/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* Represents the response containing the list of database copies for a given
* database.
*/
public class DatabaseCopyListResponse extends OperationResponse implements Iterable<DatabaseCopy> {
    private ArrayList<DatabaseCopy> databaseCopies;
    
    /**
    * Optional. Gets or sets the matching SQL Server database copies.
    * @return The DatabaseCopies value.
    */
    public ArrayList<DatabaseCopy> getDatabaseCopies() {
        return this.databaseCopies;
    }
    
    /**
    * Optional. Gets or sets the matching SQL Server database copies.
    * @param databaseCopiesValue The DatabaseCopies value.
    */
    public void setDatabaseCopies(final ArrayList<DatabaseCopy> databaseCopiesValue) {
        this.databaseCopies = databaseCopiesValue;
    }
    
    /**
    * Initializes a new instance of the DatabaseCopyListResponse class.
    *
    */
    public DatabaseCopyListResponse() {
        super();
        this.setDatabaseCopies(new LazyArrayList<DatabaseCopy>());
    }
    
    /**
    * Gets the sequence of DatabaseCopies.
    *
    */
    public Iterator<DatabaseCopy> iterator() {
        return this.getDatabaseCopies().iterator();
    }
}
