/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import java.util.Calendar;

/**
* Represents the parameters supplied to the Get Database Event Logs operation.
*/
public class DatabaseGetEventLogsParameters {
    private String eventTypes;
    
    /**
    * Required. Gets or sets the event types to retrieve.
    * @return The EventTypes value.
    */
    public String getEventTypes() {
        return this.eventTypes;
    }
    
    /**
    * Required. Gets or sets the event types to retrieve.
    * @param eventTypesValue The EventTypes value.
    */
    public void setEventTypes(final String eventTypesValue) {
        this.eventTypes = eventTypesValue;
    }
    
    private int intervalSizeInMinutes;
    
    /**
    * Required. Gets or sets the interval size in minutes.
    * @return The IntervalSizeInMinutes value.
    */
    public int getIntervalSizeInMinutes() {
        return this.intervalSizeInMinutes;
    }
    
    /**
    * Required. Gets or sets the interval size in minutes.
    * @param intervalSizeInMinutesValue The IntervalSizeInMinutes value.
    */
    public void setIntervalSizeInMinutes(final int intervalSizeInMinutesValue) {
        this.intervalSizeInMinutes = intervalSizeInMinutesValue;
    }
    
    private Calendar startDate;
    
    /**
    * Required. Gets or sets the start date for the event log.
    * @return The StartDate value.
    */
    public Calendar getStartDate() {
        return this.startDate;
    }
    
    /**
    * Required. Gets or sets the start date for the event log.
    * @param startDateValue The StartDate value.
    */
    public void setStartDate(final Calendar startDateValue) {
        this.startDate = startDateValue;
    }
    
    /**
    * Initializes a new instance of the DatabaseGetEventLogsParameters class.
    *
    */
    public DatabaseGetEventLogsParameters() {
    }
    
    /**
    * Initializes a new instance of the DatabaseGetEventLogsParameters class
    * with required arguments.
    *
    * @param startDate Gets or sets the start date for the event log.
    * @param intervalSizeInMinutes Gets or sets the interval size in minutes.
    * @param eventTypes Gets or sets the event types to retrieve.
    */
    public DatabaseGetEventLogsParameters(Calendar startDate, int intervalSizeInMinutes, String eventTypes) {
        if (eventTypes == null) {
            throw new NullPointerException("eventTypes");
        }
        this.setStartDate(startDate);
        this.setIntervalSizeInMinutes(intervalSizeInMinutes);
        this.setEventTypes(eventTypes);
    }
}
