/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* Contains the response to a Get Database Event Logs request.
*/
public class DatabaseGetEventLogsResponse extends OperationResponse implements Iterable<DatabaseEventLog> {
    private ArrayList<DatabaseEventLog> eventLogs;
    
    /**
    * Optional. Gets or sets the collection of Azure SQL Database event logs.
    * @return The EventLogs value.
    */
    public ArrayList<DatabaseEventLog> getEventLogs() {
        return this.eventLogs;
    }
    
    /**
    * Optional. Gets or sets the collection of Azure SQL Database event logs.
    * @param eventLogsValue The EventLogs value.
    */
    public void setEventLogs(final ArrayList<DatabaseEventLog> eventLogsValue) {
        this.eventLogs = eventLogsValue;
    }
    
    /**
    * Initializes a new instance of the DatabaseGetEventLogsResponse class.
    *
    */
    public DatabaseGetEventLogsResponse() {
        super();
        this.setEventLogs(new LazyArrayList<DatabaseEventLog>());
    }
    
    /**
    * Gets the sequence of EventLogs.
    *
    */
    public Iterator<DatabaseEventLog> iterator() {
        return this.getEventLogs().iterator();
    }
}
