/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import java.util.Calendar;

/**
* Contains all the information pertaining to a database operation that
* transpired.
*/
public class DatabaseOperation extends SqlModelCommon {
    private String databaseName;
    
    /**
    * Optional. Gets the name of the Azure SQL Database on which the operation
    * is performed.
    * @return The DatabaseName value.
    */
    public String getDatabaseName() {
        return this.databaseName;
    }
    
    /**
    * Optional. Gets the name of the Azure SQL Database on which the operation
    * is performed.
    * @param databaseNameValue The DatabaseName value.
    */
    public void setDatabaseName(final String databaseNameValue) {
        this.databaseName = databaseNameValue;
    }
    
    private String error;
    
    /**
    * Optional. Gets the description of the error that occurred during a failed
    * operation.
    * @return The Error value.
    */
    public String getError() {
        return this.error;
    }
    
    /**
    * Optional. Gets the description of the error that occurred during a failed
    * operation.
    * @param errorValue The Error value.
    */
    public void setError(final String errorValue) {
        this.error = errorValue;
    }
    
    private int errorCode;
    
    /**
    * Optional. Gets the code indicating the error that occurred during a
    * failed operation.
    * @return The ErrorCode value.
    */
    public int getErrorCode() {
        return this.errorCode;
    }
    
    /**
    * Optional. Gets the code indicating the error that occurred during a
    * failed operation.
    * @param errorCodeValue The ErrorCode value.
    */
    public void setErrorCode(final int errorCodeValue) {
        this.errorCode = errorCodeValue;
    }
    
    private int errorSeverity;
    
    /**
    * Optional. Gets the severity level of the error that occurred during a
    * failed operation.
    * @return The ErrorSeverity value.
    */
    public int getErrorSeverity() {
        return this.errorSeverity;
    }
    
    /**
    * Optional. Gets the severity level of the error that occurred during a
    * failed operation.
    * @param errorSeverityValue The ErrorSeverity value.
    */
    public void setErrorSeverity(final int errorSeverityValue) {
        this.errorSeverity = errorSeverityValue;
    }
    
    private int errorState;
    
    /**
    * Optional. Gets the error state of the operation.
    * @return The ErrorState value.
    */
    public int getErrorState() {
        return this.errorState;
    }
    
    /**
    * Optional. Gets the error state of the operation.
    * @param errorStateValue The ErrorState value.
    */
    public void setErrorState(final int errorStateValue) {
        this.errorState = errorStateValue;
    }
    
    private String id;
    
    /**
    * Optional. Gets a unique identifier for this database operation.
    * @return The Id value.
    */
    public String getId() {
        return this.id;
    }
    
    /**
    * Optional. Gets a unique identifier for this database operation.
    * @param idValue The Id value.
    */
    public void setId(final String idValue) {
        this.id = idValue;
    }
    
    private Calendar lastModifyTime;
    
    /**
    * Optional. Gets the timestamp when the record was last modified for a long
    * running operation.
    * @return The LastModifyTime value.
    */
    public Calendar getLastModifyTime() {
        return this.lastModifyTime;
    }
    
    /**
    * Optional. Gets the timestamp when the record was last modified for a long
    * running operation.
    * @param lastModifyTimeValue The LastModifyTime value.
    */
    public void setLastModifyTime(final Calendar lastModifyTimeValue) {
        this.lastModifyTime = lastModifyTimeValue;
    }
    
    private int percentComplete;
    
    /**
    * Optional. Gets the percentage of the operation that has completed.
    * @return The PercentComplete value.
    */
    public int getPercentComplete() {
        return this.percentComplete;
    }
    
    /**
    * Optional. Gets the percentage of the operation that has completed.
    * @param percentCompleteValue The PercentComplete value.
    */
    public void setPercentComplete(final int percentCompleteValue) {
        this.percentComplete = percentCompleteValue;
    }
    
    private String sessionActivityId;
    
    /**
    * Optional. Gets the unique Guid that identifies the session that this
    * operation occured in. This is helpful if contacting support for an issue.
    * @return The SessionActivityId value.
    */
    public String getSessionActivityId() {
        return this.sessionActivityId;
    }
    
    /**
    * Optional. Gets the unique Guid that identifies the session that this
    * operation occured in. This is helpful if contacting support for an issue.
    * @param sessionActivityIdValue The SessionActivityId value.
    */
    public void setSessionActivityId(final String sessionActivityIdValue) {
        this.sessionActivityId = sessionActivityIdValue;
    }
    
    private Calendar startTime;
    
    /**
    * Optional. Gets the timestamp when the operation started.
    * @return The StartTime value.
    */
    public Calendar getStartTime() {
        return this.startTime;
    }
    
    /**
    * Optional. Gets the timestamp when the operation started.
    * @param startTimeValue The StartTime value.
    */
    public void setStartTime(final Calendar startTimeValue) {
        this.startTime = startTimeValue;
    }
    
    private int stateId;
    
    /**
    * Optional. Gets a unique identifier for the service activity representing
    * the operation. This activity id can be provided to the service support
    * for investigating an operation.
    * @return The StateId value.
    */
    public int getStateId() {
        return this.stateId;
    }
    
    /**
    * Optional. Gets a unique identifier for the service activity representing
    * the operation. This activity id can be provided to the service support
    * for investigating an operation.
    * @param stateIdValue The StateId value.
    */
    public void setStateId(final int stateIdValue) {
        this.stateId = stateIdValue;
    }
}
