/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import java.util.Calendar;

/**
* Represents a database's usage in the Azure SQL Database service.
*/
public class DatabaseUsageMetric {
    private String currentValue;
    
    /**
    * Optional. Gets the current value of the usage.
    * @return The CurrentValue value.
    */
    public String getCurrentValue() {
        return this.currentValue;
    }
    
    /**
    * Optional. Gets the current value of the usage.
    * @param currentValueValue The CurrentValue value.
    */
    public void setCurrentValue(final String currentValueValue) {
        this.currentValue = currentValueValue;
    }
    
    private String limit;
    
    /**
    * Optional. Gets the current limit of usage.
    * @return The Limit value.
    */
    public String getLimit() {
        return this.limit;
    }
    
    /**
    * Optional. Gets the current limit of usage.
    * @param limitValue The Limit value.
    */
    public void setLimit(final String limitValue) {
        this.limit = limitValue;
    }
    
    private String name;
    
    /**
    * Optional. Gets the name of the usage.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Gets the name of the usage.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private Calendar nextResetTime;
    
    /**
    * Optional. Gets the timestamp of when the current value gets reset.
    * @return The NextResetTime value.
    */
    public Calendar getNextResetTime() {
        return this.nextResetTime;
    }
    
    /**
    * Optional. Gets the timestamp of when the current value gets reset.
    * @param nextResetTimeValue The NextResetTime value.
    */
    public void setNextResetTime(final Calendar nextResetTimeValue) {
        this.nextResetTime = nextResetTimeValue;
    }
    
    private String resourceName;
    
    /**
    * Optional. Gets the name of the resource.
    * @return The ResourceName value.
    */
    public String getResourceName() {
        return this.resourceName;
    }
    
    /**
    * Optional. Gets the name of the resource.
    * @param resourceNameValue The ResourceName value.
    */
    public void setResourceName(final String resourceNameValue) {
        this.resourceName = resourceNameValue;
    }
    
    private String unit;
    
    /**
    * Optional. Gets the units the usage is expressed in.
    * @return The Unit value.
    */
    public String getUnit() {
        return this.unit;
    }
    
    /**
    * Optional. Gets the units the usage is expressed in.
    * @param unitValue The Unit value.
    */
    public void setUnit(final String unitValue) {
        this.unit = unitValue;
    }
}
