/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import java.util.Calendar;

/**
* Represents a recoverable Azure SQL Database.
*/
public class RecoverableDatabase extends SqlModelCommon {
    private String edition;
    
    /**
    * Optional. Gets the edition of the database.
    * @return The Edition value.
    */
    public String getEdition() {
        return this.edition;
    }
    
    /**
    * Optional. Gets the edition of the database.
    * @param editionValue The Edition value.
    */
    public void setEdition(final String editionValue) {
        this.edition = editionValue;
    }
    
    private String entityId;
    
    /**
    * Optional. Gets the entity ID of the database.
    * @return The EntityId value.
    */
    public String getEntityId() {
        return this.entityId;
    }
    
    /**
    * Optional. Gets the entity ID of the database.
    * @param entityIdValue The EntityId value.
    */
    public void setEntityId(final String entityIdValue) {
        this.entityId = entityIdValue;
    }
    
    private Calendar lastAvailableBackupDate;
    
    /**
    * Optional. Gets the last available backup date for this database.
    * @return The LastAvailableBackupDate value.
    */
    public Calendar getLastAvailableBackupDate() {
        return this.lastAvailableBackupDate;
    }
    
    /**
    * Optional. Gets the last available backup date for this database.
    * @param lastAvailableBackupDateValue The LastAvailableBackupDate value.
    */
    public void setLastAvailableBackupDate(final Calendar lastAvailableBackupDateValue) {
        this.lastAvailableBackupDate = lastAvailableBackupDateValue;
    }
    
    private String serverName;
    
    /**
    * Optional. Gets the name of the Azure SQL Database Server where the
    * database resided.
    * @return The ServerName value.
    */
    public String getServerName() {
        return this.serverName;
    }
    
    /**
    * Optional. Gets the name of the Azure SQL Database Server where the
    * database resided.
    * @param serverNameValue The ServerName value.
    */
    public void setServerName(final String serverNameValue) {
        this.serverName = serverNameValue;
    }
}
