/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* Contains the response to the List Recoverable Databases request.
*/
public class RecoverableDatabaseListResponse extends OperationResponse implements Iterable<RecoverableDatabase> {
    private ArrayList<RecoverableDatabase> databases;
    
    /**
    * Optional. Gets or sets the collection of databases that were hosted on
    * the server.
    * @return The Databases value.
    */
    public ArrayList<RecoverableDatabase> getDatabases() {
        return this.databases;
    }
    
    /**
    * Optional. Gets or sets the collection of databases that were hosted on
    * the server.
    * @param databasesValue The Databases value.
    */
    public void setDatabases(final ArrayList<RecoverableDatabase> databasesValue) {
        this.databases = databasesValue;
    }
    
    /**
    * Initializes a new instance of the RecoverableDatabaseListResponse class.
    *
    */
    public RecoverableDatabaseListResponse() {
        super();
        this.setDatabases(new LazyArrayList<RecoverableDatabase>());
    }
    
    /**
    * Gets the sequence of Databases.
    *
    */
    public Iterator<RecoverableDatabase> iterator() {
        return this.getDatabases().iterator();
    }
}
