/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import com.microsoft.windowsazure.core.OperationResponse;

/**
* The response returned from the Create Server operation.  This contains all
* the information returned from the service when a server is created.
*/
public class ServerCreateResponse extends OperationResponse {
    private String fullyQualifiedDomainName;
    
    /**
    * Optional. Gets the fully qualified domain name of the server.
    * @return The FullyQualifiedDomainName value.
    */
    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }
    
    /**
    * Optional. Gets the fully qualified domain name of the server.
    * @param fullyQualifiedDomainNameValue The FullyQualifiedDomainName value.
    */
    public void setFullyQualifiedDomainName(final String fullyQualifiedDomainNameValue) {
        this.fullyQualifiedDomainName = fullyQualifiedDomainNameValue;
    }
    
    private String serverName;
    
    /**
    * Optional. Gets the name of the Azure SQL Database Server that was
    * provisioned.
    * @return The ServerName value.
    */
    public String getServerName() {
        return this.serverName;
    }
    
    /**
    * Optional. Gets the name of the Azure SQL Database Server that was
    * provisioned.
    * @param serverNameValue The ServerName value.
    */
    public void setServerName(final String serverNameValue) {
        this.serverName = serverNameValue;
    }
}
