/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* Response containing the list of service objective for a given server.  This
* is returnedfrom a call to List Service Objectives.
*/
public class ServiceObjectiveListResponse extends OperationResponse implements Iterable<ServiceObjective> {
    private ArrayList<ServiceObjective> serviceObjectives;
    
    /**
    * Optional. Gets or sets list of all of the Service Objectives that exist
    * in an Azure SQL Database Server.
    * @return The ServiceObjectives value.
    */
    public ArrayList<ServiceObjective> getServiceObjectives() {
        return this.serviceObjectives;
    }
    
    /**
    * Optional. Gets or sets list of all of the Service Objectives that exist
    * in an Azure SQL Database Server.
    * @param serviceObjectivesValue The ServiceObjectives value.
    */
    public void setServiceObjectives(final ArrayList<ServiceObjective> serviceObjectivesValue) {
        this.serviceObjectives = serviceObjectivesValue;
    }
    
    /**
    * Initializes a new instance of the ServiceObjectiveListResponse class.
    *
    */
    public ServiceObjectiveListResponse() {
        super();
        this.setServiceObjectives(new LazyArrayList<ServiceObjective>());
    }
    
    /**
    * Gets the sequence of ServiceObjectives.
    *
    */
    public Iterator<ServiceObjective> iterator() {
        return this.getServiceObjectives().iterator();
    }
}
