/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.sql.models;

import java.net.URI;
import java.util.Calendar;

/**
* Describes the status of an import or export operation.
*/
public class StatusInfo {
    private URI blobUri;
    
    /**
    * Optional. Gets the URI of the DACPAC file being used that is stored in
    * Azure Blob Storage.  For import this is the DACPAC that is being
    * imported.  For export this is the destination for the resultant DACPAC
    * file.
    * @return The BlobUri value.
    */
    public URI getBlobUri() {
        return this.blobUri;
    }
    
    /**
    * Optional. Gets the URI of the DACPAC file being used that is stored in
    * Azure Blob Storage.  For import this is the DACPAC that is being
    * imported.  For export this is the destination for the resultant DACPAC
    * file.
    * @param blobUriValue The BlobUri value.
    */
    public void setBlobUri(final URI blobUriValue) {
        this.blobUri = blobUriValue;
    }
    
    private String databaseName;
    
    /**
    * Optional. Gets the name of the database that is being used.  For import
    * this is the name of the newly created database that is being imported
    * into.  For export this is the name of the database being exported.
    * @return The DatabaseName value.
    */
    public String getDatabaseName() {
        return this.databaseName;
    }
    
    /**
    * Optional. Gets the name of the database that is being used.  For import
    * this is the name of the newly created database that is being imported
    * into.  For export this is the name of the database being exported.
    * @param databaseNameValue The DatabaseName value.
    */
    public void setDatabaseName(final String databaseNameValue) {
        this.databaseName = databaseNameValue;
    }
    
    private String errorMessage;
    
    /**
    * Optional. Gets the error message of the request if the request failed in
    * some way.
    * @return The ErrorMessage value.
    */
    public String getErrorMessage() {
        return this.errorMessage;
    }
    
    /**
    * Optional. Gets the error message of the request if the request failed in
    * some way.
    * @param errorMessageValue The ErrorMessage value.
    */
    public void setErrorMessage(final String errorMessageValue) {
        this.errorMessage = errorMessageValue;
    }
    
    private Calendar lastModifiedTime;
    
    /**
    * Optional. Gets the last time the operation status changed.
    * @return The LastModifiedTime value.
    */
    public Calendar getLastModifiedTime() {
        return this.lastModifiedTime;
    }
    
    /**
    * Optional. Gets the last time the operation status changed.
    * @param lastModifiedTimeValue The LastModifiedTime value.
    */
    public void setLastModifiedTime(final Calendar lastModifiedTimeValue) {
        this.lastModifiedTime = lastModifiedTimeValue;
    }
    
    private Calendar queuedTime;
    
    /**
    * Optional. Gets the time at which the import or export request was queued
    * and the process initiated.
    * @return The QueuedTime value.
    */
    public Calendar getQueuedTime() {
        return this.queuedTime;
    }
    
    /**
    * Optional. Gets the time at which the import or export request was queued
    * and the process initiated.
    * @param queuedTimeValue The QueuedTime value.
    */
    public void setQueuedTime(final Calendar queuedTimeValue) {
        this.queuedTime = queuedTimeValue;
    }
    
    private String requestId;
    
    /**
    * Optional. Gets the request ID of this import or export request.  This can
    * be used to continue to track this operation using GetStatus.
    * @return The RequestId value.
    */
    public String getRequestId() {
        return this.requestId;
    }
    
    /**
    * Optional. Gets the request ID of this import or export request.  This can
    * be used to continue to track this operation using GetStatus.
    * @param requestIdValue The RequestId value.
    */
    public void setRequestId(final String requestIdValue) {
        this.requestId = requestIdValue;
    }
    
    private String requestType;
    
    /**
    * Optional. Gets the type of the operation.  This can be either: Import or
    * Export.
    * @return The RequestType value.
    */
    public String getRequestType() {
        return this.requestType;
    }
    
    /**
    * Optional. Gets the type of the operation.  This can be either: Import or
    * Export.
    * @param requestTypeValue The RequestType value.
    */
    public void setRequestType(final String requestTypeValue) {
        this.requestType = requestTypeValue;
    }
    
    private String serverName;
    
    /**
    * Optional. Gets the name of the SQL Database server holding the database
    * that the import or export operation is utilizing.
    * @return The ServerName value.
    */
    public String getServerName() {
        return this.serverName;
    }
    
    /**
    * Optional. Gets the name of the SQL Database server holding the database
    * that the import or export operation is utilizing.
    * @param serverNameValue The ServerName value.
    */
    public void setServerName(final String serverNameValue) {
        this.serverName = serverNameValue;
    }
    
    private String status;
    
    /**
    * Optional. Gets the status of the import or export request.
    * @return The Status value.
    */
    public String getStatus() {
        return this.status;
    }
    
    /**
    * Optional. Gets the status of the import or export request.
    * @param statusValue The Status value.
    */
    public void setStatus(final String statusValue) {
        this.status = statusValue;
    }
}
