/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.storage;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.CloudError;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.storage.models.CheckNameAvailabilityResponse;
import com.microsoft.windowsazure.management.storage.models.GeoRegionStatus;
import com.microsoft.windowsazure.management.storage.models.StorageAccount;
import com.microsoft.windowsazure.management.storage.models.StorageAccountCreateParameters;
import com.microsoft.windowsazure.management.storage.models.StorageAccountGetKeysResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountGetResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountListResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountProperties;
import com.microsoft.windowsazure.management.storage.models.StorageAccountRegenerateKeysParameters;
import com.microsoft.windowsazure.management.storage.models.StorageAccountRegenerateKeysResponse;
import com.microsoft.windowsazure.management.storage.models.StorageAccountStatus;
import com.microsoft.windowsazure.management.storage.models.StorageAccountUpdateParameters;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* The Service Management API includes operations for managing the storage
* accounts beneath your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/ee460790.aspx for more
* information)
*/
public class StorageAccountOperationsImpl implements ServiceOperations<StorageManagementClientImpl>, StorageAccountOperations {
    /**
    * Initializes a new instance of the StorageAccountOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    StorageAccountOperationsImpl(StorageManagementClientImpl client) {
        this.client = client;
    }
    
    private StorageManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.storage.StorageManagementClientImpl.
    * @return The Client value.
    */
    public StorageManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Begin Creating Storage Account operation creates a new storage
    * account in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh264518.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Storage Account operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginCreatingAsync(final StorageAccountCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginCreating(parameters);
            }
         });
    }
    
    /**
    * The Begin Creating Storage Account operation creates a new storage
    * account in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh264518.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Storage Account operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginCreating(StorageAccountCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() != null && parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getName().length() < 3) {
            throw new IllegalArgumentException("parameters.Name");
        }
        if (parameters.getName().length() > 24) {
            throw new IllegalArgumentException("parameters.Name");
        }
        for (char nameChar : parameters.getName().toCharArray()) {
            if (Character.isLowerCase(nameChar) == false && Character.isDigit(nameChar) == false) {
                throw new IllegalArgumentException("parameters.Name");
            }
        }
        // TODO: Validate parameters.Name is a valid DNS name.
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/storageservices";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element createStorageServiceInputElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CreateStorageServiceInput");
        requestDoc.appendChild(createStorageServiceInputElement);
        
        Element serviceNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ServiceName");
        serviceNameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        createStorageServiceInputElement.appendChild(serviceNameElement);
        
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            createStorageServiceInputElement.appendChild(descriptionElement);
        } else {
            Element emptyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            Attr nilAttribute = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
            nilAttribute.setValue("true");
            emptyElement.setAttributeNode(nilAttribute);
            createStorageServiceInputElement.appendChild(emptyElement);
        }
        
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getLabel().getBytes())));
        createStorageServiceInputElement.appendChild(labelElement);
        
        if (parameters.getAffinityGroup() != null) {
            Element affinityGroupElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AffinityGroup");
            affinityGroupElement.appendChild(requestDoc.createTextNode(parameters.getAffinityGroup()));
            createStorageServiceInputElement.appendChild(affinityGroupElement);
        }
        
        if (parameters.getLocation() != null) {
            Element locationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Location");
            locationElement.appendChild(requestDoc.createTextNode(parameters.getLocation()));
            createStorageServiceInputElement.appendChild(locationElement);
        }
        
        if (parameters.getExtendedProperties() != null) {
            if (parameters.getExtendedProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtendedProperties()).isInitialized()) {
                Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                    String extendedPropertiesKey = entry.getKey();
                    String extendedPropertiesValue = entry.getValue();
                    Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                    extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                    
                    Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                    extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                    
                    Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                    extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                    extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
                }
                createStorageServiceInputElement.appendChild(extendedPropertiesDictionaryElement);
            }
        }
        
        if (parameters.getAccountType() != null) {
            Element accountTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AccountType");
            accountTypeElement.appendChild(requestDoc.createTextNode(parameters.getAccountType()));
            createStorageServiceInputElement.appendChild(accountTypeElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Check Name Availability operation checks if a storage account name is
    * available for use in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154125.aspx for
    * more information)
    *
    * @param accountName Required. The desired storage account name to check
    * for availability.
    * @return The response to a storage account check name availability request.
    */
    @Override
    public Future<CheckNameAvailabilityResponse> checkNameAvailabilityAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<CheckNameAvailabilityResponse>() { 
            @Override
            public CheckNameAvailabilityResponse call() throws Exception {
                return checkNameAvailability(accountName);
            }
         });
    }
    
    /**
    * The Check Name Availability operation checks if a storage account name is
    * available for use in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154125.aspx for
    * more information)
    *
    * @param accountName Required. The desired storage account name to check
    * for availability.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response to a storage account check name availability request.
    */
    @Override
    public CheckNameAvailabilityResponse checkNameAvailability(String accountName) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter(invocationId, this, "checkNameAvailabilityAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/storageservices/operations/isavailable/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            CheckNameAvailabilityResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new CheckNameAvailabilityResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element availabilityResponseElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "AvailabilityResponse");
                if (availabilityResponseElement != null) {
                    Element resultElement = XmlUtility.getElementByTagNameNS(availabilityResponseElement, "http://schemas.microsoft.com/windowsazure", "Result");
                    if (resultElement != null) {
                        boolean resultInstance;
                        resultInstance = DatatypeConverter.parseBoolean(resultElement.getTextContent().toLowerCase());
                        result.setIsAvailable(resultInstance);
                    }
                    
                    Element reasonElement = XmlUtility.getElementByTagNameNS(availabilityResponseElement, "http://schemas.microsoft.com/windowsazure", "Reason");
                    if (reasonElement != null) {
                        boolean isNil = false;
                        Attr nilAttribute = reasonElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                        if (nilAttribute != null) {
                            isNil = "true".equals(nilAttribute.getValue());
                        }
                        if (isNil == false) {
                            String reasonInstance;
                            reasonInstance = reasonElement.getTextContent();
                            result.setReason(reasonInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Create Storage Account operation creates a new storage account in
    * Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh264518.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Create Storage
    * Account operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> createAsync(final StorageAccountCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return create(parameters);
            }
         });
    }
    
    /**
    * The Create Storage Account operation creates a new storage account in
    * Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh264518.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Create Storage
    * Account operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse create(StorageAccountCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        StorageManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getStorageAccountsOperations().beginCreatingAsync(parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setError(new CloudError());
                    ex.getError().setCode(result.getError().getCode());
                    ex.getError().setMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete Storage Account operation deletes the specified storage
    * account from Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh264517.aspx for
    * more information)
    *
    * @param accountName Required. The name of the storage account to be
    * deleted.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(accountName);
            }
         });
    }
    
    /**
    * The Delete Storage Account operation deletes the specified storage
    * account from Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh264517.aspx for
    * more information)
    *
    * @param accountName Required. The name of the storage account to be
    * deleted.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String accountName) throws IOException, ServiceException {
        // Validate
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/storageservices/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Storage Account Properties operation returns system properties
    * for the specified storage account.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460802.aspx for
    * more information)
    *
    * @param accountName Required. Name of the storage account to get
    * properties for.
    * @return The Get Storage Account Properties operation response.
    */
    @Override
    public Future<StorageAccountGetResponse> getAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountGetResponse>() { 
            @Override
            public StorageAccountGetResponse call() throws Exception {
                return get(accountName);
            }
         });
    }
    
    /**
    * The Get Storage Account Properties operation returns system properties
    * for the specified storage account.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460802.aspx for
    * more information)
    *
    * @param accountName Required. Name of the storage account to get
    * properties for.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Storage Account Properties operation response.
    */
    @Override
    public StorageAccountGetResponse get(String accountName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/storageservices/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            StorageAccountGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element storageServiceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "StorageService");
                if (storageServiceElement != null) {
                    StorageAccount storageServiceInstance = new StorageAccount();
                    result.setStorageAccount(storageServiceInstance);
                    
                    Element urlElement = XmlUtility.getElementByTagNameNS(storageServiceElement, "http://schemas.microsoft.com/windowsazure", "Url");
                    if (urlElement != null) {
                        URI urlInstance;
                        urlInstance = new URI(urlElement.getTextContent());
                        storageServiceInstance.setUri(urlInstance);
                    }
                    
                    Element serviceNameElement = XmlUtility.getElementByTagNameNS(storageServiceElement, "http://schemas.microsoft.com/windowsazure", "ServiceName");
                    if (serviceNameElement != null) {
                        String serviceNameInstance;
                        serviceNameInstance = serviceNameElement.getTextContent();
                        storageServiceInstance.setName(serviceNameInstance);
                    }
                    
                    Element storageServicePropertiesElement = XmlUtility.getElementByTagNameNS(storageServiceElement, "http://schemas.microsoft.com/windowsazure", "StorageServiceProperties");
                    if (storageServicePropertiesElement != null) {
                        StorageAccountProperties storageServicePropertiesInstance = new StorageAccountProperties();
                        storageServiceInstance.setProperties(storageServicePropertiesInstance);
                        
                        Element descriptionElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Description");
                        if (descriptionElement != null) {
                            boolean isNil = false;
                            Attr nilAttribute = descriptionElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                            if (nilAttribute != null) {
                                isNil = "true".equals(nilAttribute.getValue());
                            }
                            if (isNil == false) {
                                String descriptionInstance;
                                descriptionInstance = descriptionElement.getTextContent();
                                storageServicePropertiesInstance.setDescription(descriptionInstance);
                            }
                        }
                        
                        Element affinityGroupElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "AffinityGroup");
                        if (affinityGroupElement != null) {
                            String affinityGroupInstance;
                            affinityGroupInstance = affinityGroupElement.getTextContent();
                            storageServicePropertiesInstance.setAffinityGroup(affinityGroupInstance);
                        }
                        
                        Element locationElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Location");
                        if (locationElement != null) {
                            String locationInstance;
                            locationInstance = locationElement.getTextContent();
                            storageServicePropertiesInstance.setLocation(locationInstance);
                        }
                        
                        Element labelElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Label");
                        if (labelElement != null) {
                            String labelInstance;
                            labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode(labelElement.getTextContent())) : null;
                            storageServicePropertiesInstance.setLabel(labelInstance);
                        }
                        
                        Element statusElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Status");
                        if (statusElement != null && statusElement.getTextContent() != null && !statusElement.getTextContent().isEmpty()) {
                            StorageAccountStatus statusInstance;
                            statusInstance = StorageAccountStatus.valueOf(statusElement.getTextContent());
                            storageServicePropertiesInstance.setStatus(statusInstance);
                        }
                        
                        Element endpointsSequenceElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Endpoints");
                        if (endpointsSequenceElement != null) {
                            for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(endpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Endpoint").size(); i1 = i1 + 1) {
                                org.w3c.dom.Element endpointsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(endpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Endpoint").get(i1));
                                storageServicePropertiesInstance.getEndpoints().add(new URI(endpointsElement.getTextContent()));
                            }
                        }
                        
                        Element geoPrimaryRegionElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "GeoPrimaryRegion");
                        if (geoPrimaryRegionElement != null) {
                            String geoPrimaryRegionInstance;
                            geoPrimaryRegionInstance = geoPrimaryRegionElement.getTextContent();
                            storageServicePropertiesInstance.setGeoPrimaryRegion(geoPrimaryRegionInstance);
                        }
                        
                        Element statusOfPrimaryElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "StatusOfPrimary");
                        if (statusOfPrimaryElement != null && statusOfPrimaryElement.getTextContent() != null && !statusOfPrimaryElement.getTextContent().isEmpty()) {
                            GeoRegionStatus statusOfPrimaryInstance;
                            statusOfPrimaryInstance = GeoRegionStatus.valueOf(statusOfPrimaryElement.getTextContent());
                            storageServicePropertiesInstance.setStatusOfGeoPrimaryRegion(statusOfPrimaryInstance);
                        }
                        
                        Element lastGeoFailoverTimeElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "LastGeoFailoverTime");
                        if (lastGeoFailoverTimeElement != null && lastGeoFailoverTimeElement.getTextContent() != null && !lastGeoFailoverTimeElement.getTextContent().isEmpty()) {
                            Calendar lastGeoFailoverTimeInstance;
                            lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime(lastGeoFailoverTimeElement.getTextContent());
                            storageServicePropertiesInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                        }
                        
                        Element geoSecondaryRegionElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "GeoSecondaryRegion");
                        if (geoSecondaryRegionElement != null) {
                            String geoSecondaryRegionInstance;
                            geoSecondaryRegionInstance = geoSecondaryRegionElement.getTextContent();
                            storageServicePropertiesInstance.setGeoSecondaryRegion(geoSecondaryRegionInstance);
                        }
                        
                        Element statusOfSecondaryElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "StatusOfSecondary");
                        if (statusOfSecondaryElement != null && statusOfSecondaryElement.getTextContent() != null && !statusOfSecondaryElement.getTextContent().isEmpty()) {
                            GeoRegionStatus statusOfSecondaryInstance;
                            statusOfSecondaryInstance = GeoRegionStatus.valueOf(statusOfSecondaryElement.getTextContent());
                            storageServicePropertiesInstance.setStatusOfGeoSecondaryRegion(statusOfSecondaryInstance);
                        }
                        
                        Element accountTypeElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "AccountType");
                        if (accountTypeElement != null) {
                            String accountTypeInstance;
                            accountTypeInstance = accountTypeElement.getTextContent();
                            storageServicePropertiesInstance.setAccountType(accountTypeInstance);
                        }
                    }
                    
                    Element extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS(storageServiceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                    if (extendedPropertiesSequenceElement != null) {
                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extendedPropertiesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperty").size(); i2 = i2 + 1) {
                            org.w3c.dom.Element extendedPropertiesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extendedPropertiesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperty").get(i2));
                            String extendedPropertiesKey = XmlUtility.getElementByTagNameNS(extendedPropertiesElement, "http://schemas.microsoft.com/windowsazure", "Name").getTextContent();
                            String extendedPropertiesValue = XmlUtility.getElementByTagNameNS(extendedPropertiesElement, "http://schemas.microsoft.com/windowsazure", "Value").getTextContent();
                            storageServiceInstance.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Storage Keys operation returns the primary and secondary access
    * keys for the specified storage account.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460785.aspx for
    * more information)
    *
    * @param accountName Required. The name of the desired storage account.
    * @return The primary and secondary access keys for a storage account.
    */
    @Override
    public Future<StorageAccountGetKeysResponse> getKeysAsync(final String accountName) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountGetKeysResponse>() { 
            @Override
            public StorageAccountGetKeysResponse call() throws Exception {
                return getKeys(accountName);
            }
         });
    }
    
    /**
    * The Get Storage Keys operation returns the primary and secondary access
    * keys for the specified storage account.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460785.aspx for
    * more information)
    *
    * @param accountName Required. The name of the desired storage account.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The primary and secondary access keys for a storage account.
    */
    @Override
    public StorageAccountGetKeysResponse getKeys(String accountName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("accountName", accountName);
            CloudTracing.enter(invocationId, this, "getKeysAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/storageservices/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        url = url + "/keys";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            StorageAccountGetKeysResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountGetKeysResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element storageServiceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "StorageService");
                if (storageServiceElement != null) {
                    Element urlElement = XmlUtility.getElementByTagNameNS(storageServiceElement, "http://schemas.microsoft.com/windowsazure", "Url");
                    if (urlElement != null) {
                        URI urlInstance;
                        urlInstance = new URI(urlElement.getTextContent());
                        result.setUri(urlInstance);
                    }
                    
                    Element storageServiceKeysElement = XmlUtility.getElementByTagNameNS(storageServiceElement, "http://schemas.microsoft.com/windowsazure", "StorageServiceKeys");
                    if (storageServiceKeysElement != null) {
                        Element primaryElement = XmlUtility.getElementByTagNameNS(storageServiceKeysElement, "http://schemas.microsoft.com/windowsazure", "Primary");
                        if (primaryElement != null) {
                            String primaryInstance;
                            primaryInstance = primaryElement.getTextContent();
                            result.setPrimaryKey(primaryInstance);
                        }
                        
                        Element secondaryElement = XmlUtility.getElementByTagNameNS(storageServiceKeysElement, "http://schemas.microsoft.com/windowsazure", "Secondary");
                        if (secondaryElement != null) {
                            String secondaryInstance;
                            secondaryInstance = secondaryElement.getTextContent();
                            result.setSecondaryKey(secondaryInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List Storage Accounts operation lists the storage accounts available
    * under the current subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460787.aspx for
    * more information)
    *
    * @return The List Storage Accounts operation response.
    */
    @Override
    public Future<StorageAccountListResponse> listAsync() {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountListResponse>() { 
            @Override
            public StorageAccountListResponse call() throws Exception {
                return list();
            }
         });
    }
    
    /**
    * The List Storage Accounts operation lists the storage accounts available
    * under the current subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460787.aspx for
    * more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Storage Accounts operation response.
    */
    @Override
    public StorageAccountListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/storageservices";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            StorageAccountListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountListResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element storageServicesSequenceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "StorageServices");
                if (storageServicesSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(storageServicesSequenceElement, "http://schemas.microsoft.com/windowsazure", "StorageService").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element storageServicesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(storageServicesSequenceElement, "http://schemas.microsoft.com/windowsazure", "StorageService").get(i1));
                        StorageAccount storageServiceInstance = new StorageAccount();
                        result.getStorageAccounts().add(storageServiceInstance);
                        
                        Element urlElement = XmlUtility.getElementByTagNameNS(storageServicesElement, "http://schemas.microsoft.com/windowsazure", "Url");
                        if (urlElement != null) {
                            URI urlInstance;
                            urlInstance = new URI(urlElement.getTextContent());
                            storageServiceInstance.setUri(urlInstance);
                        }
                        
                        Element serviceNameElement = XmlUtility.getElementByTagNameNS(storageServicesElement, "http://schemas.microsoft.com/windowsazure", "ServiceName");
                        if (serviceNameElement != null) {
                            String serviceNameInstance;
                            serviceNameInstance = serviceNameElement.getTextContent();
                            storageServiceInstance.setName(serviceNameInstance);
                        }
                        
                        Element storageServicePropertiesElement = XmlUtility.getElementByTagNameNS(storageServicesElement, "http://schemas.microsoft.com/windowsazure", "StorageServiceProperties");
                        if (storageServicePropertiesElement != null) {
                            StorageAccountProperties storageServicePropertiesInstance = new StorageAccountProperties();
                            storageServiceInstance.setProperties(storageServicePropertiesInstance);
                            
                            Element descriptionElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Description");
                            if (descriptionElement != null) {
                                boolean isNil = false;
                                Attr nilAttribute = descriptionElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                                if (nilAttribute != null) {
                                    isNil = "true".equals(nilAttribute.getValue());
                                }
                                if (isNil == false) {
                                    String descriptionInstance;
                                    descriptionInstance = descriptionElement.getTextContent();
                                    storageServicePropertiesInstance.setDescription(descriptionInstance);
                                }
                            }
                            
                            Element affinityGroupElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "AffinityGroup");
                            if (affinityGroupElement != null) {
                                String affinityGroupInstance;
                                affinityGroupInstance = affinityGroupElement.getTextContent();
                                storageServicePropertiesInstance.setAffinityGroup(affinityGroupInstance);
                            }
                            
                            Element locationElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Location");
                            if (locationElement != null) {
                                String locationInstance;
                                locationInstance = locationElement.getTextContent();
                                storageServicePropertiesInstance.setLocation(locationInstance);
                            }
                            
                            Element labelElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Label");
                            if (labelElement != null) {
                                String labelInstance;
                                labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode(labelElement.getTextContent())) : null;
                                storageServicePropertiesInstance.setLabel(labelInstance);
                            }
                            
                            Element statusElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Status");
                            if (statusElement != null && statusElement.getTextContent() != null && !statusElement.getTextContent().isEmpty()) {
                                StorageAccountStatus statusInstance;
                                statusInstance = StorageAccountStatus.valueOf(statusElement.getTextContent());
                                storageServicePropertiesInstance.setStatus(statusInstance);
                            }
                            
                            Element endpointsSequenceElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "Endpoints");
                            if (endpointsSequenceElement != null) {
                                for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(endpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Endpoint").size(); i2 = i2 + 1) {
                                    org.w3c.dom.Element endpointsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(endpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Endpoint").get(i2));
                                    storageServicePropertiesInstance.getEndpoints().add(new URI(endpointsElement.getTextContent()));
                                }
                            }
                            
                            Element geoPrimaryRegionElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "GeoPrimaryRegion");
                            if (geoPrimaryRegionElement != null) {
                                String geoPrimaryRegionInstance;
                                geoPrimaryRegionInstance = geoPrimaryRegionElement.getTextContent();
                                storageServicePropertiesInstance.setGeoPrimaryRegion(geoPrimaryRegionInstance);
                            }
                            
                            Element statusOfPrimaryElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "StatusOfPrimary");
                            if (statusOfPrimaryElement != null && statusOfPrimaryElement.getTextContent() != null && !statusOfPrimaryElement.getTextContent().isEmpty()) {
                                GeoRegionStatus statusOfPrimaryInstance;
                                statusOfPrimaryInstance = GeoRegionStatus.valueOf(statusOfPrimaryElement.getTextContent());
                                storageServicePropertiesInstance.setStatusOfGeoPrimaryRegion(statusOfPrimaryInstance);
                            }
                            
                            Element lastGeoFailoverTimeElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "LastGeoFailoverTime");
                            if (lastGeoFailoverTimeElement != null && lastGeoFailoverTimeElement.getTextContent() != null && !lastGeoFailoverTimeElement.getTextContent().isEmpty()) {
                                Calendar lastGeoFailoverTimeInstance;
                                lastGeoFailoverTimeInstance = DatatypeConverter.parseDateTime(lastGeoFailoverTimeElement.getTextContent());
                                storageServicePropertiesInstance.setLastGeoFailoverTime(lastGeoFailoverTimeInstance);
                            }
                            
                            Element geoSecondaryRegionElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "GeoSecondaryRegion");
                            if (geoSecondaryRegionElement != null) {
                                String geoSecondaryRegionInstance;
                                geoSecondaryRegionInstance = geoSecondaryRegionElement.getTextContent();
                                storageServicePropertiesInstance.setGeoSecondaryRegion(geoSecondaryRegionInstance);
                            }
                            
                            Element statusOfSecondaryElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "StatusOfSecondary");
                            if (statusOfSecondaryElement != null && statusOfSecondaryElement.getTextContent() != null && !statusOfSecondaryElement.getTextContent().isEmpty()) {
                                GeoRegionStatus statusOfSecondaryInstance;
                                statusOfSecondaryInstance = GeoRegionStatus.valueOf(statusOfSecondaryElement.getTextContent());
                                storageServicePropertiesInstance.setStatusOfGeoSecondaryRegion(statusOfSecondaryInstance);
                            }
                            
                            Element accountTypeElement = XmlUtility.getElementByTagNameNS(storageServicePropertiesElement, "http://schemas.microsoft.com/windowsazure", "AccountType");
                            if (accountTypeElement != null) {
                                String accountTypeInstance;
                                accountTypeInstance = accountTypeElement.getTextContent();
                                storageServicePropertiesInstance.setAccountType(accountTypeInstance);
                            }
                        }
                        
                        Element extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS(storageServicesElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                        if (extendedPropertiesSequenceElement != null) {
                            for (int i3 = 0; i3 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extendedPropertiesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperty").size(); i3 = i3 + 1) {
                                org.w3c.dom.Element extendedPropertiesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extendedPropertiesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperty").get(i3));
                                String extendedPropertiesKey = XmlUtility.getElementByTagNameNS(extendedPropertiesElement, "http://schemas.microsoft.com/windowsazure", "Name").getTextContent();
                                String extendedPropertiesValue = XmlUtility.getElementByTagNameNS(extendedPropertiesElement, "http://schemas.microsoft.com/windowsazure", "Value").getTextContent();
                                storageServiceInstance.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Regenerate Keys operation regenerates the primary or secondary access
    * key for the specified storage account.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460795.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Regenerate Keys
    * operation.
    * @return The primary and secondary access keys for a storage account.
    */
    @Override
    public Future<StorageAccountRegenerateKeysResponse> regenerateKeysAsync(final StorageAccountRegenerateKeysParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<StorageAccountRegenerateKeysResponse>() { 
            @Override
            public StorageAccountRegenerateKeysResponse call() throws Exception {
                return regenerateKeys(parameters);
            }
         });
    }
    
    /**
    * The Regenerate Keys operation regenerates the primary or secondary access
    * key for the specified storage account.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460795.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the Regenerate Keys
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The primary and secondary access keys for a storage account.
    */
    @Override
    public StorageAccountRegenerateKeysResponse regenerateKeys(StorageAccountRegenerateKeysParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getKeyType() == null) {
            throw new NullPointerException("parameters.KeyType");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "regenerateKeysAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/storageservices/";
        url = url + URLEncoder.encode(parameters.getName(), "UTF-8");
        url = url + "/keys";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("action=regenerate");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element regenerateKeysElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RegenerateKeys");
        requestDoc.appendChild(regenerateKeysElement);
        
        Element keyTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "KeyType");
        keyTypeElement.appendChild(requestDoc.createTextNode(parameters.getKeyType().toString()));
        regenerateKeysElement.appendChild(keyTypeElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            StorageAccountRegenerateKeysResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new StorageAccountRegenerateKeysResponse();
                DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
                documentBuilderFactory2.setNamespaceAware(true);
                DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
                Document responseDoc = documentBuilder2.parse(new BOMInputStream(responseContent));
                
                Element storageServiceElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "StorageService");
                if (storageServiceElement != null) {
                    Element urlElement = XmlUtility.getElementByTagNameNS(storageServiceElement, "http://schemas.microsoft.com/windowsazure", "Url");
                    if (urlElement != null) {
                        URI urlInstance;
                        urlInstance = new URI(urlElement.getTextContent());
                        result.setUri(urlInstance);
                    }
                    
                    Element storageServiceKeysElement = XmlUtility.getElementByTagNameNS(storageServiceElement, "http://schemas.microsoft.com/windowsazure", "StorageServiceKeys");
                    if (storageServiceKeysElement != null) {
                        Element primaryElement = XmlUtility.getElementByTagNameNS(storageServiceKeysElement, "http://schemas.microsoft.com/windowsazure", "Primary");
                        if (primaryElement != null) {
                            String primaryInstance;
                            primaryInstance = primaryElement.getTextContent();
                            result.setPrimaryKey(primaryInstance);
                        }
                        
                        Element secondaryElement = XmlUtility.getElementByTagNameNS(storageServiceKeysElement, "http://schemas.microsoft.com/windowsazure", "Secondary");
                        if (secondaryElement != null) {
                            String secondaryInstance;
                            secondaryInstance = secondaryElement.getTextContent();
                            result.setSecondaryKey(secondaryInstance);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Update Storage Account operation updates the label and the
    * description, and enables or disables the geo-replication status for a
    * storage account in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh264516.aspx for
    * more information)
    *
    * @param accountName Required. Name of the storage account to update.
    * @param parameters Required. Parameters supplied to the Update Storage
    * Account operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> updateAsync(final String accountName, final StorageAccountUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return update(accountName, parameters);
            }
         });
    }
    
    /**
    * The Update Storage Account operation updates the label and the
    * description, and enables or disables the geo-replication status for a
    * storage account in Azure.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh264516.aspx for
    * more information)
    *
    * @param accountName Required. Name of the storage account to update.
    * @param parameters Required. Parameters supplied to the Update Storage
    * Account operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse update(String accountName, StorageAccountUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (accountName == null) {
            throw new NullPointerException("accountName");
        }
        if (accountName.length() < 3) {
            throw new IllegalArgumentException("accountName");
        }
        if (accountName.length() > 24) {
            throw new IllegalArgumentException("accountName");
        }
        for (char accountNameChar : accountName.toCharArray()) {
            if (Character.isLowerCase(accountNameChar) == false && Character.isDigit(accountNameChar) == false) {
                throw new IllegalArgumentException("accountName");
            }
        }
        // TODO: Validate accountName is a valid DNS name.
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDescription() != null && parameters.getDescription().length() > 1024) {
            throw new IllegalArgumentException("parameters.Description");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("accountName", accountName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/storageservices/";
        url = url + URLEncoder.encode(accountName, "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element updateStorageServiceInputElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateStorageServiceInput");
        requestDoc.appendChild(updateStorageServiceInputElement);
        
        if (parameters.getDescription() != null) {
            Element descriptionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            descriptionElement.appendChild(requestDoc.createTextNode(parameters.getDescription()));
            updateStorageServiceInputElement.appendChild(descriptionElement);
        } else {
            Element emptyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Description");
            Attr nilAttribute = requestDoc.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
            nilAttribute.setValue("true");
            emptyElement.setAttributeNode(nilAttribute);
            updateStorageServiceInputElement.appendChild(emptyElement);
        }
        
        if (parameters.getLabel() != null) {
            Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
            labelElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getLabel().getBytes())));
            updateStorageServiceInputElement.appendChild(labelElement);
        }
        
        if (parameters.getExtendedProperties() != null) {
            if (parameters.getExtendedProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtendedProperties()).isInitialized()) {
                Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                    String extendedPropertiesKey = entry.getKey();
                    String extendedPropertiesValue = entry.getValue();
                    Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                    extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                    
                    Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                    extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                    
                    Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                    extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                    extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
                }
                updateStorageServiceInputElement.appendChild(extendedPropertiesDictionaryElement);
            }
        }
        
        if (parameters.getAccountType() != null) {
            Element accountTypeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AccountType");
            accountTypeElement.appendChild(requestDoc.createTextNode(parameters.getAccountType()));
            updateStorageServiceInputElement.appendChild(accountTypeElement);
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
