/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import com.microsoft.windowsazure.management.websites.models.ConnectionStringType;
import com.microsoft.windowsazure.management.websites.models.ManagedPipelineMode;
import com.microsoft.windowsazure.management.websites.models.WebSiteOperationStatus;
import com.microsoft.windowsazure.management.websites.models.WebSiteOperationStatusResponse;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.client.HttpClientBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
* The Web Sites Management API provides a RESTful set of web services that
* interact with the Windows Azure Web Sites service to manage your web sites.
* The API has entities that capture the relationship between an end user and
* Windows Azure Web Sites service.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/dn166981.aspx for more
* information)
*/
public class WebSiteManagementClientImpl extends ServiceClient<WebSiteManagementClient> implements WebSiteManagementClient {
    private String apiVersion;
    
    /**
    * Gets the API version.
    * @return The ApiVersion value.
    */
    public String getApiVersion() {
        return this.apiVersion;
    }
    
    private URI baseUri;
    
    /**
    * Gets the URI used as the base for all cloud service requests.
    * @return The BaseUri value.
    */
    public URI getBaseUri() {
        return this.baseUri;
    }
    
    private SubscriptionCloudCredentials credentials;
    
    /**
    * Gets subscription credentials which uniquely identify Microsoft Azure
    * subscription. The subscription ID forms part of the URI for every
    * service call.
    * @return The Credentials value.
    */
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }
    
    private int longRunningOperationInitialTimeout;
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @return The LongRunningOperationInitialTimeout value.
    */
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @param longRunningOperationInitialTimeoutValue The
    * LongRunningOperationInitialTimeout value.
    */
    public void setLongRunningOperationInitialTimeout(final int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }
    
    private int longRunningOperationRetryTimeout;
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @return The LongRunningOperationRetryTimeout value.
    */
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeoutValue The
    * LongRunningOperationRetryTimeout value.
    */
    public void setLongRunningOperationRetryTimeout(final int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }
    
    private WebHostingPlanOperations webHostingPlans;
    
    /**
    * Operations for managing web hosting plans beneath your subscription.
    * @return The WebHostingPlansOperations value.
    */
    public WebHostingPlanOperations getWebHostingPlansOperations() {
        return this.webHostingPlans;
    }
    
    private WebSiteOperations webSites;
    
    /**
    * Operations for managing the web sites in a web space.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166981.aspx for
    * more information)
    * @return The WebSitesOperations value.
    */
    public WebSiteOperations getWebSitesOperations() {
        return this.webSites;
    }
    
    private WebSpaceOperations webSpaces;
    
    /**
    * Operations for managing web spaces beneath your subscription.
    * @return The WebSpacesOperations value.
    */
    public WebSpaceOperations getWebSpacesOperations() {
        return this.webSpaces;
    }
    
    /**
    * Initializes a new instance of the WebSiteManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    */
    public WebSiteManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
        this.webHostingPlans = new WebHostingPlanOperationsImpl(this);
        this.webSites = new WebSiteOperationsImpl(this);
        this.webSpaces = new WebSpaceOperationsImpl(this);
        this.apiVersion = "2014-04-01";
        this.longRunningOperationInitialTimeout = -1;
        this.longRunningOperationRetryTimeout = -1;
    }
    
    /**
    * Initializes a new instance of the WebSiteManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @param baseUri Optional. Gets the URI used as the base for all cloud
    * service requests.
    */
    @Inject
    public WebSiteManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(ManagementConfiguration.SUBSCRIPTION_CLOUD_CREDENTIALS) SubscriptionCloudCredentials credentials, @Named(ManagementConfiguration.URI) URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        } else {
            this.credentials = credentials;
        }
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.core.windows.net");
            }
            catch (URISyntaxException ex) {
            }
        } else {
            this.baseUri = baseUri;
        }
    }
    
    /**
    * Initializes a new instance of the WebSiteManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    */
    public WebSiteManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.core.windows.net");
    }
    
    /**
    * Initializes a new instance of the WebSiteManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @param baseUri Optional. Gets the URI used as the base for all cloud
    * service requests.
    * @param apiVersion Optional. Gets the API version.
    * @param longRunningOperationInitialTimeout Required. Gets or sets the
    * initial timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeout Required. Gets or sets the retry
    * timeout for Long Running Operations.
    */
    public WebSiteManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }
    
    /**
    * Initializes a new instance of the WebSiteManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    */
    protected WebSiteManagementClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new WebSiteManagementClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }
    
    /**
    * Parse enum values for type ConnectionStringType.
    *
    * @param value The value to parse.
    * @return The enum value.
    */
     static ConnectionStringType parseConnectionStringType(String value) {
        if ("0".equalsIgnoreCase(value)) {
            return ConnectionStringType.MySql;
        }
        if ("1".equalsIgnoreCase(value)) {
            return ConnectionStringType.SqlServer;
        }
        if ("2".equalsIgnoreCase(value)) {
            return ConnectionStringType.SqlAzure;
        }
        if ("3".equalsIgnoreCase(value)) {
            return ConnectionStringType.Custom;
        }
        throw new IllegalArgumentException("value");
    }
    
    /**
    * Convert an enum of type ConnectionStringType to a string.
    *
    * @param value The value to convert to a string.
    * @return The enum value as a string.
    */
     static String connectionStringTypeToString(ConnectionStringType value) {
        if (value == ConnectionStringType.MySql) {
            return "0";
        }
        if (value == ConnectionStringType.SqlServer) {
            return "1";
        }
        if (value == ConnectionStringType.SqlAzure) {
            return "2";
        }
        if (value == ConnectionStringType.Custom) {
            return "3";
        }
        throw new IllegalArgumentException("value");
    }
    
    /**
    * Parse enum values for type ManagedPipelineMode.
    *
    * @param value The value to parse.
    * @return The enum value.
    */
     static ManagedPipelineMode parseManagedPipelineMode(String value) {
        if ("0".equalsIgnoreCase(value)) {
            return ManagedPipelineMode.Integrated;
        }
        if ("1".equalsIgnoreCase(value)) {
            return ManagedPipelineMode.Classic;
        }
        throw new IllegalArgumentException("value");
    }
    
    /**
    * Convert an enum of type ManagedPipelineMode to a string.
    *
    * @param value The value to convert to a string.
    * @return The enum value as a string.
    */
     static String managedPipelineModeToString(ManagedPipelineMode value) {
        if (value == ManagedPipelineMode.Integrated) {
            return "0";
        }
        if (value == ManagedPipelineMode.Classic) {
            return "1";
        }
        throw new IllegalArgumentException("value");
    }
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling a long-running operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, timed out, or is still in progress.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460783.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the webspace for the website
    * where the operation was targeted.
    * @param siteName Required. The name of the site where the operation was
    * targeted.
    * @param operationId Required. The operation ID for the operation you wish
    * to track. The operation ID is returned in the ID field in the body of
    * the response for long-running operations.
    * @return The response body contains the status of the specified
    * long-running operation, indicating whether it has succeeded, is
    * inprogress, has timed out, or has failed. Note that this status is
    * distinct from the HTTP status code returned for the Get Operation Status
    * operation itself. If the long-running operation failed, the response
    * body includes error information regarding the failure.
    */
    @Override
    public Future<WebSiteOperationStatusResponse> getOperationStatusAsync(final String webSpaceName, final String siteName, final String operationId) {
        return this.getExecutorService().submit(new Callable<WebSiteOperationStatusResponse>() { 
            @Override
            public WebSiteOperationStatusResponse call() throws Exception {
                return getOperationStatus(webSpaceName, siteName, operationId);
            }
         });
    }
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling a long-running operation, you can call Get
    * Operation Status to determine whether the operation has succeeded,
    * failed, timed out, or is still in progress.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460783.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the webspace for the website
    * where the operation was targeted.
    * @param siteName Required. The name of the site where the operation was
    * targeted.
    * @param operationId Required. The operation ID for the operation you wish
    * to track. The operation ID is returned in the ID field in the body of
    * the response for long-running operations.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * long-running operation, indicating whether it has succeeded, is
    * inprogress, has timed out, or has failed. Note that this status is
    * distinct from the HTTP status code returned for the Get Operation Status
    * operation itself. If the long-running operation failed, the response
    * body includes error information regarding the failure.
    */
    @Override
    public WebSiteOperationStatusResponse getOperationStatus(String webSpaceName, String siteName, String operationId) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (webSpaceName == null) {
            throw new NullPointerException("webSpaceName");
        }
        if (siteName == null) {
            throw new NullPointerException("siteName");
        }
        if (operationId == null) {
            throw new NullPointerException("operationId");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("webSpaceName", webSpaceName);
            tracingParameters.put("siteName", siteName);
            tracingParameters.put("operationId", operationId);
            CloudTracing.enter(invocationId, this, "getOperationStatusAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services/WebSpaces/";
        url = url + URLEncoder.encode(webSpaceName, "UTF-8");
        url = url + "/sites/";
        url = url + URLEncoder.encode(siteName, "UTF-8");
        url = url + "/operations/";
        url = url + URLEncoder.encode(operationId, "UTF-8");
        String baseUrl = this.getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            WebSiteOperationStatusResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new WebSiteOperationStatusResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element operationElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Operation");
                if (operationElement != null) {
                    Element createdTimeElement = XmlUtility.getElementByTagNameNS(operationElement, "http://schemas.microsoft.com/windowsazure", "CreatedTime");
                    if (createdTimeElement != null) {
                        Calendar createdTimeInstance;
                        createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                        result.setCreatedTime(createdTimeInstance);
                    }
                    
                    Element errorsSequenceElement = XmlUtility.getElementByTagNameNS(operationElement, "http://schemas.microsoft.com/windowsazure", "Errors");
                    if (errorsSequenceElement != null) {
                        boolean isNil = false;
                        Attr nilAttribute = errorsSequenceElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                        if (nilAttribute != null) {
                            isNil = "true".equals(nilAttribute.getValue());
                        }
                        if (isNil == false) {
                            for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(errorsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Error").size(); i1 = i1 + 1) {
                                org.w3c.dom.Element errorsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(errorsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Error").get(i1));
                                WebSiteOperationStatusResponse.Error errorInstance = new WebSiteOperationStatusResponse.Error();
                                result.getErrors().add(errorInstance);
                                
                                Element codeElement = XmlUtility.getElementByTagNameNS(errorsElement, "http://schemas.microsoft.com/windowsazure", "Code");
                                if (codeElement != null) {
                                    boolean isNil2 = false;
                                    Attr nilAttribute2 = codeElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                                    if (nilAttribute2 != null) {
                                        isNil2 = "true".equals(nilAttribute2.getValue());
                                    }
                                    if (isNil2 == false) {
                                        String codeInstance;
                                        codeInstance = codeElement.getTextContent();
                                        errorInstance.setCode(codeInstance);
                                    }
                                }
                                
                                Element messageElement = XmlUtility.getElementByTagNameNS(errorsElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                if (messageElement != null) {
                                    boolean isNil3 = false;
                                    Attr nilAttribute3 = messageElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                                    if (nilAttribute3 != null) {
                                        isNil3 = "true".equals(nilAttribute3.getValue());
                                    }
                                    if (isNil3 == false) {
                                        String messageInstance;
                                        messageInstance = messageElement.getTextContent();
                                        errorInstance.setMessage(messageInstance);
                                    }
                                }
                                
                                Element extendedCodeElement = XmlUtility.getElementByTagNameNS(errorsElement, "http://schemas.microsoft.com/windowsazure", "ExtendedCode");
                                if (extendedCodeElement != null) {
                                    boolean isNil4 = false;
                                    Attr nilAttribute4 = extendedCodeElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                                    if (nilAttribute4 != null) {
                                        isNil4 = "true".equals(nilAttribute4.getValue());
                                    }
                                    if (isNil4 == false) {
                                        String extendedCodeInstance;
                                        extendedCodeInstance = extendedCodeElement.getTextContent();
                                        errorInstance.setExtendedCode(extendedCodeInstance);
                                    }
                                }
                                
                                Element messageTemplateElement = XmlUtility.getElementByTagNameNS(errorsElement, "http://schemas.microsoft.com/windowsazure", "MessageTemplate");
                                if (messageTemplateElement != null) {
                                    boolean isNil5 = false;
                                    Attr nilAttribute5 = messageTemplateElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                                    if (nilAttribute5 != null) {
                                        isNil5 = "true".equals(nilAttribute5.getValue());
                                    }
                                    if (isNil5 == false) {
                                        String messageTemplateInstance;
                                        messageTemplateInstance = messageTemplateElement.getTextContent();
                                        errorInstance.setMessageTemplate(messageTemplateInstance);
                                    }
                                }
                                
                                Element parametersSequenceElement = XmlUtility.getElementByTagNameNS(errorsElement, "http://schemas.microsoft.com/windowsazure", "Parameters");
                                if (parametersSequenceElement != null) {
                                    boolean isNil6 = false;
                                    Attr nilAttribute6 = parametersSequenceElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                                    if (nilAttribute6 != null) {
                                        isNil6 = "true".equals(nilAttribute6.getValue());
                                    }
                                    if (isNil6 == false) {
                                        for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(parametersSequenceElement, "http://schemas.microsoft.com/2003/10/Serialization/Arrays", "string").size(); i2 = i2 + 1) {
                                            org.w3c.dom.Element parametersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(parametersSequenceElement, "http://schemas.microsoft.com/2003/10/Serialization/Arrays", "string").get(i2));
                                            errorInstance.getParameters().add(parametersElement.getTextContent());
                                        }
                                    } else {
                                        errorInstance.setParameters(null);
                                    }
                                }
                                
                                Element innerErrorsElement = XmlUtility.getElementByTagNameNS(errorsElement, "http://schemas.microsoft.com/windowsazure", "InnerErrors");
                                if (innerErrorsElement != null) {
                                    boolean isNil7 = false;
                                    Attr nilAttribute7 = innerErrorsElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                                    if (nilAttribute7 != null) {
                                        isNil7 = "true".equals(nilAttribute7.getValue());
                                    }
                                    if (isNil7 == false) {
                                        String innerErrorsInstance;
                                        innerErrorsInstance = innerErrorsElement.getTextContent();
                                        errorInstance.setInnerErrors(innerErrorsInstance);
                                    }
                                }
                            }
                        } else {
                            result.setErrors(null);
                        }
                    }
                    
                    Element expirationTimeElement = XmlUtility.getElementByTagNameNS(operationElement, "http://schemas.microsoft.com/windowsazure", "ExpirationTime");
                    if (expirationTimeElement != null) {
                        Calendar expirationTimeInstance;
                        expirationTimeInstance = DatatypeConverter.parseDateTime(expirationTimeElement.getTextContent());
                        result.setExpirationTime(expirationTimeInstance);
                    }
                    
                    Element geoMasterOperationIdElement = XmlUtility.getElementByTagNameNS(operationElement, "http://schemas.microsoft.com/windowsazure", "GeoMasterOperationId");
                    if (geoMasterOperationIdElement != null) {
                        boolean isNil8 = false;
                        Attr nilAttribute8 = geoMasterOperationIdElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                        if (nilAttribute8 != null) {
                            isNil8 = "true".equals(nilAttribute8.getValue());
                        }
                        if (isNil8 == false) {
                            String geoMasterOperationIdInstance;
                            geoMasterOperationIdInstance = geoMasterOperationIdElement.getTextContent();
                            result.setGeoMasterOperationId(geoMasterOperationIdInstance);
                        }
                    }
                    
                    Element idElement = XmlUtility.getElementByTagNameNS(operationElement, "http://schemas.microsoft.com/windowsazure", "Id");
                    if (idElement != null) {
                        boolean isNil9 = false;
                        Attr nilAttribute9 = idElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                        if (nilAttribute9 != null) {
                            isNil9 = "true".equals(nilAttribute9.getValue());
                        }
                        if (isNil9 == false) {
                            String idInstance;
                            idInstance = idElement.getTextContent();
                            result.setOperationId(idInstance);
                        }
                    }
                    
                    Element modifiedTimeElement = XmlUtility.getElementByTagNameNS(operationElement, "http://schemas.microsoft.com/windowsazure", "ModifiedTime");
                    if (modifiedTimeElement != null) {
                        Calendar modifiedTimeInstance;
                        modifiedTimeInstance = DatatypeConverter.parseDateTime(modifiedTimeElement.getTextContent());
                        result.setModifiedTime(modifiedTimeInstance);
                    }
                    
                    Element nameElement = XmlUtility.getElementByTagNameNS(operationElement, "http://schemas.microsoft.com/windowsazure", "Name");
                    if (nameElement != null) {
                        boolean isNil10 = false;
                        Attr nilAttribute10 = nameElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
                        if (nilAttribute10 != null) {
                            isNil10 = "true".equals(nilAttribute10.getValue());
                        }
                        if (isNil10 == false) {
                            String nameInstance;
                            nameInstance = nameElement.getTextContent();
                            result.setName(nameInstance);
                        }
                    }
                    
                    Element statusElement = XmlUtility.getElementByTagNameNS(operationElement, "http://schemas.microsoft.com/windowsazure", "Status");
                    if (statusElement != null && statusElement.getTextContent() != null && !statusElement.getTextContent().isEmpty()) {
                        WebSiteOperationStatus statusInstance;
                        statusInstance = WebSiteOperationStatus.valueOf(statusElement.getTextContent());
                        result.setStatus(statusInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Register your subscription to use Azure Web Sites.
    *
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> registerSubscriptionAsync() {
        return this.getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return registerSubscription();
            }
         });
    }
    
    /**
    * Register your subscription to use Azure Web Sites.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse registerSubscription() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "registerSubscriptionAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("service=website");
        queryParameters.add("action=register");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Unregister your subscription to use Azure Web Sites.
    *
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> unregisterSubscriptionAsync() {
        return this.getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return unregisterSubscription();
            }
         });
    }
    
    /**
    * Unregister your subscription to use Azure Web Sites.
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse unregisterSubscription() throws IOException, ServiceException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "unregisterSubscriptionAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("service=website");
        queryParameters.add("action=unregister");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-04-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
