/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.websites.models.BackupRequest;
import com.microsoft.windowsazure.management.websites.models.HybridConnectionCreateParameters;
import com.microsoft.windowsazure.management.websites.models.HybridConnectionCreateResponse;
import com.microsoft.windowsazure.management.websites.models.HybridConnectionGetResponse;
import com.microsoft.windowsazure.management.websites.models.HybridConnectionListResponse;
import com.microsoft.windowsazure.management.websites.models.HybridConnectionUpdateParameters;
import com.microsoft.windowsazure.management.websites.models.RestoreRequest;
import com.microsoft.windowsazure.management.websites.models.SlotConfigNames;
import com.microsoft.windowsazure.management.websites.models.SlotConfigNamesUpdate;
import com.microsoft.windowsazure.management.websites.models.WebSiteBackupResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteCreateParameters;
import com.microsoft.windowsazure.management.websites.models.WebSiteCreateResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteDeleteParameters;
import com.microsoft.windowsazure.management.websites.models.WebSiteDeleteRepositoryResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetBackupConfigurationResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetBackupsResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetConfigurationResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetHistoricalUsageMetricsParameters;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetHistoricalUsageMetricsResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetParameters;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetPublishProfileResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetRepositoryResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteGetUsageMetricsResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteInstanceIdsResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteIsHostnameAvailableResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteOperationStatusResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteRestoreDiscoverResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteRestoreResponse;
import com.microsoft.windowsazure.management.websites.models.WebSiteUpdateConfigurationParameters;
import com.microsoft.windowsazure.management.websites.models.WebSiteUpdateParameters;
import com.microsoft.windowsazure.management.websites.models.WebSiteUpdateResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing the web sites in a web space.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/dn166981.aspx for more
* information)
*/
public interface WebSiteOperations {
    /**
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param targetSwapSlot Required. The name of the target slot to be swapped
    * with.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse applySlotConfiguration(String webSpaceName, String webSiteName, String targetSwapSlot) throws IOException, ServiceException;
    
    /**
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param targetSwapSlot Required. The name of the target slot to be swapped
    * with.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> applySlotConfigurationAsync(String webSpaceName, String webSiteName, String targetSwapSlot);
    
    /**
    * Backups a site on-demand.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param backupRequest Required. A backup specification.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The backup record created based on the backup request.
    */
    WebSiteBackupResponse backup(String webSpaceName, String webSiteName, BackupRequest backupRequest) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Backups a site on-demand.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param backupRequest Required. A backup specification.
    * @return The backup record created based on the backup request.
    */
    Future<WebSiteBackupResponse> backupAsync(String webSpaceName, String webSiteName, BackupRequest backupRequest);
    
    /**
    * You can swap a web site from one slot to another slot.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param sourceSlotName Required. The name of the first web site slot to
    * swap (source).
    * @param targetSlotName Required. The name of the second web site slot to
    * swap with (target).
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The response body contains the status of the specified
    * long-running operation, indicating whether it has succeeded, is
    * inprogress, has timed out, or has failed. Note that this status is
    * distinct from the HTTP status code returned for the Get Operation Status
    * operation itself. If the long-running operation failed, the response
    * body includes error information regarding the failure.
    */
    WebSiteOperationStatusResponse beginSwappingSlots(String webSpaceName, String webSiteName, String sourceSlotName, String targetSlotName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * You can swap a web site from one slot to another slot.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param sourceSlotName Required. The name of the first web site slot to
    * swap (source).
    * @param targetSlotName Required. The name of the second web site slot to
    * swap with (target).
    * @return The response body contains the status of the specified
    * long-running operation, indicating whether it has succeeded, is
    * inprogress, has timed out, or has failed. Note that this status is
    * distinct from the HTTP status code returned for the Get Operation Status
    * operation itself. If the long-running operation failed, the response
    * body includes error information regarding the failure.
    */
    Future<WebSiteOperationStatusResponse> beginSwappingSlotsAsync(String webSpaceName, String webSiteName, String sourceSlotName, String targetSlotName);
    
    /**
    * You can create a web site by using a POST request that includes the name
    * of the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param parameters Required. Parameters supplied to the Create Web Site
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Create Web Site operation response.
    */
    WebSiteCreateResponse create(String webSpaceName, WebSiteCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException;
    
    /**
    * You can create a web site by using a POST request that includes the name
    * of the web site and other information in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166986.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param parameters Required. Parameters supplied to the Create Web Site
    * operation.
    * @return The Create Web Site operation response.
    */
    Future<WebSiteCreateResponse> createAsync(String webSpaceName, WebSiteCreateParameters parameters);
    
    /**
    * Creates an association to a hybrid connection for a web site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param siteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Create Hybrid
    * Connection operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Create Hybrid Connection operation response.
    */
    HybridConnectionCreateResponse createHybridConnection(String webSpaceName, String siteName, HybridConnectionCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Creates an association to a hybrid connection for a web site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param siteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Create Hybrid
    * Connection operation.
    * @return The Create Hybrid Connection operation response.
    */
    Future<HybridConnectionCreateResponse> createHybridConnectionAsync(String webSpaceName, String siteName, HybridConnectionCreateParameters parameters);
    
    /**
    * A web site repository is essentially a Git repository that you can use to
    * manage your web site content. By using Git source control tools, you can
    * push or pull version-controlled changes to your site. This API executes
    * a repository create operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse createRepository(String webSpaceName, String webSiteName) throws IOException, ServiceException;
    
    /**
    * A web site repository is essentially a Git repository that you can use to
    * manage your web site content. By using Git source control tools, you can
    * push or pull version-controlled changes to your site. This API executes
    * a repository create operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> createRepositoryAsync(String webSpaceName, String webSiteName);
    
    /**
    * You can delete a web site by issuing an HTTP DELETE request. If the web
    * site being deleted is the only site remaining in a server farm, you can
    * optionally delete the server farm as well by using the
    * deleteEmptyServerFarm parameter.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236430.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Delete Web Site
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String webSpaceName, String webSiteName, WebSiteDeleteParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can delete a web site by issuing an HTTP DELETE request. If the web
    * site being deleted is the only site remaining in a server farm, you can
    * optionally delete the server farm as well by using the
    * deleteEmptyServerFarm parameter.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236430.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Delete Web Site
    * operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String webSpaceName, String webSiteName, WebSiteDeleteParameters parameters);
    
    /**
    * Deletes a hybrid connection on a specific site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param hybridConnectionName Required. The name of the hybrid connection
    * entity
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse deleteHybridConnection(String webSpaceName, String webSiteName, String hybridConnectionName) throws IOException, ServiceException;
    
    /**
    * Deletes a hybrid connection on a specific site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param hybridConnectionName Required. The name of the hybrid connection
    * entity
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteHybridConnectionAsync(String webSpaceName, String webSiteName, String hybridConnectionName);
    
    /**
    * A web site repository is essentially a Git repository that you can use to
    * manage your web site content. By using Git source control tools, you can
    * push or pull version-controlled changes to your site. This API executes
    * a repository delete operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Delete Repository Web Site operation response.
    */
    WebSiteDeleteRepositoryResponse deleteRepository(String webSpaceName, String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * A web site repository is essentially a Git repository that you can use to
    * manage your web site content. By using Git source control tools, you can
    * push or pull version-controlled changes to your site. This API executes
    * a repository delete operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return The Delete Repository Web Site operation response.
    */
    Future<WebSiteDeleteRepositoryResponse> deleteRepositoryAsync(String webSpaceName, String webSiteName);
    
    /**
    * Scans a backup in a storage account and returns database information etc.
    * Should be called before calling Restore to discover what parameters are
    * needed for the restore operation.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param restoreRequest Required. A restore request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The information gathered about a backup storaged in a storage
    * account.
    */
    WebSiteRestoreDiscoverResponse discover(String webSpaceName, String webSiteName, RestoreRequest restoreRequest) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Scans a backup in a storage account and returns database information etc.
    * Should be called before calling Restore to discover what parameters are
    * needed for the restore operation.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param restoreRequest Required. A restore request.
    * @return The information gathered about a backup storaged in a storage
    * account.
    */
    Future<WebSiteRestoreDiscoverResponse> discoverAsync(String webSpaceName, String webSiteName, RestoreRequest restoreRequest);
    
    /**
    * You can generate a new random password for publishing a site by issuing
    * an HTTP POST request. Tip: If you want to verify that the publish
    * password has changed, issue an HTTP GET on /publishxml before calling
    * /newpassword. In the publish XML, note the hash value in the userPWD
    * attribute. After calling /newpassword, call /publishxml again. You can
    * then compare the new value of userPWD in the Publish XML with the one
    * you noted earlier.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236428.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse generatePassword(String webSpaceName, String webSiteName) throws IOException, ServiceException;
    
    /**
    * You can generate a new random password for publishing a site by issuing
    * an HTTP POST request. Tip: If you want to verify that the publish
    * password has changed, issue an HTTP GET on /publishxml before calling
    * /newpassword. In the publish XML, note the hash value in the userPWD
    * attribute. After calling /newpassword, call /publishxml again. You can
    * then compare the new value of userPWD in the Publish XML with the one
    * you noted earlier.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236428.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> generatePasswordAsync(String webSpaceName, String webSiteName);
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Optional. Parameters supplied to the Get Web Site
    * Operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Web Site operation response.
    */
    WebSiteGetResponse get(String webSpaceName, String webSiteName, WebSiteGetParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * You can retrieve details for a web site by issuing an HTTP GET request.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/dn167007.aspx
    * for more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Optional. Parameters supplied to the Get Web Site
    * Operation.
    * @return The Get Web Site operation response.
    */
    Future<WebSiteGetResponse> getAsync(String webSpaceName, String webSiteName, WebSiteGetParameters parameters);
    
    /**
    * Gets a schedule configuration for site backups.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Scheduled backup definition.
    */
    WebSiteGetBackupConfigurationResponse getBackupConfiguration(String webSpaceName, String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Gets a schedule configuration for site backups.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return Scheduled backup definition.
    */
    Future<WebSiteGetBackupConfigurationResponse> getBackupConfigurationAsync(String webSpaceName, String webSiteName);
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Get Configuration Web Site operation response.
    */
    WebSiteGetConfigurationResponse getConfiguration(String webSpaceName, String webSiteName) throws IOException, ServiceException;
    
    /**
    * You can retrieve the config settings for a web site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return The Get Configuration Web Site operation response.
    */
    Future<WebSiteGetConfigurationResponse> getConfigurationAsync(String webSpaceName, String webSiteName);
    
    /**
    * You can retrieve historical usage metrics for a site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166964.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Get Historical
    * Usage Metrics Web Site operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The Get Historical Usage Metrics Web Site operation response.
    */
    WebSiteGetHistoricalUsageMetricsResponse getHistoricalUsageMetrics(String webSpaceName, String webSiteName, WebSiteGetHistoricalUsageMetricsParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * You can retrieve historical usage metrics for a site by issuing an HTTP
    * GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166964.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Get Historical
    * Usage Metrics Web Site operation.
    * @return The Get Historical Usage Metrics Web Site operation response.
    */
    Future<WebSiteGetHistoricalUsageMetricsResponse> getHistoricalUsageMetricsAsync(String webSpaceName, String webSiteName, WebSiteGetHistoricalUsageMetricsParameters parameters);
    
    /**
    * Retrieves a particular hybrid connection that belongs to a specific site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param hybridConnectionName Required. The name of the hybrid connection
    * entity
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The Get Hybrid Connection operation response.
    */
    HybridConnectionGetResponse getHybridConnection(String webSpaceName, String webSiteName, String hybridConnectionName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Retrieves a particular hybrid connection that belongs to a specific site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param hybridConnectionName Required. The name of the hybrid connection
    * entity
    * @return The Get Hybrid Connection operation response.
    */
    Future<HybridConnectionGetResponse> getHybridConnectionAsync(String webSpaceName, String webSiteName, String hybridConnectionName);
    
    /**
    * You can retrieve the list of active instances by ids for a web site by
    * issuing an HTTP GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166981.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The web site instance ids response.
    */
    WebSiteInstanceIdsResponse getInstanceIds(String webSpaceName, String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * You can retrieve the list of active instances by ids for a web site by
    * issuing an HTTP GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166981.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return The web site instance ids response.
    */
    Future<WebSiteInstanceIdsResponse> getInstanceIdsAsync(String webSpaceName, String webSiteName);
    
    /**
    * You can retrieve the publish settings information for a web site by
    * issuing an HTTP GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166996.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Publish Profile Web Site operation response.
    */
    WebSiteGetPublishProfileResponse getPublishProfile(String webSpaceName, String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * You can retrieve the publish settings information for a web site by
    * issuing an HTTP GET request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166996.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return The Get Publish Profile Web Site operation response.
    */
    Future<WebSiteGetPublishProfileResponse> getPublishProfileAsync(String webSpaceName, String webSiteName);
    
    /**
    * A web site repository is essentially a Git repository that you can use to
    * manage your web site content. By using Git source control tools, you can
    * push or pull version-controlled changes to your site. This API executes
    * a repository get operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Repository Web Site operation response.
    */
    WebSiteGetRepositoryResponse getRepository(String webSpaceName, String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException;
    
    /**
    * A web site repository is essentially a Git repository that you can use to
    * manage your web site content. By using Git source control tools, you can
    * push or pull version-controlled changes to your site. This API executes
    * a repository get operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return The Get Repository Web Site operation response.
    */
    Future<WebSiteGetRepositoryResponse> getRepositoryAsync(String webSpaceName, String webSiteName);
    
    /**
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    SlotConfigNames getSlotConfigNames(String webSpaceName, String webSiteName) throws IOException, ServiceException;
    
    /**
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<SlotConfigNames> getSlotConfigNamesAsync(String webSpaceName, String webSiteName);
    
    /**
    * You can retrieve current usage metrics for a site by issuing an HTTP GET
    * request. The metrics returned include CPU Time, Data In, Data Out, Local
    * Bytes Read, Local Bytes Written, Network Bytes Read, Network Bytes
    * Written, WP Stop Requests, Memory Usage, CPU Time - Minute Limit, and
    * File System Storage.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166991.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The Get Usage Metrics Web Site operation response.
    */
    WebSiteGetUsageMetricsResponse getUsageMetrics(String webSpaceName, String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * You can retrieve current usage metrics for a site by issuing an HTTP GET
    * request. The metrics returned include CPU Time, Data In, Data Out, Local
    * Bytes Read, Local Bytes Written, Network Bytes Read, Network Bytes
    * Written, WP Stop Requests, Memory Usage, CPU Time - Minute Limit, and
    * File System Storage.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166991.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return The Get Usage Metrics Web Site operation response.
    */
    Future<WebSiteGetUsageMetricsResponse> getUsageMetricsAsync(String webSpaceName, String webSiteName);
    
    /**
    * Determines if a host name is available.
    *
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The Is Hostname Available Web Site operation response.
    */
    WebSiteIsHostnameAvailableResponse isHostnameAvailable(String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Determines if a host name is available.
    *
    * @param webSiteName Required. The name of the web site.
    * @return The Is Hostname Available Web Site operation response.
    */
    Future<WebSiteIsHostnameAvailableResponse> isHostnameAvailableAsync(String webSiteName);
    
    /**
    * Returns list of all backups which are tracked by the system.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return List of backups for the website.
    */
    WebSiteGetBackupsResponse listBackups(String webSpaceName, String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Returns list of all backups which are tracked by the system.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return List of backups for the website.
    */
    Future<WebSiteGetBackupsResponse> listBackupsAsync(String webSpaceName, String webSiteName);
    
    /**
    * Retrieves a list of all hybrid connections on a specific web site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The List Hybrid Connection operation response.
    */
    HybridConnectionListResponse listHybridConnections(String webSpaceName, String webSiteName) throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * Retrieves a list of all hybrid connections on a specific web site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return The List Hybrid Connection operation response.
    */
    Future<HybridConnectionListResponse> listHybridConnectionsAsync(String webSpaceName, String webSiteName);
    
    /**
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse resetSlotConfiguration(String webSpaceName, String webSiteName) throws IOException, ServiceException;
    
    /**
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> resetSlotConfigurationAsync(String webSpaceName, String webSiteName);
    
    /**
    * You can restart a web site by issuing an HTTP POST request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236425.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse restart(String webSpaceName, String webSiteName) throws IOException, ServiceException;
    
    /**
    * You can restart a web site by issuing an HTTP POST request.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn236425.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> restartAsync(String webSpaceName, String webSiteName);
    
    /**
    * Restores a site to either a new site or existing site (Overwrite flag has
    * to be set to true for that).
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param restoreRequest Required. A restore request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return Restore operation information.
    */
    WebSiteRestoreResponse restore(String webSpaceName, String webSiteName, RestoreRequest restoreRequest) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Restores a site to either a new site or existing site (Overwrite flag has
    * to be set to true for that).
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param restoreRequest Required. A restore request.
    * @return Restore operation information.
    */
    Future<WebSiteRestoreResponse> restoreAsync(String webSpaceName, String webSiteName, RestoreRequest restoreRequest);
    
    /**
    * You can swap a web site from one slot to another slot.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param sourceSlotName Required. The name of the first web site slot to
    * swap (source).
    * @param targetSlotName Required. The name of the second web site slot to
    * swap with (target).
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * long-running operation, indicating whether it has succeeded, is
    * inprogress, has timed out, or has failed. Note that this status is
    * distinct from the HTTP status code returned for the Get Operation Status
    * operation itself. If the long-running operation failed, the response
    * body includes error information regarding the failure.
    */
    WebSiteOperationStatusResponse swapSlots(String webSpaceName, String webSiteName, String sourceSlotName, String targetSlotName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * You can swap a web site from one slot to another slot.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param sourceSlotName Required. The name of the first web site slot to
    * swap (source).
    * @param targetSlotName Required. The name of the second web site slot to
    * swap with (target).
    * @return The response body contains the status of the specified
    * long-running operation, indicating whether it has succeeded, is
    * inprogress, has timed out, or has failed. Note that this status is
    * distinct from the HTTP status code returned for the Get Operation Status
    * operation itself. If the long-running operation failed, the response
    * body includes error information regarding the failure.
    */
    Future<WebSiteOperationStatusResponse> swapSlotsAsync(String webSpaceName, String webSiteName, String sourceSlotName, String targetSlotName);
    
    /**
    * A web site repository is essentially a Git repository that you can use to
    * manage your web site content. By using Git source control tools, you can
    * push or pull version-controlled changes to your site. This API executes
    * a repository sync operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse syncRepository(String webSpaceName, String webSiteName) throws IOException, ServiceException;
    
    /**
    * A web site repository is essentially a Git repository that you can use to
    * manage your web site content. By using Git source control tools, you can
    * push or pull version-controlled changes to your site. This API executes
    * a repository sync operation.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166967.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> syncRepositoryAsync(String webSpaceName, String webSiteName);
    
    /**
    * You can update the settings for a web site by using the HTTP PUT method
    * and by specifying the settings in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn167005.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Update Web Site
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Update Web Site operation response.
    */
    WebSiteUpdateResponse update(String webSpaceName, String webSiteName, WebSiteUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException, URISyntaxException;
    
    /**
    * You can update the settings for a web site by using the HTTP PUT method
    * and by specifying the settings in the request body.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn167005.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Update Web Site
    * operation.
    * @return The Update Web Site operation response.
    */
    Future<WebSiteUpdateResponse> updateAsync(String webSpaceName, String webSiteName, WebSiteUpdateParameters parameters);
    
    /**
    * Updates a backup schedule for a site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param backupRequest Required. A backup schedule specification.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse updateBackupConfiguration(String webSpaceName, String webSiteName, BackupRequest backupRequest) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Updates a backup schedule for a site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param backupRequest Required. A backup schedule specification.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateBackupConfigurationAsync(String webSpaceName, String webSiteName, BackupRequest backupRequest);
    
    /**
    * You can update the config settings for a web site by issuing an HTTP PUT
    * with a request body containing the updated settings.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Update
    * Configuration Web Site operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse updateConfiguration(String webSpaceName, String webSiteName, WebSiteUpdateConfigurationParameters parameters) throws IOException, ServiceException;
    
    /**
    * You can update the config settings for a web site by issuing an HTTP PUT
    * with a request body containing the updated settings.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn166985.aspx for
    * more information)
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Update
    * Configuration Web Site operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateConfigurationAsync(String webSpaceName, String webSiteName, WebSiteUpdateConfigurationParameters parameters);
    
    /**
    * Updates an association to a hybrid connection for a web site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param siteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Create Hybrid
    * Connection operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse updateHybridConnection(String webSpaceName, String siteName, HybridConnectionUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Updates an association to a hybrid connection for a web site.
    *
    * @param webSpaceName Required. The name of the web space.
    * @param siteName Required. The name of the web site.
    * @param parameters Required. Parameters supplied to the Create Hybrid
    * Connection operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateHybridConnectionAsync(String webSpaceName, String siteName, HybridConnectionUpdateParameters parameters);
    
    /**
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. The parameters.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse updateSlotConfigNames(String webSpaceName, String webSiteName, SlotConfigNamesUpdate parameters) throws IOException, ServiceException;
    
    /**
    *
    * @param webSpaceName Required. The name of the web space.
    * @param webSiteName Required. The name of the web site.
    * @param parameters Required. The parameters.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> updateSlotConfigNamesAsync(String webSpaceName, String webSiteName, SlotConfigNamesUpdate parameters);
}
