/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;
import java.util.Calendar;

/**
* A specific backup.
*/
public class BackupItem {
    private String blobName;
    
    /**
    * Optional. The blob name where the backup is stored, e.g.
    * mysite1_20140506.zip
    * @return The BlobName value.
    */
    public String getBlobName() {
        return this.blobName;
    }
    
    /**
    * Optional. The blob name where the backup is stored, e.g.
    * mysite1_20140506.zip
    * @param blobNameValue The BlobName value.
    */
    public void setBlobName(final String blobNameValue) {
        this.blobName = blobNameValue;
    }
    
    private String correlationId;
    
    /**
    * Optional. Internal correlation identifier - identifies a specific backup.
    * @return The CorrelationId value.
    */
    public String getCorrelationId() {
        return this.correlationId;
    }
    
    /**
    * Optional. Internal correlation identifier - identifies a specific backup.
    * @param correlationIdValue The CorrelationId value.
    */
    public void setCorrelationId(final String correlationIdValue) {
        this.correlationId = correlationIdValue;
    }
    
    private Calendar created;
    
    /**
    * Optional. Timestamp when the backup has been created.
    * @return The Created value.
    */
    public Calendar getCreated() {
        return this.created;
    }
    
    /**
    * Optional. Timestamp when the backup has been created.
    * @param createdValue The Created value.
    */
    public void setCreated(final Calendar createdValue) {
        this.created = createdValue;
    }
    
    private ArrayList<DatabaseBackupSetting> databases;
    
    /**
    * Optional. Database settings for backup.
    * @return The Databases value.
    */
    public ArrayList<DatabaseBackupSetting> getDatabases() {
        return this.databases;
    }
    
    /**
    * Optional. Database settings for backup.
    * @param databasesValue The Databases value.
    */
    public void setDatabases(final ArrayList<DatabaseBackupSetting> databasesValue) {
        this.databases = databasesValue;
    }
    
    private Calendar finishedTimeStamp;
    
    /**
    * Optional. Timestamp when this backup has been finished and a zip file has
    * been uploaded to a storage account.
    * @return The FinishedTimeStamp value.
    */
    public Calendar getFinishedTimeStamp() {
        return this.finishedTimeStamp;
    }
    
    /**
    * Optional. Timestamp when this backup has been finished and a zip file has
    * been uploaded to a storage account.
    * @param finishedTimeStampValue The FinishedTimeStamp value.
    */
    public void setFinishedTimeStamp(final Calendar finishedTimeStampValue) {
        this.finishedTimeStamp = finishedTimeStampValue;
    }
    
    private Calendar lastRestoreTimeStamp;
    
    /**
    * Optional. Timestamp when this backup has been used for a restore
    * operation (empty if it wasn't).
    * @return The LastRestoreTimeStamp value.
    */
    public Calendar getLastRestoreTimeStamp() {
        return this.lastRestoreTimeStamp;
    }
    
    /**
    * Optional. Timestamp when this backup has been used for a restore
    * operation (empty if it wasn't).
    * @param lastRestoreTimeStampValue The LastRestoreTimeStamp value.
    */
    public void setLastRestoreTimeStamp(final Calendar lastRestoreTimeStampValue) {
        this.lastRestoreTimeStamp = lastRestoreTimeStampValue;
    }
    
    private String log;
    
    /**
    * Optional. Information about the backup, usually used only if there was an
    * error.
    * @return The Log value.
    */
    public String getLog() {
        return this.log;
    }
    
    /**
    * Optional. Information about the backup, usually used only if there was an
    * error.
    * @param logValue The Log value.
    */
    public void setLog(final String logValue) {
        this.log = logValue;
    }
    
    private String name;
    
    /**
    * Optional. The name of this backup.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. The name of this backup.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private boolean scheduled;
    
    /**
    * Optional. True if this backup has been created as a part of a scheduled
    * backup; false otherwise.
    * @return The Scheduled value.
    */
    public boolean isScheduled() {
        return this.scheduled;
    }
    
    /**
    * Optional. True if this backup has been created as a part of a scheduled
    * backup; false otherwise.
    * @param scheduledValue The Scheduled value.
    */
    public void setScheduled(final boolean scheduledValue) {
        this.scheduled = scheduledValue;
    }
    
    private long sizeInBytes;
    
    /**
    * Optional. Size of the backup zip file in bytes.
    * @return The SizeInBytes value.
    */
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }
    
    /**
    * Optional. Size of the backup zip file in bytes.
    * @param sizeInBytesValue The SizeInBytes value.
    */
    public void setSizeInBytes(final long sizeInBytesValue) {
        this.sizeInBytes = sizeInBytesValue;
    }
    
    private BackupItemStatus status;
    
    /**
    * Optional. The status of the backup - e.g. Succeeded or Failed
    * @return The Status value.
    */
    public BackupItemStatus getStatus() {
        return this.status;
    }
    
    /**
    * Optional. The status of the backup - e.g. Succeeded or Failed
    * @param statusValue The Status value.
    */
    public void setStatus(final BackupItemStatus statusValue) {
        this.status = statusValue;
    }
    
    private String storageAccountUrl;
    
    /**
    * Optional. SAS URL for a container in a storage account. E.g.
    * https://NAME.blob.core.windows.net/CONTAINERNAME/?sv=2012-02-12&st=2013-12-05T19%3A30%3A45Z&se=2017-12-04T19%3A30%3A45Z&sr=c&sp=rwdl&sig=abcdefABCDEFabcdef0123456789
    * @return The StorageAccountUrl value.
    */
    public String getStorageAccountUrl() {
        return this.storageAccountUrl;
    }
    
    /**
    * Optional. SAS URL for a container in a storage account. E.g.
    * https://NAME.blob.core.windows.net/CONTAINERNAME/?sv=2012-02-12&st=2013-12-05T19%3A30%3A45Z&se=2017-12-04T19%3A30%3A45Z&sr=c&sp=rwdl&sig=abcdefABCDEFabcdef0123456789
    * @param storageAccountUrlValue The StorageAccountUrl value.
    */
    public void setStorageAccountUrl(final String storageAccountUrlValue) {
        this.storageAccountUrl = storageAccountUrlValue;
    }
    
    /**
    * Initializes a new instance of the BackupItem class.
    *
    */
    public BackupItem() {
        this.setDatabases(new LazyArrayList<DatabaseBackupSetting>());
    }
}
