/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites.models;

import java.util.Calendar;

/**
* Defines a backup schedule for a website.
*/
public class BackupSchedule {
    private int frequencyInterval;
    
    /**
    * Optional. The frequency of backups.
    * @return The FrequencyInterval value.
    */
    public int getFrequencyInterval() {
        return this.frequencyInterval;
    }
    
    /**
    * Optional. The frequency of backups.
    * @param frequencyIntervalValue The FrequencyInterval value.
    */
    public void setFrequencyInterval(final int frequencyIntervalValue) {
        this.frequencyInterval = frequencyIntervalValue;
    }
    
    private FrequencyUnit frequencyUnit;
    
    /**
    * Optional. Units for FrequencyInterval - e.g. Day or Hour
    * @return The FrequencyUnit value.
    */
    public FrequencyUnit getFrequencyUnit() {
        return this.frequencyUnit;
    }
    
    /**
    * Optional. Units for FrequencyInterval - e.g. Day or Hour
    * @param frequencyUnitValue The FrequencyUnit value.
    */
    public void setFrequencyUnit(final FrequencyUnit frequencyUnitValue) {
        this.frequencyUnit = frequencyUnitValue;
    }
    
    private boolean keepAtLeastOneBackup;
    
    /**
    * Optional. Retention policy deletes backups after predefined number of
    * days. If this is true, there will be always at least one backup left.
    * regardless of the policy. If false, all backups can be deleted.
    * @return The KeepAtLeastOneBackup value.
    */
    public boolean isKeepAtLeastOneBackup() {
        return this.keepAtLeastOneBackup;
    }
    
    /**
    * Optional. Retention policy deletes backups after predefined number of
    * days. If this is true, there will be always at least one backup left.
    * regardless of the policy. If false, all backups can be deleted.
    * @param keepAtLeastOneBackupValue The KeepAtLeastOneBackup value.
    */
    public void setKeepAtLeastOneBackup(final boolean keepAtLeastOneBackupValue) {
        this.keepAtLeastOneBackup = keepAtLeastOneBackupValue;
    }
    
    private Calendar lastExecutionTime;
    
    /**
    * Optional. The last time when this schedule started a backup, Null if
    * didn't start anything yet.
    * @return The LastExecutionTime value.
    */
    public Calendar getLastExecutionTime() {
        return this.lastExecutionTime;
    }
    
    /**
    * Optional. The last time when this schedule started a backup, Null if
    * didn't start anything yet.
    * @param lastExecutionTimeValue The LastExecutionTime value.
    */
    public void setLastExecutionTime(final Calendar lastExecutionTimeValue) {
        this.lastExecutionTime = lastExecutionTimeValue;
    }
    
    private int retentionPeriodInDays;
    
    /**
    * Optional. Backups older N days (N defined by this value) will be
    * automatically deleted.
    * @return The RetentionPeriodInDays value.
    */
    public int getRetentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }
    
    /**
    * Optional. Backups older N days (N defined by this value) will be
    * automatically deleted.
    * @param retentionPeriodInDaysValue The RetentionPeriodInDays value.
    */
    public void setRetentionPeriodInDays(final int retentionPeriodInDaysValue) {
        this.retentionPeriodInDays = retentionPeriodInDaysValue;
    }
    
    private Calendar startTime;
    
    /**
    * Optional. When this schedule should start backing up the site. Null means
    * immediately.
    * @return The StartTime value.
    */
    public Calendar getStartTime() {
        return this.startTime;
    }
    
    /**
    * Optional. When this schedule should start backing up the site. Null means
    * immediately.
    * @param startTimeValue The StartTime value.
    */
    public void setStartTime(final Calendar startTimeValue) {
        this.startTime = startTimeValue;
    }
}
