/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The List Hybrid Connection operation response.
*/
public class HybridConnectionListResponse extends OperationResponse implements Iterable<HybridConnection> {
    private ArrayList<HybridConnection> hybridConnections;
    
    /**
    * Optional. Details for the hybrid connections.
    * @return The HybridConnections value.
    */
    public ArrayList<HybridConnection> getHybridConnections() {
        return this.hybridConnections;
    }
    
    /**
    * Optional. Details for the hybrid connections.
    * @param hybridConnectionsValue The HybridConnections value.
    */
    public void setHybridConnections(final ArrayList<HybridConnection> hybridConnectionsValue) {
        this.hybridConnections = hybridConnectionsValue;
    }
    
    /**
    * Initializes a new instance of the HybridConnectionListResponse class.
    *
    */
    public HybridConnectionListResponse() {
        super();
        this.setHybridConnections(new LazyArrayList<HybridConnection>());
    }
    
    /**
    * Gets the sequence of HybridConnections.
    *
    */
    public Iterator<HybridConnection> iterator() {
        return this.getHybridConnections().iterator();
    }
}
