/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites.models;

/**
* Parameters supplied to the Create Hybrid Connection operation
*/
public class HybridConnectionUpdateParameters {
    private String biztalkUri;
    
    /**
    * Optional. The resource uri of the biztalk service. This field can be left
    * empty; Without it the Azure Portal will not be able to display the
    * biztalk service for this connection properly.
    * @return The BiztalkUri value.
    */
    public String getBiztalkUri() {
        return this.biztalkUri;
    }
    
    /**
    * Optional. The resource uri of the biztalk service. This field can be left
    * empty; Without it the Azure Portal will not be able to display the
    * biztalk service for this connection properly.
    * @param biztalkUriValue The BiztalkUri value.
    */
    public void setBiztalkUri(final String biztalkUriValue) {
        this.biztalkUri = biztalkUriValue;
    }
    
    private String entityConnectionString;
    
    /**
    * Optional. The biztalk application connection string for this connection
    * @return The EntityConnectionString value.
    */
    public String getEntityConnectionString() {
        return this.entityConnectionString;
    }
    
    /**
    * Optional. The biztalk application connection string for this connection
    * @param entityConnectionStringValue The EntityConnectionString value.
    */
    public void setEntityConnectionString(final String entityConnectionStringValue) {
        this.entityConnectionString = entityConnectionStringValue;
    }
    
    private String entityName;
    
    /**
    * Required. The unique name for this connection
    * @return The EntityName value.
    */
    public String getEntityName() {
        return this.entityName;
    }
    
    /**
    * Required. The unique name for this connection
    * @param entityNameValue The EntityName value.
    */
    public void setEntityName(final String entityNameValue) {
        this.entityName = entityNameValue;
    }
    
    private String hostname;
    
    /**
    * Optional. The hostname of the target on-premise resource
    * @return The Hostname value.
    */
    public String getHostname() {
        return this.hostname;
    }
    
    /**
    * Optional. The hostname of the target on-premise resource
    * @param hostnameValue The Hostname value.
    */
    public void setHostname(final String hostnameValue) {
        this.hostname = hostnameValue;
    }
    
    private int port;
    
    /**
    * Optional. The port of the target on-premise resource
    * @return The Port value.
    */
    public int getPort() {
        return this.port;
    }
    
    /**
    * Optional. The port of the target on-premise resource
    * @param portValue The Port value.
    */
    public void setPort(final int portValue) {
        this.port = portValue;
    }
    
    private String resourceConnectionString;
    
    /**
    * Optional. Reserved for future use. The connection string for the
    * resource. This field can be left empty.
    * @return The ResourceConnectionString value.
    */
    public String getResourceConnectionString() {
        return this.resourceConnectionString;
    }
    
    /**
    * Optional. Reserved for future use. The connection string for the
    * resource. This field can be left empty.
    * @param resourceConnectionStringValue The ResourceConnectionString value.
    */
    public void setResourceConnectionString(final String resourceConnectionStringValue) {
        this.resourceConnectionString = resourceConnectionStringValue;
    }
    
    private String resourceType;
    
    /**
    * Optional. Reserved for future use. The type of resource to be connected.
    * This field can be left empty.
    * @return The ResourceType value.
    */
    public String getResourceType() {
        return this.resourceType;
    }
    
    /**
    * Optional. Reserved for future use. The type of resource to be connected.
    * This field can be left empty.
    * @param resourceTypeValue The ResourceType value.
    */
    public void setResourceType(final String resourceTypeValue) {
        this.resourceType = resourceTypeValue;
    }
    
    /**
    * Initializes a new instance of the HybridConnectionUpdateParameters class.
    *
    */
    public HybridConnectionUpdateParameters() {
    }
    
    /**
    * Initializes a new instance of the HybridConnectionUpdateParameters class
    * with required arguments.
    *
    * @param entityName The unique name for this connection
    */
    public HybridConnectionUpdateParameters(String entityName) {
        if (entityName == null) {
            throw new NullPointerException("entityName");
        }
        this.setEntityName(entityName);
    }
}
