/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites.models;

/**
* Parameters supplied to the Create Web Site operation.
*/
public class WebSiteCreateParameters {
    private String name;
    
    /**
    * Required. The name of the web site. This should match the host name in
    * the default domain.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Required. The name of the web site. This should match the host name in
    * the default domain.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String serverFarm;
    
    /**
    * Required. The name of the Server Farm (Web Hosting Plan) associated with
    * this web site. This is a required value. Server Farm must already exist.
    * @return The ServerFarm value.
    */
    public String getServerFarm() {
        return this.serverFarm;
    }
    
    /**
    * Required. The name of the Server Farm (Web Hosting Plan) associated with
    * this web site. This is a required value. Server Farm must already exist.
    * @param serverFarmValue The ServerFarm value.
    */
    public void setServerFarm(final String serverFarmValue) {
        this.serverFarm = serverFarmValue;
    }
    
    private WebSiteCreateParameters.WebSpaceDetails webSpace;
    
    /**
    * Optional. Information about the web space to create.
    * @return The WebSpace value.
    */
    public WebSiteCreateParameters.WebSpaceDetails getWebSpace() {
        return this.webSpace;
    }
    
    /**
    * Optional. Information about the web space to create.
    * @param webSpaceValue The WebSpace value.
    */
    public void setWebSpace(final WebSiteCreateParameters.WebSpaceDetails webSpaceValue) {
        this.webSpace = webSpaceValue;
    }
    
    /**
    * Initializes a new instance of the WebSiteCreateParameters class.
    *
    */
    public WebSiteCreateParameters() {
    }
    
    /**
    * Initializes a new instance of the WebSiteCreateParameters class with
    * required arguments.
    *
    * @param name The name of the web site. This should match the host name in
    * the default domain.
    * @param serverFarm The name of the Server Farm (Web Hosting Plan)
    * associated with this web site. This is a required value. Server Farm
    * must already exist.
    */
    public WebSiteCreateParameters(String name, String serverFarm) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (serverFarm == null) {
            throw new NullPointerException("serverFarm");
        }
        this.setName(name);
        this.setServerFarm(serverFarm);
    }
    
    /**
    * Information about the web space to create.
    */
    public static class WebSpaceDetails {
        private String geoRegion;
        
        /**
        * Required. The geographical region of the web space that will be
        * created.
        * @return The GeoRegion value.
        */
        public String getGeoRegion() {
            return this.geoRegion;
        }
        
        /**
        * Required. The geographical region of the web space that will be
        * created.
        * @param geoRegionValue The GeoRegion value.
        */
        public void setGeoRegion(final String geoRegionValue) {
            this.geoRegion = geoRegionValue;
        }
        
        private String name;
        
        /**
        * Required. The name of the web space.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Required. The name of the web space.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
        
        private String plan;
        
        /**
        * Required. The web space plan. This value must be VirtualDedicatedPlan.
        * @return The Plan value.
        */
        public String getPlan() {
            return this.plan;
        }
        
        /**
        * Required. The web space plan. This value must be VirtualDedicatedPlan.
        * @param planValue The Plan value.
        */
        public void setPlan(final String planValue) {
            this.plan = planValue;
        }
        
        /**
        * Initializes a new instance of the WebSpaceDetails class.
        *
        */
        public WebSpaceDetails() {
        }
        
        /**
        * Initializes a new instance of the WebSpaceDetails class with required
        * arguments.
        *
        * @param geoRegion The geographical region of the web space that will
        * be created.
        * @param name The name of the web space.
        * @param plan The web space plan. This value must be
        * VirtualDedicatedPlan.
        */
        public WebSpaceDetails(String geoRegion, String name, String plan) {
            if (geoRegion == null) {
                throw new NullPointerException("geoRegion");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (plan == null) {
                throw new NullPointerException("plan");
            }
            this.setGeoRegion(geoRegion);
            this.setName(name);
            this.setPlan(plan);
        }
    }
}
