/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites.models;

/**
* Parameters supplied to the Delete Web Site operation.
*/
public class WebSiteDeleteParameters {
    private boolean deleteAllSlots;
    
    /**
    * Required. Indicates if all slots for the web site should be deleted.
    * @return The DeleteAllSlots value.
    */
    public boolean isDeleteAllSlots() {
        return this.deleteAllSlots;
    }
    
    /**
    * Required. Indicates if all slots for the web site should be deleted.
    * @param deleteAllSlotsValue The DeleteAllSlots value.
    */
    public void setDeleteAllSlots(final boolean deleteAllSlotsValue) {
        this.deleteAllSlots = deleteAllSlotsValue;
    }
    
    private boolean deleteEmptyServerFarm;
    
    /**
    * Required. Indicates if the server farm should be deleted. You can delete
    * the server farm if the web site being deleted is the last web site in a
    * server farm.
    * @return The DeleteEmptyServerFarm value.
    */
    public boolean isDeleteEmptyServerFarm() {
        return this.deleteEmptyServerFarm;
    }
    
    /**
    * Required. Indicates if the server farm should be deleted. You can delete
    * the server farm if the web site being deleted is the last web site in a
    * server farm.
    * @param deleteEmptyServerFarmValue The DeleteEmptyServerFarm value.
    */
    public void setDeleteEmptyServerFarm(final boolean deleteEmptyServerFarmValue) {
        this.deleteEmptyServerFarm = deleteEmptyServerFarmValue;
    }
    
    private boolean deleteMetrics;
    
    /**
    * Required. Indicates if the metrics for the web site should be deleted.
    * @return The DeleteMetrics value.
    */
    public boolean isDeleteMetrics() {
        return this.deleteMetrics;
    }
    
    /**
    * Required. Indicates if the metrics for the web site should be deleted.
    * @param deleteMetricsValue The DeleteMetrics value.
    */
    public void setDeleteMetrics(final boolean deleteMetricsValue) {
        this.deleteMetrics = deleteMetricsValue;
    }
    
    /**
    * Initializes a new instance of the WebSiteDeleteParameters class.
    *
    */
    public WebSiteDeleteParameters() {
    }
    
    /**
    * Initializes a new instance of the WebSiteDeleteParameters class with
    * required arguments.
    *
    * @param deleteEmptyServerFarm Indicates if the server farm should be
    * deleted. You can delete the server farm if the web site being deleted is
    * the last web site in a server farm.
    * @param deleteMetrics Indicates if the metrics for the web site should be
    * deleted.
    * @param deleteAllSlots Indicates if all slots for the web site should be
    * deleted.
    */
    public WebSiteDeleteParameters(boolean deleteEmptyServerFarm, boolean deleteMetrics, boolean deleteAllSlots) {
        this.setDeleteEmptyServerFarm(deleteEmptyServerFarm);
        this.setDeleteMetrics(deleteMetrics);
        this.setDeleteAllSlots(deleteAllSlots);
    }
}
