/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* List of backups for the website.
*/
public class WebSiteGetBackupsResponse extends OperationResponse implements Iterable<BackupItem> {
    private ArrayList<BackupItem> backupItems;
    
    /**
    * Optional. Backups for a web site.
    * @return The BackupItems value.
    */
    public ArrayList<BackupItem> getBackupItems() {
        return this.backupItems;
    }
    
    /**
    * Optional. Backups for a web site.
    * @param backupItemsValue The BackupItems value.
    */
    public void setBackupItems(final ArrayList<BackupItem> backupItemsValue) {
        this.backupItems = backupItemsValue;
    }
    
    /**
    * Initializes a new instance of the WebSiteGetBackupsResponse class.
    *
    */
    public WebSiteGetBackupsResponse() {
        super();
        this.setBackupItems(new LazyArrayList<BackupItem>());
    }
    
    /**
    * Gets the sequence of BackupItems.
    *
    */
    public Iterator<BackupItem> iterator() {
        return this.getBackupItems().iterator();
    }
}
