/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.websites.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Calendar;

/**
* The response body contains the status of the specified long-running
* operation, indicating whether it has succeeded, is inprogress, has timed
* out, or has failed. Note that this status is distinct from the HTTP status
* code returned for the Get Operation Status operation itself. If the
* long-running operation failed, the response body includes error information
* regarding the failure.
*/
public class WebSiteOperationStatusResponse extends OperationResponse {
    private Calendar createdTime;
    
    /**
    * Optional. The time when the operation was created.
    * @return The CreatedTime value.
    */
    public Calendar getCreatedTime() {
        return this.createdTime;
    }
    
    /**
    * Optional. The time when the operation was created.
    * @param createdTimeValue The CreatedTime value.
    */
    public void setCreatedTime(final Calendar createdTimeValue) {
        this.createdTime = createdTimeValue;
    }
    
    private ArrayList<WebSiteOperationStatusResponse.Error> errors;
    
    /**
    * Optional. The list of errors that occurred during the operation.
    * @return The Errors value.
    */
    public ArrayList<WebSiteOperationStatusResponse.Error> getErrors() {
        return this.errors;
    }
    
    /**
    * Optional. The list of errors that occurred during the operation.
    * @param errorsValue The Errors value.
    */
    public void setErrors(final ArrayList<WebSiteOperationStatusResponse.Error> errorsValue) {
        this.errors = errorsValue;
    }
    
    private Calendar expirationTime;
    
    /**
    * Optional. The time when the operation will time out.
    * @return The ExpirationTime value.
    */
    public Calendar getExpirationTime() {
        return this.expirationTime;
    }
    
    /**
    * Optional. The time when the operation will time out.
    * @param expirationTimeValue The ExpirationTime value.
    */
    public void setExpirationTime(final Calendar expirationTimeValue) {
        this.expirationTime = expirationTimeValue;
    }
    
    private String geoMasterOperationId;
    
    /**
    * Optional. The GeoMaster Operation ID for this operation, if any.
    * @return The GeoMasterOperationId value.
    */
    public String getGeoMasterOperationId() {
        return this.geoMasterOperationId;
    }
    
    /**
    * Optional. The GeoMaster Operation ID for this operation, if any.
    * @param geoMasterOperationIdValue The GeoMasterOperationId value.
    */
    public void setGeoMasterOperationId(final String geoMasterOperationIdValue) {
        this.geoMasterOperationId = geoMasterOperationIdValue;
    }
    
    private Calendar modifiedTime;
    
    /**
    * Optional. The time when the operation was last modified.
    * @return The ModifiedTime value.
    */
    public Calendar getModifiedTime() {
        return this.modifiedTime;
    }
    
    /**
    * Optional. The time when the operation was last modified.
    * @param modifiedTimeValue The ModifiedTime value.
    */
    public void setModifiedTime(final Calendar modifiedTimeValue) {
        this.modifiedTime = modifiedTimeValue;
    }
    
    private String name;
    
    /**
    * Optional. The name of the operation.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. The name of the operation.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private String operationId;
    
    /**
    * Optional. The Operation ID for this operation. Used to poll for operation
    * status.
    * @return The OperationId value.
    */
    public String getOperationId() {
        return this.operationId;
    }
    
    /**
    * Optional. The Operation ID for this operation. Used to poll for operation
    * status.
    * @param operationIdValue The OperationId value.
    */
    public void setOperationId(final String operationIdValue) {
        this.operationId = operationIdValue;
    }
    
    private WebSiteOperationStatus status;
    
    /**
    * Optional. The status of the asynchronous operation.
    * @return The Status value.
    */
    public WebSiteOperationStatus getStatus() {
        return this.status;
    }
    
    /**
    * Optional. The status of the asynchronous operation.
    * @param statusValue The Status value.
    */
    public void setStatus(final WebSiteOperationStatus statusValue) {
        this.status = statusValue;
    }
    
    /**
    * Initializes a new instance of the WebSiteOperationStatusResponse class.
    *
    */
    public WebSiteOperationStatusResponse() {
        super();
        this.setErrors(new LazyArrayList<WebSiteOperationStatusResponse.Error>());
    }
    
    /**
    * Information about an error that occurred during the operation.
    */
    public static class Error {
        private String code;
        
        /**
        * Optional. The error code.
        * @return The Code value.
        */
        public String getCode() {
            return this.code;
        }
        
        /**
        * Optional. The error code.
        * @param codeValue The Code value.
        */
        public void setCode(final String codeValue) {
            this.code = codeValue;
        }
        
        private String extendedCode;
        
        /**
        * Optional. The extended error code.
        * @return The ExtendedCode value.
        */
        public String getExtendedCode() {
            return this.extendedCode;
        }
        
        /**
        * Optional. The extended error code.
        * @param extendedCodeValue The ExtendedCode value.
        */
        public void setExtendedCode(final String extendedCodeValue) {
            this.extendedCode = extendedCodeValue;
        }
        
        private String innerErrors;
        
        /**
        * Optional. The inner errors for this operation.
        * @return The InnerErrors value.
        */
        public String getInnerErrors() {
            return this.innerErrors;
        }
        
        /**
        * Optional. The inner errors for this operation.
        * @param innerErrorsValue The InnerErrors value.
        */
        public void setInnerErrors(final String innerErrorsValue) {
            this.innerErrors = innerErrorsValue;
        }
        
        private String message;
        
        /**
        * Optional. The error message.
        * @return The Message value.
        */
        public String getMessage() {
            return this.message;
        }
        
        /**
        * Optional. The error message.
        * @param messageValue The Message value.
        */
        public void setMessage(final String messageValue) {
            this.message = messageValue;
        }
        
        private String messageTemplate;
        
        /**
        * Optional. The message template.
        * @return The MessageTemplate value.
        */
        public String getMessageTemplate() {
            return this.messageTemplate;
        }
        
        /**
        * Optional. The message template.
        * @param messageTemplateValue The MessageTemplate value.
        */
        public void setMessageTemplate(final String messageTemplateValue) {
            this.messageTemplate = messageTemplateValue;
        }
        
        private ArrayList<String> parameters;
        
        /**
        * Optional. The parameters for the message template.
        * @return The Parameters value.
        */
        public ArrayList<String> getParameters() {
            return this.parameters;
        }
        
        /**
        * Optional. The parameters for the message template.
        * @param parametersValue The Parameters value.
        */
        public void setParameters(final ArrayList<String> parametersValue) {
            this.parameters = parametersValue;
        }
        
        /**
        * Initializes a new instance of the Error class.
        *
        */
        public Error() {
            this.setParameters(new LazyArrayList<String>());
        }
    }
}
