/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.models.LocationsListResponse;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.util.concurrent.Future;

/**
* The Service Management API includes operations for listing the available data
* center locations for a hosted service in your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/gg441299.aspx for more
* information)
*/
public interface LocationOperations {
    /**
    * The List Locations operation lists all of the data center locations that
    * are valid for your subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/gg441293.aspx for
    * more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The List Locations operation response.
    */
    LocationsListResponse list() throws IOException, ServiceException, ParserConfigurationException, SAXException;
    
    /**
    * The List Locations operation lists all of the data center locations that
    * are valid for your subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/gg441293.aspx for
    * more information)
    *
    * @return The List Locations operation response.
    */
    Future<LocationsListResponse> listAsync();
}
