/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.models.SubscriptionGetResponse;
import com.microsoft.windowsazure.management.models.SubscriptionListOperationsParameters;
import com.microsoft.windowsazure.management.models.SubscriptionListOperationsResponse;
import com.microsoft.windowsazure.management.models.SubscriptionStatus;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for listing subscription details.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/gg715315.aspx for more
* information)
*/
public class SubscriptionOperationsImpl implements ServiceOperations<ManagementClientImpl>, SubscriptionOperations {
    /**
    * Initializes a new instance of the SubscriptionOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    SubscriptionOperationsImpl(ManagementClientImpl client) {
        this.client = client;
    }
    
    private ManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.ManagementClientImpl.
    * @return The Client value.
    */
    public ManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Get Subscription operation returns account and resource allocation
    * information for the specified subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh403995.aspx for
    * more information)
    *
    * @return The Get Subscription operation response.
    */
    @Override
    public Future<SubscriptionGetResponse> getAsync() {
        return this.getClient().getExecutorService().submit(new Callable<SubscriptionGetResponse>() { 
            @Override
            public SubscriptionGetResponse call() throws Exception {
                return get();
            }
         });
    }
    
    /**
    * The Get Subscription operation returns account and resource allocation
    * information for the specified subscription.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh403995.aspx for
    * more information)
    *
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get Subscription operation response.
    */
    @Override
    public SubscriptionGetResponse get() throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SubscriptionGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubscriptionGetResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element subscriptionElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Subscription");
                if (subscriptionElement != null) {
                    Element subscriptionIDElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "SubscriptionID");
                    if (subscriptionIDElement != null) {
                        String subscriptionIDInstance;
                        subscriptionIDInstance = subscriptionIDElement.getTextContent();
                        result.setSubscriptionID(subscriptionIDInstance);
                    }
                    
                    Element subscriptionNameElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "SubscriptionName");
                    if (subscriptionNameElement != null) {
                        String subscriptionNameInstance;
                        subscriptionNameInstance = subscriptionNameElement.getTextContent();
                        result.setSubscriptionName(subscriptionNameInstance);
                    }
                    
                    Element subscriptionStatusElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "SubscriptionStatus");
                    if (subscriptionStatusElement != null && subscriptionStatusElement.getTextContent() != null && !subscriptionStatusElement.getTextContent().isEmpty()) {
                        SubscriptionStatus subscriptionStatusInstance;
                        subscriptionStatusInstance = SubscriptionStatus.valueOf(subscriptionStatusElement.getTextContent());
                        result.setSubscriptionStatus(subscriptionStatusInstance);
                    }
                    
                    Element accountAdminLiveEmailIdElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "AccountAdminLiveEmailId");
                    if (accountAdminLiveEmailIdElement != null) {
                        String accountAdminLiveEmailIdInstance;
                        accountAdminLiveEmailIdInstance = accountAdminLiveEmailIdElement.getTextContent();
                        result.setAccountAdminLiveEmailId(accountAdminLiveEmailIdInstance);
                    }
                    
                    Element serviceAdminLiveEmailIdElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "ServiceAdminLiveEmailId");
                    if (serviceAdminLiveEmailIdElement != null) {
                        String serviceAdminLiveEmailIdInstance;
                        serviceAdminLiveEmailIdInstance = serviceAdminLiveEmailIdElement.getTextContent();
                        result.setServiceAdminLiveEmailId(serviceAdminLiveEmailIdInstance);
                    }
                    
                    Element maxCoreCountElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "MaxCoreCount");
                    if (maxCoreCountElement != null) {
                        int maxCoreCountInstance;
                        maxCoreCountInstance = DatatypeConverter.parseInt(maxCoreCountElement.getTextContent());
                        result.setMaximumCoreCount(maxCoreCountInstance);
                    }
                    
                    Element maxStorageAccountsElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "MaxStorageAccounts");
                    if (maxStorageAccountsElement != null) {
                        int maxStorageAccountsInstance;
                        maxStorageAccountsInstance = DatatypeConverter.parseInt(maxStorageAccountsElement.getTextContent());
                        result.setMaximumStorageAccounts(maxStorageAccountsInstance);
                    }
                    
                    Element maxHostedServicesElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "MaxHostedServices");
                    if (maxHostedServicesElement != null) {
                        int maxHostedServicesInstance;
                        maxHostedServicesInstance = DatatypeConverter.parseInt(maxHostedServicesElement.getTextContent());
                        result.setMaximumHostedServices(maxHostedServicesInstance);
                    }
                    
                    Element currentCoreCountElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "CurrentCoreCount");
                    if (currentCoreCountElement != null) {
                        int currentCoreCountInstance;
                        currentCoreCountInstance = DatatypeConverter.parseInt(currentCoreCountElement.getTextContent());
                        result.setCurrentCoreCount(currentCoreCountInstance);
                    }
                    
                    Element currentStorageAccountsElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "CurrentStorageAccounts");
                    if (currentStorageAccountsElement != null) {
                        int currentStorageAccountsInstance;
                        currentStorageAccountsInstance = DatatypeConverter.parseInt(currentStorageAccountsElement.getTextContent());
                        result.setCurrentStorageAccounts(currentStorageAccountsInstance);
                    }
                    
                    Element currentHostedServicesElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "CurrentHostedServices");
                    if (currentHostedServicesElement != null) {
                        int currentHostedServicesInstance;
                        currentHostedServicesInstance = DatatypeConverter.parseInt(currentHostedServicesElement.getTextContent());
                        result.setCurrentHostedServices(currentHostedServicesInstance);
                    }
                    
                    Element maxVirtualNetworkSitesElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "MaxVirtualNetworkSites");
                    if (maxVirtualNetworkSitesElement != null) {
                        int maxVirtualNetworkSitesInstance;
                        maxVirtualNetworkSitesInstance = DatatypeConverter.parseInt(maxVirtualNetworkSitesElement.getTextContent());
                        result.setMaximumVirtualNetworkSites(maxVirtualNetworkSitesInstance);
                    }
                    
                    Element currentVirtualNetworkSitesElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "CurrentVirtualNetworkSites");
                    if (currentVirtualNetworkSitesElement != null) {
                        int currentVirtualNetworkSitesInstance;
                        currentVirtualNetworkSitesInstance = DatatypeConverter.parseInt(currentVirtualNetworkSitesElement.getTextContent());
                        result.setCurrentVirtualNetworkSites(currentVirtualNetworkSitesInstance);
                    }
                    
                    Element maxLocalNetworkSitesElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "MaxLocalNetworkSites");
                    if (maxLocalNetworkSitesElement != null) {
                        int maxLocalNetworkSitesInstance;
                        maxLocalNetworkSitesInstance = DatatypeConverter.parseInt(maxLocalNetworkSitesElement.getTextContent());
                        result.setMaximumLocalNetworkSites(maxLocalNetworkSitesInstance);
                    }
                    
                    Element maxDnsServersElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "MaxDnsServers");
                    if (maxDnsServersElement != null) {
                        int maxDnsServersInstance;
                        maxDnsServersInstance = DatatypeConverter.parseInt(maxDnsServersElement.getTextContent());
                        result.setMaximumDnsServers(maxDnsServersInstance);
                    }
                    
                    Element currentLocalNetworkSitesElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "CurrentLocalNetworkSites");
                    if (currentLocalNetworkSitesElement != null) {
                        int currentLocalNetworkSitesInstance;
                        currentLocalNetworkSitesInstance = DatatypeConverter.parseInt(currentLocalNetworkSitesElement.getTextContent());
                        result.setCurrentLocalNetworkSites(currentLocalNetworkSitesInstance);
                    }
                    
                    Element currentDnsServersElement = XmlUtility.getElementByTagNameNS(subscriptionElement, "http://schemas.microsoft.com/windowsazure", "CurrentDnsServers");
                    if (currentDnsServersElement != null) {
                        int currentDnsServersInstance;
                        currentDnsServersInstance = DatatypeConverter.parseInt(currentDnsServersElement.getTextContent());
                        result.setCurrentDnsServers(currentDnsServersInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The List Subscription Operations operation returns a list of create,
    * update, and delete operations that were performed on a subscription
    * during the specified timeframe.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/gg715318.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the List Subscription
    * Operations operation.
    * @return The List Subscription Operations operation response.
    */
    @Override
    public Future<SubscriptionListOperationsResponse> listOperationsAsync(final SubscriptionListOperationsParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<SubscriptionListOperationsResponse>() { 
            @Override
            public SubscriptionListOperationsResponse call() throws Exception {
                return listOperations(parameters);
            }
         });
    }
    
    /**
    * The List Subscription Operations operation returns a list of create,
    * update, and delete operations that were performed on a subscription
    * during the specified timeframe.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/gg715318.aspx for
    * more information)
    *
    * @param parameters Required. Parameters supplied to the List Subscription
    * Operations operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return The List Subscription Operations operation response.
    */
    @Override
    public SubscriptionListOperationsResponse listOperations(SubscriptionListOperationsParameters parameters) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listOperationsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/operations";
        ArrayList<String> queryParameters = new ArrayList<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("StartTime=" + URLEncoder.encode(simpleDateFormat.format(parameters.getStartTime().getTime()), "UTF-8"));
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        queryParameters.add("EndTime=" + URLEncoder.encode(simpleDateFormat2.format(parameters.getEndTime().getTime()), "UTF-8"));
        if (parameters.getObjectIdFilter() != null) {
            queryParameters.add("ObjectIdFilter=" + URLEncoder.encode(parameters.getObjectIdFilter(), "UTF-8"));
        }
        if (parameters.getOperationStatus() != null) {
            queryParameters.add("OperationResultFilter=" + URLEncoder.encode(parameters.getOperationStatus().toString(), "UTF-8"));
        }
        if (parameters.getContinuationToken() != null) {
            queryParameters.add("ContinuationToken=" + URLEncoder.encode(parameters.getContinuationToken(), "UTF-8"));
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            SubscriptionListOperationsResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new SubscriptionListOperationsResponse();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
                
                Element subscriptionOperationCollectionElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "SubscriptionOperationCollection");
                if (subscriptionOperationCollectionElement != null) {
                    Element continuationTokenElement = XmlUtility.getElementByTagNameNS(subscriptionOperationCollectionElement, "http://schemas.microsoft.com/windowsazure", "ContinuationToken");
                    if (continuationTokenElement != null) {
                        String continuationTokenInstance;
                        continuationTokenInstance = continuationTokenElement.getTextContent();
                        result.setContinuationToken(continuationTokenInstance);
                    }
                    
                    Element subscriptionOperationsSequenceElement = XmlUtility.getElementByTagNameNS(subscriptionOperationCollectionElement, "http://schemas.microsoft.com/windowsazure", "SubscriptionOperations");
                    if (subscriptionOperationsSequenceElement != null) {
                        for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subscriptionOperationsSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubscriptionOperation").size(); i1 = i1 + 1) {
                            org.w3c.dom.Element subscriptionOperationsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subscriptionOperationsSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubscriptionOperation").get(i1));
                            SubscriptionListOperationsResponse.SubscriptionOperation subscriptionOperationInstance = new SubscriptionListOperationsResponse.SubscriptionOperation();
                            result.getSubscriptionOperations().add(subscriptionOperationInstance);
                            
                            Element operationIdElement = XmlUtility.getElementByTagNameNS(subscriptionOperationsElement, "http://schemas.microsoft.com/windowsazure", "OperationId");
                            if (operationIdElement != null) {
                                String operationIdInstance;
                                operationIdInstance = operationIdElement.getTextContent();
                                subscriptionOperationInstance.setOperationId(operationIdInstance);
                            }
                            
                            Element operationObjectIdElement = XmlUtility.getElementByTagNameNS(subscriptionOperationsElement, "http://schemas.microsoft.com/windowsazure", "OperationObjectId");
                            if (operationObjectIdElement != null) {
                                String operationObjectIdInstance;
                                operationObjectIdInstance = operationObjectIdElement.getTextContent();
                                subscriptionOperationInstance.setOperationObjectId(operationObjectIdInstance);
                            }
                            
                            Element operationNameElement = XmlUtility.getElementByTagNameNS(subscriptionOperationsElement, "http://schemas.microsoft.com/windowsazure", "OperationName");
                            if (operationNameElement != null) {
                                String operationNameInstance;
                                operationNameInstance = operationNameElement.getTextContent();
                                subscriptionOperationInstance.setOperationName(operationNameInstance);
                            }
                            
                            Element operationParametersSequenceElement = XmlUtility.getElementByTagNameNS(subscriptionOperationsElement, "http://schemas.microsoft.com/windowsazure", "OperationParameters");
                            if (operationParametersSequenceElement != null) {
                                for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(operationParametersSequenceElement, "http://schemas.microsoft.com/windowsazure", "OperationParameter").size(); i2 = i2 + 1) {
                                    org.w3c.dom.Element operationParametersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(operationParametersSequenceElement, "http://schemas.microsoft.com/windowsazure", "OperationParameter").get(i2));
                                    String operationParametersKey = XmlUtility.getElementByTagNameNS(operationParametersElement, "http://schemas.datacontract.org/2004/07/Microsoft.WindowsAzure.ServiceManagement", "Name").getTextContent();
                                    String operationParametersValue = XmlUtility.getElementByTagNameNS(operationParametersElement, "http://schemas.datacontract.org/2004/07/Microsoft.WindowsAzure.ServiceManagement", "Value").getTextContent();
                                    subscriptionOperationInstance.getOperationParameters().put(operationParametersKey, operationParametersValue);
                                }
                            }
                            
                            Element operationCallerElement = XmlUtility.getElementByTagNameNS(subscriptionOperationsElement, "http://schemas.microsoft.com/windowsazure", "OperationCaller");
                            if (operationCallerElement != null) {
                                SubscriptionListOperationsResponse.OperationCallerDetails operationCallerInstance = new SubscriptionListOperationsResponse.OperationCallerDetails();
                                subscriptionOperationInstance.setOperationCaller(operationCallerInstance);
                                
                                Element usedServiceManagementApiElement = XmlUtility.getElementByTagNameNS(operationCallerElement, "http://schemas.microsoft.com/windowsazure", "UsedServiceManagementApi");
                                if (usedServiceManagementApiElement != null) {
                                    boolean usedServiceManagementApiInstance;
                                    usedServiceManagementApiInstance = DatatypeConverter.parseBoolean(usedServiceManagementApiElement.getTextContent().toLowerCase());
                                    operationCallerInstance.setUsedServiceManagementApi(usedServiceManagementApiInstance);
                                }
                                
                                Element userEmailAddressElement = XmlUtility.getElementByTagNameNS(operationCallerElement, "http://schemas.microsoft.com/windowsazure", "UserEmailAddress");
                                if (userEmailAddressElement != null) {
                                    String userEmailAddressInstance;
                                    userEmailAddressInstance = userEmailAddressElement.getTextContent();
                                    operationCallerInstance.setUserEmailAddress(userEmailAddressInstance);
                                }
                                
                                Element subscriptionCertificateThumbprintElement = XmlUtility.getElementByTagNameNS(operationCallerElement, "http://schemas.microsoft.com/windowsazure", "SubscriptionCertificateThumbprint");
                                if (subscriptionCertificateThumbprintElement != null) {
                                    String subscriptionCertificateThumbprintInstance;
                                    subscriptionCertificateThumbprintInstance = subscriptionCertificateThumbprintElement.getTextContent();
                                    operationCallerInstance.setSubscriptionCertificateThumbprint(subscriptionCertificateThumbprintInstance);
                                }
                                
                                Element clientIPElement = XmlUtility.getElementByTagNameNS(operationCallerElement, "http://schemas.microsoft.com/windowsazure", "ClientIP");
                                if (clientIPElement != null) {
                                    InetAddress clientIPInstance;
                                    clientIPInstance = InetAddress.getByName(clientIPElement.getTextContent());
                                    operationCallerInstance.setClientIPAddress(clientIPInstance);
                                }
                            }
                            
                            Element operationStatusElement = XmlUtility.getElementByTagNameNS(subscriptionOperationsElement, "http://schemas.microsoft.com/windowsazure", "OperationStatus");
                            if (operationStatusElement != null) {
                                String operationStatusInstance;
                                operationStatusInstance = operationStatusElement.getTextContent();
                                subscriptionOperationInstance.setOperationStatus(operationStatusInstance);
                            }
                            
                            Element operationStartedTimeElement = XmlUtility.getElementByTagNameNS(subscriptionOperationsElement, "http://schemas.microsoft.com/windowsazure", "OperationStartedTime");
                            if (operationStartedTimeElement != null) {
                                Calendar operationStartedTimeInstance;
                                operationStartedTimeInstance = DatatypeConverter.parseDateTime(operationStartedTimeElement.getTextContent());
                                subscriptionOperationInstance.setOperationStartedTime(operationStartedTimeInstance);
                            }
                            
                            Element operationCompletedTimeElement = XmlUtility.getElementByTagNameNS(subscriptionOperationsElement, "http://schemas.microsoft.com/windowsazure", "OperationCompletedTime");
                            if (operationCompletedTimeElement != null) {
                                Calendar operationCompletedTimeInstance;
                                operationCompletedTimeInstance = DatatypeConverter.parseDateTime(operationCompletedTimeElement.getTextContent());
                                subscriptionOperationInstance.setOperationCompletedTime(operationCompletedTimeInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Register a resource with your subscription.
    *
    * @param resourceName Required. Name of the resource to register.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> registerResourceAsync(final String resourceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return registerResource(resourceName);
            }
         });
    }
    
    /**
    * Register a resource with your subscription.
    *
    * @param resourceName Required. Name of the resource to register.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse registerResource(String resourceName) throws IOException, ServiceException {
        // Validate
        if (resourceName == null) {
            throw new NullPointerException("resourceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceName", resourceName);
            CloudTracing.enter(invocationId, this, "registerResourceAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("service=" + URLEncoder.encode(resourceName, "UTF-8"));
        queryParameters.add("action=register");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Unregister a resource with your subscription.
    *
    * @param resourceName Required. Name of the resource to unregister.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> unregisterResourceAsync(final String resourceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return unregisterResource(resourceName);
            }
         });
    }
    
    /**
    * Unregister a resource with your subscription.
    *
    * @param resourceName Required. Name of the resource to unregister.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse unregisterResource(String resourceName) throws IOException, ServiceException {
        // Validate
        if (resourceName == null) {
            throw new NullPointerException("resourceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceName", resourceName);
            CloudTracing.enter(invocationId, this, "unregisterResourceAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/services";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("service=" + URLEncoder.encode(resourceName, "UTF-8"));
        queryParameters.add("action=unregister");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
