/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;
import java.util.Iterator;

/**
* The List Role Sizes operation response.
*/
public class RoleSizeListResponse extends OperationResponse implements Iterable<RoleSizeListResponse.RoleSize> {
    private ArrayList<RoleSizeListResponse.RoleSize> roleSizes;
    
    /**
    * Optional. The role sizes that are valid for your subscription.
    * @return The RoleSizes value.
    */
    public ArrayList<RoleSizeListResponse.RoleSize> getRoleSizes() {
        return this.roleSizes;
    }
    
    /**
    * Optional. The role sizes that are valid for your subscription.
    * @param roleSizesValue The RoleSizes value.
    */
    public void setRoleSizes(final ArrayList<RoleSizeListResponse.RoleSize> roleSizesValue) {
        this.roleSizes = roleSizesValue;
    }
    
    /**
    * Initializes a new instance of the RoleSizeListResponse class.
    *
    */
    public RoleSizeListResponse() {
        super();
        this.setRoleSizes(new LazyArrayList<RoleSizeListResponse.RoleSize>());
    }
    
    /**
    * Gets the sequence of RoleSizes.
    *
    */
    public Iterator<RoleSizeListResponse.RoleSize> iterator() {
        return this.getRoleSizes().iterator();
    }
    
    /**
    * A role size that is valid for your subscription.
    */
    public static class RoleSize {
        private int cores;
        
        /**
        * Optional. Number of cores available for the role size.
        * @return The Cores value.
        */
        public int getCores() {
            return this.cores;
        }
        
        /**
        * Optional. Number of cores available for the role size.
        * @param coresValue The Cores value.
        */
        public void setCores(final int coresValue) {
            this.cores = coresValue;
        }
        
        private String label;
        
        /**
        * Optional. Localized label of the role size.
        * @return The Label value.
        */
        public String getLabel() {
            return this.label;
        }
        
        /**
        * Optional. Localized label of the role size.
        * @param labelValue The Label value.
        */
        public void setLabel(final String labelValue) {
            this.label = labelValue;
        }
        
        private int maxDataDiskCount;
        
        /**
        * Optional. Number of data disks that can be attached for the given
        * role size.
        * @return The MaxDataDiskCount value.
        */
        public int getMaxDataDiskCount() {
            return this.maxDataDiskCount;
        }
        
        /**
        * Optional. Number of data disks that can be attached for the given
        * role size.
        * @param maxDataDiskCountValue The MaxDataDiskCount value.
        */
        public void setMaxDataDiskCount(final int maxDataDiskCountValue) {
            this.maxDataDiskCount = maxDataDiskCountValue;
        }
        
        private int memoryInMb;
        
        /**
        * Optional. Memory available for the role size.
        * @return The MemoryInMb value.
        */
        public int getMemoryInMb() {
            return this.memoryInMb;
        }
        
        /**
        * Optional. Memory available for the role size.
        * @param memoryInMbValue The MemoryInMb value.
        */
        public void setMemoryInMb(final int memoryInMbValue) {
            this.memoryInMb = memoryInMbValue;
        }
        
        private String name;
        
        /**
        * Optional. The name of a role size that is valid for your subscription.
        * @return The Name value.
        */
        public String getName() {
            return this.name;
        }
        
        /**
        * Optional. The name of a role size that is valid for your subscription.
        * @param nameValue The Name value.
        */
        public void setName(final String nameValue) {
            this.name = nameValue;
        }
        
        private boolean supportedByVirtualMachines;
        
        /**
        * Optional. Indicating if the role size is supported by VMs.
        * @return The SupportedByVirtualMachines value.
        */
        public boolean isSupportedByVirtualMachines() {
            return this.supportedByVirtualMachines;
        }
        
        /**
        * Optional. Indicating if the role size is supported by VMs.
        * @param supportedByVirtualMachinesValue The SupportedByVirtualMachines
        * value.
        */
        public void setSupportedByVirtualMachines(final boolean supportedByVirtualMachinesValue) {
            this.supportedByVirtualMachines = supportedByVirtualMachinesValue;
        }
        
        private boolean supportedByWebWorkerRoles;
        
        /**
        * Optional. Indicating if the role size is supported by web/worker
        * roles.
        * @return The SupportedByWebWorkerRoles value.
        */
        public boolean isSupportedByWebWorkerRoles() {
            return this.supportedByWebWorkerRoles;
        }
        
        /**
        * Optional. Indicating if the role size is supported by web/worker
        * roles.
        * @param supportedByWebWorkerRolesValue The SupportedByWebWorkerRoles
        * value.
        */
        public void setSupportedByWebWorkerRoles(final boolean supportedByWebWorkerRolesValue) {
            this.supportedByWebWorkerRoles = supportedByWebWorkerRolesValue;
        }
        
        private int virtualMachineResourceDiskSizeInMb;
        
        /**
        * Optional. Resource disk drive size for the role size in IaaS
        * deployment.
        * @return The VirtualMachineResourceDiskSizeInMb value.
        */
        public int getVirtualMachineResourceDiskSizeInMb() {
            return this.virtualMachineResourceDiskSizeInMb;
        }
        
        /**
        * Optional. Resource disk drive size for the role size in IaaS
        * deployment.
        * @param virtualMachineResourceDiskSizeInMbValue The
        * VirtualMachineResourceDiskSizeInMb value.
        */
        public void setVirtualMachineResourceDiskSizeInMb(final int virtualMachineResourceDiskSizeInMbValue) {
            this.virtualMachineResourceDiskSizeInMb = virtualMachineResourceDiskSizeInMbValue;
        }
        
        private int webWorkerResourceDiskSizeInMb;
        
        /**
        * Optional. Resource disk drive size for the role size in PaaS
        * deployment.
        * @return The WebWorkerResourceDiskSizeInMb value.
        */
        public int getWebWorkerResourceDiskSizeInMb() {
            return this.webWorkerResourceDiskSizeInMb;
        }
        
        /**
        * Optional. Resource disk drive size for the role size in PaaS
        * deployment.
        * @param webWorkerResourceDiskSizeInMbValue The
        * WebWorkerResourceDiskSizeInMb value.
        */
        public void setWebWorkerResourceDiskSizeInMb(final int webWorkerResourceDiskSizeInMbValue) {
            this.webWorkerResourceDiskSizeInMb = webWorkerResourceDiskSizeInMbValue;
        }
    }
}
