/**
 * Copyright Microsoft Corporation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.microsoft.windowsazure.management;

import com.microsoft.windowsazure.management.models.ManagementCertificateGetResponse;
import com.microsoft.windowsazure.management.models.ManagementCertificateListResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import java.util.ArrayList;

public class ManagementCertificateOperationsTests extends ManagementIntegrationTestBase {
    @BeforeClass
    public static void setup() throws Exception {
        createService();
    }
    
    @Before
    public void beforeTest() throws Exception {
        setupTest();
    }
    
    @After
    public void afterTest() throws Exception {
        resetTest();
    }


    @Test
    public void getManagementCertificateSuccess() throws Exception {
        // arrange
        ManagementCertificateListResponse managementCertificateListResponse = managementClient.getManagementCertificatesOperations().list();
        ArrayList<ManagementCertificateListResponse.SubscriptionCertificate> managementCertificatelist = managementCertificateListResponse.getSubscriptionCertificates();

        if (managementCertificatelist.size() > 0) {
            String thumbprint = managementCertificatelist.get(0).getThumbprint();

            ManagementCertificateGetResponse managementCertificateResponse = managementClient.getManagementCertificatesOperations().get(thumbprint);

            // Assert
            Assert.assertEquals(200, managementCertificateResponse.getStatusCode());
            Assert.assertNotNull(managementCertificateResponse.getRequestId());
            Assert.assertEquals(thumbprint, managementCertificateResponse.getThumbprint());
        }
    }

    @Test
    public void listManagementCertificateSuccess() throws Exception {
        // Arrange  
        ManagementCertificateListResponse managementCertificateListResponse = managementClient.getManagementCertificatesOperations().list();
        ArrayList<ManagementCertificateListResponse.SubscriptionCertificate> managementCertificatelist = managementCertificateListResponse.getSubscriptionCertificates();

        Assert.assertNotNull(managementCertificatelist);
    }
}
