/**
 *
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

// Warning: This code was generated by a tool.
//
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.keyvault;

import java.net.URI;
import java.util.concurrent.ExecutorService;

import javax.inject.Inject;
import javax.inject.Named;

import org.apache.http.impl.client.HttpClientBuilder;

import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;

class KeyVaultInternalClientImpl extends ServiceClient<KeyVaultInternalClient>implements KeyVaultInternalClient {
    private String apiVersion;

    /**
     * Gets the API version.
     *
     * @return The ApiVersion value.
     */
    @Override
    public String getApiVersion() {
        return apiVersion;
    }

    private URI baseUri;

    /**
     * Gets the URI used as the base for all cloud service requests.
     *
     * @return The BaseUri value.
     */
    @Override
    public URI getBaseUri() {
        return baseUri;
    }

    private CloudCredentials credentials;

    /**
     * Gets or sets the credential
     *
     * @return The Credentials value.
     */
    @Override
    public CloudCredentials getCredentials() {
        return credentials;
    }

    /**
     * Gets or sets the credential
     *
     * @param credentialsValue
     *            The Credentials value.
     */
    @Override
    public void setCredentials(final CloudCredentials credentialsValue) {
        credentials = credentialsValue;
    }

    private int longRunningOperationInitialTimeout;

    /**
     * Gets or sets the initial timeout for Long Running Operations.
     *
     * @return The LongRunningOperationInitialTimeout value.
     */
    @Override
    public int getLongRunningOperationInitialTimeout() {
        return longRunningOperationInitialTimeout;
    }

    /**
     * Gets or sets the initial timeout for Long Running Operations.
     *
     * @param longRunningOperationInitialTimeoutValue
     *            The LongRunningOperationInitialTimeout value.
     */
    @Override
    public void setLongRunningOperationInitialTimeout(final int longRunningOperationInitialTimeoutValue) {
        longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }

    private int longRunningOperationRetryTimeout;

    /**
     * Gets or sets the retry timeout for Long Running Operations.
     *
     * @return The LongRunningOperationRetryTimeout value.
     */
    @Override
    public int getLongRunningOperationRetryTimeout() {
        return longRunningOperationRetryTimeout;
    }

    /**
     * Gets or sets the retry timeout for Long Running Operations.
     *
     * @param longRunningOperationRetryTimeoutValue
     *            The LongRunningOperationRetryTimeout value.
     */
    @Override
    public void setLongRunningOperationRetryTimeout(final int longRunningOperationRetryTimeoutValue) {
        longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }

    private KeyOperations keys;

    /**
     * Cryptographic and management operations for keys in a vault
     *
     * @return The KeysOperations value.
     */
    @Override
    public KeyOperations getKeysOperations() {
        return keys;
    }

    private SecretOperations secrets;

    /**
     * Operations for secrets in a vault
     *
     * @return The SecretsOperations value.
     */
    @Override
    public SecretOperations getSecretsOperations() {
        return secrets;
    }

    /**
     * Initializes a new instance of the KeyVaultInternalClientImpl class.
     *
     * @param httpBuilder
     *            The HTTP client builder.
     * @param executorService
     *            The executor service.
     */
    public KeyVaultInternalClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
        keys = new KeyOperationsImpl(this);
        secrets = new SecretOperationsImpl(this);
        apiVersion = "2015-06-01";
        longRunningOperationInitialTimeout = -1;
        longRunningOperationRetryTimeout = -1;
    }

    /**
     * Initializes a new instance of the KeyVaultInternalClientImpl class.
     *
     * @param httpBuilder
     *            The HTTP client builder.
     * @param executorService
     *            The executor service.
     * @param credentials
     *            Required. Gets or sets the credential
     * @param baseUri
     *            Optional. Gets the URI used as the base for all cloud service
     *            requests.
     */
    @Inject
    public KeyVaultInternalClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(ManagementConfiguration.SUBSCRIPTION_CLOUD_CREDENTIALS) CloudCredentials credentials, @Named(ManagementConfiguration.URI) URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        } else {
            this.credentials = credentials;
        }
        this.baseUri = baseUri;
    }

    /**
     * Initializes a new instance of the KeyVaultInternalClientImpl class.
     *
     * @param httpBuilder
     *            The HTTP client builder.
     * @param executorService
     *            The executor service.
     * @param credentials
     *            Required. Gets or sets the credential
     */
    public KeyVaultInternalClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, CloudCredentials credentials) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        baseUri = null;
    }

    /**
     * Initializes a new instance of the KeyVaultInternalClientImpl class.
     *
     * @param httpBuilder
     *            The HTTP client builder.
     * @param executorService
     *            The executor service.
     * @param credentials
     *            Required. Gets or sets the credential
     * @param baseUri
     *            Optional. Gets the URI used as the base for all cloud service
     *            requests.
     * @param apiVersion
     *            Optional. Gets the API version.
     * @param longRunningOperationInitialTimeout
     *            Required. Gets or sets the initial timeout for Long Running
     *            Operations.
     * @param longRunningOperationRetryTimeout
     *            Required. Gets or sets the retry timeout for Long Running
     *            Operations.
     */
    public KeyVaultInternalClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, CloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    /**
     * Initializes a new instance of the KeyVaultInternalClientImpl class.
     *
     * @param httpBuilder
     *            The HTTP client builder.
     * @param executorService
     *            The executor service.
     */
    @Override
    protected KeyVaultInternalClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new KeyVaultInternalClientImpl(httpBuilder, executorService, getCredentials(), getBaseUri(), getApiVersion(), getLongRunningOperationInitialTimeout(), getLongRunningOperationRetryTimeout());
    }
}
