(module
  ;; Test that we can use the empty string as a symbol.
  (func (export "") (result i32) (i32.const 0))

  ;; Test that we can use names beginning with a digit.
  (func (export "0") (result i32) (i32.const 1))

  ;; Test that we can use names beginning with a dash.
  (func (export "-0") (result i32) (i32.const 2))

  ;; Test that we can use names beginning with an underscore.
  (func (export "_") (result i32) (i32.const 3))

  ;; Test that we can use names beginning with a dollar sign.
  (func (export "$") (result i32) (i32.const 4))

  ;; Test that we can use names beginning with an at sign.
  (func (export "@") (result i32) (i32.const 5))

  ;; Test that we can use non-alphanumeric names.
  (func (export "~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./ ") (result i32) (i32.const 6))

  ;; Test that we can use names that have special meaning in JS.
  (func (export "NaN") (result i32) (i32.const 7))
  (func (export "Infinity") (result i32) (i32.const 8))
  (func (export "if") (result i32) (i32.const 9))

  ;; Test that we can use common libc names without conflict.
  (func (export "malloc") (result i32) (i32.const 10))

  ;; Test that we can use some libc hidden names without conflict.
  (func (export "_malloc") (result i32) (i32.const 11))
  (func (export "__malloc") (result i32) (i32.const 12))

  ;; Test that names are case-sensitive.
  (func (export "a") (result i32) (i32.const 13))
  (func (export "A") (result i32) (i32.const 14))

  ;; Test that UTF-8 BOM code points can appear in identifiers.
  (func (export "﻿") (result i32) (i32.const 15))

  ;; Test that Unicode normalization is not applied. These function names
  ;; contain different codepoints which normalize to the same thing under
  ;; NFC or NFD.
  (func (export "Å") (result i32) (i32.const 16))
  (func (export "Å") (result i32) (i32.const 17))
  (func (export "Å") (result i32) (i32.const 18))

  ;; Test that Unicode compatibility normalization is not applied. These
  ;; function names contain different codepoints which normalize to the
  ;; same thing under NFKC or NFKD.
  (func (export "ﬃ") (result i32) (i32.const 19))
  (func (export "fﬁ") (result i32) (i32.const 20))
  (func (export "ffi") (result i32) (i32.const 21))

  ;; Test the C0 control codes.
  (func (export "\00\01\02\03\04\05\06\07\08\09\0a\0b\0c\0d\0e\0f") (result i32) (i32.const 22))
  (func (export "\10\11\12\13\14\15\16\17\18\19\1a\1b\1c\1d\1e\1f") (result i32) (i32.const 23))
  ;; Test miscellaneous control codes.
  (func (export " \7f") (result i32) (i32.const 24))
  ;; Test the C1 control codes.
  (func (export "\c2\80\c2\81\c2\82\c2\83\c2\84\c2\85\c2\86\c2\87\c2\88\c2\89\c2\8a\c2\8b\c2\8c\c2\8d\c2\8e\c2\8f") (result i32) (i32.const 25))
  (func (export "\c2\90\c2\91\c2\92\c2\93\c2\94\c2\95\c2\96\c2\97\c2\98\c2\99\c2\9a\c2\9b\c2\9c\c2\9d\c2\9e\c2\9f") (result i32) (i32.const 26))
  ;; Test the Unicode Specials.
  (func (export "\ef\bf\b0\ef\bf\b1\ef\bf\b2\ef\bf\b3\ef\bf\b4\ef\bf\b5\ef\bf\b6\ef\bf\b7") (result i32) (i32.const 27))
  (func (export "\ef\bf\b8\ef\bf\b9\ef\bf\ba\ef\bf\bb\ef\bf\bc\ef\bf\bd\ef\bf\be\ef\bf\bf") (result i32) (i32.const 28))

  ;; Test that the control pictures are distinct from the control codes they
  ;; depict. These correspond to the C0 and miscellaneous control code tests
  ;; above.
  (func (export "␀␁␂␃␄␅␆␇␈␉␊␋␌␍␎␏") (result i32) (i32.const 29))
  (func (export "␐␑␒␓␔␕␖␗␘␙␚␛␜␝␞␟") (result i32) (i32.const 30))
  (func (export "␠␡") (result i32) (i32.const 31))

  ;; Test the Unicode Specials in non-escaped form (excluding U+FFFE and
  ;; U+FFFF, so that generic tools don't detect this file as non-UTF-8).
  (func (export "￰￱￲￳￴￵￶￷￸￹￺￻￼�") (result i32) (i32.const 32))

  ;; Test a bare ZWJ code point.
  (func (export "‍") (result i32) (i32.const 33))
  ;; Test a bare ZWNJ code point.
  (func (export "‌") (result i32) (i32.const 34))

  ;; Test various bare joiner code points.
  (func (export "͏") (result i32) (i32.const 35))
  (func (export "⁠") (result i32) (i32.const 36))
  (func (export "⵿") (result i32) (i32.const 37))
  (func (export "𑁿") (result i32) (i32.const 38))
  (func (export "᠎") (result i32) (i32.const 39))

  ;; Test various interesting code points: reverse BOM, zero-width space,
  ;; no-break space, soft hyphen, word joiner, ogham space mark,
  ;; right-to-left override, left-to-right override.
  (func (export "￯​ ­⁠ ‮‭") (result i32) (i32.const 40))

  ;; Test more interesting code points: left-to-right mark, right-to-left mark,
  ;; non-breaking hyphen, line separator, paragraph separator,
  ;; left-to-right embedding, right-to-left embedding,
  ;; pop directional formatting, narrow no-break space, left-to-right isolate,
  ;; right-to-left isolate, first strong isolate, pop directional isolate.
  (func (export "‎‏‑  ‪‫‬ ⁦⁧⁨⁩") (result i32) (i32.const 41))

  ;; Test some deprecated code points: inhibit symmetric swapping,
  ;; activate symmetric swapping, inhibit arabic form shaping,
  ;; activate arabic form shaping, national digit shapes, nominal digit shapes.
  (func (export "⁪⁫⁬⁭⁮⁯") (result i32) (i32.const 42))

  ;; Test "invisible" operator code points.
  (func (export "⁡⁢⁣⁤") (result i32) (i32.const 43))

  ;; Test that code points outside the BMP are supported.
  (func (export "𐀀󟿿􏿿") (result i32) (i32.const 44))

  ;; Test that WebAssembly implementations cope in the presence of Zalgo.
  (func (export "Z̴͇̫̥̪͓͈͔͎̗̞̺̯̱̞̙̱̜̖̠̏͆̆͛͌͘͞ḁ̶̰̳̭͙̲̱̹̝͎̼͗ͨ̎̄̆͗̿̀́͟͡l̶̷͉̩̹̫̝͖̙̲̼͇͚͍̮͎̥̞̈́͊͗ͦ̈́ͫ̇́̚ͅͅg̶͕͔͚̩̓̐̅ͮ̔̐̎̂̏̾͊̍͋͊ͧ́̆ͦ͞o̡͋̔͐ͪͩ͏̢̧̫̙̤̮͖͙͓̺̜̩̼̘̠́") (result i32) (i32.const 45))

  ;; Test Hangul filler code points.
  (func (export "ᅟᅠㅤﾠ") (result i32) (i32.const 46))

  ;; Test variation selectors (which are also ID_Continue code points).
  (func (export "︀") (result i32) (i32.const 47))
  (func (export "︄") (result i32) (i32.const 48))
  (func (export "󠄀") (result i32) (i32.const 49))
  (func (export "󠇯") (result i32) (i32.const 50))

  ;; Test an uncombined combining code point.
  (func (export "̈") (result i32) (i32.const 51))

  ;; Test that numerous different present and historical representations of the
  ;; "newline" concept are distinct. Tests largely inspired by:
  ;;   https://en.wikipedia.org/wiki/Newline#Representations
  ;;   https://en.wikipedia.org/wiki/Newline#Unicode and
  ;;   https://en.wikipedia.org/wiki/Newline#Reverse_and_partial_line_feeds
  (func (export "\0a") (result i32) (i32.const 52))
  (func (export "␤") (result i32) (i32.const 53))
  (func (export " ") (result i32) (i32.const 54))
  (func (export "\0d") (result i32) (i32.const 55))
  (func (export "\0d\0a") (result i32) (i32.const 56))
  (func (export "\0a\0d") (result i32) (i32.const 57))
  (func (export "\1e") (result i32) (i32.const 58))
  (func (export "\0b") (result i32) (i32.const 59))
  (func (export "\0c") (result i32) (i32.const 60))
  (func (export "\c2\85") (result i32) (i32.const 61))
  (func (export " ") (result i32) (i32.const 62))
  (func (export "…") (result i32) (i32.const 63))
  (func (export "⏎") (result i32) (i32.const 64))
  (func (export "\c2\8b") (result i32) (i32.const 65))
  (func (export "\c2\8c") (result i32) (i32.const 66))
  (func (export "\c2\8d") (result i32) (i32.const 67))
  (func (export "↵") (result i32) (i32.const 68))
  (func (export "↩") (result i32) (i32.const 69))
  (func (export "⌤") (result i32) (i32.const 70))
  (func (export "⤶") (result i32) (i32.const 71))
  (func (export "↲") (result i32) (i32.const 72))
  (func (export "⮨") (result i32) (i32.const 73))
  (func (export "⮰") (result i32) (i32.const 74))

  ;; Test that non-characters are not replaced by the replacement character.
  (func (export "�") (result i32) (i32.const 75))
  (func (export "\ef\b7\90") (result i32) (i32.const 76))
  (func (export "\ef\b7\91") (result i32) (i32.const 77))
  (func (export "\ef\b7\92") (result i32) (i32.const 78))
  (func (export "\ef\b7\93") (result i32) (i32.const 79))
  (func (export "\ef\b7\94") (result i32) (i32.const 80))
  (func (export "\ef\b7\95") (result i32) (i32.const 81))
  (func (export "\ef\b7\96") (result i32) (i32.const 82))
  (func (export "\ef\b7\97") (result i32) (i32.const 83))
  (func (export "\ef\b7\98") (result i32) (i32.const 84))
  (func (export "\ef\b7\99") (result i32) (i32.const 85))
  (func (export "\ef\b7\9a") (result i32) (i32.const 86))
  (func (export "\ef\b7\9b") (result i32) (i32.const 87))
  (func (export "\ef\b7\9c") (result i32) (i32.const 88))
  (func (export "\ef\b7\9d") (result i32) (i32.const 89))
  (func (export "\ef\b7\9e") (result i32) (i32.const 90))
  (func (export "\ef\b7\9f") (result i32) (i32.const 91))
  (func (export "\ef\b7\a0") (result i32) (i32.const 92))
  (func (export "\ef\b7\a1") (result i32) (i32.const 93))
  (func (export "\ef\b7\a2") (result i32) (i32.const 94))
  (func (export "\ef\b7\a3") (result i32) (i32.const 95))
  (func (export "\ef\b7\a4") (result i32) (i32.const 96))
  (func (export "\ef\b7\a5") (result i32) (i32.const 97))
  (func (export "\ef\b7\a6") (result i32) (i32.const 98))
  (func (export "\ef\b7\a7") (result i32) (i32.const 99))
  (func (export "\ef\b7\a8") (result i32) (i32.const 100))
  (func (export "\ef\b7\a9") (result i32) (i32.const 101))
  (func (export "\ef\b7\aa") (result i32) (i32.const 102))
  (func (export "\ef\b7\ab") (result i32) (i32.const 103))
  (func (export "\ef\b7\ac") (result i32) (i32.const 104))
  (func (export "\ef\b7\ad") (result i32) (i32.const 105))
  (func (export "\ef\b7\ae") (result i32) (i32.const 106))
  (func (export "\ef\b7\af") (result i32) (i32.const 107))
  (func (export "\ef\bf\be") (result i32) (i32.const 108))
  (func (export "\ef\bf\bf") (result i32) (i32.const 109))
  (func (export "\f0\9f\bf\be") (result i32) (i32.const 110))
  (func (export "\f0\9f\bf\bf") (result i32) (i32.const 111))
  (func (export "\f0\af\bf\be") (result i32) (i32.const 112))
  (func (export "\f0\af\bf\bf") (result i32) (i32.const 113))
  (func (export "\f0\bf\bf\be") (result i32) (i32.const 114))
  (func (export "\f0\bf\bf\bf") (result i32) (i32.const 115))
  (func (export "\f1\8f\bf\be") (result i32) (i32.const 116))
  (func (export "\f1\8f\bf\bf") (result i32) (i32.const 117))
  (func (export "\f1\9f\bf\be") (result i32) (i32.const 118))
  (func (export "\f1\9f\bf\bf") (result i32) (i32.const 119))
  (func (export "\f1\af\bf\be") (result i32) (i32.const 120))
  (func (export "\f1\af\bf\bf") (result i32) (i32.const 121))
  (func (export "\f1\bf\bf\be") (result i32) (i32.const 122))
  (func (export "\f1\bf\bf\bf") (result i32) (i32.const 123))
  (func (export "\f2\8f\bf\be") (result i32) (i32.const 124))
  (func (export "\f2\8f\bf\bf") (result i32) (i32.const 125))
  (func (export "\f2\9f\bf\be") (result i32) (i32.const 126))
  (func (export "\f2\9f\bf\bf") (result i32) (i32.const 127))
  (func (export "\f2\af\bf\be") (result i32) (i32.const 128))
  (func (export "\f2\af\bf\bf") (result i32) (i32.const 129))
  (func (export "\f2\bf\bf\be") (result i32) (i32.const 130))
  (func (export "\f2\bf\bf\bf") (result i32) (i32.const 131))
  (func (export "\f3\8f\bf\be") (result i32) (i32.const 132))
  (func (export "\f3\8f\bf\bf") (result i32) (i32.const 133))
  (func (export "\f3\9f\bf\be") (result i32) (i32.const 134))
  (func (export "\f3\9f\bf\bf") (result i32) (i32.const 135))
  (func (export "\f3\af\bf\be") (result i32) (i32.const 136))
  (func (export "\f3\af\bf\bf") (result i32) (i32.const 137))
  (func (export "\f3\bf\bf\be") (result i32) (i32.const 138))
  (func (export "\f3\bf\bf\bf") (result i32) (i32.const 139))
  (func (export "\f4\8f\bf\be") (result i32) (i32.const 140))
  (func (export "\f4\8f\bf\bf") (result i32) (i32.const 141))

  ;; Test an interrobang with combining diacritical marks above.
  ;; https://xkcd.com/1209/
  (func (export "̈‽̈̉") (result i32) (i32.const 142))

  ;; Test that RLM/LRM don't change the logical byte order.
  (func (export "abc") (result i32) (i32.const 143))
  (func (export "‭abc") (result i32) (i32.const 144))
  (func (export "‮cba") (result i32) (i32.const 145))
  (func (export "‭abc‮") (result i32) (i32.const 146))
  (func (export "‮cba‭") (result i32) (i32.const 147))

  ;; Test that Unicode font variations are preserved.
  (func (export "𝑨") (result i32) (i32.const 148))
  (func (export "𝐴") (result i32) (i32.const 149))
  (func (export "𝘈") (result i32) (i32.const 150))
  (func (export "𝘼") (result i32) (i32.const 151))
  (func (export "𝐀") (result i32) (i32.const 152))
  (func (export "𝓐") (result i32) (i32.const 153))
  (func (export "𝕬") (result i32) (i32.const 154))
  (func (export "𝗔") (result i32) (i32.const 155))
  (func (export "𝒜") (result i32) (i32.const 156))
  (func (export "𝔄") (result i32) (i32.const 157))
  (func (export "𝔸") (result i32) (i32.const 158))
  (func (export "𝖠") (result i32) (i32.const 159))
  (func (export "𝙰") (result i32) (i32.const 160))
  (func (export "ᴀ") (result i32) (i32.const 161))

  ;; Test that various additional letter variations are preserved.
  ;; (U+0040, U+0061, U+0041, U+00C5, U+0041 U+030A, U+212B, and the font
  ;; variations are covered above.)
  (func (export "ᴬ") (result i32) (i32.const 162))
  (func (export "Ⓐ") (result i32) (i32.const 163))
  (func (export "Ａ") (result i32) (i32.const 164))
  (func (export "🄐") (result i32) (i32.const 165))
  (func (export "🄰") (result i32) (i32.const 166))
  (func (export "󠁁") (result i32) (i32.const 167))
  (func (export "U+0041") (result i32) (i32.const 168))
  (func (export "A​") (result i32) (i32.const 169))
  (func (export "А") (result i32) (i32.const 170))
  (func (export "Ꙗ") (result i32) (i32.const 171))
  (func (export "ⷼ") (result i32) (i32.const 172))
  (func (export "ⷶ") (result i32) (i32.const 173))
  (func (export "Ɐ") (result i32) (i32.const 174))
  (func (export "🅐") (result i32) (i32.const 175))
  (func (export "🅰") (result i32) (i32.const 176))
  (func (export "Ⱝ") (result i32) (i32.const 177))
  (func (export "𐐂") (result i32) (i32.const 178))
  (func (export "𐐈") (result i32) (i32.const 179))
  (func (export "𐒰") (result i32) (i32.const 180))
  (func (export "À") (result i32) (i32.const 181))
  (func (export "Á") (result i32) (i32.const 182))
  (func (export "Â") (result i32) (i32.const 183))
  (func (export "Ã") (result i32) (i32.const 184))
  (func (export "Ä") (result i32) (i32.const 185))
  (func (export "Ā") (result i32) (i32.const 186))
  (func (export "Ă") (result i32) (i32.const 187))
  (func (export "Ą") (result i32) (i32.const 188))
  (func (export "Ǎ") (result i32) (i32.const 189))
  (func (export "Ǟ") (result i32) (i32.const 190))
  (func (export "Ǡ") (result i32) (i32.const 191))
  (func (export "Ǻ") (result i32) (i32.const 192))
  (func (export "Ȁ") (result i32) (i32.const 193))
  (func (export "Ȃ") (result i32) (i32.const 194))
  (func (export "Ȧ") (result i32) (i32.const 195))
  (func (export "Ⱥ") (result i32) (i32.const 196))
  (func (export "Ӑ") (result i32) (i32.const 197))
  (func (export "Ӓ") (result i32) (i32.const 198))
  (func (export "ߊ") (result i32) (i32.const 199))
  (func (export "ࠡ") (result i32) (i32.const 200))
  (func (export "ࠢ") (result i32) (i32.const 201))
  (func (export "ࠣ") (result i32) (i32.const 202))
  (func (export "ࠤ") (result i32) (i32.const 203))
  (func (export "ࠥ") (result i32) (i32.const 204))
  (func (export "ऄ") (result i32) (i32.const 205))
  (func (export "अ") (result i32) (i32.const 206))
  (func (export "ॲ") (result i32) (i32.const 207))
  (func (export "অ") (result i32) (i32.const 208))
  (func (export "ਅ") (result i32) (i32.const 209))
  (func (export "અ") (result i32) (i32.const 210))
  (func (export "ଅ") (result i32) (i32.const 211))
  (func (export "அ") (result i32) (i32.const 212))
  (func (export "అ") (result i32) (i32.const 213))
  (func (export "ಅ") (result i32) (i32.const 214))
  (func (export "അ") (result i32) (i32.const 215))
  (func (export "ะ") (result i32) (i32.const 216))
  (func (export "ະ") (result i32) (i32.const 217))
  (func (export "༁") (result i32) (i32.const 218))
  (func (export "ཨ") (result i32) (i32.const 219))
  (func (export "ྸ") (result i32) (i32.const 220))
  (func (export "အ") (result i32) (i32.const 221))
  (func (export "ဢ") (result i32) (i32.const 222))
  (func (export "ႜ") (result i32) (i32.const 223))
  (func (export "ᅡ") (result i32) (i32.const 224))
  (func (export "አ") (result i32) (i32.const 225))
  (func (export "ዐ") (result i32) (i32.const 226))
  (func (export "Ꭰ") (result i32) (i32.const 227))
  (func (export "ᐊ") (result i32) (i32.const 228))
  (func (export "ᖳ") (result i32) (i32.const 229))
  (func (export "ᚨ") (result i32) (i32.const 230))
  (func (export "ᚪ") (result i32) (i32.const 231))
  (func (export "ᛆ") (result i32) (i32.const 232))
  (func (export "ᜀ") (result i32) (i32.const 233))
  (func (export "ᜠ") (result i32) (i32.const 234))
  (func (export "ᝀ") (result i32) (i32.const 235))
  (func (export "ᝠ") (result i32) (i32.const 236))
  (func (export "ᠠ") (result i32) (i32.const 237))
  (func (export "ᢇ") (result i32) (i32.const 238))
  (func (export "ᤠ") (result i32) (i32.const 239))
  (func (export "ᥣ") (result i32) (i32.const 240))
  (func (export "ᨕ") (result i32) (i32.const 241))
  (func (export "ᩋ") (result i32) (i32.const 242))
  (func (export "ᩡ") (result i32) (i32.const 243))
  (func (export "ᮃ") (result i32) (i32.const 244))
  (func (export "ᯀ") (result i32) (i32.const 245))
  (func (export "ᯁ") (result i32) (i32.const 246))
  (func (export "ᰣ") (result i32) (i32.const 247))
  (func (export "Ḁ") (result i32) (i32.const 248))
  (func (export "Ạ") (result i32) (i32.const 249))
  (func (export "Ả") (result i32) (i32.const 250))
  (func (export "Ấ") (result i32) (i32.const 251))
  (func (export "Ầ") (result i32) (i32.const 252))
  (func (export "Ẩ") (result i32) (i32.const 253))
  (func (export "Ẫ") (result i32) (i32.const 254))
  (func (export "Ậ") (result i32) (i32.const 255))
  (func (export "Ắ") (result i32) (i32.const 256))
  (func (export "Ằ") (result i32) (i32.const 257))
  (func (export "Ẳ") (result i32) (i32.const 258))
  (func (export "Ẵ") (result i32) (i32.const 259))
  (func (export "Ặ") (result i32) (i32.const 260))
  (func (export "あ") (result i32) (i32.const 261))
  (func (export "ア") (result i32) (i32.const 262))
  (func (export "ㄚ") (result i32) (i32.const 263))
  (func (export "ㅏ") (result i32) (i32.const 264))
  (func (export "㈎") (result i32) (i32.const 265))
  (func (export "㈏") (result i32) (i32.const 266))
  (func (export "㈐") (result i32) (i32.const 267))
  (func (export "㈑") (result i32) (i32.const 268))
  (func (export "㈒") (result i32) (i32.const 269))
  (func (export "㈓") (result i32) (i32.const 270))
  (func (export "㈔") (result i32) (i32.const 271))
  (func (export "㈕") (result i32) (i32.const 272))
  (func (export "㈖") (result i32) (i32.const 273))
  (func (export "㈗") (result i32) (i32.const 274))
  (func (export "㈘") (result i32) (i32.const 275))
  (func (export "㈙") (result i32) (i32.const 276))
  (func (export "㈚") (result i32) (i32.const 277))
  (func (export "㈛") (result i32) (i32.const 278))
  (func (export "㉮") (result i32) (i32.const 279))
  (func (export "㉯") (result i32) (i32.const 280))
  (func (export "㉰") (result i32) (i32.const 281))
  (func (export "㉱") (result i32) (i32.const 282))
  (func (export "㉲") (result i32) (i32.const 283))
  (func (export "㉳") (result i32) (i32.const 284))
  (func (export "㉴") (result i32) (i32.const 285))
  (func (export "㉵") (result i32) (i32.const 286))
  (func (export "㉶") (result i32) (i32.const 287))
  (func (export "㉷") (result i32) (i32.const 288))
  (func (export "㉸") (result i32) (i32.const 289))
  (func (export "㉹") (result i32) (i32.const 290))
  (func (export "㉺") (result i32) (i32.const 291))
  (func (export "㉻") (result i32) (i32.const 292))
  (func (export "㋐") (result i32) (i32.const 293))
  (func (export "ꀊ") (result i32) (i32.const 294))
  (func (export "ꓮ") (result i32) (i32.const 295))
  (func (export "ꕉ") (result i32) (i32.const 296))
  (func (export "ꚠ") (result i32) (i32.const 297))
  (func (export "ꠀ") (result i32) (i32.const 298))
  (func (export "ꠣ") (result i32) (i32.const 299))
  (func (export "ꡝ") (result i32) (i32.const 300))
  (func (export "ꢂ") (result i32) (i32.const 301))
  (func (export "꣪") (result i32) (i32.const 302))
  (func (export "ꤢ") (result i32) (i32.const 303))
  (func (export "ꥆ") (result i32) (i32.const 304))
  (func (export "ꦄ") (result i32) (i32.const 305))
  (func (export "ꨀ") (result i32) (i32.const 306))
  (func (export "ｱ") (result i32) (i32.const 307))
  (func (export "ￂ") (result i32) (i32.const 308))
  (func (export "𐀀") (result i32) (i32.const 309))
  (func (export "𐊀") (result i32) (i32.const 310))
  (func (export "𐊠") (result i32) (i32.const 311))
  (func (export "𐌀") (result i32) (i32.const 312))
  (func (export "𐎠") (result i32) (i32.const 313))
  (func (export "𐒖") (result i32) (i32.const 314))
  (func (export "𐔀") (result i32) (i32.const 315))
  (func (export "𐝀") (result i32) (i32.const 316))
  (func (export "𐠀") (result i32) (i32.const 317))
  (func (export "𐤠") (result i32) (i32.const 318))
  (func (export "𐦀") (result i32) (i32.const 319))
  (func (export "𐦠") (result i32) (i32.const 320))
  (func (export "𐨀") (result i32) (i32.const 321))
  (func (export "𐬀") (result i32) (i32.const 322))
  (func (export "𐰀") (result i32) (i32.const 323))
  (func (export "𐰁") (result i32) (i32.const 324))
  (func (export "𐲀") (result i32) (i32.const 325))
  (func (export "𑀅") (result i32) (i32.const 326))
  (func (export "𑂃") (result i32) (i32.const 327))
  (func (export "𑄧") (result i32) (i32.const 328))
  (func (export "𑅐") (result i32) (i32.const 329))
  (func (export "𑆃") (result i32) (i32.const 330))
  (func (export "𑈀") (result i32) (i32.const 331))
  (func (export "𑊀") (result i32) (i32.const 332))
  (func (export "𑊰") (result i32) (i32.const 333))
  (func (export "𑌅") (result i32) (i32.const 334))
  (func (export "𑍰") (result i32) (i32.const 335))
  (func (export "𑐀") (result i32) (i32.const 336))
  (func (export "𑒁") (result i32) (i32.const 337))
  (func (export "𑖀") (result i32) (i32.const 338))
  (func (export "𑘀") (result i32) (i32.const 339))
  (func (export "𑚀") (result i32) (i32.const 340))
  (func (export "𑜒") (result i32) (i32.const 341))
  (func (export "𑜠") (result i32) (i32.const 342))
  (func (export "𑢡") (result i32) (i32.const 343))
  (func (export "𑫕") (result i32) (i32.const 344))
  (func (export "𑰀") (result i32) (i32.const 345))
  (func (export "𑲏") (result i32) (i32.const 346))
  (func (export "𑲯") (result i32) (i32.const 347))
  (func (export "𒀀") (result i32) (i32.const 348))
  (func (export "𖧕") (result i32) (i32.const 349))
  (func (export "𖩆") (result i32) (i32.const 350))
  (func (export "𖫧") (result i32) (i32.const 351))
  (func (export "𖽔") (result i32) (i32.const 352))
  (func (export "𛱁") (result i32) (i32.const 353))
  (func (export "𛱤") (result i32) (i32.const 354))
  (func (export "𞠣") (result i32) (i32.const 355))
  (func (export "🇦") (result i32) (i32.const 356))
  (func (export "Ɑ") (result i32) (i32.const 357))
  (func (export "Λ") (result i32) (i32.const 358))
  (func (export "Ɒ") (result i32) (i32.const 359))
  (func (export "ª") (result i32) (i32.const 360))
  (func (export "∀") (result i32) (i32.const 361))
  (func (export "₳") (result i32) (i32.const 362))
  (func (export "𐤀") (result i32) (i32.const 363))
  (func (export "Ⲁ") (result i32) (i32.const 364))
  (func (export "𐌰") (result i32) (i32.const 365))
  (func (export "Ά") (result i32) (i32.const 366))
  (func (export "Α") (result i32) (i32.const 367))
  (func (export "Ἀ") (result i32) (i32.const 368))
  (func (export "Ἁ") (result i32) (i32.const 369))
  (func (export "Ἂ") (result i32) (i32.const 370))
  (func (export "Ἃ") (result i32) (i32.const 371))
  (func (export "Ἄ") (result i32) (i32.const 372))
  (func (export "Ἅ") (result i32) (i32.const 373))
  (func (export "Ἆ") (result i32) (i32.const 374))
  (func (export "Ἇ") (result i32) (i32.const 375))
  (func (export "ᾈ") (result i32) (i32.const 376))
  (func (export "ᾉ") (result i32) (i32.const 377))
  (func (export "ᾊ") (result i32) (i32.const 378))
  (func (export "ᾋ") (result i32) (i32.const 379))
  (func (export "ᾌ") (result i32) (i32.const 380))
  (func (export "ᾍ") (result i32) (i32.const 381))
  (func (export "ᾎ") (result i32) (i32.const 382))
  (func (export "ᾏ") (result i32) (i32.const 383))
  (func (export "Ᾰ") (result i32) (i32.const 384))
  (func (export "Ᾱ") (result i32) (i32.const 385))
  (func (export "Ὰ") (result i32) (i32.const 386))
  (func (export "Ά") (result i32) (i32.const 387))
  (func (export "ᾼ") (result i32) (i32.const 388))
  (func (export "𝚨") (result i32) (i32.const 389))
  (func (export "𝛢") (result i32) (i32.const 390))
  (func (export "𝜜") (result i32) (i32.const 391))
  (func (export "𝝖") (result i32) (i32.const 392))
  (func (export "𝞐") (result i32) (i32.const 393))
  (func (export "⍶") (result i32) (i32.const 394))
  (func (export "⍺") (result i32) (i32.const 395))
  (func (export "⩜") (result i32) (i32.const 396))
  (func (export "ᗅ") (result i32) (i32.const 397))
  (func (export "Ꭺ") (result i32) (i32.const 398))

  ;; Test unmatched "closing" and "opening" code points.
  (func (export ")˺˼𔗏𝅴𝅶𝅸𝅺⁾₎❩❫⟯﴿︶﹚）｠󠀩❳❵⟧⟩⟫⟭⦈⦊⦖⸣⸥︘︸︺︼︾﹀﹂﹄﹈﹜﹞］｝｣󠁝󠁽»’”›❯") (result i32) (i32.const 399))
  (func (export "(˹˻𔗎𝅳𝅵𝅷𝅹⁽₍❨❪⟮﴾︵﹙（｟󠀨❲❴⟦⟨⟪⟬⦇⦉⦕⸢⸤︗︷︹︻︽︿﹁﹃﹇﹛﹝［｛｢󠁛󠁻«‘“‹❮") (result i32) (i32.const 400))
  (func (export "𝪋𝪤") (result i32) (i32.const 401))
  (func (export "𝪋") (result i32) (i32.const 402))

  ;; Test that Unicode fraction normalization is not applied.
  (func (export "½") (result i32) (i32.const 403))
  (func (export "1⁄2") (result i32) (i32.const 404))
  (func (export "1/2") (result i32) (i32.const 405))
  (func (export "୳") (result i32) (i32.const 406))
  (func (export "൴") (result i32) (i32.const 407))
  (func (export "⳽") (result i32) (i32.const 408))
  (func (export "꠱") (result i32) (i32.const 409))
  (func (export "𐅁") (result i32) (i32.const 410))
  (func (export "𐅵") (result i32) (i32.const 411))
  (func (export "𐅶") (result i32) (i32.const 412))
  (func (export "𐦽") (result i32) (i32.const 413))
  (func (export "𐹻") (result i32) (i32.const 414))

  ;; Test a full-width quote.
  (func (export "＂") (result i32) (i32.const 415))

  ;; Test that different present and historical representations of the "delete"
  ;; concept are distinct.
  (func (export "\7f") (result i32) (i32.const 416))
  (func (export "\08") (result i32) (i32.const 417))
  (func (export "⌫") (result i32) (i32.const 418))
  (func (export "⌦") (result i32) (i32.const 419))
  (func (export "␈") (result i32) (i32.const 420))
  (func (export "␡") (result i32) (i32.const 421))
  (func (export "᷻") (result i32) (i32.const 422))
  (func (export "\0f") (result i32) (i32.const 423))
  (func (export "←") (result i32) (i32.const 424))
  (func (export "⌧") (result i32) (i32.const 425))
  (func (export "⍒") (result i32) (i32.const 426))
  (func (export "⍔") (result i32) (i32.const 427))
  (func (export "⍢") (result i32) (i32.const 428))
  (func (export "⍫") (result i32) (i32.const 429))

  ;; Test that different representations of the "substitute" concept are
  ;; distinct. (U+FFFD is covered above.)
  (func (export "\1a") (result i32) (i32.const 430))
  (func (export "␦") (result i32) (i32.const 431))
  (func (export "␚") (result i32) (i32.const 432))
  (func (export "￼") (result i32) (i32.const 433))
  (func (export "?") (result i32) (i32.const 434))
  (func (export "¿") (result i32) (i32.const 435))
  (func (export "᥅") (result i32) (i32.const 436))
  (func (export ";") (result i32) (i32.const 437))
  (func (export "՞") (result i32) (i32.const 438))
  (func (export "؟") (result i32) (i32.const 439))
  (func (export "፧") (result i32) (i32.const 440))
  (func (export "⁇") (result i32) (i32.const 441))
  (func (export "⍰") (result i32) (i32.const 442))
  (func (export "❓") (result i32) (i32.const 443))
  (func (export "❔") (result i32) (i32.const 444))
  (func (export "⳺") (result i32) (i32.const 445))
  (func (export "⳻") (result i32) (i32.const 446))
  (func (export "⸮") (result i32) (i32.const 447))
  (func (export "㉄") (result i32) (i32.const 448))
  (func (export "꘏") (result i32) (i32.const 449))
  (func (export "꛷") (result i32) (i32.const 450))
  (func (export "︖") (result i32) (i32.const 451))
  (func (export "﹖") (result i32) (i32.const 452))
  (func (export "？") (result i32) (i32.const 453))
  (func (export "𑅃") (result i32) (i32.const 454))
  (func (export "𞥟") (result i32) (i32.const 455))
  (func (export "󠀿") (result i32) (i32.const 456))
  (func (export "𖡄") (result i32) (i32.const 457))
  (func (export "⯑") (result i32) (i32.const 458))

  ;; Test that different present and historical representations of the
  ;; "paragraph" concept are distinct. (U+2029 is covered above).
  (func (export "¶") (result i32) (i32.const 459))
  (func (export "⁋") (result i32) (i32.const 460))
  (func (export "܀") (result i32) (i32.const 461))
  (func (export "჻") (result i32) (i32.const 462))
  (func (export "፨") (result i32) (i32.const 463))
  (func (export "〷") (result i32) (i32.const 464))
  (func (export "❡") (result i32) (i32.const 465))
  (func (export "⸏") (result i32) (i32.const 466))
  (func (export "⸐") (result i32) (i32.const 467))
  (func (export "⸑") (result i32) (i32.const 468))
  (func (export "⸎") (result i32) (i32.const 469))
  (func (export "\14") (result i32) (i32.const 470)) ;; ¶ in CP437
  (func (export "☙") (result i32) (i32.const 471))
)