// Copyright 2017 The go-interpreter Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package wasm

import (
	"io/ioutil"
	"log"
	"os"
)

var logger *log.Logger

func init() {
	SetDebugMode(false)
}

func SetDebugMode(dbg bool) {
	w := ioutil.Discard
	if dbg {
		w = os.Stderr
	}
	logger = log.New(w, "", log.Lshortfile)
}
