package middleware

import (
	"net/http"
)

type (
	srv func(http.Handler) http.Handler
	rtr func(http.HandlerFunc) http.HandlerFunc
)

// Server allows server level middleware chaining. The first middleware in the
// chain runs last. Server level middleware always take precedence over router
// level middleware.
func Server(h http.Handler, middleware ...srv) http.Handler {
	for _, m := range middleware {
		h = m(h)
	}

	return h
}

// Router allows router level middleware chaining. The first middleware in the
// chain runs last. Server level middleware always take precedence over router
// level middleware.
func Router(h http.HandlerFunc, middleware ...rtr) http.HandlerFunc {
	for _, m := range middleware {
		h = m(h)
	}

	return h
}
