package validator

import (
	"regexp"
)

// ISO8601Date validates ISO 8601 date format `yyyy-mm-dd`.
func ISO8601Date(v string) bool {
	return regexp.MustCompile(`([12]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01]))`).MatchString(v)
}
