package middleware

import (
	"context"
	"net/http"
)

type ctxRouteName string

const CtxRouteNameKey = ctxRouteName("route_name")

// RouteName is a route level middleware which names the given route and links
// it to its corresponding key in the request context. The purpose of this
// middleware is to inject the value to the logs.
func RouteName(val string) func(http.Handler) http.Handler {
	return func(h http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			h.ServeHTTP(w, r.WithContext(context.WithValue(r.Context(), CtxRouteNameKey, val)))
		})
	}
}

// RouteNameFromContext returns the name of the current route from the request
// context.
func RouteNameFromContext(ctx context.Context) string {
	if ctx.Value(CtxRouteNameKey) != nil {
		return ctx.Value(CtxRouteNameKey).(string)
	}

	return ""
}
