package rdbms

import (
	"database/sql"
	"fmt"
	"time"

	_ "github.com/go-sql-driver/mysql"
)

type MySQLConfig struct {
	Host           string
	Port           string
	Username       string
	Password       string
	Database       string
	MaxIdleCons    int
	ConMaxLifetime time.Duration
}

func NewMySQL(config MySQLConfig) (*sql.DB, error) {
	db, err := sql.Open("mysql", fmt.Sprintf(
		"%s:%s@tcp(%s:%s)/%s",
		config.Username,
		config.Password,
		config.Host,
		config.Port,
		config.Database,
	))
	if err != nil {
		return nil, err
	}

	db.SetMaxIdleConns(config.MaxIdleCons)
	db.SetConnMaxLifetime(config.ConMaxLifetime)

	return db, nil
}
