package rdbms

type Paginator struct {
	sortDefault       string
	allowedSortFields map[string]string
}

func NewPaginator(sortDefault string, allowedSortFields map[string]string) Paginator {
	return Paginator{
		sortDefault:       sortDefault,
		allowedSortFields: allowedSortFields,
	}
}

func (p Paginator) Page(page int) int {
	if page < 1 {
		return 1
	}

	return page
}

func (p Paginator) Limit(size, maxSize int) int {
	if size < 1 || size > maxSize {
		return maxSize
	}

	return size
}

func (p Paginator) Offset(page, limit int) int {
	if page <= 1 {
		return 0
	}

	return (page * limit) - limit
}

func (p Paginator) OrderBy(sortFields []string) string {
	if len(sortFields) == 0 {
		return p.sortDefault
	}

	var order string

	for _, field := range sortFields {
		if name, ok := p.allowedSortFields[field]; ok {
			order += name + " ASC, "
			continue
		}

		if field[0:1] == "-" {
			if name, ok := p.allowedSortFields[field[1:]]; ok {
				order += name + " DESC, "
			}
		}
	}

	if order != "" {
		return order[:len(order)-2]
	}

	return p.sortDefault
}
