package rest

import (
	"regexp"
	"strconv"
	"strings"
)

var (
	urlPageNumberRegex = regexp.MustCompile(`^[1-9][0-9]*$`)
	urlSortFieldsRegex = regexp.MustCompile(`^[\w\d\,_-]+$`)
)

func ValidateURLPageNumber(val string) (int, bool) {
	if val == "" {
		return 0, true
	}

	if !urlPageNumberRegex.MatchString(val) {
		return 0, false
	}

	v, err := strconv.Atoi(val)
	if err != nil || v < 1 {
		return 0, false
	}

	return v, true
}

func ValidateURLPageSize(val string, max int) (int, bool) {
	if val == "" {
		return 0, true
	}

	if !urlPageNumberRegex.MatchString(val) {
		return 0, false
	}

	v, err := strconv.Atoi(val)
	if err != nil || v < 1 || v > max {
		return 0, false
	}

	return v, true
}

func ValidateURLSortFields(val string, max int) ([]string, bool) {
	if val == "" {
		return nil, true
	}

	if !urlSortFieldsRegex.MatchString(val) {
		return nil, false
	}

	vals := strings.Split(val, ",")
	if len(vals) > max {
		return nil, false
	}

	for _, v := range vals {
		if v == "" {
			return nil, false
		}
	}

	return vals, true
}
