// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateFleet = "AssociateFleet"

// AssociateFleetRequest generates a "aws/request.Request" representing the
// client's request for the AssociateFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateFleet for more information on using the AssociateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateFleetRequest method.
//    req, resp := client.AssociateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet
func (c *AppStream) AssociateFleetRequest(input *AssociateFleetInput) (req *request.Request, output *AssociateFleetOutput) {
	op := &request.Operation{
		Name:       opAssociateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateFleetInput{}
	}

	output = &AssociateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateFleet API operation for Amazon AppStream.
//
// Associates the specified fleet with the specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation AssociateFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
//   * ErrCodeIncompatibleImageException "IncompatibleImageException"
//   The image does not support storage connectors.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet
func (c *AppStream) AssociateFleet(input *AssociateFleetInput) (*AssociateFleetOutput, error) {
	req, out := c.AssociateFleetRequest(input)
	return out, req.Send()
}

// AssociateFleetWithContext is the same as AssociateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) AssociateFleetWithContext(ctx aws.Context, input *AssociateFleetInput, opts ...request.Option) (*AssociateFleetOutput, error) {
	req, out := c.AssociateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyImage = "CopyImage"

// CopyImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyImage operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyImage for more information on using the CopyImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyImageRequest method.
//    req, resp := client.CopyImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CopyImage
func (c *AppStream) CopyImageRequest(input *CopyImageInput) (req *request.Request, output *CopyImageOutput) {
	op := &request.Operation{
		Name:       opCopyImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyImageInput{}
	}

	output = &CopyImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyImage API operation for Amazon AppStream.
//
// Copies the image within the same region or to a new region within the same
// AWS account. Note that any tags you added to the image will not be copied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CopyImage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeResourceNotAvailableException "ResourceNotAvailableException"
//   The specified resource exists and is not in use, but isn't available.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeIncompatibleImageException "IncompatibleImageException"
//   The image does not support storage connectors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CopyImage
func (c *AppStream) CopyImage(input *CopyImageInput) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	return out, req.Send()
}

// CopyImageWithContext is the same as CopyImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CopyImageWithContext(ctx aws.Context, input *CopyImageInput, opts ...request.Option) (*CopyImageOutput, error) {
	req, out := c.CopyImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectoryConfig = "CreateDirectoryConfig"

// CreateDirectoryConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectoryConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectoryConfig for more information on using the CreateDirectoryConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectoryConfigRequest method.
//    req, resp := client.CreateDirectoryConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig
func (c *AppStream) CreateDirectoryConfigRequest(input *CreateDirectoryConfigInput) (req *request.Request, output *CreateDirectoryConfigOutput) {
	op := &request.Operation{
		Name:       opCreateDirectoryConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectoryConfigInput{}
	}

	output = &CreateDirectoryConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectoryConfig API operation for Amazon AppStream.
//
// Creates a directory configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateDirectoryConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig
func (c *AppStream) CreateDirectoryConfig(input *CreateDirectoryConfigInput) (*CreateDirectoryConfigOutput, error) {
	req, out := c.CreateDirectoryConfigRequest(input)
	return out, req.Send()
}

// CreateDirectoryConfigWithContext is the same as CreateDirectoryConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectoryConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateDirectoryConfigWithContext(ctx aws.Context, input *CreateDirectoryConfigInput, opts ...request.Option) (*CreateDirectoryConfigOutput, error) {
	req, out := c.CreateDirectoryConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFleetRequest method.
//    req, resp := client.CreateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet
func (c *AppStream) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon AppStream.
//
// Creates a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceNotAvailableException "ResourceNotAvailableException"
//   The specified resource exists and is not in use, but isn't available.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The specified role is invalid.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * ErrCodeIncompatibleImageException "IncompatibleImageException"
//   The image does not support storage connectors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet
func (c *AppStream) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImageBuilder = "CreateImageBuilder"

// CreateImageBuilderRequest generates a "aws/request.Request" representing the
// client's request for the CreateImageBuilder operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImageBuilder for more information on using the CreateImageBuilder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImageBuilderRequest method.
//    req, resp := client.CreateImageBuilderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder
func (c *AppStream) CreateImageBuilderRequest(input *CreateImageBuilderInput) (req *request.Request, output *CreateImageBuilderOutput) {
	op := &request.Operation{
		Name:       opCreateImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageBuilderInput{}
	}

	output = &CreateImageBuilderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImageBuilder API operation for Amazon AppStream.
//
// Creates an image builder.
//
// The initial state of the builder is PENDING. When it is ready, the state
// is RUNNING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateImageBuilder for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceNotAvailableException "ResourceNotAvailableException"
//   The specified resource exists and is not in use, but isn't available.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The specified role is invalid.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * ErrCodeIncompatibleImageException "IncompatibleImageException"
//   The image does not support storage connectors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder
func (c *AppStream) CreateImageBuilder(input *CreateImageBuilderInput) (*CreateImageBuilderOutput, error) {
	req, out := c.CreateImageBuilderRequest(input)
	return out, req.Send()
}

// CreateImageBuilderWithContext is the same as CreateImageBuilder with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImageBuilder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateImageBuilderWithContext(ctx aws.Context, input *CreateImageBuilderInput, opts ...request.Option) (*CreateImageBuilderOutput, error) {
	req, out := c.CreateImageBuilderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImageBuilderStreamingURL = "CreateImageBuilderStreamingURL"

// CreateImageBuilderStreamingURLRequest generates a "aws/request.Request" representing the
// client's request for the CreateImageBuilderStreamingURL operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImageBuilderStreamingURL for more information on using the CreateImageBuilderStreamingURL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImageBuilderStreamingURLRequest method.
//    req, resp := client.CreateImageBuilderStreamingURLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL
func (c *AppStream) CreateImageBuilderStreamingURLRequest(input *CreateImageBuilderStreamingURLInput) (req *request.Request, output *CreateImageBuilderStreamingURLOutput) {
	op := &request.Operation{
		Name:       opCreateImageBuilderStreamingURL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageBuilderStreamingURLInput{}
	}

	output = &CreateImageBuilderStreamingURLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImageBuilderStreamingURL API operation for Amazon AppStream.
//
// Creates a URL to start an image builder streaming session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateImageBuilderStreamingURL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The attempted operation is not permitted.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL
func (c *AppStream) CreateImageBuilderStreamingURL(input *CreateImageBuilderStreamingURLInput) (*CreateImageBuilderStreamingURLOutput, error) {
	req, out := c.CreateImageBuilderStreamingURLRequest(input)
	return out, req.Send()
}

// CreateImageBuilderStreamingURLWithContext is the same as CreateImageBuilderStreamingURL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImageBuilderStreamingURL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateImageBuilderStreamingURLWithContext(ctx aws.Context, input *CreateImageBuilderStreamingURLInput, opts ...request.Option) (*CreateImageBuilderStreamingURLOutput, error) {
	req, out := c.CreateImageBuilderStreamingURLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a "aws/request.Request" representing the
// client's request for the CreateStack operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStack for more information on using the CreateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStackRequest method.
//    req, resp := client.CreateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack
func (c *AppStream) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	output = &CreateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStack API operation for Amazon AppStream.
//
// Creates a stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateStack for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The specified role is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack
func (c *AppStream) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	return out, req.Send()
}

// CreateStackWithContext is the same as CreateStack with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateStackWithContext(ctx aws.Context, input *CreateStackInput, opts ...request.Option) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamingURL = "CreateStreamingURL"

// CreateStreamingURLRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamingURL operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamingURL for more information on using the CreateStreamingURL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamingURLRequest method.
//    req, resp := client.CreateStreamingURLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL
func (c *AppStream) CreateStreamingURLRequest(input *CreateStreamingURLInput) (req *request.Request, output *CreateStreamingURLOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingURL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStreamingURLInput{}
	}

	output = &CreateStreamingURLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamingURL API operation for Amazon AppStream.
//
// Creates a URL to start a streaming session for the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation CreateStreamingURL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeResourceNotAvailableException "ResourceNotAvailableException"
//   The specified resource exists and is not in use, but isn't available.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The attempted operation is not permitted.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL
func (c *AppStream) CreateStreamingURL(input *CreateStreamingURLInput) (*CreateStreamingURLOutput, error) {
	req, out := c.CreateStreamingURLRequest(input)
	return out, req.Send()
}

// CreateStreamingURLWithContext is the same as CreateStreamingURL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamingURL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) CreateStreamingURLWithContext(ctx aws.Context, input *CreateStreamingURLInput, opts ...request.Option) (*CreateStreamingURLOutput, error) {
	req, out := c.CreateStreamingURLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectoryConfig = "DeleteDirectoryConfig"

// DeleteDirectoryConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectoryConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectoryConfig for more information on using the DeleteDirectoryConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectoryConfigRequest method.
//    req, resp := client.DeleteDirectoryConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig
func (c *AppStream) DeleteDirectoryConfigRequest(input *DeleteDirectoryConfigInput) (req *request.Request, output *DeleteDirectoryConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectoryConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectoryConfigInput{}
	}

	output = &DeleteDirectoryConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDirectoryConfig API operation for Amazon AppStream.
//
// Deletes the specified directory configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteDirectoryConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig
func (c *AppStream) DeleteDirectoryConfig(input *DeleteDirectoryConfigInput) (*DeleteDirectoryConfigOutput, error) {
	req, out := c.DeleteDirectoryConfigRequest(input)
	return out, req.Send()
}

// DeleteDirectoryConfigWithContext is the same as DeleteDirectoryConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectoryConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteDirectoryConfigWithContext(ctx aws.Context, input *DeleteDirectoryConfigInput, opts ...request.Option) (*DeleteDirectoryConfigOutput, error) {
	req, out := c.DeleteDirectoryConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFleetRequest method.
//    req, resp := client.DeleteFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet
func (c *AppStream) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFleet API operation for Amazon AppStream.
//
// Deletes the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet
func (c *AppStream) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImage = "DeleteImage"

// DeleteImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImage operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImage for more information on using the DeleteImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteImageRequest method.
//    req, resp := client.DeleteImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage
func (c *AppStream) DeleteImageRequest(input *DeleteImageInput) (req *request.Request, output *DeleteImageOutput) {
	op := &request.Operation{
		Name:       opDeleteImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImageInput{}
	}

	output = &DeleteImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImage API operation for Amazon AppStream.
//
// Deletes the specified image. You cannot delete an image that is currently
// in use. After you delete an image, you cannot provision new capacity using
// the image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteImage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The attempted operation is not permitted.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage
func (c *AppStream) DeleteImage(input *DeleteImageInput) (*DeleteImageOutput, error) {
	req, out := c.DeleteImageRequest(input)
	return out, req.Send()
}

// DeleteImageWithContext is the same as DeleteImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteImageWithContext(ctx aws.Context, input *DeleteImageInput, opts ...request.Option) (*DeleteImageOutput, error) {
	req, out := c.DeleteImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImageBuilder = "DeleteImageBuilder"

// DeleteImageBuilderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImageBuilder operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImageBuilder for more information on using the DeleteImageBuilder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteImageBuilderRequest method.
//    req, resp := client.DeleteImageBuilderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder
func (c *AppStream) DeleteImageBuilderRequest(input *DeleteImageBuilderInput) (req *request.Request, output *DeleteImageBuilderOutput) {
	op := &request.Operation{
		Name:       opDeleteImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImageBuilderInput{}
	}

	output = &DeleteImageBuilderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteImageBuilder API operation for Amazon AppStream.
//
// Deletes the specified image builder and releases the capacity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteImageBuilder for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The attempted operation is not permitted.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder
func (c *AppStream) DeleteImageBuilder(input *DeleteImageBuilderInput) (*DeleteImageBuilderOutput, error) {
	req, out := c.DeleteImageBuilderRequest(input)
	return out, req.Send()
}

// DeleteImageBuilderWithContext is the same as DeleteImageBuilder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImageBuilder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteImageBuilderWithContext(ctx aws.Context, input *DeleteImageBuilderInput, opts ...request.Option) (*DeleteImageBuilderOutput, error) {
	req, out := c.DeleteImageBuilderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStack operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStack for more information on using the DeleteStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStackRequest method.
//    req, resp := client.DeleteStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack
func (c *AppStream) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	output = &DeleteStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStack API operation for Amazon AppStream.
//
// Deletes the specified stack. After this operation completes, the environment
// can no longer be activated and any reservations made for the stack are released.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DeleteStack for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack
func (c *AppStream) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	return out, req.Send()
}

// DeleteStackWithContext is the same as DeleteStack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DeleteStackWithContext(ctx aws.Context, input *DeleteStackInput, opts ...request.Option) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectoryConfigs = "DescribeDirectoryConfigs"

// DescribeDirectoryConfigsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectoryConfigs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectoryConfigs for more information on using the DescribeDirectoryConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectoryConfigsRequest method.
//    req, resp := client.DescribeDirectoryConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs
func (c *AppStream) DescribeDirectoryConfigsRequest(input *DescribeDirectoryConfigsInput) (req *request.Request, output *DescribeDirectoryConfigsOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectoryConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectoryConfigsInput{}
	}

	output = &DescribeDirectoryConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectoryConfigs API operation for Amazon AppStream.
//
// Describes the specified directory configurations. Note that although the
// response syntax in this topic includes the account password, this password
// is not returned in the actual response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeDirectoryConfigs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs
func (c *AppStream) DescribeDirectoryConfigs(input *DescribeDirectoryConfigsInput) (*DescribeDirectoryConfigsOutput, error) {
	req, out := c.DescribeDirectoryConfigsRequest(input)
	return out, req.Send()
}

// DescribeDirectoryConfigsWithContext is the same as DescribeDirectoryConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectoryConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeDirectoryConfigsWithContext(ctx aws.Context, input *DescribeDirectoryConfigsInput, opts ...request.Option) (*DescribeDirectoryConfigsOutput, error) {
	req, out := c.DescribeDirectoryConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleets = "DescribeFleets"

// DescribeFleetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleets operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleets for more information on using the DescribeFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetsRequest method.
//    req, resp := client.DescribeFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets
func (c *AppStream) DescribeFleetsRequest(input *DescribeFleetsInput) (req *request.Request, output *DescribeFleetsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetsInput{}
	}

	output = &DescribeFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleets API operation for Amazon AppStream.
//
// Describes the specified fleets or all fleets in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeFleets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets
func (c *AppStream) DescribeFleets(input *DescribeFleetsInput) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	return out, req.Send()
}

// DescribeFleetsWithContext is the same as DescribeFleets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeFleetsWithContext(ctx aws.Context, input *DescribeFleetsInput, opts ...request.Option) (*DescribeFleetsOutput, error) {
	req, out := c.DescribeFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImageBuilders = "DescribeImageBuilders"

// DescribeImageBuildersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImageBuilders operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImageBuilders for more information on using the DescribeImageBuilders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImageBuildersRequest method.
//    req, resp := client.DescribeImageBuildersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders
func (c *AppStream) DescribeImageBuildersRequest(input *DescribeImageBuildersInput) (req *request.Request, output *DescribeImageBuildersOutput) {
	op := &request.Operation{
		Name:       opDescribeImageBuilders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImageBuildersInput{}
	}

	output = &DescribeImageBuildersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImageBuilders API operation for Amazon AppStream.
//
// Describes the specified image builders or all image builders in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeImageBuilders for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders
func (c *AppStream) DescribeImageBuilders(input *DescribeImageBuildersInput) (*DescribeImageBuildersOutput, error) {
	req, out := c.DescribeImageBuildersRequest(input)
	return out, req.Send()
}

// DescribeImageBuildersWithContext is the same as DescribeImageBuilders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImageBuilders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeImageBuildersWithContext(ctx aws.Context, input *DescribeImageBuildersInput, opts ...request.Option) (*DescribeImageBuildersOutput, error) {
	req, out := c.DescribeImageBuildersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeImages = "DescribeImages"

// DescribeImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeImages operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeImages for more information on using the DescribeImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeImagesRequest method.
//    req, resp := client.DescribeImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages
func (c *AppStream) DescribeImagesRequest(input *DescribeImagesInput) (req *request.Request, output *DescribeImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeImagesInput{}
	}

	output = &DescribeImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeImages API operation for Amazon AppStream.
//
// Describes the specified images or all images in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeImages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages
func (c *AppStream) DescribeImages(input *DescribeImagesInput) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	return out, req.Send()
}

// DescribeImagesWithContext is the same as DescribeImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeImagesWithContext(ctx aws.Context, input *DescribeImagesInput, opts ...request.Option) (*DescribeImagesOutput, error) {
	req, out := c.DescribeImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSessions = "DescribeSessions"

// DescribeSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSessions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSessions for more information on using the DescribeSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSessionsRequest method.
//    req, resp := client.DescribeSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions
func (c *AppStream) DescribeSessionsRequest(input *DescribeSessionsInput) (req *request.Request, output *DescribeSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSessionsInput{}
	}

	output = &DescribeSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSessions API operation for Amazon AppStream.
//
// Describes the streaming sessions for the specified stack and fleet. If a
// user ID is provided, only the streaming sessions for only that user are returned.
// If an authentication type is not provided, the default is to authenticate
// users using a streaming URL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions
func (c *AppStream) DescribeSessions(input *DescribeSessionsInput) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	return out, req.Send()
}

// DescribeSessionsWithContext is the same as DescribeSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeSessionsWithContext(ctx aws.Context, input *DescribeSessionsInput, opts ...request.Option) (*DescribeSessionsOutput, error) {
	req, out := c.DescribeSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStacks operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStacks for more information on using the DescribeStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStacksRequest method.
//    req, resp := client.DescribeStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks
func (c *AppStream) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	output = &DescribeStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStacks API operation for Amazon AppStream.
//
// Describes the specified stacks or all stacks in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DescribeStacks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks
func (c *AppStream) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	return out, req.Send()
}

// DescribeStacksWithContext is the same as DescribeStacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DescribeStacksWithContext(ctx aws.Context, input *DescribeStacksInput, opts ...request.Option) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFleet = "DisassociateFleet"

// DisassociateFleetRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFleet for more information on using the DisassociateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateFleetRequest method.
//    req, resp := client.DisassociateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet
func (c *AppStream) DisassociateFleetRequest(input *DisassociateFleetInput) (req *request.Request, output *DisassociateFleetOutput) {
	op := &request.Operation{
		Name:       opDisassociateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateFleetInput{}
	}

	output = &DisassociateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateFleet API operation for Amazon AppStream.
//
// Disassociates the specified fleet from the specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation DisassociateFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet
func (c *AppStream) DisassociateFleet(input *DisassociateFleetInput) (*DisassociateFleetOutput, error) {
	req, out := c.DisassociateFleetRequest(input)
	return out, req.Send()
}

// DisassociateFleetWithContext is the same as DisassociateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) DisassociateFleetWithContext(ctx aws.Context, input *DisassociateFleetInput, opts ...request.Option) (*DisassociateFleetOutput, error) {
	req, out := c.DisassociateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExpireSession = "ExpireSession"

// ExpireSessionRequest generates a "aws/request.Request" representing the
// client's request for the ExpireSession operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExpireSession for more information on using the ExpireSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExpireSessionRequest method.
//    req, resp := client.ExpireSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession
func (c *AppStream) ExpireSessionRequest(input *ExpireSessionInput) (req *request.Request, output *ExpireSessionOutput) {
	op := &request.Operation{
		Name:       opExpireSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExpireSessionInput{}
	}

	output = &ExpireSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExpireSession API operation for Amazon AppStream.
//
// Stops the specified streaming session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ExpireSession for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession
func (c *AppStream) ExpireSession(input *ExpireSessionInput) (*ExpireSessionOutput, error) {
	req, out := c.ExpireSessionRequest(input)
	return out, req.Send()
}

// ExpireSessionWithContext is the same as ExpireSession with the addition of
// the ability to pass a context and additional request options.
//
// See ExpireSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) ExpireSessionWithContext(ctx aws.Context, input *ExpireSessionInput, opts ...request.Option) (*ExpireSessionOutput, error) {
	req, out := c.ExpireSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociatedFleets = "ListAssociatedFleets"

// ListAssociatedFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedFleets operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedFleets for more information on using the ListAssociatedFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedFleetsRequest method.
//    req, resp := client.ListAssociatedFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets
func (c *AppStream) ListAssociatedFleetsRequest(input *ListAssociatedFleetsInput) (req *request.Request, output *ListAssociatedFleetsOutput) {
	op := &request.Operation{
		Name:       opListAssociatedFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociatedFleetsInput{}
	}

	output = &ListAssociatedFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedFleets API operation for Amazon AppStream.
//
// Lists the fleets associated with the specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ListAssociatedFleets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets
func (c *AppStream) ListAssociatedFleets(input *ListAssociatedFleetsInput) (*ListAssociatedFleetsOutput, error) {
	req, out := c.ListAssociatedFleetsRequest(input)
	return out, req.Send()
}

// ListAssociatedFleetsWithContext is the same as ListAssociatedFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) ListAssociatedFleetsWithContext(ctx aws.Context, input *ListAssociatedFleetsInput, opts ...request.Option) (*ListAssociatedFleetsOutput, error) {
	req, out := c.ListAssociatedFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssociatedStacks = "ListAssociatedStacks"

// ListAssociatedStacksRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedStacks operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedStacks for more information on using the ListAssociatedStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedStacksRequest method.
//    req, resp := client.ListAssociatedStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks
func (c *AppStream) ListAssociatedStacksRequest(input *ListAssociatedStacksInput) (req *request.Request, output *ListAssociatedStacksOutput) {
	op := &request.Operation{
		Name:       opListAssociatedStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociatedStacksInput{}
	}

	output = &ListAssociatedStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedStacks API operation for Amazon AppStream.
//
// Lists the stacks associated with the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ListAssociatedStacks for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks
func (c *AppStream) ListAssociatedStacks(input *ListAssociatedStacksInput) (*ListAssociatedStacksOutput, error) {
	req, out := c.ListAssociatedStacksRequest(input)
	return out, req.Send()
}

// ListAssociatedStacksWithContext is the same as ListAssociatedStacks with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) ListAssociatedStacksWithContext(ctx aws.Context, input *ListAssociatedStacksInput, opts ...request.Option) (*ListAssociatedStacksOutput, error) {
	req, out := c.ListAssociatedStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListTagsForResource
func (c *AppStream) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon AppStream.
//
// Lists the tags for the specified AppStream 2.0 resource. You can tag AppStream
// 2.0 image builders, images, fleets, and stacks.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
// in the Amazon AppStream 2.0 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListTagsForResource
func (c *AppStream) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFleet = "StartFleet"

// StartFleetRequest generates a "aws/request.Request" representing the
// client's request for the StartFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFleet for more information on using the StartFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFleetRequest method.
//    req, resp := client.StartFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet
func (c *AppStream) StartFleetRequest(input *StartFleetInput) (req *request.Request, output *StartFleetOutput) {
	op := &request.Operation{
		Name:       opStartFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFleetInput{}
	}

	output = &StartFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFleet API operation for Amazon AppStream.
//
// Starts the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StartFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The attempted operation is not permitted.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet
func (c *AppStream) StartFleet(input *StartFleetInput) (*StartFleetOutput, error) {
	req, out := c.StartFleetRequest(input)
	return out, req.Send()
}

// StartFleetWithContext is the same as StartFleet with the addition of
// the ability to pass a context and additional request options.
//
// See StartFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) StartFleetWithContext(ctx aws.Context, input *StartFleetInput, opts ...request.Option) (*StartFleetOutput, error) {
	req, out := c.StartFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartImageBuilder = "StartImageBuilder"

// StartImageBuilderRequest generates a "aws/request.Request" representing the
// client's request for the StartImageBuilder operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartImageBuilder for more information on using the StartImageBuilder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartImageBuilderRequest method.
//    req, resp := client.StartImageBuilderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder
func (c *AppStream) StartImageBuilderRequest(input *StartImageBuilderInput) (req *request.Request, output *StartImageBuilderOutput) {
	op := &request.Operation{
		Name:       opStartImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartImageBuilderInput{}
	}

	output = &StartImageBuilderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartImageBuilder API operation for Amazon AppStream.
//
// Starts the specified image builder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StartImageBuilder for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotAvailableException "ResourceNotAvailableException"
//   The specified resource exists and is not in use, but isn't available.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
//   * ErrCodeIncompatibleImageException "IncompatibleImageException"
//   The image does not support storage connectors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder
func (c *AppStream) StartImageBuilder(input *StartImageBuilderInput) (*StartImageBuilderOutput, error) {
	req, out := c.StartImageBuilderRequest(input)
	return out, req.Send()
}

// StartImageBuilderWithContext is the same as StartImageBuilder with the addition of
// the ability to pass a context and additional request options.
//
// See StartImageBuilder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) StartImageBuilderWithContext(ctx aws.Context, input *StartImageBuilderInput, opts ...request.Option) (*StartImageBuilderOutput, error) {
	req, out := c.StartImageBuilderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFleet = "StopFleet"

// StopFleetRequest generates a "aws/request.Request" representing the
// client's request for the StopFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFleet for more information on using the StopFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopFleetRequest method.
//    req, resp := client.StopFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet
func (c *AppStream) StopFleetRequest(input *StopFleetInput) (req *request.Request, output *StopFleetOutput) {
	op := &request.Operation{
		Name:       opStopFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopFleetInput{}
	}

	output = &StopFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopFleet API operation for Amazon AppStream.
//
// Stops the specified fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StopFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet
func (c *AppStream) StopFleet(input *StopFleetInput) (*StopFleetOutput, error) {
	req, out := c.StopFleetRequest(input)
	return out, req.Send()
}

// StopFleetWithContext is the same as StopFleet with the addition of
// the ability to pass a context and additional request options.
//
// See StopFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) StopFleetWithContext(ctx aws.Context, input *StopFleetInput, opts ...request.Option) (*StopFleetOutput, error) {
	req, out := c.StopFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopImageBuilder = "StopImageBuilder"

// StopImageBuilderRequest generates a "aws/request.Request" representing the
// client's request for the StopImageBuilder operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopImageBuilder for more information on using the StopImageBuilder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopImageBuilderRequest method.
//    req, resp := client.StopImageBuilderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder
func (c *AppStream) StopImageBuilderRequest(input *StopImageBuilderInput) (req *request.Request, output *StopImageBuilderOutput) {
	op := &request.Operation{
		Name:       opStopImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopImageBuilderInput{}
	}

	output = &StopImageBuilderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopImageBuilder API operation for Amazon AppStream.
//
// Stops the specified image builder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation StopImageBuilder for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The attempted operation is not permitted.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder
func (c *AppStream) StopImageBuilder(input *StopImageBuilderInput) (*StopImageBuilderOutput, error) {
	req, out := c.StopImageBuilderRequest(input)
	return out, req.Send()
}

// StopImageBuilderWithContext is the same as StopImageBuilder with the addition of
// the ability to pass a context and additional request options.
//
// See StopImageBuilder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) StopImageBuilderWithContext(ctx aws.Context, input *StopImageBuilderInput, opts ...request.Option) (*StopImageBuilderOutput, error) {
	req, out := c.StopImageBuilderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/TagResource
func (c *AppStream) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon AppStream.
//
// Adds or overwrites one or more tags for the specified AppStream 2.0 resource.
// You can tag AppStream 2.0 image builders, images, fleets, and stacks.
//
// Each tag consists of a key and an optional value. If a resource already has
// a tag with the same key, this operation updates its value.
//
// To list the current tags for your resources, use ListTagsForResource. To
// disassociate tags from your resources, use UntagResource.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
// in the Amazon AppStream 2.0 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/TagResource
func (c *AppStream) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UntagResource
func (c *AppStream) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon AppStream.
//
// Disassociates the specified tags from the specified AppStream 2.0 resource.
//
// To list the current tags for your resources, use ListTagsForResource.
//
// For more information about tags, see Tagging Your Resources (http://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
// in the Amazon AppStream 2.0 Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UntagResource
func (c *AppStream) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDirectoryConfig = "UpdateDirectoryConfig"

// UpdateDirectoryConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDirectoryConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDirectoryConfig for more information on using the UpdateDirectoryConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDirectoryConfigRequest method.
//    req, resp := client.UpdateDirectoryConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig
func (c *AppStream) UpdateDirectoryConfigRequest(input *UpdateDirectoryConfigInput) (req *request.Request, output *UpdateDirectoryConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateDirectoryConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDirectoryConfigInput{}
	}

	output = &UpdateDirectoryConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDirectoryConfig API operation for Amazon AppStream.
//
// Updates the specified directory configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateDirectoryConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig
func (c *AppStream) UpdateDirectoryConfig(input *UpdateDirectoryConfigInput) (*UpdateDirectoryConfigOutput, error) {
	req, out := c.UpdateDirectoryConfigRequest(input)
	return out, req.Send()
}

// UpdateDirectoryConfigWithContext is the same as UpdateDirectoryConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDirectoryConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UpdateDirectoryConfigWithContext(ctx aws.Context, input *UpdateDirectoryConfigInput, opts ...request.Option) (*UpdateDirectoryConfigOutput, error) {
	req, out := c.UpdateDirectoryConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleet = "UpdateFleet"

// UpdateFleetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleet operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleet for more information on using the UpdateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFleetRequest method.
//    req, resp := client.UpdateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet
func (c *AppStream) UpdateFleetRequest(input *UpdateFleetInput) (req *request.Request, output *UpdateFleetOutput) {
	op := &request.Operation{
		Name:       opUpdateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetInput{}
	}

	output = &UpdateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleet API operation for Amazon AppStream.
//
// Updates the specified fleet.
//
// If the fleet is in the STOPPED state, you can update any attribute except
// the fleet name. If the fleet is in the RUNNING state, you can update the
// DisplayName and ComputeCapacity attributes. If the fleet is in the STARTING
// or STOPPING state, you can't update it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateFleet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The specified role is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeResourceNotAvailableException "ResourceNotAvailableException"
//   The specified resource exists and is not in use, but isn't available.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   An API error occurred. Wait a few minutes and try again.
//
//   * ErrCodeIncompatibleImageException "IncompatibleImageException"
//   The image does not support storage connectors.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   The attempted operation is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet
func (c *AppStream) UpdateFleet(input *UpdateFleetInput) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	return out, req.Send()
}

// UpdateFleetWithContext is the same as UpdateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UpdateFleetWithContext(ctx aws.Context, input *UpdateFleetInput, opts ...request.Option) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStack operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStack for more information on using the UpdateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStackRequest method.
//    req, resp := client.UpdateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack
func (c *AppStream) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	output = &UpdateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStack API operation for Amazon AppStream.
//
// Updates the specified stack.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppStream's
// API operation UpdateStack for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The specified resource is in use.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The specified role is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Indicates an incorrect combination of parameters, or a missing parameter.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The requested limit exceeds the permitted limit for an account.
//
//   * ErrCodeIncompatibleImageException "IncompatibleImageException"
//   The image does not support storage connectors.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack
func (c *AppStream) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	return out, req.Send()
}

// UpdateStackWithContext is the same as UpdateStack with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppStream) UpdateStackWithContext(ctx aws.Context, input *UpdateStackInput, opts ...request.Option) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes an application in the application catalog.
type Application struct {
	_ struct{} `type:"structure"`

	// The application name for display.
	DisplayName *string `min:"1" type:"string"`

	// If there is a problem, the application can be disabled after image creation.
	Enabled *bool `type:"boolean"`

	// The URL for the application icon. This URL might be time-limited.
	IconURL *string `min:"1" type:"string"`

	// The arguments that are passed to the application at launch.
	LaunchParameters *string `min:"1" type:"string"`

	// The path to the application executable in the instance.
	LaunchPath *string `min:"1" type:"string"`

	// Additional attributes that describe the application.
	Metadata map[string]*string `type:"map"`

	// The name of the application.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Application) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Application) SetDisplayName(v string) *Application {
	s.DisplayName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *Application) SetEnabled(v bool) *Application {
	s.Enabled = &v
	return s
}

// SetIconURL sets the IconURL field's value.
func (s *Application) SetIconURL(v string) *Application {
	s.IconURL = &v
	return s
}

// SetLaunchParameters sets the LaunchParameters field's value.
func (s *Application) SetLaunchParameters(v string) *Application {
	s.LaunchParameters = &v
	return s
}

// SetLaunchPath sets the LaunchPath field's value.
func (s *Application) SetLaunchPath(v string) *Application {
	s.LaunchPath = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Application) SetMetadata(v map[string]*string) *Application {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *Application) SetName(v string) *Application {
	s.Name = &v
	return s
}

type AssociateFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateFleetInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *AssociateFleetInput) SetFleetName(v string) *AssociateFleetInput {
	s.FleetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *AssociateFleetInput) SetStackName(v string) *AssociateFleetInput {
	s.StackName = &v
	return s
}

type AssociateFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateFleetOutput) GoString() string {
	return s.String()
}

// Describes the capacity for a fleet.
type ComputeCapacity struct {
	_ struct{} `type:"structure"`

	// The desired number of streaming instances.
	//
	// DesiredInstances is a required field
	DesiredInstances *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ComputeCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeCapacity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeCapacity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputeCapacity"}
	if s.DesiredInstances == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredInstances"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredInstances sets the DesiredInstances field's value.
func (s *ComputeCapacity) SetDesiredInstances(v int64) *ComputeCapacity {
	s.DesiredInstances = &v
	return s
}

// Describes the capacity status for a fleet.
type ComputeCapacityStatus struct {
	_ struct{} `type:"structure"`

	// The number of currently available instances that can be used to stream sessions.
	Available *int64 `type:"integer"`

	// The desired number of streaming instances.
	//
	// Desired is a required field
	Desired *int64 `type:"integer" required:"true"`

	// The number of instances in use for streaming.
	InUse *int64 `type:"integer"`

	// The total number of simultaneous streaming instances that are running.
	Running *int64 `type:"integer"`
}

// String returns the string representation
func (s ComputeCapacityStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeCapacityStatus) GoString() string {
	return s.String()
}

// SetAvailable sets the Available field's value.
func (s *ComputeCapacityStatus) SetAvailable(v int64) *ComputeCapacityStatus {
	s.Available = &v
	return s
}

// SetDesired sets the Desired field's value.
func (s *ComputeCapacityStatus) SetDesired(v int64) *ComputeCapacityStatus {
	s.Desired = &v
	return s
}

// SetInUse sets the InUse field's value.
func (s *ComputeCapacityStatus) SetInUse(v int64) *ComputeCapacityStatus {
	s.InUse = &v
	return s
}

// SetRunning sets the Running field's value.
func (s *ComputeCapacityStatus) SetRunning(v int64) *ComputeCapacityStatus {
	s.Running = &v
	return s
}

type CopyImageInput struct {
	_ struct{} `type:"structure"`

	// The description that the image will have when it is copied to the destination.
	DestinationImageDescription *string `type:"string"`

	// The name that the image will have when it is copied to the destination.
	//
	// DestinationImageName is a required field
	DestinationImageName *string `type:"string" required:"true"`

	// The destination region to which the image will be copied. This parameter
	// is required, even if you are copying an image within the same region.
	//
	// DestinationRegion is a required field
	DestinationRegion *string `min:"1" type:"string" required:"true"`

	// The name of the image to copy.
	//
	// SourceImageName is a required field
	SourceImageName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyImageInput"}
	if s.DestinationImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationImageName"))
	}
	if s.DestinationRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationRegion"))
	}
	if s.DestinationRegion != nil && len(*s.DestinationRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationRegion", 1))
	}
	if s.SourceImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationImageDescription sets the DestinationImageDescription field's value.
func (s *CopyImageInput) SetDestinationImageDescription(v string) *CopyImageInput {
	s.DestinationImageDescription = &v
	return s
}

// SetDestinationImageName sets the DestinationImageName field's value.
func (s *CopyImageInput) SetDestinationImageName(v string) *CopyImageInput {
	s.DestinationImageName = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CopyImageInput) SetDestinationRegion(v string) *CopyImageInput {
	s.DestinationRegion = &v
	return s
}

// SetSourceImageName sets the SourceImageName field's value.
func (s *CopyImageInput) SetSourceImageName(v string) *CopyImageInput {
	s.SourceImageName = &v
	return s
}

type CopyImageOutput struct {
	_ struct{} `type:"structure"`

	// The name of the destination image.
	DestinationImageName *string `type:"string"`
}

// String returns the string representation
func (s CopyImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyImageOutput) GoString() string {
	return s.String()
}

// SetDestinationImageName sets the DestinationImageName field's value.
func (s *CopyImageOutput) SetDestinationImageName(v string) *CopyImageOutput {
	s.DestinationImageName = &v
	return s
}

type CreateDirectoryConfigInput struct {
	_ struct{} `type:"structure"`

	// The fully qualified name of the directory (for example, corp.example.com).
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`

	// The distinguished names of the organizational units for computer accounts.
	//
	// OrganizationalUnitDistinguishedNames is a required field
	OrganizationalUnitDistinguishedNames []*string `type:"list" required:"true"`

	// The credentials for the service account used by the streaming instance to
	// connect to the directory.
	//
	// ServiceAccountCredentials is a required field
	ServiceAccountCredentials *ServiceAccountCredentials `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateDirectoryConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectoryConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectoryConfigInput"}
	if s.DirectoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryName"))
	}
	if s.OrganizationalUnitDistinguishedNames == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationalUnitDistinguishedNames"))
	}
	if s.ServiceAccountCredentials == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccountCredentials"))
	}
	if s.ServiceAccountCredentials != nil {
		if err := s.ServiceAccountCredentials.Validate(); err != nil {
			invalidParams.AddNested("ServiceAccountCredentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *CreateDirectoryConfigInput) SetDirectoryName(v string) *CreateDirectoryConfigInput {
	s.DirectoryName = &v
	return s
}

// SetOrganizationalUnitDistinguishedNames sets the OrganizationalUnitDistinguishedNames field's value.
func (s *CreateDirectoryConfigInput) SetOrganizationalUnitDistinguishedNames(v []*string) *CreateDirectoryConfigInput {
	s.OrganizationalUnitDistinguishedNames = v
	return s
}

// SetServiceAccountCredentials sets the ServiceAccountCredentials field's value.
func (s *CreateDirectoryConfigInput) SetServiceAccountCredentials(v *ServiceAccountCredentials) *CreateDirectoryConfigInput {
	s.ServiceAccountCredentials = v
	return s
}

type CreateDirectoryConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directory configuration.
	DirectoryConfig *DirectoryConfig `type:"structure"`
}

// String returns the string representation
func (s CreateDirectoryConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryConfigOutput) GoString() string {
	return s.String()
}

// SetDirectoryConfig sets the DirectoryConfig field's value.
func (s *CreateDirectoryConfigOutput) SetDirectoryConfig(v *DirectoryConfig) *CreateDirectoryConfigOutput {
	s.DirectoryConfig = v
	return s
}

type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// The desired capacity for the fleet.
	//
	// ComputeCapacity is a required field
	ComputeCapacity *ComputeCapacity `type:"structure" required:"true"`

	// The description for display.
	Description *string `type:"string"`

	// The time after disconnection when a session is considered to have ended,
	// in seconds. If a user who was disconnected reconnects within this time interval,
	// the user is connected to their previous session. Specify a value between
	// 60 and 57600.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The fleet name for display.
	DisplayName *string `type:"string"`

	// The information needed to join a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the fleet.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The fleet type.
	//
	// ALWAYS_ONProvides users with instant-on access to their apps. You are charged
	// for all running instances in your fleet, even if no users are streaming apps.
	//
	// ON_DEMANDProvide users with access to applications after they connect, which
	// takes one to two minutes. You are charged for instance streaming when users
	// are connected and a small hourly fee for instances that are not streaming
	// apps.
	FleetType *string `type:"string" enum:"FleetType"`

	// The name of the image used to create the fleet.
	//
	// ImageName is a required field
	ImageName *string `min:"1" type:"string" required:"true"`

	// The instance type to use when launching fleet instances. The following instance
	// types are available:
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The maximum time that a streaming session can run, in seconds. Specify a
	// value between 600 and 57600.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// A unique name for the fleet.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.ComputeCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeCapacity"))
	}
	if s.ImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageName"))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ComputeCapacity != nil {
		if err := s.ComputeCapacity.Validate(); err != nil {
			invalidParams.AddNested("ComputeCapacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeCapacity sets the ComputeCapacity field's value.
func (s *CreateFleetInput) SetComputeCapacity(v *ComputeCapacity) *CreateFleetInput {
	s.ComputeCapacity = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetInput) SetDescription(v string) *CreateFleetInput {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *CreateFleetInput) SetDisconnectTimeoutInSeconds(v int64) *CreateFleetInput {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateFleetInput) SetDisplayName(v string) *CreateFleetInput {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *CreateFleetInput) SetDomainJoinInfo(v *DomainJoinInfo) *CreateFleetInput {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *CreateFleetInput) SetEnableDefaultInternetAccess(v bool) *CreateFleetInput {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *CreateFleetInput) SetFleetType(v string) *CreateFleetInput {
	s.FleetType = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *CreateFleetInput) SetImageName(v string) *CreateFleetInput {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateFleetInput) SetInstanceType(v string) *CreateFleetInput {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *CreateFleetInput) SetMaxUserDurationInSeconds(v int64) *CreateFleetInput {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFleetInput) SetName(v string) *CreateFleetInput {
	s.Name = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateFleetInput) SetVpcConfig(v *VpcConfig) *CreateFleetInput {
	s.VpcConfig = v
	return s
}

type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the fleet.
	Fleet *Fleet `type:"structure"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetFleet sets the Fleet field's value.
func (s *CreateFleetOutput) SetFleet(v *Fleet) *CreateFleetOutput {
	s.Fleet = v
	return s
}

type CreateImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The version of the AppStream 2.0 agent to use for this image builder. To
	// use the latest version of the AppStream 2.0 agent, specify [LATEST].
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The description for display.
	Description *string `type:"string"`

	// The image builder name for display.
	DisplayName *string `type:"string"`

	// The information needed to join a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the image builder.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The name of the image used to create the builder.
	//
	// ImageName is a required field
	ImageName *string `min:"1" type:"string" required:"true"`

	// The instance type to use when launching the image builder.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// A unique name for the image builder.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The VPC configuration for the image builder. You can specify only one subnet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageBuilderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageBuilderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImageBuilderInput"}
	if s.AppstreamAgentVersion != nil && len(*s.AppstreamAgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppstreamAgentVersion", 1))
	}
	if s.ImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageName"))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppstreamAgentVersion sets the AppstreamAgentVersion field's value.
func (s *CreateImageBuilderInput) SetAppstreamAgentVersion(v string) *CreateImageBuilderInput {
	s.AppstreamAgentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateImageBuilderInput) SetDescription(v string) *CreateImageBuilderInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateImageBuilderInput) SetDisplayName(v string) *CreateImageBuilderInput {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *CreateImageBuilderInput) SetDomainJoinInfo(v *DomainJoinInfo) *CreateImageBuilderInput {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *CreateImageBuilderInput) SetEnableDefaultInternetAccess(v bool) *CreateImageBuilderInput {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *CreateImageBuilderInput) SetImageName(v string) *CreateImageBuilderInput {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateImageBuilderInput) SetInstanceType(v string) *CreateImageBuilderInput {
	s.InstanceType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateImageBuilderInput) SetName(v string) *CreateImageBuilderInput {
	s.Name = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateImageBuilderInput) SetVpcConfig(v *VpcConfig) *CreateImageBuilderInput {
	s.VpcConfig = v
	return s
}

type CreateImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s CreateImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageBuilderOutput) GoString() string {
	return s.String()
}

// SetImageBuilder sets the ImageBuilder field's value.
func (s *CreateImageBuilderOutput) SetImageBuilder(v *ImageBuilder) *CreateImageBuilderOutput {
	s.ImageBuilder = v
	return s
}

type CreateImageBuilderStreamingURLInput struct {
	_ struct{} `type:"structure"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The time that the streaming URL will be valid, in seconds. Specify a value
	// between 1 and 604800 seconds. The default is 3600 seconds.
	Validity *int64 `type:"long"`
}

// String returns the string representation
func (s CreateImageBuilderStreamingURLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageBuilderStreamingURLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageBuilderStreamingURLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImageBuilderStreamingURLInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateImageBuilderStreamingURLInput) SetName(v string) *CreateImageBuilderStreamingURLInput {
	s.Name = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CreateImageBuilderStreamingURLInput) SetValidity(v int64) *CreateImageBuilderStreamingURLInput {
	s.Validity = &v
	return s
}

type CreateImageBuilderStreamingURLOutput struct {
	_ struct{} `type:"structure"`

	// The elapsed time, in seconds after the Unix epoch, when this URL expires.
	Expires *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The URL to start the AppStream 2.0 streaming session.
	StreamingURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateImageBuilderStreamingURLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImageBuilderStreamingURLOutput) GoString() string {
	return s.String()
}

// SetExpires sets the Expires field's value.
func (s *CreateImageBuilderStreamingURLOutput) SetExpires(v time.Time) *CreateImageBuilderStreamingURLOutput {
	s.Expires = &v
	return s
}

// SetStreamingURL sets the StreamingURL field's value.
func (s *CreateImageBuilderStreamingURLOutput) SetStreamingURL(v string) *CreateImageBuilderStreamingURLOutput {
	s.StreamingURL = &v
	return s
}

type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// The description for display.
	Description *string `type:"string"`

	// The stack name for display.
	DisplayName *string `type:"string"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The URL the user is redirected to after the streaming session ends.
	RedirectURL *string `type:"string"`

	// The storage connectors to enable.
	StorageConnectors []*StorageConnector `type:"list"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StorageConnectors != nil {
		for i, v := range s.StorageConnectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StorageConnectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateStackInput) SetDescription(v string) *CreateStackInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateStackInput) SetDisplayName(v string) *CreateStackInput {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStackInput) SetName(v string) *CreateStackInput {
	s.Name = &v
	return s
}

// SetRedirectURL sets the RedirectURL field's value.
func (s *CreateStackInput) SetRedirectURL(v string) *CreateStackInput {
	s.RedirectURL = &v
	return s
}

// SetStorageConnectors sets the StorageConnectors field's value.
func (s *CreateStackInput) SetStorageConnectors(v []*StorageConnector) *CreateStackInput {
	s.StorageConnectors = v
	return s
}

type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	// Information about the stack.
	Stack *Stack `type:"structure"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// SetStack sets the Stack field's value.
func (s *CreateStackOutput) SetStack(v *Stack) *CreateStackOutput {
	s.Stack = v
	return s
}

type CreateStreamingURLInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to launch after the session starts. This is the
	// name that you specified as Name in the Image Assistant.
	ApplicationId *string `min:"1" type:"string"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The session context. For more information, see Session Context (http://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters)
	// in the Amazon AppStream 2.0 Developer Guide.
	SessionContext *string `min:"1" type:"string"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The ID of the user.
	//
	// UserId is a required field
	UserId *string `min:"2" type:"string" required:"true"`

	// The time that the streaming URL will be valid, in seconds. Specify a value
	// between 1 and 604800 seconds. The default is 60 seconds.
	Validity *int64 `type:"long"`
}

// String returns the string representation
func (s CreateStreamingURLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingURLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingURLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamingURLInput"}
	if s.ApplicationId != nil && len(*s.ApplicationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationId", 1))
	}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.SessionContext != nil && len(*s.SessionContext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionContext", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateStreamingURLInput) SetApplicationId(v string) *CreateStreamingURLInput {
	s.ApplicationId = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *CreateStreamingURLInput) SetFleetName(v string) *CreateStreamingURLInput {
	s.FleetName = &v
	return s
}

// SetSessionContext sets the SessionContext field's value.
func (s *CreateStreamingURLInput) SetSessionContext(v string) *CreateStreamingURLInput {
	s.SessionContext = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CreateStreamingURLInput) SetStackName(v string) *CreateStreamingURLInput {
	s.StackName = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateStreamingURLInput) SetUserId(v string) *CreateStreamingURLInput {
	s.UserId = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *CreateStreamingURLInput) SetValidity(v int64) *CreateStreamingURLInput {
	s.Validity = &v
	return s
}

type CreateStreamingURLOutput struct {
	_ struct{} `type:"structure"`

	// The elapsed time, in seconds after the Unix epoch, when this URL expires.
	Expires *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The URL to start the AppStream 2.0 streaming session.
	StreamingURL *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStreamingURLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingURLOutput) GoString() string {
	return s.String()
}

// SetExpires sets the Expires field's value.
func (s *CreateStreamingURLOutput) SetExpires(v time.Time) *CreateStreamingURLOutput {
	s.Expires = &v
	return s
}

// SetStreamingURL sets the StreamingURL field's value.
func (s *CreateStreamingURLOutput) SetStreamingURL(v string) *CreateStreamingURLOutput {
	s.StreamingURL = &v
	return s
}

type DeleteDirectoryConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the directory configuration.
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectoryConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectoryConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectoryConfigInput"}
	if s.DirectoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *DeleteDirectoryConfigInput) SetDirectoryName(v string) *DeleteDirectoryConfigInput {
	s.DirectoryName = &v
	return s
}

type DeleteDirectoryConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDirectoryConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryConfigOutput) GoString() string {
	return s.String()
}

type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteFleetInput) SetName(v string) *DeleteFleetInput {
	s.Name = &v
	return s
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

type DeleteImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImageBuilderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImageBuilderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImageBuilderInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteImageBuilderInput) SetName(v string) *DeleteImageBuilderInput {
	s.Name = &v
	return s
}

type DeleteImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s DeleteImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImageBuilderOutput) GoString() string {
	return s.String()
}

// SetImageBuilder sets the ImageBuilder field's value.
func (s *DeleteImageBuilderOutput) SetImageBuilder(v *ImageBuilder) *DeleteImageBuilderOutput {
	s.ImageBuilder = v
	return s
}

type DeleteImageInput struct {
	_ struct{} `type:"structure"`

	// The name of the image.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImageInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteImageInput) SetName(v string) *DeleteImageInput {
	s.Name = &v
	return s
}

type DeleteImageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image.
	Image *Image `type:"structure"`
}

// String returns the string representation
func (s DeleteImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImageOutput) GoString() string {
	return s.String()
}

// SetImage sets the Image field's value.
func (s *DeleteImageOutput) SetImage(v *Image) *DeleteImageOutput {
	s.Image = v
	return s
}

type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteStackInput) SetName(v string) *DeleteStackInput {
	s.Name = &v
	return s
}

type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

type DescribeDirectoryConfigsInput struct {
	_ struct{} `type:"structure"`

	// The directory names.
	DirectoryNames []*string `type:"list"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDirectoryConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoryConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDirectoryConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDirectoryConfigsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryNames sets the DirectoryNames field's value.
func (s *DescribeDirectoryConfigsInput) SetDirectoryNames(v []*string) *DescribeDirectoryConfigsInput {
	s.DirectoryNames = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDirectoryConfigsInput) SetMaxResults(v int64) *DescribeDirectoryConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectoryConfigsInput) SetNextToken(v string) *DescribeDirectoryConfigsInput {
	s.NextToken = &v
	return s
}

type DescribeDirectoryConfigsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directory configurations. Note that although the response
	// syntax in this topic includes the account password, this password is not
	// returned in the actual response.
	DirectoryConfigs []*DirectoryConfig `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDirectoryConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoryConfigsOutput) GoString() string {
	return s.String()
}

// SetDirectoryConfigs sets the DirectoryConfigs field's value.
func (s *DescribeDirectoryConfigsOutput) SetDirectoryConfigs(v []*DirectoryConfig) *DescribeDirectoryConfigsOutput {
	s.DirectoryConfigs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectoryConfigsOutput) SetNextToken(v string) *DescribeDirectoryConfigsOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetsInput struct {
	_ struct{} `type:"structure"`

	// The names of the fleets to describe.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *DescribeFleetsInput) SetNames(v []*string) *DescribeFleetsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetsInput) SetNextToken(v string) *DescribeFleetsInput {
	s.NextToken = &v
	return s
}

type DescribeFleetsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the fleets.
	Fleets []*Fleet `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetsOutput) GoString() string {
	return s.String()
}

// SetFleets sets the Fleets field's value.
func (s *DescribeFleetsOutput) SetFleets(v []*Fleet) *DescribeFleetsOutput {
	s.Fleets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetsOutput) SetNextToken(v string) *DescribeFleetsOutput {
	s.NextToken = &v
	return s
}

type DescribeImageBuildersInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The names of the image builders to describe.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeImageBuildersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImageBuildersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImageBuildersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeImageBuildersInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeImageBuildersInput) SetMaxResults(v int64) *DescribeImageBuildersInput {
	s.MaxResults = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeImageBuildersInput) SetNames(v []*string) *DescribeImageBuildersInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImageBuildersInput) SetNextToken(v string) *DescribeImageBuildersInput {
	s.NextToken = &v
	return s
}

type DescribeImageBuildersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builders.
	ImageBuilders []*ImageBuilder `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeImageBuildersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImageBuildersOutput) GoString() string {
	return s.String()
}

// SetImageBuilders sets the ImageBuilders field's value.
func (s *DescribeImageBuildersOutput) SetImageBuilders(v []*ImageBuilder) *DescribeImageBuildersOutput {
	s.ImageBuilders = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeImageBuildersOutput) SetNextToken(v string) *DescribeImageBuildersOutput {
	s.NextToken = &v
	return s
}

type DescribeImagesInput struct {
	_ struct{} `type:"structure"`

	// The names of the images to describe.
	Names []*string `type:"list"`
}

// String returns the string representation
func (s DescribeImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesInput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *DescribeImagesInput) SetNames(v []*string) *DescribeImagesInput {
	s.Names = v
	return s
}

type DescribeImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the images.
	Images []*Image `type:"list"`
}

// String returns the string representation
func (s DescribeImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeImagesOutput) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *DescribeImagesOutput) SetImages(v []*Image) *DescribeImagesOutput {
	s.Images = v
	return s
}

type DescribeSessionsInput struct {
	_ struct{} `type:"structure"`

	// The authentication method. Specify API for a user authenticated using a streaming
	// URL or SAML for a SAML federated user. The default is to authenticate users
	// using a streaming URL.
	AuthenticationType *string `type:"string" enum:"AuthenticationType"`

	// The name of the fleet. This value is case-sensitive.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The size of each page of results. The default value is 20 and the maximum
	// value is 50.
	Limit *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack. This value is case-sensitive.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The user ID.
	UserId *string `min:"2" type:"string"`
}

// String returns the string representation
func (s DescribeSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSessionsInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *DescribeSessionsInput) SetAuthenticationType(v string) *DescribeSessionsInput {
	s.AuthenticationType = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *DescribeSessionsInput) SetFleetName(v string) *DescribeSessionsInput {
	s.FleetName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeSessionsInput) SetLimit(v int64) *DescribeSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSessionsInput) SetNextToken(v string) *DescribeSessionsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DescribeSessionsInput) SetStackName(v string) *DescribeSessionsInput {
	s.StackName = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeSessionsInput) SetUserId(v string) *DescribeSessionsInput {
	s.UserId = &v
	return s
}

type DescribeSessionsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about the streaming sessions.
	Sessions []*Session `type:"list"`
}

// String returns the string representation
func (s DescribeSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSessionsOutput) SetNextToken(v string) *DescribeSessionsOutput {
	s.NextToken = &v
	return s
}

// SetSessions sets the Sessions field's value.
func (s *DescribeSessionsOutput) SetSessions(v []*Session) *DescribeSessionsOutput {
	s.Sessions = v
	return s
}

type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// The names of the stacks to describe.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStacksInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *DescribeStacksInput) SetNames(v []*string) *DescribeStacksInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksInput) SetNextToken(v string) *DescribeStacksInput {
	s.NextToken = &v
	return s
}

type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about the stacks.
	Stacks []*Stack `type:"list"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeStacksOutput) SetNextToken(v string) *DescribeStacksOutput {
	s.NextToken = &v
	return s
}

// SetStacks sets the Stacks field's value.
func (s *DescribeStacksOutput) SetStacks(v []*Stack) *DescribeStacksOutput {
	s.Stacks = v
	return s
}

// Configuration information for the directory used to join domains.
type DirectoryConfig struct {
	_ struct{} `type:"structure"`

	// The time the directory configuration was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The fully qualified name of the directory (for example, corp.example.com).
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`

	// The distinguished names of the organizational units for computer accounts.
	OrganizationalUnitDistinguishedNames []*string `type:"list"`

	// The credentials for the service account used by the streaming instance to
	// connect to the directory.
	ServiceAccountCredentials *ServiceAccountCredentials `type:"structure"`
}

// String returns the string representation
func (s DirectoryConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryConfig) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *DirectoryConfig) SetCreatedTime(v time.Time) *DirectoryConfig {
	s.CreatedTime = &v
	return s
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *DirectoryConfig) SetDirectoryName(v string) *DirectoryConfig {
	s.DirectoryName = &v
	return s
}

// SetOrganizationalUnitDistinguishedNames sets the OrganizationalUnitDistinguishedNames field's value.
func (s *DirectoryConfig) SetOrganizationalUnitDistinguishedNames(v []*string) *DirectoryConfig {
	s.OrganizationalUnitDistinguishedNames = v
	return s
}

// SetServiceAccountCredentials sets the ServiceAccountCredentials field's value.
func (s *DirectoryConfig) SetServiceAccountCredentials(v *ServiceAccountCredentials) *DirectoryConfig {
	s.ServiceAccountCredentials = v
	return s
}

type DisassociateFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateFleetInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *DisassociateFleetInput) SetFleetName(v string) *DisassociateFleetInput {
	s.FleetName = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *DisassociateFleetInput) SetStackName(v string) *DisassociateFleetInput {
	s.StackName = &v
	return s
}

type DisassociateFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateFleetOutput) GoString() string {
	return s.String()
}

// Contains the information needed to join a Microsoft Active Directory domain.
type DomainJoinInfo struct {
	_ struct{} `type:"structure"`

	// The fully qualified name of the directory (for example, corp.example.com).
	DirectoryName *string `type:"string"`

	// The distinguished name of the organizational unit for computer accounts.
	OrganizationalUnitDistinguishedName *string `type:"string"`
}

// String returns the string representation
func (s DomainJoinInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainJoinInfo) GoString() string {
	return s.String()
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *DomainJoinInfo) SetDirectoryName(v string) *DomainJoinInfo {
	s.DirectoryName = &v
	return s
}

// SetOrganizationalUnitDistinguishedName sets the OrganizationalUnitDistinguishedName field's value.
func (s *DomainJoinInfo) SetOrganizationalUnitDistinguishedName(v string) *DomainJoinInfo {
	s.OrganizationalUnitDistinguishedName = &v
	return s
}

type ExpireSessionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the streaming session.
	//
	// SessionId is a required field
	SessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExpireSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpireSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpireSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExpireSessionInput"}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSessionId sets the SessionId field's value.
func (s *ExpireSessionInput) SetSessionId(v string) *ExpireSessionInput {
	s.SessionId = &v
	return s
}

type ExpireSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExpireSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpireSessionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for a fleet.
type Fleet struct {
	_ struct{} `type:"structure"`

	// The ARN for the fleet.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The capacity status for the fleet.
	//
	// ComputeCapacityStatus is a required field
	ComputeCapacityStatus *ComputeCapacityStatus `type:"structure" required:"true"`

	// The time the fleet was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description for display.
	Description *string `min:"1" type:"string"`

	// The time after disconnection when a session is considered to have ended,
	// in seconds. If a user who was disconnected reconnects within this time interval,
	// the user is connected to their previous session. Specify a value between
	// 60 and 57600.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The fleet name for display.
	DisplayName *string `min:"1" type:"string"`

	// The information needed to join a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Indicates whether default internet access is enabled for the fleet.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The fleet errors.
	FleetErrors []*FleetError `type:"list"`

	// The fleet type.
	//
	// ALWAYS_ONProvides users with instant-on access to their apps. You are charged
	// for all running instances in your fleet, even if no users are streaming apps.
	//
	// ON_DEMANDProvide users with access to applications after they connect, which
	// takes one to two minutes. You are charged for instance streaming when users
	// are connected and a small hourly fee for instances that are not streaming
	// apps.
	FleetType *string `type:"string" enum:"FleetType"`

	// The name of the image used to create the fleet.
	//
	// ImageName is a required field
	ImageName *string `min:"1" type:"string" required:"true"`

	// The instance type to use when launching fleet instances.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The maximum time that a streaming session can run, in seconds. Specify a
	// value between 600 and 57600.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The current state for the fleet.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"FleetState"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s Fleet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Fleet) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Fleet) SetArn(v string) *Fleet {
	s.Arn = &v
	return s
}

// SetComputeCapacityStatus sets the ComputeCapacityStatus field's value.
func (s *Fleet) SetComputeCapacityStatus(v *ComputeCapacityStatus) *Fleet {
	s.ComputeCapacityStatus = v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Fleet) SetCreatedTime(v time.Time) *Fleet {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Fleet) SetDescription(v string) *Fleet {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *Fleet) SetDisconnectTimeoutInSeconds(v int64) *Fleet {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Fleet) SetDisplayName(v string) *Fleet {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *Fleet) SetDomainJoinInfo(v *DomainJoinInfo) *Fleet {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *Fleet) SetEnableDefaultInternetAccess(v bool) *Fleet {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetFleetErrors sets the FleetErrors field's value.
func (s *Fleet) SetFleetErrors(v []*FleetError) *Fleet {
	s.FleetErrors = v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *Fleet) SetFleetType(v string) *Fleet {
	s.FleetType = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *Fleet) SetImageName(v string) *Fleet {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Fleet) SetInstanceType(v string) *Fleet {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *Fleet) SetMaxUserDurationInSeconds(v int64) *Fleet {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *Fleet) SetName(v string) *Fleet {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Fleet) SetState(v string) *Fleet {
	s.State = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *Fleet) SetVpcConfig(v *VpcConfig) *Fleet {
	s.VpcConfig = v
	return s
}

// Describes a fleet error.
type FleetError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"FleetErrorCode"`

	// The error message.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FleetError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FleetError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FleetError) SetErrorCode(v string) *FleetError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FleetError) SetErrorMessage(v string) *FleetError {
	s.ErrorMessage = &v
	return s
}

// Describes an image.
type Image struct {
	_ struct{} `type:"structure"`

	// The applications associated with the image.
	Applications []*Application `type:"list"`

	// The version of the AppStream 2.0 agent to use for instances that are launched
	// from this image.
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The ARN of the image.
	Arn *string `type:"string"`

	// The ARN of the image from which this image was created.
	BaseImageArn *string `type:"string"`

	// The time the image was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description for display.
	Description *string `min:"1" type:"string"`

	// The image name for display.
	DisplayName *string `min:"1" type:"string"`

	// Indicates whether an image builder can be launched from this image.
	ImageBuilderSupported *bool `type:"boolean"`

	// The name of the image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The operating system platform of the image.
	Platform *string `type:"string" enum:"PlatformType"`

	// The release date of the public base image. For private images, this date
	// is the release date of the base image from which the image was created.
	PublicBaseImageReleasedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The image starts in the PENDING state. If image creation succeeds, the state
	// is AVAILABLE. If image creation fails, the state is FAILED.
	State *string `type:"string" enum:"ImageState"`

	// The reason why the last state change occurred.
	StateChangeReason *ImageStateChangeReason `type:"structure"`

	// Indicates whether the image is public or private.
	Visibility *string `type:"string" enum:"VisibilityType"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Image) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *Image) SetApplications(v []*Application) *Image {
	s.Applications = v
	return s
}

// SetAppstreamAgentVersion sets the AppstreamAgentVersion field's value.
func (s *Image) SetAppstreamAgentVersion(v string) *Image {
	s.AppstreamAgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Image) SetArn(v string) *Image {
	s.Arn = &v
	return s
}

// SetBaseImageArn sets the BaseImageArn field's value.
func (s *Image) SetBaseImageArn(v string) *Image {
	s.BaseImageArn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Image) SetCreatedTime(v time.Time) *Image {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Image) SetDescription(v string) *Image {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Image) SetDisplayName(v string) *Image {
	s.DisplayName = &v
	return s
}

// SetImageBuilderSupported sets the ImageBuilderSupported field's value.
func (s *Image) SetImageBuilderSupported(v bool) *Image {
	s.ImageBuilderSupported = &v
	return s
}

// SetName sets the Name field's value.
func (s *Image) SetName(v string) *Image {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Image) SetPlatform(v string) *Image {
	s.Platform = &v
	return s
}

// SetPublicBaseImageReleasedDate sets the PublicBaseImageReleasedDate field's value.
func (s *Image) SetPublicBaseImageReleasedDate(v time.Time) *Image {
	s.PublicBaseImageReleasedDate = &v
	return s
}

// SetState sets the State field's value.
func (s *Image) SetState(v string) *Image {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *Image) SetStateChangeReason(v *ImageStateChangeReason) *Image {
	s.StateChangeReason = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *Image) SetVisibility(v string) *Image {
	s.Visibility = &v
	return s
}

// Describes a streaming instance used for editing an image. New images are
// created from a snapshot through an image builder.
type ImageBuilder struct {
	_ struct{} `type:"structure"`

	// The version of the AppStream 2.0 agent that is currently being used by this
	// image builder.
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The ARN for the image builder.
	Arn *string `type:"string"`

	// The time stamp when the image builder was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description for display.
	Description *string `min:"1" type:"string"`

	// The image builder name for display.
	DisplayName *string `min:"1" type:"string"`

	// The information needed to join a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the image builder.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The ARN of the image from which this builder was created.
	ImageArn *string `type:"string"`

	// The image builder errors.
	ImageBuilderErrors []*ResourceError `type:"list"`

	// The instance type for the image builder.
	InstanceType *string `min:"1" type:"string"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The operating system platform of the image builder.
	Platform *string `type:"string" enum:"PlatformType"`

	// The state of the image builder.
	State *string `type:"string" enum:"ImageBuilderState"`

	// The reason why the last state change occurred.
	StateChangeReason *ImageBuilderStateChangeReason `type:"structure"`

	// The VPC configuration of the image builder.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s ImageBuilder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageBuilder) GoString() string {
	return s.String()
}

// SetAppstreamAgentVersion sets the AppstreamAgentVersion field's value.
func (s *ImageBuilder) SetAppstreamAgentVersion(v string) *ImageBuilder {
	s.AppstreamAgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ImageBuilder) SetArn(v string) *ImageBuilder {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ImageBuilder) SetCreatedTime(v time.Time) *ImageBuilder {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ImageBuilder) SetDescription(v string) *ImageBuilder {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ImageBuilder) SetDisplayName(v string) *ImageBuilder {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *ImageBuilder) SetDomainJoinInfo(v *DomainJoinInfo) *ImageBuilder {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *ImageBuilder) SetEnableDefaultInternetAccess(v bool) *ImageBuilder {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetImageArn sets the ImageArn field's value.
func (s *ImageBuilder) SetImageArn(v string) *ImageBuilder {
	s.ImageArn = &v
	return s
}

// SetImageBuilderErrors sets the ImageBuilderErrors field's value.
func (s *ImageBuilder) SetImageBuilderErrors(v []*ResourceError) *ImageBuilder {
	s.ImageBuilderErrors = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ImageBuilder) SetInstanceType(v string) *ImageBuilder {
	s.InstanceType = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImageBuilder) SetName(v string) *ImageBuilder {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ImageBuilder) SetPlatform(v string) *ImageBuilder {
	s.Platform = &v
	return s
}

// SetState sets the State field's value.
func (s *ImageBuilder) SetState(v string) *ImageBuilder {
	s.State = &v
	return s
}

// SetStateChangeReason sets the StateChangeReason field's value.
func (s *ImageBuilder) SetStateChangeReason(v *ImageBuilderStateChangeReason) *ImageBuilder {
	s.StateChangeReason = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *ImageBuilder) SetVpcConfig(v *VpcConfig) *ImageBuilder {
	s.VpcConfig = v
	return s
}

// Describes the reason why the last image builder state change occurred.
type ImageBuilderStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The state change reason code.
	Code *string `type:"string" enum:"ImageBuilderStateChangeReasonCode"`

	// The state change reason message.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ImageBuilderStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageBuilderStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ImageBuilderStateChangeReason) SetCode(v string) *ImageBuilderStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ImageBuilderStateChangeReason) SetMessage(v string) *ImageBuilderStateChangeReason {
	s.Message = &v
	return s
}

// Describes the reason why the last image state change occurred.
type ImageStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The state change reason code.
	Code *string `type:"string" enum:"ImageStateChangeReasonCode"`

	// The state change reason message.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ImageStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageStateChangeReason) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ImageStateChangeReason) SetCode(v string) *ImageStateChangeReason {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ImageStateChangeReason) SetMessage(v string) *ImageStateChangeReason {
	s.Message = &v
	return s
}

type ListAssociatedFleetsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAssociatedFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedFleetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StackName == nil {
		invalidParams.Add(request.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedFleetsInput) SetNextToken(v string) *ListAssociatedFleetsInput {
	s.NextToken = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *ListAssociatedFleetsInput) SetStackName(v string) *ListAssociatedFleetsInput {
	s.StackName = &v
	return s
}

type ListAssociatedFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the fleets.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedFleetsOutput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *ListAssociatedFleetsOutput) SetNames(v []*string) *ListAssociatedFleetsOutput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedFleetsOutput) SetNextToken(v string) *ListAssociatedFleetsOutput {
	s.NextToken = &v
	return s
}

type ListAssociatedStacksInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedStacksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedStacksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedStacksInput"}
	if s.FleetName == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetName"))
	}
	if s.FleetName != nil && len(*s.FleetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetName sets the FleetName field's value.
func (s *ListAssociatedStacksInput) SetFleetName(v string) *ListAssociatedStacksInput {
	s.FleetName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedStacksInput) SetNextToken(v string) *ListAssociatedStacksInput {
	s.NextToken = &v
	return s
}

type ListAssociatedStacksOutput struct {
	_ struct{} `type:"structure"`

	// The names of the stacks.
	Names []*string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociatedStacksOutput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *ListAssociatedStacksOutput) SetNames(v []*string) *ListAssociatedStacksOutput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedStacksOutput) SetNextToken(v string) *ListAssociatedStacksOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The information about the tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Describes a resource error.
type ResourceError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"FleetErrorCode"`

	// The error message.
	ErrorMessage *string `min:"1" type:"string"`

	// The time the error occurred.
	ErrorTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ResourceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ResourceError) SetErrorCode(v string) *ResourceError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ResourceError) SetErrorMessage(v string) *ResourceError {
	s.ErrorMessage = &v
	return s
}

// SetErrorTimestamp sets the ErrorTimestamp field's value.
func (s *ResourceError) SetErrorTimestamp(v time.Time) *ResourceError {
	s.ErrorTimestamp = &v
	return s
}

// Describes the credentials for the service account used by the streaming instance
// to connect to the directory.
type ServiceAccountCredentials struct {
	_ struct{} `type:"structure"`

	// The user name of the account. This account must have the following privileges:
	// create computer objects, join computers to the domain, and change/reset the
	// password on descendant computer objects for the organizational units specified.
	//
	// AccountName is a required field
	AccountName *string `min:"1" type:"string" required:"true"`

	// The password for the account.
	//
	// AccountPassword is a required field
	AccountPassword *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceAccountCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceAccountCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceAccountCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceAccountCredentials"}
	if s.AccountName == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountName"))
	}
	if s.AccountName != nil && len(*s.AccountName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountName", 1))
	}
	if s.AccountPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountPassword"))
	}
	if s.AccountPassword != nil && len(*s.AccountPassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountPassword", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountName sets the AccountName field's value.
func (s *ServiceAccountCredentials) SetAccountName(v string) *ServiceAccountCredentials {
	s.AccountName = &v
	return s
}

// SetAccountPassword sets the AccountPassword field's value.
func (s *ServiceAccountCredentials) SetAccountPassword(v string) *ServiceAccountCredentials {
	s.AccountPassword = &v
	return s
}

// Describes a streaming session.
type Session struct {
	_ struct{} `type:"structure"`

	// The authentication method. The user is authenticated using a streaming URL
	// (API) or SAML federation (SAML).
	AuthenticationType *string `type:"string" enum:"AuthenticationType"`

	// The name of the fleet for the streaming session.
	//
	// FleetName is a required field
	FleetName *string `min:"1" type:"string" required:"true"`

	// The ID of the streaming session.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the stack for the streaming session.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The current state of the streaming session.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"SessionState"`

	// The identifier of the user for whom the session was created.
	//
	// UserId is a required field
	UserId *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s Session) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Session) GoString() string {
	return s.String()
}

// SetAuthenticationType sets the AuthenticationType field's value.
func (s *Session) SetAuthenticationType(v string) *Session {
	s.AuthenticationType = &v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *Session) SetFleetName(v string) *Session {
	s.FleetName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Session) SetId(v string) *Session {
	s.Id = &v
	return s
}

// SetStackName sets the StackName field's value.
func (s *Session) SetStackName(v string) *Session {
	s.StackName = &v
	return s
}

// SetState sets the State field's value.
func (s *Session) SetState(v string) *Session {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *Session) SetUserId(v string) *Session {
	s.UserId = &v
	return s
}

// Describes a stack.
type Stack struct {
	_ struct{} `type:"structure"`

	// The ARN of the stack.
	Arn *string `type:"string"`

	// The time the stack was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description for display.
	Description *string `min:"1" type:"string"`

	// The stack name for display.
	DisplayName *string `min:"1" type:"string"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The URL the user is redirected to after the streaming session ends.
	RedirectURL *string `type:"string"`

	// The errors for the stack.
	StackErrors []*StackError `type:"list"`

	// The storage connectors to enable.
	StorageConnectors []*StorageConnector `type:"list"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Stack) SetArn(v string) *Stack {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Stack) SetCreatedTime(v time.Time) *Stack {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Stack) SetDescription(v string) *Stack {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Stack) SetDisplayName(v string) *Stack {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Stack) SetName(v string) *Stack {
	s.Name = &v
	return s
}

// SetRedirectURL sets the RedirectURL field's value.
func (s *Stack) SetRedirectURL(v string) *Stack {
	s.RedirectURL = &v
	return s
}

// SetStackErrors sets the StackErrors field's value.
func (s *Stack) SetStackErrors(v []*StackError) *Stack {
	s.StackErrors = v
	return s
}

// SetStorageConnectors sets the StorageConnectors field's value.
func (s *Stack) SetStorageConnectors(v []*StorageConnector) *Stack {
	s.StorageConnectors = v
	return s
}

// Describes a stack error.
type StackError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"StackErrorCode"`

	// The error message.
	ErrorMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StackError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *StackError) SetErrorCode(v string) *StackError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *StackError) SetErrorMessage(v string) *StackError {
	s.ErrorMessage = &v
	return s
}

type StartFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartFleetInput) SetName(v string) *StartFleetInput {
	s.Name = &v
	return s
}

type StartFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFleetOutput) GoString() string {
	return s.String()
}

type StartImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The version of the AppStream 2.0 agent to use for this image builder. To
	// use the latest version of the AppStream 2.0 agent, specify [LATEST].
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartImageBuilderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartImageBuilderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartImageBuilderInput"}
	if s.AppstreamAgentVersion != nil && len(*s.AppstreamAgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppstreamAgentVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppstreamAgentVersion sets the AppstreamAgentVersion field's value.
func (s *StartImageBuilderInput) SetAppstreamAgentVersion(v string) *StartImageBuilderInput {
	s.AppstreamAgentVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartImageBuilderInput) SetName(v string) *StartImageBuilderInput {
	s.Name = &v
	return s
}

type StartImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s StartImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartImageBuilderOutput) GoString() string {
	return s.String()
}

// SetImageBuilder sets the ImageBuilder field's value.
func (s *StartImageBuilderOutput) SetImageBuilder(v *ImageBuilder) *StartImageBuilderOutput {
	s.ImageBuilder = v
	return s
}

type StopFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopFleetInput) SetName(v string) *StopFleetInput {
	s.Name = &v
	return s
}

type StopFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFleetOutput) GoString() string {
	return s.String()
}

type StopImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The name of the image builder.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopImageBuilderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopImageBuilderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopImageBuilderInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopImageBuilderInput) SetName(v string) *StopImageBuilderInput {
	s.Name = &v
	return s
}

type StopImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s StopImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopImageBuilderOutput) GoString() string {
	return s.String()
}

// SetImageBuilder sets the ImageBuilder field's value.
func (s *StopImageBuilderOutput) SetImageBuilder(v *ImageBuilder) *StopImageBuilderOutput {
	s.ImageBuilder = v
	return s
}

// Describes a storage connector.
type StorageConnector struct {
	_ struct{} `type:"structure"`

	// The type of storage connector.
	//
	// ConnectorType is a required field
	ConnectorType *string `type:"string" required:"true" enum:"StorageConnectorType"`

	// The ARN of the storage connector.
	ResourceIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StorageConnector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageConnector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageConnector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageConnector"}
	if s.ConnectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorType"))
	}
	if s.ResourceIdentifier != nil && len(*s.ResourceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorType sets the ConnectorType field's value.
func (s *StorageConnector) SetConnectorType(v string) *StorageConnector {
	s.ConnectorType = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *StorageConnector) SetResourceIdentifier(v string) *StorageConnector {
	s.ResourceIdentifier = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tags to associate. A tag is a key-value pair (the value is optional).
	// For example, Environment=Test, or, if you do not specify a value, Environment=.
	//
	// If you do not specify a value, we set the value to an empty string.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag keys for the tags to disassociate.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDirectoryConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the directory configuration.
	//
	// DirectoryName is a required field
	DirectoryName *string `type:"string" required:"true"`

	// The distinguished names of the organizational units for computer accounts.
	OrganizationalUnitDistinguishedNames []*string `type:"list"`

	// The credentials for the service account used by the streaming instance to
	// connect to the directory.
	ServiceAccountCredentials *ServiceAccountCredentials `type:"structure"`
}

// String returns the string representation
func (s UpdateDirectoryConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDirectoryConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDirectoryConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDirectoryConfigInput"}
	if s.DirectoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryName"))
	}
	if s.ServiceAccountCredentials != nil {
		if err := s.ServiceAccountCredentials.Validate(); err != nil {
			invalidParams.AddNested("ServiceAccountCredentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *UpdateDirectoryConfigInput) SetDirectoryName(v string) *UpdateDirectoryConfigInput {
	s.DirectoryName = &v
	return s
}

// SetOrganizationalUnitDistinguishedNames sets the OrganizationalUnitDistinguishedNames field's value.
func (s *UpdateDirectoryConfigInput) SetOrganizationalUnitDistinguishedNames(v []*string) *UpdateDirectoryConfigInput {
	s.OrganizationalUnitDistinguishedNames = v
	return s
}

// SetServiceAccountCredentials sets the ServiceAccountCredentials field's value.
func (s *UpdateDirectoryConfigInput) SetServiceAccountCredentials(v *ServiceAccountCredentials) *UpdateDirectoryConfigInput {
	s.ServiceAccountCredentials = v
	return s
}

type UpdateDirectoryConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directory configuration.
	DirectoryConfig *DirectoryConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateDirectoryConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDirectoryConfigOutput) GoString() string {
	return s.String()
}

// SetDirectoryConfig sets the DirectoryConfig field's value.
func (s *UpdateDirectoryConfigOutput) SetDirectoryConfig(v *DirectoryConfig) *UpdateDirectoryConfigOutput {
	s.DirectoryConfig = v
	return s
}

type UpdateFleetInput struct {
	_ struct{} `type:"structure"`

	// The fleet attributes to delete.
	AttributesToDelete []*string `type:"list"`

	// The desired capacity for the fleet.
	ComputeCapacity *ComputeCapacity `type:"structure"`

	// Deletes the VPC association for the specified fleet.
	DeleteVpcConfig *bool `deprecated:"true" type:"boolean"`

	// The description for display.
	Description *string `type:"string"`

	// The time after disconnection when a session is considered to have ended,
	// in seconds. If a user who was disconnected reconnects within this time interval,
	// the user is connected to their previous session. Specify a value between
	// 60 and 57600.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The fleet name for display.
	DisplayName *string `type:"string"`

	// The information needed to join a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the fleet.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The name of the image used to create the fleet.
	ImageName *string `min:"1" type:"string"`

	// The instance type to use when launching fleet instances. The following instance
	// types are available:
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	InstanceType *string `min:"1" type:"string"`

	// The maximum time that a streaming session can run, in seconds. Specify a
	// value between 600 and 57600.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// A unique name for the fleet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFleetInput"}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ComputeCapacity != nil {
		if err := s.ComputeCapacity.Validate(); err != nil {
			invalidParams.AddNested("ComputeCapacity", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToDelete sets the AttributesToDelete field's value.
func (s *UpdateFleetInput) SetAttributesToDelete(v []*string) *UpdateFleetInput {
	s.AttributesToDelete = v
	return s
}

// SetComputeCapacity sets the ComputeCapacity field's value.
func (s *UpdateFleetInput) SetComputeCapacity(v *ComputeCapacity) *UpdateFleetInput {
	s.ComputeCapacity = v
	return s
}

// SetDeleteVpcConfig sets the DeleteVpcConfig field's value.
func (s *UpdateFleetInput) SetDeleteVpcConfig(v bool) *UpdateFleetInput {
	s.DeleteVpcConfig = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFleetInput) SetDescription(v string) *UpdateFleetInput {
	s.Description = &v
	return s
}

// SetDisconnectTimeoutInSeconds sets the DisconnectTimeoutInSeconds field's value.
func (s *UpdateFleetInput) SetDisconnectTimeoutInSeconds(v int64) *UpdateFleetInput {
	s.DisconnectTimeoutInSeconds = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateFleetInput) SetDisplayName(v string) *UpdateFleetInput {
	s.DisplayName = &v
	return s
}

// SetDomainJoinInfo sets the DomainJoinInfo field's value.
func (s *UpdateFleetInput) SetDomainJoinInfo(v *DomainJoinInfo) *UpdateFleetInput {
	s.DomainJoinInfo = v
	return s
}

// SetEnableDefaultInternetAccess sets the EnableDefaultInternetAccess field's value.
func (s *UpdateFleetInput) SetEnableDefaultInternetAccess(v bool) *UpdateFleetInput {
	s.EnableDefaultInternetAccess = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *UpdateFleetInput) SetImageName(v string) *UpdateFleetInput {
	s.ImageName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *UpdateFleetInput) SetInstanceType(v string) *UpdateFleetInput {
	s.InstanceType = &v
	return s
}

// SetMaxUserDurationInSeconds sets the MaxUserDurationInSeconds field's value.
func (s *UpdateFleetInput) SetMaxUserDurationInSeconds(v int64) *UpdateFleetInput {
	s.MaxUserDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFleetInput) SetName(v string) *UpdateFleetInput {
	s.Name = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateFleetInput) SetVpcConfig(v *VpcConfig) *UpdateFleetInput {
	s.VpcConfig = v
	return s
}

type UpdateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the fleet.
	Fleet *Fleet `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFleetOutput) GoString() string {
	return s.String()
}

// SetFleet sets the Fleet field's value.
func (s *UpdateFleetOutput) SetFleet(v *Fleet) *UpdateFleetOutput {
	s.Fleet = v
	return s
}

type UpdateStackInput struct {
	_ struct{} `type:"structure"`

	// The stack attributes to delete.
	AttributesToDelete []*string `type:"list"`

	// Deletes the storage connectors currently enabled for the stack.
	DeleteStorageConnectors *bool `deprecated:"true" type:"boolean"`

	// The description for display.
	Description *string `type:"string"`

	// The stack name for display.
	DisplayName *string `type:"string"`

	// The name of the stack.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The URL the user is redirected to after the streaming session ends.
	RedirectURL *string `type:"string"`

	// The storage connectors to enable.
	StorageConnectors []*StorageConnector `type:"list"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStackInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StorageConnectors != nil {
		for i, v := range s.StorageConnectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StorageConnectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToDelete sets the AttributesToDelete field's value.
func (s *UpdateStackInput) SetAttributesToDelete(v []*string) *UpdateStackInput {
	s.AttributesToDelete = v
	return s
}

// SetDeleteStorageConnectors sets the DeleteStorageConnectors field's value.
func (s *UpdateStackInput) SetDeleteStorageConnectors(v bool) *UpdateStackInput {
	s.DeleteStorageConnectors = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateStackInput) SetDescription(v string) *UpdateStackInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateStackInput) SetDisplayName(v string) *UpdateStackInput {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStackInput) SetName(v string) *UpdateStackInput {
	s.Name = &v
	return s
}

// SetRedirectURL sets the RedirectURL field's value.
func (s *UpdateStackInput) SetRedirectURL(v string) *UpdateStackInput {
	s.RedirectURL = &v
	return s
}

// SetStorageConnectors sets the StorageConnectors field's value.
func (s *UpdateStackInput) SetStorageConnectors(v []*StorageConnector) *UpdateStackInput {
	s.StorageConnectors = v
	return s
}

type UpdateStackOutput struct {
	_ struct{} `type:"structure"`

	// Information about the stack.
	Stack *Stack `type:"structure"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

// SetStack sets the Stack field's value.
func (s *UpdateStackOutput) SetStack(v *Stack) *UpdateStackOutput {
	s.Stack = v
	return s
}

// Describes VPC configuration information.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// The security groups for the fleet.
	SecurityGroupIds []*string `type:"list"`

	// The subnets to which a network interface is established from the fleet instance.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

const (
	// AuthenticationTypeApi is a AuthenticationType enum value
	AuthenticationTypeApi = "API"

	// AuthenticationTypeSaml is a AuthenticationType enum value
	AuthenticationTypeSaml = "SAML"

	// AuthenticationTypeUserpool is a AuthenticationType enum value
	AuthenticationTypeUserpool = "USERPOOL"
)

// The fleet attribute.
const (
	// FleetAttributeVpcConfiguration is a FleetAttribute enum value
	FleetAttributeVpcConfiguration = "VPC_CONFIGURATION"

	// FleetAttributeVpcConfigurationSecurityGroupIds is a FleetAttribute enum value
	FleetAttributeVpcConfigurationSecurityGroupIds = "VPC_CONFIGURATION_SECURITY_GROUP_IDS"

	// FleetAttributeDomainJoinInfo is a FleetAttribute enum value
	FleetAttributeDomainJoinInfo = "DOMAIN_JOIN_INFO"
)

const (
	// FleetErrorCodeIamServiceRoleMissingEniDescribeAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniDescribeAction = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"

	// FleetErrorCodeIamServiceRoleMissingEniCreateAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniCreateAction = "IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"

	// FleetErrorCodeIamServiceRoleMissingEniDeleteAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingEniDeleteAction = "IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"

	// FleetErrorCodeNetworkInterfaceLimitExceeded is a FleetErrorCode enum value
	FleetErrorCodeNetworkInterfaceLimitExceeded = "NETWORK_INTERFACE_LIMIT_EXCEEDED"

	// FleetErrorCodeInternalServiceError is a FleetErrorCode enum value
	FleetErrorCodeInternalServiceError = "INTERNAL_SERVICE_ERROR"

	// FleetErrorCodeIamServiceRoleIsMissing is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleIsMissing = "IAM_SERVICE_ROLE_IS_MISSING"

	// FleetErrorCodeSubnetHasInsufficientIpAddresses is a FleetErrorCode enum value
	FleetErrorCodeSubnetHasInsufficientIpAddresses = "SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"

	// FleetErrorCodeIamServiceRoleMissingDescribeSubnetAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingDescribeSubnetAction = "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"

	// FleetErrorCodeSubnetNotFound is a FleetErrorCode enum value
	FleetErrorCodeSubnetNotFound = "SUBNET_NOT_FOUND"

	// FleetErrorCodeImageNotFound is a FleetErrorCode enum value
	FleetErrorCodeImageNotFound = "IMAGE_NOT_FOUND"

	// FleetErrorCodeInvalidSubnetConfiguration is a FleetErrorCode enum value
	FleetErrorCodeInvalidSubnetConfiguration = "INVALID_SUBNET_CONFIGURATION"

	// FleetErrorCodeSecurityGroupsNotFound is a FleetErrorCode enum value
	FleetErrorCodeSecurityGroupsNotFound = "SECURITY_GROUPS_NOT_FOUND"

	// FleetErrorCodeIgwNotAttached is a FleetErrorCode enum value
	FleetErrorCodeIgwNotAttached = "IGW_NOT_ATTACHED"

	// FleetErrorCodeIamServiceRoleMissingDescribeSecurityGroupsAction is a FleetErrorCode enum value
	FleetErrorCodeIamServiceRoleMissingDescribeSecurityGroupsAction = "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"

	// FleetErrorCodeDomainJoinErrorFileNotFound is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorFileNotFound = "DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"

	// FleetErrorCodeDomainJoinErrorAccessDenied is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorAccessDenied = "DOMAIN_JOIN_ERROR_ACCESS_DENIED"

	// FleetErrorCodeDomainJoinErrorLogonFailure is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorLogonFailure = "DOMAIN_JOIN_ERROR_LOGON_FAILURE"

	// FleetErrorCodeDomainJoinErrorInvalidParameter is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorInvalidParameter = "DOMAIN_JOIN_ERROR_INVALID_PARAMETER"

	// FleetErrorCodeDomainJoinErrorMoreData is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorMoreData = "DOMAIN_JOIN_ERROR_MORE_DATA"

	// FleetErrorCodeDomainJoinErrorNoSuchDomain is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorNoSuchDomain = "DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"

	// FleetErrorCodeDomainJoinErrorNotSupported is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorNotSupported = "DOMAIN_JOIN_ERROR_NOT_SUPPORTED"

	// FleetErrorCodeDomainJoinNerrInvalidWorkgroupName is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinNerrInvalidWorkgroupName = "DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"

	// FleetErrorCodeDomainJoinNerrWorkstationNotStarted is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinNerrWorkstationNotStarted = "DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"

	// FleetErrorCodeDomainJoinErrorDsMachineAccountQuotaExceeded is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinErrorDsMachineAccountQuotaExceeded = "DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"

	// FleetErrorCodeDomainJoinNerrPasswordExpired is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinNerrPasswordExpired = "DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"

	// FleetErrorCodeDomainJoinInternalServiceError is a FleetErrorCode enum value
	FleetErrorCodeDomainJoinInternalServiceError = "DOMAIN_JOIN_INTERNAL_SERVICE_ERROR"
)

const (
	// FleetStateStarting is a FleetState enum value
	FleetStateStarting = "STARTING"

	// FleetStateRunning is a FleetState enum value
	FleetStateRunning = "RUNNING"

	// FleetStateStopping is a FleetState enum value
	FleetStateStopping = "STOPPING"

	// FleetStateStopped is a FleetState enum value
	FleetStateStopped = "STOPPED"
)

const (
	// FleetTypeAlwaysOn is a FleetType enum value
	FleetTypeAlwaysOn = "ALWAYS_ON"

	// FleetTypeOnDemand is a FleetType enum value
	FleetTypeOnDemand = "ON_DEMAND"
)

const (
	// ImageBuilderStatePending is a ImageBuilderState enum value
	ImageBuilderStatePending = "PENDING"

	// ImageBuilderStateUpdatingAgent is a ImageBuilderState enum value
	ImageBuilderStateUpdatingAgent = "UPDATING_AGENT"

	// ImageBuilderStateRunning is a ImageBuilderState enum value
	ImageBuilderStateRunning = "RUNNING"

	// ImageBuilderStateStopping is a ImageBuilderState enum value
	ImageBuilderStateStopping = "STOPPING"

	// ImageBuilderStateStopped is a ImageBuilderState enum value
	ImageBuilderStateStopped = "STOPPED"

	// ImageBuilderStateRebooting is a ImageBuilderState enum value
	ImageBuilderStateRebooting = "REBOOTING"

	// ImageBuilderStateSnapshotting is a ImageBuilderState enum value
	ImageBuilderStateSnapshotting = "SNAPSHOTTING"

	// ImageBuilderStateDeleting is a ImageBuilderState enum value
	ImageBuilderStateDeleting = "DELETING"

	// ImageBuilderStateFailed is a ImageBuilderState enum value
	ImageBuilderStateFailed = "FAILED"
)

const (
	// ImageBuilderStateChangeReasonCodeInternalError is a ImageBuilderStateChangeReasonCode enum value
	ImageBuilderStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// ImageBuilderStateChangeReasonCodeImageUnavailable is a ImageBuilderStateChangeReasonCode enum value
	ImageBuilderStateChangeReasonCodeImageUnavailable = "IMAGE_UNAVAILABLE"
)

const (
	// ImageStatePending is a ImageState enum value
	ImageStatePending = "PENDING"

	// ImageStateAvailable is a ImageState enum value
	ImageStateAvailable = "AVAILABLE"

	// ImageStateFailed is a ImageState enum value
	ImageStateFailed = "FAILED"

	// ImageStateCopying is a ImageState enum value
	ImageStateCopying = "COPYING"

	// ImageStateDeleting is a ImageState enum value
	ImageStateDeleting = "DELETING"
)

const (
	// ImageStateChangeReasonCodeInternalError is a ImageStateChangeReasonCode enum value
	ImageStateChangeReasonCodeInternalError = "INTERNAL_ERROR"

	// ImageStateChangeReasonCodeImageBuilderNotAvailable is a ImageStateChangeReasonCode enum value
	ImageStateChangeReasonCodeImageBuilderNotAvailable = "IMAGE_BUILDER_NOT_AVAILABLE"

	// ImageStateChangeReasonCodeImageCopyFailure is a ImageStateChangeReasonCode enum value
	ImageStateChangeReasonCodeImageCopyFailure = "IMAGE_COPY_FAILURE"
)

const (
	// PlatformTypeWindows is a PlatformType enum value
	PlatformTypeWindows = "WINDOWS"
)

// Possible values for the state of a streaming session.
const (
	// SessionStateActive is a SessionState enum value
	SessionStateActive = "ACTIVE"

	// SessionStatePending is a SessionState enum value
	SessionStatePending = "PENDING"

	// SessionStateExpired is a SessionState enum value
	SessionStateExpired = "EXPIRED"
)

const (
	// StackAttributeStorageConnectors is a StackAttribute enum value
	StackAttributeStorageConnectors = "STORAGE_CONNECTORS"

	// StackAttributeRedirectUrl is a StackAttribute enum value
	StackAttributeRedirectUrl = "REDIRECT_URL"
)

const (
	// StackErrorCodeStorageConnectorError is a StackErrorCode enum value
	StackErrorCodeStorageConnectorError = "STORAGE_CONNECTOR_ERROR"

	// StackErrorCodeInternalServiceError is a StackErrorCode enum value
	StackErrorCodeInternalServiceError = "INTERNAL_SERVICE_ERROR"
)

// The type of storage connector.
const (
	// StorageConnectorTypeHomefolders is a StorageConnectorType enum value
	StorageConnectorTypeHomefolders = "HOMEFOLDERS"
)

const (
	// VisibilityTypePublic is a VisibilityType enum value
	VisibilityTypePublic = "PUBLIC"

	// VisibilityTypePrivate is a VisibilityType enum value
	VisibilityTypePrivate = "PRIVATE"
)
