// Code generated by protoc-gen-go. DO NOT EDIT.
// source: as/as.proto

package as

import (
	context "context"
	fmt "fmt"
	common "github.com/brocaar/chirpstack-api/go/v3/common"
	gw "github.com/brocaar/chirpstack-api/go/v3/gw"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type RXWindow int32

const (
	RXWindow_RX1 RXWindow = 0
	RXWindow_RX2 RXWindow = 1
)

var RXWindow_name = map[int32]string{
	0: "RX1",
	1: "RX2",
}

var RXWindow_value = map[string]int32{
	"RX1": 0,
	"RX2": 1,
}

func (x RXWindow) String() string {
	return proto.EnumName(RXWindow_name, int32(x))
}

func (RXWindow) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{0}
}

type ErrorType int32

const (
	// Generic error type.
	ErrorType_GENERIC ErrorType = 0
	// OTAA error.
	ErrorType_OTAA ErrorType = 1
	// Uplink frame-counter was reset.
	ErrorType_DATA_UP_FCNT_RESET ErrorType = 2
	// Uplink MIC error.
	ErrorType_DATA_UP_MIC ErrorType = 3
	// Downlink payload size error.
	ErrorType_DEVICE_QUEUE_ITEM_SIZE ErrorType = 4
	// Downlink frame-counter error.
	ErrorType_DEVICE_QUEUE_ITEM_FCNT ErrorType = 5
	// Uplink frame-counter retransmission.
	ErrorType_DATA_UP_FCNT_RETRANSMISSION ErrorType = 6
	// Downlink gateway error.
	ErrorType_DATA_DOWN_GATEWAY ErrorType = 7
)

var ErrorType_name = map[int32]string{
	0: "GENERIC",
	1: "OTAA",
	2: "DATA_UP_FCNT_RESET",
	3: "DATA_UP_MIC",
	4: "DEVICE_QUEUE_ITEM_SIZE",
	5: "DEVICE_QUEUE_ITEM_FCNT",
	6: "DATA_UP_FCNT_RETRANSMISSION",
	7: "DATA_DOWN_GATEWAY",
}

var ErrorType_value = map[string]int32{
	"GENERIC":                     0,
	"OTAA":                        1,
	"DATA_UP_FCNT_RESET":          2,
	"DATA_UP_MIC":                 3,
	"DEVICE_QUEUE_ITEM_SIZE":      4,
	"DEVICE_QUEUE_ITEM_FCNT":      5,
	"DATA_UP_FCNT_RETRANSMISSION": 6,
	"DATA_DOWN_GATEWAY":           7,
}

func (x ErrorType) String() string {
	return proto.EnumName(ErrorType_name, int32(x))
}

func (ErrorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{1}
}

type DeviceActivationContext struct {
	// Assigned Device Address.
	DevAddr []byte `protobuf:"bytes,1,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	// Application session key (envelope).
	AppSKey              *common.KeyEnvelope `protobuf:"bytes,2,opt,name=app_s_key,json=appSKey,proto3" json:"app_s_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *DeviceActivationContext) Reset()         { *m = DeviceActivationContext{} }
func (m *DeviceActivationContext) String() string { return proto.CompactTextString(m) }
func (*DeviceActivationContext) ProtoMessage()    {}
func (*DeviceActivationContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{0}
}

func (m *DeviceActivationContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceActivationContext.Unmarshal(m, b)
}
func (m *DeviceActivationContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceActivationContext.Marshal(b, m, deterministic)
}
func (m *DeviceActivationContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceActivationContext.Merge(m, src)
}
func (m *DeviceActivationContext) XXX_Size() int {
	return xxx_messageInfo_DeviceActivationContext.Size(m)
}
func (m *DeviceActivationContext) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceActivationContext.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceActivationContext proto.InternalMessageInfo

func (m *DeviceActivationContext) GetDevAddr() []byte {
	if m != nil {
		return m.DevAddr
	}
	return nil
}

func (m *DeviceActivationContext) GetAppSKey() *common.KeyEnvelope {
	if m != nil {
		return m.AppSKey
	}
	return nil
}

type HandleUplinkDataRequest struct {
	// DevEUI EUI (8 bytes).
	DevEui []byte `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Join EUI used for OTAA activation (8 bytes).
	JoinEui []byte `protobuf:"bytes,2,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
	// Frame-counter.
	FCnt uint32 `protobuf:"varint,3,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// Frame port.
	FPort uint32 `protobuf:"varint,4,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// ADR enabled.
	Adr bool `protobuf:"varint,5,opt,name=adr,proto3" json:"adr,omitempty"`
	// Data-rate.
	Dr uint32 `protobuf:"varint,6,opt,name=dr,proto3" json:"dr,omitempty"`
	// TX meta-data.
	TxInfo *gw.UplinkTXInfo `protobuf:"bytes,7,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
	// RX meta-data.
	RxInfo []*gw.UplinkRXInfo `protobuf:"bytes,8,rep,name=rx_info,json=rxInfo,proto3" json:"rx_info,omitempty"`
	// Received data (encrypted).
	Data []byte `protobuf:"bytes,9,opt,name=data,proto3" json:"data,omitempty"`
	// Device activation context.
	//
	// This field is only set on the first uplink frame when the security
	// context has changed (e.g. a new OTAA (re)activation).
	DeviceActivationContext *DeviceActivationContext `protobuf:"bytes,10,opt,name=device_activation_context,json=deviceActivationContext,proto3" json:"device_activation_context,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                 `json:"-"`
	XXX_unrecognized        []byte                   `json:"-"`
	XXX_sizecache           int32                    `json:"-"`
}

func (m *HandleUplinkDataRequest) Reset()         { *m = HandleUplinkDataRequest{} }
func (m *HandleUplinkDataRequest) String() string { return proto.CompactTextString(m) }
func (*HandleUplinkDataRequest) ProtoMessage()    {}
func (*HandleUplinkDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{1}
}

func (m *HandleUplinkDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandleUplinkDataRequest.Unmarshal(m, b)
}
func (m *HandleUplinkDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandleUplinkDataRequest.Marshal(b, m, deterministic)
}
func (m *HandleUplinkDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleUplinkDataRequest.Merge(m, src)
}
func (m *HandleUplinkDataRequest) XXX_Size() int {
	return xxx_messageInfo_HandleUplinkDataRequest.Size(m)
}
func (m *HandleUplinkDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleUplinkDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleUplinkDataRequest proto.InternalMessageInfo

func (m *HandleUplinkDataRequest) GetDevEui() []byte {
	if m != nil {
		return m.DevEui
	}
	return nil
}

func (m *HandleUplinkDataRequest) GetJoinEui() []byte {
	if m != nil {
		return m.JoinEui
	}
	return nil
}

func (m *HandleUplinkDataRequest) GetFCnt() uint32 {
	if m != nil {
		return m.FCnt
	}
	return 0
}

func (m *HandleUplinkDataRequest) GetFPort() uint32 {
	if m != nil {
		return m.FPort
	}
	return 0
}

func (m *HandleUplinkDataRequest) GetAdr() bool {
	if m != nil {
		return m.Adr
	}
	return false
}

func (m *HandleUplinkDataRequest) GetDr() uint32 {
	if m != nil {
		return m.Dr
	}
	return 0
}

func (m *HandleUplinkDataRequest) GetTxInfo() *gw.UplinkTXInfo {
	if m != nil {
		return m.TxInfo
	}
	return nil
}

func (m *HandleUplinkDataRequest) GetRxInfo() []*gw.UplinkRXInfo {
	if m != nil {
		return m.RxInfo
	}
	return nil
}

func (m *HandleUplinkDataRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *HandleUplinkDataRequest) GetDeviceActivationContext() *DeviceActivationContext {
	if m != nil {
		return m.DeviceActivationContext
	}
	return nil
}

type HandleProprietaryUplinkRequest struct {
	// MACPayload of the proprietary LoRaWAN frame.
	MacPayload []byte `protobuf:"bytes,1,opt,name=mac_payload,json=macPayload,proto3" json:"mac_payload,omitempty"`
	// MIC of the proprietary LoRaWAN frame.
	Mic []byte `protobuf:"bytes,2,opt,name=mic,proto3" json:"mic,omitempty"`
	// TXInfo contains the TX related meta-data.
	TxInfo *gw.UplinkTXInfo `protobuf:"bytes,3,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
	// RXInfo contains the RX related meta-data.
	RxInfo               []*gw.UplinkRXInfo `protobuf:"bytes,4,rep,name=rx_info,json=rxInfo,proto3" json:"rx_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *HandleProprietaryUplinkRequest) Reset()         { *m = HandleProprietaryUplinkRequest{} }
func (m *HandleProprietaryUplinkRequest) String() string { return proto.CompactTextString(m) }
func (*HandleProprietaryUplinkRequest) ProtoMessage()    {}
func (*HandleProprietaryUplinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{2}
}

func (m *HandleProprietaryUplinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandleProprietaryUplinkRequest.Unmarshal(m, b)
}
func (m *HandleProprietaryUplinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandleProprietaryUplinkRequest.Marshal(b, m, deterministic)
}
func (m *HandleProprietaryUplinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleProprietaryUplinkRequest.Merge(m, src)
}
func (m *HandleProprietaryUplinkRequest) XXX_Size() int {
	return xxx_messageInfo_HandleProprietaryUplinkRequest.Size(m)
}
func (m *HandleProprietaryUplinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleProprietaryUplinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleProprietaryUplinkRequest proto.InternalMessageInfo

func (m *HandleProprietaryUplinkRequest) GetMacPayload() []byte {
	if m != nil {
		return m.MacPayload
	}
	return nil
}

func (m *HandleProprietaryUplinkRequest) GetMic() []byte {
	if m != nil {
		return m.Mic
	}
	return nil
}

func (m *HandleProprietaryUplinkRequest) GetTxInfo() *gw.UplinkTXInfo {
	if m != nil {
		return m.TxInfo
	}
	return nil
}

func (m *HandleProprietaryUplinkRequest) GetRxInfo() []*gw.UplinkRXInfo {
	if m != nil {
		return m.RxInfo
	}
	return nil
}

type HandleErrorRequest struct {
	// Device EUI (8 bytes).
	DevEui []byte `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Type of the error.
	Type ErrorType `protobuf:"varint,3,opt,name=type,proto3,enum=as.ErrorType" json:"type,omitempty"`
	// Error string describing the error.
	Error string `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
	// Frame-counter (if applicable) related to the error.
	FCnt                 uint32   `protobuf:"varint,5,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HandleErrorRequest) Reset()         { *m = HandleErrorRequest{} }
func (m *HandleErrorRequest) String() string { return proto.CompactTextString(m) }
func (*HandleErrorRequest) ProtoMessage()    {}
func (*HandleErrorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{3}
}

func (m *HandleErrorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandleErrorRequest.Unmarshal(m, b)
}
func (m *HandleErrorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandleErrorRequest.Marshal(b, m, deterministic)
}
func (m *HandleErrorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleErrorRequest.Merge(m, src)
}
func (m *HandleErrorRequest) XXX_Size() int {
	return xxx_messageInfo_HandleErrorRequest.Size(m)
}
func (m *HandleErrorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleErrorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleErrorRequest proto.InternalMessageInfo

func (m *HandleErrorRequest) GetDevEui() []byte {
	if m != nil {
		return m.DevEui
	}
	return nil
}

func (m *HandleErrorRequest) GetType() ErrorType {
	if m != nil {
		return m.Type
	}
	return ErrorType_GENERIC
}

func (m *HandleErrorRequest) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *HandleErrorRequest) GetFCnt() uint32 {
	if m != nil {
		return m.FCnt
	}
	return 0
}

type HandleDownlinkACKRequest struct {
	// Device EUI (8 bytes).
	DevEui []byte `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Downlink frame-counter.
	FCnt uint32 `protobuf:"varint,2,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// Frame was acknowledged?
	Acknowledged         bool     `protobuf:"varint,3,opt,name=acknowledged,proto3" json:"acknowledged,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HandleDownlinkACKRequest) Reset()         { *m = HandleDownlinkACKRequest{} }
func (m *HandleDownlinkACKRequest) String() string { return proto.CompactTextString(m) }
func (*HandleDownlinkACKRequest) ProtoMessage()    {}
func (*HandleDownlinkACKRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{4}
}

func (m *HandleDownlinkACKRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandleDownlinkACKRequest.Unmarshal(m, b)
}
func (m *HandleDownlinkACKRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandleDownlinkACKRequest.Marshal(b, m, deterministic)
}
func (m *HandleDownlinkACKRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleDownlinkACKRequest.Merge(m, src)
}
func (m *HandleDownlinkACKRequest) XXX_Size() int {
	return xxx_messageInfo_HandleDownlinkACKRequest.Size(m)
}
func (m *HandleDownlinkACKRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleDownlinkACKRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleDownlinkACKRequest proto.InternalMessageInfo

func (m *HandleDownlinkACKRequest) GetDevEui() []byte {
	if m != nil {
		return m.DevEui
	}
	return nil
}

func (m *HandleDownlinkACKRequest) GetFCnt() uint32 {
	if m != nil {
		return m.FCnt
	}
	return 0
}

func (m *HandleDownlinkACKRequest) GetAcknowledged() bool {
	if m != nil {
		return m.Acknowledged
	}
	return false
}

type SetDeviceStatusRequest struct {
	// Device EUI (8 bytes).
	DevEui []byte `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Battery level (deprecated, use battery_level).
	// 0:      The end-device is connected to an external power source
	// 1..254: The battery level, 1 being at minimum and 254 being at maximum
	// 255:    The end-device was not able to measure the battery level
	Battery uint32 `protobuf:"varint,2,opt,name=battery,proto3" json:"battery,omitempty"`
	// The device margin status
	// -32..32: The demodulation SNR ration in dB
	Margin int32 `protobuf:"varint,3,opt,name=margin,proto3" json:"margin,omitempty"`
	// Device is connected to an external power source.
	ExternalPowerSource bool `protobuf:"varint,4,opt,name=external_power_source,json=externalPowerSource,proto3" json:"external_power_source,omitempty"`
	// Device battery status is not available.
	BatteryLevelUnavailable bool `protobuf:"varint,5,opt,name=battery_level_unavailable,json=batteryLevelUnavailable,proto3" json:"battery_level_unavailable,omitempty"`
	// Battery level as a percentage.
	BatteryLevel         float32  `protobuf:"fixed32,6,opt,name=battery_level,json=batteryLevel,proto3" json:"battery_level,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetDeviceStatusRequest) Reset()         { *m = SetDeviceStatusRequest{} }
func (m *SetDeviceStatusRequest) String() string { return proto.CompactTextString(m) }
func (*SetDeviceStatusRequest) ProtoMessage()    {}
func (*SetDeviceStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{5}
}

func (m *SetDeviceStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetDeviceStatusRequest.Unmarshal(m, b)
}
func (m *SetDeviceStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetDeviceStatusRequest.Marshal(b, m, deterministic)
}
func (m *SetDeviceStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetDeviceStatusRequest.Merge(m, src)
}
func (m *SetDeviceStatusRequest) XXX_Size() int {
	return xxx_messageInfo_SetDeviceStatusRequest.Size(m)
}
func (m *SetDeviceStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetDeviceStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetDeviceStatusRequest proto.InternalMessageInfo

func (m *SetDeviceStatusRequest) GetDevEui() []byte {
	if m != nil {
		return m.DevEui
	}
	return nil
}

func (m *SetDeviceStatusRequest) GetBattery() uint32 {
	if m != nil {
		return m.Battery
	}
	return 0
}

func (m *SetDeviceStatusRequest) GetMargin() int32 {
	if m != nil {
		return m.Margin
	}
	return 0
}

func (m *SetDeviceStatusRequest) GetExternalPowerSource() bool {
	if m != nil {
		return m.ExternalPowerSource
	}
	return false
}

func (m *SetDeviceStatusRequest) GetBatteryLevelUnavailable() bool {
	if m != nil {
		return m.BatteryLevelUnavailable
	}
	return false
}

func (m *SetDeviceStatusRequest) GetBatteryLevel() float32 {
	if m != nil {
		return m.BatteryLevel
	}
	return 0
}

type SetDeviceLocationRequest struct {
	// Device EUI (8 bytes).
	DevEui []byte `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// The location of the device.
	Location *common.Location `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Uplink IDs used for geolocation.
	UplinkIds            [][]byte `protobuf:"bytes,3,rep,name=uplink_ids,json=uplinkIds,proto3" json:"uplink_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetDeviceLocationRequest) Reset()         { *m = SetDeviceLocationRequest{} }
func (m *SetDeviceLocationRequest) String() string { return proto.CompactTextString(m) }
func (*SetDeviceLocationRequest) ProtoMessage()    {}
func (*SetDeviceLocationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{6}
}

func (m *SetDeviceLocationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetDeviceLocationRequest.Unmarshal(m, b)
}
func (m *SetDeviceLocationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetDeviceLocationRequest.Marshal(b, m, deterministic)
}
func (m *SetDeviceLocationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetDeviceLocationRequest.Merge(m, src)
}
func (m *SetDeviceLocationRequest) XXX_Size() int {
	return xxx_messageInfo_SetDeviceLocationRequest.Size(m)
}
func (m *SetDeviceLocationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetDeviceLocationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetDeviceLocationRequest proto.InternalMessageInfo

func (m *SetDeviceLocationRequest) GetDevEui() []byte {
	if m != nil {
		return m.DevEui
	}
	return nil
}

func (m *SetDeviceLocationRequest) GetLocation() *common.Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *SetDeviceLocationRequest) GetUplinkIds() [][]byte {
	if m != nil {
		return m.UplinkIds
	}
	return nil
}

type HandleGatewayStatsRequest struct {
	// Gateway ID (8 bytes).
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Stats ID (UUID).
	StatsId []byte `protobuf:"bytes,2,opt,name=stats_id,json=statsId,proto3" json:"stats_id,omitempty"`
	// Timestamp.
	Time *timestamp.Timestamp `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
	// Gateway location.
	Location *common.Location `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// Uplink frames received.
	RxPacketsReceived uint32 `protobuf:"varint,5,opt,name=rx_packets_received,json=rxPacketsReceived,proto3" json:"rx_packets_received,omitempty"`
	// Uplink frames received OK.
	RxPacketsReceivedOk uint32 `protobuf:"varint,6,opt,name=rx_packets_received_ok,json=rxPacketsReceivedOk,proto3" json:"rx_packets_received_ok,omitempty"`
	// Downlink transmissions requested.
	TxPacketsReceived uint32 `protobuf:"varint,7,opt,name=tx_packets_received,json=txPacketsReceived,proto3" json:"tx_packets_received,omitempty"`
	// Downlink emitted.
	TxPacketsEmitted uint32 `protobuf:"varint,8,opt,name=tx_packets_emitted,json=txPacketsEmitted,proto3" json:"tx_packets_emitted,omitempty"`
	// Gateway metadata.
	Metadata             map[string]string `protobuf:"bytes,9,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *HandleGatewayStatsRequest) Reset()         { *m = HandleGatewayStatsRequest{} }
func (m *HandleGatewayStatsRequest) String() string { return proto.CompactTextString(m) }
func (*HandleGatewayStatsRequest) ProtoMessage()    {}
func (*HandleGatewayStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{7}
}

func (m *HandleGatewayStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandleGatewayStatsRequest.Unmarshal(m, b)
}
func (m *HandleGatewayStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandleGatewayStatsRequest.Marshal(b, m, deterministic)
}
func (m *HandleGatewayStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleGatewayStatsRequest.Merge(m, src)
}
func (m *HandleGatewayStatsRequest) XXX_Size() int {
	return xxx_messageInfo_HandleGatewayStatsRequest.Size(m)
}
func (m *HandleGatewayStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleGatewayStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleGatewayStatsRequest proto.InternalMessageInfo

func (m *HandleGatewayStatsRequest) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *HandleGatewayStatsRequest) GetStatsId() []byte {
	if m != nil {
		return m.StatsId
	}
	return nil
}

func (m *HandleGatewayStatsRequest) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *HandleGatewayStatsRequest) GetLocation() *common.Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *HandleGatewayStatsRequest) GetRxPacketsReceived() uint32 {
	if m != nil {
		return m.RxPacketsReceived
	}
	return 0
}

func (m *HandleGatewayStatsRequest) GetRxPacketsReceivedOk() uint32 {
	if m != nil {
		return m.RxPacketsReceivedOk
	}
	return 0
}

func (m *HandleGatewayStatsRequest) GetTxPacketsReceived() uint32 {
	if m != nil {
		return m.TxPacketsReceived
	}
	return 0
}

func (m *HandleGatewayStatsRequest) GetTxPacketsEmitted() uint32 {
	if m != nil {
		return m.TxPacketsEmitted
	}
	return 0
}

func (m *HandleGatewayStatsRequest) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type HandleTxAckRequest struct {
	// Device EUI (8 bytes).
	DevEui []byte `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Downlink frame-counter.
	FCnt                 uint32   `protobuf:"varint,2,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HandleTxAckRequest) Reset()         { *m = HandleTxAckRequest{} }
func (m *HandleTxAckRequest) String() string { return proto.CompactTextString(m) }
func (*HandleTxAckRequest) ProtoMessage()    {}
func (*HandleTxAckRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1d6d0f577a60e27d, []int{8}
}

func (m *HandleTxAckRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HandleTxAckRequest.Unmarshal(m, b)
}
func (m *HandleTxAckRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HandleTxAckRequest.Marshal(b, m, deterministic)
}
func (m *HandleTxAckRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleTxAckRequest.Merge(m, src)
}
func (m *HandleTxAckRequest) XXX_Size() int {
	return xxx_messageInfo_HandleTxAckRequest.Size(m)
}
func (m *HandleTxAckRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleTxAckRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleTxAckRequest proto.InternalMessageInfo

func (m *HandleTxAckRequest) GetDevEui() []byte {
	if m != nil {
		return m.DevEui
	}
	return nil
}

func (m *HandleTxAckRequest) GetFCnt() uint32 {
	if m != nil {
		return m.FCnt
	}
	return 0
}

func init() {
	proto.RegisterEnum("as.RXWindow", RXWindow_name, RXWindow_value)
	proto.RegisterEnum("as.ErrorType", ErrorType_name, ErrorType_value)
	proto.RegisterType((*DeviceActivationContext)(nil), "as.DeviceActivationContext")
	proto.RegisterType((*HandleUplinkDataRequest)(nil), "as.HandleUplinkDataRequest")
	proto.RegisterType((*HandleProprietaryUplinkRequest)(nil), "as.HandleProprietaryUplinkRequest")
	proto.RegisterType((*HandleErrorRequest)(nil), "as.HandleErrorRequest")
	proto.RegisterType((*HandleDownlinkACKRequest)(nil), "as.HandleDownlinkACKRequest")
	proto.RegisterType((*SetDeviceStatusRequest)(nil), "as.SetDeviceStatusRequest")
	proto.RegisterType((*SetDeviceLocationRequest)(nil), "as.SetDeviceLocationRequest")
	proto.RegisterType((*HandleGatewayStatsRequest)(nil), "as.HandleGatewayStatsRequest")
	proto.RegisterMapType((map[string]string)(nil), "as.HandleGatewayStatsRequest.MetadataEntry")
	proto.RegisterType((*HandleTxAckRequest)(nil), "as.HandleTxAckRequest")
}

func init() { proto.RegisterFile("as/as.proto", fileDescriptor_1d6d0f577a60e27d) }

var fileDescriptor_1d6d0f577a60e27d = []byte{
	// 1224 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x4b, 0x73, 0x1b, 0x45,
	0x10, 0xce, 0xea, 0xad, 0x96, 0x9d, 0x6c, 0xc6, 0x44, 0x5e, 0xcb, 0x09, 0x31, 0xe2, 0x62, 0x42,
	0x90, 0x0a, 0xe7, 0x42, 0x85, 0x03, 0xa5, 0xc8, 0x8b, 0x51, 0x39, 0x7e, 0xb0, 0x92, 0x71, 0xc8,
	0x65, 0x6a, 0xbc, 0x3b, 0x52, 0x16, 0xad, 0x76, 0x96, 0xd9, 0xd1, 0xab, 0xb8, 0xf0, 0x77, 0xf8,
	0x0d, 0xfc, 0x17, 0x7e, 0x04, 0x27, 0x0e, 0x1c, 0xa8, 0x99, 0x1d, 0x3d, 0x6c, 0xd9, 0x72, 0x8a,
	0x8b, 0xb5, 0xd3, 0xfd, 0x4d, 0x77, 0x4f, 0x3f, 0xbe, 0x36, 0x94, 0x48, 0x5c, 0x27, 0x71, 0x2d,
	0xe2, 0x4c, 0x30, 0x94, 0x22, 0x71, 0x65, 0xb7, 0xc7, 0x58, 0x2f, 0xa0, 0x75, 0x25, 0xb9, 0x1a,
	0x76, 0xeb, 0x74, 0x10, 0x89, 0x69, 0x02, 0xa8, 0x3c, 0xbf, 0xa9, 0x14, 0xfe, 0x80, 0xc6, 0x82,
	0x0c, 0x22, 0x0d, 0xd8, 0x72, 0xd9, 0x60, 0xc0, 0xc2, 0x7a, 0xf2, 0xa3, 0x85, 0xa5, 0xde, 0xb8,
	0xde, 0x1b, 0x27, 0x87, 0x2a, 0x85, 0xed, 0x43, 0x3a, 0xf2, 0x5d, 0xda, 0x70, 0x85, 0x3f, 0x22,
	0xc2, 0x67, 0x61, 0x93, 0x85, 0x82, 0x4e, 0x04, 0xda, 0x81, 0x82, 0x47, 0x47, 0x98, 0x78, 0x1e,
	0xb7, 0x8c, 0x3d, 0x63, 0x7f, 0xc3, 0xc9, 0x7b, 0x74, 0xd4, 0xf0, 0x3c, 0x8e, 0xea, 0x50, 0x24,
	0x51, 0x84, 0x63, 0xdc, 0xa7, 0x53, 0x2b, 0xb5, 0x67, 0xec, 0x97, 0x0e, 0xb6, 0x6a, 0xda, 0xc9,
	0x31, 0x9d, 0xda, 0xe1, 0x88, 0x06, 0x2c, 0xa2, 0x4e, 0x9e, 0x44, 0x51, 0xfb, 0x98, 0x4e, 0xab,
	0x7f, 0xa5, 0x60, 0xfb, 0x07, 0x12, 0x7a, 0x01, 0xbd, 0x88, 0x02, 0x3f, 0xec, 0x1f, 0x12, 0x41,
	0x1c, 0xfa, 0xeb, 0x90, 0xc6, 0x02, 0x6d, 0x83, 0xb4, 0x8b, 0xe9, 0xd0, 0xd7, 0x6e, 0x72, 0x1e,
	0x1d, 0xd9, 0x43, 0x5f, 0x06, 0xf0, 0x0b, 0xf3, 0x43, 0xa5, 0x49, 0x25, 0x01, 0xc8, 0xb3, 0x54,
	0x6d, 0x41, 0xb6, 0x8b, 0xdd, 0x50, 0x58, 0xe9, 0x3d, 0x63, 0x7f, 0xd3, 0xc9, 0x74, 0x9b, 0xa1,
	0x40, 0x4f, 0x20, 0xd7, 0xc5, 0x11, 0xe3, 0xc2, 0xca, 0x28, 0x69, 0xb6, 0x7b, 0xce, 0xb8, 0x40,
	0x26, 0xa4, 0x89, 0xc7, 0xad, 0xec, 0x9e, 0xb1, 0x5f, 0x70, 0xe4, 0x27, 0x7a, 0x08, 0x29, 0x8f,
	0x5b, 0x39, 0x05, 0x4a, 0x79, 0x1c, 0x7d, 0x01, 0x79, 0x31, 0xc1, 0x7e, 0xd8, 0x65, 0x56, 0x5e,
	0x3d, 0xc6, 0xac, 0xf5, 0xc6, 0xb5, 0x24, 0xd2, 0xce, 0xbb, 0x56, 0xd8, 0x65, 0x4e, 0x4e, 0x4c,
	0xe4, 0xaf, 0x84, 0x72, 0x0d, 0x2d, 0xec, 0xa5, 0xaf, 0x43, 0x1d, 0x0d, 0xe5, 0x09, 0x14, 0x41,
	0xc6, 0x23, 0x82, 0x58, 0x45, 0x15, 0xba, 0xfa, 0x46, 0x97, 0xb0, 0xe3, 0xa9, 0x74, 0x63, 0x32,
	0xcf, 0x37, 0x76, 0x93, 0x84, 0x5b, 0xa0, 0x7c, 0xef, 0xd6, 0x48, 0x5c, 0xbb, 0xa3, 0x26, 0xce,
	0xb6, 0x77, 0xbb, 0xa2, 0xfa, 0x87, 0x01, 0x9f, 0x26, 0x09, 0x3e, 0xe7, 0x2c, 0xe2, 0x3e, 0x15,
	0x84, 0x4f, 0x75, 0x58, 0x3a, 0xcf, 0xcf, 0xa1, 0x34, 0x20, 0x2e, 0x8e, 0xc8, 0x34, 0x60, 0xc4,
	0xd3, 0xb9, 0x86, 0x01, 0x71, 0xcf, 0x13, 0x89, 0x4c, 0xd4, 0xc0, 0x77, 0x75, 0xaa, 0xe5, 0xe7,
	0x72, 0x62, 0xd2, 0x1f, 0x9f, 0x98, 0xcc, 0xfa, 0xc4, 0x54, 0x7f, 0x03, 0x94, 0x84, 0x6a, 0x73,
	0xce, 0xf8, 0xbd, 0x6d, 0xf0, 0x19, 0x64, 0xc4, 0x34, 0xa2, 0x2a, 0x82, 0x87, 0x07, 0x9b, 0x32,
	0x3d, 0xea, 0x62, 0x67, 0x1a, 0x51, 0x47, 0xa9, 0xd0, 0x27, 0x90, 0xa5, 0x52, 0xa4, 0x0a, 0x5f,
	0x74, 0x92, 0xc3, 0xa2, 0x49, 0xb2, 0x8b, 0x26, 0xa9, 0x06, 0x60, 0x25, 0xce, 0x0f, 0xd9, 0x38,
	0x94, 0xc1, 0x35, 0x9a, 0xc7, 0xf7, 0x86, 0x30, 0xb7, 0x94, 0x5a, 0x6a, 0xb7, 0x2a, 0x6c, 0x10,
	0xb7, 0x1f, 0xb2, 0x71, 0x40, 0xbd, 0x1e, 0xf5, 0x54, 0x7c, 0x05, 0xe7, 0x9a, 0xac, 0xfa, 0x8f,
	0x01, 0xe5, 0x36, 0x15, 0x49, 0x39, 0xdb, 0x82, 0x88, 0x61, 0x7c, 0xaf, 0x33, 0x0b, 0xf2, 0x57,
	0x44, 0x08, 0xca, 0xa7, 0xda, 0xdd, 0xec, 0x88, 0xca, 0x90, 0x1b, 0x10, 0xde, 0xf3, 0x43, 0xe5,
	0x2b, 0xeb, 0xe8, 0x13, 0x3a, 0x80, 0x27, 0x74, 0x22, 0x28, 0x0f, 0x49, 0x80, 0x23, 0x36, 0xa6,
	0x1c, 0xc7, 0x6c, 0xc8, 0x5d, 0xaa, 0xd2, 0x51, 0x70, 0xb6, 0x66, 0xca, 0x73, 0xa9, 0x6b, 0x2b,
	0x15, 0x7a, 0x0d, 0x3b, 0xda, 0x2c, 0x0e, 0xe8, 0x88, 0x06, 0x78, 0x18, 0x92, 0x11, 0xf1, 0x03,
	0x72, 0x15, 0x50, 0x3d, 0x2b, 0xdb, 0x1a, 0xf0, 0x56, 0xea, 0x2f, 0x16, 0x6a, 0xf4, 0x39, 0x6c,
	0x5e, 0xbb, 0xab, 0x46, 0x29, 0xe5, 0x6c, 0x2c, 0xe3, 0xab, 0xbf, 0x1b, 0x60, 0xcd, 0x9f, 0xfe,
	0x96, 0xb9, 0xaa, 0x5d, 0xef, 0x7d, 0xfc, 0x4b, 0x28, 0x04, 0x1a, 0xab, 0x89, 0xc5, 0x9c, 0x11,
	0xcb, 0xdc, 0xc6, 0x1c, 0x81, 0x9e, 0x01, 0x0c, 0x55, 0x87, 0x61, 0xdf, 0x8b, 0xad, 0xf4, 0x5e,
	0x7a, 0x7f, 0xc3, 0x29, 0x26, 0x92, 0x96, 0x17, 0x57, 0xff, 0x4d, 0xc3, 0x4e, 0x52, 0xec, 0x23,
	0x22, 0xe8, 0x98, 0x4c, 0x65, 0x05, 0xe6, 0x05, 0x78, 0x06, 0xd0, 0x4b, 0xc4, 0xd8, 0x9f, 0x8d,
	0x43, 0x51, 0x4b, 0x5a, 0x9e, 0x64, 0x9f, 0x58, 0xc2, 0xa5, 0x52, 0xb3, 0x8f, 0x3a, 0xb7, 0x3c,
	0x54, 0x83, 0x8c, 0x64, 0x5a, 0x3d, 0x13, 0x95, 0x5a, 0x42, 0xc3, 0xb5, 0x19, 0x0d, 0xd7, 0x3a,
	0x33, 0x1a, 0x76, 0x14, 0xee, 0xda, 0xa3, 0x32, 0xf7, 0x3e, 0xaa, 0x06, 0x5b, 0x7c, 0x82, 0x23,
	0xe2, 0xf6, 0xa9, 0x88, 0x31, 0xa7, 0x2e, 0xf5, 0x47, 0xd4, 0xd3, 0x4d, 0xfc, 0x98, 0x4f, 0xce,
	0x13, 0x8d, 0xa3, 0x15, 0xe8, 0x15, 0x94, 0x6f, 0xc1, 0x63, 0xd6, 0xd7, 0x0c, 0xb7, 0xb5, 0x72,
	0xe5, 0xac, 0x2f, 0x9d, 0x88, 0x5b, 0x9c, 0xe4, 0x13, 0x27, 0x62, 0xc5, 0xc9, 0x4b, 0x40, 0x4b,
	0x78, 0x3a, 0xf0, 0x85, 0xa0, 0x9e, 0x55, 0x50, 0x70, 0x73, 0x0e, 0xb7, 0x13, 0x39, 0x3a, 0x82,
	0xc2, 0x80, 0x0a, 0xa2, 0xe9, 0x4f, 0xb2, 0xc1, 0x97, 0x72, 0x6c, 0xef, 0xac, 0x45, 0xed, 0x44,
	0xa3, 0xed, 0x50, 0xf0, 0xa9, 0x33, 0xbf, 0x5c, 0xf9, 0x16, 0x36, 0xaf, 0xa9, 0x24, 0x47, 0xc9,
	0x9d, 0x63, 0xa8, 0x39, 0x97, 0x9f, 0x72, 0xf6, 0x47, 0x24, 0x18, 0x52, 0x55, 0xa4, 0xa2, 0x93,
	0x1c, 0x5e, 0xa7, 0xbe, 0x31, 0xaa, 0x6f, 0x66, 0x3c, 0xd3, 0x99, 0x34, 0xdc, 0xfe, 0xff, 0x1a,
	0xf2, 0x17, 0x4f, 0xa1, 0xe0, 0xbc, 0xbb, 0xf4, 0x43, 0x8f, 0x8d, 0x51, 0x1e, 0xd2, 0xce, 0xbb,
	0xaf, 0xcd, 0x07, 0xc9, 0xc7, 0x81, 0x69, 0xbc, 0xf8, 0xd3, 0x80, 0xe2, 0x9c, 0x8b, 0x50, 0x09,
	0xf2, 0x47, 0xf6, 0xa9, 0xed, 0xb4, 0x9a, 0xe6, 0x03, 0x54, 0x80, 0xcc, 0x59, 0xa7, 0xd1, 0x30,
	0x0d, 0x54, 0x06, 0x74, 0xd8, 0xe8, 0x34, 0xf0, 0xc5, 0x39, 0xfe, 0xbe, 0x79, 0xda, 0xc1, 0x8e,
	0xdd, 0xb6, 0x3b, 0x66, 0x0a, 0x3d, 0x82, 0xd2, 0x4c, 0x7e, 0xd2, 0x6a, 0x9a, 0x69, 0x54, 0x81,
	0xf2, 0xa1, 0xfd, 0x53, 0xab, 0x69, 0xe3, 0x1f, 0x2f, 0xec, 0x0b, 0x1b, 0xb7, 0x3a, 0xf6, 0x09,
	0x6e, 0xb7, 0xde, 0xdb, 0x66, 0xe6, 0x76, 0x9d, 0x34, 0x67, 0x66, 0xd1, 0x73, 0xd8, 0xbd, 0xe1,
	0xa0, 0xe3, 0x34, 0x4e, 0xdb, 0x27, 0xad, 0x76, 0xbb, 0x75, 0x76, 0x6a, 0xe6, 0xd0, 0x13, 0x78,
	0xac, 0x00, 0x87, 0x67, 0x97, 0xa7, 0xf8, 0xa8, 0xd1, 0xb1, 0x2f, 0x1b, 0x3f, 0x9b, 0xf9, 0x83,
	0xbf, 0x33, 0x60, 0x35, 0xa2, 0x28, 0xf0, 0x93, 0xc6, 0x6b, 0x53, 0x3e, 0xa2, 0x5c, 0xfe, 0xf5,
	0x5d, 0x8a, 0x5a, 0x60, 0xde, 0x5c, 0xd8, 0x68, 0x77, 0x51, 0xc4, 0x95, 0x35, 0x5e, 0x29, 0xaf,
	0x8c, 0x81, 0x2d, 0xff, 0x55, 0xa9, 0x3e, 0x40, 0x97, 0xb3, 0xdd, 0xbf, 0xb2, 0x9a, 0x50, 0x75,
	0x61, 0xf1, 0xae, 0xbd, 0xb5, 0xc6, 0xf0, 0x77, 0x50, 0x5a, 0x5a, 0x24, 0xa8, 0xbc, 0x30, 0xb6,
	0xbc, 0x59, 0xd6, 0x18, 0x38, 0x86, 0xc7, 0x2b, 0xcb, 0x00, 0x3d, 0x5d, 0x98, 0x59, 0xdd, 0x11,
	0x6b, 0x8c, 0x9d, 0xcc, 0xda, 0x6d, 0xb9, 0xc1, 0xd1, 0xb3, 0xb5, 0x8d, 0xff, 0x31, 0x8f, 0x53,
	0xdd, 0xbb, 0xfc, 0xb8, 0xe5, 0x76, 0x5e, 0x63, 0xe0, 0x08, 0x1e, 0xdd, 0x58, 0x3d, 0xa8, 0x22,
	0x8d, 0xdc, 0xbe, 0x8f, 0xd6, 0x67, 0x69, 0x85, 0xc8, 0x93, 0x2c, 0xdd, 0xc5, 0xef, 0x77, 0x1b,
	0x7b, 0xf3, 0xf2, 0xfd, 0x8b, 0x9e, 0x2f, 0x3e, 0x0c, 0xaf, 0x24, 0x03, 0xd6, 0xaf, 0x38, 0x73,
	0x09, 0xe1, 0x75, 0xf7, 0x83, 0xcf, 0xa3, 0x58, 0x10, 0xb7, 0xff, 0x15, 0x89, 0xfc, 0x7a, 0x8f,
	0xd5, 0x47, 0xaf, 0xea, 0x24, 0xbe, 0xca, 0xa9, 0xfb, 0xaf, 0xfe, 0x0b, 0x00, 0x00, 0xff, 0xff,
	0x45, 0x63, 0x64, 0xe3, 0x18, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ApplicationServerServiceClient is the client API for ApplicationServerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApplicationServerServiceClient interface {
	// HandleUplinkData handles uplink data received from an end-device.
	HandleUplinkData(ctx context.Context, in *HandleUplinkDataRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// HandleProprietaryUplink handles proprietary uplink payloads.
	HandleProprietaryUplink(ctx context.Context, in *HandleProprietaryUplinkRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// HandleError handles an error message.
	HandleError(ctx context.Context, in *HandleErrorRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// HandleDownlinkACK handles a downlink ACK or nACK response.
	HandleDownlinkACK(ctx context.Context, in *HandleDownlinkACKRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// HandleGatewayStats handles the given gateway stats.
	HandleGatewayStats(ctx context.Context, in *HandleGatewayStatsRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// HandleTXACK handles the TX acknowledgement.
	HandleTxAck(ctx context.Context, in *HandleTxAckRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// SetDeviceStatus updates the device-status for a device.
	SetDeviceStatus(ctx context.Context, in *SetDeviceStatusRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// SetDeviceLocation updates the device-location for a device.
	SetDeviceLocation(ctx context.Context, in *SetDeviceLocationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type applicationServerServiceClient struct {
	cc *grpc.ClientConn
}

func NewApplicationServerServiceClient(cc *grpc.ClientConn) ApplicationServerServiceClient {
	return &applicationServerServiceClient{cc}
}

func (c *applicationServerServiceClient) HandleUplinkData(ctx context.Context, in *HandleUplinkDataRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/as.ApplicationServerService/HandleUplinkData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServerServiceClient) HandleProprietaryUplink(ctx context.Context, in *HandleProprietaryUplinkRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/as.ApplicationServerService/HandleProprietaryUplink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServerServiceClient) HandleError(ctx context.Context, in *HandleErrorRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/as.ApplicationServerService/HandleError", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServerServiceClient) HandleDownlinkACK(ctx context.Context, in *HandleDownlinkACKRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/as.ApplicationServerService/HandleDownlinkACK", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServerServiceClient) HandleGatewayStats(ctx context.Context, in *HandleGatewayStatsRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/as.ApplicationServerService/HandleGatewayStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServerServiceClient) HandleTxAck(ctx context.Context, in *HandleTxAckRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/as.ApplicationServerService/HandleTxAck", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServerServiceClient) SetDeviceStatus(ctx context.Context, in *SetDeviceStatusRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/as.ApplicationServerService/SetDeviceStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServerServiceClient) SetDeviceLocation(ctx context.Context, in *SetDeviceLocationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/as.ApplicationServerService/SetDeviceLocation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationServerServiceServer is the server API for ApplicationServerService service.
type ApplicationServerServiceServer interface {
	// HandleUplinkData handles uplink data received from an end-device.
	HandleUplinkData(context.Context, *HandleUplinkDataRequest) (*empty.Empty, error)
	// HandleProprietaryUplink handles proprietary uplink payloads.
	HandleProprietaryUplink(context.Context, *HandleProprietaryUplinkRequest) (*empty.Empty, error)
	// HandleError handles an error message.
	HandleError(context.Context, *HandleErrorRequest) (*empty.Empty, error)
	// HandleDownlinkACK handles a downlink ACK or nACK response.
	HandleDownlinkACK(context.Context, *HandleDownlinkACKRequest) (*empty.Empty, error)
	// HandleGatewayStats handles the given gateway stats.
	HandleGatewayStats(context.Context, *HandleGatewayStatsRequest) (*empty.Empty, error)
	// HandleTXACK handles the TX acknowledgement.
	HandleTxAck(context.Context, *HandleTxAckRequest) (*empty.Empty, error)
	// SetDeviceStatus updates the device-status for a device.
	SetDeviceStatus(context.Context, *SetDeviceStatusRequest) (*empty.Empty, error)
	// SetDeviceLocation updates the device-location for a device.
	SetDeviceLocation(context.Context, *SetDeviceLocationRequest) (*empty.Empty, error)
}

// UnimplementedApplicationServerServiceServer can be embedded to have forward compatible implementations.
type UnimplementedApplicationServerServiceServer struct {
}

func (*UnimplementedApplicationServerServiceServer) HandleUplinkData(ctx context.Context, req *HandleUplinkDataRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleUplinkData not implemented")
}
func (*UnimplementedApplicationServerServiceServer) HandleProprietaryUplink(ctx context.Context, req *HandleProprietaryUplinkRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleProprietaryUplink not implemented")
}
func (*UnimplementedApplicationServerServiceServer) HandleError(ctx context.Context, req *HandleErrorRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleError not implemented")
}
func (*UnimplementedApplicationServerServiceServer) HandleDownlinkACK(ctx context.Context, req *HandleDownlinkACKRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleDownlinkACK not implemented")
}
func (*UnimplementedApplicationServerServiceServer) HandleGatewayStats(ctx context.Context, req *HandleGatewayStatsRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleGatewayStats not implemented")
}
func (*UnimplementedApplicationServerServiceServer) HandleTxAck(ctx context.Context, req *HandleTxAckRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleTxAck not implemented")
}
func (*UnimplementedApplicationServerServiceServer) SetDeviceStatus(ctx context.Context, req *SetDeviceStatusRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDeviceStatus not implemented")
}
func (*UnimplementedApplicationServerServiceServer) SetDeviceLocation(ctx context.Context, req *SetDeviceLocationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDeviceLocation not implemented")
}

func RegisterApplicationServerServiceServer(s *grpc.Server, srv ApplicationServerServiceServer) {
	s.RegisterService(&_ApplicationServerService_serviceDesc, srv)
}

func _ApplicationServerService_HandleUplinkData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleUplinkDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServerServiceServer).HandleUplinkData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/as.ApplicationServerService/HandleUplinkData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServerServiceServer).HandleUplinkData(ctx, req.(*HandleUplinkDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationServerService_HandleProprietaryUplink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleProprietaryUplinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServerServiceServer).HandleProprietaryUplink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/as.ApplicationServerService/HandleProprietaryUplink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServerServiceServer).HandleProprietaryUplink(ctx, req.(*HandleProprietaryUplinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationServerService_HandleError_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleErrorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServerServiceServer).HandleError(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/as.ApplicationServerService/HandleError",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServerServiceServer).HandleError(ctx, req.(*HandleErrorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationServerService_HandleDownlinkACK_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleDownlinkACKRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServerServiceServer).HandleDownlinkACK(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/as.ApplicationServerService/HandleDownlinkACK",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServerServiceServer).HandleDownlinkACK(ctx, req.(*HandleDownlinkACKRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationServerService_HandleGatewayStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleGatewayStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServerServiceServer).HandleGatewayStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/as.ApplicationServerService/HandleGatewayStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServerServiceServer).HandleGatewayStats(ctx, req.(*HandleGatewayStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationServerService_HandleTxAck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleTxAckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServerServiceServer).HandleTxAck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/as.ApplicationServerService/HandleTxAck",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServerServiceServer).HandleTxAck(ctx, req.(*HandleTxAckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationServerService_SetDeviceStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDeviceStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServerServiceServer).SetDeviceStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/as.ApplicationServerService/SetDeviceStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServerServiceServer).SetDeviceStatus(ctx, req.(*SetDeviceStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationServerService_SetDeviceLocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDeviceLocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServerServiceServer).SetDeviceLocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/as.ApplicationServerService/SetDeviceLocation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServerServiceServer).SetDeviceLocation(ctx, req.(*SetDeviceLocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApplicationServerService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "as.ApplicationServerService",
	HandlerType: (*ApplicationServerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleUplinkData",
			Handler:    _ApplicationServerService_HandleUplinkData_Handler,
		},
		{
			MethodName: "HandleProprietaryUplink",
			Handler:    _ApplicationServerService_HandleProprietaryUplink_Handler,
		},
		{
			MethodName: "HandleError",
			Handler:    _ApplicationServerService_HandleError_Handler,
		},
		{
			MethodName: "HandleDownlinkACK",
			Handler:    _ApplicationServerService_HandleDownlinkACK_Handler,
		},
		{
			MethodName: "HandleGatewayStats",
			Handler:    _ApplicationServerService_HandleGatewayStats_Handler,
		},
		{
			MethodName: "HandleTxAck",
			Handler:    _ApplicationServerService_HandleTxAck_Handler,
		},
		{
			MethodName: "SetDeviceStatus",
			Handler:    _ApplicationServerService_SetDeviceStatus_Handler,
		},
		{
			MethodName: "SetDeviceLocation",
			Handler:    _ApplicationServerService_SetDeviceLocation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "as/as.proto",
}
