// Code generated by protoc-gen-go. DO NOT EDIT.
// source: as/external/api/application.proto

package api

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type IntegrationKind int32

const (
	IntegrationKind_HTTP        IntegrationKind = 0
	IntegrationKind_INFLUXDB    IntegrationKind = 1
	IntegrationKind_THINGSBOARD IntegrationKind = 2
	IntegrationKind_MYDEVICES   IntegrationKind = 3
)

var IntegrationKind_name = map[int32]string{
	0: "HTTP",
	1: "INFLUXDB",
	2: "THINGSBOARD",
	3: "MYDEVICES",
}

var IntegrationKind_value = map[string]int32{
	"HTTP":        0,
	"INFLUXDB":    1,
	"THINGSBOARD": 2,
	"MYDEVICES":   3,
}

func (x IntegrationKind) String() string {
	return proto.EnumName(IntegrationKind_name, int32(x))
}

func (IntegrationKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{0}
}

type InfluxDBPrecision int32

const (
	InfluxDBPrecision_NS InfluxDBPrecision = 0
	InfluxDBPrecision_U  InfluxDBPrecision = 1
	InfluxDBPrecision_MS InfluxDBPrecision = 2
	InfluxDBPrecision_S  InfluxDBPrecision = 3
	InfluxDBPrecision_M  InfluxDBPrecision = 4
	InfluxDBPrecision_H  InfluxDBPrecision = 5
)

var InfluxDBPrecision_name = map[int32]string{
	0: "NS",
	1: "U",
	2: "MS",
	3: "S",
	4: "M",
	5: "H",
}

var InfluxDBPrecision_value = map[string]int32{
	"NS": 0,
	"U":  1,
	"MS": 2,
	"S":  3,
	"M":  4,
	"H":  5,
}

func (x InfluxDBPrecision) String() string {
	return proto.EnumName(InfluxDBPrecision_name, int32(x))
}

func (InfluxDBPrecision) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{1}
}

type Application struct {
	// Application ID.
	// This will be automatically assigned on create.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the application (must be unique).
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the application.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the organization to which the application belongs.
	// After create, this can not be modified.
	OrganizationId int64 `protobuf:"varint,4,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// ID of the service profile.
	ServiceProfileId string `protobuf:"bytes,5,opt,name=service_profile_id,json=serviceProfileID,proto3" json:"service_profile_id,omitempty"`
	// Payload codec.
	// NOTE: These field have moved to the device-profile and will be removed
	// in the next major release. When set, the device-profile payload_ fields
	// have priority over the application payload_ fields.
	PayloadCodec string `protobuf:"bytes,6,opt,name=payload_codec,json=payloadCodec,proto3" json:"payload_codec,omitempty"`
	// Payload encoder script.
	// NOTE: These field have moved to the device-profile and will be removed
	// in the next major release. When set, the device-profile payload_ fields
	// have priority over the application payload_ fields.
	PayloadEncoderScript string `protobuf:"bytes,7,opt,name=payload_encoder_script,json=payloadEncoderScript,proto3" json:"payload_encoder_script,omitempty"`
	// Payload decoder script.
	// NOTE: These field have moved to the device-profile and will be removed
	// in the next major release. When set, the device-profile payload_ fields
	// have priority over the application payload_ fields.
	PayloadDecoderScript string   `protobuf:"bytes,8,opt,name=payload_decoder_script,json=payloadDecoderScript,proto3" json:"payload_decoder_script,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Application) Reset()         { *m = Application{} }
func (m *Application) String() string { return proto.CompactTextString(m) }
func (*Application) ProtoMessage()    {}
func (*Application) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{0}
}

func (m *Application) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Application.Unmarshal(m, b)
}
func (m *Application) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Application.Marshal(b, m, deterministic)
}
func (m *Application) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Application.Merge(m, src)
}
func (m *Application) XXX_Size() int {
	return xxx_messageInfo_Application.Size(m)
}
func (m *Application) XXX_DiscardUnknown() {
	xxx_messageInfo_Application.DiscardUnknown(m)
}

var xxx_messageInfo_Application proto.InternalMessageInfo

func (m *Application) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Application) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Application) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Application) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *Application) GetServiceProfileId() string {
	if m != nil {
		return m.ServiceProfileId
	}
	return ""
}

func (m *Application) GetPayloadCodec() string {
	if m != nil {
		return m.PayloadCodec
	}
	return ""
}

func (m *Application) GetPayloadEncoderScript() string {
	if m != nil {
		return m.PayloadEncoderScript
	}
	return ""
}

func (m *Application) GetPayloadDecoderScript() string {
	if m != nil {
		return m.PayloadDecoderScript
	}
	return ""
}

type ApplicationListItem struct {
	// Application ID.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the application.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the application.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the organization to which the application belongs.
	OrganizationId int64 `protobuf:"varint,4,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// ID of the service profile.
	ServiceProfileId string `protobuf:"bytes,5,opt,name=service_profile_id,json=serviceProfileID,proto3" json:"service_profile_id,omitempty"`
	// Service-profile name.
	ServiceProfileName   string   `protobuf:"bytes,6,opt,name=service_profile_name,json=serviceProfileName,proto3" json:"service_profile_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationListItem) Reset()         { *m = ApplicationListItem{} }
func (m *ApplicationListItem) String() string { return proto.CompactTextString(m) }
func (*ApplicationListItem) ProtoMessage()    {}
func (*ApplicationListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{1}
}

func (m *ApplicationListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationListItem.Unmarshal(m, b)
}
func (m *ApplicationListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationListItem.Marshal(b, m, deterministic)
}
func (m *ApplicationListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationListItem.Merge(m, src)
}
func (m *ApplicationListItem) XXX_Size() int {
	return xxx_messageInfo_ApplicationListItem.Size(m)
}
func (m *ApplicationListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationListItem.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationListItem proto.InternalMessageInfo

func (m *ApplicationListItem) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ApplicationListItem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ApplicationListItem) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ApplicationListItem) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *ApplicationListItem) GetServiceProfileId() string {
	if m != nil {
		return m.ServiceProfileId
	}
	return ""
}

func (m *ApplicationListItem) GetServiceProfileName() string {
	if m != nil {
		return m.ServiceProfileName
	}
	return ""
}

type CreateApplicationRequest struct {
	// Application object to create.
	Application          *Application `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateApplicationRequest) Reset()         { *m = CreateApplicationRequest{} }
func (m *CreateApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateApplicationRequest) ProtoMessage()    {}
func (*CreateApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{2}
}

func (m *CreateApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateApplicationRequest.Unmarshal(m, b)
}
func (m *CreateApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateApplicationRequest.Marshal(b, m, deterministic)
}
func (m *CreateApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateApplicationRequest.Merge(m, src)
}
func (m *CreateApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateApplicationRequest.Size(m)
}
func (m *CreateApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateApplicationRequest proto.InternalMessageInfo

func (m *CreateApplicationRequest) GetApplication() *Application {
	if m != nil {
		return m.Application
	}
	return nil
}

type CreateApplicationResponse struct {
	// Application ID.
	Id                   int64    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateApplicationResponse) Reset()         { *m = CreateApplicationResponse{} }
func (m *CreateApplicationResponse) String() string { return proto.CompactTextString(m) }
func (*CreateApplicationResponse) ProtoMessage()    {}
func (*CreateApplicationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{3}
}

func (m *CreateApplicationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateApplicationResponse.Unmarshal(m, b)
}
func (m *CreateApplicationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateApplicationResponse.Marshal(b, m, deterministic)
}
func (m *CreateApplicationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateApplicationResponse.Merge(m, src)
}
func (m *CreateApplicationResponse) XXX_Size() int {
	return xxx_messageInfo_CreateApplicationResponse.Size(m)
}
func (m *CreateApplicationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateApplicationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateApplicationResponse proto.InternalMessageInfo

func (m *CreateApplicationResponse) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type GetApplicationRequest struct {
	// Application ID.
	Id                   int64    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetApplicationRequest) Reset()         { *m = GetApplicationRequest{} }
func (m *GetApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*GetApplicationRequest) ProtoMessage()    {}
func (*GetApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{4}
}

func (m *GetApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetApplicationRequest.Unmarshal(m, b)
}
func (m *GetApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetApplicationRequest.Marshal(b, m, deterministic)
}
func (m *GetApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetApplicationRequest.Merge(m, src)
}
func (m *GetApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_GetApplicationRequest.Size(m)
}
func (m *GetApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetApplicationRequest proto.InternalMessageInfo

func (m *GetApplicationRequest) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type GetApplicationResponse struct {
	// Application object.
	Application          *Application `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *GetApplicationResponse) Reset()         { *m = GetApplicationResponse{} }
func (m *GetApplicationResponse) String() string { return proto.CompactTextString(m) }
func (*GetApplicationResponse) ProtoMessage()    {}
func (*GetApplicationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{5}
}

func (m *GetApplicationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetApplicationResponse.Unmarshal(m, b)
}
func (m *GetApplicationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetApplicationResponse.Marshal(b, m, deterministic)
}
func (m *GetApplicationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetApplicationResponse.Merge(m, src)
}
func (m *GetApplicationResponse) XXX_Size() int {
	return xxx_messageInfo_GetApplicationResponse.Size(m)
}
func (m *GetApplicationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetApplicationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetApplicationResponse proto.InternalMessageInfo

func (m *GetApplicationResponse) GetApplication() *Application {
	if m != nil {
		return m.Application
	}
	return nil
}

type UpdateApplicationRequest struct {
	// Application object to update.
	Application          *Application `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *UpdateApplicationRequest) Reset()         { *m = UpdateApplicationRequest{} }
func (m *UpdateApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateApplicationRequest) ProtoMessage()    {}
func (*UpdateApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{6}
}

func (m *UpdateApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateApplicationRequest.Unmarshal(m, b)
}
func (m *UpdateApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateApplicationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateApplicationRequest.Merge(m, src)
}
func (m *UpdateApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateApplicationRequest.Size(m)
}
func (m *UpdateApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateApplicationRequest proto.InternalMessageInfo

func (m *UpdateApplicationRequest) GetApplication() *Application {
	if m != nil {
		return m.Application
	}
	return nil
}

type DeleteApplicationRequest struct {
	// Application ID.
	Id                   int64    `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteApplicationRequest) Reset()         { *m = DeleteApplicationRequest{} }
func (m *DeleteApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteApplicationRequest) ProtoMessage()    {}
func (*DeleteApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{7}
}

func (m *DeleteApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteApplicationRequest.Unmarshal(m, b)
}
func (m *DeleteApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteApplicationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteApplicationRequest.Merge(m, src)
}
func (m *DeleteApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteApplicationRequest.Size(m)
}
func (m *DeleteApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteApplicationRequest proto.InternalMessageInfo

func (m *DeleteApplicationRequest) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type ListApplicationRequest struct {
	// Max number of applications to return in the result-test.
	Limit int64 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset in the result-set (for pagination).
	Offset int64 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// ID of the organization to filter on.
	OrganizationId int64 `protobuf:"varint,3,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Search on name (optional).
	Search               string   `protobuf:"bytes,4,opt,name=search,proto3" json:"search,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListApplicationRequest) Reset()         { *m = ListApplicationRequest{} }
func (m *ListApplicationRequest) String() string { return proto.CompactTextString(m) }
func (*ListApplicationRequest) ProtoMessage()    {}
func (*ListApplicationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{8}
}

func (m *ListApplicationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListApplicationRequest.Unmarshal(m, b)
}
func (m *ListApplicationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListApplicationRequest.Marshal(b, m, deterministic)
}
func (m *ListApplicationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListApplicationRequest.Merge(m, src)
}
func (m *ListApplicationRequest) XXX_Size() int {
	return xxx_messageInfo_ListApplicationRequest.Size(m)
}
func (m *ListApplicationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListApplicationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListApplicationRequest proto.InternalMessageInfo

func (m *ListApplicationRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListApplicationRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListApplicationRequest) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *ListApplicationRequest) GetSearch() string {
	if m != nil {
		return m.Search
	}
	return ""
}

type ListApplicationResponse struct {
	// Total number of applications available within the result-set.
	TotalCount int64 `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Applications within this result-set.
	Result               []*ApplicationListItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ListApplicationResponse) Reset()         { *m = ListApplicationResponse{} }
func (m *ListApplicationResponse) String() string { return proto.CompactTextString(m) }
func (*ListApplicationResponse) ProtoMessage()    {}
func (*ListApplicationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{9}
}

func (m *ListApplicationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListApplicationResponse.Unmarshal(m, b)
}
func (m *ListApplicationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListApplicationResponse.Marshal(b, m, deterministic)
}
func (m *ListApplicationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListApplicationResponse.Merge(m, src)
}
func (m *ListApplicationResponse) XXX_Size() int {
	return xxx_messageInfo_ListApplicationResponse.Size(m)
}
func (m *ListApplicationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListApplicationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListApplicationResponse proto.InternalMessageInfo

func (m *ListApplicationResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ListApplicationResponse) GetResult() []*ApplicationListItem {
	if m != nil {
		return m.Result
	}
	return nil
}

type HTTPIntegrationHeader struct {
	// Key
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPIntegrationHeader) Reset()         { *m = HTTPIntegrationHeader{} }
func (m *HTTPIntegrationHeader) String() string { return proto.CompactTextString(m) }
func (*HTTPIntegrationHeader) ProtoMessage()    {}
func (*HTTPIntegrationHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{10}
}

func (m *HTTPIntegrationHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPIntegrationHeader.Unmarshal(m, b)
}
func (m *HTTPIntegrationHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPIntegrationHeader.Marshal(b, m, deterministic)
}
func (m *HTTPIntegrationHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPIntegrationHeader.Merge(m, src)
}
func (m *HTTPIntegrationHeader) XXX_Size() int {
	return xxx_messageInfo_HTTPIntegrationHeader.Size(m)
}
func (m *HTTPIntegrationHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPIntegrationHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPIntegrationHeader proto.InternalMessageInfo

func (m *HTTPIntegrationHeader) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *HTTPIntegrationHeader) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type HTTPIntegration struct {
	// The id of the application.
	ApplicationId int64 `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// The headers to use when making HTTP callbacks.
	Headers []*HTTPIntegrationHeader `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty"`
	// The URL to call for uplink data.
	UplinkDataUrl string `protobuf:"bytes,3,opt,name=uplink_data_url,json=uplinkDataURL,proto3" json:"uplink_data_url,omitempty"`
	// The URL to call for join notifications.
	JoinNotificationUrl string `protobuf:"bytes,4,opt,name=join_notification_url,json=joinNotificationURL,proto3" json:"join_notification_url,omitempty"`
	// The URL to call for ACK notifications (for confirmed downlink data).
	AckNotificationUrl string `protobuf:"bytes,5,opt,name=ack_notification_url,json=ackNotificationURL,proto3" json:"ack_notification_url,omitempty"`
	// The URL to call for error notifications.
	ErrorNotificationUrl string `protobuf:"bytes,6,opt,name=error_notification_url,json=errorNotificationURL,proto3" json:"error_notification_url,omitempty"`
	// The URL to call for device-status notifications.
	StatusNotificationUrl string `protobuf:"bytes,7,opt,name=status_notification_url,json=statusNotificationURL,proto3" json:"status_notification_url,omitempty"`
	// The URL to call for location notifications.
	LocationNotificationUrl string `protobuf:"bytes,8,opt,name=location_notification_url,json=locationNotificationURL,proto3" json:"location_notification_url,omitempty"`
	// The URL to call for tx ack notifications (downlink acknowledged by gateway for transmission).
	TxAckNotificationUrl string   `protobuf:"bytes,9,opt,name=tx_ack_notification_url,json=txAckNotificationURL,proto3" json:"tx_ack_notification_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPIntegration) Reset()         { *m = HTTPIntegration{} }
func (m *HTTPIntegration) String() string { return proto.CompactTextString(m) }
func (*HTTPIntegration) ProtoMessage()    {}
func (*HTTPIntegration) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{11}
}

func (m *HTTPIntegration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPIntegration.Unmarshal(m, b)
}
func (m *HTTPIntegration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPIntegration.Marshal(b, m, deterministic)
}
func (m *HTTPIntegration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPIntegration.Merge(m, src)
}
func (m *HTTPIntegration) XXX_Size() int {
	return xxx_messageInfo_HTTPIntegration.Size(m)
}
func (m *HTTPIntegration) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPIntegration.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPIntegration proto.InternalMessageInfo

func (m *HTTPIntegration) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *HTTPIntegration) GetHeaders() []*HTTPIntegrationHeader {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *HTTPIntegration) GetUplinkDataUrl() string {
	if m != nil {
		return m.UplinkDataUrl
	}
	return ""
}

func (m *HTTPIntegration) GetJoinNotificationUrl() string {
	if m != nil {
		return m.JoinNotificationUrl
	}
	return ""
}

func (m *HTTPIntegration) GetAckNotificationUrl() string {
	if m != nil {
		return m.AckNotificationUrl
	}
	return ""
}

func (m *HTTPIntegration) GetErrorNotificationUrl() string {
	if m != nil {
		return m.ErrorNotificationUrl
	}
	return ""
}

func (m *HTTPIntegration) GetStatusNotificationUrl() string {
	if m != nil {
		return m.StatusNotificationUrl
	}
	return ""
}

func (m *HTTPIntegration) GetLocationNotificationUrl() string {
	if m != nil {
		return m.LocationNotificationUrl
	}
	return ""
}

func (m *HTTPIntegration) GetTxAckNotificationUrl() string {
	if m != nil {
		return m.TxAckNotificationUrl
	}
	return ""
}

type CreateHTTPIntegrationRequest struct {
	// Integration object to create.
	Integration          *HTTPIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CreateHTTPIntegrationRequest) Reset()         { *m = CreateHTTPIntegrationRequest{} }
func (m *CreateHTTPIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateHTTPIntegrationRequest) ProtoMessage()    {}
func (*CreateHTTPIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{12}
}

func (m *CreateHTTPIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateHTTPIntegrationRequest.Unmarshal(m, b)
}
func (m *CreateHTTPIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateHTTPIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *CreateHTTPIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateHTTPIntegrationRequest.Merge(m, src)
}
func (m *CreateHTTPIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateHTTPIntegrationRequest.Size(m)
}
func (m *CreateHTTPIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateHTTPIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateHTTPIntegrationRequest proto.InternalMessageInfo

func (m *CreateHTTPIntegrationRequest) GetIntegration() *HTTPIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type GetHTTPIntegrationRequest struct {
	// Application ID.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetHTTPIntegrationRequest) Reset()         { *m = GetHTTPIntegrationRequest{} }
func (m *GetHTTPIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*GetHTTPIntegrationRequest) ProtoMessage()    {}
func (*GetHTTPIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{13}
}

func (m *GetHTTPIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetHTTPIntegrationRequest.Unmarshal(m, b)
}
func (m *GetHTTPIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetHTTPIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *GetHTTPIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetHTTPIntegrationRequest.Merge(m, src)
}
func (m *GetHTTPIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_GetHTTPIntegrationRequest.Size(m)
}
func (m *GetHTTPIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetHTTPIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetHTTPIntegrationRequest proto.InternalMessageInfo

func (m *GetHTTPIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type GetHTTPIntegrationResponse struct {
	// Integration object.
	Integration          *HTTPIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetHTTPIntegrationResponse) Reset()         { *m = GetHTTPIntegrationResponse{} }
func (m *GetHTTPIntegrationResponse) String() string { return proto.CompactTextString(m) }
func (*GetHTTPIntegrationResponse) ProtoMessage()    {}
func (*GetHTTPIntegrationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{14}
}

func (m *GetHTTPIntegrationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetHTTPIntegrationResponse.Unmarshal(m, b)
}
func (m *GetHTTPIntegrationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetHTTPIntegrationResponse.Marshal(b, m, deterministic)
}
func (m *GetHTTPIntegrationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetHTTPIntegrationResponse.Merge(m, src)
}
func (m *GetHTTPIntegrationResponse) XXX_Size() int {
	return xxx_messageInfo_GetHTTPIntegrationResponse.Size(m)
}
func (m *GetHTTPIntegrationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetHTTPIntegrationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetHTTPIntegrationResponse proto.InternalMessageInfo

func (m *GetHTTPIntegrationResponse) GetIntegration() *HTTPIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type UpdateHTTPIntegrationRequest struct {
	// Integration object to update.
	Integration          *HTTPIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *UpdateHTTPIntegrationRequest) Reset()         { *m = UpdateHTTPIntegrationRequest{} }
func (m *UpdateHTTPIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateHTTPIntegrationRequest) ProtoMessage()    {}
func (*UpdateHTTPIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{15}
}

func (m *UpdateHTTPIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateHTTPIntegrationRequest.Unmarshal(m, b)
}
func (m *UpdateHTTPIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateHTTPIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateHTTPIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateHTTPIntegrationRequest.Merge(m, src)
}
func (m *UpdateHTTPIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateHTTPIntegrationRequest.Size(m)
}
func (m *UpdateHTTPIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateHTTPIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateHTTPIntegrationRequest proto.InternalMessageInfo

func (m *UpdateHTTPIntegrationRequest) GetIntegration() *HTTPIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type DeleteHTTPIntegrationRequest struct {
	// The id of the application.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteHTTPIntegrationRequest) Reset()         { *m = DeleteHTTPIntegrationRequest{} }
func (m *DeleteHTTPIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteHTTPIntegrationRequest) ProtoMessage()    {}
func (*DeleteHTTPIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{16}
}

func (m *DeleteHTTPIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteHTTPIntegrationRequest.Unmarshal(m, b)
}
func (m *DeleteHTTPIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteHTTPIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteHTTPIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteHTTPIntegrationRequest.Merge(m, src)
}
func (m *DeleteHTTPIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteHTTPIntegrationRequest.Size(m)
}
func (m *DeleteHTTPIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteHTTPIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteHTTPIntegrationRequest proto.InternalMessageInfo

func (m *DeleteHTTPIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type ListIntegrationRequest struct {
	// The id of the application.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIntegrationRequest) Reset()         { *m = ListIntegrationRequest{} }
func (m *ListIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*ListIntegrationRequest) ProtoMessage()    {}
func (*ListIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{17}
}

func (m *ListIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIntegrationRequest.Unmarshal(m, b)
}
func (m *ListIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *ListIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIntegrationRequest.Merge(m, src)
}
func (m *ListIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_ListIntegrationRequest.Size(m)
}
func (m *ListIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListIntegrationRequest proto.InternalMessageInfo

func (m *ListIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type IntegrationListItem struct {
	// Integration kind.
	Kind                 IntegrationKind `protobuf:"varint,1,opt,name=kind,proto3,enum=api.IntegrationKind" json:"kind,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *IntegrationListItem) Reset()         { *m = IntegrationListItem{} }
func (m *IntegrationListItem) String() string { return proto.CompactTextString(m) }
func (*IntegrationListItem) ProtoMessage()    {}
func (*IntegrationListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{18}
}

func (m *IntegrationListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntegrationListItem.Unmarshal(m, b)
}
func (m *IntegrationListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntegrationListItem.Marshal(b, m, deterministic)
}
func (m *IntegrationListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntegrationListItem.Merge(m, src)
}
func (m *IntegrationListItem) XXX_Size() int {
	return xxx_messageInfo_IntegrationListItem.Size(m)
}
func (m *IntegrationListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_IntegrationListItem.DiscardUnknown(m)
}

var xxx_messageInfo_IntegrationListItem proto.InternalMessageInfo

func (m *IntegrationListItem) GetKind() IntegrationKind {
	if m != nil {
		return m.Kind
	}
	return IntegrationKind_HTTP
}

type ListIntegrationResponse struct {
	// Total number of integrations available within the result-set.
	TotalCount int64 `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Integrations within result-set.
	Result               []*IntegrationListItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ListIntegrationResponse) Reset()         { *m = ListIntegrationResponse{} }
func (m *ListIntegrationResponse) String() string { return proto.CompactTextString(m) }
func (*ListIntegrationResponse) ProtoMessage()    {}
func (*ListIntegrationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{19}
}

func (m *ListIntegrationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIntegrationResponse.Unmarshal(m, b)
}
func (m *ListIntegrationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIntegrationResponse.Marshal(b, m, deterministic)
}
func (m *ListIntegrationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIntegrationResponse.Merge(m, src)
}
func (m *ListIntegrationResponse) XXX_Size() int {
	return xxx_messageInfo_ListIntegrationResponse.Size(m)
}
func (m *ListIntegrationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIntegrationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListIntegrationResponse proto.InternalMessageInfo

func (m *ListIntegrationResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ListIntegrationResponse) GetResult() []*IntegrationListItem {
	if m != nil {
		return m.Result
	}
	return nil
}

type InfluxDBIntegration struct {
	// Application ID.
	ApplicationId int64 `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// InfluxDB API write endpoint (e.g. http://localhost:8086/write).
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// InfluxDB database name.
	Db string `protobuf:"bytes,3,opt,name=db,proto3" json:"db,omitempty"`
	// InfluxDB username.
	Username string `protobuf:"bytes,4,opt,name=username,proto3" json:"username,omitempty"`
	// InfluxDB password.
	Password string `protobuf:"bytes,5,opt,name=password,proto3" json:"password,omitempty"`
	// InfluxDB retention policy name.
	RetentionPolicyName string `protobuf:"bytes,6,opt,name=retention_policy_name,json=retentionPolicyName,proto3" json:"retention_policy_name,omitempty"`
	// InfluxDB timestamp precision.
	Precision            InfluxDBPrecision `protobuf:"varint,7,opt,name=precision,proto3,enum=api.InfluxDBPrecision" json:"precision,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *InfluxDBIntegration) Reset()         { *m = InfluxDBIntegration{} }
func (m *InfluxDBIntegration) String() string { return proto.CompactTextString(m) }
func (*InfluxDBIntegration) ProtoMessage()    {}
func (*InfluxDBIntegration) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{20}
}

func (m *InfluxDBIntegration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InfluxDBIntegration.Unmarshal(m, b)
}
func (m *InfluxDBIntegration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InfluxDBIntegration.Marshal(b, m, deterministic)
}
func (m *InfluxDBIntegration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfluxDBIntegration.Merge(m, src)
}
func (m *InfluxDBIntegration) XXX_Size() int {
	return xxx_messageInfo_InfluxDBIntegration.Size(m)
}
func (m *InfluxDBIntegration) XXX_DiscardUnknown() {
	xxx_messageInfo_InfluxDBIntegration.DiscardUnknown(m)
}

var xxx_messageInfo_InfluxDBIntegration proto.InternalMessageInfo

func (m *InfluxDBIntegration) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *InfluxDBIntegration) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *InfluxDBIntegration) GetDb() string {
	if m != nil {
		return m.Db
	}
	return ""
}

func (m *InfluxDBIntegration) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *InfluxDBIntegration) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *InfluxDBIntegration) GetRetentionPolicyName() string {
	if m != nil {
		return m.RetentionPolicyName
	}
	return ""
}

func (m *InfluxDBIntegration) GetPrecision() InfluxDBPrecision {
	if m != nil {
		return m.Precision
	}
	return InfluxDBPrecision_NS
}

type CreateInfluxDBIntegrationRequest struct {
	// Integration object to create.
	Integration          *InfluxDBIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateInfluxDBIntegrationRequest) Reset()         { *m = CreateInfluxDBIntegrationRequest{} }
func (m *CreateInfluxDBIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInfluxDBIntegrationRequest) ProtoMessage()    {}
func (*CreateInfluxDBIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{21}
}

func (m *CreateInfluxDBIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInfluxDBIntegrationRequest.Unmarshal(m, b)
}
func (m *CreateInfluxDBIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInfluxDBIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *CreateInfluxDBIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInfluxDBIntegrationRequest.Merge(m, src)
}
func (m *CreateInfluxDBIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInfluxDBIntegrationRequest.Size(m)
}
func (m *CreateInfluxDBIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInfluxDBIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInfluxDBIntegrationRequest proto.InternalMessageInfo

func (m *CreateInfluxDBIntegrationRequest) GetIntegration() *InfluxDBIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type GetInfluxDBIntegrationRequest struct {
	// Application ID.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInfluxDBIntegrationRequest) Reset()         { *m = GetInfluxDBIntegrationRequest{} }
func (m *GetInfluxDBIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*GetInfluxDBIntegrationRequest) ProtoMessage()    {}
func (*GetInfluxDBIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{22}
}

func (m *GetInfluxDBIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInfluxDBIntegrationRequest.Unmarshal(m, b)
}
func (m *GetInfluxDBIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInfluxDBIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *GetInfluxDBIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInfluxDBIntegrationRequest.Merge(m, src)
}
func (m *GetInfluxDBIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_GetInfluxDBIntegrationRequest.Size(m)
}
func (m *GetInfluxDBIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInfluxDBIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInfluxDBIntegrationRequest proto.InternalMessageInfo

func (m *GetInfluxDBIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type GetInfluxDBIntegrationResponse struct {
	// Integration object.
	Integration          *InfluxDBIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetInfluxDBIntegrationResponse) Reset()         { *m = GetInfluxDBIntegrationResponse{} }
func (m *GetInfluxDBIntegrationResponse) String() string { return proto.CompactTextString(m) }
func (*GetInfluxDBIntegrationResponse) ProtoMessage()    {}
func (*GetInfluxDBIntegrationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{23}
}

func (m *GetInfluxDBIntegrationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInfluxDBIntegrationResponse.Unmarshal(m, b)
}
func (m *GetInfluxDBIntegrationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInfluxDBIntegrationResponse.Marshal(b, m, deterministic)
}
func (m *GetInfluxDBIntegrationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInfluxDBIntegrationResponse.Merge(m, src)
}
func (m *GetInfluxDBIntegrationResponse) XXX_Size() int {
	return xxx_messageInfo_GetInfluxDBIntegrationResponse.Size(m)
}
func (m *GetInfluxDBIntegrationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInfluxDBIntegrationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetInfluxDBIntegrationResponse proto.InternalMessageInfo

func (m *GetInfluxDBIntegrationResponse) GetIntegration() *InfluxDBIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type UpdateInfluxDBIntegrationRequest struct {
	// Integration object.
	Integration          *InfluxDBIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateInfluxDBIntegrationRequest) Reset()         { *m = UpdateInfluxDBIntegrationRequest{} }
func (m *UpdateInfluxDBIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInfluxDBIntegrationRequest) ProtoMessage()    {}
func (*UpdateInfluxDBIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{24}
}

func (m *UpdateInfluxDBIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInfluxDBIntegrationRequest.Unmarshal(m, b)
}
func (m *UpdateInfluxDBIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInfluxDBIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInfluxDBIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInfluxDBIntegrationRequest.Merge(m, src)
}
func (m *UpdateInfluxDBIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInfluxDBIntegrationRequest.Size(m)
}
func (m *UpdateInfluxDBIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInfluxDBIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInfluxDBIntegrationRequest proto.InternalMessageInfo

func (m *UpdateInfluxDBIntegrationRequest) GetIntegration() *InfluxDBIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type DeleteInfluxDBIntegrationRequest struct {
	// Application ID.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInfluxDBIntegrationRequest) Reset()         { *m = DeleteInfluxDBIntegrationRequest{} }
func (m *DeleteInfluxDBIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInfluxDBIntegrationRequest) ProtoMessage()    {}
func (*DeleteInfluxDBIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{25}
}

func (m *DeleteInfluxDBIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInfluxDBIntegrationRequest.Unmarshal(m, b)
}
func (m *DeleteInfluxDBIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInfluxDBIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInfluxDBIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInfluxDBIntegrationRequest.Merge(m, src)
}
func (m *DeleteInfluxDBIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInfluxDBIntegrationRequest.Size(m)
}
func (m *DeleteInfluxDBIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInfluxDBIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInfluxDBIntegrationRequest proto.InternalMessageInfo

func (m *DeleteInfluxDBIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type ThingsBoardIntegration struct {
	// Application ID.
	ApplicationId int64 `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// ThingsBoard server endpoint, e.g. https://example.com
	Server               string   `protobuf:"bytes,2,opt,name=server,proto3" json:"server,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ThingsBoardIntegration) Reset()         { *m = ThingsBoardIntegration{} }
func (m *ThingsBoardIntegration) String() string { return proto.CompactTextString(m) }
func (*ThingsBoardIntegration) ProtoMessage()    {}
func (*ThingsBoardIntegration) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{26}
}

func (m *ThingsBoardIntegration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThingsBoardIntegration.Unmarshal(m, b)
}
func (m *ThingsBoardIntegration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThingsBoardIntegration.Marshal(b, m, deterministic)
}
func (m *ThingsBoardIntegration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThingsBoardIntegration.Merge(m, src)
}
func (m *ThingsBoardIntegration) XXX_Size() int {
	return xxx_messageInfo_ThingsBoardIntegration.Size(m)
}
func (m *ThingsBoardIntegration) XXX_DiscardUnknown() {
	xxx_messageInfo_ThingsBoardIntegration.DiscardUnknown(m)
}

var xxx_messageInfo_ThingsBoardIntegration proto.InternalMessageInfo

func (m *ThingsBoardIntegration) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *ThingsBoardIntegration) GetServer() string {
	if m != nil {
		return m.Server
	}
	return ""
}

type CreateThingsBoardIntegrationRequest struct {
	// Integration object to create.
	Integration          *ThingsBoardIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *CreateThingsBoardIntegrationRequest) Reset()         { *m = CreateThingsBoardIntegrationRequest{} }
func (m *CreateThingsBoardIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateThingsBoardIntegrationRequest) ProtoMessage()    {}
func (*CreateThingsBoardIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{27}
}

func (m *CreateThingsBoardIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateThingsBoardIntegrationRequest.Unmarshal(m, b)
}
func (m *CreateThingsBoardIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateThingsBoardIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *CreateThingsBoardIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateThingsBoardIntegrationRequest.Merge(m, src)
}
func (m *CreateThingsBoardIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateThingsBoardIntegrationRequest.Size(m)
}
func (m *CreateThingsBoardIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateThingsBoardIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateThingsBoardIntegrationRequest proto.InternalMessageInfo

func (m *CreateThingsBoardIntegrationRequest) GetIntegration() *ThingsBoardIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type GetThingsBoardIntegrationRequest struct {
	// Application ID.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetThingsBoardIntegrationRequest) Reset()         { *m = GetThingsBoardIntegrationRequest{} }
func (m *GetThingsBoardIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*GetThingsBoardIntegrationRequest) ProtoMessage()    {}
func (*GetThingsBoardIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{28}
}

func (m *GetThingsBoardIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetThingsBoardIntegrationRequest.Unmarshal(m, b)
}
func (m *GetThingsBoardIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetThingsBoardIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *GetThingsBoardIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetThingsBoardIntegrationRequest.Merge(m, src)
}
func (m *GetThingsBoardIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_GetThingsBoardIntegrationRequest.Size(m)
}
func (m *GetThingsBoardIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetThingsBoardIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetThingsBoardIntegrationRequest proto.InternalMessageInfo

func (m *GetThingsBoardIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type GetThingsBoardIntegrationResponse struct {
	// Integration object.
	Integration          *ThingsBoardIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *GetThingsBoardIntegrationResponse) Reset()         { *m = GetThingsBoardIntegrationResponse{} }
func (m *GetThingsBoardIntegrationResponse) String() string { return proto.CompactTextString(m) }
func (*GetThingsBoardIntegrationResponse) ProtoMessage()    {}
func (*GetThingsBoardIntegrationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{29}
}

func (m *GetThingsBoardIntegrationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetThingsBoardIntegrationResponse.Unmarshal(m, b)
}
func (m *GetThingsBoardIntegrationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetThingsBoardIntegrationResponse.Marshal(b, m, deterministic)
}
func (m *GetThingsBoardIntegrationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetThingsBoardIntegrationResponse.Merge(m, src)
}
func (m *GetThingsBoardIntegrationResponse) XXX_Size() int {
	return xxx_messageInfo_GetThingsBoardIntegrationResponse.Size(m)
}
func (m *GetThingsBoardIntegrationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetThingsBoardIntegrationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetThingsBoardIntegrationResponse proto.InternalMessageInfo

func (m *GetThingsBoardIntegrationResponse) GetIntegration() *ThingsBoardIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type UpdateThingsBoardIntegrationRequest struct {
	// Integration object.
	Integration          *ThingsBoardIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *UpdateThingsBoardIntegrationRequest) Reset()         { *m = UpdateThingsBoardIntegrationRequest{} }
func (m *UpdateThingsBoardIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateThingsBoardIntegrationRequest) ProtoMessage()    {}
func (*UpdateThingsBoardIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{30}
}

func (m *UpdateThingsBoardIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateThingsBoardIntegrationRequest.Unmarshal(m, b)
}
func (m *UpdateThingsBoardIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateThingsBoardIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateThingsBoardIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateThingsBoardIntegrationRequest.Merge(m, src)
}
func (m *UpdateThingsBoardIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateThingsBoardIntegrationRequest.Size(m)
}
func (m *UpdateThingsBoardIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateThingsBoardIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateThingsBoardIntegrationRequest proto.InternalMessageInfo

func (m *UpdateThingsBoardIntegrationRequest) GetIntegration() *ThingsBoardIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type DeleteThingsBoardIntegrationRequest struct {
	// Application ID.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteThingsBoardIntegrationRequest) Reset()         { *m = DeleteThingsBoardIntegrationRequest{} }
func (m *DeleteThingsBoardIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteThingsBoardIntegrationRequest) ProtoMessage()    {}
func (*DeleteThingsBoardIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{31}
}

func (m *DeleteThingsBoardIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteThingsBoardIntegrationRequest.Unmarshal(m, b)
}
func (m *DeleteThingsBoardIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteThingsBoardIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteThingsBoardIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteThingsBoardIntegrationRequest.Merge(m, src)
}
func (m *DeleteThingsBoardIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteThingsBoardIntegrationRequest.Size(m)
}
func (m *DeleteThingsBoardIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteThingsBoardIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteThingsBoardIntegrationRequest proto.InternalMessageInfo

func (m *DeleteThingsBoardIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type MyDevicesIntegration struct {
	// Application ID.
	ApplicationId int64 `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// MyDevices API endpoint.
	Endpoint             string   `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MyDevicesIntegration) Reset()         { *m = MyDevicesIntegration{} }
func (m *MyDevicesIntegration) String() string { return proto.CompactTextString(m) }
func (*MyDevicesIntegration) ProtoMessage()    {}
func (*MyDevicesIntegration) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{32}
}

func (m *MyDevicesIntegration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MyDevicesIntegration.Unmarshal(m, b)
}
func (m *MyDevicesIntegration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MyDevicesIntegration.Marshal(b, m, deterministic)
}
func (m *MyDevicesIntegration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MyDevicesIntegration.Merge(m, src)
}
func (m *MyDevicesIntegration) XXX_Size() int {
	return xxx_messageInfo_MyDevicesIntegration.Size(m)
}
func (m *MyDevicesIntegration) XXX_DiscardUnknown() {
	xxx_messageInfo_MyDevicesIntegration.DiscardUnknown(m)
}

var xxx_messageInfo_MyDevicesIntegration proto.InternalMessageInfo

func (m *MyDevicesIntegration) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *MyDevicesIntegration) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

type CreateMyDevicesIntegrationRequest struct {
	// Integration object to create.
	Integration          *MyDevicesIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CreateMyDevicesIntegrationRequest) Reset()         { *m = CreateMyDevicesIntegrationRequest{} }
func (m *CreateMyDevicesIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateMyDevicesIntegrationRequest) ProtoMessage()    {}
func (*CreateMyDevicesIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{33}
}

func (m *CreateMyDevicesIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMyDevicesIntegrationRequest.Unmarshal(m, b)
}
func (m *CreateMyDevicesIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMyDevicesIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *CreateMyDevicesIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMyDevicesIntegrationRequest.Merge(m, src)
}
func (m *CreateMyDevicesIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateMyDevicesIntegrationRequest.Size(m)
}
func (m *CreateMyDevicesIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMyDevicesIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMyDevicesIntegrationRequest proto.InternalMessageInfo

func (m *CreateMyDevicesIntegrationRequest) GetIntegration() *MyDevicesIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type GetMyDevicesIntegrationRequest struct {
	// Application ID.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMyDevicesIntegrationRequest) Reset()         { *m = GetMyDevicesIntegrationRequest{} }
func (m *GetMyDevicesIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*GetMyDevicesIntegrationRequest) ProtoMessage()    {}
func (*GetMyDevicesIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{34}
}

func (m *GetMyDevicesIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMyDevicesIntegrationRequest.Unmarshal(m, b)
}
func (m *GetMyDevicesIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMyDevicesIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *GetMyDevicesIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMyDevicesIntegrationRequest.Merge(m, src)
}
func (m *GetMyDevicesIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_GetMyDevicesIntegrationRequest.Size(m)
}
func (m *GetMyDevicesIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMyDevicesIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMyDevicesIntegrationRequest proto.InternalMessageInfo

func (m *GetMyDevicesIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type GetMyDevicesIntegrationResponse struct {
	// Integration object.
	Integration          *MyDevicesIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetMyDevicesIntegrationResponse) Reset()         { *m = GetMyDevicesIntegrationResponse{} }
func (m *GetMyDevicesIntegrationResponse) String() string { return proto.CompactTextString(m) }
func (*GetMyDevicesIntegrationResponse) ProtoMessage()    {}
func (*GetMyDevicesIntegrationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{35}
}

func (m *GetMyDevicesIntegrationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMyDevicesIntegrationResponse.Unmarshal(m, b)
}
func (m *GetMyDevicesIntegrationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMyDevicesIntegrationResponse.Marshal(b, m, deterministic)
}
func (m *GetMyDevicesIntegrationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMyDevicesIntegrationResponse.Merge(m, src)
}
func (m *GetMyDevicesIntegrationResponse) XXX_Size() int {
	return xxx_messageInfo_GetMyDevicesIntegrationResponse.Size(m)
}
func (m *GetMyDevicesIntegrationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMyDevicesIntegrationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetMyDevicesIntegrationResponse proto.InternalMessageInfo

func (m *GetMyDevicesIntegrationResponse) GetIntegration() *MyDevicesIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type UpdateMyDevicesIntegrationRequest struct {
	// Integration object.
	Integration          *MyDevicesIntegration `protobuf:"bytes,1,opt,name=integration,proto3" json:"integration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateMyDevicesIntegrationRequest) Reset()         { *m = UpdateMyDevicesIntegrationRequest{} }
func (m *UpdateMyDevicesIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateMyDevicesIntegrationRequest) ProtoMessage()    {}
func (*UpdateMyDevicesIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{36}
}

func (m *UpdateMyDevicesIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateMyDevicesIntegrationRequest.Unmarshal(m, b)
}
func (m *UpdateMyDevicesIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateMyDevicesIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *UpdateMyDevicesIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateMyDevicesIntegrationRequest.Merge(m, src)
}
func (m *UpdateMyDevicesIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateMyDevicesIntegrationRequest.Size(m)
}
func (m *UpdateMyDevicesIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateMyDevicesIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateMyDevicesIntegrationRequest proto.InternalMessageInfo

func (m *UpdateMyDevicesIntegrationRequest) GetIntegration() *MyDevicesIntegration {
	if m != nil {
		return m.Integration
	}
	return nil
}

type DeleteMyDevicesIntegrationRequest struct {
	// Application ID.
	ApplicationId        int64    `protobuf:"varint,1,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteMyDevicesIntegrationRequest) Reset()         { *m = DeleteMyDevicesIntegrationRequest{} }
func (m *DeleteMyDevicesIntegrationRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteMyDevicesIntegrationRequest) ProtoMessage()    {}
func (*DeleteMyDevicesIntegrationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0774996cc1ba5bfc, []int{37}
}

func (m *DeleteMyDevicesIntegrationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteMyDevicesIntegrationRequest.Unmarshal(m, b)
}
func (m *DeleteMyDevicesIntegrationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteMyDevicesIntegrationRequest.Marshal(b, m, deterministic)
}
func (m *DeleteMyDevicesIntegrationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteMyDevicesIntegrationRequest.Merge(m, src)
}
func (m *DeleteMyDevicesIntegrationRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteMyDevicesIntegrationRequest.Size(m)
}
func (m *DeleteMyDevicesIntegrationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteMyDevicesIntegrationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteMyDevicesIntegrationRequest proto.InternalMessageInfo

func (m *DeleteMyDevicesIntegrationRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func init() {
	proto.RegisterEnum("api.IntegrationKind", IntegrationKind_name, IntegrationKind_value)
	proto.RegisterEnum("api.InfluxDBPrecision", InfluxDBPrecision_name, InfluxDBPrecision_value)
	proto.RegisterType((*Application)(nil), "api.Application")
	proto.RegisterType((*ApplicationListItem)(nil), "api.ApplicationListItem")
	proto.RegisterType((*CreateApplicationRequest)(nil), "api.CreateApplicationRequest")
	proto.RegisterType((*CreateApplicationResponse)(nil), "api.CreateApplicationResponse")
	proto.RegisterType((*GetApplicationRequest)(nil), "api.GetApplicationRequest")
	proto.RegisterType((*GetApplicationResponse)(nil), "api.GetApplicationResponse")
	proto.RegisterType((*UpdateApplicationRequest)(nil), "api.UpdateApplicationRequest")
	proto.RegisterType((*DeleteApplicationRequest)(nil), "api.DeleteApplicationRequest")
	proto.RegisterType((*ListApplicationRequest)(nil), "api.ListApplicationRequest")
	proto.RegisterType((*ListApplicationResponse)(nil), "api.ListApplicationResponse")
	proto.RegisterType((*HTTPIntegrationHeader)(nil), "api.HTTPIntegrationHeader")
	proto.RegisterType((*HTTPIntegration)(nil), "api.HTTPIntegration")
	proto.RegisterType((*CreateHTTPIntegrationRequest)(nil), "api.CreateHTTPIntegrationRequest")
	proto.RegisterType((*GetHTTPIntegrationRequest)(nil), "api.GetHTTPIntegrationRequest")
	proto.RegisterType((*GetHTTPIntegrationResponse)(nil), "api.GetHTTPIntegrationResponse")
	proto.RegisterType((*UpdateHTTPIntegrationRequest)(nil), "api.UpdateHTTPIntegrationRequest")
	proto.RegisterType((*DeleteHTTPIntegrationRequest)(nil), "api.DeleteHTTPIntegrationRequest")
	proto.RegisterType((*ListIntegrationRequest)(nil), "api.ListIntegrationRequest")
	proto.RegisterType((*IntegrationListItem)(nil), "api.IntegrationListItem")
	proto.RegisterType((*ListIntegrationResponse)(nil), "api.ListIntegrationResponse")
	proto.RegisterType((*InfluxDBIntegration)(nil), "api.InfluxDBIntegration")
	proto.RegisterType((*CreateInfluxDBIntegrationRequest)(nil), "api.CreateInfluxDBIntegrationRequest")
	proto.RegisterType((*GetInfluxDBIntegrationRequest)(nil), "api.GetInfluxDBIntegrationRequest")
	proto.RegisterType((*GetInfluxDBIntegrationResponse)(nil), "api.GetInfluxDBIntegrationResponse")
	proto.RegisterType((*UpdateInfluxDBIntegrationRequest)(nil), "api.UpdateInfluxDBIntegrationRequest")
	proto.RegisterType((*DeleteInfluxDBIntegrationRequest)(nil), "api.DeleteInfluxDBIntegrationRequest")
	proto.RegisterType((*ThingsBoardIntegration)(nil), "api.ThingsBoardIntegration")
	proto.RegisterType((*CreateThingsBoardIntegrationRequest)(nil), "api.CreateThingsBoardIntegrationRequest")
	proto.RegisterType((*GetThingsBoardIntegrationRequest)(nil), "api.GetThingsBoardIntegrationRequest")
	proto.RegisterType((*GetThingsBoardIntegrationResponse)(nil), "api.GetThingsBoardIntegrationResponse")
	proto.RegisterType((*UpdateThingsBoardIntegrationRequest)(nil), "api.UpdateThingsBoardIntegrationRequest")
	proto.RegisterType((*DeleteThingsBoardIntegrationRequest)(nil), "api.DeleteThingsBoardIntegrationRequest")
	proto.RegisterType((*MyDevicesIntegration)(nil), "api.MyDevicesIntegration")
	proto.RegisterType((*CreateMyDevicesIntegrationRequest)(nil), "api.CreateMyDevicesIntegrationRequest")
	proto.RegisterType((*GetMyDevicesIntegrationRequest)(nil), "api.GetMyDevicesIntegrationRequest")
	proto.RegisterType((*GetMyDevicesIntegrationResponse)(nil), "api.GetMyDevicesIntegrationResponse")
	proto.RegisterType((*UpdateMyDevicesIntegrationRequest)(nil), "api.UpdateMyDevicesIntegrationRequest")
	proto.RegisterType((*DeleteMyDevicesIntegrationRequest)(nil), "api.DeleteMyDevicesIntegrationRequest")
}

func init() { proto.RegisterFile("as/external/api/application.proto", fileDescriptor_0774996cc1ba5bfc) }

var fileDescriptor_0774996cc1ba5bfc = []byte{
	// 1823 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xcf, 0x53, 0x23, 0xc7,
	0x15, 0xf6, 0x48, 0xac, 0x76, 0x79, 0xf2, 0x82, 0xdc, 0x80, 0x10, 0xb3, 0x98, 0x85, 0x21, 0xd9,
	0xa5, 0x94, 0x58, 0xda, 0x60, 0xb2, 0x8e, 0xd9, 0xb8, 0xd6, 0x80, 0xb0, 0x90, 0x0d, 0x98, 0x12,
	0xb0, 0x89, 0x53, 0x2e, 0xe4, 0x91, 0xa6, 0x81, 0x09, 0xa3, 0x99, 0xc9, 0x4c, 0x8b, 0x40, 0x52,
	0x7b, 0xc9, 0x21, 0xa9, 0xca, 0x29, 0x55, 0x3e, 0xe4, 0x92, 0x2a, 0x1f, 0x52, 0xa9, 0x1c, 0x52,
	0x95, 0x5c, 0x72, 0xcb, 0x9f, 0x91, 0x73, 0x6e, 0xfe, 0x43, 0x52, 0xfd, 0x63, 0xc4, 0x30, 0xea,
	0x19, 0x01, 0xd2, 0x56, 0xf9, 0x84, 0x7a, 0xde, 0x8f, 0xfe, 0xfa, 0x9b, 0xaf, 0x7b, 0xde, 0x6b,
	0x60, 0x41, 0xf7, 0xcb, 0xf8, 0x82, 0x60, 0xcf, 0xd6, 0xad, 0xb2, 0xee, 0x9a, 0x65, 0xdd, 0x75,
	0x2d, 0xb3, 0xa5, 0x13, 0xd3, 0xb1, 0x4b, 0xae, 0xe7, 0x10, 0x07, 0xa5, 0x75, 0xd7, 0x54, 0x67,
	0x4f, 0x1c, 0xe7, 0xc4, 0xc2, 0xdc, 0xc5, 0xb6, 0x1d, 0xc2, 0x3c, 0x7c, 0xee, 0xa2, 0x3e, 0x12,
	0x56, 0x36, 0x6a, 0x76, 0x8e, 0xcb, 0xb8, 0xed, 0x92, 0x4b, 0x6e, 0xd4, 0xfe, 0x93, 0x82, 0xec,
	0xda, 0x55, 0x56, 0x34, 0x06, 0x29, 0xd3, 0x28, 0x28, 0xf3, 0xca, 0x52, 0xba, 0x9e, 0x32, 0x0d,
	0x84, 0x60, 0xc4, 0xd6, 0xdb, 0xb8, 0x90, 0x9a, 0x57, 0x96, 0x46, 0xeb, 0xec, 0x37, 0x9a, 0x87,
	0xac, 0x81, 0xfd, 0x96, 0x67, 0xba, 0x34, 0xa4, 0x90, 0x66, 0xa6, 0xf0, 0x23, 0xf4, 0x14, 0xc6,
	0x1d, 0xef, 0x44, 0xb7, 0xcd, 0xdf, 0xb0, 0xac, 0x0d, 0xd3, 0x28, 0x8c, 0xb0, 0x94, 0x63, 0xe1,
	0xc7, 0xb5, 0x0a, 0xfa, 0x21, 0x20, 0x1f, 0x7b, 0xe7, 0x66, 0x0b, 0x37, 0x5c, 0xcf, 0x39, 0x36,
	0x2d, 0x4c, 0x7d, 0xef, 0xb1, 0x8c, 0x39, 0x61, 0xd9, 0xe3, 0x86, 0x5a, 0x05, 0x2d, 0xc2, 0x43,
	0x57, 0xbf, 0xb4, 0x1c, 0xdd, 0x68, 0xb4, 0x1c, 0x03, 0xb7, 0x0a, 0x19, 0xe6, 0xf8, 0xb6, 0x78,
	0xb8, 0x41, 0x9f, 0xa1, 0x15, 0xc8, 0x07, 0x4e, 0xd8, 0xa6, 0x6e, 0x5e, 0x83, 0x03, 0x2b, 0xdc,
	0x67, 0xde, 0x93, 0xc2, 0xba, 0xc9, 0x8d, 0xfb, 0xcc, 0x16, 0x8e, 0x32, 0xf0, 0xb5, 0xa8, 0x07,
	0xd7, 0xa2, 0x2a, 0x38, 0x14, 0xa5, 0x7d, 0xab, 0xc0, 0x44, 0x88, 0xbd, 0x6d, 0xd3, 0x27, 0x35,
	0x82, 0xdb, 0xdf, 0x6d, 0x16, 0x9f, 0xc1, 0x64, 0xd4, 0x9b, 0x81, 0xe3, 0x64, 0xa2, 0xeb, 0xfe,
	0xbb, 0x7a, 0x1b, 0x6b, 0xbb, 0x50, 0xd8, 0xf0, 0xb0, 0x4e, 0x70, 0x68, 0xad, 0x75, 0xfc, 0xab,
	0x0e, 0xf6, 0x09, 0x5a, 0x86, 0x6c, 0x48, 0x95, 0x6c, 0xcd, 0xd9, 0xe5, 0x5c, 0x49, 0x77, 0xcd,
	0x52, 0xd8, 0x3b, 0xec, 0xa4, 0xfd, 0x00, 0x66, 0x24, 0xf9, 0x7c, 0xd7, 0xb1, 0x7d, 0x1c, 0xe5,
	0x4e, 0x7b, 0x0a, 0x53, 0x55, 0x4c, 0x24, 0x33, 0x47, 0x1d, 0xb7, 0x21, 0x1f, 0x75, 0x14, 0x29,
	0xef, 0x82, 0x71, 0x17, 0x0a, 0x87, 0xae, 0x31, 0xbc, 0x35, 0x17, 0xa1, 0x50, 0xc1, 0x16, 0x96,
	0xe6, 0x8b, 0xae, 0xe4, 0x0f, 0x0a, 0xe4, 0xa9, 0x96, 0x24, 0xae, 0x93, 0x70, 0xcf, 0x32, 0xdb,
	0x26, 0x11, 0xde, 0x7c, 0x80, 0xf2, 0x90, 0x71, 0x8e, 0x8f, 0x7d, 0x4c, 0x98, 0xc2, 0xd2, 0x75,
	0x31, 0x92, 0x29, 0x28, 0x2d, 0x55, 0x50, 0x1e, 0x32, 0x3e, 0xd6, 0xbd, 0xd6, 0x29, 0x53, 0xd8,
	0x68, 0x5d, 0x8c, 0x34, 0x0b, 0xa6, 0x7b, 0x80, 0x08, 0x52, 0x1f, 0x43, 0x96, 0x38, 0x44, 0xb7,
	0x1a, 0x2d, 0xa7, 0x63, 0x07, 0x78, 0x80, 0x3d, 0xda, 0xa0, 0x4f, 0xd0, 0x33, 0xc8, 0x78, 0xd8,
	0xef, 0x58, 0x14, 0x54, 0x7a, 0x29, 0xbb, 0x5c, 0x88, 0x12, 0x14, 0x6c, 0x97, 0xba, 0xf0, 0xd3,
	0x5e, 0xc2, 0xd4, 0xd6, 0xc1, 0xc1, 0x5e, 0xcd, 0x26, 0xf8, 0xc4, 0x63, 0x2e, 0x5b, 0x58, 0x37,
	0xb0, 0x87, 0x72, 0x90, 0x3e, 0xc3, 0x97, 0x6c, 0x8e, 0xd1, 0x3a, 0xfd, 0x49, 0x79, 0x38, 0xd7,
	0xad, 0x4e, 0xb0, 0xa5, 0xf8, 0x40, 0xfb, 0x5f, 0x1a, 0xc6, 0x23, 0x19, 0xd0, 0xf7, 0x61, 0x2c,
	0xf4, 0x1e, 0x1a, 0x5d, 0xa2, 0x1f, 0x86, 0x9e, 0xd6, 0x2a, 0x68, 0x05, 0xee, 0x9f, 0xb2, 0xc9,
	0x7c, 0x01, 0x57, 0x65, 0x70, 0xa5, 0x78, 0xea, 0x81, 0x2b, 0x7a, 0x02, 0xe3, 0x1d, 0xd7, 0x32,
	0xed, 0xb3, 0x86, 0xa1, 0x13, 0xbd, 0xd1, 0xf1, 0x2c, 0xb1, 0x91, 0x1f, 0xf2, 0xc7, 0x15, 0x9d,
	0xe8, 0x87, 0xf5, 0x6d, 0xb4, 0x0c, 0x53, 0xbf, 0x74, 0x4c, 0xbb, 0x61, 0x3b, 0xc4, 0x3c, 0x0e,
	0xa0, 0x50, 0x6f, 0x4e, 0xf7, 0x04, 0x35, 0xee, 0x86, 0x6c, 0x34, 0xe6, 0x19, 0x4c, 0xea, 0xad,
	0xb3, 0xde, 0x10, 0xbe, 0xaf, 0x91, 0xde, 0x3a, 0x8b, 0x46, 0xac, 0x40, 0x1e, 0x7b, 0x9e, 0xe3,
	0xf5, 0xc6, 0xf0, 0xbd, 0x3d, 0xc9, 0xac, 0xd1, 0xa8, 0xe7, 0x30, 0xed, 0x13, 0x9d, 0x74, 0xfc,
	0xde, 0x30, 0x7e, 0x62, 0x4e, 0x71, 0x73, 0x34, 0x6e, 0x15, 0x66, 0x2c, 0x47, 0x38, 0xf7, 0x44,
	0xf2, 0x53, 0x73, 0x3a, 0x70, 0x88, 0xc6, 0xfe, 0x18, 0xa6, 0xc9, 0x45, 0x43, 0xba, 0xbc, 0x51,
	0x0e, 0x95, 0x5c, 0xac, 0xf5, 0x2c, 0x50, 0x7b, 0x05, 0xb3, 0xfc, 0xe0, 0x88, 0xbc, 0x96, 0x60,
	0x77, 0x3c, 0x87, 0xac, 0x79, 0xf5, 0x54, 0x6c, 0xcc, 0x49, 0xd9, 0x8b, 0xac, 0x87, 0x1d, 0xb5,
	0x75, 0x98, 0xa9, 0x62, 0x12, 0x93, 0xf4, 0x66, 0x02, 0xd2, 0x0e, 0x40, 0x95, 0xe5, 0x10, 0xbb,
	0xe5, 0xae, 0xc8, 0x5e, 0xc1, 0x2c, 0x3f, 0x86, 0x86, 0xbc, 0xe2, 0x4d, 0x98, 0xe5, 0xc7, 0xd1,
	0x60, 0x8b, 0x7e, 0xc9, 0x0f, 0xaa, 0x41, 0x12, 0x4c, 0x84, 0x82, 0xbb, 0x1f, 0xd0, 0x25, 0x18,
	0x39, 0x33, 0x6d, 0x1e, 0x33, 0x26, 0xd6, 0x13, 0xf2, 0xfb, 0xcc, 0xb4, 0x8d, 0x3a, 0xf3, 0x08,
	0x4e, 0x28, 0x19, 0xe7, 0x77, 0x3c, 0xa1, 0x24, 0x78, 0xba, 0x27, 0xd4, 0x1f, 0x53, 0x14, 0xef,
	0xb1, 0xd5, 0xb9, 0xa8, 0xac, 0xdf, 0xe1, 0x90, 0x51, 0xe1, 0x01, 0xb6, 0x0d, 0xd7, 0x31, 0x6d,
	0x22, 0x0e, 0xae, 0xee, 0x98, 0x7e, 0x04, 0x8c, 0xa6, 0x38, 0x3d, 0x52, 0x46, 0x93, 0xfa, 0x76,
	0x7c, 0x5a, 0xfa, 0xb5, 0xb1, 0x38, 0x25, 0xba, 0x63, 0x6a, 0x73, 0x75, 0xdf, 0xff, 0xb5, 0xe3,
	0x05, 0x9f, 0xf9, 0xee, 0x98, 0x1e, 0x35, 0x1e, 0x26, 0xd8, 0x66, 0x40, 0x5c, 0xc7, 0x32, 0x5b,
	0x97, 0xe1, 0xef, 0xfb, 0x44, 0xd7, 0xb8, 0xc7, 0x6c, 0xf4, 0x03, 0x8f, 0x56, 0x60, 0xd4, 0xf5,
	0x70, 0xcb, 0xf4, 0xa9, 0x86, 0xee, 0x33, 0xce, 0xf3, 0x82, 0x0b, 0xbe, 0xd6, 0xbd, 0xc0, 0x5a,
	0xbf, 0x72, 0xd4, 0x8e, 0x60, 0x9e, 0xef, 0x46, 0x09, 0x23, 0x81, 0x0c, 0x56, 0x65, 0xfa, 0x2c,
	0x5c, 0xcb, 0x1d, 0xab, 0xd1, 0x4f, 0xe0, 0xdd, 0x2a, 0x26, 0x09, 0xc9, 0x6f, 0xa8, 0xb1, 0x2f,
	0x61, 0x2e, 0x2e, 0x8f, 0x50, 0xca, 0x20, 0x28, 0x8f, 0x60, 0x9e, 0xef, 0xd0, 0x37, 0xc4, 0x42,
	0x0d, 0xe6, 0xf9, 0x4e, 0x1d, 0x9c, 0x88, 0x9f, 0x41, 0xfe, 0xe0, 0xd4, 0xb4, 0x4f, 0xfc, 0x75,
	0x47, 0xf7, 0x8c, 0x3b, 0xe8, 0x97, 0x95, 0x09, 0xde, 0x39, 0xf6, 0x84, 0x7a, 0xc5, 0x48, 0x33,
	0x60, 0x91, 0x2b, 0x41, 0x9e, 0x3e, 0x80, 0xf9, 0x91, 0x8c, 0x86, 0x47, 0x8c, 0x86, 0x98, 0xc0,
	0x28, 0x13, 0x55, 0x4c, 0x92, 0xa7, 0xb8, 0x21, 0x13, 0x4d, 0x58, 0x48, 0x48, 0x25, 0x54, 0x31,
	0x20, 0x5c, 0x03, 0x16, 0xb9, 0x30, 0xde, 0x28, 0x29, 0xdb, 0xb0, 0xc8, 0xe5, 0x31, 0x14, 0x5e,
	0xbe, 0x80, 0xc9, 0x9d, 0xcb, 0x0a, 0xa6, 0x0d, 0x80, 0x3f, 0xdc, 0xf3, 0x4d, 0xfb, 0x0a, 0x16,
	0xb8, 0x46, 0x64, 0x13, 0x04, 0x30, 0x5f, 0xc8, 0xc8, 0x98, 0x61, 0x64, 0x48, 0xc3, 0xae, 0x51,
	0x51, 0x65, 0xfb, 0x3c, 0x29, 0xfd, 0x0d, 0x59, 0x38, 0x82, 0xc7, 0xb1, 0x89, 0x84, 0x36, 0x06,
	0x02, 0xfa, 0x15, 0x2c, 0x70, 0x65, 0xbc, 0x31, 0x2a, 0x3e, 0x85, 0x05, 0xae, 0x8a, 0xc1, 0xd9,
	0x28, 0xd6, 0x60, 0x3c, 0xf2, 0xe9, 0x45, 0x0f, 0x60, 0x84, 0xd6, 0x0d, 0xb9, 0xb7, 0xd0, 0xdb,
	0xf0, 0xa0, 0xb6, 0xfb, 0xc9, 0xf6, 0xe1, 0xcf, 0x2b, 0xeb, 0x39, 0x05, 0x8d, 0x43, 0xf6, 0x60,
	0xab, 0xb6, 0x5b, 0xdd, 0x5f, 0xff, 0x7c, 0xad, 0x5e, 0xc9, 0xa5, 0xd0, 0x43, 0x18, 0xdd, 0xf9,
	0xa2, 0xb2, 0xf9, 0xaa, 0xb6, 0xb1, 0xb9, 0x9f, 0x4b, 0x17, 0x5f, 0xc2, 0x3b, 0x3d, 0x5f, 0x14,
	0x94, 0x81, 0xd4, 0xee, 0x7e, 0xee, 0x2d, 0x74, 0x0f, 0x94, 0xc3, 0x9c, 0x42, 0x87, 0x3b, 0xfb,
	0xb9, 0x14, 0x1d, 0xee, 0xe7, 0xd2, 0xf4, 0xcf, 0x4e, 0x6e, 0x84, 0xfe, 0xd9, 0xca, 0xdd, 0x5b,
	0xfe, 0xb3, 0x0a, 0x28, 0xd4, 0x41, 0xec, 0xf3, 0x5e, 0x15, 0x61, 0xc8, 0x70, 0x6d, 0xa1, 0x77,
	0x19, 0x41, 0x71, 0xdd, 0xaa, 0x3a, 0x17, 0x67, 0xe6, 0xaf, 0x55, 0x9b, 0xfd, 0xdd, 0x7f, 0xbf,
	0xfd, 0x3a, 0x95, 0xd7, 0xde, 0x89, 0x5e, 0xb7, 0xf8, 0xab, 0x4a, 0x11, 0x1d, 0x41, 0xba, 0x8a,
	0x09, 0xe2, 0x9d, 0x81, 0xb4, 0x29, 0x55, 0x1f, 0x49, 0x6d, 0x22, 0xfb, 0x1c, 0xcb, 0x5e, 0x40,
	0xf9, 0x9e, 0xec, 0xe5, 0xdf, 0x9a, 0xc6, 0x6b, 0x64, 0x43, 0x86, 0xeb, 0x42, 0x2c, 0x23, 0xae,
	0x01, 0x55, 0xf3, 0x25, 0x7e, 0xa7, 0x53, 0x0a, 0xee, 0x74, 0x4a, 0x9b, 0x6d, 0x97, 0x5c, 0x6a,
	0xef, 0xb1, 0x09, 0x9e, 0xaa, 0x9a, 0x64, 0x82, 0xf0, 0xdd, 0x91, 0x69, 0xbc, 0xa6, 0xeb, 0x69,
	0x40, 0x86, 0xab, 0x44, 0xcc, 0x17, 0xd7, 0xa0, 0xc6, 0xce, 0x27, 0x16, 0x54, 0x8c, 0x5b, 0xd0,
	0x97, 0x30, 0x42, 0x4b, 0x28, 0xc4, 0x59, 0x91, 0xb7, 0xb4, 0xea, 0xac, 0xdc, 0x28, 0x38, 0x9b,
	0x61, 0x53, 0x4c, 0xa0, 0xde, 0x37, 0x82, 0xbe, 0x51, 0x60, 0x4a, 0xda, 0x0e, 0xa0, 0x85, 0xd0,
	0x6b, 0x96, 0x17, 0xb8, 0xb1, 0x4b, 0xfa, 0x8c, 0xcd, 0xb7, 0xa9, 0x7d, 0x2c, 0x5b, 0xd2, 0x55,
	0x9a, 0xd2, 0xf5, 0x9d, 0xf3, 0xba, 0x1c, 0xb2, 0xf9, 0xe5, 0x53, 0x42, 0x5c, 0x4a, 0xf0, 0xd7,
	0x0a, 0xa0, 0xde, 0xa6, 0x00, 0xcd, 0x05, 0x22, 0x89, 0xc1, 0xf6, 0x38, 0xd6, 0x2e, 0x48, 0xf9,
	0x29, 0x03, 0xf9, 0x1c, 0xad, 0x24, 0xbf, 0x67, 0x39, 0x30, 0xc6, 0x9b, 0xb4, 0xa9, 0x10, 0xbc,
	0x25, 0x35, 0x1c, 0xfd, 0x78, 0x53, 0x87, 0xc2, 0xdb, 0x9f, 0x14, 0x98, 0x92, 0xb6, 0x27, 0x02,
	0x61, 0x52, 0xeb, 0x12, 0x8b, 0x50, 0x90, 0x56, 0xbc, 0x1b, 0x69, 0xff, 0x50, 0x82, 0x4b, 0x2b,
	0x69, 0xfd, 0x1f, 0x12, 0x5c, 0x7c, 0x9d, 0x16, 0x0b, 0xed, 0x73, 0x06, 0xad, 0xa6, 0x55, 0x06,
	0x21, 0xcf, 0x64, 0xf3, 0x1a, 0x4d, 0x4a, 0xe0, 0x5f, 0x15, 0x76, 0x19, 0x26, 0x83, 0xaa, 0x05,
	0xe2, 0x4a, 0xc0, 0xb9, 0x98, 0xe8, 0x23, 0x44, 0xf8, 0x31, 0x03, 0xbd, 0x8a, 0x7e, 0x72, 0x5b,
	0x3e, 0x03, 0xa0, 0x8c, 0xd3, 0xd8, 0xda, 0x59, 0x70, 0xda, 0xaf, 0xb6, 0xee, 0xc7, 0xa9, 0x3a,
	0x34, 0x4e, 0xff, 0xa2, 0xc0, 0x4c, 0x6c, 0x25, 0x2e, 0xd0, 0xf6, 0xab, 0xd4, 0x63, 0xd1, 0x0a,
	0x32, 0x8b, 0x77, 0x27, 0xf3, 0xdf, 0x4a, 0x70, 0x39, 0x12, 0x53, 0xe3, 0x2f, 0x85, 0x34, 0x9a,
	0x58, 0x2c, 0xc6, 0x82, 0xac, 0x33, 0x90, 0xdb, 0x5a, 0x75, 0x10, 0x4a, 0x09, 0x9b, 0xba, 0x49,
	0xa7, 0xa6, 0xac, 0xfe, 0x4b, 0x61, 0x77, 0x2f, 0x71, 0x7d, 0x49, 0x20, 0xc4, 0x64, 0xc0, 0x4f,
	0xfa, 0xb9, 0x09, 0xc9, 0x6e, 0xb0, 0x05, 0x7c, 0x84, 0x5e, 0xdc, 0x96, 0xe5, 0x10, 0x68, 0x46,
	0x74, 0x52, 0x61, 0x2f, 0x88, 0xbe, 0x41, 0xed, 0xdf, 0x8f, 0x68, 0x75, 0x98, 0x44, 0xff, 0x4d,
	0x09, 0xae, 0x7c, 0x12, 0x61, 0xdf, 0xa0, 0x99, 0x88, 0x85, 0x2d, 0xe8, 0x2d, 0x0e, 0x44, 0xef,
	0x3f, 0x15, 0x50, 0xe3, 0x1b, 0x05, 0xf4, 0x24, 0xa4, 0xe2, 0x84, 0xe2, 0x36, 0x16, 0xe3, 0x1e,
	0xc3, 0xf8, 0xa9, 0xb6, 0x39, 0x08, 0xb5, 0xed, 0x4b, 0x83, 0x4f, 0x4c, 0x89, 0xfd, 0xbb, 0x02,
	0xd3, 0x31, 0xed, 0x02, 0xea, 0x1e, 0xa4, 0x49, 0x50, 0xbf, 0x97, 0xec, 0x24, 0xb4, 0xbb, 0xc6,
	0x80, 0xbf, 0x40, 0x1f, 0xde, 0x96, 0xdc, 0x2e, 0x58, 0x46, 0x6d, 0x7c, 0xe3, 0x21, 0xa8, 0xed,
	0xdb, 0x99, 0xf4, 0xa3, 0x56, 0x1d, 0x1e, 0xb5, 0xdf, 0x28, 0xa0, 0xc6, 0xf7, 0x31, 0x02, 0x70,
	0xdf, 0x46, 0x27, 0x16, 0xb0, 0xa0, 0xb4, 0x38, 0x00, 0xa5, 0xbf, 0x57, 0x20, 0x17, 0xb9, 0x7f,
	0xf4, 0x43, 0xe5, 0xae, 0x04, 0xcc, 0xac, 0xdc, 0x28, 0xde, 0xf2, 0x07, 0x0c, 0xd2, 0x8f, 0x50,
	0xf9, 0x96, 0x90, 0xd6, 0x3f, 0xfc, 0xc5, 0x07, 0x27, 0x26, 0x39, 0xed, 0x34, 0x4b, 0x2d, 0xa7,
	0x5d, 0x6e, 0x7a, 0x4e, 0x4b, 0xd7, 0xbd, 0x72, 0xeb, 0xd4, 0xf4, 0x5c, 0x9f, 0xe8, 0xad, 0xb3,
	0xf7, 0x68, 0xbe, 0x13, 0xa7, 0x7c, 0xfe, 0x7e, 0x39, 0xf2, 0x5f, 0xe5, 0x66, 0x86, 0xd1, 0xf2,
	0xfe, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0x2c, 0xdf, 0x55, 0x3e, 0x6f, 0x1e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ApplicationServiceClient is the client API for ApplicationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApplicationServiceClient interface {
	// Create creates the given application.
	Create(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*CreateApplicationResponse, error)
	// Get returns the requested application.
	Get(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*GetApplicationResponse, error)
	// Update updates the given application.
	Update(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Delete deletes the given application.
	Delete(ctx context.Context, in *DeleteApplicationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// List lists the available applications.
	List(ctx context.Context, in *ListApplicationRequest, opts ...grpc.CallOption) (*ListApplicationResponse, error)
	// CreateHTTPIntegration creates a HTTP application-integration.
	CreateHTTPIntegration(ctx context.Context, in *CreateHTTPIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetHTTPIntegration returns the HTTP application-integration.
	GetHTTPIntegration(ctx context.Context, in *GetHTTPIntegrationRequest, opts ...grpc.CallOption) (*GetHTTPIntegrationResponse, error)
	// UpdateHTTPIntegration updates the HTTP application-integration.
	UpdateHTTPIntegration(ctx context.Context, in *UpdateHTTPIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// DeleteIntegration deletes the HTTP application-integration.
	DeleteHTTPIntegration(ctx context.Context, in *DeleteHTTPIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// CreateInfluxDBIntegration create an InfluxDB application-integration.
	CreateInfluxDBIntegration(ctx context.Context, in *CreateInfluxDBIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetInfluxDBIntegration returns the InfluxDB application-integration.
	GetInfluxDBIntegration(ctx context.Context, in *GetInfluxDBIntegrationRequest, opts ...grpc.CallOption) (*GetInfluxDBIntegrationResponse, error)
	// UpdateInfluxDBIntegration updates the InfluxDB application-integration.
	UpdateInfluxDBIntegration(ctx context.Context, in *UpdateInfluxDBIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// DeleteInfluxDBIntegration deletes the InfluxDB application-integration.
	DeleteInfluxDBIntegration(ctx context.Context, in *DeleteInfluxDBIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// CreateThingsBoardIntegration creates a ThingsBoard application-integration.
	CreateThingsBoardIntegration(ctx context.Context, in *CreateThingsBoardIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetThingsBoardIntegration returns the ThingsBoard application-integration.
	GetThingsBoardIntegration(ctx context.Context, in *GetThingsBoardIntegrationRequest, opts ...grpc.CallOption) (*GetThingsBoardIntegrationResponse, error)
	// UpdateThingsBoardIntegration updates the ThingsBoard application-integration.
	UpdateThingsBoardIntegration(ctx context.Context, in *UpdateThingsBoardIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// DeleteThingsBoardIntegration deletes the ThingsBoard application-integration.
	DeleteThingsBoardIntegration(ctx context.Context, in *DeleteThingsBoardIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// CreateMyDevicesIntegration creates a MyDevices application-integration.
	CreateMyDevicesIntegration(ctx context.Context, in *CreateMyDevicesIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetMyDevicesIntegration returns the MyDevices application-integration.
	GetMyDevicesIntegration(ctx context.Context, in *GetMyDevicesIntegrationRequest, opts ...grpc.CallOption) (*GetMyDevicesIntegrationResponse, error)
	// UpdateMyDevicesIntegration updates the MyDevices application-integration.
	UpdateMyDevicesIntegration(ctx context.Context, in *UpdateMyDevicesIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// DeleteMyDevicesIntegration deletes the MyDevices application-integration.
	DeleteMyDevicesIntegration(ctx context.Context, in *DeleteMyDevicesIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// ListIntegrations lists all configured integrations.
	ListIntegrations(ctx context.Context, in *ListIntegrationRequest, opts ...grpc.CallOption) (*ListIntegrationResponse, error)
}

type applicationServiceClient struct {
	cc *grpc.ClientConn
}

func NewApplicationServiceClient(cc *grpc.ClientConn) ApplicationServiceClient {
	return &applicationServiceClient{cc}
}

func (c *applicationServiceClient) Create(ctx context.Context, in *CreateApplicationRequest, opts ...grpc.CallOption) (*CreateApplicationResponse, error) {
	out := new(CreateApplicationResponse)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) Get(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*GetApplicationResponse, error) {
	out := new(GetApplicationResponse)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) Update(ctx context.Context, in *UpdateApplicationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) Delete(ctx context.Context, in *DeleteApplicationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) List(ctx context.Context, in *ListApplicationRequest, opts ...grpc.CallOption) (*ListApplicationResponse, error) {
	out := new(ListApplicationResponse)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) CreateHTTPIntegration(ctx context.Context, in *CreateHTTPIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/CreateHTTPIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetHTTPIntegration(ctx context.Context, in *GetHTTPIntegrationRequest, opts ...grpc.CallOption) (*GetHTTPIntegrationResponse, error) {
	out := new(GetHTTPIntegrationResponse)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/GetHTTPIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) UpdateHTTPIntegration(ctx context.Context, in *UpdateHTTPIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/UpdateHTTPIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) DeleteHTTPIntegration(ctx context.Context, in *DeleteHTTPIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/DeleteHTTPIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) CreateInfluxDBIntegration(ctx context.Context, in *CreateInfluxDBIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/CreateInfluxDBIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetInfluxDBIntegration(ctx context.Context, in *GetInfluxDBIntegrationRequest, opts ...grpc.CallOption) (*GetInfluxDBIntegrationResponse, error) {
	out := new(GetInfluxDBIntegrationResponse)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/GetInfluxDBIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) UpdateInfluxDBIntegration(ctx context.Context, in *UpdateInfluxDBIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/UpdateInfluxDBIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) DeleteInfluxDBIntegration(ctx context.Context, in *DeleteInfluxDBIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/DeleteInfluxDBIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) CreateThingsBoardIntegration(ctx context.Context, in *CreateThingsBoardIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/CreateThingsBoardIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetThingsBoardIntegration(ctx context.Context, in *GetThingsBoardIntegrationRequest, opts ...grpc.CallOption) (*GetThingsBoardIntegrationResponse, error) {
	out := new(GetThingsBoardIntegrationResponse)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/GetThingsBoardIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) UpdateThingsBoardIntegration(ctx context.Context, in *UpdateThingsBoardIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/UpdateThingsBoardIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) DeleteThingsBoardIntegration(ctx context.Context, in *DeleteThingsBoardIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/DeleteThingsBoardIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) CreateMyDevicesIntegration(ctx context.Context, in *CreateMyDevicesIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/CreateMyDevicesIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) GetMyDevicesIntegration(ctx context.Context, in *GetMyDevicesIntegrationRequest, opts ...grpc.CallOption) (*GetMyDevicesIntegrationResponse, error) {
	out := new(GetMyDevicesIntegrationResponse)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/GetMyDevicesIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) UpdateMyDevicesIntegration(ctx context.Context, in *UpdateMyDevicesIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/UpdateMyDevicesIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) DeleteMyDevicesIntegration(ctx context.Context, in *DeleteMyDevicesIntegrationRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/DeleteMyDevicesIntegration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationServiceClient) ListIntegrations(ctx context.Context, in *ListIntegrationRequest, opts ...grpc.CallOption) (*ListIntegrationResponse, error) {
	out := new(ListIntegrationResponse)
	err := c.cc.Invoke(ctx, "/api.ApplicationService/ListIntegrations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationServiceServer is the server API for ApplicationService service.
type ApplicationServiceServer interface {
	// Create creates the given application.
	Create(context.Context, *CreateApplicationRequest) (*CreateApplicationResponse, error)
	// Get returns the requested application.
	Get(context.Context, *GetApplicationRequest) (*GetApplicationResponse, error)
	// Update updates the given application.
	Update(context.Context, *UpdateApplicationRequest) (*empty.Empty, error)
	// Delete deletes the given application.
	Delete(context.Context, *DeleteApplicationRequest) (*empty.Empty, error)
	// List lists the available applications.
	List(context.Context, *ListApplicationRequest) (*ListApplicationResponse, error)
	// CreateHTTPIntegration creates a HTTP application-integration.
	CreateHTTPIntegration(context.Context, *CreateHTTPIntegrationRequest) (*empty.Empty, error)
	// GetHTTPIntegration returns the HTTP application-integration.
	GetHTTPIntegration(context.Context, *GetHTTPIntegrationRequest) (*GetHTTPIntegrationResponse, error)
	// UpdateHTTPIntegration updates the HTTP application-integration.
	UpdateHTTPIntegration(context.Context, *UpdateHTTPIntegrationRequest) (*empty.Empty, error)
	// DeleteIntegration deletes the HTTP application-integration.
	DeleteHTTPIntegration(context.Context, *DeleteHTTPIntegrationRequest) (*empty.Empty, error)
	// CreateInfluxDBIntegration create an InfluxDB application-integration.
	CreateInfluxDBIntegration(context.Context, *CreateInfluxDBIntegrationRequest) (*empty.Empty, error)
	// GetInfluxDBIntegration returns the InfluxDB application-integration.
	GetInfluxDBIntegration(context.Context, *GetInfluxDBIntegrationRequest) (*GetInfluxDBIntegrationResponse, error)
	// UpdateInfluxDBIntegration updates the InfluxDB application-integration.
	UpdateInfluxDBIntegration(context.Context, *UpdateInfluxDBIntegrationRequest) (*empty.Empty, error)
	// DeleteInfluxDBIntegration deletes the InfluxDB application-integration.
	DeleteInfluxDBIntegration(context.Context, *DeleteInfluxDBIntegrationRequest) (*empty.Empty, error)
	// CreateThingsBoardIntegration creates a ThingsBoard application-integration.
	CreateThingsBoardIntegration(context.Context, *CreateThingsBoardIntegrationRequest) (*empty.Empty, error)
	// GetThingsBoardIntegration returns the ThingsBoard application-integration.
	GetThingsBoardIntegration(context.Context, *GetThingsBoardIntegrationRequest) (*GetThingsBoardIntegrationResponse, error)
	// UpdateThingsBoardIntegration updates the ThingsBoard application-integration.
	UpdateThingsBoardIntegration(context.Context, *UpdateThingsBoardIntegrationRequest) (*empty.Empty, error)
	// DeleteThingsBoardIntegration deletes the ThingsBoard application-integration.
	DeleteThingsBoardIntegration(context.Context, *DeleteThingsBoardIntegrationRequest) (*empty.Empty, error)
	// CreateMyDevicesIntegration creates a MyDevices application-integration.
	CreateMyDevicesIntegration(context.Context, *CreateMyDevicesIntegrationRequest) (*empty.Empty, error)
	// GetMyDevicesIntegration returns the MyDevices application-integration.
	GetMyDevicesIntegration(context.Context, *GetMyDevicesIntegrationRequest) (*GetMyDevicesIntegrationResponse, error)
	// UpdateMyDevicesIntegration updates the MyDevices application-integration.
	UpdateMyDevicesIntegration(context.Context, *UpdateMyDevicesIntegrationRequest) (*empty.Empty, error)
	// DeleteMyDevicesIntegration deletes the MyDevices application-integration.
	DeleteMyDevicesIntegration(context.Context, *DeleteMyDevicesIntegrationRequest) (*empty.Empty, error)
	// ListIntegrations lists all configured integrations.
	ListIntegrations(context.Context, *ListIntegrationRequest) (*ListIntegrationResponse, error)
}

// UnimplementedApplicationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedApplicationServiceServer struct {
}

func (*UnimplementedApplicationServiceServer) Create(ctx context.Context, req *CreateApplicationRequest) (*CreateApplicationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedApplicationServiceServer) Get(ctx context.Context, req *GetApplicationRequest) (*GetApplicationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedApplicationServiceServer) Update(ctx context.Context, req *UpdateApplicationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedApplicationServiceServer) Delete(ctx context.Context, req *DeleteApplicationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedApplicationServiceServer) List(ctx context.Context, req *ListApplicationRequest) (*ListApplicationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedApplicationServiceServer) CreateHTTPIntegration(ctx context.Context, req *CreateHTTPIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHTTPIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) GetHTTPIntegration(ctx context.Context, req *GetHTTPIntegrationRequest) (*GetHTTPIntegrationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHTTPIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) UpdateHTTPIntegration(ctx context.Context, req *UpdateHTTPIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHTTPIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) DeleteHTTPIntegration(ctx context.Context, req *DeleteHTTPIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHTTPIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) CreateInfluxDBIntegration(ctx context.Context, req *CreateInfluxDBIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInfluxDBIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) GetInfluxDBIntegration(ctx context.Context, req *GetInfluxDBIntegrationRequest) (*GetInfluxDBIntegrationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInfluxDBIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) UpdateInfluxDBIntegration(ctx context.Context, req *UpdateInfluxDBIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInfluxDBIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) DeleteInfluxDBIntegration(ctx context.Context, req *DeleteInfluxDBIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInfluxDBIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) CreateThingsBoardIntegration(ctx context.Context, req *CreateThingsBoardIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateThingsBoardIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) GetThingsBoardIntegration(ctx context.Context, req *GetThingsBoardIntegrationRequest) (*GetThingsBoardIntegrationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetThingsBoardIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) UpdateThingsBoardIntegration(ctx context.Context, req *UpdateThingsBoardIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateThingsBoardIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) DeleteThingsBoardIntegration(ctx context.Context, req *DeleteThingsBoardIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteThingsBoardIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) CreateMyDevicesIntegration(ctx context.Context, req *CreateMyDevicesIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMyDevicesIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) GetMyDevicesIntegration(ctx context.Context, req *GetMyDevicesIntegrationRequest) (*GetMyDevicesIntegrationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMyDevicesIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) UpdateMyDevicesIntegration(ctx context.Context, req *UpdateMyDevicesIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMyDevicesIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) DeleteMyDevicesIntegration(ctx context.Context, req *DeleteMyDevicesIntegrationRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMyDevicesIntegration not implemented")
}
func (*UnimplementedApplicationServiceServer) ListIntegrations(ctx context.Context, req *ListIntegrationRequest) (*ListIntegrationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIntegrations not implemented")
}

func RegisterApplicationServiceServer(s *grpc.Server, srv ApplicationServiceServer) {
	s.RegisterService(&_ApplicationService_serviceDesc, srv)
}

func _ApplicationService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Create(ctx, req.(*CreateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Get(ctx, req.(*GetApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Update(ctx, req.(*UpdateApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).Delete(ctx, req.(*DeleteApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).List(ctx, req.(*ListApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_CreateHTTPIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHTTPIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).CreateHTTPIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/CreateHTTPIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).CreateHTTPIntegration(ctx, req.(*CreateHTTPIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetHTTPIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHTTPIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).GetHTTPIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/GetHTTPIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).GetHTTPIntegration(ctx, req.(*GetHTTPIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_UpdateHTTPIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHTTPIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).UpdateHTTPIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/UpdateHTTPIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).UpdateHTTPIntegration(ctx, req.(*UpdateHTTPIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_DeleteHTTPIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHTTPIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).DeleteHTTPIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/DeleteHTTPIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).DeleteHTTPIntegration(ctx, req.(*DeleteHTTPIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_CreateInfluxDBIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInfluxDBIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).CreateInfluxDBIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/CreateInfluxDBIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).CreateInfluxDBIntegration(ctx, req.(*CreateInfluxDBIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetInfluxDBIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInfluxDBIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).GetInfluxDBIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/GetInfluxDBIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).GetInfluxDBIntegration(ctx, req.(*GetInfluxDBIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_UpdateInfluxDBIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInfluxDBIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).UpdateInfluxDBIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/UpdateInfluxDBIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).UpdateInfluxDBIntegration(ctx, req.(*UpdateInfluxDBIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_DeleteInfluxDBIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInfluxDBIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).DeleteInfluxDBIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/DeleteInfluxDBIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).DeleteInfluxDBIntegration(ctx, req.(*DeleteInfluxDBIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_CreateThingsBoardIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateThingsBoardIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).CreateThingsBoardIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/CreateThingsBoardIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).CreateThingsBoardIntegration(ctx, req.(*CreateThingsBoardIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetThingsBoardIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetThingsBoardIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).GetThingsBoardIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/GetThingsBoardIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).GetThingsBoardIntegration(ctx, req.(*GetThingsBoardIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_UpdateThingsBoardIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateThingsBoardIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).UpdateThingsBoardIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/UpdateThingsBoardIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).UpdateThingsBoardIntegration(ctx, req.(*UpdateThingsBoardIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_DeleteThingsBoardIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteThingsBoardIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).DeleteThingsBoardIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/DeleteThingsBoardIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).DeleteThingsBoardIntegration(ctx, req.(*DeleteThingsBoardIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_CreateMyDevicesIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMyDevicesIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).CreateMyDevicesIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/CreateMyDevicesIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).CreateMyDevicesIntegration(ctx, req.(*CreateMyDevicesIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_GetMyDevicesIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMyDevicesIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).GetMyDevicesIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/GetMyDevicesIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).GetMyDevicesIntegration(ctx, req.(*GetMyDevicesIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_UpdateMyDevicesIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMyDevicesIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).UpdateMyDevicesIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/UpdateMyDevicesIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).UpdateMyDevicesIntegration(ctx, req.(*UpdateMyDevicesIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_DeleteMyDevicesIntegration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMyDevicesIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).DeleteMyDevicesIntegration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/DeleteMyDevicesIntegration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).DeleteMyDevicesIntegration(ctx, req.(*DeleteMyDevicesIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ApplicationService_ListIntegrations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIntegrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationServiceServer).ListIntegrations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.ApplicationService/ListIntegrations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationServiceServer).ListIntegrations(ctx, req.(*ListIntegrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApplicationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.ApplicationService",
	HandlerType: (*ApplicationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _ApplicationService_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ApplicationService_Get_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ApplicationService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ApplicationService_Delete_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ApplicationService_List_Handler,
		},
		{
			MethodName: "CreateHTTPIntegration",
			Handler:    _ApplicationService_CreateHTTPIntegration_Handler,
		},
		{
			MethodName: "GetHTTPIntegration",
			Handler:    _ApplicationService_GetHTTPIntegration_Handler,
		},
		{
			MethodName: "UpdateHTTPIntegration",
			Handler:    _ApplicationService_UpdateHTTPIntegration_Handler,
		},
		{
			MethodName: "DeleteHTTPIntegration",
			Handler:    _ApplicationService_DeleteHTTPIntegration_Handler,
		},
		{
			MethodName: "CreateInfluxDBIntegration",
			Handler:    _ApplicationService_CreateInfluxDBIntegration_Handler,
		},
		{
			MethodName: "GetInfluxDBIntegration",
			Handler:    _ApplicationService_GetInfluxDBIntegration_Handler,
		},
		{
			MethodName: "UpdateInfluxDBIntegration",
			Handler:    _ApplicationService_UpdateInfluxDBIntegration_Handler,
		},
		{
			MethodName: "DeleteInfluxDBIntegration",
			Handler:    _ApplicationService_DeleteInfluxDBIntegration_Handler,
		},
		{
			MethodName: "CreateThingsBoardIntegration",
			Handler:    _ApplicationService_CreateThingsBoardIntegration_Handler,
		},
		{
			MethodName: "GetThingsBoardIntegration",
			Handler:    _ApplicationService_GetThingsBoardIntegration_Handler,
		},
		{
			MethodName: "UpdateThingsBoardIntegration",
			Handler:    _ApplicationService_UpdateThingsBoardIntegration_Handler,
		},
		{
			MethodName: "DeleteThingsBoardIntegration",
			Handler:    _ApplicationService_DeleteThingsBoardIntegration_Handler,
		},
		{
			MethodName: "CreateMyDevicesIntegration",
			Handler:    _ApplicationService_CreateMyDevicesIntegration_Handler,
		},
		{
			MethodName: "GetMyDevicesIntegration",
			Handler:    _ApplicationService_GetMyDevicesIntegration_Handler,
		},
		{
			MethodName: "UpdateMyDevicesIntegration",
			Handler:    _ApplicationService_UpdateMyDevicesIntegration_Handler,
		},
		{
			MethodName: "DeleteMyDevicesIntegration",
			Handler:    _ApplicationService_DeleteMyDevicesIntegration_Handler,
		},
		{
			MethodName: "ListIntegrations",
			Handler:    _ApplicationService_ListIntegrations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "as/external/api/application.proto",
}
