// Code generated by protoc-gen-go. DO NOT EDIT.
// source: as/external/api/device.proto

package api

import (
	context "context"
	fmt "fmt"
	common "github.com/brocaar/chirpstack-api/go/v3/common"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Device struct {
	// Device EUI (HEX encoded).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	// Name of the device (if left blank, it will be set to the DevEUI).
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the application to which the device must be added.
	// It is possible to move a device to a different application on update,
	// given that both the old and the new application share the same
	// service-profile.
	ApplicationId int64 `protobuf:"varint,3,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// Description of the device.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// DeviceProfileID attached to the device.
	DeviceProfileId string `protobuf:"bytes,5,opt,name=device_profile_id,json=deviceProfileID,proto3" json:"device_profile_id,omitempty"`
	// Skip frame-counter checks (this is insecure, but could be helpful for debugging).
	SkipFCntCheck bool `protobuf:"varint,6,opt,name=skip_f_cnt_check,json=skipFCntCheck,proto3" json:"skip_f_cnt_check,omitempty"`
	// Reference altitude.
	// When using geolocation, this altitude will be used as a reference
	// (when supported by the geolocation-server) to increase geolocation
	// accuracy.
	ReferenceAltitude float64 `protobuf:"fixed64,7,opt,name=reference_altitude,json=referenceAltitude,proto3" json:"reference_altitude,omitempty"`
	// Variables (user defined).
	// These variables can be used together with integrations to store tokens /
	// secrets that must be configured per device. These variables are not
	// exposed in the event payloads.
	Variables map[string]string `protobuf:"bytes,8,rep,name=variables,proto3" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Tags (user defined).
	// These tags are exposed in the event payloads or to integration. Tags are
	// intended for aggregation and filtering.
	Tags                 map[string]string `protobuf:"bytes,9,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Device) Reset()         { *m = Device{} }
func (m *Device) String() string { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()    {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{0}
}

func (m *Device) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device.Unmarshal(m, b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device.Marshal(b, m, deterministic)
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return xxx_messageInfo_Device.Size(m)
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

func (m *Device) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

func (m *Device) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Device) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *Device) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Device) GetDeviceProfileId() string {
	if m != nil {
		return m.DeviceProfileId
	}
	return ""
}

func (m *Device) GetSkipFCntCheck() bool {
	if m != nil {
		return m.SkipFCntCheck
	}
	return false
}

func (m *Device) GetReferenceAltitude() float64 {
	if m != nil {
		return m.ReferenceAltitude
	}
	return 0
}

func (m *Device) GetVariables() map[string]string {
	if m != nil {
		return m.Variables
	}
	return nil
}

func (m *Device) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type DeviceListItem struct {
	// Device EUI (HEX encoded).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	// Name of the device.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Application ID.
	ApplicationId int64 `protobuf:"varint,3,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// Description of the device.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Device-profile ID attached to the device.
	DeviceProfileId string `protobuf:"bytes,5,opt,name=device_profile_id,json=deviceProfileID,proto3" json:"device_profile_id,omitempty"`
	// Device-profile name.
	DeviceProfileName string `protobuf:"bytes,6,opt,name=device_profile_name,json=deviceProfileName,proto3" json:"device_profile_name,omitempty"`
	// The device battery status (deprecated, use device_status_battery_level).
	// 0:      The end-device is connected to an external power source
	// 1..254: The battery level, 1 being at minimum and 254 being at maximum
	// 255:    The end-device was not able to measure the battery level
	// 256:    The device-status is not available.
	DeviceStatusBattery uint32 `protobuf:"varint,7,opt,name=device_status_battery,json=deviceStatusBattery,proto3" json:"device_status_battery,omitempty"`
	// The device margin status
	// -32..32: The demodulation SNR ration in dB
	// 256:     The device-status is not available.
	DeviceStatusMargin int32 `protobuf:"varint,8,opt,name=device_status_margin,json=deviceStatusMargin,proto3" json:"device_status_margin,omitempty"`
	// Device is connected to an external power source.
	DeviceStatusExternalPowerSource bool `protobuf:"varint,10,opt,name=device_status_external_power_source,json=deviceStatusExternalPowerSource,proto3" json:"device_status_external_power_source,omitempty"`
	// Device battery status is unavailable.
	DeviceStatusBatteryLevelUnavailable bool `protobuf:"varint,11,opt,name=device_status_battery_level_unavailable,json=deviceStatusBatteryLevelUnavailable,proto3" json:"device_status_battery_level_unavailable,omitempty"`
	// Device battery level as a percentage.
	DeviceStatusBatteryLevel float32 `protobuf:"fixed32,12,opt,name=device_status_battery_level,json=deviceStatusBatteryLevel,proto3" json:"device_status_battery_level,omitempty"`
	// The last time the application-server received any data from the device,
	// or an empty string when the device never sent any data.
	LastSeenAt           *timestamp.Timestamp `protobuf:"bytes,9,opt,name=last_seen_at,json=lastSeenAt,proto3" json:"last_seen_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *DeviceListItem) Reset()         { *m = DeviceListItem{} }
func (m *DeviceListItem) String() string { return proto.CompactTextString(m) }
func (*DeviceListItem) ProtoMessage()    {}
func (*DeviceListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{1}
}

func (m *DeviceListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceListItem.Unmarshal(m, b)
}
func (m *DeviceListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceListItem.Marshal(b, m, deterministic)
}
func (m *DeviceListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceListItem.Merge(m, src)
}
func (m *DeviceListItem) XXX_Size() int {
	return xxx_messageInfo_DeviceListItem.Size(m)
}
func (m *DeviceListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceListItem.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceListItem proto.InternalMessageInfo

func (m *DeviceListItem) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

func (m *DeviceListItem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeviceListItem) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *DeviceListItem) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DeviceListItem) GetDeviceProfileId() string {
	if m != nil {
		return m.DeviceProfileId
	}
	return ""
}

func (m *DeviceListItem) GetDeviceProfileName() string {
	if m != nil {
		return m.DeviceProfileName
	}
	return ""
}

func (m *DeviceListItem) GetDeviceStatusBattery() uint32 {
	if m != nil {
		return m.DeviceStatusBattery
	}
	return 0
}

func (m *DeviceListItem) GetDeviceStatusMargin() int32 {
	if m != nil {
		return m.DeviceStatusMargin
	}
	return 0
}

func (m *DeviceListItem) GetDeviceStatusExternalPowerSource() bool {
	if m != nil {
		return m.DeviceStatusExternalPowerSource
	}
	return false
}

func (m *DeviceListItem) GetDeviceStatusBatteryLevelUnavailable() bool {
	if m != nil {
		return m.DeviceStatusBatteryLevelUnavailable
	}
	return false
}

func (m *DeviceListItem) GetDeviceStatusBatteryLevel() float32 {
	if m != nil {
		return m.DeviceStatusBatteryLevel
	}
	return 0
}

func (m *DeviceListItem) GetLastSeenAt() *timestamp.Timestamp {
	if m != nil {
		return m.LastSeenAt
	}
	return nil
}

type DeviceKeys struct {
	// Device EUI (HEX encoded).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	// Network root key (HEX encoded).
	// Note: For LoRaWAN 1.0.x, use this field for the LoRaWAN 1.0.x 'AppKey`!
	NwkKey string `protobuf:"bytes,2,opt,name=nwk_key,json=nwkKey,proto3" json:"nwk_key,omitempty"`
	// Application root key (HEX encoded).
	// Note: This field only needs to be set for LoRaWAN 1.1.x devices!
	AppKey string `protobuf:"bytes,3,opt,name=app_key,json=appKey,proto3" json:"app_key,omitempty"`
	// Gen application key (HEX encoded).
	// This is an optional key that only must be set for LORaWAN 1.0.x devices
	// that implement the remote multicast setup specification.
	GenAppKey            string   `protobuf:"bytes,4,opt,name=gen_app_key,json=genAppKey,proto3" json:"gen_app_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceKeys) Reset()         { *m = DeviceKeys{} }
func (m *DeviceKeys) String() string { return proto.CompactTextString(m) }
func (*DeviceKeys) ProtoMessage()    {}
func (*DeviceKeys) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{2}
}

func (m *DeviceKeys) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceKeys.Unmarshal(m, b)
}
func (m *DeviceKeys) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceKeys.Marshal(b, m, deterministic)
}
func (m *DeviceKeys) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceKeys.Merge(m, src)
}
func (m *DeviceKeys) XXX_Size() int {
	return xxx_messageInfo_DeviceKeys.Size(m)
}
func (m *DeviceKeys) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceKeys.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceKeys proto.InternalMessageInfo

func (m *DeviceKeys) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

func (m *DeviceKeys) GetNwkKey() string {
	if m != nil {
		return m.NwkKey
	}
	return ""
}

func (m *DeviceKeys) GetAppKey() string {
	if m != nil {
		return m.AppKey
	}
	return ""
}

func (m *DeviceKeys) GetGenAppKey() string {
	if m != nil {
		return m.GenAppKey
	}
	return ""
}

type CreateDeviceRequest struct {
	// Device object to create.
	Device               *Device  `protobuf:"bytes,1,opt,name=device,proto3" json:"device,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDeviceRequest) Reset()         { *m = CreateDeviceRequest{} }
func (m *CreateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceRequest) ProtoMessage()    {}
func (*CreateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{3}
}

func (m *CreateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceRequest.Unmarshal(m, b)
}
func (m *CreateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceRequest.Marshal(b, m, deterministic)
}
func (m *CreateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceRequest.Merge(m, src)
}
func (m *CreateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceRequest.Size(m)
}
func (m *CreateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceRequest proto.InternalMessageInfo

func (m *CreateDeviceRequest) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

type GetDeviceRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDeviceRequest) Reset()         { *m = GetDeviceRequest{} }
func (m *GetDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*GetDeviceRequest) ProtoMessage()    {}
func (*GetDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{4}
}

func (m *GetDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceRequest.Unmarshal(m, b)
}
func (m *GetDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceRequest.Marshal(b, m, deterministic)
}
func (m *GetDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceRequest.Merge(m, src)
}
func (m *GetDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_GetDeviceRequest.Size(m)
}
func (m *GetDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceRequest proto.InternalMessageInfo

func (m *GetDeviceRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type GetDeviceResponse struct {
	// Device object.
	Device *Device `protobuf:"bytes,1,opt,name=device,proto3" json:"device,omitempty"`
	// Last seen timestamp.
	LastSeenAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=last_seen_at,json=lastSeenAt,proto3" json:"last_seen_at,omitempty"`
	// The device battery status
	// 0:      The end-device is connected to an external power source
	// 1..254: The battery level, 1 being at minimum and 254 being at maximum
	// 255:    The end-device was not able to measure the battery level
	// 256:    The device-status is not available.
	DeviceStatusBattery uint32 `protobuf:"varint,6,opt,name=device_status_battery,json=deviceStatusBattery,proto3" json:"device_status_battery,omitempty"`
	// The device margin status
	// -32..32: The demodulation SNR ration in dB
	// 256:     The device-status is not available.
	DeviceStatusMargin int32 `protobuf:"varint,20,opt,name=device_status_margin,json=deviceStatusMargin,proto3" json:"device_status_margin,omitempty"`
	// Device location.
	// This will set when the network-server was able to resolve the location
	// using the geolocation-server.
	Location             *common.Location `protobuf:"bytes,21,opt,name=location,proto3" json:"location,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GetDeviceResponse) Reset()         { *m = GetDeviceResponse{} }
func (m *GetDeviceResponse) String() string { return proto.CompactTextString(m) }
func (*GetDeviceResponse) ProtoMessage()    {}
func (*GetDeviceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{5}
}

func (m *GetDeviceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceResponse.Unmarshal(m, b)
}
func (m *GetDeviceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceResponse.Marshal(b, m, deterministic)
}
func (m *GetDeviceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceResponse.Merge(m, src)
}
func (m *GetDeviceResponse) XXX_Size() int {
	return xxx_messageInfo_GetDeviceResponse.Size(m)
}
func (m *GetDeviceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceResponse proto.InternalMessageInfo

func (m *GetDeviceResponse) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

func (m *GetDeviceResponse) GetLastSeenAt() *timestamp.Timestamp {
	if m != nil {
		return m.LastSeenAt
	}
	return nil
}

func (m *GetDeviceResponse) GetDeviceStatusBattery() uint32 {
	if m != nil {
		return m.DeviceStatusBattery
	}
	return 0
}

func (m *GetDeviceResponse) GetDeviceStatusMargin() int32 {
	if m != nil {
		return m.DeviceStatusMargin
	}
	return 0
}

func (m *GetDeviceResponse) GetLocation() *common.Location {
	if m != nil {
		return m.Location
	}
	return nil
}

type ListDeviceRequest struct {
	// Max number of devices to return in the result-set.
	Limit int64 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset in the result-set (for pagination).
	Offset int64 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// Application ID to filter on.
	ApplicationId int64 `protobuf:"varint,3,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// Search on name or DevEUI.
	Search string `protobuf:"bytes,4,opt,name=search,proto3" json:"search,omitempty"`
	// Multicast-group ID to filter on (string formatted UUID).
	MulticastGroupId string `protobuf:"bytes,5,opt,name=multicast_group_id,json=multicastGroupID,proto3" json:"multicast_group_id,omitempty"`
	// Service-profile ID to filter on (string formatted UUID).
	ServiceProfileId string `protobuf:"bytes,6,opt,name=service_profile_id,json=serviceProfileID,proto3" json:"service_profile_id,omitempty"`
	// Tags to filter on.
	Tags                 map[string]string `protobuf:"bytes,7,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListDeviceRequest) Reset()         { *m = ListDeviceRequest{} }
func (m *ListDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*ListDeviceRequest) ProtoMessage()    {}
func (*ListDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{6}
}

func (m *ListDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceRequest.Unmarshal(m, b)
}
func (m *ListDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceRequest.Marshal(b, m, deterministic)
}
func (m *ListDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceRequest.Merge(m, src)
}
func (m *ListDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_ListDeviceRequest.Size(m)
}
func (m *ListDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceRequest proto.InternalMessageInfo

func (m *ListDeviceRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListDeviceRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListDeviceRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *ListDeviceRequest) GetSearch() string {
	if m != nil {
		return m.Search
	}
	return ""
}

func (m *ListDeviceRequest) GetMulticastGroupId() string {
	if m != nil {
		return m.MulticastGroupId
	}
	return ""
}

func (m *ListDeviceRequest) GetServiceProfileId() string {
	if m != nil {
		return m.ServiceProfileId
	}
	return ""
}

func (m *ListDeviceRequest) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type ListDeviceResponse struct {
	// Total number of devices available within the result-set.
	TotalCount int64 `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Devices within this result-set.
	Result               []*DeviceListItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListDeviceResponse) Reset()         { *m = ListDeviceResponse{} }
func (m *ListDeviceResponse) String() string { return proto.CompactTextString(m) }
func (*ListDeviceResponse) ProtoMessage()    {}
func (*ListDeviceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{7}
}

func (m *ListDeviceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDeviceResponse.Unmarshal(m, b)
}
func (m *ListDeviceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDeviceResponse.Marshal(b, m, deterministic)
}
func (m *ListDeviceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDeviceResponse.Merge(m, src)
}
func (m *ListDeviceResponse) XXX_Size() int {
	return xxx_messageInfo_ListDeviceResponse.Size(m)
}
func (m *ListDeviceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDeviceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDeviceResponse proto.InternalMessageInfo

func (m *ListDeviceResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ListDeviceResponse) GetResult() []*DeviceListItem {
	if m != nil {
		return m.Result
	}
	return nil
}

type DeleteDeviceRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceRequest) Reset()         { *m = DeleteDeviceRequest{} }
func (m *DeleteDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceRequest) ProtoMessage()    {}
func (*DeleteDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{8}
}

func (m *DeleteDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceRequest.Unmarshal(m, b)
}
func (m *DeleteDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceRequest.Merge(m, src)
}
func (m *DeleteDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceRequest.Size(m)
}
func (m *DeleteDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceRequest proto.InternalMessageInfo

func (m *DeleteDeviceRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type UpdateDeviceRequest struct {
	// Device object to update.
	Device               *Device  `protobuf:"bytes,1,opt,name=device,proto3" json:"device,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateDeviceRequest) Reset()         { *m = UpdateDeviceRequest{} }
func (m *UpdateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDeviceRequest) ProtoMessage()    {}
func (*UpdateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{9}
}

func (m *UpdateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDeviceRequest.Unmarshal(m, b)
}
func (m *UpdateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDeviceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDeviceRequest.Merge(m, src)
}
func (m *UpdateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDeviceRequest.Size(m)
}
func (m *UpdateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDeviceRequest proto.InternalMessageInfo

func (m *UpdateDeviceRequest) GetDevice() *Device {
	if m != nil {
		return m.Device
	}
	return nil
}

type CreateDeviceKeysRequest struct {
	// Device-keys object to create.
	DeviceKeys           *DeviceKeys `protobuf:"bytes,1,opt,name=device_keys,json=deviceKeys,proto3" json:"device_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateDeviceKeysRequest) Reset()         { *m = CreateDeviceKeysRequest{} }
func (m *CreateDeviceKeysRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDeviceKeysRequest) ProtoMessage()    {}
func (*CreateDeviceKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{10}
}

func (m *CreateDeviceKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDeviceKeysRequest.Unmarshal(m, b)
}
func (m *CreateDeviceKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDeviceKeysRequest.Marshal(b, m, deterministic)
}
func (m *CreateDeviceKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDeviceKeysRequest.Merge(m, src)
}
func (m *CreateDeviceKeysRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDeviceKeysRequest.Size(m)
}
func (m *CreateDeviceKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDeviceKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDeviceKeysRequest proto.InternalMessageInfo

func (m *CreateDeviceKeysRequest) GetDeviceKeys() *DeviceKeys {
	if m != nil {
		return m.DeviceKeys
	}
	return nil
}

type GetDeviceKeysRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDeviceKeysRequest) Reset()         { *m = GetDeviceKeysRequest{} }
func (m *GetDeviceKeysRequest) String() string { return proto.CompactTextString(m) }
func (*GetDeviceKeysRequest) ProtoMessage()    {}
func (*GetDeviceKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{11}
}

func (m *GetDeviceKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceKeysRequest.Unmarshal(m, b)
}
func (m *GetDeviceKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceKeysRequest.Marshal(b, m, deterministic)
}
func (m *GetDeviceKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceKeysRequest.Merge(m, src)
}
func (m *GetDeviceKeysRequest) XXX_Size() int {
	return xxx_messageInfo_GetDeviceKeysRequest.Size(m)
}
func (m *GetDeviceKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceKeysRequest proto.InternalMessageInfo

func (m *GetDeviceKeysRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type GetDeviceKeysResponse struct {
	// Device-key object.
	DeviceKeys           *DeviceKeys `protobuf:"bytes,1,opt,name=device_keys,json=deviceKeys,proto3" json:"device_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *GetDeviceKeysResponse) Reset()         { *m = GetDeviceKeysResponse{} }
func (m *GetDeviceKeysResponse) String() string { return proto.CompactTextString(m) }
func (*GetDeviceKeysResponse) ProtoMessage()    {}
func (*GetDeviceKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{12}
}

func (m *GetDeviceKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceKeysResponse.Unmarshal(m, b)
}
func (m *GetDeviceKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceKeysResponse.Marshal(b, m, deterministic)
}
func (m *GetDeviceKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceKeysResponse.Merge(m, src)
}
func (m *GetDeviceKeysResponse) XXX_Size() int {
	return xxx_messageInfo_GetDeviceKeysResponse.Size(m)
}
func (m *GetDeviceKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceKeysResponse proto.InternalMessageInfo

func (m *GetDeviceKeysResponse) GetDeviceKeys() *DeviceKeys {
	if m != nil {
		return m.DeviceKeys
	}
	return nil
}

type UpdateDeviceKeysRequest struct {
	// Device-keys object to update.
	DeviceKeys           *DeviceKeys `protobuf:"bytes,1,opt,name=device_keys,json=deviceKeys,proto3" json:"device_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *UpdateDeviceKeysRequest) Reset()         { *m = UpdateDeviceKeysRequest{} }
func (m *UpdateDeviceKeysRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDeviceKeysRequest) ProtoMessage()    {}
func (*UpdateDeviceKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{13}
}

func (m *UpdateDeviceKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDeviceKeysRequest.Unmarshal(m, b)
}
func (m *UpdateDeviceKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDeviceKeysRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDeviceKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDeviceKeysRequest.Merge(m, src)
}
func (m *UpdateDeviceKeysRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDeviceKeysRequest.Size(m)
}
func (m *UpdateDeviceKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDeviceKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDeviceKeysRequest proto.InternalMessageInfo

func (m *UpdateDeviceKeysRequest) GetDeviceKeys() *DeviceKeys {
	if m != nil {
		return m.DeviceKeys
	}
	return nil
}

type DeleteDeviceKeysRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDeviceKeysRequest) Reset()         { *m = DeleteDeviceKeysRequest{} }
func (m *DeleteDeviceKeysRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDeviceKeysRequest) ProtoMessage()    {}
func (*DeleteDeviceKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{14}
}

func (m *DeleteDeviceKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDeviceKeysRequest.Unmarshal(m, b)
}
func (m *DeleteDeviceKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDeviceKeysRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDeviceKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDeviceKeysRequest.Merge(m, src)
}
func (m *DeleteDeviceKeysRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDeviceKeysRequest.Size(m)
}
func (m *DeleteDeviceKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDeviceKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDeviceKeysRequest proto.InternalMessageInfo

func (m *DeleteDeviceKeysRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type DeviceActivation struct {
	// Device EUI (HEX encoded).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	// Device address (HEX encoded).
	DevAddr string `protobuf:"bytes,2,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	// Application session key (HEX encoded).
	AppSKey string `protobuf:"bytes,3,opt,name=app_s_key,json=appSKey,proto3" json:"app_s_key,omitempty"`
	// Network session encryption key (HEX encoded).
	NwkSEncKey string `protobuf:"bytes,4,opt,name=nwk_s_enc_key,json=nwkSEncKey,proto3" json:"nwk_s_enc_key,omitempty"`
	// Serving network session integrity key (HEX encoded).
	SNwkSIntKey string `protobuf:"bytes,8,opt,name=s_nwk_s_int_key,json=sNwkSIntKey,proto3" json:"s_nwk_s_int_key,omitempty"`
	// Forwarding network session integrity key (HEX encoded).
	FNwkSIntKey string `protobuf:"bytes,9,opt,name=f_nwk_s_int_key,json=fNwkSIntKey,proto3" json:"f_nwk_s_int_key,omitempty"`
	// Uplink frame-counter.
	FCntUp uint32 `protobuf:"varint,5,opt,name=f_cnt_up,json=fCntUp,proto3" json:"f_cnt_up,omitempty"`
	// Downlink network frame-counter.
	NFCntDown uint32 `protobuf:"varint,6,opt,name=n_f_cnt_down,json=nFCntDown,proto3" json:"n_f_cnt_down,omitempty"`
	// Downlink application frame-counter.
	AFCntDown            uint32   `protobuf:"varint,10,opt,name=a_f_cnt_down,json=aFCntDown,proto3" json:"a_f_cnt_down,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceActivation) Reset()         { *m = DeviceActivation{} }
func (m *DeviceActivation) String() string { return proto.CompactTextString(m) }
func (*DeviceActivation) ProtoMessage()    {}
func (*DeviceActivation) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{15}
}

func (m *DeviceActivation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceActivation.Unmarshal(m, b)
}
func (m *DeviceActivation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceActivation.Marshal(b, m, deterministic)
}
func (m *DeviceActivation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceActivation.Merge(m, src)
}
func (m *DeviceActivation) XXX_Size() int {
	return xxx_messageInfo_DeviceActivation.Size(m)
}
func (m *DeviceActivation) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceActivation.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceActivation proto.InternalMessageInfo

func (m *DeviceActivation) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

func (m *DeviceActivation) GetDevAddr() string {
	if m != nil {
		return m.DevAddr
	}
	return ""
}

func (m *DeviceActivation) GetAppSKey() string {
	if m != nil {
		return m.AppSKey
	}
	return ""
}

func (m *DeviceActivation) GetNwkSEncKey() string {
	if m != nil {
		return m.NwkSEncKey
	}
	return ""
}

func (m *DeviceActivation) GetSNwkSIntKey() string {
	if m != nil {
		return m.SNwkSIntKey
	}
	return ""
}

func (m *DeviceActivation) GetFNwkSIntKey() string {
	if m != nil {
		return m.FNwkSIntKey
	}
	return ""
}

func (m *DeviceActivation) GetFCntUp() uint32 {
	if m != nil {
		return m.FCntUp
	}
	return 0
}

func (m *DeviceActivation) GetNFCntDown() uint32 {
	if m != nil {
		return m.NFCntDown
	}
	return 0
}

func (m *DeviceActivation) GetAFCntDown() uint32 {
	if m != nil {
		return m.AFCntDown
	}
	return 0
}

type ActivateDeviceRequest struct {
	DeviceActivation     *DeviceActivation `protobuf:"bytes,1,opt,name=device_activation,json=deviceActivation,proto3" json:"device_activation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ActivateDeviceRequest) Reset()         { *m = ActivateDeviceRequest{} }
func (m *ActivateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*ActivateDeviceRequest) ProtoMessage()    {}
func (*ActivateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{16}
}

func (m *ActivateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActivateDeviceRequest.Unmarshal(m, b)
}
func (m *ActivateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActivateDeviceRequest.Marshal(b, m, deterministic)
}
func (m *ActivateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActivateDeviceRequest.Merge(m, src)
}
func (m *ActivateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_ActivateDeviceRequest.Size(m)
}
func (m *ActivateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ActivateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ActivateDeviceRequest proto.InternalMessageInfo

func (m *ActivateDeviceRequest) GetDeviceActivation() *DeviceActivation {
	if m != nil {
		return m.DeviceActivation
	}
	return nil
}

type DeactivateDeviceRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeactivateDeviceRequest) Reset()         { *m = DeactivateDeviceRequest{} }
func (m *DeactivateDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*DeactivateDeviceRequest) ProtoMessage()    {}
func (*DeactivateDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{17}
}

func (m *DeactivateDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeactivateDeviceRequest.Unmarshal(m, b)
}
func (m *DeactivateDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeactivateDeviceRequest.Marshal(b, m, deterministic)
}
func (m *DeactivateDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeactivateDeviceRequest.Merge(m, src)
}
func (m *DeactivateDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_DeactivateDeviceRequest.Size(m)
}
func (m *DeactivateDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeactivateDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeactivateDeviceRequest proto.InternalMessageInfo

func (m *DeactivateDeviceRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type GetDeviceActivationRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDeviceActivationRequest) Reset()         { *m = GetDeviceActivationRequest{} }
func (m *GetDeviceActivationRequest) String() string { return proto.CompactTextString(m) }
func (*GetDeviceActivationRequest) ProtoMessage()    {}
func (*GetDeviceActivationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{18}
}

func (m *GetDeviceActivationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceActivationRequest.Unmarshal(m, b)
}
func (m *GetDeviceActivationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceActivationRequest.Marshal(b, m, deterministic)
}
func (m *GetDeviceActivationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceActivationRequest.Merge(m, src)
}
func (m *GetDeviceActivationRequest) XXX_Size() int {
	return xxx_messageInfo_GetDeviceActivationRequest.Size(m)
}
func (m *GetDeviceActivationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceActivationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceActivationRequest proto.InternalMessageInfo

func (m *GetDeviceActivationRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type GetDeviceActivationResponse struct {
	// Device-activation object.
	DeviceActivation     *DeviceActivation `protobuf:"bytes,1,opt,name=device_activation,json=deviceActivation,proto3" json:"device_activation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GetDeviceActivationResponse) Reset()         { *m = GetDeviceActivationResponse{} }
func (m *GetDeviceActivationResponse) String() string { return proto.CompactTextString(m) }
func (*GetDeviceActivationResponse) ProtoMessage()    {}
func (*GetDeviceActivationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{19}
}

func (m *GetDeviceActivationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDeviceActivationResponse.Unmarshal(m, b)
}
func (m *GetDeviceActivationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDeviceActivationResponse.Marshal(b, m, deterministic)
}
func (m *GetDeviceActivationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDeviceActivationResponse.Merge(m, src)
}
func (m *GetDeviceActivationResponse) XXX_Size() int {
	return xxx_messageInfo_GetDeviceActivationResponse.Size(m)
}
func (m *GetDeviceActivationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDeviceActivationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDeviceActivationResponse proto.InternalMessageInfo

func (m *GetDeviceActivationResponse) GetDeviceActivation() *DeviceActivation {
	if m != nil {
		return m.DeviceActivation
	}
	return nil
}

type GetRandomDevAddrRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRandomDevAddrRequest) Reset()         { *m = GetRandomDevAddrRequest{} }
func (m *GetRandomDevAddrRequest) String() string { return proto.CompactTextString(m) }
func (*GetRandomDevAddrRequest) ProtoMessage()    {}
func (*GetRandomDevAddrRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{20}
}

func (m *GetRandomDevAddrRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRandomDevAddrRequest.Unmarshal(m, b)
}
func (m *GetRandomDevAddrRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRandomDevAddrRequest.Marshal(b, m, deterministic)
}
func (m *GetRandomDevAddrRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRandomDevAddrRequest.Merge(m, src)
}
func (m *GetRandomDevAddrRequest) XXX_Size() int {
	return xxx_messageInfo_GetRandomDevAddrRequest.Size(m)
}
func (m *GetRandomDevAddrRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRandomDevAddrRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRandomDevAddrRequest proto.InternalMessageInfo

func (m *GetRandomDevAddrRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type GetRandomDevAddrResponse struct {
	// Device address (HEX encoded).
	DevAddr              string   `protobuf:"bytes,1,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRandomDevAddrResponse) Reset()         { *m = GetRandomDevAddrResponse{} }
func (m *GetRandomDevAddrResponse) String() string { return proto.CompactTextString(m) }
func (*GetRandomDevAddrResponse) ProtoMessage()    {}
func (*GetRandomDevAddrResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{21}
}

func (m *GetRandomDevAddrResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRandomDevAddrResponse.Unmarshal(m, b)
}
func (m *GetRandomDevAddrResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRandomDevAddrResponse.Marshal(b, m, deterministic)
}
func (m *GetRandomDevAddrResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRandomDevAddrResponse.Merge(m, src)
}
func (m *GetRandomDevAddrResponse) XXX_Size() int {
	return xxx_messageInfo_GetRandomDevAddrResponse.Size(m)
}
func (m *GetRandomDevAddrResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRandomDevAddrResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetRandomDevAddrResponse proto.InternalMessageInfo

func (m *GetRandomDevAddrResponse) GetDevAddr() string {
	if m != nil {
		return m.DevAddr
	}
	return ""
}

type StreamDeviceFrameLogsRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamDeviceFrameLogsRequest) Reset()         { *m = StreamDeviceFrameLogsRequest{} }
func (m *StreamDeviceFrameLogsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamDeviceFrameLogsRequest) ProtoMessage()    {}
func (*StreamDeviceFrameLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{22}
}

func (m *StreamDeviceFrameLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamDeviceFrameLogsRequest.Unmarshal(m, b)
}
func (m *StreamDeviceFrameLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamDeviceFrameLogsRequest.Marshal(b, m, deterministic)
}
func (m *StreamDeviceFrameLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamDeviceFrameLogsRequest.Merge(m, src)
}
func (m *StreamDeviceFrameLogsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamDeviceFrameLogsRequest.Size(m)
}
func (m *StreamDeviceFrameLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamDeviceFrameLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamDeviceFrameLogsRequest proto.InternalMessageInfo

func (m *StreamDeviceFrameLogsRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type StreamDeviceFrameLogsResponse struct {
	// Types that are valid to be assigned to Frame:
	//	*StreamDeviceFrameLogsResponse_UplinkFrame
	//	*StreamDeviceFrameLogsResponse_DownlinkFrame
	Frame                isStreamDeviceFrameLogsResponse_Frame `protobuf_oneof:"frame"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *StreamDeviceFrameLogsResponse) Reset()         { *m = StreamDeviceFrameLogsResponse{} }
func (m *StreamDeviceFrameLogsResponse) String() string { return proto.CompactTextString(m) }
func (*StreamDeviceFrameLogsResponse) ProtoMessage()    {}
func (*StreamDeviceFrameLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{23}
}

func (m *StreamDeviceFrameLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamDeviceFrameLogsResponse.Unmarshal(m, b)
}
func (m *StreamDeviceFrameLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamDeviceFrameLogsResponse.Marshal(b, m, deterministic)
}
func (m *StreamDeviceFrameLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamDeviceFrameLogsResponse.Merge(m, src)
}
func (m *StreamDeviceFrameLogsResponse) XXX_Size() int {
	return xxx_messageInfo_StreamDeviceFrameLogsResponse.Size(m)
}
func (m *StreamDeviceFrameLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamDeviceFrameLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamDeviceFrameLogsResponse proto.InternalMessageInfo

type isStreamDeviceFrameLogsResponse_Frame interface {
	isStreamDeviceFrameLogsResponse_Frame()
}

type StreamDeviceFrameLogsResponse_UplinkFrame struct {
	UplinkFrame *UplinkFrameLog `protobuf:"bytes,1,opt,name=uplink_frame,json=uplinkFrame,proto3,oneof"`
}

type StreamDeviceFrameLogsResponse_DownlinkFrame struct {
	DownlinkFrame *DownlinkFrameLog `protobuf:"bytes,2,opt,name=downlink_frame,json=downlinkFrame,proto3,oneof"`
}

func (*StreamDeviceFrameLogsResponse_UplinkFrame) isStreamDeviceFrameLogsResponse_Frame() {}

func (*StreamDeviceFrameLogsResponse_DownlinkFrame) isStreamDeviceFrameLogsResponse_Frame() {}

func (m *StreamDeviceFrameLogsResponse) GetFrame() isStreamDeviceFrameLogsResponse_Frame {
	if m != nil {
		return m.Frame
	}
	return nil
}

func (m *StreamDeviceFrameLogsResponse) GetUplinkFrame() *UplinkFrameLog {
	if x, ok := m.GetFrame().(*StreamDeviceFrameLogsResponse_UplinkFrame); ok {
		return x.UplinkFrame
	}
	return nil
}

func (m *StreamDeviceFrameLogsResponse) GetDownlinkFrame() *DownlinkFrameLog {
	if x, ok := m.GetFrame().(*StreamDeviceFrameLogsResponse_DownlinkFrame); ok {
		return x.DownlinkFrame
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StreamDeviceFrameLogsResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StreamDeviceFrameLogsResponse_UplinkFrame)(nil),
		(*StreamDeviceFrameLogsResponse_DownlinkFrame)(nil),
	}
}

type StreamDeviceEventLogsRequest struct {
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamDeviceEventLogsRequest) Reset()         { *m = StreamDeviceEventLogsRequest{} }
func (m *StreamDeviceEventLogsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamDeviceEventLogsRequest) ProtoMessage()    {}
func (*StreamDeviceEventLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{24}
}

func (m *StreamDeviceEventLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamDeviceEventLogsRequest.Unmarshal(m, b)
}
func (m *StreamDeviceEventLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamDeviceEventLogsRequest.Marshal(b, m, deterministic)
}
func (m *StreamDeviceEventLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamDeviceEventLogsRequest.Merge(m, src)
}
func (m *StreamDeviceEventLogsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamDeviceEventLogsRequest.Size(m)
}
func (m *StreamDeviceEventLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamDeviceEventLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamDeviceEventLogsRequest proto.InternalMessageInfo

func (m *StreamDeviceEventLogsRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type StreamDeviceEventLogsResponse struct {
	// The event type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The event payload in JSON encoding.
	PayloadJson          string   `protobuf:"bytes,2,opt,name=payload_json,json=payloadJSON,proto3" json:"payload_json,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamDeviceEventLogsResponse) Reset()         { *m = StreamDeviceEventLogsResponse{} }
func (m *StreamDeviceEventLogsResponse) String() string { return proto.CompactTextString(m) }
func (*StreamDeviceEventLogsResponse) ProtoMessage()    {}
func (*StreamDeviceEventLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_57ec3c2ed36f7cf9, []int{25}
}

func (m *StreamDeviceEventLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamDeviceEventLogsResponse.Unmarshal(m, b)
}
func (m *StreamDeviceEventLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamDeviceEventLogsResponse.Marshal(b, m, deterministic)
}
func (m *StreamDeviceEventLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamDeviceEventLogsResponse.Merge(m, src)
}
func (m *StreamDeviceEventLogsResponse) XXX_Size() int {
	return xxx_messageInfo_StreamDeviceEventLogsResponse.Size(m)
}
func (m *StreamDeviceEventLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamDeviceEventLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamDeviceEventLogsResponse proto.InternalMessageInfo

func (m *StreamDeviceEventLogsResponse) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *StreamDeviceEventLogsResponse) GetPayloadJson() string {
	if m != nil {
		return m.PayloadJson
	}
	return ""
}

func init() {
	proto.RegisterType((*Device)(nil), "api.Device")
	proto.RegisterMapType((map[string]string)(nil), "api.Device.TagsEntry")
	proto.RegisterMapType((map[string]string)(nil), "api.Device.VariablesEntry")
	proto.RegisterType((*DeviceListItem)(nil), "api.DeviceListItem")
	proto.RegisterType((*DeviceKeys)(nil), "api.DeviceKeys")
	proto.RegisterType((*CreateDeviceRequest)(nil), "api.CreateDeviceRequest")
	proto.RegisterType((*GetDeviceRequest)(nil), "api.GetDeviceRequest")
	proto.RegisterType((*GetDeviceResponse)(nil), "api.GetDeviceResponse")
	proto.RegisterType((*ListDeviceRequest)(nil), "api.ListDeviceRequest")
	proto.RegisterMapType((map[string]string)(nil), "api.ListDeviceRequest.TagsEntry")
	proto.RegisterType((*ListDeviceResponse)(nil), "api.ListDeviceResponse")
	proto.RegisterType((*DeleteDeviceRequest)(nil), "api.DeleteDeviceRequest")
	proto.RegisterType((*UpdateDeviceRequest)(nil), "api.UpdateDeviceRequest")
	proto.RegisterType((*CreateDeviceKeysRequest)(nil), "api.CreateDeviceKeysRequest")
	proto.RegisterType((*GetDeviceKeysRequest)(nil), "api.GetDeviceKeysRequest")
	proto.RegisterType((*GetDeviceKeysResponse)(nil), "api.GetDeviceKeysResponse")
	proto.RegisterType((*UpdateDeviceKeysRequest)(nil), "api.UpdateDeviceKeysRequest")
	proto.RegisterType((*DeleteDeviceKeysRequest)(nil), "api.DeleteDeviceKeysRequest")
	proto.RegisterType((*DeviceActivation)(nil), "api.DeviceActivation")
	proto.RegisterType((*ActivateDeviceRequest)(nil), "api.ActivateDeviceRequest")
	proto.RegisterType((*DeactivateDeviceRequest)(nil), "api.DeactivateDeviceRequest")
	proto.RegisterType((*GetDeviceActivationRequest)(nil), "api.GetDeviceActivationRequest")
	proto.RegisterType((*GetDeviceActivationResponse)(nil), "api.GetDeviceActivationResponse")
	proto.RegisterType((*GetRandomDevAddrRequest)(nil), "api.GetRandomDevAddrRequest")
	proto.RegisterType((*GetRandomDevAddrResponse)(nil), "api.GetRandomDevAddrResponse")
	proto.RegisterType((*StreamDeviceFrameLogsRequest)(nil), "api.StreamDeviceFrameLogsRequest")
	proto.RegisterType((*StreamDeviceFrameLogsResponse)(nil), "api.StreamDeviceFrameLogsResponse")
	proto.RegisterType((*StreamDeviceEventLogsRequest)(nil), "api.StreamDeviceEventLogsRequest")
	proto.RegisterType((*StreamDeviceEventLogsResponse)(nil), "api.StreamDeviceEventLogsResponse")
}

func init() { proto.RegisterFile("as/external/api/device.proto", fileDescriptor_57ec3c2ed36f7cf9) }

var fileDescriptor_57ec3c2ed36f7cf9 = []byte{
	// 1751 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0x4f, 0x73, 0x1b, 0x49,
	0x15, 0x67, 0x2c, 0x5b, 0xb6, 0x9e, 0x2c, 0xc7, 0x6e, 0xff, 0x9b, 0x9d, 0xc4, 0xb1, 0x32, 0x66,
	0x2b, 0x8e, 0x37, 0x2b, 0x05, 0x2f, 0x90, 0x90, 0x0a, 0x54, 0x39, 0xb6, 0xd7, 0x98, 0x78, 0xc3,
	0xd6, 0x28, 0xde, 0xc3, 0x72, 0x98, 0x6a, 0xcf, 0xb4, 0x94, 0x41, 0xa3, 0x9e, 0x61, 0xa6, 0x47,
	0x46, 0x05, 0x5b, 0x05, 0x7b, 0xe4, 0xca, 0x37, 0xe0, 0xce, 0x27, 0xe1, 0xc8, 0x9d, 0x13, 0x17,
	0xbe, 0x05, 0xd5, 0x7f, 0x24, 0xb5, 0xa4, 0x99, 0xd8, 0x5e, 0xb8, 0xec, 0xc9, 0x9a, 0xf7, 0x7e,
	0xef, 0xff, 0xeb, 0xf7, 0xba, 0x0d, 0x0f, 0x70, 0xda, 0x24, 0xbf, 0x67, 0x24, 0xa1, 0x38, 0x6c,
	0xe2, 0x38, 0x68, 0xfa, 0xa4, 0x1f, 0x78, 0xa4, 0x11, 0x27, 0x11, 0x8b, 0x50, 0x09, 0xc7, 0x81,
	0xf5, 0xa0, 0x13, 0x45, 0x9d, 0x90, 0x08, 0x2e, 0xa6, 0x34, 0x62, 0x98, 0x05, 0x11, 0x4d, 0x25,
	0xc4, 0xda, 0x55, 0x5c, 0xf1, 0x75, 0x95, 0xb5, 0x9b, 0x2c, 0xe8, 0x91, 0x94, 0xe1, 0x5e, 0xac,
	0x00, 0xf7, 0xa7, 0x01, 0xa4, 0x17, 0xb3, 0x81, 0x62, 0xae, 0x7b, 0x51, 0xaf, 0x17, 0xd1, 0xa6,
	0xfc, 0xa3, 0x88, 0x0f, 0xa7, 0x7d, 0x6a, 0x27, 0xb8, 0x47, 0x2e, 0xa2, 0x8e, 0xe4, 0xdb, 0xff,
	0x2a, 0x41, 0xf9, 0x44, 0xb8, 0x89, 0xb6, 0x61, 0xd1, 0x27, 0x7d, 0x97, 0x64, 0x81, 0x69, 0xd4,
	0x8d, 0xfd, 0x8a, 0x53, 0xf6, 0x49, 0xff, 0xf4, 0xf2, 0x1c, 0x21, 0x98, 0xa7, 0xb8, 0x47, 0xcc,
	0x39, 0x41, 0x15, 0xbf, 0xd1, 0xc7, 0xb0, 0x82, 0xe3, 0x38, 0x0c, 0x3c, 0x11, 0x80, 0x1b, 0xf8,
	0x66, 0xa9, 0x6e, 0xec, 0x97, 0x9c, 0x9a, 0x46, 0x3d, 0x3f, 0x41, 0x75, 0xa8, 0xfa, 0x24, 0xf5,
	0x92, 0x20, 0xe6, 0x04, 0x73, 0x5e, 0x68, 0xd0, 0x49, 0xe8, 0x00, 0xd6, 0x64, 0x9a, 0xdc, 0x38,
	0x89, 0xda, 0x41, 0x48, 0xb8, 0xae, 0x05, 0x81, 0xbb, 0x27, 0x19, 0x5f, 0x4a, 0xfa, 0xf9, 0x09,
	0x7a, 0x0c, 0xab, 0x69, 0x37, 0x88, 0xdd, 0xb6, 0xeb, 0x51, 0xe6, 0x7a, 0xef, 0x89, 0xd7, 0x35,
	0xcb, 0x75, 0x63, 0x7f, 0xc9, 0xa9, 0x71, 0xfa, 0xe7, 0xc7, 0x94, 0x1d, 0x73, 0x22, 0xfa, 0x14,
	0x50, 0x42, 0xda, 0x24, 0x21, 0xd4, 0x23, 0x2e, 0x0e, 0x59, 0xc0, 0x32, 0x9f, 0x98, 0x8b, 0x75,
	0x63, 0xdf, 0x70, 0xd6, 0x46, 0x9c, 0x23, 0xc5, 0x40, 0x2f, 0xa0, 0xd2, 0xc7, 0x49, 0x80, 0xaf,
	0x42, 0x92, 0x9a, 0x4b, 0xf5, 0xd2, 0x7e, 0xf5, 0xd0, 0x6a, 0xe0, 0x38, 0x68, 0xc8, 0xcc, 0x34,
	0xbe, 0x1a, 0x32, 0x4f, 0x29, 0x4b, 0x06, 0xce, 0x18, 0x8c, 0x9e, 0xc0, 0x3c, 0xc3, 0x9d, 0xd4,
	0xac, 0x08, 0xa1, 0x4d, 0x5d, 0xe8, 0x1d, 0xee, 0x28, 0xbc, 0x80, 0x58, 0xaf, 0x60, 0x65, 0x52,
	0x0f, 0x5a, 0x85, 0x52, 0x97, 0x0c, 0x54, 0xb2, 0xf9, 0x4f, 0xb4, 0x01, 0x0b, 0x7d, 0x1c, 0x66,
	0xc3, 0x54, 0xcb, 0x8f, 0x97, 0x73, 0x2f, 0x0c, 0xeb, 0x39, 0x54, 0x46, 0x0a, 0xef, 0x22, 0x68,
	0xff, 0x67, 0x1e, 0x56, 0xa4, 0x47, 0x17, 0x41, 0xca, 0xce, 0x19, 0xe9, 0x7d, 0x0f, 0x0a, 0xdd,
	0x80, 0xf5, 0x29, 0xac, 0xf0, 0xab, 0x2c, 0xd0, 0x6b, 0x13, 0xe8, 0xb7, 0xdc, 0xc9, 0x43, 0xd8,
	0x54, 0xf8, 0x94, 0x61, 0x96, 0xa5, 0xee, 0x15, 0x66, 0x8c, 0x24, 0x03, 0x51, 0xf2, 0x9a, 0xa3,
	0x94, 0xb5, 0x04, 0xef, 0xb5, 0x64, 0xa1, 0x67, 0xb0, 0x31, 0x29, 0xd3, 0xc3, 0x49, 0x27, 0xa0,
	0xe6, 0x52, 0xdd, 0xd8, 0x5f, 0x70, 0x90, 0x2e, 0xf2, 0x85, 0xe0, 0xa0, 0x0b, 0xd8, 0x9b, 0x94,
	0x18, 0x1e, 0x2c, 0x37, 0x8e, 0xae, 0x49, 0xe2, 0xa6, 0x51, 0x96, 0x78, 0xc4, 0x04, 0xd1, 0x91,
	0xbb, 0xba, 0x82, 0x53, 0x05, 0xfc, 0x92, 0xe3, 0x5a, 0x02, 0x86, 0xde, 0xc1, 0xe3, 0x5c, 0x9f,
	0xdd, 0x90, 0xf4, 0x49, 0xe8, 0x66, 0x14, 0xf7, 0x71, 0x10, 0xf2, 0x76, 0x31, 0xab, 0x42, 0xe3,
	0x5e, 0x4e, 0x14, 0x17, 0x1c, 0x7b, 0x39, 0x86, 0xa2, 0x9f, 0xc3, 0xfd, 0x0f, 0x68, 0x35, 0x97,
	0xeb, 0xc6, 0xfe, 0x9c, 0x63, 0x16, 0x69, 0x42, 0xaf, 0x60, 0x39, 0xc4, 0x29, 0x73, 0x53, 0x42,
	0xa8, 0x8b, 0x99, 0x59, 0xa9, 0x1b, 0xe2, 0x30, 0xc8, 0xb9, 0xd3, 0x18, 0xce, 0x9d, 0xc6, 0xbb,
	0xe1, 0x60, 0x72, 0x80, 0xe3, 0x5b, 0x84, 0xd0, 0x23, 0x66, 0x5f, 0x03, 0xc8, 0x56, 0x7b, 0x43,
	0x06, 0x69, 0x71, 0x9b, 0x6d, 0xc3, 0x22, 0xbd, 0xee, 0xba, 0xbc, 0x85, 0x65, 0xa7, 0x95, 0xe9,
	0x75, 0xf7, 0x0d, 0x19, 0x70, 0x06, 0x8e, 0x63, 0xc1, 0x28, 0x49, 0x06, 0x8e, 0x63, 0xce, 0x78,
	0x08, 0xd5, 0x0e, 0x77, 0x48, 0x31, 0x65, 0x77, 0x55, 0x3a, 0x84, 0x1e, 0x09, 0xbe, 0xfd, 0x12,
	0xd6, 0x8f, 0x13, 0x82, 0x19, 0x91, 0xe6, 0x1d, 0xf2, 0xbb, 0x8c, 0xa4, 0x0c, 0xed, 0x41, 0x59,
	0x46, 0x2a, 0x1c, 0xa8, 0x1e, 0x56, 0xb5, 0xf3, 0xe9, 0x28, 0x96, 0xfd, 0x09, 0xac, 0x9e, 0x11,
	0x36, 0x29, 0x58, 0xe4, 0xba, 0xfd, 0x97, 0x39, 0x58, 0xd3, 0xd0, 0x69, 0x1c, 0xd1, 0x94, 0xdc,
	0xca, 0xce, 0x4c, 0x6a, 0x17, 0xee, 0x92, 0xda, 0xe2, 0x0e, 0x2f, 0xdf, 0xbd, 0xc3, 0x37, 0x0a,
	0x3b, 0xfc, 0x29, 0x2c, 0x85, 0x91, 0x3c, 0xd3, 0xe6, 0xa6, 0xf0, 0x6f, 0xb5, 0xa1, 0xd6, 0xc9,
	0x85, 0xa2, 0x3b, 0x23, 0x84, 0xfd, 0x8f, 0x39, 0x58, 0xe3, 0x43, 0x65, 0x32, 0x77, 0x1b, 0xb0,
	0x10, 0x06, 0xbd, 0x80, 0x89, 0x5c, 0x94, 0x1c, 0xf9, 0x81, 0xb6, 0xa0, 0x1c, 0xb5, 0xdb, 0x29,
	0x61, 0xa2, 0xe4, 0x25, 0x47, 0x7d, 0xdd, 0x76, 0xbc, 0x6c, 0x41, 0x39, 0x25, 0x38, 0xf1, 0xde,
	0xab, 0xda, 0xab, 0x2f, 0xf4, 0x14, 0x50, 0x2f, 0x0b, 0x59, 0xe0, 0xf1, 0xcc, 0x76, 0x92, 0x28,
	0x8b, 0xc7, 0x53, 0x65, 0x75, 0xc4, 0x39, 0xe3, 0x8c, 0xf3, 0x13, 0x8e, 0x4e, 0x49, 0x32, 0x3d,
	0x83, 0xe4, 0x54, 0x59, 0x55, 0x9c, 0xf1, 0x10, 0xfa, 0xb1, 0x9a, 0xed, 0x8b, 0x62, 0xb6, 0xd7,
	0x45, 0x4d, 0x67, 0xc2, 0x9d, 0x19, 0xf3, 0xdf, 0x79, 0x50, 0x5f, 0x01, 0xd2, 0xb5, 0xab, 0xd6,
	0xda, 0x85, 0x2a, 0x8b, 0x18, 0x0e, 0x5d, 0x2f, 0xca, 0xe8, 0x30, 0xa7, 0x20, 0x48, 0xc7, 0x9c,
	0x82, 0x3e, 0x81, 0x72, 0x42, 0xd2, 0x2c, 0xe4, 0x89, 0xe5, 0x7e, 0xae, 0x6b, 0xbd, 0x37, 0x9c,
	0xf8, 0x8e, 0x82, 0xd8, 0x0d, 0x58, 0x3f, 0x21, 0x21, 0x99, 0x3e, 0x27, 0x85, 0xed, 0xfe, 0x12,
	0xd6, 0x2f, 0x63, 0xff, 0xbb, 0x9d, 0xab, 0x37, 0xb0, 0xad, 0x9f, 0x49, 0x3e, 0x12, 0x86, 0xf2,
	0xcf, 0xf8, 0xb2, 0x10, 0x65, 0xe8, 0x92, 0x41, 0xaa, 0x94, 0xdc, 0xd3, 0x94, 0x08, 0x30, 0xf8,
	0xa3, 0xdf, 0x76, 0x13, 0x36, 0x46, 0xc7, 0x4e, 0xd7, 0x54, 0xe8, 0xf9, 0x39, 0x6c, 0x4e, 0x09,
	0xa8, 0x84, 0xde, 0xdd, 0xf6, 0x1b, 0xd8, 0xd6, 0x93, 0xf0, 0xbf, 0x05, 0x72, 0x08, 0xdb, 0x7a,
	0x05, 0x6e, 0x15, 0xcb, 0xdf, 0xe7, 0x60, 0x55, 0xc2, 0x8f, 0x3c, 0x16, 0xf4, 0xc5, 0x99, 0x28,
	0x9e, 0xae, 0x1f, 0xc1, 0x12, 0x67, 0x60, 0xdf, 0x4f, 0x54, 0x93, 0x71, 0xe0, 0x91, 0xef, 0x27,
	0xc8, 0x82, 0x0a, 0x1f, 0xa1, 0xa9, 0x36, 0x61, 0xf9, 0xc0, 0x6d, 0xf1, 0x11, 0xfb, 0x08, 0x6a,
	0x7c, 0x28, 0xa7, 0x2e, 0xa1, 0x9e, 0x36, 0x64, 0x81, 0x5e, 0x77, 0x5b, 0xa7, 0xd4, 0xe3, 0x90,
	0x1f, 0xc2, 0xbd, 0xd4, 0x95, 0xa0, 0x80, 0x32, 0x01, 0x5a, 0x92, 0x7b, 0x3e, 0x7d, 0x7b, 0xdd,
	0x6d, 0x9d, 0x53, 0xa6, 0x50, 0xed, 0x29, 0x54, 0x45, 0xa2, 0xda, 0x1a, 0xca, 0x84, 0x25, 0x79,
	0x8b, 0xcb, 0x62, 0x71, 0x5c, 0x6b, 0x4e, 0xb9, 0x7d, 0x4c, 0xd9, 0x65, 0x8c, 0x76, 0x61, 0x99,
	0xaa, 0x1b, 0x9e, 0x1f, 0x5d, 0x53, 0x35, 0xe0, 0x2a, 0x94, 0xdf, 0xee, 0x4e, 0xa2, 0x6b, 0xca,
	0x01, 0x58, 0x07, 0x80, 0x04, 0xe0, 0x21, 0xc0, 0xfe, 0x0d, 0x6c, 0xaa, 0x44, 0x4d, 0xf5, 0xed,
	0xeb, 0xd1, 0x15, 0x04, 0x8f, 0x12, 0xa9, 0x8a, 0xa6, 0x5f, 0xdd, 0xc6, 0x59, 0x76, 0x56, 0xfd,
	0x29, 0x8a, 0x2c, 0x20, 0xce, 0x55, 0x5f, 0x58, 0xc0, 0x9f, 0x80, 0x35, 0x6a, 0x46, 0x4d, 0xf9,
	0x4d, 0x62, 0x18, 0xee, 0xe7, 0x8a, 0xa9, 0x4e, 0xfe, 0x3f, 0x45, 0x73, 0x46, 0x98, 0x83, 0xa9,
	0x1f, 0xf5, 0x4e, 0x64, 0x97, 0xdc, 0x22, 0x1a, 0x73, 0x56, 0x46, 0xf9, 0xa4, 0x37, 0x9f, 0x31,
	0xd1, 0x7c, 0xf6, 0x73, 0x78, 0xd0, 0x62, 0x09, 0xc1, 0x3d, 0xe9, 0xd6, 0xe7, 0xea, 0x1d, 0x72,
	0x73, 0xfb, 0xff, 0xcd, 0x80, 0x9d, 0x02, 0x49, 0x65, 0xf5, 0x05, 0x2c, 0x67, 0x71, 0x18, 0xd0,
	0xae, 0x2b, 0x5e, 0x37, 0x2a, 0x09, 0x72, 0x12, 0x5e, 0x0a, 0xc6, 0x50, 0xe6, 0x97, 0x3f, 0x70,
	0xaa, 0xd9, 0x98, 0x82, 0x7e, 0x01, 0x2b, 0xbc, 0x87, 0x34, 0xd9, 0x39, 0x3d, 0x81, 0x8a, 0xa5,
	0x49, 0xd7, 0x7c, 0x9d, 0xf6, 0x7a, 0x11, 0x16, 0x84, 0xd8, 0x74, 0x74, 0xa7, 0x7d, 0x42, 0xd9,
	0xad, 0xa2, 0xfb, 0x6a, 0x32, 0x38, 0x4d, 0x50, 0x05, 0x87, 0x60, 0x9e, 0x0d, 0x62, 0xa2, 0xc4,
	0xc4, 0x6f, 0xf4, 0x08, 0x96, 0x63, 0x3c, 0x08, 0x23, 0xec, 0xbb, 0xbf, 0x4d, 0x23, 0xaa, 0xce,
	0x79, 0x55, 0xd1, 0x7e, 0xd5, 0xfa, 0xf5, 0xdb, 0xc3, 0x6f, 0x6b, 0x50, 0x93, 0x2a, 0x5b, 0x72,
	0xb1, 0xa1, 0x16, 0x94, 0xe5, 0x40, 0x46, 0xa6, 0x88, 0x2e, 0xe7, 0xc6, 0x64, 0x6d, 0xcd, 0x5c,
	0x47, 0x4e, 0xf9, 0x0b, 0xd3, 0xde, 0xfe, 0xf6, 0x9f, 0xff, 0xfe, 0xeb, 0xdc, 0x9a, 0xbd, 0xac,
	0xbd, 0x6b, 0xd3, 0x97, 0xc6, 0x01, 0x7a, 0x07, 0xa5, 0x33, 0xc2, 0x90, 0xcc, 0xd7, 0xf4, 0x3d,
	0xca, 0xda, 0x9a, 0x26, 0xcb, 0x98, 0xec, 0x87, 0x42, 0x9d, 0x89, 0xb6, 0x74, 0x75, 0xcd, 0x3f,
	0xa8, 0x0c, 0x7d, 0x83, 0xbe, 0x80, 0x79, 0xbe, 0xbb, 0xd0, 0x56, 0xfe, 0xd2, 0xb5, 0xb6, 0x67,
	0xe8, 0x4a, 0xf1, 0x86, 0x50, 0xbc, 0x82, 0x26, 0xfc, 0x44, 0x5f, 0xf3, 0x37, 0x2e, 0x1f, 0xba,
	0x2a, 0xf2, 0x9c, 0x1d, 0x58, 0x18, 0xb9, 0x72, 0xf5, 0xa0, 0xc8, 0x55, 0x1f, 0xca, 0x72, 0x3b,
	0x28, 0xdd, 0x39, 0xfb, 0xb2, 0x50, 0xf7, 0xbe, 0xd0, 0x6d, 0x5b, 0x3b, 0x33, 0xba, 0xf9, 0x03,
	0x72, 0x68, 0x82, 0xa7, 0xb9, 0x0f, 0x20, 0xcb, 0x25, 0x6e, 0xd6, 0x0f, 0x66, 0xea, 0xa7, 0xed,
	0x91, 0x42, 0x6b, 0x87, 0xc2, 0xda, 0x53, 0xfb, 0x71, 0x9e, 0x35, 0xb1, 0xc0, 0x46, 0x26, 0x9b,
	0xfc, 0x8b, 0xdb, 0x25, 0xb0, 0x78, 0x46, 0x98, 0x30, 0xfa, 0xd1, 0x64, 0x2d, 0x75, 0x8b, 0x56,
	0x1e, 0x4b, 0x55, 0x64, 0x4f, 0x58, 0xdd, 0x41, 0xf7, 0xf3, 0xf3, 0x27, 0x2c, 0xf1, 0xf0, 0x64,
	0xde, 0xb4, 0xf0, 0x0a, 0x76, 0xee, 0x4d, 0xe1, 0x59, 0x77, 0x09, 0xaf, 0xc3, 0x1f, 0x2c, 0xbc,
	0x17, 0x34, 0xbb, 0x05, 0xeb, 0xb9, 0xd0, 0xae, 0x0a, 0xf0, 0xe0, 0x83, 0x01, 0xfe, 0x11, 0x96,
	0x86, 0x2b, 0x09, 0xc9, 0x6c, 0xe5, 0x6e, 0xa8, 0x42, 0x23, 0xaf, 0x84, 0x91, 0x9f, 0xda, 0x3f,
	0xca, 0x0d, 0x6e, 0x3c, 0xff, 0xc7, 0x21, 0x0e, 0x57, 0x14, 0x0f, 0xb3, 0xc7, 0xc3, 0x1c, 0x12,
	0x46, 0x61, 0xe2, 0x3b, 0x79, 0xf0, 0x44, 0x78, 0xb0, 0x77, 0xf0, 0xa8, 0x20, 0xcc, 0xb1, 0x0f,
	0xe8, 0x1b, 0xa8, 0x9d, 0x11, 0xa6, 0xdd, 0x55, 0x76, 0x27, 0xfb, 0x63, 0x66, 0x05, 0x5a, 0xf5,
	0x62, 0x80, 0x6a, 0x23, 0x65, 0x1e, 0xdd, 0xc2, 0xfc, 0x9f, 0x0c, 0xf1, 0xa2, 0x9b, 0x58, 0x50,
	0x2a, 0xe8, 0x82, 0x5d, 0x67, 0xed, 0x14, 0x70, 0x95, 0xf1, 0xa6, 0x30, 0xfe, 0x24, 0xe7, 0xe4,
	0x48, 0xe3, 0x9d, 0x69, 0x6b, 0x7f, 0x36, 0xe0, 0x9e, 0x9c, 0xea, 0xa3, 0x65, 0x85, 0x1e, 0x09,
	0x1b, 0x1f, 0x5a, 0x81, 0x96, 0xfd, 0x21, 0x88, 0xf2, 0xe5, 0x63, 0xe1, 0xcb, 0x2e, 0xda, 0x29,
	0xf0, 0x45, 0xac, 0xa3, 0xf4, 0x99, 0xa1, 0xf9, 0x30, 0xda, 0x29, 0x39, 0x3e, 0x4c, 0x2f, 0xaa,
	0x1c, 0x1f, 0x66, 0x56, 0xd2, 0x8d, 0x3e, 0x10, 0x2e, 0x91, 0x3e, 0x33, 0x5e, 0xff, 0xec, 0xeb,
	0xe7, 0x9d, 0x80, 0xbd, 0xcf, 0xae, 0xf8, 0x2b, 0xb2, 0x79, 0x95, 0x44, 0x1e, 0xc6, 0x49, 0xd3,
	0x7b, 0x1f, 0x24, 0x71, 0xca, 0xb0, 0xd7, 0xfd, 0x94, 0xcb, 0x77, 0xa2, 0x66, 0xff, 0xb3, 0xe6,
	0xd4, 0xff, 0x29, 0xaf, 0xca, 0xa2, 0xff, 0x3e, 0xfb, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x16,
	0x7c, 0xad, 0xf6, 0x55, 0x15, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DeviceServiceClient is the client API for DeviceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DeviceServiceClient interface {
	// Create creates the given device.
	Create(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Get returns the device matching the given DevEUI.
	Get(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*GetDeviceResponse, error)
	// List returns the available devices.
	List(ctx context.Context, in *ListDeviceRequest, opts ...grpc.CallOption) (*ListDeviceResponse, error)
	// Delete deletes the device matching the given DevEUI.
	Delete(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Update updates the device matching the given DevEUI.
	Update(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// CreateKeys creates the given device-keys.
	CreateKeys(ctx context.Context, in *CreateDeviceKeysRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetKeys returns the device-keys for the given DevEUI.
	GetKeys(ctx context.Context, in *GetDeviceKeysRequest, opts ...grpc.CallOption) (*GetDeviceKeysResponse, error)
	// UpdateKeys updates the device-keys.
	UpdateKeys(ctx context.Context, in *UpdateDeviceKeysRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// DeleteKeys deletes the device-keys for the given DevEUI.
	DeleteKeys(ctx context.Context, in *DeleteDeviceKeysRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Activate (re)activates the device (only when ABP is set to true).
	Activate(ctx context.Context, in *ActivateDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Deactivate de-activates the device.
	Deactivate(ctx context.Context, in *DeactivateDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// GetActivation returns the current activation details of the device (OTAA and ABP).
	GetActivation(ctx context.Context, in *GetDeviceActivationRequest, opts ...grpc.CallOption) (*GetDeviceActivationResponse, error)
	// GetRandomDevAddr returns a random DevAddr taking the NwkID prefix into account.
	GetRandomDevAddr(ctx context.Context, in *GetRandomDevAddrRequest, opts ...grpc.CallOption) (*GetRandomDevAddrResponse, error)
	// StreamFrameLogs streams the uplink and downlink frame-logs for the given DevEUI.
	//   * These are the raw LoRaWAN frames and this endpoint is intended for debugging only.
	//   * This endpoint does not work from a web-browser.
	StreamFrameLogs(ctx context.Context, in *StreamDeviceFrameLogsRequest, opts ...grpc.CallOption) (DeviceService_StreamFrameLogsClient, error)
	// StreamEventLogs stream the device events (uplink payloads, ACKs, joins, errors).
	//   * This endpoint is intended for debugging only.
	//   * This endpoint does not work from a web-browser.
	StreamEventLogs(ctx context.Context, in *StreamDeviceEventLogsRequest, opts ...grpc.CallOption) (DeviceService_StreamEventLogsClient, error)
}

type deviceServiceClient struct {
	cc *grpc.ClientConn
}

func NewDeviceServiceClient(cc *grpc.ClientConn) DeviceServiceClient {
	return &deviceServiceClient{cc}
}

func (c *deviceServiceClient) Create(ctx context.Context, in *CreateDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.DeviceService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) Get(ctx context.Context, in *GetDeviceRequest, opts ...grpc.CallOption) (*GetDeviceResponse, error) {
	out := new(GetDeviceResponse)
	err := c.cc.Invoke(ctx, "/api.DeviceService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) List(ctx context.Context, in *ListDeviceRequest, opts ...grpc.CallOption) (*ListDeviceResponse, error) {
	out := new(ListDeviceResponse)
	err := c.cc.Invoke(ctx, "/api.DeviceService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) Delete(ctx context.Context, in *DeleteDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.DeviceService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) Update(ctx context.Context, in *UpdateDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.DeviceService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) CreateKeys(ctx context.Context, in *CreateDeviceKeysRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.DeviceService/CreateKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) GetKeys(ctx context.Context, in *GetDeviceKeysRequest, opts ...grpc.CallOption) (*GetDeviceKeysResponse, error) {
	out := new(GetDeviceKeysResponse)
	err := c.cc.Invoke(ctx, "/api.DeviceService/GetKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) UpdateKeys(ctx context.Context, in *UpdateDeviceKeysRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.DeviceService/UpdateKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) DeleteKeys(ctx context.Context, in *DeleteDeviceKeysRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.DeviceService/DeleteKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) Activate(ctx context.Context, in *ActivateDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.DeviceService/Activate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) Deactivate(ctx context.Context, in *DeactivateDeviceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.DeviceService/Deactivate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) GetActivation(ctx context.Context, in *GetDeviceActivationRequest, opts ...grpc.CallOption) (*GetDeviceActivationResponse, error) {
	out := new(GetDeviceActivationResponse)
	err := c.cc.Invoke(ctx, "/api.DeviceService/GetActivation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) GetRandomDevAddr(ctx context.Context, in *GetRandomDevAddrRequest, opts ...grpc.CallOption) (*GetRandomDevAddrResponse, error) {
	out := new(GetRandomDevAddrResponse)
	err := c.cc.Invoke(ctx, "/api.DeviceService/GetRandomDevAddr", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *deviceServiceClient) StreamFrameLogs(ctx context.Context, in *StreamDeviceFrameLogsRequest, opts ...grpc.CallOption) (DeviceService_StreamFrameLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DeviceService_serviceDesc.Streams[0], "/api.DeviceService/StreamFrameLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &deviceServiceStreamFrameLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DeviceService_StreamFrameLogsClient interface {
	Recv() (*StreamDeviceFrameLogsResponse, error)
	grpc.ClientStream
}

type deviceServiceStreamFrameLogsClient struct {
	grpc.ClientStream
}

func (x *deviceServiceStreamFrameLogsClient) Recv() (*StreamDeviceFrameLogsResponse, error) {
	m := new(StreamDeviceFrameLogsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *deviceServiceClient) StreamEventLogs(ctx context.Context, in *StreamDeviceEventLogsRequest, opts ...grpc.CallOption) (DeviceService_StreamEventLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_DeviceService_serviceDesc.Streams[1], "/api.DeviceService/StreamEventLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &deviceServiceStreamEventLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type DeviceService_StreamEventLogsClient interface {
	Recv() (*StreamDeviceEventLogsResponse, error)
	grpc.ClientStream
}

type deviceServiceStreamEventLogsClient struct {
	grpc.ClientStream
}

func (x *deviceServiceStreamEventLogsClient) Recv() (*StreamDeviceEventLogsResponse, error) {
	m := new(StreamDeviceEventLogsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// DeviceServiceServer is the server API for DeviceService service.
type DeviceServiceServer interface {
	// Create creates the given device.
	Create(context.Context, *CreateDeviceRequest) (*empty.Empty, error)
	// Get returns the device matching the given DevEUI.
	Get(context.Context, *GetDeviceRequest) (*GetDeviceResponse, error)
	// List returns the available devices.
	List(context.Context, *ListDeviceRequest) (*ListDeviceResponse, error)
	// Delete deletes the device matching the given DevEUI.
	Delete(context.Context, *DeleteDeviceRequest) (*empty.Empty, error)
	// Update updates the device matching the given DevEUI.
	Update(context.Context, *UpdateDeviceRequest) (*empty.Empty, error)
	// CreateKeys creates the given device-keys.
	CreateKeys(context.Context, *CreateDeviceKeysRequest) (*empty.Empty, error)
	// GetKeys returns the device-keys for the given DevEUI.
	GetKeys(context.Context, *GetDeviceKeysRequest) (*GetDeviceKeysResponse, error)
	// UpdateKeys updates the device-keys.
	UpdateKeys(context.Context, *UpdateDeviceKeysRequest) (*empty.Empty, error)
	// DeleteKeys deletes the device-keys for the given DevEUI.
	DeleteKeys(context.Context, *DeleteDeviceKeysRequest) (*empty.Empty, error)
	// Activate (re)activates the device (only when ABP is set to true).
	Activate(context.Context, *ActivateDeviceRequest) (*empty.Empty, error)
	// Deactivate de-activates the device.
	Deactivate(context.Context, *DeactivateDeviceRequest) (*empty.Empty, error)
	// GetActivation returns the current activation details of the device (OTAA and ABP).
	GetActivation(context.Context, *GetDeviceActivationRequest) (*GetDeviceActivationResponse, error)
	// GetRandomDevAddr returns a random DevAddr taking the NwkID prefix into account.
	GetRandomDevAddr(context.Context, *GetRandomDevAddrRequest) (*GetRandomDevAddrResponse, error)
	// StreamFrameLogs streams the uplink and downlink frame-logs for the given DevEUI.
	//   * These are the raw LoRaWAN frames and this endpoint is intended for debugging only.
	//   * This endpoint does not work from a web-browser.
	StreamFrameLogs(*StreamDeviceFrameLogsRequest, DeviceService_StreamFrameLogsServer) error
	// StreamEventLogs stream the device events (uplink payloads, ACKs, joins, errors).
	//   * This endpoint is intended for debugging only.
	//   * This endpoint does not work from a web-browser.
	StreamEventLogs(*StreamDeviceEventLogsRequest, DeviceService_StreamEventLogsServer) error
}

// UnimplementedDeviceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDeviceServiceServer struct {
}

func (*UnimplementedDeviceServiceServer) Create(ctx context.Context, req *CreateDeviceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedDeviceServiceServer) Get(ctx context.Context, req *GetDeviceRequest) (*GetDeviceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedDeviceServiceServer) List(ctx context.Context, req *ListDeviceRequest) (*ListDeviceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedDeviceServiceServer) Delete(ctx context.Context, req *DeleteDeviceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedDeviceServiceServer) Update(ctx context.Context, req *UpdateDeviceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedDeviceServiceServer) CreateKeys(ctx context.Context, req *CreateDeviceKeysRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKeys not implemented")
}
func (*UnimplementedDeviceServiceServer) GetKeys(ctx context.Context, req *GetDeviceKeysRequest) (*GetDeviceKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKeys not implemented")
}
func (*UnimplementedDeviceServiceServer) UpdateKeys(ctx context.Context, req *UpdateDeviceKeysRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKeys not implemented")
}
func (*UnimplementedDeviceServiceServer) DeleteKeys(ctx context.Context, req *DeleteDeviceKeysRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKeys not implemented")
}
func (*UnimplementedDeviceServiceServer) Activate(ctx context.Context, req *ActivateDeviceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Activate not implemented")
}
func (*UnimplementedDeviceServiceServer) Deactivate(ctx context.Context, req *DeactivateDeviceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Deactivate not implemented")
}
func (*UnimplementedDeviceServiceServer) GetActivation(ctx context.Context, req *GetDeviceActivationRequest) (*GetDeviceActivationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetActivation not implemented")
}
func (*UnimplementedDeviceServiceServer) GetRandomDevAddr(ctx context.Context, req *GetRandomDevAddrRequest) (*GetRandomDevAddrResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRandomDevAddr not implemented")
}
func (*UnimplementedDeviceServiceServer) StreamFrameLogs(req *StreamDeviceFrameLogsRequest, srv DeviceService_StreamFrameLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamFrameLogs not implemented")
}
func (*UnimplementedDeviceServiceServer) StreamEventLogs(req *StreamDeviceEventLogsRequest, srv DeviceService_StreamEventLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamEventLogs not implemented")
}

func RegisterDeviceServiceServer(s *grpc.Server, srv DeviceServiceServer) {
	s.RegisterService(&_DeviceService_serviceDesc, srv)
}

func _DeviceService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Create(ctx, req.(*CreateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Get(ctx, req.(*GetDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).List(ctx, req.(*ListDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Delete(ctx, req.(*DeleteDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Update(ctx, req.(*UpdateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_CreateKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeviceKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).CreateKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/CreateKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).CreateKeys(ctx, req.(*CreateDeviceKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_GetKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).GetKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/GetKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).GetKeys(ctx, req.(*GetDeviceKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_UpdateKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeviceKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).UpdateKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/UpdateKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).UpdateKeys(ctx, req.(*UpdateDeviceKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_DeleteKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeviceKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).DeleteKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/DeleteKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).DeleteKeys(ctx, req.(*DeleteDeviceKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_Activate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Activate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/Activate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Activate(ctx, req.(*ActivateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_Deactivate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeactivateDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).Deactivate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/Deactivate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).Deactivate(ctx, req.(*DeactivateDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_GetActivation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeviceActivationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).GetActivation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/GetActivation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).GetActivation(ctx, req.(*GetDeviceActivationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_GetRandomDevAddr_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRandomDevAddrRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DeviceServiceServer).GetRandomDevAddr(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.DeviceService/GetRandomDevAddr",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DeviceServiceServer).GetRandomDevAddr(ctx, req.(*GetRandomDevAddrRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DeviceService_StreamFrameLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamDeviceFrameLogsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DeviceServiceServer).StreamFrameLogs(m, &deviceServiceStreamFrameLogsServer{stream})
}

type DeviceService_StreamFrameLogsServer interface {
	Send(*StreamDeviceFrameLogsResponse) error
	grpc.ServerStream
}

type deviceServiceStreamFrameLogsServer struct {
	grpc.ServerStream
}

func (x *deviceServiceStreamFrameLogsServer) Send(m *StreamDeviceFrameLogsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _DeviceService_StreamEventLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamDeviceEventLogsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DeviceServiceServer).StreamEventLogs(m, &deviceServiceStreamEventLogsServer{stream})
}

type DeviceService_StreamEventLogsServer interface {
	Send(*StreamDeviceEventLogsResponse) error
	grpc.ServerStream
}

type deviceServiceStreamEventLogsServer struct {
	grpc.ServerStream
}

func (x *deviceServiceStreamEventLogsServer) Send(m *StreamDeviceEventLogsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _DeviceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.DeviceService",
	HandlerType: (*DeviceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _DeviceService_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _DeviceService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _DeviceService_List_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _DeviceService_Delete_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _DeviceService_Update_Handler,
		},
		{
			MethodName: "CreateKeys",
			Handler:    _DeviceService_CreateKeys_Handler,
		},
		{
			MethodName: "GetKeys",
			Handler:    _DeviceService_GetKeys_Handler,
		},
		{
			MethodName: "UpdateKeys",
			Handler:    _DeviceService_UpdateKeys_Handler,
		},
		{
			MethodName: "DeleteKeys",
			Handler:    _DeviceService_DeleteKeys_Handler,
		},
		{
			MethodName: "Activate",
			Handler:    _DeviceService_Activate_Handler,
		},
		{
			MethodName: "Deactivate",
			Handler:    _DeviceService_Deactivate_Handler,
		},
		{
			MethodName: "GetActivation",
			Handler:    _DeviceService_GetActivation_Handler,
		},
		{
			MethodName: "GetRandomDevAddr",
			Handler:    _DeviceService_GetRandomDevAddr_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamFrameLogs",
			Handler:       _DeviceService_StreamFrameLogs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamEventLogs",
			Handler:       _DeviceService_StreamEventLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "as/external/api/device.proto",
}
