// Code generated by protoc-gen-go. DO NOT EDIT.
// source: as/external/api/fuotaDeployment.proto

package api

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type FUOTADeploymentDeviceState int32

const (
	// Pending.
	FUOTADeploymentDeviceState_PENDING FUOTADeploymentDeviceState = 0
	// Success.
	FUOTADeploymentDeviceState_SUCCESS FUOTADeploymentDeviceState = 1
	// Error.
	FUOTADeploymentDeviceState_ERROR FUOTADeploymentDeviceState = 2
)

var FUOTADeploymentDeviceState_name = map[int32]string{
	0: "PENDING",
	1: "SUCCESS",
	2: "ERROR",
}

var FUOTADeploymentDeviceState_value = map[string]int32{
	"PENDING": 0,
	"SUCCESS": 1,
	"ERROR":   2,
}

func (x FUOTADeploymentDeviceState) String() string {
	return proto.EnumName(FUOTADeploymentDeviceState_name, int32(x))
}

func (FUOTADeploymentDeviceState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{0}
}

type FUOTADeployment struct {
	// ID of the deployment (string formatted UUID).
	// This value will be automatically assigned on create.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the deployment.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Multicast type.
	// Currently only Class-C is supported!
	GroupType MulticastGroupType `protobuf:"varint,3,opt,name=group_type,json=groupType,proto3,enum=api.MulticastGroupType" json:"group_type,omitempty"`
	// Data-rate.
	Dr uint32 `protobuf:"varint,4,opt,name=dr,proto3" json:"dr,omitempty"`
	// Frequency (Hz).
	Frequency uint32 `protobuf:"varint,5,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Payload.
	Payload []byte `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
	// Redundancy (number of packages).
	Redundancy uint32 `protobuf:"varint,7,opt,name=redundancy,proto3" json:"redundancy,omitempty"`
	// Multicast time-out.
	// Please refer to the Remote Multicast Setup specification as this field
	// has a different meaning for Class-B and Class-C groups.
	MulticastTimeout uint32 `protobuf:"varint,8,opt,name=multicast_timeout,json=multicastTimeout,proto3" json:"multicast_timeout,omitempty"`
	// Unicast time-out.
	// Set this to the value in which you at least expect an uplink frame from the
	// device. The FUOTA deployment engine will wait at least for the given time
	// before proceeding with the next steps.
	UnicastTimeout *duration.Duration `protobuf:"bytes,9,opt,name=unicast_timeout,json=unicastTimeout,proto3" json:"unicast_timeout,omitempty"`
	// Deployment state.
	// This value will be automatically set on create.
	State string `protobuf:"bytes,10,opt,name=state,proto3" json:"state,omitempty"`
	// Next step after.
	// This value will be automatically set on create.
	NextStepAfter        *timestamp.Timestamp `protobuf:"bytes,11,opt,name=next_step_after,json=nextStepAfter,proto3" json:"next_step_after,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FUOTADeployment) Reset()         { *m = FUOTADeployment{} }
func (m *FUOTADeployment) String() string { return proto.CompactTextString(m) }
func (*FUOTADeployment) ProtoMessage()    {}
func (*FUOTADeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{0}
}

func (m *FUOTADeployment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FUOTADeployment.Unmarshal(m, b)
}
func (m *FUOTADeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FUOTADeployment.Marshal(b, m, deterministic)
}
func (m *FUOTADeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FUOTADeployment.Merge(m, src)
}
func (m *FUOTADeployment) XXX_Size() int {
	return xxx_messageInfo_FUOTADeployment.Size(m)
}
func (m *FUOTADeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_FUOTADeployment.DiscardUnknown(m)
}

var xxx_messageInfo_FUOTADeployment proto.InternalMessageInfo

func (m *FUOTADeployment) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *FUOTADeployment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FUOTADeployment) GetGroupType() MulticastGroupType {
	if m != nil {
		return m.GroupType
	}
	return MulticastGroupType_CLASS_C
}

func (m *FUOTADeployment) GetDr() uint32 {
	if m != nil {
		return m.Dr
	}
	return 0
}

func (m *FUOTADeployment) GetFrequency() uint32 {
	if m != nil {
		return m.Frequency
	}
	return 0
}

func (m *FUOTADeployment) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *FUOTADeployment) GetRedundancy() uint32 {
	if m != nil {
		return m.Redundancy
	}
	return 0
}

func (m *FUOTADeployment) GetMulticastTimeout() uint32 {
	if m != nil {
		return m.MulticastTimeout
	}
	return 0
}

func (m *FUOTADeployment) GetUnicastTimeout() *duration.Duration {
	if m != nil {
		return m.UnicastTimeout
	}
	return nil
}

func (m *FUOTADeployment) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *FUOTADeployment) GetNextStepAfter() *timestamp.Timestamp {
	if m != nil {
		return m.NextStepAfter
	}
	return nil
}

type FUOTADeploymentListItem struct {
	// ID of the deployment (string formatted UUID).
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Name of the deployment.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Deployment state.
	State string `protobuf:"bytes,5,opt,name=state,proto3" json:"state,omitempty"`
	// Next step after.
	NextStepAfter        *timestamp.Timestamp `protobuf:"bytes,6,opt,name=next_step_after,json=nextStepAfter,proto3" json:"next_step_after,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FUOTADeploymentListItem) Reset()         { *m = FUOTADeploymentListItem{} }
func (m *FUOTADeploymentListItem) String() string { return proto.CompactTextString(m) }
func (*FUOTADeploymentListItem) ProtoMessage()    {}
func (*FUOTADeploymentListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{1}
}

func (m *FUOTADeploymentListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FUOTADeploymentListItem.Unmarshal(m, b)
}
func (m *FUOTADeploymentListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FUOTADeploymentListItem.Marshal(b, m, deterministic)
}
func (m *FUOTADeploymentListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FUOTADeploymentListItem.Merge(m, src)
}
func (m *FUOTADeploymentListItem) XXX_Size() int {
	return xxx_messageInfo_FUOTADeploymentListItem.Size(m)
}
func (m *FUOTADeploymentListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_FUOTADeploymentListItem.DiscardUnknown(m)
}

var xxx_messageInfo_FUOTADeploymentListItem proto.InternalMessageInfo

func (m *FUOTADeploymentListItem) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *FUOTADeploymentListItem) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *FUOTADeploymentListItem) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *FUOTADeploymentListItem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FUOTADeploymentListItem) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *FUOTADeploymentListItem) GetNextStepAfter() *timestamp.Timestamp {
	if m != nil {
		return m.NextStepAfter
	}
	return nil
}

type CreateFUOTADeploymentForDeviceRequest struct {
	// Device EUI (HEX encoded).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	// FUOTA deployment.
	FuotaDeployment      *FUOTADeployment `protobuf:"bytes,2,opt,name=fuota_deployment,json=fuotaDeployment,proto3" json:"fuota_deployment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CreateFUOTADeploymentForDeviceRequest) Reset()         { *m = CreateFUOTADeploymentForDeviceRequest{} }
func (m *CreateFUOTADeploymentForDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFUOTADeploymentForDeviceRequest) ProtoMessage()    {}
func (*CreateFUOTADeploymentForDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{2}
}

func (m *CreateFUOTADeploymentForDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFUOTADeploymentForDeviceRequest.Unmarshal(m, b)
}
func (m *CreateFUOTADeploymentForDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFUOTADeploymentForDeviceRequest.Marshal(b, m, deterministic)
}
func (m *CreateFUOTADeploymentForDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFUOTADeploymentForDeviceRequest.Merge(m, src)
}
func (m *CreateFUOTADeploymentForDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFUOTADeploymentForDeviceRequest.Size(m)
}
func (m *CreateFUOTADeploymentForDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFUOTADeploymentForDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFUOTADeploymentForDeviceRequest proto.InternalMessageInfo

func (m *CreateFUOTADeploymentForDeviceRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

func (m *CreateFUOTADeploymentForDeviceRequest) GetFuotaDeployment() *FUOTADeployment {
	if m != nil {
		return m.FuotaDeployment
	}
	return nil
}

type CreateFUOTADeploymentForDeviceResponse struct {
	// ID of the created deployment (string formatted UUID).
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFUOTADeploymentForDeviceResponse) Reset() {
	*m = CreateFUOTADeploymentForDeviceResponse{}
}
func (m *CreateFUOTADeploymentForDeviceResponse) String() string { return proto.CompactTextString(m) }
func (*CreateFUOTADeploymentForDeviceResponse) ProtoMessage()    {}
func (*CreateFUOTADeploymentForDeviceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{3}
}

func (m *CreateFUOTADeploymentForDeviceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFUOTADeploymentForDeviceResponse.Unmarshal(m, b)
}
func (m *CreateFUOTADeploymentForDeviceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFUOTADeploymentForDeviceResponse.Marshal(b, m, deterministic)
}
func (m *CreateFUOTADeploymentForDeviceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFUOTADeploymentForDeviceResponse.Merge(m, src)
}
func (m *CreateFUOTADeploymentForDeviceResponse) XXX_Size() int {
	return xxx_messageInfo_CreateFUOTADeploymentForDeviceResponse.Size(m)
}
func (m *CreateFUOTADeploymentForDeviceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFUOTADeploymentForDeviceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFUOTADeploymentForDeviceResponse proto.InternalMessageInfo

func (m *CreateFUOTADeploymentForDeviceResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type GetFUOTADeploymentRequest struct {
	// ID of the deployment (string formatted UUID).
	// This value will be automatically assigned on create.
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFUOTADeploymentRequest) Reset()         { *m = GetFUOTADeploymentRequest{} }
func (m *GetFUOTADeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*GetFUOTADeploymentRequest) ProtoMessage()    {}
func (*GetFUOTADeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{4}
}

func (m *GetFUOTADeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFUOTADeploymentRequest.Unmarshal(m, b)
}
func (m *GetFUOTADeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFUOTADeploymentRequest.Marshal(b, m, deterministic)
}
func (m *GetFUOTADeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFUOTADeploymentRequest.Merge(m, src)
}
func (m *GetFUOTADeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_GetFUOTADeploymentRequest.Size(m)
}
func (m *GetFUOTADeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFUOTADeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFUOTADeploymentRequest proto.InternalMessageInfo

func (m *GetFUOTADeploymentRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type GetFUOTADeploymentResponse struct {
	FuotaDeployment *FUOTADeployment `protobuf:"bytes,1,opt,name=fuota_deployment,json=fuotaDeployment,proto3" json:"fuota_deployment,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt            *timestamp.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetFUOTADeploymentResponse) Reset()         { *m = GetFUOTADeploymentResponse{} }
func (m *GetFUOTADeploymentResponse) String() string { return proto.CompactTextString(m) }
func (*GetFUOTADeploymentResponse) ProtoMessage()    {}
func (*GetFUOTADeploymentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{5}
}

func (m *GetFUOTADeploymentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFUOTADeploymentResponse.Unmarshal(m, b)
}
func (m *GetFUOTADeploymentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFUOTADeploymentResponse.Marshal(b, m, deterministic)
}
func (m *GetFUOTADeploymentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFUOTADeploymentResponse.Merge(m, src)
}
func (m *GetFUOTADeploymentResponse) XXX_Size() int {
	return xxx_messageInfo_GetFUOTADeploymentResponse.Size(m)
}
func (m *GetFUOTADeploymentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFUOTADeploymentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetFUOTADeploymentResponse proto.InternalMessageInfo

func (m *GetFUOTADeploymentResponse) GetFuotaDeployment() *FUOTADeployment {
	if m != nil {
		return m.FuotaDeployment
	}
	return nil
}

func (m *GetFUOTADeploymentResponse) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *GetFUOTADeploymentResponse) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

type ListFUOTADeploymentRequest struct {
	// Max number of deployments to return in the result-set.
	Limit int64 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset in the result-set (for pagination).
	Offset int64 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// Application ID to filter on (optional).
	ApplicationId int64 `protobuf:"varint,3,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// Device EUI (HEX encoded) (optional).
	DevEui               string   `protobuf:"bytes,4,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFUOTADeploymentRequest) Reset()         { *m = ListFUOTADeploymentRequest{} }
func (m *ListFUOTADeploymentRequest) String() string { return proto.CompactTextString(m) }
func (*ListFUOTADeploymentRequest) ProtoMessage()    {}
func (*ListFUOTADeploymentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{6}
}

func (m *ListFUOTADeploymentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFUOTADeploymentRequest.Unmarshal(m, b)
}
func (m *ListFUOTADeploymentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFUOTADeploymentRequest.Marshal(b, m, deterministic)
}
func (m *ListFUOTADeploymentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFUOTADeploymentRequest.Merge(m, src)
}
func (m *ListFUOTADeploymentRequest) XXX_Size() int {
	return xxx_messageInfo_ListFUOTADeploymentRequest.Size(m)
}
func (m *ListFUOTADeploymentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFUOTADeploymentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFUOTADeploymentRequest proto.InternalMessageInfo

func (m *ListFUOTADeploymentRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListFUOTADeploymentRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListFUOTADeploymentRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *ListFUOTADeploymentRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type ListFUOTADeploymentResponse struct {
	// Total number of deployments available within the result-set.
	TotalCount int64 `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Deployments within this result-set.
	Result               []*FUOTADeploymentListItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ListFUOTADeploymentResponse) Reset()         { *m = ListFUOTADeploymentResponse{} }
func (m *ListFUOTADeploymentResponse) String() string { return proto.CompactTextString(m) }
func (*ListFUOTADeploymentResponse) ProtoMessage()    {}
func (*ListFUOTADeploymentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{7}
}

func (m *ListFUOTADeploymentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFUOTADeploymentResponse.Unmarshal(m, b)
}
func (m *ListFUOTADeploymentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFUOTADeploymentResponse.Marshal(b, m, deterministic)
}
func (m *ListFUOTADeploymentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFUOTADeploymentResponse.Merge(m, src)
}
func (m *ListFUOTADeploymentResponse) XXX_Size() int {
	return xxx_messageInfo_ListFUOTADeploymentResponse.Size(m)
}
func (m *ListFUOTADeploymentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFUOTADeploymentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFUOTADeploymentResponse proto.InternalMessageInfo

func (m *ListFUOTADeploymentResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ListFUOTADeploymentResponse) GetResult() []*FUOTADeploymentListItem {
	if m != nil {
		return m.Result
	}
	return nil
}

type ListFUOTADeploymentDevicesRequest struct {
	// ID of the deployment (string formatted UUID).
	// This value will be automatically assigned on create.
	FuotaDeploymentId string `protobuf:"bytes,1,opt,name=fuota_deployment_id,json=fuotaDeploymentID,proto3" json:"fuota_deployment_id,omitempty"`
	// Max number of items to return.
	Limit int64 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset in the result-set (for pagination).
	Offset               int64    `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFUOTADeploymentDevicesRequest) Reset()         { *m = ListFUOTADeploymentDevicesRequest{} }
func (m *ListFUOTADeploymentDevicesRequest) String() string { return proto.CompactTextString(m) }
func (*ListFUOTADeploymentDevicesRequest) ProtoMessage()    {}
func (*ListFUOTADeploymentDevicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{8}
}

func (m *ListFUOTADeploymentDevicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFUOTADeploymentDevicesRequest.Unmarshal(m, b)
}
func (m *ListFUOTADeploymentDevicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFUOTADeploymentDevicesRequest.Marshal(b, m, deterministic)
}
func (m *ListFUOTADeploymentDevicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFUOTADeploymentDevicesRequest.Merge(m, src)
}
func (m *ListFUOTADeploymentDevicesRequest) XXX_Size() int {
	return xxx_messageInfo_ListFUOTADeploymentDevicesRequest.Size(m)
}
func (m *ListFUOTADeploymentDevicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFUOTADeploymentDevicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFUOTADeploymentDevicesRequest proto.InternalMessageInfo

func (m *ListFUOTADeploymentDevicesRequest) GetFuotaDeploymentId() string {
	if m != nil {
		return m.FuotaDeploymentId
	}
	return ""
}

func (m *ListFUOTADeploymentDevicesRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListFUOTADeploymentDevicesRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type GetFUOTADeploymentDeviceRequest struct {
	// ID of the deployment (string formatted UUID).
	// This value will be automatically assigned on create.
	FuotaDeploymentId string `protobuf:"bytes,1,opt,name=fuota_deployment_id,json=fuotaDeploymentID,proto3" json:"fuota_deployment_id,omitempty"`
	// Device EUI (HEX encoded).
	DevEui               string   `protobuf:"bytes,2,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFUOTADeploymentDeviceRequest) Reset()         { *m = GetFUOTADeploymentDeviceRequest{} }
func (m *GetFUOTADeploymentDeviceRequest) String() string { return proto.CompactTextString(m) }
func (*GetFUOTADeploymentDeviceRequest) ProtoMessage()    {}
func (*GetFUOTADeploymentDeviceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{9}
}

func (m *GetFUOTADeploymentDeviceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFUOTADeploymentDeviceRequest.Unmarshal(m, b)
}
func (m *GetFUOTADeploymentDeviceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFUOTADeploymentDeviceRequest.Marshal(b, m, deterministic)
}
func (m *GetFUOTADeploymentDeviceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFUOTADeploymentDeviceRequest.Merge(m, src)
}
func (m *GetFUOTADeploymentDeviceRequest) XXX_Size() int {
	return xxx_messageInfo_GetFUOTADeploymentDeviceRequest.Size(m)
}
func (m *GetFUOTADeploymentDeviceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFUOTADeploymentDeviceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFUOTADeploymentDeviceRequest proto.InternalMessageInfo

func (m *GetFUOTADeploymentDeviceRequest) GetFuotaDeploymentId() string {
	if m != nil {
		return m.FuotaDeploymentId
	}
	return ""
}

func (m *GetFUOTADeploymentDeviceRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type GetFUOTADeploymentDeviceResponse struct {
	DeploymentDevice     *FUOTADeploymentDeviceListItem `protobuf:"bytes,1,opt,name=deployment_device,json=deploymentDevice,proto3" json:"deployment_device,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *GetFUOTADeploymentDeviceResponse) Reset()         { *m = GetFUOTADeploymentDeviceResponse{} }
func (m *GetFUOTADeploymentDeviceResponse) String() string { return proto.CompactTextString(m) }
func (*GetFUOTADeploymentDeviceResponse) ProtoMessage()    {}
func (*GetFUOTADeploymentDeviceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{10}
}

func (m *GetFUOTADeploymentDeviceResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFUOTADeploymentDeviceResponse.Unmarshal(m, b)
}
func (m *GetFUOTADeploymentDeviceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFUOTADeploymentDeviceResponse.Marshal(b, m, deterministic)
}
func (m *GetFUOTADeploymentDeviceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFUOTADeploymentDeviceResponse.Merge(m, src)
}
func (m *GetFUOTADeploymentDeviceResponse) XXX_Size() int {
	return xxx_messageInfo_GetFUOTADeploymentDeviceResponse.Size(m)
}
func (m *GetFUOTADeploymentDeviceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFUOTADeploymentDeviceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetFUOTADeploymentDeviceResponse proto.InternalMessageInfo

func (m *GetFUOTADeploymentDeviceResponse) GetDeploymentDevice() *FUOTADeploymentDeviceListItem {
	if m != nil {
		return m.DeploymentDevice
	}
	return nil
}

type ListFUOTADeploymentDevicesResponse struct {
	// Total number of devices for the FUOTA deployment.
	TotalCount           int64                            `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	Result               []*FUOTADeploymentDeviceListItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *ListFUOTADeploymentDevicesResponse) Reset()         { *m = ListFUOTADeploymentDevicesResponse{} }
func (m *ListFUOTADeploymentDevicesResponse) String() string { return proto.CompactTextString(m) }
func (*ListFUOTADeploymentDevicesResponse) ProtoMessage()    {}
func (*ListFUOTADeploymentDevicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{11}
}

func (m *ListFUOTADeploymentDevicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFUOTADeploymentDevicesResponse.Unmarshal(m, b)
}
func (m *ListFUOTADeploymentDevicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFUOTADeploymentDevicesResponse.Marshal(b, m, deterministic)
}
func (m *ListFUOTADeploymentDevicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFUOTADeploymentDevicesResponse.Merge(m, src)
}
func (m *ListFUOTADeploymentDevicesResponse) XXX_Size() int {
	return xxx_messageInfo_ListFUOTADeploymentDevicesResponse.Size(m)
}
func (m *ListFUOTADeploymentDevicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFUOTADeploymentDevicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFUOTADeploymentDevicesResponse proto.InternalMessageInfo

func (m *ListFUOTADeploymentDevicesResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ListFUOTADeploymentDevicesResponse) GetResult() []*FUOTADeploymentDeviceListItem {
	if m != nil {
		return m.Result
	}
	return nil
}

type FUOTADeploymentDeviceListItem struct {
	// Device EUI (HEX encoded).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	// Device name.
	DeviceName string `protobuf:"bytes,2,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Device state.
	State FUOTADeploymentDeviceState `protobuf:"varint,3,opt,name=state,proto3,enum=api.FUOTADeploymentDeviceState" json:"state,omitempty"`
	// Error message (in case of error state).
	ErrorMessage string `protobuf:"bytes,4,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Updated at timestamp.
	UpdatedAt            *timestamp.Timestamp `protobuf:"bytes,6,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FUOTADeploymentDeviceListItem) Reset()         { *m = FUOTADeploymentDeviceListItem{} }
func (m *FUOTADeploymentDeviceListItem) String() string { return proto.CompactTextString(m) }
func (*FUOTADeploymentDeviceListItem) ProtoMessage()    {}
func (*FUOTADeploymentDeviceListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ae912e3feed0382, []int{12}
}

func (m *FUOTADeploymentDeviceListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FUOTADeploymentDeviceListItem.Unmarshal(m, b)
}
func (m *FUOTADeploymentDeviceListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FUOTADeploymentDeviceListItem.Marshal(b, m, deterministic)
}
func (m *FUOTADeploymentDeviceListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FUOTADeploymentDeviceListItem.Merge(m, src)
}
func (m *FUOTADeploymentDeviceListItem) XXX_Size() int {
	return xxx_messageInfo_FUOTADeploymentDeviceListItem.Size(m)
}
func (m *FUOTADeploymentDeviceListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_FUOTADeploymentDeviceListItem.DiscardUnknown(m)
}

var xxx_messageInfo_FUOTADeploymentDeviceListItem proto.InternalMessageInfo

func (m *FUOTADeploymentDeviceListItem) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

func (m *FUOTADeploymentDeviceListItem) GetDeviceName() string {
	if m != nil {
		return m.DeviceName
	}
	return ""
}

func (m *FUOTADeploymentDeviceListItem) GetState() FUOTADeploymentDeviceState {
	if m != nil {
		return m.State
	}
	return FUOTADeploymentDeviceState_PENDING
}

func (m *FUOTADeploymentDeviceListItem) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *FUOTADeploymentDeviceListItem) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *FUOTADeploymentDeviceListItem) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func init() {
	proto.RegisterEnum("api.FUOTADeploymentDeviceState", FUOTADeploymentDeviceState_name, FUOTADeploymentDeviceState_value)
	proto.RegisterType((*FUOTADeployment)(nil), "api.FUOTADeployment")
	proto.RegisterType((*FUOTADeploymentListItem)(nil), "api.FUOTADeploymentListItem")
	proto.RegisterType((*CreateFUOTADeploymentForDeviceRequest)(nil), "api.CreateFUOTADeploymentForDeviceRequest")
	proto.RegisterType((*CreateFUOTADeploymentForDeviceResponse)(nil), "api.CreateFUOTADeploymentForDeviceResponse")
	proto.RegisterType((*GetFUOTADeploymentRequest)(nil), "api.GetFUOTADeploymentRequest")
	proto.RegisterType((*GetFUOTADeploymentResponse)(nil), "api.GetFUOTADeploymentResponse")
	proto.RegisterType((*ListFUOTADeploymentRequest)(nil), "api.ListFUOTADeploymentRequest")
	proto.RegisterType((*ListFUOTADeploymentResponse)(nil), "api.ListFUOTADeploymentResponse")
	proto.RegisterType((*ListFUOTADeploymentDevicesRequest)(nil), "api.ListFUOTADeploymentDevicesRequest")
	proto.RegisterType((*GetFUOTADeploymentDeviceRequest)(nil), "api.GetFUOTADeploymentDeviceRequest")
	proto.RegisterType((*GetFUOTADeploymentDeviceResponse)(nil), "api.GetFUOTADeploymentDeviceResponse")
	proto.RegisterType((*ListFUOTADeploymentDevicesResponse)(nil), "api.ListFUOTADeploymentDevicesResponse")
	proto.RegisterType((*FUOTADeploymentDeviceListItem)(nil), "api.FUOTADeploymentDeviceListItem")
}

func init() {
	proto.RegisterFile("as/external/api/fuotaDeployment.proto", fileDescriptor_0ae912e3feed0382)
}

var fileDescriptor_0ae912e3feed0382 = []byte{
	// 1083 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0x41, 0x53, 0xdb, 0x46,
	0x14, 0xae, 0x6c, 0x6c, 0xea, 0xe7, 0x00, 0x66, 0x43, 0x41, 0x51, 0x08, 0x76, 0x95, 0x90, 0x7a,
	0x60, 0xb0, 0x66, 0x20, 0x4d, 0x9b, 0x4c, 0xa7, 0x2d, 0xc1, 0xc0, 0x30, 0xd3, 0x40, 0x47, 0x86,
	0x4b, 0x2f, 0x9a, 0x45, 0x5a, 0x3b, 0x6a, 0x6c, 0xad, 0x2a, 0xad, 0x98, 0x30, 0x19, 0x0e, 0xed,
	0xb1, 0x33, 0x3d, 0xf5, 0x07, 0xb4, 0xa7, 0x1e, 0xda, 0x9f, 0x93, 0xbf, 0xd0, 0x43, 0x7f, 0x46,
	0x67, 0x57, 0x2b, 0x23, 0x0b, 0x0b, 0x43, 0x2e, 0xb9, 0x79, 0xdf, 0x7e, 0xef, 0xbd, 0x6f, 0xbf,
	0xf7, 0xf6, 0xad, 0x0c, 0xab, 0x38, 0x34, 0xc8, 0x1b, 0x46, 0x02, 0x0f, 0xf7, 0x0d, 0xec, 0xbb,
	0x46, 0x37, 0xa2, 0x0c, 0xb7, 0x89, 0xdf, 0xa7, 0xe7, 0x03, 0xe2, 0xb1, 0x96, 0x1f, 0x50, 0x46,
	0x51, 0x11, 0xfb, 0xae, 0xb6, 0xdc, 0xa3, 0xb4, 0xd7, 0x27, 0x02, 0x86, 0x3d, 0x8f, 0x32, 0xcc,
	0x5c, 0xea, 0x85, 0x31, 0x44, 0xab, 0xcb, 0x5d, 0xb1, 0x3a, 0x8d, 0xba, 0x06, 0x73, 0x07, 0x24,
	0x64, 0x78, 0xe0, 0x4b, 0xc0, 0x4a, 0x16, 0xe0, 0x44, 0x81, 0x88, 0x20, 0xf7, 0x1f, 0x65, 0xa9,
	0x0c, 0xa2, 0x3e, 0x73, 0x6d, 0x1c, 0xb2, 0xfd, 0x80, 0x46, 0x32, 0x8a, 0xfe, 0x67, 0x11, 0xe6,
	0xf6, 0x4e, 0x8e, 0x8e, 0xb7, 0x2f, 0x39, 0xa2, 0x59, 0x28, 0xb8, 0x8e, 0xaa, 0x34, 0x94, 0x66,
	0xc5, 0x2c, 0xb8, 0x0e, 0x42, 0x30, 0xe5, 0xe1, 0x01, 0x51, 0x0b, 0xc2, 0x22, 0x7e, 0xa3, 0xa7,
	0x00, 0x3d, 0x1e, 0xc6, 0x62, 0xe7, 0x3e, 0x51, 0x8b, 0x0d, 0xa5, 0x39, 0xbb, 0xb9, 0xd4, 0xc2,
	0xbe, 0xdb, 0x7a, 0x39, 0x92, 0xe6, 0xf8, 0xdc, 0x27, 0x66, 0xa5, 0x97, 0xfc, 0xe4, 0xb1, 0x9d,
	0x40, 0x9d, 0x6a, 0x28, 0xcd, 0x19, 0xb3, 0xe0, 0x04, 0x68, 0x19, 0x2a, 0xdd, 0x80, 0xfc, 0x14,
	0x11, 0xcf, 0x3e, 0x57, 0x4b, 0xc2, 0x7c, 0x69, 0x40, 0x2a, 0x4c, 0xfb, 0xf8, 0xbc, 0x4f, 0xb1,
	0xa3, 0x96, 0x1b, 0x4a, 0xf3, 0x8e, 0x99, 0x2c, 0xd1, 0x0a, 0x40, 0x40, 0x9c, 0xc8, 0x73, 0x30,
	0x77, 0x9c, 0x16, 0x8e, 0x29, 0x0b, 0x5a, 0x87, 0xf9, 0xe1, 0x79, 0x2d, 0x2e, 0x1d, 0x8d, 0x98,
	0xfa, 0xb1, 0x80, 0xd5, 0x86, 0x1b, 0xc7, 0xb1, 0x1d, 0xbd, 0x80, 0xb9, 0xc8, 0x1b, 0x85, 0x56,
	0x1a, 0x4a, 0xb3, 0xba, 0x79, 0xaf, 0x15, 0x8b, 0xdc, 0x4a, 0x44, 0x6e, 0xb5, 0xa5, 0xc8, 0xe6,
	0xac, 0xf4, 0x48, 0x62, 0x2c, 0x40, 0x29, 0x64, 0x98, 0x11, 0x15, 0x84, 0x4a, 0xf1, 0x82, 0x47,
	0xf6, 0xc8, 0x1b, 0x66, 0x85, 0x8c, 0xf8, 0x16, 0xee, 0x32, 0x12, 0xa8, 0x55, 0x11, 0x59, 0xbb,
	0x12, 0xf9, 0x38, 0xa9, 0xaf, 0x39, 0xc3, 0x5d, 0x3a, 0x8c, 0xf8, 0xdb, 0xdc, 0x41, 0xff, 0xad,
	0x00, 0x4b, 0x99, 0x12, 0x7d, 0xe7, 0x86, 0xec, 0x80, 0x91, 0xc1, 0x95, 0x52, 0x3d, 0x03, 0xb0,
	0x03, 0x82, 0x19, 0x71, 0x2c, 0xcc, 0x44, 0xc1, 0xae, 0x4f, 0x55, 0x91, 0xe8, 0x6d, 0xc6, 0x5d,
	0x23, 0xdf, 0x49, 0x5c, 0x8b, 0x93, 0x5d, 0x25, 0x7a, 0x9b, 0x0d, 0x1b, 0x64, 0x2a, 0xd5, 0x20,
	0x43, 0x3d, 0x4a, 0x13, 0xf4, 0x28, 0xdf, 0x56, 0x8f, 0x9f, 0x15, 0x58, 0xdd, 0x11, 0xb4, 0x33,
	0xaa, 0xec, 0xd1, 0xa0, 0x4d, 0xce, 0x5c, 0x9b, 0x98, 0xbc, 0x7f, 0x42, 0x86, 0x96, 0x60, 0xda,
	0x21, 0x67, 0x16, 0x89, 0x5c, 0x29, 0x51, 0xd9, 0x21, 0x67, 0xbb, 0x27, 0x07, 0xe8, 0x1b, 0xa8,
	0x89, 0x8b, 0x69, 0x39, 0x43, 0x67, 0x29, 0xd6, 0x82, 0xe8, 0xe1, 0x4c, 0x60, 0x73, 0x2e, 0x73,
	0x8d, 0xf5, 0x2f, 0xe1, 0xf1, 0x24, 0x0a, 0xa1, 0x4f, 0xbd, 0x90, 0x64, 0x2b, 0xa4, 0xaf, 0xc3,
	0xbd, 0x7d, 0xc2, 0xb2, 0x09, 0x24, 0xe1, 0x2c, 0xf8, 0x9d, 0x02, 0xda, 0x38, 0xb4, 0x8c, 0x3d,
	0xee, 0x18, 0xca, 0x2d, 0x8e, 0xf1, 0x61, 0xda, 0x45, 0xff, 0x55, 0x01, 0x8d, 0x77, 0x70, 0x8e,
	0x08, 0x0b, 0x50, 0xea, 0xbb, 0x03, 0x37, 0x3e, 0x4a, 0xd1, 0x8c, 0x17, 0x68, 0x11, 0xca, 0xb4,
	0xdb, 0x0d, 0x49, 0x4c, 0xb3, 0x68, 0xca, 0x15, 0x5a, 0x85, 0x59, 0xec, 0xfb, 0x7d, 0xd7, 0x16,
	0xd7, 0xd2, 0x72, 0x1d, 0xc1, 0xa5, 0x68, 0xce, 0xa4, 0xac, 0x07, 0xed, 0x74, 0x2b, 0x4c, 0xa5,
	0x5b, 0x41, 0x67, 0x70, 0x7f, 0x2c, 0x17, 0x29, 0x71, 0x1d, 0xaa, 0x8c, 0x32, 0xdc, 0xb7, 0x6c,
	0x1a, 0x79, 0x09, 0x25, 0x10, 0xa6, 0x1d, 0x6e, 0x41, 0x4f, 0xa0, 0x1c, 0x90, 0x30, 0xea, 0x73,
	0x5e, 0xc5, 0x66, 0x75, 0x73, 0x79, 0x9c, 0xf2, 0xc9, 0x7d, 0x35, 0x25, 0x96, 0xf7, 0xf0, 0xa7,
	0x63, 0xd2, 0xc6, 0xbd, 0x13, 0x26, 0x4a, 0xb4, 0xe0, 0x6e, 0xb6, 0xbe, 0xd6, 0xb0, 0x3f, 0xe6,
	0x33, 0xc5, 0x3c, 0x68, 0x5f, 0x2a, 0x57, 0x18, 0xaf, 0x5c, 0x31, 0xad, 0x9c, 0xfe, 0x23, 0xd4,
	0xaf, 0xf6, 0xd6, 0xe8, 0x05, 0xba, 0x2d, 0x81, 0x94, 0xca, 0x85, 0x11, 0x95, 0x43, 0x68, 0xe4,
	0xe7, 0x92, 0x52, 0x1f, 0xc1, 0x7c, 0x2a, 0x8d, 0x23, 0x36, 0x65, 0x3b, 0xeb, 0xe3, 0x44, 0x8d,
	0xdd, 0x87, 0xd2, 0xd6, 0x9c, 0xcc, 0x0e, 0x17, 0x59, 0xbf, 0x4e, 0xe4, 0x9b, 0x96, 0xf8, 0x79,
	0xa6, 0xc4, 0x37, 0x61, 0x93, 0x14, 0xfa, 0x9f, 0x02, 0x3c, 0xb8, 0x16, 0x99, 0x3f, 0xa4, 0xea,
	0x50, 0x8d, 0x45, 0xb0, 0x52, 0xaf, 0x2f, 0xc4, 0xa6, 0x43, 0x3e, 0x62, 0x3f, 0x4f, 0x46, 0x6c,
	0xfc, 0xfc, 0xd6, 0xf3, 0x69, 0x75, 0x38, 0x2c, 0x99, 0xc1, 0x0f, 0x61, 0x86, 0x04, 0x01, 0x0d,
	0xac, 0x01, 0x09, 0x43, 0xdc, 0x4b, 0xc6, 0xf6, 0x1d, 0x61, 0x7c, 0x19, 0xdb, 0x32, 0x93, 0xa1,
	0xf4, 0xfe, 0x93, 0xa1, 0x7c, 0x8b, 0xc9, 0xb0, 0xb6, 0x0d, 0x5a, 0x3e, 0x7f, 0x54, 0x85, 0xe9,
	0xef, 0x77, 0x0f, 0xdb, 0x07, 0x87, 0xfb, 0xb5, 0x8f, 0xf8, 0xa2, 0x73, 0xb2, 0xb3, 0xb3, 0xdb,
	0xe9, 0xd4, 0x14, 0x54, 0x81, 0xd2, 0xae, 0x69, 0x1e, 0x99, 0xb5, 0xc2, 0xe6, 0x7f, 0x25, 0x58,
	0xcc, 0xc4, 0xe8, 0x90, 0x80, 0x07, 0x41, 0x7f, 0x28, 0x30, 0x27, 0xa7, 0x76, 0x32, 0xa6, 0xd1,
	0x9a, 0x10, 0xed, 0x46, 0xcf, 0x89, 0xb6, 0x7e, 0x23, 0x6c, 0xdc, 0x55, 0xfa, 0xd6, 0x2f, 0xef,
	0xfe, 0xfd, 0xbd, 0xb0, 0xa1, 0x37, 0xc5, 0xb7, 0x57, 0x5c, 0xb5, 0xd0, 0x78, 0x2b, 0x4b, 0x7d,
	0x11, 0x7f, 0x18, 0x6e, 0x5c, 0xf6, 0x6c, 0xf8, 0x5c, 0x59, 0x43, 0xaf, 0xa1, 0xb8, 0x4f, 0x18,
	0x5a, 0x11, 0x89, 0x72, 0x9f, 0x09, 0xad, 0x9e, 0xbb, 0x2f, 0x93, 0x3f, 0x14, 0xc9, 0x1f, 0xa0,
	0xfb, 0x97, 0xdf, 0xa0, 0xe9, 0x54, 0xc6, 0x5b, 0xd7, 0xb9, 0x40, 0x2e, 0x4c, 0xf1, 0x26, 0x44,
	0x71, 0xb4, 0xfc, 0x81, 0xac, 0x35, 0xf2, 0x01, 0x32, 0xdf, 0x8a, 0xc8, 0xa7, 0xa2, 0xc5, 0xf1,
	0xf9, 0xd0, 0xdf, 0x0a, 0xdc, 0xdd, 0x27, 0x2c, 0x5b, 0x56, 0xf4, 0x28, 0xe7, 0x20, 0xa3, 0xba,
	0xaf, 0x4e, 0x40, 0x49, 0x12, 0x7b, 0x82, 0xc4, 0xb7, 0xe8, 0xeb, 0xbc, 0x43, 0x8f, 0x19, 0x65,
	0x17, 0x57, 0x2b, 0x83, 0xfe, 0x52, 0xe0, 0x13, 0x7e, 0xd8, 0x2b, 0x13, 0x03, 0x3d, 0xce, 0x13,
	0x62, 0x74, 0x6e, 0x6b, 0x9f, 0x4d, 0xc4, 0x49, 0xca, 0x5f, 0x09, 0xca, 0x4f, 0xd1, 0x93, 0xf7,
	0xa1, 0xfc, 0xe2, 0xd9, 0x0f, 0x5f, 0xf4, 0x5c, 0xf6, 0x2a, 0x3a, 0x6d, 0xd9, 0x74, 0x60, 0x9c,
	0x06, 0xd4, 0xc6, 0x38, 0x30, 0xec, 0x57, 0x6e, 0xe0, 0x87, 0x0c, 0xdb, 0xaf, 0x37, 0x78, 0xd0,
	0x1e, 0x35, 0xce, 0xb6, 0x8c, 0xcc, 0x7f, 0x81, 0xd3, 0xb2, 0xb8, 0x87, 0x5b, 0xff, 0x07, 0x00,
	0x00, 0xff, 0xff, 0x5f, 0x5e, 0xd7, 0x13, 0xb0, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FUOTADeploymentServiceClient is the client API for FUOTADeploymentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FUOTADeploymentServiceClient interface {
	// CreateForDevice creates a deployment for the given DevEUI.
	CreateForDevice(ctx context.Context, in *CreateFUOTADeploymentForDeviceRequest, opts ...grpc.CallOption) (*CreateFUOTADeploymentForDeviceResponse, error)
	// Get returns the fuota deployment for the given id.
	Get(ctx context.Context, in *GetFUOTADeploymentRequest, opts ...grpc.CallOption) (*GetFUOTADeploymentResponse, error)
	// List lists the fuota deployments.
	List(ctx context.Context, in *ListFUOTADeploymentRequest, opts ...grpc.CallOption) (*ListFUOTADeploymentResponse, error)
	// GetDeploymentDevice returns the deployment device.
	GetDeploymentDevice(ctx context.Context, in *GetFUOTADeploymentDeviceRequest, opts ...grpc.CallOption) (*GetFUOTADeploymentDeviceResponse, error)
	// ListDeploymentDevices lists the devices (and status) for the given fuota deployment ID.
	ListDeploymentDevices(ctx context.Context, in *ListFUOTADeploymentDevicesRequest, opts ...grpc.CallOption) (*ListFUOTADeploymentDevicesResponse, error)
}

type fUOTADeploymentServiceClient struct {
	cc *grpc.ClientConn
}

func NewFUOTADeploymentServiceClient(cc *grpc.ClientConn) FUOTADeploymentServiceClient {
	return &fUOTADeploymentServiceClient{cc}
}

func (c *fUOTADeploymentServiceClient) CreateForDevice(ctx context.Context, in *CreateFUOTADeploymentForDeviceRequest, opts ...grpc.CallOption) (*CreateFUOTADeploymentForDeviceResponse, error) {
	out := new(CreateFUOTADeploymentForDeviceResponse)
	err := c.cc.Invoke(ctx, "/api.FUOTADeploymentService/CreateForDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fUOTADeploymentServiceClient) Get(ctx context.Context, in *GetFUOTADeploymentRequest, opts ...grpc.CallOption) (*GetFUOTADeploymentResponse, error) {
	out := new(GetFUOTADeploymentResponse)
	err := c.cc.Invoke(ctx, "/api.FUOTADeploymentService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fUOTADeploymentServiceClient) List(ctx context.Context, in *ListFUOTADeploymentRequest, opts ...grpc.CallOption) (*ListFUOTADeploymentResponse, error) {
	out := new(ListFUOTADeploymentResponse)
	err := c.cc.Invoke(ctx, "/api.FUOTADeploymentService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fUOTADeploymentServiceClient) GetDeploymentDevice(ctx context.Context, in *GetFUOTADeploymentDeviceRequest, opts ...grpc.CallOption) (*GetFUOTADeploymentDeviceResponse, error) {
	out := new(GetFUOTADeploymentDeviceResponse)
	err := c.cc.Invoke(ctx, "/api.FUOTADeploymentService/GetDeploymentDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fUOTADeploymentServiceClient) ListDeploymentDevices(ctx context.Context, in *ListFUOTADeploymentDevicesRequest, opts ...grpc.CallOption) (*ListFUOTADeploymentDevicesResponse, error) {
	out := new(ListFUOTADeploymentDevicesResponse)
	err := c.cc.Invoke(ctx, "/api.FUOTADeploymentService/ListDeploymentDevices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FUOTADeploymentServiceServer is the server API for FUOTADeploymentService service.
type FUOTADeploymentServiceServer interface {
	// CreateForDevice creates a deployment for the given DevEUI.
	CreateForDevice(context.Context, *CreateFUOTADeploymentForDeviceRequest) (*CreateFUOTADeploymentForDeviceResponse, error)
	// Get returns the fuota deployment for the given id.
	Get(context.Context, *GetFUOTADeploymentRequest) (*GetFUOTADeploymentResponse, error)
	// List lists the fuota deployments.
	List(context.Context, *ListFUOTADeploymentRequest) (*ListFUOTADeploymentResponse, error)
	// GetDeploymentDevice returns the deployment device.
	GetDeploymentDevice(context.Context, *GetFUOTADeploymentDeviceRequest) (*GetFUOTADeploymentDeviceResponse, error)
	// ListDeploymentDevices lists the devices (and status) for the given fuota deployment ID.
	ListDeploymentDevices(context.Context, *ListFUOTADeploymentDevicesRequest) (*ListFUOTADeploymentDevicesResponse, error)
}

// UnimplementedFUOTADeploymentServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFUOTADeploymentServiceServer struct {
}

func (*UnimplementedFUOTADeploymentServiceServer) CreateForDevice(ctx context.Context, req *CreateFUOTADeploymentForDeviceRequest) (*CreateFUOTADeploymentForDeviceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateForDevice not implemented")
}
func (*UnimplementedFUOTADeploymentServiceServer) Get(ctx context.Context, req *GetFUOTADeploymentRequest) (*GetFUOTADeploymentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedFUOTADeploymentServiceServer) List(ctx context.Context, req *ListFUOTADeploymentRequest) (*ListFUOTADeploymentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedFUOTADeploymentServiceServer) GetDeploymentDevice(ctx context.Context, req *GetFUOTADeploymentDeviceRequest) (*GetFUOTADeploymentDeviceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeploymentDevice not implemented")
}
func (*UnimplementedFUOTADeploymentServiceServer) ListDeploymentDevices(ctx context.Context, req *ListFUOTADeploymentDevicesRequest) (*ListFUOTADeploymentDevicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeploymentDevices not implemented")
}

func RegisterFUOTADeploymentServiceServer(s *grpc.Server, srv FUOTADeploymentServiceServer) {
	s.RegisterService(&_FUOTADeploymentService_serviceDesc, srv)
}

func _FUOTADeploymentService_CreateForDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFUOTADeploymentForDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FUOTADeploymentServiceServer).CreateForDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.FUOTADeploymentService/CreateForDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FUOTADeploymentServiceServer).CreateForDevice(ctx, req.(*CreateFUOTADeploymentForDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FUOTADeploymentService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFUOTADeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FUOTADeploymentServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.FUOTADeploymentService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FUOTADeploymentServiceServer).Get(ctx, req.(*GetFUOTADeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FUOTADeploymentService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFUOTADeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FUOTADeploymentServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.FUOTADeploymentService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FUOTADeploymentServiceServer).List(ctx, req.(*ListFUOTADeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FUOTADeploymentService_GetDeploymentDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFUOTADeploymentDeviceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FUOTADeploymentServiceServer).GetDeploymentDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.FUOTADeploymentService/GetDeploymentDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FUOTADeploymentServiceServer).GetDeploymentDevice(ctx, req.(*GetFUOTADeploymentDeviceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FUOTADeploymentService_ListDeploymentDevices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFUOTADeploymentDevicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FUOTADeploymentServiceServer).ListDeploymentDevices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.FUOTADeploymentService/ListDeploymentDevices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FUOTADeploymentServiceServer).ListDeploymentDevices(ctx, req.(*ListFUOTADeploymentDevicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FUOTADeploymentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.FUOTADeploymentService",
	HandlerType: (*FUOTADeploymentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateForDevice",
			Handler:    _FUOTADeploymentService_CreateForDevice_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _FUOTADeploymentService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _FUOTADeploymentService_List_Handler,
		},
		{
			MethodName: "GetDeploymentDevice",
			Handler:    _FUOTADeploymentService_GetDeploymentDevice_Handler,
		},
		{
			MethodName: "ListDeploymentDevices",
			Handler:    _FUOTADeploymentService_ListDeploymentDevices_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "as/external/api/fuotaDeployment.proto",
}
