// Code generated by protoc-gen-go. DO NOT EDIT.
// source: as/external/api/gateway.proto

package api

import (
	context "context"
	fmt "fmt"
	common "github.com/brocaar/chirpstack-api/go/v3/common"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type Gateway struct {
	// Gateway ID (HEX encoded).
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Gateway name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Gateway description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Gateway location.
	Location *common.Location `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
	// Organization ID to which the gateway belongs.
	// This can't be changed after creating the gateway.
	OrganizationId int64 `protobuf:"varint,5,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Set to true to enable gateway discovery.
	DiscoveryEnabled bool `protobuf:"varint,6,opt,name=discovery_enabled,json=discoveryEnabled,proto3" json:"discovery_enabled,omitempty"`
	// Network-server ID on which the gateway is provisioned.
	NetworkServerId int64 `protobuf:"varint,7,opt,name=network_server_id,json=networkServerID,proto3" json:"network_server_id,omitempty"`
	// Gateway-profile ID (UUID string, optional).
	GatewayProfileId string `protobuf:"bytes,8,opt,name=gateway_profile_id,json=gatewayProfileID,proto3" json:"gateway_profile_id,omitempty"`
	// Gateway boards configuration (optional).
	// This is (currently) only needed when the gateway supports the fine-timestamp
	// and you you would like to add the FPGA ID to the gateway meta-data or would
	// like ChirpStack Network Server to decrypt the fine-timestamp.
	Boards []*GatewayBoard `protobuf:"bytes,9,rep,name=boards,proto3" json:"boards,omitempty"`
	// Tags (user defined).
	Tags map[string]string `protobuf:"bytes,10,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Metadata (provided by the gateway).
	Metadata             map[string]string `protobuf:"bytes,11,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Gateway) Reset()         { *m = Gateway{} }
func (m *Gateway) String() string { return proto.CompactTextString(m) }
func (*Gateway) ProtoMessage()    {}
func (*Gateway) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{0}
}

func (m *Gateway) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Gateway.Unmarshal(m, b)
}
func (m *Gateway) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Gateway.Marshal(b, m, deterministic)
}
func (m *Gateway) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Gateway.Merge(m, src)
}
func (m *Gateway) XXX_Size() int {
	return xxx_messageInfo_Gateway.Size(m)
}
func (m *Gateway) XXX_DiscardUnknown() {
	xxx_messageInfo_Gateway.DiscardUnknown(m)
}

var xxx_messageInfo_Gateway proto.InternalMessageInfo

func (m *Gateway) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Gateway) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Gateway) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Gateway) GetLocation() *common.Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *Gateway) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *Gateway) GetDiscoveryEnabled() bool {
	if m != nil {
		return m.DiscoveryEnabled
	}
	return false
}

func (m *Gateway) GetNetworkServerId() int64 {
	if m != nil {
		return m.NetworkServerId
	}
	return 0
}

func (m *Gateway) GetGatewayProfileId() string {
	if m != nil {
		return m.GatewayProfileId
	}
	return ""
}

func (m *Gateway) GetBoards() []*GatewayBoard {
	if m != nil {
		return m.Boards
	}
	return nil
}

func (m *Gateway) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Gateway) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type GatewayBoard struct {
	// FPGA ID of the gateway (HEX encoded) (optional).
	FpgaId string `protobuf:"bytes,1,opt,name=fpga_id,json=fpgaID,proto3" json:"fpga_id,omitempty"`
	// Fine-timestamp AES decryption key (HEX encoded) (optional).
	FineTimestampKey     string   `protobuf:"bytes,2,opt,name=fine_timestamp_key,json=fineTimestampKey,proto3" json:"fine_timestamp_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GatewayBoard) Reset()         { *m = GatewayBoard{} }
func (m *GatewayBoard) String() string { return proto.CompactTextString(m) }
func (*GatewayBoard) ProtoMessage()    {}
func (*GatewayBoard) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{1}
}

func (m *GatewayBoard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayBoard.Unmarshal(m, b)
}
func (m *GatewayBoard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayBoard.Marshal(b, m, deterministic)
}
func (m *GatewayBoard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayBoard.Merge(m, src)
}
func (m *GatewayBoard) XXX_Size() int {
	return xxx_messageInfo_GatewayBoard.Size(m)
}
func (m *GatewayBoard) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayBoard.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayBoard proto.InternalMessageInfo

func (m *GatewayBoard) GetFpgaId() string {
	if m != nil {
		return m.FpgaId
	}
	return ""
}

func (m *GatewayBoard) GetFineTimestampKey() string {
	if m != nil {
		return m.FineTimestampKey
	}
	return ""
}

type CreateGatewayRequest struct {
	// Gateway object to create.
	Gateway              *Gateway `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateGatewayRequest) Reset()         { *m = CreateGatewayRequest{} }
func (m *CreateGatewayRequest) String() string { return proto.CompactTextString(m) }
func (*CreateGatewayRequest) ProtoMessage()    {}
func (*CreateGatewayRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{2}
}

func (m *CreateGatewayRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateGatewayRequest.Unmarshal(m, b)
}
func (m *CreateGatewayRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateGatewayRequest.Marshal(b, m, deterministic)
}
func (m *CreateGatewayRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateGatewayRequest.Merge(m, src)
}
func (m *CreateGatewayRequest) XXX_Size() int {
	return xxx_messageInfo_CreateGatewayRequest.Size(m)
}
func (m *CreateGatewayRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateGatewayRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateGatewayRequest proto.InternalMessageInfo

func (m *CreateGatewayRequest) GetGateway() *Gateway {
	if m != nil {
		return m.Gateway
	}
	return nil
}

type GetGatewayRequest struct {
	// Gateway ID (HEX encoded).
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGatewayRequest) Reset()         { *m = GetGatewayRequest{} }
func (m *GetGatewayRequest) String() string { return proto.CompactTextString(m) }
func (*GetGatewayRequest) ProtoMessage()    {}
func (*GetGatewayRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{3}
}

func (m *GetGatewayRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGatewayRequest.Unmarshal(m, b)
}
func (m *GetGatewayRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGatewayRequest.Marshal(b, m, deterministic)
}
func (m *GetGatewayRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGatewayRequest.Merge(m, src)
}
func (m *GetGatewayRequest) XXX_Size() int {
	return xxx_messageInfo_GetGatewayRequest.Size(m)
}
func (m *GetGatewayRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGatewayRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGatewayRequest proto.InternalMessageInfo

func (m *GetGatewayRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type GetGatewayResponse struct {
	// Gateway object.
	Gateway *Gateway `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// First seen at timestamp.
	FirstSeenAt *timestamp.Timestamp `protobuf:"bytes,4,opt,name=first_seen_at,json=firstSeenAt,proto3" json:"first_seen_at,omitempty"`
	// Last seen at timestamp.
	LastSeenAt           *timestamp.Timestamp `protobuf:"bytes,5,opt,name=last_seen_at,json=lastSeenAt,proto3" json:"last_seen_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetGatewayResponse) Reset()         { *m = GetGatewayResponse{} }
func (m *GetGatewayResponse) String() string { return proto.CompactTextString(m) }
func (*GetGatewayResponse) ProtoMessage()    {}
func (*GetGatewayResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{4}
}

func (m *GetGatewayResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGatewayResponse.Unmarshal(m, b)
}
func (m *GetGatewayResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGatewayResponse.Marshal(b, m, deterministic)
}
func (m *GetGatewayResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGatewayResponse.Merge(m, src)
}
func (m *GetGatewayResponse) XXX_Size() int {
	return xxx_messageInfo_GetGatewayResponse.Size(m)
}
func (m *GetGatewayResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGatewayResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetGatewayResponse proto.InternalMessageInfo

func (m *GetGatewayResponse) GetGateway() *Gateway {
	if m != nil {
		return m.Gateway
	}
	return nil
}

func (m *GetGatewayResponse) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *GetGatewayResponse) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *GetGatewayResponse) GetFirstSeenAt() *timestamp.Timestamp {
	if m != nil {
		return m.FirstSeenAt
	}
	return nil
}

func (m *GetGatewayResponse) GetLastSeenAt() *timestamp.Timestamp {
	if m != nil {
		return m.LastSeenAt
	}
	return nil
}

type DeleteGatewayRequest struct {
	// Gateway ID (HEX encoded).
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteGatewayRequest) Reset()         { *m = DeleteGatewayRequest{} }
func (m *DeleteGatewayRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteGatewayRequest) ProtoMessage()    {}
func (*DeleteGatewayRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{5}
}

func (m *DeleteGatewayRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteGatewayRequest.Unmarshal(m, b)
}
func (m *DeleteGatewayRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteGatewayRequest.Marshal(b, m, deterministic)
}
func (m *DeleteGatewayRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteGatewayRequest.Merge(m, src)
}
func (m *DeleteGatewayRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteGatewayRequest.Size(m)
}
func (m *DeleteGatewayRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteGatewayRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteGatewayRequest proto.InternalMessageInfo

func (m *DeleteGatewayRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type ListGatewayRequest struct {
	// Max number of nodes to return in the result-set.
	Limit int32 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset of the result-set (for pagination).
	Offset int32 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// ID of the organization for which to filter on, when left blank the
	// response will return all gateways to which the user has access to.
	OrganizationId int64 `protobuf:"varint,3,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Search on name or gateway MAC (optional).
	Search               string   `protobuf:"bytes,4,opt,name=search,proto3" json:"search,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGatewayRequest) Reset()         { *m = ListGatewayRequest{} }
func (m *ListGatewayRequest) String() string { return proto.CompactTextString(m) }
func (*ListGatewayRequest) ProtoMessage()    {}
func (*ListGatewayRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{6}
}

func (m *ListGatewayRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGatewayRequest.Unmarshal(m, b)
}
func (m *ListGatewayRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGatewayRequest.Marshal(b, m, deterministic)
}
func (m *ListGatewayRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGatewayRequest.Merge(m, src)
}
func (m *ListGatewayRequest) XXX_Size() int {
	return xxx_messageInfo_ListGatewayRequest.Size(m)
}
func (m *ListGatewayRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGatewayRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListGatewayRequest proto.InternalMessageInfo

func (m *ListGatewayRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListGatewayRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListGatewayRequest) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *ListGatewayRequest) GetSearch() string {
	if m != nil {
		return m.Search
	}
	return ""
}

type GatewayListItem struct {
	// Gateway ID (HEX encoded).
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A name for the gateway
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// A description for the gateway
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Create timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// First seen timestamp.
	FirstSeenAt *timestamp.Timestamp `protobuf:"bytes,8,opt,name=first_seen_at,json=firstSeenAt,proto3" json:"first_seen_at,omitempty"`
	// Last seen timestamp.
	LastSeenAt *timestamp.Timestamp `protobuf:"bytes,9,opt,name=last_seen_at,json=lastSeenAt,proto3" json:"last_seen_at,omitempty"`
	// Organization ID.
	OrganizationId int64 `protobuf:"varint,6,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Network-server ID.
	NetworkServerId int64 `protobuf:"varint,7,opt,name=network_server_id,json=networkServerID,proto3" json:"network_server_id,omitempty"`
	// Location.
	Location             *common.Location `protobuf:"bytes,10,opt,name=location,proto3" json:"location,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GatewayListItem) Reset()         { *m = GatewayListItem{} }
func (m *GatewayListItem) String() string { return proto.CompactTextString(m) }
func (*GatewayListItem) ProtoMessage()    {}
func (*GatewayListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{7}
}

func (m *GatewayListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayListItem.Unmarshal(m, b)
}
func (m *GatewayListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayListItem.Marshal(b, m, deterministic)
}
func (m *GatewayListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayListItem.Merge(m, src)
}
func (m *GatewayListItem) XXX_Size() int {
	return xxx_messageInfo_GatewayListItem.Size(m)
}
func (m *GatewayListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayListItem.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayListItem proto.InternalMessageInfo

func (m *GatewayListItem) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *GatewayListItem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GatewayListItem) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *GatewayListItem) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *GatewayListItem) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *GatewayListItem) GetFirstSeenAt() *timestamp.Timestamp {
	if m != nil {
		return m.FirstSeenAt
	}
	return nil
}

func (m *GatewayListItem) GetLastSeenAt() *timestamp.Timestamp {
	if m != nil {
		return m.LastSeenAt
	}
	return nil
}

func (m *GatewayListItem) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *GatewayListItem) GetNetworkServerId() int64 {
	if m != nil {
		return m.NetworkServerId
	}
	return 0
}

func (m *GatewayListItem) GetLocation() *common.Location {
	if m != nil {
		return m.Location
	}
	return nil
}

type ListGatewayResponse struct {
	// Total number of nodes available within the result-set.
	TotalCount int64 `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Nodes within this result-set.
	Result               []*GatewayListItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListGatewayResponse) Reset()         { *m = ListGatewayResponse{} }
func (m *ListGatewayResponse) String() string { return proto.CompactTextString(m) }
func (*ListGatewayResponse) ProtoMessage()    {}
func (*ListGatewayResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{8}
}

func (m *ListGatewayResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGatewayResponse.Unmarshal(m, b)
}
func (m *ListGatewayResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGatewayResponse.Marshal(b, m, deterministic)
}
func (m *ListGatewayResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGatewayResponse.Merge(m, src)
}
func (m *ListGatewayResponse) XXX_Size() int {
	return xxx_messageInfo_ListGatewayResponse.Size(m)
}
func (m *ListGatewayResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGatewayResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListGatewayResponse proto.InternalMessageInfo

func (m *ListGatewayResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ListGatewayResponse) GetResult() []*GatewayListItem {
	if m != nil {
		return m.Result
	}
	return nil
}

type UpdateGatewayRequest struct {
	// Gateway object to update.
	Gateway              *Gateway `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateGatewayRequest) Reset()         { *m = UpdateGatewayRequest{} }
func (m *UpdateGatewayRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateGatewayRequest) ProtoMessage()    {}
func (*UpdateGatewayRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{9}
}

func (m *UpdateGatewayRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateGatewayRequest.Unmarshal(m, b)
}
func (m *UpdateGatewayRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateGatewayRequest.Marshal(b, m, deterministic)
}
func (m *UpdateGatewayRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateGatewayRequest.Merge(m, src)
}
func (m *UpdateGatewayRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateGatewayRequest.Size(m)
}
func (m *UpdateGatewayRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateGatewayRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateGatewayRequest proto.InternalMessageInfo

func (m *UpdateGatewayRequest) GetGateway() *Gateway {
	if m != nil {
		return m.Gateway
	}
	return nil
}

type GatewayStats struct {
	// Timestamp of the (aggregated) measurement.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Packets received by the gateway.
	RxPacketsReceived int32 `protobuf:"varint,2,opt,name=rx_packets_received,json=rxPacketsReceived,proto3" json:"rx_packets_received,omitempty"`
	// Packets received by the gateway that passed the CRC check.
	RxPacketsReceivedOk int32 `protobuf:"varint,3,opt,name=rx_packets_received_ok,json=rxPacketsReceivedOK,proto3" json:"rx_packets_received_ok,omitempty"`
	// Packets received by the gateway for transmission.
	TxPacketsReceived int32 `protobuf:"varint,4,opt,name=tx_packets_received,json=txPacketsReceived,proto3" json:"tx_packets_received,omitempty"`
	// Packets transmitted by the gateway.
	TxPacketsEmitted     int32    `protobuf:"varint,5,opt,name=tx_packets_emitted,json=txPacketsEmitted,proto3" json:"tx_packets_emitted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GatewayStats) Reset()         { *m = GatewayStats{} }
func (m *GatewayStats) String() string { return proto.CompactTextString(m) }
func (*GatewayStats) ProtoMessage()    {}
func (*GatewayStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{10}
}

func (m *GatewayStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayStats.Unmarshal(m, b)
}
func (m *GatewayStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayStats.Marshal(b, m, deterministic)
}
func (m *GatewayStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayStats.Merge(m, src)
}
func (m *GatewayStats) XXX_Size() int {
	return xxx_messageInfo_GatewayStats.Size(m)
}
func (m *GatewayStats) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayStats.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayStats proto.InternalMessageInfo

func (m *GatewayStats) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *GatewayStats) GetRxPacketsReceived() int32 {
	if m != nil {
		return m.RxPacketsReceived
	}
	return 0
}

func (m *GatewayStats) GetRxPacketsReceivedOk() int32 {
	if m != nil {
		return m.RxPacketsReceivedOk
	}
	return 0
}

func (m *GatewayStats) GetTxPacketsReceived() int32 {
	if m != nil {
		return m.TxPacketsReceived
	}
	return 0
}

func (m *GatewayStats) GetTxPacketsEmitted() int32 {
	if m != nil {
		return m.TxPacketsEmitted
	}
	return 0
}

type GetGatewayStatsRequest struct {
	// Gateway ID (HEX encoded).
	GatewayId string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// Aggregation interval.  One of "second", "minute", "hour", "day", "week",
	// "month", "quarter", "year".  Case insensitive.
	Interval string `protobuf:"bytes,2,opt,name=interval,proto3" json:"interval,omitempty"`
	// Timestamp to start from.
	StartTimestamp *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
	// Timestamp until to get from.
	EndTimestamp         *timestamp.Timestamp `protobuf:"bytes,4,opt,name=end_timestamp,json=endTimestamp,proto3" json:"end_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetGatewayStatsRequest) Reset()         { *m = GetGatewayStatsRequest{} }
func (m *GetGatewayStatsRequest) String() string { return proto.CompactTextString(m) }
func (*GetGatewayStatsRequest) ProtoMessage()    {}
func (*GetGatewayStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{11}
}

func (m *GetGatewayStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGatewayStatsRequest.Unmarshal(m, b)
}
func (m *GetGatewayStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGatewayStatsRequest.Marshal(b, m, deterministic)
}
func (m *GetGatewayStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGatewayStatsRequest.Merge(m, src)
}
func (m *GetGatewayStatsRequest) XXX_Size() int {
	return xxx_messageInfo_GetGatewayStatsRequest.Size(m)
}
func (m *GetGatewayStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGatewayStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGatewayStatsRequest proto.InternalMessageInfo

func (m *GetGatewayStatsRequest) GetGatewayId() string {
	if m != nil {
		return m.GatewayId
	}
	return ""
}

func (m *GetGatewayStatsRequest) GetInterval() string {
	if m != nil {
		return m.Interval
	}
	return ""
}

func (m *GetGatewayStatsRequest) GetStartTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.StartTimestamp
	}
	return nil
}

func (m *GetGatewayStatsRequest) GetEndTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.EndTimestamp
	}
	return nil
}

type GetGatewayStatsResponse struct {
	Result               []*GatewayStats `protobuf:"bytes,1,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *GetGatewayStatsResponse) Reset()         { *m = GetGatewayStatsResponse{} }
func (m *GetGatewayStatsResponse) String() string { return proto.CompactTextString(m) }
func (*GetGatewayStatsResponse) ProtoMessage()    {}
func (*GetGatewayStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{12}
}

func (m *GetGatewayStatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGatewayStatsResponse.Unmarshal(m, b)
}
func (m *GetGatewayStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGatewayStatsResponse.Marshal(b, m, deterministic)
}
func (m *GetGatewayStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGatewayStatsResponse.Merge(m, src)
}
func (m *GetGatewayStatsResponse) XXX_Size() int {
	return xxx_messageInfo_GetGatewayStatsResponse.Size(m)
}
func (m *GetGatewayStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGatewayStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetGatewayStatsResponse proto.InternalMessageInfo

func (m *GetGatewayStatsResponse) GetResult() []*GatewayStats {
	if m != nil {
		return m.Result
	}
	return nil
}

type PingRX struct {
	// Gateway ID (HEX encoded).
	GatewayId string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// RSSI.
	Rssi int32 `protobuf:"varint,2,opt,name=rssi,proto3" json:"rssi,omitempty"`
	// LoRa SNR.
	LoraSnr float64 `protobuf:"fixed64,3,opt,name=lora_snr,json=loRaSNR,proto3" json:"lora_snr,omitempty"`
	// Latitude of the gateway -90.0 to 90.0.
	Latitude float64 `protobuf:"fixed64,4,opt,name=latitude,proto3" json:"latitude,omitempty"`
	// Longitude of the gateway -180.0 to 180.0.
	Longitude float64 `protobuf:"fixed64,5,opt,name=longitude,proto3" json:"longitude,omitempty"`
	// Altitude of the gateway in meters.
	Altitude             float64  `protobuf:"fixed64,6,opt,name=altitude,proto3" json:"altitude,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PingRX) Reset()         { *m = PingRX{} }
func (m *PingRX) String() string { return proto.CompactTextString(m) }
func (*PingRX) ProtoMessage()    {}
func (*PingRX) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{13}
}

func (m *PingRX) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PingRX.Unmarshal(m, b)
}
func (m *PingRX) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PingRX.Marshal(b, m, deterministic)
}
func (m *PingRX) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingRX.Merge(m, src)
}
func (m *PingRX) XXX_Size() int {
	return xxx_messageInfo_PingRX.Size(m)
}
func (m *PingRX) XXX_DiscardUnknown() {
	xxx_messageInfo_PingRX.DiscardUnknown(m)
}

var xxx_messageInfo_PingRX proto.InternalMessageInfo

func (m *PingRX) GetGatewayId() string {
	if m != nil {
		return m.GatewayId
	}
	return ""
}

func (m *PingRX) GetRssi() int32 {
	if m != nil {
		return m.Rssi
	}
	return 0
}

func (m *PingRX) GetLoraSnr() float64 {
	if m != nil {
		return m.LoraSnr
	}
	return 0
}

func (m *PingRX) GetLatitude() float64 {
	if m != nil {
		return m.Latitude
	}
	return 0
}

func (m *PingRX) GetLongitude() float64 {
	if m != nil {
		return m.Longitude
	}
	return 0
}

func (m *PingRX) GetAltitude() float64 {
	if m != nil {
		return m.Altitude
	}
	return 0
}

type GetLastPingRequest struct {
	// Gateway ID (HEX encoded).
	GatewayId            string   `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLastPingRequest) Reset()         { *m = GetLastPingRequest{} }
func (m *GetLastPingRequest) String() string { return proto.CompactTextString(m) }
func (*GetLastPingRequest) ProtoMessage()    {}
func (*GetLastPingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{14}
}

func (m *GetLastPingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetLastPingRequest.Unmarshal(m, b)
}
func (m *GetLastPingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetLastPingRequest.Marshal(b, m, deterministic)
}
func (m *GetLastPingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLastPingRequest.Merge(m, src)
}
func (m *GetLastPingRequest) XXX_Size() int {
	return xxx_messageInfo_GetLastPingRequest.Size(m)
}
func (m *GetLastPingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLastPingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLastPingRequest proto.InternalMessageInfo

func (m *GetLastPingRequest) GetGatewayId() string {
	if m != nil {
		return m.GatewayId
	}
	return ""
}

type GetLastPingResponse struct {
	// Created at timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,1,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Frequency (Hz).
	Frequency uint32 `protobuf:"varint,2,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Data-rate.
	Dr uint32 `protobuf:"varint,3,opt,name=dr,proto3" json:"dr,omitempty"`
	// Gateways and meta-data of reception.
	PingRx               []*PingRX `protobuf:"bytes,4,rep,name=ping_rx,json=pingRX,proto3" json:"ping_rx,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GetLastPingResponse) Reset()         { *m = GetLastPingResponse{} }
func (m *GetLastPingResponse) String() string { return proto.CompactTextString(m) }
func (*GetLastPingResponse) ProtoMessage()    {}
func (*GetLastPingResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{15}
}

func (m *GetLastPingResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetLastPingResponse.Unmarshal(m, b)
}
func (m *GetLastPingResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetLastPingResponse.Marshal(b, m, deterministic)
}
func (m *GetLastPingResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLastPingResponse.Merge(m, src)
}
func (m *GetLastPingResponse) XXX_Size() int {
	return xxx_messageInfo_GetLastPingResponse.Size(m)
}
func (m *GetLastPingResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLastPingResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetLastPingResponse proto.InternalMessageInfo

func (m *GetLastPingResponse) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *GetLastPingResponse) GetFrequency() uint32 {
	if m != nil {
		return m.Frequency
	}
	return 0
}

func (m *GetLastPingResponse) GetDr() uint32 {
	if m != nil {
		return m.Dr
	}
	return 0
}

func (m *GetLastPingResponse) GetPingRx() []*PingRX {
	if m != nil {
		return m.PingRx
	}
	return nil
}

type StreamGatewayFrameLogsRequest struct {
	// Gateway ID (HEX encoded).
	GatewayId            string   `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamGatewayFrameLogsRequest) Reset()         { *m = StreamGatewayFrameLogsRequest{} }
func (m *StreamGatewayFrameLogsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamGatewayFrameLogsRequest) ProtoMessage()    {}
func (*StreamGatewayFrameLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{16}
}

func (m *StreamGatewayFrameLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamGatewayFrameLogsRequest.Unmarshal(m, b)
}
func (m *StreamGatewayFrameLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamGatewayFrameLogsRequest.Marshal(b, m, deterministic)
}
func (m *StreamGatewayFrameLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamGatewayFrameLogsRequest.Merge(m, src)
}
func (m *StreamGatewayFrameLogsRequest) XXX_Size() int {
	return xxx_messageInfo_StreamGatewayFrameLogsRequest.Size(m)
}
func (m *StreamGatewayFrameLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamGatewayFrameLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamGatewayFrameLogsRequest proto.InternalMessageInfo

func (m *StreamGatewayFrameLogsRequest) GetGatewayId() string {
	if m != nil {
		return m.GatewayId
	}
	return ""
}

type StreamGatewayFrameLogsResponse struct {
	// Types that are valid to be assigned to Frame:
	//	*StreamGatewayFrameLogsResponse_UplinkFrame
	//	*StreamGatewayFrameLogsResponse_DownlinkFrame
	Frame                isStreamGatewayFrameLogsResponse_Frame `protobuf_oneof:"frame"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *StreamGatewayFrameLogsResponse) Reset()         { *m = StreamGatewayFrameLogsResponse{} }
func (m *StreamGatewayFrameLogsResponse) String() string { return proto.CompactTextString(m) }
func (*StreamGatewayFrameLogsResponse) ProtoMessage()    {}
func (*StreamGatewayFrameLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f909ac54118d345f, []int{17}
}

func (m *StreamGatewayFrameLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamGatewayFrameLogsResponse.Unmarshal(m, b)
}
func (m *StreamGatewayFrameLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamGatewayFrameLogsResponse.Marshal(b, m, deterministic)
}
func (m *StreamGatewayFrameLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamGatewayFrameLogsResponse.Merge(m, src)
}
func (m *StreamGatewayFrameLogsResponse) XXX_Size() int {
	return xxx_messageInfo_StreamGatewayFrameLogsResponse.Size(m)
}
func (m *StreamGatewayFrameLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamGatewayFrameLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamGatewayFrameLogsResponse proto.InternalMessageInfo

type isStreamGatewayFrameLogsResponse_Frame interface {
	isStreamGatewayFrameLogsResponse_Frame()
}

type StreamGatewayFrameLogsResponse_UplinkFrame struct {
	UplinkFrame *UplinkFrameLog `protobuf:"bytes,1,opt,name=uplink_frame,json=uplinkFrame,proto3,oneof"`
}

type StreamGatewayFrameLogsResponse_DownlinkFrame struct {
	DownlinkFrame *DownlinkFrameLog `protobuf:"bytes,2,opt,name=downlink_frame,json=downlinkFrame,proto3,oneof"`
}

func (*StreamGatewayFrameLogsResponse_UplinkFrame) isStreamGatewayFrameLogsResponse_Frame() {}

func (*StreamGatewayFrameLogsResponse_DownlinkFrame) isStreamGatewayFrameLogsResponse_Frame() {}

func (m *StreamGatewayFrameLogsResponse) GetFrame() isStreamGatewayFrameLogsResponse_Frame {
	if m != nil {
		return m.Frame
	}
	return nil
}

func (m *StreamGatewayFrameLogsResponse) GetUplinkFrame() *UplinkFrameLog {
	if x, ok := m.GetFrame().(*StreamGatewayFrameLogsResponse_UplinkFrame); ok {
		return x.UplinkFrame
	}
	return nil
}

func (m *StreamGatewayFrameLogsResponse) GetDownlinkFrame() *DownlinkFrameLog {
	if x, ok := m.GetFrame().(*StreamGatewayFrameLogsResponse_DownlinkFrame); ok {
		return x.DownlinkFrame
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StreamGatewayFrameLogsResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StreamGatewayFrameLogsResponse_UplinkFrame)(nil),
		(*StreamGatewayFrameLogsResponse_DownlinkFrame)(nil),
	}
}

func init() {
	proto.RegisterType((*Gateway)(nil), "api.Gateway")
	proto.RegisterMapType((map[string]string)(nil), "api.Gateway.MetadataEntry")
	proto.RegisterMapType((map[string]string)(nil), "api.Gateway.TagsEntry")
	proto.RegisterType((*GatewayBoard)(nil), "api.GatewayBoard")
	proto.RegisterType((*CreateGatewayRequest)(nil), "api.CreateGatewayRequest")
	proto.RegisterType((*GetGatewayRequest)(nil), "api.GetGatewayRequest")
	proto.RegisterType((*GetGatewayResponse)(nil), "api.GetGatewayResponse")
	proto.RegisterType((*DeleteGatewayRequest)(nil), "api.DeleteGatewayRequest")
	proto.RegisterType((*ListGatewayRequest)(nil), "api.ListGatewayRequest")
	proto.RegisterType((*GatewayListItem)(nil), "api.GatewayListItem")
	proto.RegisterType((*ListGatewayResponse)(nil), "api.ListGatewayResponse")
	proto.RegisterType((*UpdateGatewayRequest)(nil), "api.UpdateGatewayRequest")
	proto.RegisterType((*GatewayStats)(nil), "api.GatewayStats")
	proto.RegisterType((*GetGatewayStatsRequest)(nil), "api.GetGatewayStatsRequest")
	proto.RegisterType((*GetGatewayStatsResponse)(nil), "api.GetGatewayStatsResponse")
	proto.RegisterType((*PingRX)(nil), "api.PingRX")
	proto.RegisterType((*GetLastPingRequest)(nil), "api.GetLastPingRequest")
	proto.RegisterType((*GetLastPingResponse)(nil), "api.GetLastPingResponse")
	proto.RegisterType((*StreamGatewayFrameLogsRequest)(nil), "api.StreamGatewayFrameLogsRequest")
	proto.RegisterType((*StreamGatewayFrameLogsResponse)(nil), "api.StreamGatewayFrameLogsResponse")
}

func init() { proto.RegisterFile("as/external/api/gateway.proto", fileDescriptor_f909ac54118d345f) }

var fileDescriptor_f909ac54118d345f = []byte{
	// 1467 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0x4b, 0x73, 0xdc, 0xc4,
	0x13, 0xff, 0x6b, 0x1f, 0xb2, 0xb7, 0xd7, 0xcf, 0xb1, 0xe3, 0x6c, 0x14, 0x27, 0xf1, 0x5f, 0x21,
	0x89, 0x63, 0x9c, 0x5d, 0xca, 0xae, 0x22, 0x0f, 0x28, 0x53, 0x49, 0x6c, 0x8c, 0x2b, 0x06, 0x5c,
	0x72, 0x5c, 0x50, 0x5c, 0x54, 0x63, 0x69, 0x76, 0x33, 0x65, 0xad, 0x24, 0x66, 0x66, 0x1d, 0x1b,
	0x2a, 0x17, 0x38, 0x70, 0xe0, 0xc8, 0x47, 0x80, 0x23, 0x07, 0x8a, 0x03, 0x1f, 0x83, 0x0b, 0x27,
	0xee, 0x7c, 0x10, 0x6a, 0x1e, 0x2b, 0x6b, 0x1f, 0xf1, 0x23, 0xe1, 0xb4, 0x3b, 0xdd, 0xfd, 0xeb,
	0xee, 0xe9, 0xd7, 0xb4, 0xe0, 0x1a, 0xe6, 0x0d, 0x72, 0x24, 0x08, 0x8b, 0x71, 0xd4, 0xc0, 0x29,
	0x6d, 0xb4, 0xb0, 0x20, 0x2f, 0xf1, 0x71, 0x3d, 0x65, 0x89, 0x48, 0x50, 0x11, 0xa7, 0xd4, 0x99,
	0x6f, 0x25, 0x49, 0x2b, 0x22, 0x8a, 0x8d, 0xe3, 0x38, 0x11, 0x58, 0xd0, 0x24, 0xe6, 0x5a, 0xc4,
	0xb9, 0x61, 0xb8, 0xea, 0xb4, 0xdf, 0x69, 0x36, 0x04, 0x6d, 0x13, 0x2e, 0x70, 0x3b, 0x35, 0x02,
	0x57, 0xfb, 0x05, 0x48, 0x3b, 0x15, 0xc6, 0x80, 0x33, 0x13, 0x24, 0xed, 0x76, 0x12, 0x37, 0xf4,
	0x8f, 0x21, 0x5e, 0xef, 0x77, 0xaa, 0xc9, 0x70, 0x9b, 0x6c, 0x27, 0x2d, 0xcd, 0x77, 0x7f, 0x2f,
	0xc1, 0xc8, 0xa6, 0xf6, 0x13, 0x4d, 0x40, 0x81, 0x86, 0x35, 0x6b, 0xc1, 0x5a, 0xac, 0x78, 0x05,
	0x1a, 0x22, 0x04, 0xa5, 0x18, 0xb7, 0x49, 0xad, 0xa0, 0x28, 0xea, 0x3f, 0x5a, 0x80, 0x6a, 0x48,
	0x78, 0xc0, 0x68, 0x2a, 0x1d, 0xaf, 0x15, 0x15, 0x2b, 0x4f, 0x42, 0xcb, 0x30, 0x1a, 0x25, 0x81,
	0xba, 0x57, 0xad, 0xb4, 0x60, 0x2d, 0x56, 0x57, 0xa6, 0xea, 0xc6, 0xa5, 0x6d, 0x43, 0xf7, 0x32,
	0x09, 0x74, 0x07, 0x26, 0x13, 0xd6, 0xc2, 0x31, 0xfd, 0x46, 0x9d, 0x7d, 0x1a, 0xd6, 0xca, 0x0b,
	0xd6, 0x62, 0xd1, 0x9b, 0xc8, 0x93, 0xb7, 0xd6, 0xd1, 0xbb, 0x30, 0x1d, 0x52, 0x1e, 0x24, 0x87,
	0x84, 0x1d, 0xfb, 0x24, 0xc6, 0xfb, 0x11, 0x09, 0x6b, 0xf6, 0x82, 0xb5, 0x38, 0xea, 0x4d, 0x65,
	0x8c, 0x0d, 0x4d, 0x47, 0x4b, 0x30, 0x1d, 0x13, 0xf1, 0x32, 0x61, 0x07, 0x3e, 0x27, 0xec, 0x90,
	0x30, 0xa9, 0x77, 0x44, 0xe9, 0x9d, 0x34, 0x8c, 0x5d, 0x45, 0xdf, 0x5a, 0x47, 0xcb, 0x80, 0x4c,
	0xa2, 0xfc, 0x94, 0x25, 0x4d, 0x1a, 0x11, 0x29, 0x3c, 0xaa, 0x2e, 0x36, 0x65, 0x38, 0x3b, 0x9a,
	0xb1, 0xb5, 0x8e, 0xee, 0x82, 0xbd, 0x9f, 0x60, 0x16, 0xf2, 0x5a, 0x65, 0xa1, 0xb8, 0x58, 0x5d,
	0x99, 0xae, 0xe3, 0x94, 0xd6, 0x4d, 0x04, 0x9f, 0x48, 0x8e, 0x67, 0x04, 0xd0, 0x12, 0x94, 0x04,
	0x6e, 0xf1, 0x1a, 0x28, 0xc1, 0xb9, 0xbc, 0x60, 0xfd, 0x39, 0x6e, 0xf1, 0x8d, 0x58, 0xb0, 0x63,
	0x4f, 0xc9, 0xa0, 0xf7, 0x61, 0xb4, 0x4d, 0x04, 0x0e, 0xb1, 0xc0, 0xb5, 0xaa, 0x92, 0x77, 0x7a,
	0xe4, 0x3f, 0x35, 0x4c, 0x8d, 0xc9, 0x64, 0x9d, 0xfb, 0x50, 0xc9, 0x54, 0xa1, 0x29, 0x28, 0x1e,
	0x90, 0x63, 0x93, 0x40, 0xf9, 0x17, 0xcd, 0x42, 0xf9, 0x10, 0x47, 0x9d, 0x6e, 0x0a, 0xf5, 0xe1,
	0x51, 0xe1, 0x81, 0xe5, 0x7c, 0x00, 0xe3, 0x3d, 0x3a, 0x2f, 0x02, 0x76, 0xf7, 0x60, 0x2c, 0x7f,
	0x63, 0x74, 0x19, 0x46, 0x9a, 0x69, 0x0b, 0xfb, 0x59, 0xf5, 0xd8, 0xf2, 0xa8, 0x63, 0xdb, 0xa4,
	0x31, 0xf1, 0xb3, 0x3a, 0xf6, 0xa5, 0x0d, 0xad, 0x6f, 0x4a, 0x72, 0x9e, 0x77, 0x19, 0xcf, 0xc8,
	0xb1, 0xbb, 0x06, 0xb3, 0x4f, 0x19, 0xc1, 0x82, 0x18, 0xe5, 0x1e, 0xf9, 0xba, 0x43, 0xb8, 0x40,
	0xb7, 0x61, 0xc4, 0xe4, 0x41, 0xa9, 0xaf, 0xae, 0x8c, 0xe5, 0x63, 0xe3, 0x75, 0x99, 0xee, 0x4d,
	0x98, 0xde, 0x24, 0xa2, 0x0f, 0xdc, 0x57, 0xd4, 0xee, 0x6f, 0x05, 0x40, 0x79, 0x29, 0x9e, 0x26,
	0x31, 0x27, 0xe7, 0xb5, 0x81, 0x1e, 0x02, 0x04, 0xca, 0xc7, 0xd0, 0xc7, 0x42, 0xdd, 0x44, 0xa6,
	0x4a, 0xb7, 0x65, 0xbd, 0xdb, 0x96, 0xf5, 0xec, 0x5a, 0x5e, 0xc5, 0x48, 0x3f, 0x16, 0x12, 0xda,
	0x49, 0xc3, 0x2e, 0xb4, 0x78, 0x36, 0xd4, 0x48, 0x3f, 0x16, 0x68, 0x0d, 0xc6, 0x9b, 0x94, 0x71,
	0xe1, 0x73, 0x42, 0x62, 0x89, 0x2e, 0x9d, 0x89, 0xae, 0x2a, 0xc0, 0x2e, 0x21, 0xf1, 0x63, 0x81,
	0x3e, 0x84, 0xb1, 0x08, 0xe7, 0xe0, 0xe5, 0x33, 0xe1, 0x20, 0xe5, 0x35, 0xda, 0xbd, 0x0d, 0xb3,
	0xeb, 0x24, 0x22, 0x03, 0x79, 0xe9, 0x0f, 0xed, 0xf7, 0x16, 0xa0, 0x6d, 0xca, 0xfb, 0x33, 0x30,
	0x0b, 0xe5, 0x88, 0xb6, 0xa9, 0x50, 0x92, 0x65, 0x4f, 0x1f, 0xd0, 0x1c, 0xd8, 0x49, 0xb3, 0xc9,
	0x89, 0x0e, 0x62, 0xd9, 0x33, 0xa7, 0x61, 0x03, 0xa1, 0x38, 0x74, 0x20, 0xcc, 0x81, 0xcd, 0x09,
	0x66, 0xc1, 0x0b, 0x15, 0x8c, 0x8a, 0x67, 0x4e, 0xee, 0x9f, 0x45, 0x98, 0x34, 0x1e, 0x48, 0x67,
	0xb6, 0x04, 0x69, 0xff, 0x47, 0x93, 0xad, 0x37, 0xf7, 0xa5, 0x37, 0xcf, 0x7d, 0xf9, 0xad, 0x72,
	0x3f, 0xfa, 0x76, 0xb9, 0xaf, 0x5c, 0x24, 0xf7, 0xc3, 0xd2, 0x61, 0x0f, 0x4d, 0xc7, 0xc5, 0x46,
	0xee, 0xc9, 0x13, 0x01, 0x67, 0x3d, 0x11, 0x6e, 0x08, 0x33, 0x3d, 0x55, 0x65, 0x3a, 0xf6, 0x06,
	0x54, 0x45, 0x22, 0x70, 0xe4, 0x07, 0x49, 0x27, 0xd6, 0xc5, 0x55, 0xf4, 0x40, 0x91, 0x9e, 0x4a,
	0x0a, 0x5a, 0x06, 0x9b, 0x11, 0xde, 0x89, 0x64, 0x85, 0xc9, 0x89, 0x3a, 0x9b, 0xef, 0xe8, 0x6e,
	0x69, 0x78, 0x46, 0x46, 0x0e, 0x9f, 0x3d, 0x15, 0xf3, 0x37, 0x1c, 0x3e, 0x3f, 0x16, 0xb2, 0xa1,
	0xb8, 0x2b, 0xb0, 0xe0, 0xe8, 0x01, 0x54, 0xb2, 0xb1, 0x67, 0xa0, 0xa7, 0x66, 0x3c, 0x13, 0x46,
	0x75, 0x98, 0x61, 0x47, 0x7e, 0x8a, 0x83, 0x03, 0x22, 0xb8, 0xcf, 0x48, 0x40, 0xe8, 0x21, 0x09,
	0x4d, 0x9f, 0x4c, 0xb3, 0xa3, 0x1d, 0xcd, 0xf1, 0x0c, 0x03, 0xad, 0xc2, 0xdc, 0x10, 0x79, 0x3f,
	0x39, 0x50, 0x45, 0x5c, 0xf6, 0x66, 0x06, 0x20, 0x9f, 0x3f, 0x93, 0x46, 0xc4, 0x10, 0x23, 0x25,
	0x6d, 0x44, 0x0c, 0x18, 0x59, 0x06, 0x94, 0x93, 0x27, 0x6d, 0x2a, 0x04, 0xd1, 0x6f, 0x75, 0xd9,
	0x9b, 0xca, 0xc4, 0x37, 0x34, 0xdd, 0xfd, 0xdb, 0x82, 0xb9, 0x93, 0x29, 0xab, 0x02, 0xd2, 0x0d,
	0xe8, 0x35, 0x80, 0xee, 0x7b, 0x9b, 0xf5, 0x64, 0xc5, 0x50, 0xb6, 0xd6, 0x91, 0x03, 0xa3, 0x34,
	0x16, 0x84, 0x1d, 0xe2, 0xc8, 0xb4, 0x67, 0x76, 0x46, 0x4f, 0x61, 0x92, 0x0b, 0xcc, 0xc4, 0xc9,
	0x7b, 0x72, 0x8e, 0x31, 0x3a, 0xa1, 0x20, 0xd9, 0x19, 0x7d, 0x04, 0xe3, 0x24, 0x0e, 0x73, 0x2a,
	0xce, 0x6e, 0xe4, 0x31, 0x12, 0x87, 0xd9, 0xc9, 0x5d, 0x87, 0xcb, 0x03, 0x57, 0x33, 0x35, 0x79,
	0x37, 0x2b, 0x39, 0x6b, 0x70, 0x3b, 0xd0, 0xa2, 0xdd, 0x7a, 0xfb, 0xd5, 0x02, 0x7b, 0x87, 0xc6,
	0x2d, 0xef, 0xcb, 0xb3, 0x22, 0x82, 0xa0, 0xc4, 0x38, 0xa7, 0x26, 0xff, 0xea, 0x3f, 0xba, 0x22,
	0x3b, 0x88, 0x61, 0x9f, 0xc7, 0x4c, 0x85, 0xc0, 0xf2, 0x46, 0xa2, 0xc4, 0xc3, 0xbb, 0x9f, 0x79,
	0x32, 0x80, 0x11, 0x16, 0x54, 0x74, 0x42, 0xa2, 0xae, 0x66, 0x79, 0xd9, 0x19, 0xcd, 0x43, 0x25,
	0x4a, 0xe2, 0x96, 0x66, 0x96, 0x15, 0xf3, 0x84, 0x20, 0x91, 0x38, 0x32, 0x48, 0x5b, 0x23, 0xbb,
	0x67, 0x77, 0x55, 0xbd, 0x9a, 0xdb, 0x98, 0x0b, 0xe5, 0xf4, 0xb9, 0x72, 0xe9, 0xfe, 0x62, 0xc1,
	0x4c, 0x0f, 0xca, 0x84, 0xa9, 0x77, 0x90, 0x5a, 0x17, 0x19, 0xa4, 0xf3, 0x50, 0x69, 0x32, 0x69,
	0x3d, 0x0e, 0xf4, 0x22, 0x31, 0xee, 0x9d, 0x10, 0xe4, 0x9c, 0x0f, 0x75, 0x40, 0xc6, 0xbd, 0x42,
	0xc8, 0xd0, 0x3b, 0x30, 0x92, 0xd2, 0xb8, 0xe5, 0xb3, 0xa3, 0x5a, 0x49, 0x25, 0xa4, 0xaa, 0x12,
	0xa2, 0xe3, 0xee, 0xd9, 0xa9, 0xfa, 0x75, 0xd7, 0xe0, 0xda, 0xae, 0x60, 0x04, 0xb7, 0x4d, 0xa2,
	0x3e, 0x36, 0x2b, 0xf2, 0x39, 0x4b, 0xd6, 0xfd, 0xd9, 0x82, 0xeb, 0xaf, 0x53, 0x60, 0x6e, 0xfc,
	0x00, 0xc6, 0x3a, 0x69, 0x44, 0xe3, 0x03, 0x5f, 0xed, 0xdf, 0xe6, 0xce, 0x33, 0xca, 0x9b, 0x3d,
	0xc5, 0xe8, 0x62, 0x3e, 0xf9, 0x9f, 0x57, 0xed, 0x9c, 0x50, 0xd0, 0x1a, 0x4c, 0x84, 0xc9, 0xcb,
	0x38, 0x87, 0xd5, 0x4b, 0xc7, 0x25, 0x85, 0x5d, 0x37, 0xac, 0x1c, 0x7a, 0x3c, 0xcc, 0xd3, 0x9e,
	0x8c, 0x40, 0x59, 0xc1, 0x56, 0xfe, 0xb0, 0x61, 0xa2, 0x5b, 0x89, 0x84, 0x1d, 0xd2, 0x80, 0xa0,
	0x3d, 0xb0, 0xf5, 0xc2, 0x85, 0xae, 0x28, 0x6d, 0xc3, 0xb6, 0x2f, 0x67, 0x6e, 0x20, 0x31, 0x1b,
	0xf2, 0xa3, 0xc3, 0xad, 0x7d, 0xf7, 0xd7, 0x3f, 0x3f, 0x15, 0x90, 0x3b, 0x9e, 0xff, 0xd6, 0xe1,
	0x8f, 0xac, 0x25, 0xe4, 0x41, 0x71, 0x93, 0x08, 0x64, 0x36, 0xde, 0xfe, 0x8d, 0xcc, 0xb9, 0x3c,
	0x40, 0xd7, 0x41, 0x72, 0x1d, 0xa5, 0x71, 0x16, 0xa1, 0x1e, 0x8d, 0x8d, 0x6f, 0x69, 0xf8, 0x0a,
	0xed, 0x83, 0xad, 0xc7, 0xb3, 0x71, 0x75, 0xd8, 0xac, 0x7e, 0xad, 0xab, 0xb7, 0x94, 0xe2, 0x1b,
	0x8e, 0xd3, 0xa7, 0xb8, 0xfb, 0x81, 0x46, 0xc3, 0x57, 0xd2, 0xef, 0x2f, 0xc0, 0xd6, 0x7b, 0x8e,
	0xb1, 0x31, 0x6c, 0xe9, 0x79, 0xad, 0x0d, 0xe3, 0xfc, 0xd2, 0x30, 0xe7, 0x77, 0xa0, 0x24, 0xdf,
	0x1b, 0xa4, 0x6f, 0x3e, 0xb8, 0x22, 0x39, 0xb5, 0x41, 0x86, 0x89, 0xc9, 0x25, 0xa5, 0x76, 0x12,
	0xf5, 0x46, 0x19, 0x25, 0x30, 0xba, 0x49, 0x84, 0x7e, 0x68, 0xae, 0xf6, 0xc5, 0x33, 0x3f, 0x6d,
	0x9d, 0xf9, 0xe1, 0x4c, 0xa3, 0x7d, 0x51, 0x69, 0x77, 0xd1, 0xc2, 0xf0, 0xc0, 0xf8, 0x34, 0x7c,
	0xd5, 0xe0, 0xca, 0x48, 0x02, 0xd5, 0x5c, 0x27, 0xa3, 0x2c, 0x87, 0x7d, 0x13, 0xc1, 0xdc, 0x64,
	0x48, 0xd3, 0xbb, 0xf7, 0x94, 0xad, 0x3b, 0xe8, 0xd6, 0x29, 0xb6, 0x64, 0x43, 0xf2, 0x86, 0x5c,
	0x3f, 0xd0, 0x0f, 0x16, 0x4c, 0xea, 0xa6, 0xca, 0xba, 0x09, 0xb9, 0x4a, 0xf9, 0xa9, 0xbd, 0xea,
	0xdc, 0x3c, 0x55, 0xc6, 0xf8, 0x72, 0x57, 0xf9, 0x72, 0x13, 0xfd, 0xff, 0x14, 0x5f, 0x54, 0xd7,
	0xf0, 0xf7, 0xac, 0x27, 0x0f, 0xbf, 0xba, 0xdf, 0xa2, 0xe2, 0x45, 0x67, 0x5f, 0xee, 0x28, 0x8d,
	0x7d, 0x96, 0x04, 0x18, 0xb3, 0x46, 0xf0, 0x82, 0xb2, 0x94, 0x0b, 0x1c, 0x1c, 0xdc, 0x53, 0x3a,
	0x92, 0xc6, 0xe1, 0x6a, 0xa3, 0xef, 0x63, 0x7b, 0xdf, 0x56, 0x45, 0xb2, 0xfa, 0x6f, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x42, 0xff, 0xb9, 0x51, 0x1b, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// GatewayServiceClient is the client API for GatewayService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GatewayServiceClient interface {
	// Create creates the given gateway.
	Create(ctx context.Context, in *CreateGatewayRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Get returns the gateway for the requested mac address.
	Get(ctx context.Context, in *GetGatewayRequest, opts ...grpc.CallOption) (*GetGatewayResponse, error)
	// Update updates the gateway matching the given mac address.
	Update(ctx context.Context, in *UpdateGatewayRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Delete deletes the gateway matching the given mac address.
	Delete(ctx context.Context, in *DeleteGatewayRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// List lists the gateways.
	List(ctx context.Context, in *ListGatewayRequest, opts ...grpc.CallOption) (*ListGatewayResponse, error)
	// GetStats lists the gateway stats given the query parameters.
	GetStats(ctx context.Context, in *GetGatewayStatsRequest, opts ...grpc.CallOption) (*GetGatewayStatsResponse, error)
	// GetLastPing returns the last emitted ping and gateways receiving this ping.
	GetLastPing(ctx context.Context, in *GetLastPingRequest, opts ...grpc.CallOption) (*GetLastPingResponse, error)
	// StreamFrameLogs streams the uplink and downlink frame-logs for the given gateway ID.
	// Notes:
	//   * These are the raw LoRaWAN frames and this endpoint is intended for debugging only.
	//   * This endpoint does not work from a web-browser.
	StreamFrameLogs(ctx context.Context, in *StreamGatewayFrameLogsRequest, opts ...grpc.CallOption) (GatewayService_StreamFrameLogsClient, error)
}

type gatewayServiceClient struct {
	cc *grpc.ClientConn
}

func NewGatewayServiceClient(cc *grpc.ClientConn) GatewayServiceClient {
	return &gatewayServiceClient{cc}
}

func (c *gatewayServiceClient) Create(ctx context.Context, in *CreateGatewayRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.GatewayService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayServiceClient) Get(ctx context.Context, in *GetGatewayRequest, opts ...grpc.CallOption) (*GetGatewayResponse, error) {
	out := new(GetGatewayResponse)
	err := c.cc.Invoke(ctx, "/api.GatewayService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayServiceClient) Update(ctx context.Context, in *UpdateGatewayRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.GatewayService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayServiceClient) Delete(ctx context.Context, in *DeleteGatewayRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.GatewayService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayServiceClient) List(ctx context.Context, in *ListGatewayRequest, opts ...grpc.CallOption) (*ListGatewayResponse, error) {
	out := new(ListGatewayResponse)
	err := c.cc.Invoke(ctx, "/api.GatewayService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayServiceClient) GetStats(ctx context.Context, in *GetGatewayStatsRequest, opts ...grpc.CallOption) (*GetGatewayStatsResponse, error) {
	out := new(GetGatewayStatsResponse)
	err := c.cc.Invoke(ctx, "/api.GatewayService/GetStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayServiceClient) GetLastPing(ctx context.Context, in *GetLastPingRequest, opts ...grpc.CallOption) (*GetLastPingResponse, error) {
	out := new(GetLastPingResponse)
	err := c.cc.Invoke(ctx, "/api.GatewayService/GetLastPing", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gatewayServiceClient) StreamFrameLogs(ctx context.Context, in *StreamGatewayFrameLogsRequest, opts ...grpc.CallOption) (GatewayService_StreamFrameLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_GatewayService_serviceDesc.Streams[0], "/api.GatewayService/StreamFrameLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &gatewayServiceStreamFrameLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type GatewayService_StreamFrameLogsClient interface {
	Recv() (*StreamGatewayFrameLogsResponse, error)
	grpc.ClientStream
}

type gatewayServiceStreamFrameLogsClient struct {
	grpc.ClientStream
}

func (x *gatewayServiceStreamFrameLogsClient) Recv() (*StreamGatewayFrameLogsResponse, error) {
	m := new(StreamGatewayFrameLogsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GatewayServiceServer is the server API for GatewayService service.
type GatewayServiceServer interface {
	// Create creates the given gateway.
	Create(context.Context, *CreateGatewayRequest) (*empty.Empty, error)
	// Get returns the gateway for the requested mac address.
	Get(context.Context, *GetGatewayRequest) (*GetGatewayResponse, error)
	// Update updates the gateway matching the given mac address.
	Update(context.Context, *UpdateGatewayRequest) (*empty.Empty, error)
	// Delete deletes the gateway matching the given mac address.
	Delete(context.Context, *DeleteGatewayRequest) (*empty.Empty, error)
	// List lists the gateways.
	List(context.Context, *ListGatewayRequest) (*ListGatewayResponse, error)
	// GetStats lists the gateway stats given the query parameters.
	GetStats(context.Context, *GetGatewayStatsRequest) (*GetGatewayStatsResponse, error)
	// GetLastPing returns the last emitted ping and gateways receiving this ping.
	GetLastPing(context.Context, *GetLastPingRequest) (*GetLastPingResponse, error)
	// StreamFrameLogs streams the uplink and downlink frame-logs for the given gateway ID.
	// Notes:
	//   * These are the raw LoRaWAN frames and this endpoint is intended for debugging only.
	//   * This endpoint does not work from a web-browser.
	StreamFrameLogs(*StreamGatewayFrameLogsRequest, GatewayService_StreamFrameLogsServer) error
}

// UnimplementedGatewayServiceServer can be embedded to have forward compatible implementations.
type UnimplementedGatewayServiceServer struct {
}

func (*UnimplementedGatewayServiceServer) Create(ctx context.Context, req *CreateGatewayRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedGatewayServiceServer) Get(ctx context.Context, req *GetGatewayRequest) (*GetGatewayResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedGatewayServiceServer) Update(ctx context.Context, req *UpdateGatewayRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedGatewayServiceServer) Delete(ctx context.Context, req *DeleteGatewayRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedGatewayServiceServer) List(ctx context.Context, req *ListGatewayRequest) (*ListGatewayResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedGatewayServiceServer) GetStats(ctx context.Context, req *GetGatewayStatsRequest) (*GetGatewayStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStats not implemented")
}
func (*UnimplementedGatewayServiceServer) GetLastPing(ctx context.Context, req *GetLastPingRequest) (*GetLastPingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLastPing not implemented")
}
func (*UnimplementedGatewayServiceServer) StreamFrameLogs(req *StreamGatewayFrameLogsRequest, srv GatewayService_StreamFrameLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamFrameLogs not implemented")
}

func RegisterGatewayServiceServer(s *grpc.Server, srv GatewayServiceServer) {
	s.RegisterService(&_GatewayService_serviceDesc, srv)
}

func _GatewayService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.GatewayService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServiceServer).Create(ctx, req.(*CreateGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GatewayService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.GatewayService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServiceServer).Get(ctx, req.(*GetGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GatewayService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.GatewayService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServiceServer).Update(ctx, req.(*UpdateGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GatewayService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.GatewayService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServiceServer).Delete(ctx, req.(*DeleteGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GatewayService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.GatewayService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServiceServer).List(ctx, req.(*ListGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GatewayService_GetStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGatewayStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServiceServer).GetStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.GatewayService/GetStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServiceServer).GetStats(ctx, req.(*GetGatewayStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GatewayService_GetLastPing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLastPingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GatewayServiceServer).GetLastPing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.GatewayService/GetLastPing",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GatewayServiceServer).GetLastPing(ctx, req.(*GetLastPingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GatewayService_StreamFrameLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamGatewayFrameLogsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(GatewayServiceServer).StreamFrameLogs(m, &gatewayServiceStreamFrameLogsServer{stream})
}

type GatewayService_StreamFrameLogsServer interface {
	Send(*StreamGatewayFrameLogsResponse) error
	grpc.ServerStream
}

type gatewayServiceStreamFrameLogsServer struct {
	grpc.ServerStream
}

func (x *gatewayServiceStreamFrameLogsServer) Send(m *StreamGatewayFrameLogsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _GatewayService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.GatewayService",
	HandlerType: (*GatewayServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _GatewayService_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GatewayService_Get_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _GatewayService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _GatewayService_Delete_Handler,
		},
		{
			MethodName: "List",
			Handler:    _GatewayService_List_Handler,
		},
		{
			MethodName: "GetStats",
			Handler:    _GatewayService_GetStats_Handler,
		},
		{
			MethodName: "GetLastPing",
			Handler:    _GatewayService_GetLastPing_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamFrameLogs",
			Handler:       _GatewayService_StreamFrameLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "as/external/api/gateway.proto",
}
