// Code generated by protoc-gen-go. DO NOT EDIT.
// source: as/external/api/internal.proto

package api

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type APIKey struct {
	// API key ID.
	// This value will be automatically generated on create.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Is global admin key.
	IsAdmin bool `protobuf:"varint,3,opt,name=is_admin,json=isAdmin,proto3" json:"is_admin,omitempty"`
	// Organization ID.
	// In case this API key is to manage resources within a single organization
	// set this to the ID of this organization.
	OrganizationId int64 `protobuf:"varint,4,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Application ID.
	// In case the API key is to manage resources within an application, set
	// this to the ID of this application.message
	ApplicationId        int64    `protobuf:"varint,5,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *APIKey) Reset()         { *m = APIKey{} }
func (m *APIKey) String() string { return proto.CompactTextString(m) }
func (*APIKey) ProtoMessage()    {}
func (*APIKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{0}
}

func (m *APIKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_APIKey.Unmarshal(m, b)
}
func (m *APIKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_APIKey.Marshal(b, m, deterministic)
}
func (m *APIKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APIKey.Merge(m, src)
}
func (m *APIKey) XXX_Size() int {
	return xxx_messageInfo_APIKey.Size(m)
}
func (m *APIKey) XXX_DiscardUnknown() {
	xxx_messageInfo_APIKey.DiscardUnknown(m)
}

var xxx_messageInfo_APIKey proto.InternalMessageInfo

func (m *APIKey) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *APIKey) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *APIKey) GetIsAdmin() bool {
	if m != nil {
		return m.IsAdmin
	}
	return false
}

func (m *APIKey) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *APIKey) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type CreateAPIKeyRequest struct {
	// The API key to create.
	ApiKey               *APIKey  `protobuf:"bytes,1,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateAPIKeyRequest) Reset()         { *m = CreateAPIKeyRequest{} }
func (m *CreateAPIKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAPIKeyRequest) ProtoMessage()    {}
func (*CreateAPIKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{1}
}

func (m *CreateAPIKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAPIKeyRequest.Unmarshal(m, b)
}
func (m *CreateAPIKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAPIKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateAPIKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAPIKeyRequest.Merge(m, src)
}
func (m *CreateAPIKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAPIKeyRequest.Size(m)
}
func (m *CreateAPIKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAPIKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAPIKeyRequest proto.InternalMessageInfo

func (m *CreateAPIKeyRequest) GetApiKey() *APIKey {
	if m != nil {
		return m.ApiKey
	}
	return nil
}

type CreateAPIKeyResponse struct {
	// API key ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// JWT token for this API Key.
	JwtToken             string   `protobuf:"bytes,2,opt,name=jwt_token,json=jwtToken,proto3" json:"jwt_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateAPIKeyResponse) Reset()         { *m = CreateAPIKeyResponse{} }
func (m *CreateAPIKeyResponse) String() string { return proto.CompactTextString(m) }
func (*CreateAPIKeyResponse) ProtoMessage()    {}
func (*CreateAPIKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{2}
}

func (m *CreateAPIKeyResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAPIKeyResponse.Unmarshal(m, b)
}
func (m *CreateAPIKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAPIKeyResponse.Marshal(b, m, deterministic)
}
func (m *CreateAPIKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAPIKeyResponse.Merge(m, src)
}
func (m *CreateAPIKeyResponse) XXX_Size() int {
	return xxx_messageInfo_CreateAPIKeyResponse.Size(m)
}
func (m *CreateAPIKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAPIKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAPIKeyResponse proto.InternalMessageInfo

func (m *CreateAPIKeyResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CreateAPIKeyResponse) GetJwtToken() string {
	if m != nil {
		return m.JwtToken
	}
	return ""
}

type DeleteAPIKeyRequest struct {
	// API key ID.
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAPIKeyRequest) Reset()         { *m = DeleteAPIKeyRequest{} }
func (m *DeleteAPIKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAPIKeyRequest) ProtoMessage()    {}
func (*DeleteAPIKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{3}
}

func (m *DeleteAPIKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAPIKeyRequest.Unmarshal(m, b)
}
func (m *DeleteAPIKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAPIKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAPIKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAPIKeyRequest.Merge(m, src)
}
func (m *DeleteAPIKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAPIKeyRequest.Size(m)
}
func (m *DeleteAPIKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAPIKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAPIKeyRequest proto.InternalMessageInfo

func (m *DeleteAPIKeyRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type ListAPIKeysRequest struct {
	// Max number of items to return.
	Limit int64 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset in the result-set (for pagination).
	Offset int64 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// Return only admin keys.
	IsAdmin bool `protobuf:"varint,3,opt,name=is_admin,json=isAdmin,proto3" json:"is_admin,omitempty"`
	// Filter on organization ID.
	OrganizationId int64 `protobuf:"varint,4,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Filter on application ID.
	ApplicationId        int64    `protobuf:"varint,5,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAPIKeysRequest) Reset()         { *m = ListAPIKeysRequest{} }
func (m *ListAPIKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListAPIKeysRequest) ProtoMessage()    {}
func (*ListAPIKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{4}
}

func (m *ListAPIKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAPIKeysRequest.Unmarshal(m, b)
}
func (m *ListAPIKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAPIKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListAPIKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAPIKeysRequest.Merge(m, src)
}
func (m *ListAPIKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListAPIKeysRequest.Size(m)
}
func (m *ListAPIKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAPIKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAPIKeysRequest proto.InternalMessageInfo

func (m *ListAPIKeysRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListAPIKeysRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListAPIKeysRequest) GetIsAdmin() bool {
	if m != nil {
		return m.IsAdmin
	}
	return false
}

func (m *ListAPIKeysRequest) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *ListAPIKeysRequest) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

type ListAPIKeysResponse struct {
	// Total number of API keys.
	TotalCount           int64     `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	Result               []*APIKey `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ListAPIKeysResponse) Reset()         { *m = ListAPIKeysResponse{} }
func (m *ListAPIKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListAPIKeysResponse) ProtoMessage()    {}
func (*ListAPIKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{5}
}

func (m *ListAPIKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAPIKeysResponse.Unmarshal(m, b)
}
func (m *ListAPIKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAPIKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListAPIKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAPIKeysResponse.Merge(m, src)
}
func (m *ListAPIKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListAPIKeysResponse.Size(m)
}
func (m *ListAPIKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAPIKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAPIKeysResponse proto.InternalMessageInfo

func (m *ListAPIKeysResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ListAPIKeysResponse) GetResult() []*APIKey {
	if m != nil {
		return m.Result
	}
	return nil
}

type ProfileSettings struct {
	// Existing users in the system can not be assigned to organizations and
	// application and can not be listed by non global admin users.
	DisableAssignExistingUsers bool     `protobuf:"varint,1,opt,name=disable_assign_existing_users,json=disableAssignExistingUsers,proto3" json:"disable_assign_existing_users,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *ProfileSettings) Reset()         { *m = ProfileSettings{} }
func (m *ProfileSettings) String() string { return proto.CompactTextString(m) }
func (*ProfileSettings) ProtoMessage()    {}
func (*ProfileSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{6}
}

func (m *ProfileSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProfileSettings.Unmarshal(m, b)
}
func (m *ProfileSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProfileSettings.Marshal(b, m, deterministic)
}
func (m *ProfileSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfileSettings.Merge(m, src)
}
func (m *ProfileSettings) XXX_Size() int {
	return xxx_messageInfo_ProfileSettings.Size(m)
}
func (m *ProfileSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfileSettings.DiscardUnknown(m)
}

var xxx_messageInfo_ProfileSettings proto.InternalMessageInfo

func (m *ProfileSettings) GetDisableAssignExistingUsers() bool {
	if m != nil {
		return m.DisableAssignExistingUsers
	}
	return false
}

// Defines an organization to which an user is associated.
type OrganizationLink struct {
	// Organization ID.
	OrganizationId int64 `protobuf:"varint,1,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Organization name.
	OrganizationName string `protobuf:"bytes,2,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// User is admin within the context of this organization.
	// There is no need to set the is_device_admin and is_gateway_admin flags.
	IsAdmin bool `protobuf:"varint,3,opt,name=is_admin,json=isAdmin,proto3" json:"is_admin,omitempty"`
	// User is able to modify device related resources (applications,
	// device-profiles, devices, multicast-groups).
	IsDeviceAdmin bool `protobuf:"varint,6,opt,name=is_device_admin,json=isDeviceAdmin,proto3" json:"is_device_admin,omitempty"`
	// User is able to modify gateways.
	IsGatewayAdmin bool `protobuf:"varint,7,opt,name=is_gateway_admin,json=isGatewayAdmin,proto3" json:"is_gateway_admin,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt            *timestamp.Timestamp `protobuf:"bytes,5,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OrganizationLink) Reset()         { *m = OrganizationLink{} }
func (m *OrganizationLink) String() string { return proto.CompactTextString(m) }
func (*OrganizationLink) ProtoMessage()    {}
func (*OrganizationLink) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{7}
}

func (m *OrganizationLink) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OrganizationLink.Unmarshal(m, b)
}
func (m *OrganizationLink) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OrganizationLink.Marshal(b, m, deterministic)
}
func (m *OrganizationLink) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrganizationLink.Merge(m, src)
}
func (m *OrganizationLink) XXX_Size() int {
	return xxx_messageInfo_OrganizationLink.Size(m)
}
func (m *OrganizationLink) XXX_DiscardUnknown() {
	xxx_messageInfo_OrganizationLink.DiscardUnknown(m)
}

var xxx_messageInfo_OrganizationLink proto.InternalMessageInfo

func (m *OrganizationLink) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *OrganizationLink) GetOrganizationName() string {
	if m != nil {
		return m.OrganizationName
	}
	return ""
}

func (m *OrganizationLink) GetIsAdmin() bool {
	if m != nil {
		return m.IsAdmin
	}
	return false
}

func (m *OrganizationLink) GetIsDeviceAdmin() bool {
	if m != nil {
		return m.IsDeviceAdmin
	}
	return false
}

func (m *OrganizationLink) GetIsGatewayAdmin() bool {
	if m != nil {
		return m.IsGatewayAdmin
	}
	return false
}

func (m *OrganizationLink) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *OrganizationLink) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

type LoginRequest struct {
	// Username of the user.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Password of the user.
	Password             string   `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoginRequest) Reset()         { *m = LoginRequest{} }
func (m *LoginRequest) String() string { return proto.CompactTextString(m) }
func (*LoginRequest) ProtoMessage()    {}
func (*LoginRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{8}
}

func (m *LoginRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoginRequest.Unmarshal(m, b)
}
func (m *LoginRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoginRequest.Marshal(b, m, deterministic)
}
func (m *LoginRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoginRequest.Merge(m, src)
}
func (m *LoginRequest) XXX_Size() int {
	return xxx_messageInfo_LoginRequest.Size(m)
}
func (m *LoginRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LoginRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LoginRequest proto.InternalMessageInfo

func (m *LoginRequest) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *LoginRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

type LoginResponse struct {
	// The JWT tag to be used to access chirpstack-application-server interfaces.
	Jwt                  string   `protobuf:"bytes,1,opt,name=jwt,proto3" json:"jwt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoginResponse) Reset()         { *m = LoginResponse{} }
func (m *LoginResponse) String() string { return proto.CompactTextString(m) }
func (*LoginResponse) ProtoMessage()    {}
func (*LoginResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{9}
}

func (m *LoginResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoginResponse.Unmarshal(m, b)
}
func (m *LoginResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoginResponse.Marshal(b, m, deterministic)
}
func (m *LoginResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoginResponse.Merge(m, src)
}
func (m *LoginResponse) XXX_Size() int {
	return xxx_messageInfo_LoginResponse.Size(m)
}
func (m *LoginResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LoginResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LoginResponse proto.InternalMessageInfo

func (m *LoginResponse) GetJwt() string {
	if m != nil {
		return m.Jwt
	}
	return ""
}

type ProfileResponse struct {
	// User object.
	User *User `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// Organizations to which the user is associated.
	Organizations []*OrganizationLink `protobuf:"bytes,3,rep,name=organizations,proto3" json:"organizations,omitempty"`
	// Profile settings.
	Settings             *ProfileSettings `protobuf:"bytes,4,opt,name=settings,proto3" json:"settings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ProfileResponse) Reset()         { *m = ProfileResponse{} }
func (m *ProfileResponse) String() string { return proto.CompactTextString(m) }
func (*ProfileResponse) ProtoMessage()    {}
func (*ProfileResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{10}
}

func (m *ProfileResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProfileResponse.Unmarshal(m, b)
}
func (m *ProfileResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProfileResponse.Marshal(b, m, deterministic)
}
func (m *ProfileResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfileResponse.Merge(m, src)
}
func (m *ProfileResponse) XXX_Size() int {
	return xxx_messageInfo_ProfileResponse.Size(m)
}
func (m *ProfileResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfileResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProfileResponse proto.InternalMessageInfo

func (m *ProfileResponse) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *ProfileResponse) GetOrganizations() []*OrganizationLink {
	if m != nil {
		return m.Organizations
	}
	return nil
}

func (m *ProfileResponse) GetSettings() *ProfileSettings {
	if m != nil {
		return m.Settings
	}
	return nil
}

type GlobalSearchRequest struct {
	// Search query.
	Search string `protobuf:"bytes,1,opt,name=search,proto3" json:"search,omitempty"`
	// Max number of results to return.
	Limit int64 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset offset of the result-set (for pagination).
	Offset               int64    `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GlobalSearchRequest) Reset()         { *m = GlobalSearchRequest{} }
func (m *GlobalSearchRequest) String() string { return proto.CompactTextString(m) }
func (*GlobalSearchRequest) ProtoMessage()    {}
func (*GlobalSearchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{11}
}

func (m *GlobalSearchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GlobalSearchRequest.Unmarshal(m, b)
}
func (m *GlobalSearchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GlobalSearchRequest.Marshal(b, m, deterministic)
}
func (m *GlobalSearchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlobalSearchRequest.Merge(m, src)
}
func (m *GlobalSearchRequest) XXX_Size() int {
	return xxx_messageInfo_GlobalSearchRequest.Size(m)
}
func (m *GlobalSearchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GlobalSearchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GlobalSearchRequest proto.InternalMessageInfo

func (m *GlobalSearchRequest) GetSearch() string {
	if m != nil {
		return m.Search
	}
	return ""
}

func (m *GlobalSearchRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GlobalSearchRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type GlobalSearchResponse struct {
	Result               []*GlobalSearchResult `protobuf:"bytes,1,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GlobalSearchResponse) Reset()         { *m = GlobalSearchResponse{} }
func (m *GlobalSearchResponse) String() string { return proto.CompactTextString(m) }
func (*GlobalSearchResponse) ProtoMessage()    {}
func (*GlobalSearchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{12}
}

func (m *GlobalSearchResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GlobalSearchResponse.Unmarshal(m, b)
}
func (m *GlobalSearchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GlobalSearchResponse.Marshal(b, m, deterministic)
}
func (m *GlobalSearchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlobalSearchResponse.Merge(m, src)
}
func (m *GlobalSearchResponse) XXX_Size() int {
	return xxx_messageInfo_GlobalSearchResponse.Size(m)
}
func (m *GlobalSearchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GlobalSearchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GlobalSearchResponse proto.InternalMessageInfo

func (m *GlobalSearchResponse) GetResult() []*GlobalSearchResult {
	if m != nil {
		return m.Result
	}
	return nil
}

type GlobalSearchResult struct {
	// Record kind.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Search score.
	Score float32 `protobuf:"fixed32,2,opt,name=score,proto3" json:"score,omitempty"`
	// Organization id.
	OrganizationId int64 `protobuf:"varint,3,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Organization name.
	OrganizationName string `protobuf:"bytes,4,opt,name=organization_name,json=organizationName,proto3" json:"organization_name,omitempty"`
	// Application id.
	ApplicationId int64 `protobuf:"varint,5,opt,name=application_id,json=applicationID,proto3" json:"application_id,omitempty"`
	// Application name.
	ApplicationName string `protobuf:"bytes,6,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// Device DevEUI (hex encoded).
	DeviceDevEui string `protobuf:"bytes,7,opt,name=device_dev_eui,json=deviceDevEUI,proto3" json:"device_dev_eui,omitempty"`
	// Device name.
	DeviceName string `protobuf:"bytes,8,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Gateway MAC (hex encoded).
	GatewayMac string `protobuf:"bytes,9,opt,name=gateway_mac,json=gatewayMAC,proto3" json:"gateway_mac,omitempty"`
	// Gateway name.
	GatewayName          string   `protobuf:"bytes,10,opt,name=gateway_name,json=gatewayName,proto3" json:"gateway_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GlobalSearchResult) Reset()         { *m = GlobalSearchResult{} }
func (m *GlobalSearchResult) String() string { return proto.CompactTextString(m) }
func (*GlobalSearchResult) ProtoMessage()    {}
func (*GlobalSearchResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{13}
}

func (m *GlobalSearchResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GlobalSearchResult.Unmarshal(m, b)
}
func (m *GlobalSearchResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GlobalSearchResult.Marshal(b, m, deterministic)
}
func (m *GlobalSearchResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GlobalSearchResult.Merge(m, src)
}
func (m *GlobalSearchResult) XXX_Size() int {
	return xxx_messageInfo_GlobalSearchResult.Size(m)
}
func (m *GlobalSearchResult) XXX_DiscardUnknown() {
	xxx_messageInfo_GlobalSearchResult.DiscardUnknown(m)
}

var xxx_messageInfo_GlobalSearchResult proto.InternalMessageInfo

func (m *GlobalSearchResult) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *GlobalSearchResult) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *GlobalSearchResult) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *GlobalSearchResult) GetOrganizationName() string {
	if m != nil {
		return m.OrganizationName
	}
	return ""
}

func (m *GlobalSearchResult) GetApplicationId() int64 {
	if m != nil {
		return m.ApplicationId
	}
	return 0
}

func (m *GlobalSearchResult) GetApplicationName() string {
	if m != nil {
		return m.ApplicationName
	}
	return ""
}

func (m *GlobalSearchResult) GetDeviceDevEui() string {
	if m != nil {
		return m.DeviceDevEui
	}
	return ""
}

func (m *GlobalSearchResult) GetDeviceName() string {
	if m != nil {
		return m.DeviceName
	}
	return ""
}

func (m *GlobalSearchResult) GetGatewayMac() string {
	if m != nil {
		return m.GatewayMac
	}
	return ""
}

func (m *GlobalSearchResult) GetGatewayName() string {
	if m != nil {
		return m.GatewayName
	}
	return ""
}

type BrandingResponse struct {
	// Logo html.
	Logo string `protobuf:"bytes,1,opt,name=logo,proto3" json:"logo,omitempty"`
	// Registration html.
	Registration string `protobuf:"bytes,2,opt,name=registration,proto3" json:"registration,omitempty"`
	// Footer html.
	Footer               string   `protobuf:"bytes,3,opt,name=footer,proto3" json:"footer,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BrandingResponse) Reset()         { *m = BrandingResponse{} }
func (m *BrandingResponse) String() string { return proto.CompactTextString(m) }
func (*BrandingResponse) ProtoMessage()    {}
func (*BrandingResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2d2de8ef40b5c6ca, []int{14}
}

func (m *BrandingResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BrandingResponse.Unmarshal(m, b)
}
func (m *BrandingResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BrandingResponse.Marshal(b, m, deterministic)
}
func (m *BrandingResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BrandingResponse.Merge(m, src)
}
func (m *BrandingResponse) XXX_Size() int {
	return xxx_messageInfo_BrandingResponse.Size(m)
}
func (m *BrandingResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BrandingResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BrandingResponse proto.InternalMessageInfo

func (m *BrandingResponse) GetLogo() string {
	if m != nil {
		return m.Logo
	}
	return ""
}

func (m *BrandingResponse) GetRegistration() string {
	if m != nil {
		return m.Registration
	}
	return ""
}

func (m *BrandingResponse) GetFooter() string {
	if m != nil {
		return m.Footer
	}
	return ""
}

func init() {
	proto.RegisterType((*APIKey)(nil), "api.APIKey")
	proto.RegisterType((*CreateAPIKeyRequest)(nil), "api.CreateAPIKeyRequest")
	proto.RegisterType((*CreateAPIKeyResponse)(nil), "api.CreateAPIKeyResponse")
	proto.RegisterType((*DeleteAPIKeyRequest)(nil), "api.DeleteAPIKeyRequest")
	proto.RegisterType((*ListAPIKeysRequest)(nil), "api.ListAPIKeysRequest")
	proto.RegisterType((*ListAPIKeysResponse)(nil), "api.ListAPIKeysResponse")
	proto.RegisterType((*ProfileSettings)(nil), "api.ProfileSettings")
	proto.RegisterType((*OrganizationLink)(nil), "api.OrganizationLink")
	proto.RegisterType((*LoginRequest)(nil), "api.LoginRequest")
	proto.RegisterType((*LoginResponse)(nil), "api.LoginResponse")
	proto.RegisterType((*ProfileResponse)(nil), "api.ProfileResponse")
	proto.RegisterType((*GlobalSearchRequest)(nil), "api.GlobalSearchRequest")
	proto.RegisterType((*GlobalSearchResponse)(nil), "api.GlobalSearchResponse")
	proto.RegisterType((*GlobalSearchResult)(nil), "api.GlobalSearchResult")
	proto.RegisterType((*BrandingResponse)(nil), "api.BrandingResponse")
}

func init() { proto.RegisterFile("as/external/api/internal.proto", fileDescriptor_2d2de8ef40b5c6ca) }

var fileDescriptor_2d2de8ef40b5c6ca = []byte{
	// 1132 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xcf, 0x72, 0x1b, 0xc5,
	0x13, 0x2e, 0x49, 0xb6, 0x2c, 0xb5, 0x64, 0x5b, 0x19, 0x3b, 0x8e, 0x22, 0xc7, 0xb1, 0xbd, 0x49,
	0x7e, 0x3f, 0x13, 0x2a, 0x12, 0xe5, 0x1c, 0xa8, 0x90, 0x93, 0x62, 0x1b, 0x97, 0x2b, 0x26, 0xa4,
	0xd6, 0x0e, 0x55, 0xc0, 0x61, 0x19, 0x69, 0x47, 0xeb, 0xb1, 0x56, 0x3b, 0xcb, 0xce, 0xc8, 0x8e,
	0xa0, 0xb8, 0xf0, 0x0a, 0x1c, 0x38, 0x72, 0xe5, 0xc2, 0x93, 0x70, 0xe4, 0x15, 0x78, 0x01, 0xde,
	0x80, 0x9a, 0x9e, 0x59, 0xb1, 0xfa, 0x63, 0x92, 0x13, 0xb7, 0xed, 0x9e, 0x6f, 0xbe, 0xee, 0xe9,
	0xe9, 0x6f, 0xb6, 0xe1, 0x3e, 0x95, 0x2d, 0xf6, 0x56, 0xb1, 0x24, 0xa2, 0x61, 0x8b, 0xc6, 0xbc,
	0xc5, 0x23, 0x63, 0x34, 0xe3, 0x44, 0x28, 0x41, 0x0a, 0x34, 0xe6, 0x8d, 0x7b, 0x81, 0x10, 0x41,
	0xc8, 0x70, 0x9d, 0x46, 0x91, 0x50, 0x54, 0x71, 0x11, 0x49, 0x03, 0x69, 0x6c, 0xdb, 0x55, 0xb4,
	0x3a, 0xc3, 0x5e, 0x4b, 0xf1, 0x01, 0x93, 0x8a, 0x0e, 0x62, 0x0b, 0xd8, 0x9c, 0x06, 0xb0, 0x41,
	0xac, 0x46, 0x76, 0xb1, 0x31, 0x9d, 0xc0, 0x50, 0xb2, 0xc4, 0xac, 0x39, 0x3f, 0xe7, 0xa0, 0xd8,
	0x7e, 0x7d, 0xf2, 0x92, 0x8d, 0xc8, 0x0a, 0xe4, 0xb9, 0x5f, 0xcf, 0xed, 0xe4, 0xf6, 0xca, 0x6e,
	0x9e, 0xfb, 0x84, 0xc0, 0x42, 0x44, 0x07, 0xac, 0x9e, 0x47, 0x0f, 0x7e, 0x93, 0xbb, 0x50, 0xe2,
	0xd2, 0xa3, 0xfe, 0x80, 0x47, 0xf5, 0xc2, 0x4e, 0x6e, 0xaf, 0xe4, 0x2e, 0x71, 0xd9, 0xd6, 0x26,
	0xf9, 0x3f, 0xac, 0x8a, 0x24, 0xa0, 0x11, 0xff, 0x0e, 0x53, 0xf7, 0xb8, 0x5f, 0x5f, 0xd8, 0xc9,
	0xed, 0x15, 0xdc, 0x95, 0xac, 0xfb, 0xe4, 0x90, 0x3c, 0x82, 0x15, 0x1a, 0xc7, 0x21, 0xef, 0x8e,
	0x71, 0x8b, 0x88, 0x5b, 0xce, 0x78, 0x4f, 0x0e, 0x9d, 0xe7, 0xb0, 0x76, 0x90, 0x30, 0xaa, 0x98,
	0x49, 0xcf, 0x65, 0xdf, 0x0e, 0x99, 0x54, 0xe4, 0x21, 0x2c, 0xd1, 0x98, 0x7b, 0x7d, 0x36, 0xc2,
	0x54, 0x2b, 0xfb, 0x95, 0x26, 0x8d, 0x79, 0xd3, 0x82, 0x8a, 0x34, 0xe6, 0x2f, 0xd9, 0xc8, 0x39,
	0x80, 0xf5, 0xc9, 0xcd, 0x32, 0x16, 0x91, 0x64, 0x33, 0x67, 0xdc, 0x84, 0xf2, 0xe5, 0xb5, 0xf2,
	0x94, 0xe8, 0xb3, 0xc8, 0x1e, 0xb4, 0x74, 0x79, 0xad, 0xce, 0xb5, 0xed, 0x3c, 0x82, 0xb5, 0x43,
	0x16, 0xb2, 0xe9, 0x0c, 0xa6, 0x38, 0x9c, 0xdf, 0x72, 0x40, 0x4e, 0xb9, 0x54, 0x06, 0x25, 0x53,
	0xd8, 0x3a, 0x2c, 0x86, 0x7c, 0xc0, 0x15, 0x22, 0x0b, 0xae, 0x31, 0xc8, 0x06, 0x14, 0x45, 0xaf,
	0x27, 0x99, 0xc2, 0x68, 0x05, 0xd7, 0x5a, 0xff, 0x65, 0x61, 0xbf, 0x86, 0xb5, 0x89, 0x74, 0x6d,
	0x69, 0xb6, 0xa1, 0xa2, 0x84, 0xa2, 0xa1, 0xd7, 0x15, 0xc3, 0x28, 0xcd, 0x1a, 0xd0, 0x75, 0xa0,
	0x3d, 0xe4, 0x01, 0x14, 0x13, 0x26, 0x87, 0xa1, 0x4e, 0xbd, 0x30, 0x53, 0x78, 0xb3, 0xe4, 0x9c,
	0xc3, 0xea, 0xeb, 0x44, 0xf4, 0x78, 0xc8, 0xce, 0x98, 0x52, 0x3c, 0x0a, 0x24, 0x69, 0xc3, 0x96,
	0xcf, 0x25, 0xed, 0x84, 0xcc, 0xa3, 0x52, 0xf2, 0x20, 0xf2, 0xd8, 0x5b, 0x2e, 0xf5, 0x9a, 0xa7,
	0x1b, 0x51, 0x62, 0xa8, 0x92, 0xdb, 0xb0, 0xa0, 0x36, 0x62, 0x8e, 0x2c, 0xe4, 0x8d, 0x46, 0x38,
	0xbf, 0xe7, 0xa1, 0xf6, 0x79, 0xe6, 0xb0, 0xa7, 0x3c, 0xea, 0xcf, 0xab, 0x4b, 0x6e, 0x6e, 0x5d,
	0x3e, 0x84, 0x5b, 0x13, 0xc0, 0x4c, 0x57, 0xd7, 0xb2, 0x0b, 0xaf, 0xde, 0xd1, 0xe1, 0xff, 0x83,
	0x55, 0x2e, 0x3d, 0x9f, 0x5d, 0xf1, 0x2e, 0xb3, 0x88, 0x22, 0x22, 0x96, 0xb9, 0x3c, 0x44, 0xaf,
	0xc1, 0xed, 0x41, 0x8d, 0x4b, 0x2f, 0xa0, 0x8a, 0x5d, 0xd3, 0x91, 0x05, 0x2e, 0x21, 0x70, 0x85,
	0xcb, 0x63, 0xe3, 0x36, 0xc8, 0x67, 0x00, 0x5d, 0x6c, 0x53, 0xdf, 0xa3, 0x0a, 0x6f, 0xb5, 0xb2,
	0xdf, 0x68, 0x1a, 0x2d, 0x37, 0x53, 0x2d, 0x37, 0xcf, 0x53, 0xb1, 0xbb, 0x65, 0x8b, 0x6e, 0x2b,
	0xbd, 0x75, 0x18, 0xfb, 0xe9, 0xd6, 0xc5, 0x77, 0x6f, 0xb5, 0xe8, 0xb6, 0x72, 0x3e, 0x85, 0xea,
	0xa9, 0x08, 0x78, 0x94, 0x76, 0x6a, 0x03, 0x4a, 0xfa, 0x22, 0xb0, 0x2c, 0xa6, 0xad, 0xc7, 0xb6,
	0x5e, 0x8b, 0xa9, 0x94, 0xd7, 0x22, 0xf1, 0x53, 0x7d, 0xa4, 0xb6, 0xb3, 0x0b, 0xcb, 0x96, 0xc7,
	0xb6, 0x50, 0x0d, 0x0a, 0x97, 0xd7, 0xca, 0x72, 0xe8, 0x4f, 0xe7, 0x97, 0xdc, 0xb8, 0x1f, 0xc6,
	0xa8, 0x2d, 0x58, 0xd0, 0xf4, 0x56, 0xbe, 0x65, 0xec, 0x22, 0x7d, 0xcd, 0x2e, 0xba, 0xc9, 0x73,
	0x58, 0xce, 0x5e, 0x8a, 0xac, 0x17, 0xb0, 0xdb, 0x6e, 0x23, 0x6e, 0xba, 0x09, 0xdc, 0x49, 0x2c,
	0xf9, 0x08, 0x4a, 0xd2, 0xf6, 0x9d, 0x2d, 0xe7, 0x3a, 0xee, 0x9b, 0xea, 0x49, 0x77, 0x8c, 0xd2,
	0x6a, 0x38, 0x0e, 0x45, 0x87, 0x86, 0x67, 0x8c, 0x26, 0xdd, 0x8b, 0xb4, 0x26, 0x1b, 0x50, 0x94,
	0xe8, 0xb0, 0xa7, 0xb1, 0xd6, 0x3f, 0xaa, 0xce, 0xcf, 0x57, 0x75, 0x21, 0xab, 0x6a, 0xe7, 0x18,
	0xd6, 0x27, 0xc9, 0x6d, 0x09, 0x5a, 0x63, 0x29, 0xe5, 0xf0, 0x70, 0x77, 0x30, 0xc9, 0x29, 0xe8,
	0x30, 0x54, 0x63, 0x59, 0xfd, 0x95, 0x07, 0x32, 0xbb, 0xac, 0x9f, 0xe8, 0x3e, 0x8f, 0xd2, 0xc7,
	0x08, 0xbf, 0x75, 0x86, 0xb2, 0x2b, 0x12, 0xd3, 0xe1, 0x79, 0xd7, 0x18, 0xf3, 0xc4, 0x52, 0x78,
	0x7f, 0xb1, 0x2c, 0xdc, 0x20, 0x96, 0xf7, 0x7b, 0x71, 0xc8, 0x07, 0x50, 0xcb, 0xc2, 0x90, 0xb2,
	0x88, 0x94, 0xab, 0x19, 0x3f, 0x32, 0x3e, 0x84, 0x15, 0x2b, 0x30, 0x9f, 0x5d, 0x79, 0x6c, 0xc8,
	0x51, 0x39, 0x65, 0xb7, 0x6a, 0xbc, 0x87, 0xec, 0xea, 0xe8, 0xcd, 0x89, 0x7e, 0xab, 0x2c, 0x0a,
	0xb9, 0x4a, 0x08, 0x01, 0xe3, 0x42, 0x9a, 0x6d, 0xa8, 0xa4, 0xfa, 0x1b, 0xd0, 0x6e, 0xbd, 0x6c,
	0x00, 0xd6, 0xf5, 0x59, 0xfb, 0x80, 0xec, 0x42, 0x35, 0x05, 0x20, 0x05, 0x20, 0x22, 0xdd, 0xa4,
	0x39, 0x9c, 0x0e, 0xd4, 0x5e, 0x24, 0x34, 0xf2, 0x79, 0x14, 0x8c, 0x2f, 0x8e, 0xc0, 0x42, 0x28,
	0x02, 0x91, 0x16, 0x5c, 0x7f, 0x13, 0x07, 0xaa, 0x09, 0x0b, 0xb8, 0x54, 0x09, 0x1e, 0xc3, 0xca,
	0x64, 0xc2, 0xa7, 0x1b, 0xa4, 0x27, 0x84, 0x62, 0x09, 0x56, 0xbd, 0xec, 0x5a, 0x6b, 0xff, 0xd7,
	0x45, 0x58, 0x3d, 0xb1, 0xe3, 0xc0, 0x19, 0x4b, 0x74, 0xfe, 0xe4, 0x15, 0x2c, 0xa2, 0xac, 0xc8,
	0x2d, 0xec, 0x8a, 0xac, 0x54, 0x1b, 0x24, 0xeb, 0x32, 0x39, 0x39, 0xf7, 0x7f, 0xfc, 0xe3, 0xcf,
	0x9f, 0xf2, 0x75, 0x67, 0x6d, 0x62, 0xb8, 0x68, 0x85, 0x1a, 0xf4, 0x49, 0xee, 0x31, 0xf9, 0x02,
	0x96, 0x6c, 0xfb, 0x93, 0x8d, 0x99, 0x07, 0xe2, 0x48, 0xcf, 0x09, 0x8d, 0x09, 0x91, 0x8c, 0x89,
	0xb7, 0x90, 0xf8, 0x0e, 0xb9, 0x3d, 0x49, 0x1c, 0x5b, 0xb2, 0x2f, 0xa1, 0x94, 0xd6, 0xe7, 0x46,
	0x62, 0xa3, 0xda, 0xe9, 0x32, 0xa6, 0x29, 0x93, 0x8d, 0x49, 0xe6, 0x4e, 0x4a, 0x47, 0xa1, 0x9a,
	0xed, 0x76, 0x52, 0x9f, 0xa3, 0x0f, 0x53, 0x90, 0xbb, 0xf3, 0x94, 0x63, 0x82, 0xdc, 0xc3, 0x20,
	0x1b, 0x64, 0x7d, 0x32, 0x88, 0x15, 0x72, 0x0f, 0xaa, 0xd9, 0x09, 0xc1, 0x86, 0x98, 0x33, 0x71,
	0xd8, 0x10, 0xf3, 0xc6, 0x09, 0x67, 0x17, 0x43, 0x6c, 0x3a, 0x53, 0xe7, 0xa0, 0x31, 0x7f, 0xd2,
	0x67, 0x23, 0xa9, 0xab, 0xcf, 0xa0, 0x9a, 0x1d, 0x22, 0x6c, 0x9c, 0x39, 0x73, 0x45, 0xe3, 0x86,
	0x1a, 0x3a, 0x0f, 0x30, 0xc8, 0xd6, 0xe3, 0xcd, 0xf9, 0x41, 0x5a, 0xdf, 0x73, 0xff, 0x07, 0xf2,
	0x0d, 0x54, 0x32, 0x3f, 0x75, 0x62, 0x1e, 0x94, 0xd9, 0xa9, 0xa4, 0x51, 0x9f, 0x5d, 0xf8, 0xf7,
	0x3b, 0x49, 0xc3, 0xbc, 0x78, 0xf6, 0xd5, 0xc7, 0x01, 0x57, 0x17, 0xc3, 0x4e, 0xb3, 0x2b, 0x06,
	0xad, 0x4e, 0x22, 0xba, 0x94, 0x26, 0xad, 0xee, 0x05, 0x4f, 0x62, 0xa9, 0x68, 0xb7, 0xff, 0x44,
	0x6f, 0x0b, 0x44, 0xeb, 0xea, 0x69, 0x6b, 0x6a, 0xde, 0xec, 0x14, 0xf1, 0x44, 0x4f, 0xff, 0x0e,
	0x00, 0x00, 0xff, 0xff, 0xb7, 0x59, 0xa5, 0x4e, 0x0a, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// InternalServiceClient is the client API for InternalService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InternalServiceClient interface {
	// Log in a user
	Login(ctx context.Context, in *LoginRequest, opts ...grpc.CallOption) (*LoginResponse, error)
	// Get the current user's profile
	Profile(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*ProfileResponse, error)
	// Get the branding for the UI
	Branding(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*BrandingResponse, error)
	// Perform a global search.
	GlobalSearch(ctx context.Context, in *GlobalSearchRequest, opts ...grpc.CallOption) (*GlobalSearchResponse, error)
	// CreateAPIKey creates the given API key.
	CreateAPIKey(ctx context.Context, in *CreateAPIKeyRequest, opts ...grpc.CallOption) (*CreateAPIKeyResponse, error)
	// DeleteAPIKey deletes the API key.
	DeleteAPIKey(ctx context.Context, in *DeleteAPIKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// ListAPIKeys lists the available API keys.
	ListAPIKeys(ctx context.Context, in *ListAPIKeysRequest, opts ...grpc.CallOption) (*ListAPIKeysResponse, error)
}

type internalServiceClient struct {
	cc *grpc.ClientConn
}

func NewInternalServiceClient(cc *grpc.ClientConn) InternalServiceClient {
	return &internalServiceClient{cc}
}

func (c *internalServiceClient) Login(ctx context.Context, in *LoginRequest, opts ...grpc.CallOption) (*LoginResponse, error) {
	out := new(LoginResponse)
	err := c.cc.Invoke(ctx, "/api.InternalService/Login", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalServiceClient) Profile(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*ProfileResponse, error) {
	out := new(ProfileResponse)
	err := c.cc.Invoke(ctx, "/api.InternalService/Profile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalServiceClient) Branding(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (*BrandingResponse, error) {
	out := new(BrandingResponse)
	err := c.cc.Invoke(ctx, "/api.InternalService/Branding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalServiceClient) GlobalSearch(ctx context.Context, in *GlobalSearchRequest, opts ...grpc.CallOption) (*GlobalSearchResponse, error) {
	out := new(GlobalSearchResponse)
	err := c.cc.Invoke(ctx, "/api.InternalService/GlobalSearch", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalServiceClient) CreateAPIKey(ctx context.Context, in *CreateAPIKeyRequest, opts ...grpc.CallOption) (*CreateAPIKeyResponse, error) {
	out := new(CreateAPIKeyResponse)
	err := c.cc.Invoke(ctx, "/api.InternalService/CreateAPIKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalServiceClient) DeleteAPIKey(ctx context.Context, in *DeleteAPIKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.InternalService/DeleteAPIKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *internalServiceClient) ListAPIKeys(ctx context.Context, in *ListAPIKeysRequest, opts ...grpc.CallOption) (*ListAPIKeysResponse, error) {
	out := new(ListAPIKeysResponse)
	err := c.cc.Invoke(ctx, "/api.InternalService/ListAPIKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InternalServiceServer is the server API for InternalService service.
type InternalServiceServer interface {
	// Log in a user
	Login(context.Context, *LoginRequest) (*LoginResponse, error)
	// Get the current user's profile
	Profile(context.Context, *empty.Empty) (*ProfileResponse, error)
	// Get the branding for the UI
	Branding(context.Context, *empty.Empty) (*BrandingResponse, error)
	// Perform a global search.
	GlobalSearch(context.Context, *GlobalSearchRequest) (*GlobalSearchResponse, error)
	// CreateAPIKey creates the given API key.
	CreateAPIKey(context.Context, *CreateAPIKeyRequest) (*CreateAPIKeyResponse, error)
	// DeleteAPIKey deletes the API key.
	DeleteAPIKey(context.Context, *DeleteAPIKeyRequest) (*empty.Empty, error)
	// ListAPIKeys lists the available API keys.
	ListAPIKeys(context.Context, *ListAPIKeysRequest) (*ListAPIKeysResponse, error)
}

// UnimplementedInternalServiceServer can be embedded to have forward compatible implementations.
type UnimplementedInternalServiceServer struct {
}

func (*UnimplementedInternalServiceServer) Login(ctx context.Context, req *LoginRequest) (*LoginResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Login not implemented")
}
func (*UnimplementedInternalServiceServer) Profile(ctx context.Context, req *empty.Empty) (*ProfileResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Profile not implemented")
}
func (*UnimplementedInternalServiceServer) Branding(ctx context.Context, req *empty.Empty) (*BrandingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Branding not implemented")
}
func (*UnimplementedInternalServiceServer) GlobalSearch(ctx context.Context, req *GlobalSearchRequest) (*GlobalSearchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GlobalSearch not implemented")
}
func (*UnimplementedInternalServiceServer) CreateAPIKey(ctx context.Context, req *CreateAPIKeyRequest) (*CreateAPIKeyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAPIKey not implemented")
}
func (*UnimplementedInternalServiceServer) DeleteAPIKey(ctx context.Context, req *DeleteAPIKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAPIKey not implemented")
}
func (*UnimplementedInternalServiceServer) ListAPIKeys(ctx context.Context, req *ListAPIKeysRequest) (*ListAPIKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAPIKeys not implemented")
}

func RegisterInternalServiceServer(s *grpc.Server, srv InternalServiceServer) {
	s.RegisterService(&_InternalService_serviceDesc, srv)
}

func _InternalService_Login_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServiceServer).Login(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.InternalService/Login",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServiceServer).Login(ctx, req.(*LoginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalService_Profile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServiceServer).Profile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.InternalService/Profile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServiceServer).Profile(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalService_Branding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(empty.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServiceServer).Branding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.InternalService/Branding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServiceServer).Branding(ctx, req.(*empty.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalService_GlobalSearch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GlobalSearchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServiceServer).GlobalSearch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.InternalService/GlobalSearch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServiceServer).GlobalSearch(ctx, req.(*GlobalSearchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalService_CreateAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServiceServer).CreateAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.InternalService/CreateAPIKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServiceServer).CreateAPIKey(ctx, req.(*CreateAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalService_DeleteAPIKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAPIKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServiceServer).DeleteAPIKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.InternalService/DeleteAPIKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServiceServer).DeleteAPIKey(ctx, req.(*DeleteAPIKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InternalService_ListAPIKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAPIKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServiceServer).ListAPIKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.InternalService/ListAPIKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServiceServer).ListAPIKeys(ctx, req.(*ListAPIKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InternalService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.InternalService",
	HandlerType: (*InternalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Login",
			Handler:    _InternalService_Login_Handler,
		},
		{
			MethodName: "Profile",
			Handler:    _InternalService_Profile_Handler,
		},
		{
			MethodName: "Branding",
			Handler:    _InternalService_Branding_Handler,
		},
		{
			MethodName: "GlobalSearch",
			Handler:    _InternalService_GlobalSearch_Handler,
		},
		{
			MethodName: "CreateAPIKey",
			Handler:    _InternalService_CreateAPIKey_Handler,
		},
		{
			MethodName: "DeleteAPIKey",
			Handler:    _InternalService_DeleteAPIKey_Handler,
		},
		{
			MethodName: "ListAPIKeys",
			Handler:    _InternalService_ListAPIKeys_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "as/external/api/internal.proto",
}
