// Code generated by protoc-gen-go. DO NOT EDIT.
// source: as/external/api/multicastGroup.proto

package api

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type MulticastGroupType int32

const (
	// Class-C.
	MulticastGroupType_CLASS_C MulticastGroupType = 0
	// Class-B.
	MulticastGroupType_CLASS_B MulticastGroupType = 1
)

var MulticastGroupType_name = map[int32]string{
	0: "CLASS_C",
	1: "CLASS_B",
}

var MulticastGroupType_value = map[string]int32{
	"CLASS_C": 0,
	"CLASS_B": 1,
}

func (x MulticastGroupType) String() string {
	return proto.EnumName(MulticastGroupType_name, int32(x))
}

func (MulticastGroupType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{0}
}

type MulticastGroup struct {
	// ID (string formatted UUID).
	// This will be generated automatically on create.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Multicast-group name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Multicast address (HEX encoded DevAddr).
	McAddr string `protobuf:"bytes,3,opt,name=mc_addr,json=mcAddr,proto3" json:"mc_addr,omitempty"`
	// Multicast network session key (HEX encoded AES128 key).
	McNwkSKey string `protobuf:"bytes,4,opt,name=mc_nwk_s_key,json=mcNwkSKey,proto3" json:"mc_nwk_s_key,omitempty"`
	// Multicast application session key (HEX encoded AES128 key).
	McAppSKey string `protobuf:"bytes,5,opt,name=mc_app_s_key,json=mcAppSKey,proto3" json:"mc_app_s_key,omitempty"`
	// Frame-counter.
	FCnt uint32 `protobuf:"varint,6,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// Multicast type.
	GroupType MulticastGroupType `protobuf:"varint,7,opt,name=group_type,json=groupType,proto3,enum=api.MulticastGroupType" json:"group_type,omitempty"`
	// Data-rate.
	Dr uint32 `protobuf:"varint,8,opt,name=dr,proto3" json:"dr,omitempty"`
	// Frequency (Hz).
	Frequency uint32 `protobuf:"varint,9,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Ping-slot period.
	// Mandatory for Class-B multicast groups.
	PingSlotPeriod uint32 `protobuf:"varint,10,opt,name=ping_slot_period,json=pingSlotPeriod,proto3" json:"ping_slot_period,omitempty"`
	// Service-profile ID.
	// After creation, this can not be updated.
	ServiceProfileId     string   `protobuf:"bytes,11,opt,name=service_profile_id,json=serviceProfileID,proto3" json:"service_profile_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MulticastGroup) Reset()         { *m = MulticastGroup{} }
func (m *MulticastGroup) String() string { return proto.CompactTextString(m) }
func (*MulticastGroup) ProtoMessage()    {}
func (*MulticastGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{0}
}

func (m *MulticastGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MulticastGroup.Unmarshal(m, b)
}
func (m *MulticastGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MulticastGroup.Marshal(b, m, deterministic)
}
func (m *MulticastGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MulticastGroup.Merge(m, src)
}
func (m *MulticastGroup) XXX_Size() int {
	return xxx_messageInfo_MulticastGroup.Size(m)
}
func (m *MulticastGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_MulticastGroup.DiscardUnknown(m)
}

var xxx_messageInfo_MulticastGroup proto.InternalMessageInfo

func (m *MulticastGroup) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *MulticastGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MulticastGroup) GetMcAddr() string {
	if m != nil {
		return m.McAddr
	}
	return ""
}

func (m *MulticastGroup) GetMcNwkSKey() string {
	if m != nil {
		return m.McNwkSKey
	}
	return ""
}

func (m *MulticastGroup) GetMcAppSKey() string {
	if m != nil {
		return m.McAppSKey
	}
	return ""
}

func (m *MulticastGroup) GetFCnt() uint32 {
	if m != nil {
		return m.FCnt
	}
	return 0
}

func (m *MulticastGroup) GetGroupType() MulticastGroupType {
	if m != nil {
		return m.GroupType
	}
	return MulticastGroupType_CLASS_C
}

func (m *MulticastGroup) GetDr() uint32 {
	if m != nil {
		return m.Dr
	}
	return 0
}

func (m *MulticastGroup) GetFrequency() uint32 {
	if m != nil {
		return m.Frequency
	}
	return 0
}

func (m *MulticastGroup) GetPingSlotPeriod() uint32 {
	if m != nil {
		return m.PingSlotPeriod
	}
	return 0
}

func (m *MulticastGroup) GetServiceProfileId() string {
	if m != nil {
		return m.ServiceProfileId
	}
	return ""
}

type MulticastGroupListItem struct {
	// ID (string formatted UUID).
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Multicast-group name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Service-profile ID (string formatted UUID).
	ServiceProfileId string `protobuf:"bytes,3,opt,name=service_profile_id,json=serviceProfileID,proto3" json:"service_profile_id,omitempty"`
	// Service-profile name.
	ServiceProfileName   string   `protobuf:"bytes,4,opt,name=service_profile_name,json=serviceProfileName,proto3" json:"service_profile_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MulticastGroupListItem) Reset()         { *m = MulticastGroupListItem{} }
func (m *MulticastGroupListItem) String() string { return proto.CompactTextString(m) }
func (*MulticastGroupListItem) ProtoMessage()    {}
func (*MulticastGroupListItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{1}
}

func (m *MulticastGroupListItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MulticastGroupListItem.Unmarshal(m, b)
}
func (m *MulticastGroupListItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MulticastGroupListItem.Marshal(b, m, deterministic)
}
func (m *MulticastGroupListItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MulticastGroupListItem.Merge(m, src)
}
func (m *MulticastGroupListItem) XXX_Size() int {
	return xxx_messageInfo_MulticastGroupListItem.Size(m)
}
func (m *MulticastGroupListItem) XXX_DiscardUnknown() {
	xxx_messageInfo_MulticastGroupListItem.DiscardUnknown(m)
}

var xxx_messageInfo_MulticastGroupListItem proto.InternalMessageInfo

func (m *MulticastGroupListItem) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *MulticastGroupListItem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MulticastGroupListItem) GetServiceProfileId() string {
	if m != nil {
		return m.ServiceProfileId
	}
	return ""
}

func (m *MulticastGroupListItem) GetServiceProfileName() string {
	if m != nil {
		return m.ServiceProfileName
	}
	return ""
}

type CreateMulticastGroupRequest struct {
	// Multicast-group object to create.
	MulticastGroup       *MulticastGroup `protobuf:"bytes,1,opt,name=multicast_group,json=multicastGroup,proto3" json:"multicast_group,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CreateMulticastGroupRequest) Reset()         { *m = CreateMulticastGroupRequest{} }
func (m *CreateMulticastGroupRequest) String() string { return proto.CompactTextString(m) }
func (*CreateMulticastGroupRequest) ProtoMessage()    {}
func (*CreateMulticastGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{2}
}

func (m *CreateMulticastGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMulticastGroupRequest.Unmarshal(m, b)
}
func (m *CreateMulticastGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMulticastGroupRequest.Marshal(b, m, deterministic)
}
func (m *CreateMulticastGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMulticastGroupRequest.Merge(m, src)
}
func (m *CreateMulticastGroupRequest) XXX_Size() int {
	return xxx_messageInfo_CreateMulticastGroupRequest.Size(m)
}
func (m *CreateMulticastGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMulticastGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMulticastGroupRequest proto.InternalMessageInfo

func (m *CreateMulticastGroupRequest) GetMulticastGroup() *MulticastGroup {
	if m != nil {
		return m.MulticastGroup
	}
	return nil
}

type CreateMulticastGroupResponse struct {
	// ID of created group (string formatted UUID).
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateMulticastGroupResponse) Reset()         { *m = CreateMulticastGroupResponse{} }
func (m *CreateMulticastGroupResponse) String() string { return proto.CompactTextString(m) }
func (*CreateMulticastGroupResponse) ProtoMessage()    {}
func (*CreateMulticastGroupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{3}
}

func (m *CreateMulticastGroupResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMulticastGroupResponse.Unmarshal(m, b)
}
func (m *CreateMulticastGroupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMulticastGroupResponse.Marshal(b, m, deterministic)
}
func (m *CreateMulticastGroupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMulticastGroupResponse.Merge(m, src)
}
func (m *CreateMulticastGroupResponse) XXX_Size() int {
	return xxx_messageInfo_CreateMulticastGroupResponse.Size(m)
}
func (m *CreateMulticastGroupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMulticastGroupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMulticastGroupResponse proto.InternalMessageInfo

func (m *CreateMulticastGroupResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type GetMulticastGroupRequest struct {
	// ID (string formatted UUID).
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMulticastGroupRequest) Reset()         { *m = GetMulticastGroupRequest{} }
func (m *GetMulticastGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetMulticastGroupRequest) ProtoMessage()    {}
func (*GetMulticastGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{4}
}

func (m *GetMulticastGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMulticastGroupRequest.Unmarshal(m, b)
}
func (m *GetMulticastGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMulticastGroupRequest.Marshal(b, m, deterministic)
}
func (m *GetMulticastGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMulticastGroupRequest.Merge(m, src)
}
func (m *GetMulticastGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetMulticastGroupRequest.Size(m)
}
func (m *GetMulticastGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMulticastGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMulticastGroupRequest proto.InternalMessageInfo

func (m *GetMulticastGroupRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type GetMulticastGroupResponse struct {
	// Multicast-group object.
	MulticastGroup *MulticastGroup `protobuf:"bytes,1,opt,name=multicast_group,json=multicastGroup,proto3" json:"multicast_group,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt            *timestamp.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GetMulticastGroupResponse) Reset()         { *m = GetMulticastGroupResponse{} }
func (m *GetMulticastGroupResponse) String() string { return proto.CompactTextString(m) }
func (*GetMulticastGroupResponse) ProtoMessage()    {}
func (*GetMulticastGroupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{5}
}

func (m *GetMulticastGroupResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMulticastGroupResponse.Unmarshal(m, b)
}
func (m *GetMulticastGroupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMulticastGroupResponse.Marshal(b, m, deterministic)
}
func (m *GetMulticastGroupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMulticastGroupResponse.Merge(m, src)
}
func (m *GetMulticastGroupResponse) XXX_Size() int {
	return xxx_messageInfo_GetMulticastGroupResponse.Size(m)
}
func (m *GetMulticastGroupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMulticastGroupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetMulticastGroupResponse proto.InternalMessageInfo

func (m *GetMulticastGroupResponse) GetMulticastGroup() *MulticastGroup {
	if m != nil {
		return m.MulticastGroup
	}
	return nil
}

func (m *GetMulticastGroupResponse) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *GetMulticastGroupResponse) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

type UpdateMulticastGroupRequest struct {
	// Multicast-group object to update.
	MulticastGroup       *MulticastGroup `protobuf:"bytes,1,opt,name=multicast_group,json=multicastGroup,proto3" json:"multicast_group,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *UpdateMulticastGroupRequest) Reset()         { *m = UpdateMulticastGroupRequest{} }
func (m *UpdateMulticastGroupRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateMulticastGroupRequest) ProtoMessage()    {}
func (*UpdateMulticastGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{6}
}

func (m *UpdateMulticastGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateMulticastGroupRequest.Unmarshal(m, b)
}
func (m *UpdateMulticastGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateMulticastGroupRequest.Marshal(b, m, deterministic)
}
func (m *UpdateMulticastGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateMulticastGroupRequest.Merge(m, src)
}
func (m *UpdateMulticastGroupRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateMulticastGroupRequest.Size(m)
}
func (m *UpdateMulticastGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateMulticastGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateMulticastGroupRequest proto.InternalMessageInfo

func (m *UpdateMulticastGroupRequest) GetMulticastGroup() *MulticastGroup {
	if m != nil {
		return m.MulticastGroup
	}
	return nil
}

type DeleteMulticastGroupRequest struct {
	// ID (string formatted UUID).
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteMulticastGroupRequest) Reset()         { *m = DeleteMulticastGroupRequest{} }
func (m *DeleteMulticastGroupRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteMulticastGroupRequest) ProtoMessage()    {}
func (*DeleteMulticastGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{7}
}

func (m *DeleteMulticastGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteMulticastGroupRequest.Unmarshal(m, b)
}
func (m *DeleteMulticastGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteMulticastGroupRequest.Marshal(b, m, deterministic)
}
func (m *DeleteMulticastGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteMulticastGroupRequest.Merge(m, src)
}
func (m *DeleteMulticastGroupRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteMulticastGroupRequest.Size(m)
}
func (m *DeleteMulticastGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteMulticastGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteMulticastGroupRequest proto.InternalMessageInfo

func (m *DeleteMulticastGroupRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type AddDeviceToMulticastGroupRequest struct {
	// Multicast-group ID (string formatted UUID).
	MulticastGroupId string `protobuf:"bytes,1,opt,name=multicast_group_id,json=multicastGroupID,proto3" json:"multicast_group_id,omitempty"`
	// Device EUI (HEX encoded string).
	// Note that the device must be under the same service-profile as the
	// multicast-group.
	DevEui               string   `protobuf:"bytes,2,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddDeviceToMulticastGroupRequest) Reset()         { *m = AddDeviceToMulticastGroupRequest{} }
func (m *AddDeviceToMulticastGroupRequest) String() string { return proto.CompactTextString(m) }
func (*AddDeviceToMulticastGroupRequest) ProtoMessage()    {}
func (*AddDeviceToMulticastGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{8}
}

func (m *AddDeviceToMulticastGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddDeviceToMulticastGroupRequest.Unmarshal(m, b)
}
func (m *AddDeviceToMulticastGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddDeviceToMulticastGroupRequest.Marshal(b, m, deterministic)
}
func (m *AddDeviceToMulticastGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddDeviceToMulticastGroupRequest.Merge(m, src)
}
func (m *AddDeviceToMulticastGroupRequest) XXX_Size() int {
	return xxx_messageInfo_AddDeviceToMulticastGroupRequest.Size(m)
}
func (m *AddDeviceToMulticastGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddDeviceToMulticastGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddDeviceToMulticastGroupRequest proto.InternalMessageInfo

func (m *AddDeviceToMulticastGroupRequest) GetMulticastGroupId() string {
	if m != nil {
		return m.MulticastGroupId
	}
	return ""
}

func (m *AddDeviceToMulticastGroupRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type RemoveDeviceFromMulticastGroupRequest struct {
	// Multicast-group ID (string formatted UUID).
	MulticastGroupId string `protobuf:"bytes,1,opt,name=multicast_group_id,json=multicastGroupID,proto3" json:"multicast_group_id,omitempty"`
	// Device EUI (HEX encoded string).
	DevEui               string   `protobuf:"bytes,2,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveDeviceFromMulticastGroupRequest) Reset()         { *m = RemoveDeviceFromMulticastGroupRequest{} }
func (m *RemoveDeviceFromMulticastGroupRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveDeviceFromMulticastGroupRequest) ProtoMessage()    {}
func (*RemoveDeviceFromMulticastGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{9}
}

func (m *RemoveDeviceFromMulticastGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveDeviceFromMulticastGroupRequest.Unmarshal(m, b)
}
func (m *RemoveDeviceFromMulticastGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveDeviceFromMulticastGroupRequest.Marshal(b, m, deterministic)
}
func (m *RemoveDeviceFromMulticastGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveDeviceFromMulticastGroupRequest.Merge(m, src)
}
func (m *RemoveDeviceFromMulticastGroupRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveDeviceFromMulticastGroupRequest.Size(m)
}
func (m *RemoveDeviceFromMulticastGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveDeviceFromMulticastGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveDeviceFromMulticastGroupRequest proto.InternalMessageInfo

func (m *RemoveDeviceFromMulticastGroupRequest) GetMulticastGroupId() string {
	if m != nil {
		return m.MulticastGroupId
	}
	return ""
}

func (m *RemoveDeviceFromMulticastGroupRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

type ListMulticastGroupRequest struct {
	// Max number of items to return.
	Limit int64 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset in the result-set (for pagination).
	Offset int64 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// Organization id to filter on.
	OrganizationId int64 `protobuf:"varint,3,opt,name=organization_id,json=organizationID,proto3" json:"organization_id,omitempty"`
	// Device EUI (HEX encoded string) to filter on.
	DevEui string `protobuf:"bytes,4,opt,name=dev_eui,json=devEUI,proto3" json:"dev_eui,omitempty"`
	// Service-profile ID to filter on.
	ServiceProfileId string `protobuf:"bytes,5,opt,name=service_profile_id,json=serviceProfileID,proto3" json:"service_profile_id,omitempty"`
	// Search can be used to search on the multicast-group name.
	Search               string   `protobuf:"bytes,6,opt,name=search,proto3" json:"search,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMulticastGroupRequest) Reset()         { *m = ListMulticastGroupRequest{} }
func (m *ListMulticastGroupRequest) String() string { return proto.CompactTextString(m) }
func (*ListMulticastGroupRequest) ProtoMessage()    {}
func (*ListMulticastGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{10}
}

func (m *ListMulticastGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMulticastGroupRequest.Unmarshal(m, b)
}
func (m *ListMulticastGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMulticastGroupRequest.Marshal(b, m, deterministic)
}
func (m *ListMulticastGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMulticastGroupRequest.Merge(m, src)
}
func (m *ListMulticastGroupRequest) XXX_Size() int {
	return xxx_messageInfo_ListMulticastGroupRequest.Size(m)
}
func (m *ListMulticastGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMulticastGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMulticastGroupRequest proto.InternalMessageInfo

func (m *ListMulticastGroupRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListMulticastGroupRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListMulticastGroupRequest) GetOrganizationId() int64 {
	if m != nil {
		return m.OrganizationId
	}
	return 0
}

func (m *ListMulticastGroupRequest) GetDevEui() string {
	if m != nil {
		return m.DevEui
	}
	return ""
}

func (m *ListMulticastGroupRequest) GetServiceProfileId() string {
	if m != nil {
		return m.ServiceProfileId
	}
	return ""
}

func (m *ListMulticastGroupRequest) GetSearch() string {
	if m != nil {
		return m.Search
	}
	return ""
}

type ListMulticastGroupResponse struct {
	// Total number of multicast-groups.
	TotalCount           int64                     `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	Result               []*MulticastGroupListItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ListMulticastGroupResponse) Reset()         { *m = ListMulticastGroupResponse{} }
func (m *ListMulticastGroupResponse) String() string { return proto.CompactTextString(m) }
func (*ListMulticastGroupResponse) ProtoMessage()    {}
func (*ListMulticastGroupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{11}
}

func (m *ListMulticastGroupResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMulticastGroupResponse.Unmarshal(m, b)
}
func (m *ListMulticastGroupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMulticastGroupResponse.Marshal(b, m, deterministic)
}
func (m *ListMulticastGroupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMulticastGroupResponse.Merge(m, src)
}
func (m *ListMulticastGroupResponse) XXX_Size() int {
	return xxx_messageInfo_ListMulticastGroupResponse.Size(m)
}
func (m *ListMulticastGroupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMulticastGroupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMulticastGroupResponse proto.InternalMessageInfo

func (m *ListMulticastGroupResponse) GetTotalCount() int64 {
	if m != nil {
		return m.TotalCount
	}
	return 0
}

func (m *ListMulticastGroupResponse) GetResult() []*MulticastGroupListItem {
	if m != nil {
		return m.Result
	}
	return nil
}

type MulticastQueueItem struct {
	// Multicast-group ID (string formatted UUID).
	MulticastGroupId string `protobuf:"bytes,1,opt,name=multicast_group_id,json=multicastGroupID,proto3" json:"multicast_group_id,omitempty"`
	// Downlink frame-counter.
	// This will be automatically set on enqueue.
	FCnt uint32 `protobuf:"varint,2,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// FPort used (must be > 0).
	FPort uint32 `protobuf:"varint,3,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// Base64 encoded data.
	Data                 []byte   `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MulticastQueueItem) Reset()         { *m = MulticastQueueItem{} }
func (m *MulticastQueueItem) String() string { return proto.CompactTextString(m) }
func (*MulticastQueueItem) ProtoMessage()    {}
func (*MulticastQueueItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{12}
}

func (m *MulticastQueueItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MulticastQueueItem.Unmarshal(m, b)
}
func (m *MulticastQueueItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MulticastQueueItem.Marshal(b, m, deterministic)
}
func (m *MulticastQueueItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MulticastQueueItem.Merge(m, src)
}
func (m *MulticastQueueItem) XXX_Size() int {
	return xxx_messageInfo_MulticastQueueItem.Size(m)
}
func (m *MulticastQueueItem) XXX_DiscardUnknown() {
	xxx_messageInfo_MulticastQueueItem.DiscardUnknown(m)
}

var xxx_messageInfo_MulticastQueueItem proto.InternalMessageInfo

func (m *MulticastQueueItem) GetMulticastGroupId() string {
	if m != nil {
		return m.MulticastGroupId
	}
	return ""
}

func (m *MulticastQueueItem) GetFCnt() uint32 {
	if m != nil {
		return m.FCnt
	}
	return 0
}

func (m *MulticastQueueItem) GetFPort() uint32 {
	if m != nil {
		return m.FPort
	}
	return 0
}

func (m *MulticastQueueItem) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type EnqueueMulticastQueueItemRequest struct {
	// Multicast queue-item object to enqueue.
	MulticastQueueItem   *MulticastQueueItem `protobuf:"bytes,1,opt,name=multicast_queue_item,json=multicastQueueItem,proto3" json:"multicast_queue_item,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *EnqueueMulticastQueueItemRequest) Reset()         { *m = EnqueueMulticastQueueItemRequest{} }
func (m *EnqueueMulticastQueueItemRequest) String() string { return proto.CompactTextString(m) }
func (*EnqueueMulticastQueueItemRequest) ProtoMessage()    {}
func (*EnqueueMulticastQueueItemRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{13}
}

func (m *EnqueueMulticastQueueItemRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnqueueMulticastQueueItemRequest.Unmarshal(m, b)
}
func (m *EnqueueMulticastQueueItemRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnqueueMulticastQueueItemRequest.Marshal(b, m, deterministic)
}
func (m *EnqueueMulticastQueueItemRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnqueueMulticastQueueItemRequest.Merge(m, src)
}
func (m *EnqueueMulticastQueueItemRequest) XXX_Size() int {
	return xxx_messageInfo_EnqueueMulticastQueueItemRequest.Size(m)
}
func (m *EnqueueMulticastQueueItemRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EnqueueMulticastQueueItemRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EnqueueMulticastQueueItemRequest proto.InternalMessageInfo

func (m *EnqueueMulticastQueueItemRequest) GetMulticastQueueItem() *MulticastQueueItem {
	if m != nil {
		return m.MulticastQueueItem
	}
	return nil
}

type EnqueueMulticastQueueItemResponse struct {
	// Frame-counter for the enqueued payload.
	FCnt                 uint32   `protobuf:"varint,1,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnqueueMulticastQueueItemResponse) Reset()         { *m = EnqueueMulticastQueueItemResponse{} }
func (m *EnqueueMulticastQueueItemResponse) String() string { return proto.CompactTextString(m) }
func (*EnqueueMulticastQueueItemResponse) ProtoMessage()    {}
func (*EnqueueMulticastQueueItemResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{14}
}

func (m *EnqueueMulticastQueueItemResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnqueueMulticastQueueItemResponse.Unmarshal(m, b)
}
func (m *EnqueueMulticastQueueItemResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnqueueMulticastQueueItemResponse.Marshal(b, m, deterministic)
}
func (m *EnqueueMulticastQueueItemResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnqueueMulticastQueueItemResponse.Merge(m, src)
}
func (m *EnqueueMulticastQueueItemResponse) XXX_Size() int {
	return xxx_messageInfo_EnqueueMulticastQueueItemResponse.Size(m)
}
func (m *EnqueueMulticastQueueItemResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EnqueueMulticastQueueItemResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EnqueueMulticastQueueItemResponse proto.InternalMessageInfo

func (m *EnqueueMulticastQueueItemResponse) GetFCnt() uint32 {
	if m != nil {
		return m.FCnt
	}
	return 0
}

type FlushMulticastGroupQueueItemsRequest struct {
	// Multicast-group ID (string formatted UUID).
	MulticastGroupId     string   `protobuf:"bytes,1,opt,name=multicast_group_id,json=multicastGroupID,proto3" json:"multicast_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FlushMulticastGroupQueueItemsRequest) Reset()         { *m = FlushMulticastGroupQueueItemsRequest{} }
func (m *FlushMulticastGroupQueueItemsRequest) String() string { return proto.CompactTextString(m) }
func (*FlushMulticastGroupQueueItemsRequest) ProtoMessage()    {}
func (*FlushMulticastGroupQueueItemsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{15}
}

func (m *FlushMulticastGroupQueueItemsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FlushMulticastGroupQueueItemsRequest.Unmarshal(m, b)
}
func (m *FlushMulticastGroupQueueItemsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FlushMulticastGroupQueueItemsRequest.Marshal(b, m, deterministic)
}
func (m *FlushMulticastGroupQueueItemsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlushMulticastGroupQueueItemsRequest.Merge(m, src)
}
func (m *FlushMulticastGroupQueueItemsRequest) XXX_Size() int {
	return xxx_messageInfo_FlushMulticastGroupQueueItemsRequest.Size(m)
}
func (m *FlushMulticastGroupQueueItemsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FlushMulticastGroupQueueItemsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FlushMulticastGroupQueueItemsRequest proto.InternalMessageInfo

func (m *FlushMulticastGroupQueueItemsRequest) GetMulticastGroupId() string {
	if m != nil {
		return m.MulticastGroupId
	}
	return ""
}

type ListMulticastGroupQueueItemsRequest struct {
	// Multicast-group ID (string formatted UUID).
	MulticastGroupId     string   `protobuf:"bytes,1,opt,name=multicast_group_id,json=multicastGroupID,proto3" json:"multicast_group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMulticastGroupQueueItemsRequest) Reset()         { *m = ListMulticastGroupQueueItemsRequest{} }
func (m *ListMulticastGroupQueueItemsRequest) String() string { return proto.CompactTextString(m) }
func (*ListMulticastGroupQueueItemsRequest) ProtoMessage()    {}
func (*ListMulticastGroupQueueItemsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{16}
}

func (m *ListMulticastGroupQueueItemsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMulticastGroupQueueItemsRequest.Unmarshal(m, b)
}
func (m *ListMulticastGroupQueueItemsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMulticastGroupQueueItemsRequest.Marshal(b, m, deterministic)
}
func (m *ListMulticastGroupQueueItemsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMulticastGroupQueueItemsRequest.Merge(m, src)
}
func (m *ListMulticastGroupQueueItemsRequest) XXX_Size() int {
	return xxx_messageInfo_ListMulticastGroupQueueItemsRequest.Size(m)
}
func (m *ListMulticastGroupQueueItemsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMulticastGroupQueueItemsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMulticastGroupQueueItemsRequest proto.InternalMessageInfo

func (m *ListMulticastGroupQueueItemsRequest) GetMulticastGroupId() string {
	if m != nil {
		return m.MulticastGroupId
	}
	return ""
}

type ListMulticastGroupQueueItemsResponse struct {
	MulticastQueueItems  []*MulticastQueueItem `protobuf:"bytes,1,rep,name=multicast_queue_items,json=multicastQueueItems,proto3" json:"multicast_queue_items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListMulticastGroupQueueItemsResponse) Reset()         { *m = ListMulticastGroupQueueItemsResponse{} }
func (m *ListMulticastGroupQueueItemsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMulticastGroupQueueItemsResponse) ProtoMessage()    {}
func (*ListMulticastGroupQueueItemsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ba1ee9b21d0ef74e, []int{17}
}

func (m *ListMulticastGroupQueueItemsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMulticastGroupQueueItemsResponse.Unmarshal(m, b)
}
func (m *ListMulticastGroupQueueItemsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMulticastGroupQueueItemsResponse.Marshal(b, m, deterministic)
}
func (m *ListMulticastGroupQueueItemsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMulticastGroupQueueItemsResponse.Merge(m, src)
}
func (m *ListMulticastGroupQueueItemsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMulticastGroupQueueItemsResponse.Size(m)
}
func (m *ListMulticastGroupQueueItemsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMulticastGroupQueueItemsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMulticastGroupQueueItemsResponse proto.InternalMessageInfo

func (m *ListMulticastGroupQueueItemsResponse) GetMulticastQueueItems() []*MulticastQueueItem {
	if m != nil {
		return m.MulticastQueueItems
	}
	return nil
}

func init() {
	proto.RegisterEnum("api.MulticastGroupType", MulticastGroupType_name, MulticastGroupType_value)
	proto.RegisterType((*MulticastGroup)(nil), "api.MulticastGroup")
	proto.RegisterType((*MulticastGroupListItem)(nil), "api.MulticastGroupListItem")
	proto.RegisterType((*CreateMulticastGroupRequest)(nil), "api.CreateMulticastGroupRequest")
	proto.RegisterType((*CreateMulticastGroupResponse)(nil), "api.CreateMulticastGroupResponse")
	proto.RegisterType((*GetMulticastGroupRequest)(nil), "api.GetMulticastGroupRequest")
	proto.RegisterType((*GetMulticastGroupResponse)(nil), "api.GetMulticastGroupResponse")
	proto.RegisterType((*UpdateMulticastGroupRequest)(nil), "api.UpdateMulticastGroupRequest")
	proto.RegisterType((*DeleteMulticastGroupRequest)(nil), "api.DeleteMulticastGroupRequest")
	proto.RegisterType((*AddDeviceToMulticastGroupRequest)(nil), "api.AddDeviceToMulticastGroupRequest")
	proto.RegisterType((*RemoveDeviceFromMulticastGroupRequest)(nil), "api.RemoveDeviceFromMulticastGroupRequest")
	proto.RegisterType((*ListMulticastGroupRequest)(nil), "api.ListMulticastGroupRequest")
	proto.RegisterType((*ListMulticastGroupResponse)(nil), "api.ListMulticastGroupResponse")
	proto.RegisterType((*MulticastQueueItem)(nil), "api.MulticastQueueItem")
	proto.RegisterType((*EnqueueMulticastQueueItemRequest)(nil), "api.EnqueueMulticastQueueItemRequest")
	proto.RegisterType((*EnqueueMulticastQueueItemResponse)(nil), "api.EnqueueMulticastQueueItemResponse")
	proto.RegisterType((*FlushMulticastGroupQueueItemsRequest)(nil), "api.FlushMulticastGroupQueueItemsRequest")
	proto.RegisterType((*ListMulticastGroupQueueItemsRequest)(nil), "api.ListMulticastGroupQueueItemsRequest")
	proto.RegisterType((*ListMulticastGroupQueueItemsResponse)(nil), "api.ListMulticastGroupQueueItemsResponse")
}

func init() {
	proto.RegisterFile("as/external/api/multicastGroup.proto", fileDescriptor_ba1ee9b21d0ef74e)
}

var fileDescriptor_ba1ee9b21d0ef74e = []byte{
	// 1219 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0xdd, 0x6e, 0xdb, 0x36,
	0x14, 0x9e, 0xec, 0xc4, 0x99, 0x8f, 0x53, 0x37, 0x60, 0xfe, 0x54, 0x25, 0x5d, 0x5c, 0x2d, 0xdd,
	0x5c, 0xa3, 0xb1, 0x0a, 0x07, 0x5b, 0xdb, 0xa1, 0x1b, 0xe0, 0x26, 0x69, 0x90, 0xb5, 0x2b, 0x32,
	0x39, 0xbd, 0xd9, 0x2e, 0x04, 0x46, 0xa2, 0x1d, 0x22, 0x96, 0xa8, 0x4a, 0x54, 0x3a, 0xaf, 0xc8,
	0x4d, 0xef, 0x7a, 0xbd, 0x9b, 0x61, 0xd8, 0x13, 0xec, 0x11, 0xf6, 0x12, 0xc3, 0xb0, 0x37, 0x18,
	0xf6, 0x20, 0x83, 0x28, 0xda, 0x8e, 0x1d, 0xc9, 0x49, 0x5a, 0xf4, 0x4e, 0x24, 0x0f, 0xcf, 0xf7,
	0x9d, 0x8f, 0xe7, 0xc7, 0x86, 0x75, 0x1c, 0x1a, 0xe4, 0x27, 0x4e, 0x02, 0x0f, 0x77, 0x0d, 0xec,
	0x53, 0xc3, 0x8d, 0xba, 0x9c, 0xda, 0x38, 0xe4, 0xbb, 0x01, 0x8b, 0xfc, 0xba, 0x1f, 0x30, 0xce,
	0x50, 0x1e, 0xfb, 0x54, 0x5b, 0xed, 0x30, 0xd6, 0xe9, 0x12, 0x61, 0x85, 0x3d, 0x8f, 0x71, 0xcc,
	0x29, 0xf3, 0xc2, 0xc4, 0x44, 0x5b, 0x93, 0xa7, 0x62, 0x75, 0x18, 0xb5, 0x0d, 0x4e, 0x5d, 0x12,
	0x72, 0xec, 0x4a, 0x1f, 0xda, 0xca, 0xb8, 0x01, 0x71, 0x7d, 0xde, 0x4b, 0x0e, 0xf5, 0x7f, 0x73,
	0x50, 0xfe, 0x6e, 0x04, 0x19, 0x95, 0x21, 0x47, 0x1d, 0x55, 0xa9, 0x28, 0xd5, 0xa2, 0x99, 0xa3,
	0x0e, 0x42, 0x30, 0xe5, 0x61, 0x97, 0xa8, 0x39, 0xb1, 0x23, 0xbe, 0xd1, 0x32, 0xcc, 0xb8, 0xb6,
	0x85, 0x1d, 0x27, 0x50, 0xf3, 0x62, 0xbb, 0xe0, 0xda, 0x4d, 0xc7, 0x09, 0xd0, 0x1a, 0xcc, 0xba,
	0xb6, 0xe5, 0xbd, 0x3a, 0xb6, 0x42, 0xeb, 0x98, 0xf4, 0xd4, 0x29, 0x71, 0x5a, 0x74, 0xed, 0xe7,
	0xaf, 0x8e, 0x5b, 0x4f, 0x49, 0x4f, 0x1a, 0x60, 0xdf, 0x97, 0x06, 0xd3, 0x7d, 0x83, 0xa6, 0xef,
	0x0b, 0x83, 0x79, 0x98, 0x6e, 0x5b, 0xb6, 0xc7, 0xd5, 0x42, 0x45, 0xa9, 0x5e, 0x33, 0xa7, 0xda,
	0x5b, 0x1e, 0x47, 0x5f, 0x02, 0x74, 0x62, 0x72, 0x16, 0xef, 0xf9, 0x44, 0x9d, 0xa9, 0x28, 0xd5,
	0x72, 0x63, 0xb9, 0x8e, 0x7d, 0x5a, 0x1f, 0x25, 0x7f, 0xd0, 0xf3, 0x89, 0x59, 0xec, 0xf4, 0x3f,
	0xe3, 0x58, 0x9c, 0x40, 0xfd, 0x58, 0x78, 0xca, 0x39, 0x01, 0x5a, 0x85, 0x62, 0x3b, 0x20, 0x2f,
	0x23, 0xe2, 0xd9, 0x3d, 0xb5, 0x28, 0xb6, 0x87, 0x1b, 0xa8, 0x0a, 0x73, 0x3e, 0xf5, 0x3a, 0x56,
	0xd8, 0x65, 0xdc, 0xf2, 0x49, 0x40, 0x99, 0xa3, 0x82, 0x30, 0x2a, 0xc7, 0xfb, 0xad, 0x2e, 0xe3,
	0xfb, 0x62, 0x17, 0xdd, 0x05, 0x14, 0x92, 0xe0, 0x84, 0xda, 0xc4, 0xf2, 0x03, 0xd6, 0xa6, 0x5d,
	0x62, 0x51, 0x47, 0x2d, 0x89, 0x58, 0xe6, 0xe4, 0xc9, 0x7e, 0x72, 0xb0, 0xb7, 0xad, 0xff, 0xae,
	0xc0, 0xd2, 0x28, 0xcf, 0x67, 0x34, 0xe4, 0x7b, 0x9c, 0xb8, 0x97, 0x12, 0x3b, 0x1d, 0x2c, 0x9f,
	0x0e, 0x86, 0xee, 0xc1, 0xc2, 0xb8, 0xb5, 0xf0, 0x98, 0xbc, 0x04, 0x1a, 0xb5, 0x7f, 0x8e, 0x5d,
	0xa2, 0xff, 0x08, 0x2b, 0x5b, 0x01, 0xc1, 0x9c, 0x8c, 0x72, 0x34, 0x63, 0x59, 0x42, 0x8e, 0x1e,
	0xc1, 0xf5, 0x41, 0x6e, 0x5a, 0x42, 0x5a, 0xc1, 0xb7, 0xd4, 0x98, 0x4f, 0x79, 0x00, 0xb3, 0x3c,
	0x9a, 0xc7, 0x7a, 0x1d, 0x56, 0xd3, 0x9d, 0x87, 0x3e, 0xf3, 0x42, 0x32, 0x2e, 0x80, 0x5e, 0x03,
	0x75, 0x97, 0xf0, 0x74, 0x26, 0xe3, 0xb6, 0x7f, 0x29, 0x70, 0x23, 0xc5, 0x58, 0x7a, 0x7e, 0x2f,
	0xde, 0xe8, 0x21, 0x80, 0x2d, 0x78, 0x3b, 0x16, 0xe6, 0xe2, 0x39, 0x4a, 0x0d, 0xad, 0x9e, 0x94,
	0x52, 0xbd, 0x5f, 0x4a, 0xf5, 0x83, 0x7e, 0xad, 0x99, 0x45, 0x69, 0xdd, 0xe4, 0xf1, 0xd5, 0xc8,
	0x77, 0xfa, 0x57, 0xf3, 0x17, 0x5f, 0x95, 0xd6, 0x4d, 0x1e, 0x3f, 0xc5, 0x0b, 0xb1, 0xf8, 0x10,
	0x4f, 0xb1, 0x01, 0x2b, 0xdb, 0xa4, 0x4b, 0xb2, 0x9c, 0x8f, 0xab, 0x4b, 0xa1, 0xd2, 0x74, 0x9c,
	0x6d, 0x12, 0xa7, 0xcb, 0x01, 0x4b, 0xbf, 0x73, 0x17, 0xd0, 0x18, 0x21, 0x6b, 0xe0, 0x63, 0x6e,
	0x14, 0x7e, 0x6f, 0x3b, 0xee, 0x1a, 0x0e, 0x39, 0xb1, 0x48, 0x44, 0x65, 0x7e, 0x17, 0x1c, 0x72,
	0xb2, 0xf3, 0x62, 0x4f, 0xf7, 0xe0, 0xb6, 0x49, 0x5c, 0x76, 0x42, 0x12, 0xb4, 0x27, 0x01, 0x73,
	0x3f, 0x28, 0xde, 0xdf, 0x0a, 0xdc, 0x88, 0x4b, 0x30, 0x1d, 0x64, 0x01, 0xa6, 0xbb, 0xd4, 0xa5,
	0x5c, 0xf8, 0xcd, 0x9b, 0xc9, 0x02, 0x2d, 0x41, 0x81, 0xb5, 0xdb, 0x21, 0x49, 0x92, 0x21, 0x6f,
	0xca, 0x15, 0xfa, 0x1c, 0xae, 0xb3, 0xa0, 0x83, 0x3d, 0xfa, 0xb3, 0x68, 0xcb, 0xfd, 0xd2, 0xcc,
	0x9b, 0xe5, 0xb3, 0xdb, 0xa3, 0x6c, 0xa6, 0xce, 0xb2, 0xc9, 0xa8, 0xef, 0xe9, 0x8c, 0xfa, 0x5e,
	0x82, 0x42, 0x48, 0x70, 0x60, 0x1f, 0x89, 0x06, 0x59, 0x34, 0xe5, 0x4a, 0x0f, 0x40, 0x4b, 0x0b,
	0x49, 0x16, 0xc3, 0x1a, 0x94, 0x38, 0xe3, 0xb8, 0x6b, 0xd9, 0x2c, 0xf2, 0xfa, 0x91, 0x81, 0xd8,
	0xda, 0x8a, 0x77, 0xd0, 0x26, 0x14, 0x02, 0x12, 0x46, 0xdd, 0x38, 0xbc, 0x7c, 0xb5, 0xd4, 0x58,
	0x49, 0xc9, 0xa8, 0x7e, 0xd7, 0x32, 0xa5, 0xa9, 0xfe, 0x46, 0x01, 0x34, 0x30, 0xf9, 0x3e, 0x22,
	0x11, 0x11, 0x4d, 0xed, 0x6a, 0xaf, 0x34, 0x68, 0xf8, 0xb9, 0x33, 0x0d, 0x7f, 0x11, 0x0a, 0x6d,
	0xcb, 0x67, 0x41, 0x52, 0x3f, 0xd7, 0xcc, 0xe9, 0xf6, 0x3e, 0x0b, 0x78, 0xdc, 0x1e, 0x1d, 0xcc,
	0xb1, 0x10, 0x70, 0xd6, 0x14, 0xdf, 0xba, 0x0b, 0x95, 0x1d, 0xef, 0x65, 0x0c, 0x7e, 0x9e, 0x4a,
	0xff, 0x49, 0xf7, 0x60, 0x61, 0xc8, 0x48, 0xd8, 0x5a, 0x94, 0x13, 0x57, 0x56, 0xcf, 0xd8, 0x24,
	0x19, 0xde, 0x1e, 0x86, 0x31, 0xd8, 0xd3, 0x1f, 0xc0, 0xad, 0x09, 0x70, 0x52, 0xee, 0x41, 0x4c,
	0xca, 0x30, 0x26, 0xfd, 0x00, 0xd6, 0x9f, 0x74, 0xa3, 0xf0, 0x68, 0x54, 0xd4, 0xc1, 0xe5, 0xf0,
	0x9d, 0x92, 0x5c, 0x6f, 0xc1, 0xa7, 0xe7, 0xdf, 0xfd, 0x7d, 0x9d, 0x86, 0xb0, 0x3e, 0xd9, 0xa9,
	0x8c, 0xf3, 0x29, 0x2c, 0xa6, 0xe9, 0x1a, 0xaa, 0x8a, 0x48, 0xa2, 0x4c, 0x61, 0xe7, 0xcf, 0x0b,
	0x1b, 0xd6, 0xea, 0x67, 0x92, 0x69, 0x30, 0xcd, 0x51, 0x09, 0x66, 0xb6, 0x9e, 0x35, 0x5b, 0x2d,
	0x6b, 0x6b, 0xee, 0xa3, 0xe1, 0xe2, 0xf1, 0x9c, 0xd2, 0xf8, 0x13, 0x60, 0x71, 0xf4, 0x42, 0x2b,
	0x29, 0x16, 0xc4, 0xa0, 0x90, 0x0c, 0x1d, 0x54, 0x11, 0x0c, 0x26, 0x8c, 0x37, 0xed, 0xd6, 0x04,
	0x8b, 0x24, 0x4a, 0xbd, 0xf2, 0xe6, 0x9f, 0xff, 0x7e, 0xc9, 0x69, 0xfa, 0xe2, 0xe8, 0x0f, 0xb5,
	0x0d, 0x21, 0x63, 0xf8, 0x95, 0x52, 0x43, 0x47, 0x90, 0xdf, 0x25, 0x1c, 0xdd, 0x14, 0xbe, 0xb2,
	0xe6, 0x97, 0xf6, 0x49, 0xd6, 0xb1, 0xc4, 0xd1, 0x05, 0xce, 0x2a, 0xd2, 0x52, 0x71, 0x8c, 0xd7,
	0xd4, 0x39, 0x45, 0x3d, 0x28, 0x24, 0x13, 0x42, 0x86, 0x36, 0x61, 0x5c, 0x68, 0x4b, 0xe7, 0x86,
	0xce, 0x4e, 0xfc, 0xd3, 0x4f, 0xff, 0x42, 0xe0, 0x18, 0x5a, 0x2d, 0x03, 0x67, 0x2c, 0x51, 0xea,
	0xd4, 0x39, 0x8d, 0x83, 0x6c, 0x43, 0x21, 0x99, 0x1f, 0x12, 0x7a, 0xc2, 0x30, 0xc9, 0x84, 0x96,
	0x21, 0xd6, 0x26, 0x85, 0xd8, 0x86, 0xa9, 0x38, 0xf9, 0x50, 0x22, 0x57, 0x66, 0x9f, 0xd6, 0xd6,
	0x32, 0xcf, 0xa5, 0x9e, 0x37, 0x05, 0xd8, 0x32, 0x4a, 0x7f, 0x37, 0xf4, 0x56, 0x81, 0xe2, 0x60,
	0xc2, 0xa1, 0xdb, 0xc2, 0xdb, 0x45, 0x13, 0x2f, 0x33, 0xb0, 0xaf, 0x05, 0xd6, 0x7d, 0xbd, 0x71,
	0x39, 0x4d, 0x2d, 0xea, 0x9c, 0x1a, 0x8e, 0x40, 0x12, 0x09, 0xf4, 0xab, 0x02, 0xb3, 0x67, 0x47,
	0x20, 0xaa, 0x09, 0x3a, 0x97, 0x9a, 0x8a, 0x99, 0x9c, 0xb6, 0x05, 0xa7, 0x6f, 0x6a, 0x8f, 0xae,
	0xce, 0xc9, 0x78, 0x2d, 0x67, 0xd5, 0x29, 0xfa, 0x43, 0x81, 0x19, 0xd9, 0xf1, 0xa4, 0x48, 0x17,
	0xb5, 0x5b, 0xed, 0xb3, 0x8b, 0xcc, 0xe4, 0x03, 0xed, 0x0b, 0x82, 0xdf, 0xea, 0x3b, 0x17, 0x12,
	0x1c, 0xf6, 0x96, 0x7a, 0x1a, 0x6b, 0x71, 0x1c, 0xeb, 0xf8, 0x56, 0x01, 0x10, 0x4d, 0x56, 0x80,
	0xa1, 0x3b, 0x82, 0xc8, 0x65, 0xba, 0x6e, 0xa6, 0x88, 0x0f, 0x04, 0xc7, 0x46, 0xed, 0xde, 0x15,
	0x44, 0x4c, 0xc4, 0xfa, 0x4d, 0x81, 0x62, 0x9c, 0x9d, 0x09, 0x95, 0x6a, 0x46, 0xb6, 0x9e, 0x67,
	0x72, 0xe7, 0x12, 0x96, 0x52, 0x40, 0x49, 0x0e, 0x5d, 0x99, 0xdc, 0xe3, 0x87, 0x3f, 0xdc, 0xef,
	0x50, 0x7e, 0x14, 0x1d, 0xd6, 0x6d, 0xe6, 0x1a, 0x87, 0x01, 0xb3, 0x31, 0x0e, 0x0c, 0xfb, 0x88,
	0x06, 0x7e, 0xc8, 0xb1, 0x7d, 0xbc, 0x11, 0x3b, 0xec, 0x30, 0xe3, 0x64, 0xd3, 0x18, 0xfb, 0xa7,
	0x7a, 0x58, 0x10, 0x0a, 0x6d, 0xfe, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x4a, 0x15, 0x9d, 0x07, 0xc3,
	0x0e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MulticastGroupServiceClient is the client API for MulticastGroupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MulticastGroupServiceClient interface {
	// Create creates the given multicast-group.
	Create(ctx context.Context, in *CreateMulticastGroupRequest, opts ...grpc.CallOption) (*CreateMulticastGroupResponse, error)
	// Get returns a multicast-group given an ID.
	Get(ctx context.Context, in *GetMulticastGroupRequest, opts ...grpc.CallOption) (*GetMulticastGroupResponse, error)
	// Update updates the given multicast-group.
	Update(ctx context.Context, in *UpdateMulticastGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Delete deletes a multicast-group given an ID.
	Delete(ctx context.Context, in *DeleteMulticastGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// List lists the available multicast-groups.
	List(ctx context.Context, in *ListMulticastGroupRequest, opts ...grpc.CallOption) (*ListMulticastGroupResponse, error)
	// AddDevice adds the given device to the multicast-group.
	AddDevice(ctx context.Context, in *AddDeviceToMulticastGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// RemoveDevice removes the given device from the multicast-group.
	RemoveDevice(ctx context.Context, in *RemoveDeviceFromMulticastGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Enqueue adds the given item to the multicast-queue.
	Enqueue(ctx context.Context, in *EnqueueMulticastQueueItemRequest, opts ...grpc.CallOption) (*EnqueueMulticastQueueItemResponse, error)
	// FlushQueue flushes the multicast-group queue.
	FlushQueue(ctx context.Context, in *FlushMulticastGroupQueueItemsRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// ListQueue lists the items in the multicast-group queue.
	ListQueue(ctx context.Context, in *ListMulticastGroupQueueItemsRequest, opts ...grpc.CallOption) (*ListMulticastGroupQueueItemsResponse, error)
}

type multicastGroupServiceClient struct {
	cc *grpc.ClientConn
}

func NewMulticastGroupServiceClient(cc *grpc.ClientConn) MulticastGroupServiceClient {
	return &multicastGroupServiceClient{cc}
}

func (c *multicastGroupServiceClient) Create(ctx context.Context, in *CreateMulticastGroupRequest, opts ...grpc.CallOption) (*CreateMulticastGroupResponse, error) {
	out := new(CreateMulticastGroupResponse)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/Create", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) Get(ctx context.Context, in *GetMulticastGroupRequest, opts ...grpc.CallOption) (*GetMulticastGroupResponse, error) {
	out := new(GetMulticastGroupResponse)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/Get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) Update(ctx context.Context, in *UpdateMulticastGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) Delete(ctx context.Context, in *DeleteMulticastGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) List(ctx context.Context, in *ListMulticastGroupRequest, opts ...grpc.CallOption) (*ListMulticastGroupResponse, error) {
	out := new(ListMulticastGroupResponse)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/List", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) AddDevice(ctx context.Context, in *AddDeviceToMulticastGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/AddDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) RemoveDevice(ctx context.Context, in *RemoveDeviceFromMulticastGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/RemoveDevice", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) Enqueue(ctx context.Context, in *EnqueueMulticastQueueItemRequest, opts ...grpc.CallOption) (*EnqueueMulticastQueueItemResponse, error) {
	out := new(EnqueueMulticastQueueItemResponse)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/Enqueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) FlushQueue(ctx context.Context, in *FlushMulticastGroupQueueItemsRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/FlushQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *multicastGroupServiceClient) ListQueue(ctx context.Context, in *ListMulticastGroupQueueItemsRequest, opts ...grpc.CallOption) (*ListMulticastGroupQueueItemsResponse, error) {
	out := new(ListMulticastGroupQueueItemsResponse)
	err := c.cc.Invoke(ctx, "/api.MulticastGroupService/ListQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MulticastGroupServiceServer is the server API for MulticastGroupService service.
type MulticastGroupServiceServer interface {
	// Create creates the given multicast-group.
	Create(context.Context, *CreateMulticastGroupRequest) (*CreateMulticastGroupResponse, error)
	// Get returns a multicast-group given an ID.
	Get(context.Context, *GetMulticastGroupRequest) (*GetMulticastGroupResponse, error)
	// Update updates the given multicast-group.
	Update(context.Context, *UpdateMulticastGroupRequest) (*empty.Empty, error)
	// Delete deletes a multicast-group given an ID.
	Delete(context.Context, *DeleteMulticastGroupRequest) (*empty.Empty, error)
	// List lists the available multicast-groups.
	List(context.Context, *ListMulticastGroupRequest) (*ListMulticastGroupResponse, error)
	// AddDevice adds the given device to the multicast-group.
	AddDevice(context.Context, *AddDeviceToMulticastGroupRequest) (*empty.Empty, error)
	// RemoveDevice removes the given device from the multicast-group.
	RemoveDevice(context.Context, *RemoveDeviceFromMulticastGroupRequest) (*empty.Empty, error)
	// Enqueue adds the given item to the multicast-queue.
	Enqueue(context.Context, *EnqueueMulticastQueueItemRequest) (*EnqueueMulticastQueueItemResponse, error)
	// FlushQueue flushes the multicast-group queue.
	FlushQueue(context.Context, *FlushMulticastGroupQueueItemsRequest) (*empty.Empty, error)
	// ListQueue lists the items in the multicast-group queue.
	ListQueue(context.Context, *ListMulticastGroupQueueItemsRequest) (*ListMulticastGroupQueueItemsResponse, error)
}

// UnimplementedMulticastGroupServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMulticastGroupServiceServer struct {
}

func (*UnimplementedMulticastGroupServiceServer) Create(ctx context.Context, req *CreateMulticastGroupRequest) (*CreateMulticastGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) Get(ctx context.Context, req *GetMulticastGroupRequest) (*GetMulticastGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) Update(ctx context.Context, req *UpdateMulticastGroupRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) Delete(ctx context.Context, req *DeleteMulticastGroupRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) List(ctx context.Context, req *ListMulticastGroupRequest) (*ListMulticastGroupResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) AddDevice(ctx context.Context, req *AddDeviceToMulticastGroupRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddDevice not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) RemoveDevice(ctx context.Context, req *RemoveDeviceFromMulticastGroupRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveDevice not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) Enqueue(ctx context.Context, req *EnqueueMulticastQueueItemRequest) (*EnqueueMulticastQueueItemResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Enqueue not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) FlushQueue(ctx context.Context, req *FlushMulticastGroupQueueItemsRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FlushQueue not implemented")
}
func (*UnimplementedMulticastGroupServiceServer) ListQueue(ctx context.Context, req *ListMulticastGroupQueueItemsRequest) (*ListMulticastGroupQueueItemsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQueue not implemented")
}

func RegisterMulticastGroupServiceServer(s *grpc.Server, srv MulticastGroupServiceServer) {
	s.RegisterService(&_MulticastGroupService_serviceDesc, srv)
}

func _MulticastGroupService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMulticastGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).Create(ctx, req.(*CreateMulticastGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMulticastGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/Get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).Get(ctx, req.(*GetMulticastGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMulticastGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).Update(ctx, req.(*UpdateMulticastGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMulticastGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).Delete(ctx, req.(*DeleteMulticastGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMulticastGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/List",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).List(ctx, req.(*ListMulticastGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_AddDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddDeviceToMulticastGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).AddDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/AddDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).AddDevice(ctx, req.(*AddDeviceToMulticastGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_RemoveDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveDeviceFromMulticastGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).RemoveDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/RemoveDevice",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).RemoveDevice(ctx, req.(*RemoveDeviceFromMulticastGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_Enqueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnqueueMulticastQueueItemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).Enqueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/Enqueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).Enqueue(ctx, req.(*EnqueueMulticastQueueItemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_FlushQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FlushMulticastGroupQueueItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).FlushQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/FlushQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).FlushQueue(ctx, req.(*FlushMulticastGroupQueueItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MulticastGroupService_ListQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMulticastGroupQueueItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MulticastGroupServiceServer).ListQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.MulticastGroupService/ListQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MulticastGroupServiceServer).ListQueue(ctx, req.(*ListMulticastGroupQueueItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MulticastGroupService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.MulticastGroupService",
	HandlerType: (*MulticastGroupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Create",
			Handler:    _MulticastGroupService_Create_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _MulticastGroupService_Get_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _MulticastGroupService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _MulticastGroupService_Delete_Handler,
		},
		{
			MethodName: "List",
			Handler:    _MulticastGroupService_List_Handler,
		},
		{
			MethodName: "AddDevice",
			Handler:    _MulticastGroupService_AddDevice_Handler,
		},
		{
			MethodName: "RemoveDevice",
			Handler:    _MulticastGroupService_RemoveDevice_Handler,
		},
		{
			MethodName: "Enqueue",
			Handler:    _MulticastGroupService_Enqueue_Handler,
		},
		{
			MethodName: "FlushQueue",
			Handler:    _MulticastGroupService_FlushQueue_Handler,
		},
		{
			MethodName: "ListQueue",
			Handler:    _MulticastGroupService_ListQueue_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "as/external/api/multicastGroup.proto",
}
