// Code generated by protoc-gen-go. DO NOT EDIT.
// source: gw/gw.proto

package gw

import (
	fmt "fmt"
	common "github.com/brocaar/chirpstack-api/go/v3/common"
	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type DownlinkTiming int32

const (
	// Send the downlink immediately.
	DownlinkTiming_IMMEDIATELY DownlinkTiming = 0
	// Send downlink at the given delay (based on provided context).
	DownlinkTiming_DELAY DownlinkTiming = 1
	// Send at given GPS epoch value.
	DownlinkTiming_GPS_EPOCH DownlinkTiming = 2
)

var DownlinkTiming_name = map[int32]string{
	0: "IMMEDIATELY",
	1: "DELAY",
	2: "GPS_EPOCH",
}

var DownlinkTiming_value = map[string]int32{
	"IMMEDIATELY": 0,
	"DELAY":       1,
	"GPS_EPOCH":   2,
}

func (x DownlinkTiming) String() string {
	return proto.EnumName(DownlinkTiming_name, int32(x))
}

func (DownlinkTiming) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{0}
}

type FineTimestampType int32

const (
	// No fine-timestamp available.
	FineTimestampType_NONE FineTimestampType = 0
	// Encrypted fine-timestamp.
	FineTimestampType_ENCRYPTED FineTimestampType = 1
	// Plain fine-timestamp.
	FineTimestampType_PLAIN FineTimestampType = 2
)

var FineTimestampType_name = map[int32]string{
	0: "NONE",
	1: "ENCRYPTED",
	2: "PLAIN",
}

var FineTimestampType_value = map[string]int32{
	"NONE":      0,
	"ENCRYPTED": 1,
	"PLAIN":     2,
}

func (x FineTimestampType) String() string {
	return proto.EnumName(FineTimestampType_name, int32(x))
}

func (FineTimestampType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{1}
}

type CRCStatus int32

const (
	// No CRC.
	CRCStatus_NO_CRC CRCStatus = 0
	// Bad CRC.
	CRCStatus_BAD_CRC CRCStatus = 1
	// CRC OK.
	CRCStatus_CRC_OK CRCStatus = 2
)

var CRCStatus_name = map[int32]string{
	0: "NO_CRC",
	1: "BAD_CRC",
	2: "CRC_OK",
}

var CRCStatus_value = map[string]int32{
	"NO_CRC":  0,
	"BAD_CRC": 1,
	"CRC_OK":  2,
}

func (x CRCStatus) String() string {
	return proto.EnumName(CRCStatus_name, int32(x))
}

func (CRCStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{2}
}

type UplinkTXInfo struct {
	// Frequency (Hz).
	Frequency uint32 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Modulation.
	Modulation common.Modulation `protobuf:"varint,2,opt,name=modulation,proto3,enum=common.Modulation" json:"modulation,omitempty"`
	// Types that are valid to be assigned to ModulationInfo:
	//	*UplinkTXInfo_LoraModulationInfo
	//	*UplinkTXInfo_FskModulationInfo
	ModulationInfo       isUplinkTXInfo_ModulationInfo `protobuf_oneof:"modulation_info"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UplinkTXInfo) Reset()         { *m = UplinkTXInfo{} }
func (m *UplinkTXInfo) String() string { return proto.CompactTextString(m) }
func (*UplinkTXInfo) ProtoMessage()    {}
func (*UplinkTXInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{0}
}

func (m *UplinkTXInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UplinkTXInfo.Unmarshal(m, b)
}
func (m *UplinkTXInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UplinkTXInfo.Marshal(b, m, deterministic)
}
func (m *UplinkTXInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UplinkTXInfo.Merge(m, src)
}
func (m *UplinkTXInfo) XXX_Size() int {
	return xxx_messageInfo_UplinkTXInfo.Size(m)
}
func (m *UplinkTXInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UplinkTXInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UplinkTXInfo proto.InternalMessageInfo

func (m *UplinkTXInfo) GetFrequency() uint32 {
	if m != nil {
		return m.Frequency
	}
	return 0
}

func (m *UplinkTXInfo) GetModulation() common.Modulation {
	if m != nil {
		return m.Modulation
	}
	return common.Modulation_LORA
}

type isUplinkTXInfo_ModulationInfo interface {
	isUplinkTXInfo_ModulationInfo()
}

type UplinkTXInfo_LoraModulationInfo struct {
	LoraModulationInfo *LoRaModulationInfo `protobuf:"bytes,3,opt,name=lora_modulation_info,json=loRaModulationInfo,proto3,oneof"`
}

type UplinkTXInfo_FskModulationInfo struct {
	FskModulationInfo *FSKModulationInfo `protobuf:"bytes,4,opt,name=fsk_modulation_info,json=fskModulationInfo,proto3,oneof"`
}

func (*UplinkTXInfo_LoraModulationInfo) isUplinkTXInfo_ModulationInfo() {}

func (*UplinkTXInfo_FskModulationInfo) isUplinkTXInfo_ModulationInfo() {}

func (m *UplinkTXInfo) GetModulationInfo() isUplinkTXInfo_ModulationInfo {
	if m != nil {
		return m.ModulationInfo
	}
	return nil
}

func (m *UplinkTXInfo) GetLoraModulationInfo() *LoRaModulationInfo {
	if x, ok := m.GetModulationInfo().(*UplinkTXInfo_LoraModulationInfo); ok {
		return x.LoraModulationInfo
	}
	return nil
}

func (m *UplinkTXInfo) GetFskModulationInfo() *FSKModulationInfo {
	if x, ok := m.GetModulationInfo().(*UplinkTXInfo_FskModulationInfo); ok {
		return x.FskModulationInfo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UplinkTXInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UplinkTXInfo_LoraModulationInfo)(nil),
		(*UplinkTXInfo_FskModulationInfo)(nil),
	}
}

type LoRaModulationInfo struct {
	// Bandwidth.
	Bandwidth uint32 `protobuf:"varint,1,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	// Speading-factor.
	SpreadingFactor uint32 `protobuf:"varint,2,opt,name=spreading_factor,json=spreadingFactor,proto3" json:"spreading_factor,omitempty"`
	// Code-rate.
	CodeRate string `protobuf:"bytes,3,opt,name=code_rate,json=codeRate,proto3" json:"code_rate,omitempty"`
	// Polarization inversion.
	PolarizationInversion bool     `protobuf:"varint,4,opt,name=polarization_inversion,json=polarizationInversion,proto3" json:"polarization_inversion,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *LoRaModulationInfo) Reset()         { *m = LoRaModulationInfo{} }
func (m *LoRaModulationInfo) String() string { return proto.CompactTextString(m) }
func (*LoRaModulationInfo) ProtoMessage()    {}
func (*LoRaModulationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{1}
}

func (m *LoRaModulationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoRaModulationInfo.Unmarshal(m, b)
}
func (m *LoRaModulationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoRaModulationInfo.Marshal(b, m, deterministic)
}
func (m *LoRaModulationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoRaModulationInfo.Merge(m, src)
}
func (m *LoRaModulationInfo) XXX_Size() int {
	return xxx_messageInfo_LoRaModulationInfo.Size(m)
}
func (m *LoRaModulationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LoRaModulationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LoRaModulationInfo proto.InternalMessageInfo

func (m *LoRaModulationInfo) GetBandwidth() uint32 {
	if m != nil {
		return m.Bandwidth
	}
	return 0
}

func (m *LoRaModulationInfo) GetSpreadingFactor() uint32 {
	if m != nil {
		return m.SpreadingFactor
	}
	return 0
}

func (m *LoRaModulationInfo) GetCodeRate() string {
	if m != nil {
		return m.CodeRate
	}
	return ""
}

func (m *LoRaModulationInfo) GetPolarizationInversion() bool {
	if m != nil {
		return m.PolarizationInversion
	}
	return false
}

type FSKModulationInfo struct {
	// Frequency deviation.
	FrequencyDeviation uint32 `protobuf:"varint,1,opt,name=frequency_deviation,json=frequencyDeviation,proto3" json:"frequency_deviation,omitempty"`
	// FSK datarate (bits / sec).
	Datarate             uint32   `protobuf:"varint,2,opt,name=datarate,proto3" json:"datarate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FSKModulationInfo) Reset()         { *m = FSKModulationInfo{} }
func (m *FSKModulationInfo) String() string { return proto.CompactTextString(m) }
func (*FSKModulationInfo) ProtoMessage()    {}
func (*FSKModulationInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{2}
}

func (m *FSKModulationInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FSKModulationInfo.Unmarshal(m, b)
}
func (m *FSKModulationInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FSKModulationInfo.Marshal(b, m, deterministic)
}
func (m *FSKModulationInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FSKModulationInfo.Merge(m, src)
}
func (m *FSKModulationInfo) XXX_Size() int {
	return xxx_messageInfo_FSKModulationInfo.Size(m)
}
func (m *FSKModulationInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_FSKModulationInfo.DiscardUnknown(m)
}

var xxx_messageInfo_FSKModulationInfo proto.InternalMessageInfo

func (m *FSKModulationInfo) GetFrequencyDeviation() uint32 {
	if m != nil {
		return m.FrequencyDeviation
	}
	return 0
}

func (m *FSKModulationInfo) GetDatarate() uint32 {
	if m != nil {
		return m.Datarate
	}
	return 0
}

type EncryptedFineTimestamp struct {
	// AES key index used for encrypting the fine timestamp.
	AesKeyIndex uint32 `protobuf:"varint,1,opt,name=aes_key_index,json=aesKeyIndex,proto3" json:"aes_key_index,omitempty"`
	// Encrypted 'main' fine-timestamp (ns precision part of the timestamp).
	EncryptedNs []byte `protobuf:"bytes,2,opt,name=encrypted_ns,json=encryptedNS,proto3" json:"encrypted_ns,omitempty"`
	// FPGA ID.
	FpgaId               []byte   `protobuf:"bytes,3,opt,name=fpga_id,json=fpgaID,proto3" json:"fpga_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptedFineTimestamp) Reset()         { *m = EncryptedFineTimestamp{} }
func (m *EncryptedFineTimestamp) String() string { return proto.CompactTextString(m) }
func (*EncryptedFineTimestamp) ProtoMessage()    {}
func (*EncryptedFineTimestamp) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{3}
}

func (m *EncryptedFineTimestamp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EncryptedFineTimestamp.Unmarshal(m, b)
}
func (m *EncryptedFineTimestamp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EncryptedFineTimestamp.Marshal(b, m, deterministic)
}
func (m *EncryptedFineTimestamp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptedFineTimestamp.Merge(m, src)
}
func (m *EncryptedFineTimestamp) XXX_Size() int {
	return xxx_messageInfo_EncryptedFineTimestamp.Size(m)
}
func (m *EncryptedFineTimestamp) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptedFineTimestamp.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptedFineTimestamp proto.InternalMessageInfo

func (m *EncryptedFineTimestamp) GetAesKeyIndex() uint32 {
	if m != nil {
		return m.AesKeyIndex
	}
	return 0
}

func (m *EncryptedFineTimestamp) GetEncryptedNs() []byte {
	if m != nil {
		return m.EncryptedNs
	}
	return nil
}

func (m *EncryptedFineTimestamp) GetFpgaId() []byte {
	if m != nil {
		return m.FpgaId
	}
	return nil
}

type PlainFineTimestamp struct {
	// Full timestamp.
	Time                 *timestamp.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlainFineTimestamp) Reset()         { *m = PlainFineTimestamp{} }
func (m *PlainFineTimestamp) String() string { return proto.CompactTextString(m) }
func (*PlainFineTimestamp) ProtoMessage()    {}
func (*PlainFineTimestamp) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{4}
}

func (m *PlainFineTimestamp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlainFineTimestamp.Unmarshal(m, b)
}
func (m *PlainFineTimestamp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlainFineTimestamp.Marshal(b, m, deterministic)
}
func (m *PlainFineTimestamp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlainFineTimestamp.Merge(m, src)
}
func (m *PlainFineTimestamp) XXX_Size() int {
	return xxx_messageInfo_PlainFineTimestamp.Size(m)
}
func (m *PlainFineTimestamp) XXX_DiscardUnknown() {
	xxx_messageInfo_PlainFineTimestamp.DiscardUnknown(m)
}

var xxx_messageInfo_PlainFineTimestamp proto.InternalMessageInfo

func (m *PlainFineTimestamp) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

type GatewayStats struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// Gateway IP.
	Ip string `protobuf:"bytes,9,opt,name=ip,proto3" json:"ip,omitempty"`
	// Gateway time.
	Time *timestamp.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Gateway location.
	Location *common.Location `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// Gateway configuration version (this maps to the config_version sent
	// by LoRa Server to the gateway).
	ConfigVersion string `protobuf:"bytes,4,opt,name=config_version,json=configVersion,proto3" json:"config_version,omitempty"`
	// Number of radio packets received.
	RxPacketsReceived uint32 `protobuf:"varint,5,opt,name=rx_packets_received,json=rxPacketsReceived,proto3" json:"rx_packets_received,omitempty"`
	// Number of radio packets received with valid PHY CRC.
	RxPacketsReceivedOk uint32 `protobuf:"varint,6,opt,name=rx_packets_received_ok,json=rxPacketsReceivedOK,proto3" json:"rx_packets_received_ok,omitempty"`
	// Number of downlink packets received for transmission.
	TxPacketsReceived uint32 `protobuf:"varint,7,opt,name=tx_packets_received,json=txPacketsReceived,proto3" json:"tx_packets_received,omitempty"`
	// Number of downlink packets emitted.
	TxPacketsEmitted uint32 `protobuf:"varint,8,opt,name=tx_packets_emitted,json=txPacketsEmitted,proto3" json:"tx_packets_emitted,omitempty"`
	// Additional gateway meta-data.
	MetaData map[string]string `protobuf:"bytes,10,rep,name=meta_data,json=metaData,proto3" json:"meta_data,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Stats ID (UUID).
	// Unique identifier for the gateway stats.
	StatsId              []byte   `protobuf:"bytes,11,opt,name=stats_id,json=statsID,proto3" json:"stats_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GatewayStats) Reset()         { *m = GatewayStats{} }
func (m *GatewayStats) String() string { return proto.CompactTextString(m) }
func (*GatewayStats) ProtoMessage()    {}
func (*GatewayStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{5}
}

func (m *GatewayStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayStats.Unmarshal(m, b)
}
func (m *GatewayStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayStats.Marshal(b, m, deterministic)
}
func (m *GatewayStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayStats.Merge(m, src)
}
func (m *GatewayStats) XXX_Size() int {
	return xxx_messageInfo_GatewayStats.Size(m)
}
func (m *GatewayStats) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayStats.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayStats proto.InternalMessageInfo

func (m *GatewayStats) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *GatewayStats) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *GatewayStats) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *GatewayStats) GetLocation() *common.Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *GatewayStats) GetConfigVersion() string {
	if m != nil {
		return m.ConfigVersion
	}
	return ""
}

func (m *GatewayStats) GetRxPacketsReceived() uint32 {
	if m != nil {
		return m.RxPacketsReceived
	}
	return 0
}

func (m *GatewayStats) GetRxPacketsReceivedOk() uint32 {
	if m != nil {
		return m.RxPacketsReceivedOk
	}
	return 0
}

func (m *GatewayStats) GetTxPacketsReceived() uint32 {
	if m != nil {
		return m.TxPacketsReceived
	}
	return 0
}

func (m *GatewayStats) GetTxPacketsEmitted() uint32 {
	if m != nil {
		return m.TxPacketsEmitted
	}
	return 0
}

func (m *GatewayStats) GetMetaData() map[string]string {
	if m != nil {
		return m.MetaData
	}
	return nil
}

func (m *GatewayStats) GetStatsId() []byte {
	if m != nil {
		return m.StatsId
	}
	return nil
}

type UplinkRXInfo struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// RX time (only set when the gateway has a GPS module).
	Time *timestamp.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// RX time since GPS epoch (only set when the gateway has a GPS module).
	TimeSinceGpsEpoch *duration.Duration `protobuf:"bytes,3,opt,name=time_since_gps_epoch,json=timeSinceGPSEpoch,proto3" json:"time_since_gps_epoch,omitempty"`
	// RSSI.
	Rssi int32 `protobuf:"varint,5,opt,name=rssi,proto3" json:"rssi,omitempty"`
	// LoRa SNR.
	LoraSnr float64 `protobuf:"fixed64,6,opt,name=lora_snr,json=loRaSNR,proto3" json:"lora_snr,omitempty"`
	// Channel.
	Channel uint32 `protobuf:"varint,7,opt,name=channel,proto3" json:"channel,omitempty"`
	// RF Chain.
	RfChain uint32 `protobuf:"varint,8,opt,name=rf_chain,json=rfChain,proto3" json:"rf_chain,omitempty"`
	// Board.
	Board uint32 `protobuf:"varint,9,opt,name=board,proto3" json:"board,omitempty"`
	// Antenna.
	Antenna uint32 `protobuf:"varint,10,opt,name=antenna,proto3" json:"antenna,omitempty"`
	// Location.
	Location *common.Location `protobuf:"bytes,11,opt,name=location,proto3" json:"location,omitempty"`
	// Fine-timestamp type.
	FineTimestampType FineTimestampType `protobuf:"varint,12,opt,name=fine_timestamp_type,json=fineTimestampType,proto3,enum=gw.FineTimestampType" json:"fine_timestamp_type,omitempty"`
	// Fine-timestamp data.
	//
	// Types that are valid to be assigned to FineTimestamp:
	//	*UplinkRXInfo_EncryptedFineTimestamp
	//	*UplinkRXInfo_PlainFineTimestamp
	FineTimestamp isUplinkRXInfo_FineTimestamp `protobuf_oneof:"fine_timestamp"`
	// Gateway specific context.
	Context []byte `protobuf:"bytes,15,opt,name=context,proto3" json:"context,omitempty"`
	// Uplink ID (UUID bytes).
	// Unique and random ID which can be used to correlate the uplink across multiple logs.
	UplinkId []byte `protobuf:"bytes,16,opt,name=uplink_id,json=uplinkID,proto3" json:"uplink_id,omitempty"`
	// CRC status.
	CrcStatus            CRCStatus `protobuf:"varint,17,opt,name=crc_status,json=crcStatus,proto3,enum=gw.CRCStatus" json:"crc_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UplinkRXInfo) Reset()         { *m = UplinkRXInfo{} }
func (m *UplinkRXInfo) String() string { return proto.CompactTextString(m) }
func (*UplinkRXInfo) ProtoMessage()    {}
func (*UplinkRXInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{6}
}

func (m *UplinkRXInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UplinkRXInfo.Unmarshal(m, b)
}
func (m *UplinkRXInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UplinkRXInfo.Marshal(b, m, deterministic)
}
func (m *UplinkRXInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UplinkRXInfo.Merge(m, src)
}
func (m *UplinkRXInfo) XXX_Size() int {
	return xxx_messageInfo_UplinkRXInfo.Size(m)
}
func (m *UplinkRXInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_UplinkRXInfo.DiscardUnknown(m)
}

var xxx_messageInfo_UplinkRXInfo proto.InternalMessageInfo

func (m *UplinkRXInfo) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *UplinkRXInfo) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *UplinkRXInfo) GetTimeSinceGpsEpoch() *duration.Duration {
	if m != nil {
		return m.TimeSinceGpsEpoch
	}
	return nil
}

func (m *UplinkRXInfo) GetRssi() int32 {
	if m != nil {
		return m.Rssi
	}
	return 0
}

func (m *UplinkRXInfo) GetLoraSnr() float64 {
	if m != nil {
		return m.LoraSnr
	}
	return 0
}

func (m *UplinkRXInfo) GetChannel() uint32 {
	if m != nil {
		return m.Channel
	}
	return 0
}

func (m *UplinkRXInfo) GetRfChain() uint32 {
	if m != nil {
		return m.RfChain
	}
	return 0
}

func (m *UplinkRXInfo) GetBoard() uint32 {
	if m != nil {
		return m.Board
	}
	return 0
}

func (m *UplinkRXInfo) GetAntenna() uint32 {
	if m != nil {
		return m.Antenna
	}
	return 0
}

func (m *UplinkRXInfo) GetLocation() *common.Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *UplinkRXInfo) GetFineTimestampType() FineTimestampType {
	if m != nil {
		return m.FineTimestampType
	}
	return FineTimestampType_NONE
}

type isUplinkRXInfo_FineTimestamp interface {
	isUplinkRXInfo_FineTimestamp()
}

type UplinkRXInfo_EncryptedFineTimestamp struct {
	EncryptedFineTimestamp *EncryptedFineTimestamp `protobuf:"bytes,13,opt,name=encrypted_fine_timestamp,json=encryptedFineTimestamp,proto3,oneof"`
}

type UplinkRXInfo_PlainFineTimestamp struct {
	PlainFineTimestamp *PlainFineTimestamp `protobuf:"bytes,14,opt,name=plain_fine_timestamp,json=plainFineTimestamp,proto3,oneof"`
}

func (*UplinkRXInfo_EncryptedFineTimestamp) isUplinkRXInfo_FineTimestamp() {}

func (*UplinkRXInfo_PlainFineTimestamp) isUplinkRXInfo_FineTimestamp() {}

func (m *UplinkRXInfo) GetFineTimestamp() isUplinkRXInfo_FineTimestamp {
	if m != nil {
		return m.FineTimestamp
	}
	return nil
}

func (m *UplinkRXInfo) GetEncryptedFineTimestamp() *EncryptedFineTimestamp {
	if x, ok := m.GetFineTimestamp().(*UplinkRXInfo_EncryptedFineTimestamp); ok {
		return x.EncryptedFineTimestamp
	}
	return nil
}

func (m *UplinkRXInfo) GetPlainFineTimestamp() *PlainFineTimestamp {
	if x, ok := m.GetFineTimestamp().(*UplinkRXInfo_PlainFineTimestamp); ok {
		return x.PlainFineTimestamp
	}
	return nil
}

func (m *UplinkRXInfo) GetContext() []byte {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *UplinkRXInfo) GetUplinkId() []byte {
	if m != nil {
		return m.UplinkId
	}
	return nil
}

func (m *UplinkRXInfo) GetCrcStatus() CRCStatus {
	if m != nil {
		return m.CrcStatus
	}
	return CRCStatus_NO_CRC
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*UplinkRXInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*UplinkRXInfo_EncryptedFineTimestamp)(nil),
		(*UplinkRXInfo_PlainFineTimestamp)(nil),
	}
}

type DownlinkTXInfo struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// TX frequency (in Hz).
	Frequency uint32 `protobuf:"varint,5,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// TX power (in dBm).
	Power int32 `protobuf:"varint,6,opt,name=power,proto3" json:"power,omitempty"`
	// Modulation.
	Modulation common.Modulation `protobuf:"varint,7,opt,name=modulation,proto3,enum=common.Modulation" json:"modulation,omitempty"`
	// Types that are valid to be assigned to ModulationInfo:
	//	*DownlinkTXInfo_LoraModulationInfo
	//	*DownlinkTXInfo_FskModulationInfo
	ModulationInfo isDownlinkTXInfo_ModulationInfo `protobuf_oneof:"modulation_info"`
	// The board identifier for emitting the frame.
	Board uint32 `protobuf:"varint,10,opt,name=board,proto3" json:"board,omitempty"`
	// The antenna identifier for emitting the frame.
	Antenna uint32 `protobuf:"varint,11,opt,name=antenna,proto3" json:"antenna,omitempty"`
	// Timing defines the downlink timing to use.
	Timing DownlinkTiming `protobuf:"varint,12,opt,name=timing,proto3,enum=gw.DownlinkTiming" json:"timing,omitempty"`
	// Types that are valid to be assigned to TimingInfo:
	//	*DownlinkTXInfo_ImmediatelyTimingInfo
	//	*DownlinkTXInfo_DelayTimingInfo
	//	*DownlinkTXInfo_GpsEpochTimingInfo
	TimingInfo isDownlinkTXInfo_TimingInfo `protobuf_oneof:"timing_info"`
	// Gateway specific context.
	// In case of a Class-A downlink, this contains a copy of the uplink context.
	Context              []byte   `protobuf:"bytes,16,opt,name=context,proto3" json:"context,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DownlinkTXInfo) Reset()         { *m = DownlinkTXInfo{} }
func (m *DownlinkTXInfo) String() string { return proto.CompactTextString(m) }
func (*DownlinkTXInfo) ProtoMessage()    {}
func (*DownlinkTXInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{7}
}

func (m *DownlinkTXInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DownlinkTXInfo.Unmarshal(m, b)
}
func (m *DownlinkTXInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DownlinkTXInfo.Marshal(b, m, deterministic)
}
func (m *DownlinkTXInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DownlinkTXInfo.Merge(m, src)
}
func (m *DownlinkTXInfo) XXX_Size() int {
	return xxx_messageInfo_DownlinkTXInfo.Size(m)
}
func (m *DownlinkTXInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DownlinkTXInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DownlinkTXInfo proto.InternalMessageInfo

func (m *DownlinkTXInfo) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *DownlinkTXInfo) GetFrequency() uint32 {
	if m != nil {
		return m.Frequency
	}
	return 0
}

func (m *DownlinkTXInfo) GetPower() int32 {
	if m != nil {
		return m.Power
	}
	return 0
}

func (m *DownlinkTXInfo) GetModulation() common.Modulation {
	if m != nil {
		return m.Modulation
	}
	return common.Modulation_LORA
}

type isDownlinkTXInfo_ModulationInfo interface {
	isDownlinkTXInfo_ModulationInfo()
}

type DownlinkTXInfo_LoraModulationInfo struct {
	LoraModulationInfo *LoRaModulationInfo `protobuf:"bytes,8,opt,name=lora_modulation_info,json=loRaModulationInfo,proto3,oneof"`
}

type DownlinkTXInfo_FskModulationInfo struct {
	FskModulationInfo *FSKModulationInfo `protobuf:"bytes,9,opt,name=fsk_modulation_info,json=fskModulationInfo,proto3,oneof"`
}

func (*DownlinkTXInfo_LoraModulationInfo) isDownlinkTXInfo_ModulationInfo() {}

func (*DownlinkTXInfo_FskModulationInfo) isDownlinkTXInfo_ModulationInfo() {}

func (m *DownlinkTXInfo) GetModulationInfo() isDownlinkTXInfo_ModulationInfo {
	if m != nil {
		return m.ModulationInfo
	}
	return nil
}

func (m *DownlinkTXInfo) GetLoraModulationInfo() *LoRaModulationInfo {
	if x, ok := m.GetModulationInfo().(*DownlinkTXInfo_LoraModulationInfo); ok {
		return x.LoraModulationInfo
	}
	return nil
}

func (m *DownlinkTXInfo) GetFskModulationInfo() *FSKModulationInfo {
	if x, ok := m.GetModulationInfo().(*DownlinkTXInfo_FskModulationInfo); ok {
		return x.FskModulationInfo
	}
	return nil
}

func (m *DownlinkTXInfo) GetBoard() uint32 {
	if m != nil {
		return m.Board
	}
	return 0
}

func (m *DownlinkTXInfo) GetAntenna() uint32 {
	if m != nil {
		return m.Antenna
	}
	return 0
}

func (m *DownlinkTXInfo) GetTiming() DownlinkTiming {
	if m != nil {
		return m.Timing
	}
	return DownlinkTiming_IMMEDIATELY
}

type isDownlinkTXInfo_TimingInfo interface {
	isDownlinkTXInfo_TimingInfo()
}

type DownlinkTXInfo_ImmediatelyTimingInfo struct {
	ImmediatelyTimingInfo *ImmediatelyTimingInfo `protobuf:"bytes,13,opt,name=immediately_timing_info,json=immediatelyTimingInfo,proto3,oneof"`
}

type DownlinkTXInfo_DelayTimingInfo struct {
	DelayTimingInfo *DelayTimingInfo `protobuf:"bytes,14,opt,name=delay_timing_info,json=delayTimingInfo,proto3,oneof"`
}

type DownlinkTXInfo_GpsEpochTimingInfo struct {
	GpsEpochTimingInfo *GPSEpochTimingInfo `protobuf:"bytes,15,opt,name=gps_epoch_timing_info,json=gpsEpochTimingInfo,proto3,oneof"`
}

func (*DownlinkTXInfo_ImmediatelyTimingInfo) isDownlinkTXInfo_TimingInfo() {}

func (*DownlinkTXInfo_DelayTimingInfo) isDownlinkTXInfo_TimingInfo() {}

func (*DownlinkTXInfo_GpsEpochTimingInfo) isDownlinkTXInfo_TimingInfo() {}

func (m *DownlinkTXInfo) GetTimingInfo() isDownlinkTXInfo_TimingInfo {
	if m != nil {
		return m.TimingInfo
	}
	return nil
}

func (m *DownlinkTXInfo) GetImmediatelyTimingInfo() *ImmediatelyTimingInfo {
	if x, ok := m.GetTimingInfo().(*DownlinkTXInfo_ImmediatelyTimingInfo); ok {
		return x.ImmediatelyTimingInfo
	}
	return nil
}

func (m *DownlinkTXInfo) GetDelayTimingInfo() *DelayTimingInfo {
	if x, ok := m.GetTimingInfo().(*DownlinkTXInfo_DelayTimingInfo); ok {
		return x.DelayTimingInfo
	}
	return nil
}

func (m *DownlinkTXInfo) GetGpsEpochTimingInfo() *GPSEpochTimingInfo {
	if x, ok := m.GetTimingInfo().(*DownlinkTXInfo_GpsEpochTimingInfo); ok {
		return x.GpsEpochTimingInfo
	}
	return nil
}

func (m *DownlinkTXInfo) GetContext() []byte {
	if m != nil {
		return m.Context
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DownlinkTXInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DownlinkTXInfo_LoraModulationInfo)(nil),
		(*DownlinkTXInfo_FskModulationInfo)(nil),
		(*DownlinkTXInfo_ImmediatelyTimingInfo)(nil),
		(*DownlinkTXInfo_DelayTimingInfo)(nil),
		(*DownlinkTXInfo_GpsEpochTimingInfo)(nil),
	}
}

type ImmediatelyTimingInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImmediatelyTimingInfo) Reset()         { *m = ImmediatelyTimingInfo{} }
func (m *ImmediatelyTimingInfo) String() string { return proto.CompactTextString(m) }
func (*ImmediatelyTimingInfo) ProtoMessage()    {}
func (*ImmediatelyTimingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{8}
}

func (m *ImmediatelyTimingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImmediatelyTimingInfo.Unmarshal(m, b)
}
func (m *ImmediatelyTimingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImmediatelyTimingInfo.Marshal(b, m, deterministic)
}
func (m *ImmediatelyTimingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImmediatelyTimingInfo.Merge(m, src)
}
func (m *ImmediatelyTimingInfo) XXX_Size() int {
	return xxx_messageInfo_ImmediatelyTimingInfo.Size(m)
}
func (m *ImmediatelyTimingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ImmediatelyTimingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ImmediatelyTimingInfo proto.InternalMessageInfo

type DelayTimingInfo struct {
	// Delay (duration).
	// The delay will be added to the gateway internal timing, provided by the context object.
	Delay                *duration.Duration `protobuf:"bytes,1,opt,name=delay,proto3" json:"delay,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DelayTimingInfo) Reset()         { *m = DelayTimingInfo{} }
func (m *DelayTimingInfo) String() string { return proto.CompactTextString(m) }
func (*DelayTimingInfo) ProtoMessage()    {}
func (*DelayTimingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{9}
}

func (m *DelayTimingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DelayTimingInfo.Unmarshal(m, b)
}
func (m *DelayTimingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DelayTimingInfo.Marshal(b, m, deterministic)
}
func (m *DelayTimingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DelayTimingInfo.Merge(m, src)
}
func (m *DelayTimingInfo) XXX_Size() int {
	return xxx_messageInfo_DelayTimingInfo.Size(m)
}
func (m *DelayTimingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DelayTimingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DelayTimingInfo proto.InternalMessageInfo

func (m *DelayTimingInfo) GetDelay() *duration.Duration {
	if m != nil {
		return m.Delay
	}
	return nil
}

type GPSEpochTimingInfo struct {
	// Duration since GPS Epoch.
	TimeSinceGpsEpoch    *duration.Duration `protobuf:"bytes,1,opt,name=time_since_gps_epoch,json=timeSinceGPSEpoch,proto3" json:"time_since_gps_epoch,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *GPSEpochTimingInfo) Reset()         { *m = GPSEpochTimingInfo{} }
func (m *GPSEpochTimingInfo) String() string { return proto.CompactTextString(m) }
func (*GPSEpochTimingInfo) ProtoMessage()    {}
func (*GPSEpochTimingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{10}
}

func (m *GPSEpochTimingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GPSEpochTimingInfo.Unmarshal(m, b)
}
func (m *GPSEpochTimingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GPSEpochTimingInfo.Marshal(b, m, deterministic)
}
func (m *GPSEpochTimingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GPSEpochTimingInfo.Merge(m, src)
}
func (m *GPSEpochTimingInfo) XXX_Size() int {
	return xxx_messageInfo_GPSEpochTimingInfo.Size(m)
}
func (m *GPSEpochTimingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GPSEpochTimingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GPSEpochTimingInfo proto.InternalMessageInfo

func (m *GPSEpochTimingInfo) GetTimeSinceGpsEpoch() *duration.Duration {
	if m != nil {
		return m.TimeSinceGpsEpoch
	}
	return nil
}

type UplinkFrame struct {
	// PHYPayload.
	PhyPayload []byte `protobuf:"bytes,1,opt,name=phy_payload,json=phyPayload,proto3" json:"phy_payload,omitempty"`
	// TX meta-data.
	TxInfo *UplinkTXInfo `protobuf:"bytes,2,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
	// RX meta-data.
	RxInfo               *UplinkRXInfo `protobuf:"bytes,3,opt,name=rx_info,json=rxInfo,proto3" json:"rx_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UplinkFrame) Reset()         { *m = UplinkFrame{} }
func (m *UplinkFrame) String() string { return proto.CompactTextString(m) }
func (*UplinkFrame) ProtoMessage()    {}
func (*UplinkFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{11}
}

func (m *UplinkFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UplinkFrame.Unmarshal(m, b)
}
func (m *UplinkFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UplinkFrame.Marshal(b, m, deterministic)
}
func (m *UplinkFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UplinkFrame.Merge(m, src)
}
func (m *UplinkFrame) XXX_Size() int {
	return xxx_messageInfo_UplinkFrame.Size(m)
}
func (m *UplinkFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_UplinkFrame.DiscardUnknown(m)
}

var xxx_messageInfo_UplinkFrame proto.InternalMessageInfo

func (m *UplinkFrame) GetPhyPayload() []byte {
	if m != nil {
		return m.PhyPayload
	}
	return nil
}

func (m *UplinkFrame) GetTxInfo() *UplinkTXInfo {
	if m != nil {
		return m.TxInfo
	}
	return nil
}

func (m *UplinkFrame) GetRxInfo() *UplinkRXInfo {
	if m != nil {
		return m.RxInfo
	}
	return nil
}

type UplinkFrameSet struct {
	// PHYPayload.
	PhyPayload []byte `protobuf:"bytes,1,opt,name=phy_payload,json=phyPayload,proto3" json:"phy_payload,omitempty"`
	// TX meta-data.
	TxInfo *UplinkTXInfo `protobuf:"bytes,2,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
	// RX meta-data set.
	RxInfo               []*UplinkRXInfo `protobuf:"bytes,3,rep,name=rx_info,json=rxInfo,proto3" json:"rx_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *UplinkFrameSet) Reset()         { *m = UplinkFrameSet{} }
func (m *UplinkFrameSet) String() string { return proto.CompactTextString(m) }
func (*UplinkFrameSet) ProtoMessage()    {}
func (*UplinkFrameSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{12}
}

func (m *UplinkFrameSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UplinkFrameSet.Unmarshal(m, b)
}
func (m *UplinkFrameSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UplinkFrameSet.Marshal(b, m, deterministic)
}
func (m *UplinkFrameSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UplinkFrameSet.Merge(m, src)
}
func (m *UplinkFrameSet) XXX_Size() int {
	return xxx_messageInfo_UplinkFrameSet.Size(m)
}
func (m *UplinkFrameSet) XXX_DiscardUnknown() {
	xxx_messageInfo_UplinkFrameSet.DiscardUnknown(m)
}

var xxx_messageInfo_UplinkFrameSet proto.InternalMessageInfo

func (m *UplinkFrameSet) GetPhyPayload() []byte {
	if m != nil {
		return m.PhyPayload
	}
	return nil
}

func (m *UplinkFrameSet) GetTxInfo() *UplinkTXInfo {
	if m != nil {
		return m.TxInfo
	}
	return nil
}

func (m *UplinkFrameSet) GetRxInfo() []*UplinkRXInfo {
	if m != nil {
		return m.RxInfo
	}
	return nil
}

type DownlinkFrame struct {
	// PHYPayload.
	PhyPayload []byte `protobuf:"bytes,1,opt,name=phy_payload,json=phyPayload,proto3" json:"phy_payload,omitempty"`
	// TX meta-data.
	TxInfo *DownlinkTXInfo `protobuf:"bytes,2,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
	// Token (uint16 value).
	// Deprecated: will be replaced by downlink_id.
	Token uint32 `protobuf:"varint,3,opt,name=token,proto3" json:"token,omitempty"`
	// Downlink ID (UUID).
	DownlinkId           []byte   `protobuf:"bytes,4,opt,name=downlink_id,json=downlinkID,proto3" json:"downlink_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DownlinkFrame) Reset()         { *m = DownlinkFrame{} }
func (m *DownlinkFrame) String() string { return proto.CompactTextString(m) }
func (*DownlinkFrame) ProtoMessage()    {}
func (*DownlinkFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{13}
}

func (m *DownlinkFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DownlinkFrame.Unmarshal(m, b)
}
func (m *DownlinkFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DownlinkFrame.Marshal(b, m, deterministic)
}
func (m *DownlinkFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DownlinkFrame.Merge(m, src)
}
func (m *DownlinkFrame) XXX_Size() int {
	return xxx_messageInfo_DownlinkFrame.Size(m)
}
func (m *DownlinkFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_DownlinkFrame.DiscardUnknown(m)
}

var xxx_messageInfo_DownlinkFrame proto.InternalMessageInfo

func (m *DownlinkFrame) GetPhyPayload() []byte {
	if m != nil {
		return m.PhyPayload
	}
	return nil
}

func (m *DownlinkFrame) GetTxInfo() *DownlinkTXInfo {
	if m != nil {
		return m.TxInfo
	}
	return nil
}

func (m *DownlinkFrame) GetToken() uint32 {
	if m != nil {
		return m.Token
	}
	return 0
}

func (m *DownlinkFrame) GetDownlinkId() []byte {
	if m != nil {
		return m.DownlinkId
	}
	return nil
}

type DownlinkTXAck struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// Token (uint16 value).
	Token uint32 `protobuf:"varint,2,opt,name=token,proto3" json:"token,omitempty"`
	// Error.
	Error string `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	// Downlink ID (UUID).
	DownlinkId           []byte   `protobuf:"bytes,4,opt,name=downlink_id,json=downlinkID,proto3" json:"downlink_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DownlinkTXAck) Reset()         { *m = DownlinkTXAck{} }
func (m *DownlinkTXAck) String() string { return proto.CompactTextString(m) }
func (*DownlinkTXAck) ProtoMessage()    {}
func (*DownlinkTXAck) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{14}
}

func (m *DownlinkTXAck) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DownlinkTXAck.Unmarshal(m, b)
}
func (m *DownlinkTXAck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DownlinkTXAck.Marshal(b, m, deterministic)
}
func (m *DownlinkTXAck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DownlinkTXAck.Merge(m, src)
}
func (m *DownlinkTXAck) XXX_Size() int {
	return xxx_messageInfo_DownlinkTXAck.Size(m)
}
func (m *DownlinkTXAck) XXX_DiscardUnknown() {
	xxx_messageInfo_DownlinkTXAck.DiscardUnknown(m)
}

var xxx_messageInfo_DownlinkTXAck proto.InternalMessageInfo

func (m *DownlinkTXAck) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *DownlinkTXAck) GetToken() uint32 {
	if m != nil {
		return m.Token
	}
	return 0
}

func (m *DownlinkTXAck) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *DownlinkTXAck) GetDownlinkId() []byte {
	if m != nil {
		return m.DownlinkId
	}
	return nil
}

type GatewayConfiguration struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// Configuration version.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Channels.
	Channels             []*ChannelConfiguration `protobuf:"bytes,3,rep,name=channels,proto3" json:"channels,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *GatewayConfiguration) Reset()         { *m = GatewayConfiguration{} }
func (m *GatewayConfiguration) String() string { return proto.CompactTextString(m) }
func (*GatewayConfiguration) ProtoMessage()    {}
func (*GatewayConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{15}
}

func (m *GatewayConfiguration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayConfiguration.Unmarshal(m, b)
}
func (m *GatewayConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayConfiguration.Marshal(b, m, deterministic)
}
func (m *GatewayConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayConfiguration.Merge(m, src)
}
func (m *GatewayConfiguration) XXX_Size() int {
	return xxx_messageInfo_GatewayConfiguration.Size(m)
}
func (m *GatewayConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayConfiguration proto.InternalMessageInfo

func (m *GatewayConfiguration) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *GatewayConfiguration) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *GatewayConfiguration) GetChannels() []*ChannelConfiguration {
	if m != nil {
		return m.Channels
	}
	return nil
}

type ChannelConfiguration struct {
	// Frequency (Hz).
	Frequency uint32 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Channel modulation.
	Modulation common.Modulation `protobuf:"varint,2,opt,name=modulation,proto3,enum=common.Modulation" json:"modulation,omitempty"`
	// Types that are valid to be assigned to ModulationConfig:
	//	*ChannelConfiguration_LoraModulationConfig
	//	*ChannelConfiguration_FskModulationConfig
	ModulationConfig isChannelConfiguration_ModulationConfig `protobuf_oneof:"modulation_config"`
	// Board index.
	Board uint32 `protobuf:"varint,5,opt,name=board,proto3" json:"board,omitempty"`
	// Demodulator index (of the given board).
	Demodulator          uint32   `protobuf:"varint,6,opt,name=demodulator,proto3" json:"demodulator,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChannelConfiguration) Reset()         { *m = ChannelConfiguration{} }
func (m *ChannelConfiguration) String() string { return proto.CompactTextString(m) }
func (*ChannelConfiguration) ProtoMessage()    {}
func (*ChannelConfiguration) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{16}
}

func (m *ChannelConfiguration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChannelConfiguration.Unmarshal(m, b)
}
func (m *ChannelConfiguration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChannelConfiguration.Marshal(b, m, deterministic)
}
func (m *ChannelConfiguration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChannelConfiguration.Merge(m, src)
}
func (m *ChannelConfiguration) XXX_Size() int {
	return xxx_messageInfo_ChannelConfiguration.Size(m)
}
func (m *ChannelConfiguration) XXX_DiscardUnknown() {
	xxx_messageInfo_ChannelConfiguration.DiscardUnknown(m)
}

var xxx_messageInfo_ChannelConfiguration proto.InternalMessageInfo

func (m *ChannelConfiguration) GetFrequency() uint32 {
	if m != nil {
		return m.Frequency
	}
	return 0
}

func (m *ChannelConfiguration) GetModulation() common.Modulation {
	if m != nil {
		return m.Modulation
	}
	return common.Modulation_LORA
}

type isChannelConfiguration_ModulationConfig interface {
	isChannelConfiguration_ModulationConfig()
}

type ChannelConfiguration_LoraModulationConfig struct {
	LoraModulationConfig *LoRaModulationConfig `protobuf:"bytes,3,opt,name=lora_modulation_config,json=loRaModulationConfig,proto3,oneof"`
}

type ChannelConfiguration_FskModulationConfig struct {
	FskModulationConfig *FSKModulationConfig `protobuf:"bytes,4,opt,name=fsk_modulation_config,json=fskModulationConfig,proto3,oneof"`
}

func (*ChannelConfiguration_LoraModulationConfig) isChannelConfiguration_ModulationConfig() {}

func (*ChannelConfiguration_FskModulationConfig) isChannelConfiguration_ModulationConfig() {}

func (m *ChannelConfiguration) GetModulationConfig() isChannelConfiguration_ModulationConfig {
	if m != nil {
		return m.ModulationConfig
	}
	return nil
}

func (m *ChannelConfiguration) GetLoraModulationConfig() *LoRaModulationConfig {
	if x, ok := m.GetModulationConfig().(*ChannelConfiguration_LoraModulationConfig); ok {
		return x.LoraModulationConfig
	}
	return nil
}

func (m *ChannelConfiguration) GetFskModulationConfig() *FSKModulationConfig {
	if x, ok := m.GetModulationConfig().(*ChannelConfiguration_FskModulationConfig); ok {
		return x.FskModulationConfig
	}
	return nil
}

func (m *ChannelConfiguration) GetBoard() uint32 {
	if m != nil {
		return m.Board
	}
	return 0
}

func (m *ChannelConfiguration) GetDemodulator() uint32 {
	if m != nil {
		return m.Demodulator
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ChannelConfiguration) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ChannelConfiguration_LoraModulationConfig)(nil),
		(*ChannelConfiguration_FskModulationConfig)(nil),
	}
}

type LoRaModulationConfig struct {
	// Bandwidth.
	Bandwidth uint32 `protobuf:"varint,1,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	// Spreading-factors.
	SpreadingFactors     []uint32 `protobuf:"varint,2,rep,packed,name=spreading_factors,json=spreadingFactors,proto3" json:"spreading_factors,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoRaModulationConfig) Reset()         { *m = LoRaModulationConfig{} }
func (m *LoRaModulationConfig) String() string { return proto.CompactTextString(m) }
func (*LoRaModulationConfig) ProtoMessage()    {}
func (*LoRaModulationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{17}
}

func (m *LoRaModulationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoRaModulationConfig.Unmarshal(m, b)
}
func (m *LoRaModulationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoRaModulationConfig.Marshal(b, m, deterministic)
}
func (m *LoRaModulationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoRaModulationConfig.Merge(m, src)
}
func (m *LoRaModulationConfig) XXX_Size() int {
	return xxx_messageInfo_LoRaModulationConfig.Size(m)
}
func (m *LoRaModulationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LoRaModulationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LoRaModulationConfig proto.InternalMessageInfo

func (m *LoRaModulationConfig) GetBandwidth() uint32 {
	if m != nil {
		return m.Bandwidth
	}
	return 0
}

func (m *LoRaModulationConfig) GetSpreadingFactors() []uint32 {
	if m != nil {
		return m.SpreadingFactors
	}
	return nil
}

type FSKModulationConfig struct {
	// Bandwidth.
	Bandwidth uint32 `protobuf:"varint,1,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	// Bitrate.
	Bitrate              uint32   `protobuf:"varint,2,opt,name=bitrate,proto3" json:"bitrate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FSKModulationConfig) Reset()         { *m = FSKModulationConfig{} }
func (m *FSKModulationConfig) String() string { return proto.CompactTextString(m) }
func (*FSKModulationConfig) ProtoMessage()    {}
func (*FSKModulationConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{18}
}

func (m *FSKModulationConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FSKModulationConfig.Unmarshal(m, b)
}
func (m *FSKModulationConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FSKModulationConfig.Marshal(b, m, deterministic)
}
func (m *FSKModulationConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FSKModulationConfig.Merge(m, src)
}
func (m *FSKModulationConfig) XXX_Size() int {
	return xxx_messageInfo_FSKModulationConfig.Size(m)
}
func (m *FSKModulationConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FSKModulationConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FSKModulationConfig proto.InternalMessageInfo

func (m *FSKModulationConfig) GetBandwidth() uint32 {
	if m != nil {
		return m.Bandwidth
	}
	return 0
}

func (m *FSKModulationConfig) GetBitrate() uint32 {
	if m != nil {
		return m.Bitrate
	}
	return 0
}

type GatewayCommandExecRequest struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// Command to execute.
	// This command must be pre-configured in the LoRa Gateway Bridge configuration.
	Command string `protobuf:"bytes,2,opt,name=command,proto3" json:"command,omitempty"`
	// Execution request ID (UUID).
	// The same token will be returned when the execution of the command has
	// completed.
	ExecId []byte `protobuf:"bytes,3,opt,name=ExecId,json=execID,proto3" json:"ExecId,omitempty"`
	// Standard input.
	Stdin []byte `protobuf:"bytes,4,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Environment variables.
	Environment          map[string]string `protobuf:"bytes,5,rep,name=environment,proto3" json:"environment,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GatewayCommandExecRequest) Reset()         { *m = GatewayCommandExecRequest{} }
func (m *GatewayCommandExecRequest) String() string { return proto.CompactTextString(m) }
func (*GatewayCommandExecRequest) ProtoMessage()    {}
func (*GatewayCommandExecRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{19}
}

func (m *GatewayCommandExecRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayCommandExecRequest.Unmarshal(m, b)
}
func (m *GatewayCommandExecRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayCommandExecRequest.Marshal(b, m, deterministic)
}
func (m *GatewayCommandExecRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayCommandExecRequest.Merge(m, src)
}
func (m *GatewayCommandExecRequest) XXX_Size() int {
	return xxx_messageInfo_GatewayCommandExecRequest.Size(m)
}
func (m *GatewayCommandExecRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayCommandExecRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayCommandExecRequest proto.InternalMessageInfo

func (m *GatewayCommandExecRequest) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *GatewayCommandExecRequest) GetCommand() string {
	if m != nil {
		return m.Command
	}
	return ""
}

func (m *GatewayCommandExecRequest) GetExecId() []byte {
	if m != nil {
		return m.ExecId
	}
	return nil
}

func (m *GatewayCommandExecRequest) GetStdin() []byte {
	if m != nil {
		return m.Stdin
	}
	return nil
}

func (m *GatewayCommandExecRequest) GetEnvironment() map[string]string {
	if m != nil {
		return m.Environment
	}
	return nil
}

type GatewayCommandExecResponse struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// Execution request ID (UUID).
	ExecId []byte `protobuf:"bytes,2,opt,name=exec_id,json=execID,proto3" json:"exec_id,omitempty"`
	// Standard output.
	Stdout []byte `protobuf:"bytes,3,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Standard error.
	Stderr []byte `protobuf:"bytes,4,opt,name=stderr,proto3" json:"stderr,omitempty"`
	// Error message.
	Error                string   `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GatewayCommandExecResponse) Reset()         { *m = GatewayCommandExecResponse{} }
func (m *GatewayCommandExecResponse) String() string { return proto.CompactTextString(m) }
func (*GatewayCommandExecResponse) ProtoMessage()    {}
func (*GatewayCommandExecResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{20}
}

func (m *GatewayCommandExecResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayCommandExecResponse.Unmarshal(m, b)
}
func (m *GatewayCommandExecResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayCommandExecResponse.Marshal(b, m, deterministic)
}
func (m *GatewayCommandExecResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayCommandExecResponse.Merge(m, src)
}
func (m *GatewayCommandExecResponse) XXX_Size() int {
	return xxx_messageInfo_GatewayCommandExecResponse.Size(m)
}
func (m *GatewayCommandExecResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayCommandExecResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayCommandExecResponse proto.InternalMessageInfo

func (m *GatewayCommandExecResponse) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *GatewayCommandExecResponse) GetExecId() []byte {
	if m != nil {
		return m.ExecId
	}
	return nil
}

func (m *GatewayCommandExecResponse) GetStdout() []byte {
	if m != nil {
		return m.Stdout
	}
	return nil
}

func (m *GatewayCommandExecResponse) GetStderr() []byte {
	if m != nil {
		return m.Stderr
	}
	return nil
}

func (m *GatewayCommandExecResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// RawPacketForwarderEvent contains a raw packet-forwarder event.
// It can be used to access packet-forwarder features that are not (fully)
// integrated with the ChirpStack Gateway Bridge.
type RawPacketForwarderEvent struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// Raw ID (UUID).
	RawId []byte `protobuf:"bytes,2,opt,name=raw_id,json=rawID,proto3" json:"raw_id,omitempty"`
	// Payload contains the raw payload.
	Payload              []byte   `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawPacketForwarderEvent) Reset()         { *m = RawPacketForwarderEvent{} }
func (m *RawPacketForwarderEvent) String() string { return proto.CompactTextString(m) }
func (*RawPacketForwarderEvent) ProtoMessage()    {}
func (*RawPacketForwarderEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{21}
}

func (m *RawPacketForwarderEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawPacketForwarderEvent.Unmarshal(m, b)
}
func (m *RawPacketForwarderEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawPacketForwarderEvent.Marshal(b, m, deterministic)
}
func (m *RawPacketForwarderEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawPacketForwarderEvent.Merge(m, src)
}
func (m *RawPacketForwarderEvent) XXX_Size() int {
	return xxx_messageInfo_RawPacketForwarderEvent.Size(m)
}
func (m *RawPacketForwarderEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_RawPacketForwarderEvent.DiscardUnknown(m)
}

var xxx_messageInfo_RawPacketForwarderEvent proto.InternalMessageInfo

func (m *RawPacketForwarderEvent) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *RawPacketForwarderEvent) GetRawId() []byte {
	if m != nil {
		return m.RawId
	}
	return nil
}

func (m *RawPacketForwarderEvent) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// RawPacketForwarderEvent contains a raw packet-forwarder command.
// It can be used to access packet-forwarder features that are not (fully)
// integrated with the ChirpStack Gateway Bridge.
type RawPacketForwarderCommand struct {
	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayID,proto3" json:"gateway_id,omitempty"`
	// Raw ID (UUID).
	RawId []byte `protobuf:"bytes,2,opt,name=raw_id,json=rawID,proto3" json:"raw_id,omitempty"`
	// Payload contains the raw payload.
	Payload              []byte   `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawPacketForwarderCommand) Reset()         { *m = RawPacketForwarderCommand{} }
func (m *RawPacketForwarderCommand) String() string { return proto.CompactTextString(m) }
func (*RawPacketForwarderCommand) ProtoMessage()    {}
func (*RawPacketForwarderCommand) Descriptor() ([]byte, []int) {
	return fileDescriptor_b93a753e2b32e8e7, []int{22}
}

func (m *RawPacketForwarderCommand) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawPacketForwarderCommand.Unmarshal(m, b)
}
func (m *RawPacketForwarderCommand) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawPacketForwarderCommand.Marshal(b, m, deterministic)
}
func (m *RawPacketForwarderCommand) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawPacketForwarderCommand.Merge(m, src)
}
func (m *RawPacketForwarderCommand) XXX_Size() int {
	return xxx_messageInfo_RawPacketForwarderCommand.Size(m)
}
func (m *RawPacketForwarderCommand) XXX_DiscardUnknown() {
	xxx_messageInfo_RawPacketForwarderCommand.DiscardUnknown(m)
}

var xxx_messageInfo_RawPacketForwarderCommand proto.InternalMessageInfo

func (m *RawPacketForwarderCommand) GetGatewayId() []byte {
	if m != nil {
		return m.GatewayId
	}
	return nil
}

func (m *RawPacketForwarderCommand) GetRawId() []byte {
	if m != nil {
		return m.RawId
	}
	return nil
}

func (m *RawPacketForwarderCommand) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func init() {
	proto.RegisterEnum("gw.DownlinkTiming", DownlinkTiming_name, DownlinkTiming_value)
	proto.RegisterEnum("gw.FineTimestampType", FineTimestampType_name, FineTimestampType_value)
	proto.RegisterEnum("gw.CRCStatus", CRCStatus_name, CRCStatus_value)
	proto.RegisterType((*UplinkTXInfo)(nil), "gw.UplinkTXInfo")
	proto.RegisterType((*LoRaModulationInfo)(nil), "gw.LoRaModulationInfo")
	proto.RegisterType((*FSKModulationInfo)(nil), "gw.FSKModulationInfo")
	proto.RegisterType((*EncryptedFineTimestamp)(nil), "gw.EncryptedFineTimestamp")
	proto.RegisterType((*PlainFineTimestamp)(nil), "gw.PlainFineTimestamp")
	proto.RegisterType((*GatewayStats)(nil), "gw.GatewayStats")
	proto.RegisterMapType((map[string]string)(nil), "gw.GatewayStats.MetaDataEntry")
	proto.RegisterType((*UplinkRXInfo)(nil), "gw.UplinkRXInfo")
	proto.RegisterType((*DownlinkTXInfo)(nil), "gw.DownlinkTXInfo")
	proto.RegisterType((*ImmediatelyTimingInfo)(nil), "gw.ImmediatelyTimingInfo")
	proto.RegisterType((*DelayTimingInfo)(nil), "gw.DelayTimingInfo")
	proto.RegisterType((*GPSEpochTimingInfo)(nil), "gw.GPSEpochTimingInfo")
	proto.RegisterType((*UplinkFrame)(nil), "gw.UplinkFrame")
	proto.RegisterType((*UplinkFrameSet)(nil), "gw.UplinkFrameSet")
	proto.RegisterType((*DownlinkFrame)(nil), "gw.DownlinkFrame")
	proto.RegisterType((*DownlinkTXAck)(nil), "gw.DownlinkTXAck")
	proto.RegisterType((*GatewayConfiguration)(nil), "gw.GatewayConfiguration")
	proto.RegisterType((*ChannelConfiguration)(nil), "gw.ChannelConfiguration")
	proto.RegisterType((*LoRaModulationConfig)(nil), "gw.LoRaModulationConfig")
	proto.RegisterType((*FSKModulationConfig)(nil), "gw.FSKModulationConfig")
	proto.RegisterType((*GatewayCommandExecRequest)(nil), "gw.GatewayCommandExecRequest")
	proto.RegisterMapType((map[string]string)(nil), "gw.GatewayCommandExecRequest.EnvironmentEntry")
	proto.RegisterType((*GatewayCommandExecResponse)(nil), "gw.GatewayCommandExecResponse")
	proto.RegisterType((*RawPacketForwarderEvent)(nil), "gw.RawPacketForwarderEvent")
	proto.RegisterType((*RawPacketForwarderCommand)(nil), "gw.RawPacketForwarderCommand")
}

func init() { proto.RegisterFile("gw/gw.proto", fileDescriptor_b93a753e2b32e8e7) }

var fileDescriptor_b93a753e2b32e8e7 = []byte{
	// 1819 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0x5f, 0x73, 0xe2, 0xc8,
	0x11, 0xb7, 0x58, 0x63, 0xa0, 0x31, 0x36, 0x0c, 0xd8, 0xd6, 0x3a, 0xc9, 0x9d, 0xa3, 0xaa, 0x54,
	0xed, 0xfa, 0x36, 0x90, 0xf2, 0x26, 0x95, 0x54, 0xb6, 0x2a, 0x55, 0x36, 0xe0, 0x5d, 0xd6, 0xff,
	0xa8, 0xc1, 0xb9, 0xba, 0xcd, 0x8b, 0x6e, 0x2c, 0x0d, 0x58, 0x05, 0x48, 0xca, 0x68, 0x30, 0x90,
	0xbc, 0x26, 0x95, 0x7c, 0x80, 0x7b, 0xba, 0x6f, 0x90, 0xc7, 0x7c, 0x90, 0xbc, 0xe6, 0xf3, 0xa4,
	0x66, 0x46, 0x12, 0x12, 0x70, 0xc7, 0x6e, 0xe5, 0xee, 0x09, 0xba, 0xa7, 0xa7, 0xbb, 0xa7, 0xfb,
	0xa7, 0xdf, 0xf4, 0x40, 0x71, 0x30, 0x6d, 0x0c, 0xa6, 0x75, 0x9f, 0x79, 0xdc, 0x43, 0x99, 0xc1,
	0xf4, 0xb8, 0x6a, 0x79, 0xe3, 0xb1, 0xe7, 0x36, 0xd4, 0x8f, 0x5a, 0x38, 0xfe, 0x7c, 0xe0, 0x79,
	0x83, 0x11, 0x6d, 0x48, 0xe9, 0x61, 0xd2, 0x6f, 0x70, 0x67, 0x4c, 0x03, 0x4e, 0xc6, 0x7e, 0x68,
	0xf0, 0xd9, 0xb2, 0x81, 0x3d, 0x61, 0x84, 0x3b, 0x91, 0x03, 0xe3, 0x9f, 0x19, 0xd8, 0xfd, 0xa3,
	0x3f, 0x72, 0xdc, 0xe1, 0xfd, 0x57, 0x1d, 0xb7, 0xef, 0xa1, 0x9f, 0x42, 0xa1, 0xcf, 0xe8, 0x9f,
	0x27, 0xd4, 0xb5, 0xe6, 0xba, 0x76, 0xa2, 0xbd, 0x28, 0xe1, 0x85, 0x02, 0x9d, 0x01, 0x8c, 0x3d,
	0x7b, 0x32, 0x92, 0x2e, 0xf4, 0xcc, 0x89, 0xf6, 0x62, 0xef, 0x0c, 0xd5, 0xc3, 0x94, 0x6e, 0xe2,
	0x15, 0x9c, 0xb0, 0x42, 0xef, 0xa1, 0x36, 0xf2, 0x18, 0x31, 0x17, 0x2a, 0xd3, 0x71, 0xfb, 0x9e,
	0xfe, 0xec, 0x44, 0x7b, 0x51, 0x3c, 0x3b, 0xac, 0x0f, 0xa6, 0xf5, 0x6b, 0x0f, 0x93, 0xc5, 0x6e,
	0x91, 0xc7, 0xbb, 0x2d, 0x8c, 0x46, 0x2b, 0x5a, 0xf4, 0x16, 0xaa, 0xfd, 0x60, 0xb8, 0xe2, 0x6a,
	0x5b, 0xba, 0x3a, 0x10, 0xae, 0x2e, 0x7b, 0x57, 0x2b, 0x9e, 0x2a, 0xfd, 0x60, 0x98, 0x56, 0x5e,
	0x54, 0x60, 0x7f, 0xc9, 0x89, 0xf1, 0x6f, 0x0d, 0xd0, 0x6a, 0x22, 0xa2, 0x20, 0x0f, 0xc4, 0xb5,
	0xa7, 0x8e, 0xcd, 0x1f, 0xa3, 0x82, 0xc4, 0x0a, 0xf4, 0x12, 0xca, 0x81, 0xcf, 0x28, 0xb1, 0x1d,
	0x77, 0x60, 0xf6, 0x89, 0xc5, 0x3d, 0x26, 0xcb, 0x52, 0xc2, 0xfb, 0xb1, 0xfe, 0x52, 0xaa, 0xd1,
	0x4f, 0xa0, 0x60, 0x79, 0x36, 0x35, 0x19, 0xe1, 0x54, 0x1e, 0xbe, 0x80, 0xf3, 0x42, 0x81, 0x09,
	0xa7, 0xe8, 0x37, 0x70, 0xe8, 0x7b, 0x23, 0xc2, 0x9c, 0xbf, 0x44, 0x19, 0x3d, 0x51, 0x16, 0x88,
	0x22, 0x8b, 0xb3, 0xe5, 0xf1, 0x41, 0x72, 0xb5, 0x13, 0x2d, 0x1a, 0x5f, 0x43, 0x65, 0xe5, 0xc0,
	0xa8, 0x01, 0xd5, 0xb8, 0x63, 0xa6, 0x4d, 0x9f, 0x1c, 0xd5, 0x2d, 0x95, 0x3b, 0x8a, 0x97, 0x5a,
	0xd1, 0x0a, 0x3a, 0x86, 0xbc, 0x4d, 0x38, 0x91, 0x89, 0xa9, 0xe4, 0x63, 0xd9, 0x98, 0xc1, 0x61,
	0xdb, 0xb5, 0xd8, 0xdc, 0xe7, 0xd4, 0xbe, 0x74, 0x5c, 0x7a, 0x1f, 0x01, 0x0c, 0x19, 0x50, 0x22,
	0x34, 0x30, 0x87, 0x74, 0x6e, 0x3a, 0xae, 0x4d, 0x67, 0x61, 0x80, 0x22, 0xa1, 0xc1, 0x15, 0x9d,
	0x77, 0x84, 0x0a, 0xfd, 0x1c, 0x76, 0x69, 0xb4, 0xdb, 0x74, 0x03, 0xe9, 0x7d, 0x17, 0x17, 0x63,
	0xdd, 0x6d, 0x0f, 0x1d, 0x41, 0xae, 0xef, 0x0f, 0x88, 0xe9, 0xd8, 0xb2, 0x28, 0xbb, 0x78, 0x47,
	0x88, 0x9d, 0x96, 0xd1, 0x02, 0xd4, 0x1d, 0x11, 0xc7, 0x4d, 0x47, 0xad, 0xc3, 0xb6, 0xc0, 0xb8,
	0x0c, 0x56, 0x3c, 0x3b, 0xae, 0x2b, 0x7c, 0xd7, 0x23, 0x7c, 0xd7, 0x63, 0x4b, 0x2c, 0xed, 0x8c,
	0x6f, 0xb7, 0x61, 0xf7, 0x2d, 0xe1, 0x74, 0x4a, 0xe6, 0x3d, 0x4e, 0x78, 0x80, 0x7e, 0x06, 0x30,
	0x50, 0xb2, 0x08, 0xa9, 0xc9, 0x90, 0x85, 0x50, 0xd3, 0x69, 0xa1, 0x3d, 0xc8, 0x38, 0xbe, 0x5e,
	0x90, 0xed, 0xc9, 0x38, 0x8b, 0x78, 0x99, 0x8f, 0x8b, 0x87, 0x5e, 0x41, 0x7e, 0xe4, 0x59, 0xaa,
	0xe2, 0x0a, 0xe1, 0xe5, 0xe8, 0xfb, 0xb8, 0x0e, 0xf5, 0x38, 0xb6, 0x40, 0xbf, 0x80, 0x3d, 0xcb,
	0x73, 0xfb, 0xce, 0xc0, 0x4c, 0xb6, 0xbb, 0x80, 0x4b, 0x4a, 0xfb, 0xa5, 0x52, 0xa2, 0x3a, 0x54,
	0xd9, 0xcc, 0xf4, 0x89, 0x35, 0xa4, 0x3c, 0x30, 0x19, 0xb5, 0xa8, 0xf3, 0x44, 0x6d, 0x3d, 0x2b,
	0x0b, 0x5e, 0x61, 0xb3, 0xae, 0x5a, 0xc1, 0xe1, 0x02, 0x7a, 0x0d, 0x87, 0x6b, 0xec, 0x4d, 0x6f,
	0xa8, 0xef, 0xc8, 0x2d, 0xd5, 0x95, 0x2d, 0x77, 0x57, 0x22, 0x08, 0x5f, 0x13, 0x24, 0xa7, 0x82,
	0xf0, 0x95, 0x20, 0xaf, 0x00, 0x25, 0xec, 0xe9, 0xd8, 0xe1, 0x9c, 0xda, 0x7a, 0x5e, 0x9a, 0x97,
	0x63, 0xf3, 0xb6, 0xd2, 0xa3, 0x37, 0x50, 0x18, 0x53, 0x4e, 0x4c, 0x01, 0x2c, 0x1d, 0x4e, 0x9e,
	0xbd, 0x28, 0x9e, 0x7d, 0x26, 0xbe, 0xd7, 0x64, 0x6f, 0xea, 0x37, 0x94, 0x93, 0x16, 0xe1, 0xa4,
	0xed, 0x72, 0x36, 0xc7, 0xf9, 0x71, 0x28, 0xa2, 0xe7, 0x90, 0x0f, 0x84, 0x81, 0xe8, 0x58, 0x51,
	0x76, 0x2c, 0x27, 0xe5, 0x4e, 0xeb, 0xf8, 0x0d, 0x94, 0x52, 0xbb, 0x50, 0x19, 0x9e, 0x0d, 0xa9,
	0xa2, 0xae, 0x02, 0x16, 0x7f, 0x51, 0x0d, 0xb2, 0x4f, 0x64, 0x34, 0x51, 0x3d, 0x2c, 0x60, 0x25,
	0xfc, 0x3e, 0xf3, 0x3b, 0xcd, 0xf8, 0x4f, 0x36, 0x62, 0x3f, 0xac, 0xd8, 0x6f, 0x03, 0x38, 0x3e,
	0x15, 0x0c, 0xef, 0xa1, 0x26, 0x7e, 0xcd, 0xc0, 0x71, 0x2d, 0x6a, 0x0e, 0xfc, 0xc0, 0xa4, 0xbe,
	0x67, 0x3d, 0x86, 0xc0, 0x78, 0xbe, 0xb2, 0xbf, 0x15, 0x92, 0x33, 0xae, 0x88, 0x6d, 0x3d, 0xb1,
	0xeb, 0x6d, 0xb7, 0xd7, 0x16, 0x7b, 0x10, 0x82, 0x6d, 0x16, 0x04, 0x8e, 0x6c, 0x7a, 0x16, 0xcb,
	0xff, 0xa2, 0x2e, 0x92, 0x5a, 0x03, 0x97, 0xc9, 0xce, 0x6a, 0x38, 0x27, 0x48, 0xb3, 0x77, 0x8b,
	0x91, 0x0e, 0x39, 0xeb, 0x91, 0xb8, 0x2e, 0x1d, 0x85, 0x1d, 0x8c, 0x44, 0xb1, 0x89, 0xf5, 0x4d,
	0xeb, 0x91, 0x38, 0x6e, 0xd8, 0xad, 0x1c, 0xeb, 0x37, 0x85, 0x28, 0x2a, 0xf5, 0xe0, 0x11, 0x66,
	0x4b, 0xfc, 0x97, 0xb0, 0x12, 0x84, 0x2b, 0xe2, 0x72, 0xea, 0xba, 0xa2, 0x71, 0xd2, 0x3e, 0x14,
	0x53, 0x60, 0x2f, 0x6e, 0x04, 0x7b, 0x1b, 0xaa, 0x7d, 0xc7, 0xa5, 0x66, 0x7c, 0x47, 0x99, 0x7c,
	0xee, 0x53, 0x7d, 0x57, 0xde, 0x22, 0x8a, 0xbc, 0x93, 0x9f, 0xfa, 0xfd, 0xdc, 0xa7, 0xb8, 0xd2,
	0x5f, 0x56, 0xa1, 0x2f, 0x41, 0x5f, 0x70, 0x4a, 0xda, 0xa1, 0x5e, 0x8a, 0x1a, 0x33, 0xad, 0xaf,
	0x67, 0xad, 0x77, 0x5b, 0xf8, 0x90, 0xae, 0xe7, 0xb3, 0xf7, 0x50, 0xf3, 0x05, 0xdf, 0x2c, 0xfb,
	0xdc, 0x5b, 0xdc, 0x53, 0xab, 0x7c, 0x24, 0xee, 0x29, 0x7f, 0x95, 0xa5, 0x44, 0xf5, 0x3d, 0x97,
	0xd3, 0x19, 0xd7, 0xf7, 0x15, 0x5e, 0x43, 0x51, 0xdc, 0x02, 0x13, 0x89, 0x38, 0x01, 0xb0, 0xb2,
	0x5c, 0xcb, 0x2b, 0x45, 0xa7, 0x85, 0x5e, 0x01, 0x58, 0xcc, 0x32, 0x05, 0xb6, 0x27, 0x81, 0x5e,
	0x91, 0x85, 0x29, 0x89, 0xc0, 0x4d, 0xdc, 0xec, 0x49, 0x25, 0x2e, 0x58, 0xcc, 0x52, 0x7f, 0x2f,
	0xca, 0xb0, 0x97, 0x4e, 0xd5, 0xf8, 0x57, 0x16, 0xf6, 0x5a, 0xde, 0xd4, 0x4d, 0xdc, 0xe7, 0x1b,
	0x10, 0x9d, 0xba, 0xee, 0xb3, 0xcb, 0xd7, 0x7d, 0x0d, 0xb2, 0xbe, 0x37, 0xa5, 0x0a, 0x5c, 0x59,
	0xac, 0x84, 0xa5, 0x21, 0x20, 0xf7, 0x7f, 0x0d, 0x01, 0xf9, 0x1f, 0x6e, 0x08, 0x28, 0x7c, 0xea,
	0x10, 0xb0, 0x80, 0x3b, 0x7c, 0x07, 0xdc, 0x8b, 0x69, 0xb8, 0x9f, 0xc2, 0x0e, 0x77, 0xc6, 0x8e,
	0x3b, 0x08, 0x31, 0x8b, 0x44, 0xac, 0xb8, 0xde, 0x72, 0x05, 0x87, 0x16, 0xa8, 0x07, 0x47, 0xce,
	0x78, 0x4c, 0x6d, 0x87, 0x70, 0x3a, 0x9a, 0x9b, 0x4a, 0xab, 0x12, 0x2d, 0x45, 0x5f, 0xff, 0xb4,
	0xde, 0x59, 0x98, 0xa8, 0xfd, 0x32, 0x59, 0x0d, 0x1f, 0x38, 0xeb, 0x16, 0xd0, 0x39, 0x54, 0x6c,
	0x3a, 0x22, 0x69, 0x77, 0x0a, 0x9f, 0x55, 0x99, 0x8b, 0x58, 0x4c, 0x39, 0xda, 0xb7, 0xd3, 0x2a,
	0x74, 0x05, 0x07, 0x31, 0x0f, 0xa5, 0xdc, 0xec, 0x2f, 0x3a, 0x11, 0x71, 0x4e, 0xca, 0x13, 0x1a,
	0xf8, 0xc1, 0x92, 0x36, 0x09, 0xf3, 0x72, 0x0a, 0xe6, 0x6b, 0xe6, 0xab, 0x8b, 0x12, 0x14, 0x13,
	0xf1, 0x8c, 0x23, 0x38, 0x58, 0x7b, 0x7a, 0xe3, 0x02, 0xf6, 0x97, 0xce, 0x81, 0x1a, 0x90, 0x95,
	0xe7, 0x08, 0x6f, 0xfd, 0xef, 0x21, 0x4e, 0x65, 0x67, 0x7c, 0x0d, 0x68, 0xf5, 0x10, 0xdf, 0x49,
	0xc7, 0xda, 0xa7, 0xd3, 0xb1, 0xf1, 0x37, 0x0d, 0x8a, 0xea, 0xea, 0xb8, 0x64, 0x64, 0x4c, 0xd1,
	0xe7, 0x50, 0xf4, 0x1f, 0xe7, 0xa6, 0x4f, 0xe6, 0x23, 0x8f, 0x44, 0x1f, 0x1a, 0xf8, 0x8f, 0xf3,
	0xae, 0xd2, 0xa0, 0x97, 0x90, 0xe3, 0x33, 0x55, 0xea, 0x4c, 0x48, 0x95, 0x83, 0x69, 0x3d, 0x39,
	0x7b, 0xe3, 0x1d, 0x3e, 0x93, 0x79, 0xbe, 0x84, 0x1c, 0x9b, 0x25, 0x87, 0xe4, 0x84, 0x29, 0x0e,
	0x4d, 0x99, 0x34, 0x35, 0xfe, 0xa1, 0xc1, 0x5e, 0x22, 0x8d, 0x1e, 0xe5, 0x3f, 0x5e, 0x26, 0xcf,
	0xbe, 0x37, 0x93, 0x6f, 0x34, 0x28, 0x45, 0xdf, 0xc2, 0x47, 0x96, 0xe4, 0x8b, 0xe5, 0x44, 0xd2,
	0x1f, 0x54, 0x3a, 0x95, 0x1a, 0x64, 0xb9, 0x37, 0xa4, 0x6a, 0xaa, 0x2a, 0x61, 0x25, 0x88, 0x18,
	0x76, 0x68, 0x2f, 0xf8, 0x6d, 0x5b, 0xc5, 0x88, 0x54, 0x9d, 0x96, 0xf1, 0xd7, 0x45, 0x56, 0xf7,
	0x5f, 0x9d, 0x5b, 0xc3, 0x4d, 0x84, 0x18, 0x87, 0xc9, 0x24, 0xc3, 0xd4, 0x20, 0x4b, 0x19, 0xf3,
	0x58, 0x38, 0xb7, 0x2b, 0x61, 0x73, 0xf0, 0xbf, 0x6b, 0x50, 0x0b, 0x07, 0x9c, 0xa6, 0x1c, 0xe8,
	0x42, 0x40, 0x6d, 0x4a, 0x42, 0x87, 0x5c, 0x34, 0x0f, 0xaa, 0x99, 0x25, 0x12, 0xd1, 0xaf, 0x21,
	0x1f, 0xde, 0xe3, 0x41, 0xd8, 0x11, 0x5d, 0xde, 0x0f, 0x4a, 0x97, 0x0a, 0x82, 0x63, 0x4b, 0xe3,
	0xbf, 0x19, 0xa8, 0xad, 0x33, 0xf9, 0x11, 0x5e, 0x7b, 0x5d, 0x38, 0x5c, 0x26, 0x7a, 0x35, 0xcb,
	0x86, 0x50, 0xd6, 0x57, 0xa9, 0x5e, 0xa5, 0xf4, 0x6e, 0x0b, 0xd7, 0x46, 0x6b, 0xf4, 0xe8, 0x06,
	0x0e, 0x96, 0xe8, 0x3e, 0x74, 0xa8, 0x5e, 0x7d, 0x47, 0x2b, 0x84, 0x1f, 0xfb, 0xab, 0xa6, 0x28,
	0x3f, 0x74, 0x17, 0x93, 0x7e, 0x36, 0x49, 0xfa, 0x27, 0x50, 0xb4, 0x69, 0x18, 0xc2, 0x63, 0xe1,
	0x98, 0x9c, 0x54, 0x5d, 0x54, 0xa1, 0xb2, 0x92, 0x82, 0x41, 0xa0, 0xb6, 0xee, 0x2c, 0x1b, 0x1e,
	0x8d, 0x5f, 0x40, 0x65, 0xf9, 0xd1, 0x28, 0x9e, 0x46, 0xcf, 0xc4, 0xe0, 0xbc, 0xf4, 0x6a, 0x0c,
	0x8c, 0x1b, 0xa8, 0xae, 0x39, 0xdd, 0x86, 0x08, 0x3a, 0xe4, 0x1e, 0x1c, 0x9e, 0x78, 0xd0, 0x45,
	0xa2, 0xf1, 0x4d, 0x06, 0x9e, 0xc7, 0x90, 0x1c, 0x8f, 0x89, 0x6b, 0xb7, 0x67, 0xd4, 0xc2, 0xa2,
	0xe5, 0x01, 0xff, 0x08, 0x5c, 0x5a, 0x6a, 0x53, 0x84, 0xcb, 0x50, 0x44, 0x87, 0xb0, 0x23, 0xfc,
	0x74, 0xe2, 0x47, 0x1c, 0x15, 0x92, 0xfc, 0x9c, 0x02, 0x6e, 0x3b, 0x6e, 0xf8, 0x71, 0x28, 0x01,
	0x75, 0xa1, 0x48, 0xdd, 0x27, 0x87, 0x79, 0xee, 0x98, 0xba, 0x5c, 0xcf, 0x4a, 0x20, 0xd7, 0x13,
	0xcf, 0x81, 0xd5, 0xd4, 0xea, 0xed, 0xc5, 0x06, 0xf5, 0x3c, 0x48, 0xba, 0x38, 0xfe, 0x03, 0x94,
	0x97, 0x0d, 0x3e, 0xe9, 0x25, 0xf0, 0xad, 0x06, 0xc7, 0xeb, 0x62, 0x07, 0xbe, 0xe7, 0x06, 0x74,
	0x53, 0x5d, 0x8e, 0x20, 0x27, 0xce, 0x2b, 0xd6, 0x32, 0xa9, 0xe3, 0x1f, 0xc2, 0x4e, 0xc0, 0x6d,
	0x6f, 0xc2, 0xa3, 0xb2, 0x28, 0x29, 0xd4, 0x53, 0xc6, 0xc2, 0xba, 0x84, 0xd2, 0x82, 0x67, 0xb2,
	0x09, 0x9e, 0x31, 0x1c, 0x38, 0xc2, 0x64, 0xaa, 0x1e, 0x54, 0x97, 0x1e, 0x9b, 0x12, 0x66, 0x53,
	0xd6, 0x7e, 0xa2, 0xee, 0xc6, 0x86, 0x1d, 0xc0, 0x0e, 0x23, 0xd3, 0x45, 0x5e, 0x59, 0x46, 0xa6,
	0xaa, 0x8f, 0x11, 0x2b, 0xab, 0xbc, 0x22, 0xd1, 0x18, 0xc2, 0xf3, 0xd5, 0x50, 0x61, 0x45, 0x7e,
	0xe8, 0x60, 0xa7, 0x6f, 0x12, 0xd3, 0xaa, 0x9a, 0x9a, 0xf6, 0xa1, 0xd8, 0xb9, 0xb9, 0x69, 0xb7,
	0x3a, 0xe7, 0xf7, 0xed, 0xeb, 0x0f, 0xe5, 0x2d, 0x54, 0x80, 0x6c, 0xab, 0x7d, 0x7d, 0xfe, 0xa1,
	0xac, 0xa1, 0x12, 0x14, 0xde, 0x76, 0x7b, 0x66, 0xbb, 0x7b, 0xd7, 0x7c, 0x57, 0xce, 0x9c, 0xfe,
	0x16, 0x2a, 0x2b, 0xcf, 0x05, 0x94, 0x87, 0xed, 0xdb, 0xbb, 0xdb, 0x76, 0x79, 0x4b, 0x58, 0xb7,
	0x6f, 0x9b, 0xf8, 0x43, 0xf7, 0xbe, 0xdd, 0x2a, 0x6b, 0xc2, 0x4f, 0xf7, 0xfa, 0xbc, 0x73, 0x5b,
	0xce, 0x9c, 0xfe, 0x0a, 0x0a, 0xf1, 0x38, 0x8d, 0x00, 0x76, 0x6e, 0xef, 0xcc, 0x26, 0x6e, 0x96,
	0xb7, 0x50, 0x11, 0x72, 0x17, 0xe7, 0x2d, 0x29, 0x68, 0x62, 0xa1, 0x89, 0x9b, 0xe6, 0xdd, 0x55,
	0x39, 0x73, 0xf1, 0xea, 0x4f, 0xa7, 0x03, 0x87, 0x3f, 0x4e, 0x1e, 0x04, 0xf7, 0x35, 0x1e, 0x98,
	0x67, 0x11, 0xc2, 0x1a, 0xd6, 0xa3, 0xc3, 0xfc, 0x80, 0x13, 0x6b, 0xf8, 0x4b, 0xe2, 0x3b, 0x8d,
	0x81, 0xd7, 0x78, 0x7a, 0xdd, 0x18, 0x4c, 0x1f, 0x76, 0xe4, 0xfc, 0xf0, 0xfa, 0x7f, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xcf, 0x1f, 0xbf, 0x0e, 0xc2, 0x13, 0x00, 0x00,
}
