package coder

import (
	"context"
	"net/http"
	"time"
)

// Secret describes a Coder secret.
//
// Deprecated: Coder Secrets will be removed from Coder Enterprise in a future release.
type Secret struct {
	ID          string    `json:"id"              table:"-"`
	Name        string    `json:"name"            table:"Name"`
	Value       string    `json:"value,omitempty" table:"Value"`
	Description string    `json:"description"     table:"Description"`
	CreatedAt   time.Time `json:"created_at"      table:"CreatedAt"`
	UpdatedAt   time.Time `json:"updated_at"      table:"-"`
}

// Secrets gets all secrets for the given user.
//
// Deprecated: Coder Secrets will be removed from Coder Enterprise in a future release.
func (c Client) Secrets(ctx context.Context, userID string) ([]Secret, error) {
	var secrets []Secret
	if err := c.requestBody(ctx, http.MethodGet, "/api/users/"+userID+"/secrets", nil, &secrets); err != nil {
		return nil, err
	}
	return secrets, nil
}

// SecretWithValueByName gets the Coder secret with its value by its name.
//
// Deprecated: Coder Secrets will be removed from Coder Enterprise in a future release.
func (c Client) SecretWithValueByName(ctx context.Context, name, userID string) (*Secret, error) {
	// Lookup the secret from the name.
	s, err := c.SecretByName(ctx, name, userID)
	if err != nil {
		return nil, err
	}
	// Pull the secret value.
	// NOTE: This is racy, but acceptable. If the secret is gone or the permission changed since we looked up the id,
	//       the call will simply fail and surface the error to the user.
	var secret Secret
	if err := c.requestBody(ctx, http.MethodGet, "/api/users/"+userID+"/secrets/"+s.ID, nil, &secret); err != nil {
		return nil, err
	}
	return &secret, nil
}

// SecretWithValueByID gets the Coder secret with its value by the secret_id.
//
// Deprecated: Coder Secrets will be removed from Coder Enterprise in a future release.
func (c Client) SecretWithValueByID(ctx context.Context, id, userID string) (*Secret, error) {
	var secret Secret
	if err := c.requestBody(ctx, http.MethodGet, "/api/users/"+userID+"/secrets/"+id, nil, &secret); err != nil {
		return nil, err
	}
	return &secret, nil
}

// SecretByName gets a secret object by name.
//
// Deprecated: Coder Secrets will be removed from Coder Enterprise in a future release.
func (c Client) SecretByName(ctx context.Context, name, userID string) (*Secret, error) {
	secrets, err := c.Secrets(ctx, userID)
	if err != nil {
		return nil, err
	}
	for _, s := range secrets {
		if s.Name == name {
			return &s, nil
		}
	}
	return nil, ErrNotFound
}

// InsertSecretReq describes the request body for creating a new secret.
//
// Deprecated: Coder Secrets will be removed from Coder Enterprise in a future release.
type InsertSecretReq struct {
	Name        string `json:"name"`
	Value       string `json:"value"`
	Description string `json:"description"`
}

// InsertSecret adds a new secret for the authed user.
//
// Deprecated: Coder Secrets will be removed from Coder Enterprise in a future release.
func (c Client) InsertSecret(ctx context.Context, userID string, req InsertSecretReq) error {
	return c.requestBody(ctx, http.MethodPost, "/api/users/"+userID+"/secrets", req, nil)
}

// DeleteSecretByName deletes the authenticated users secret with the given name.
//
// Deprecated: Coder Secrets will be removed from Coder Enterprise in a future release.
func (c Client) DeleteSecretByName(ctx context.Context, name, userID string) error {
	// Lookup the secret by name to get the ID.
	secret, err := c.SecretByName(ctx, name, userID)
	if err != nil {
		return err
	}
	// Delete the secret.
	// NOTE: This is racy, but acceptable. If the secret is gone or the permission changed since we looked up the id,
	//       the call will simply fail and surface the error to the user.
	resp, err := c.request(ctx, http.MethodDelete, "/api/users/"+userID+"/secrets/"+secret.ID, nil)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	return nil
}
