// Go Substrate RPC Client (GSRPC) provides APIs and types around Polkadot and any Substrate-based chain RPC calls
//
// Copyright 2019 Centrifuge GmbH
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package types

var ExamplaryMetadataV4 = &Metadata{MagicNumber: 0x6174656d, Version: 0x4, IsMetadataV4: true, AsMetadataV4: MetadataV4{Modules: []ModuleMetadataV4{{Name: "system", Prefix: "System", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "AccountNonce", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::Index", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Extrinsics nonce for accounts."}}, {Name: "ExtrinsicCount", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Total extrinsics count for the current block."}}, {Name: "AllExtrinsicsLen", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Total length in bytes for all extrinsics put together, for the current block."}}, {Name: "BlockHash", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::BlockNumber", Value: "T::Hash", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Map of block numbers to block hashes."}}, {Name: "ExtrinsicData", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "u32", Value: "Vec<u8>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Extrinsics data for the current block (maps extrinsic's index to its data)."}}, {Name: "RandomSeed", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Hash", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Random seed of the current block."}}, {Name: "Number", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The current block number being processed. Set by `execute_block`."}}, {Name: "ParentHash", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Hash", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Hash of the previous block."}}, {Name: "ExtrinsicsRoot", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Hash", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Extrinsics root of the current block, also part of the block header."}}, {Name: "Digest", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Digest", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Digest of the current block, also part of the block header."}}, {Name: "Events", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<EventRecord<T::Event>>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Events deposited for the current block."}}}, HasCalls: false, Calls: []FunctionMetadataV4(nil), HasEvents: true, Events: []EventMetadataV4{{Name: "ExtrinsicSuccess", Args: []Type(nil), Documentation: []Text{" An extrinsic completed successfully."}}, {Name: "ExtrinsicFailed", Args: []Type(nil), Documentation: []Text{" An extrinsic failed."}}}}, {Name: "aura", Prefix: "", HasStorage: false, Storage: []StorageFunctionMetadataV4(nil), HasCalls: false, Calls: []FunctionMetadataV4(nil), HasEvents: false, Events: []EventMetadataV4(nil)}, {Name: "timestamp", Prefix: "Timestamp", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "Now", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Moment", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current time for the current block."}}, {Name: "BlockPeriod", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Moment", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Old storage item provided for compatibility. Remove after all networks upgraded."}}, {Name: "MinimumPeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Moment", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The minimum period between blocks. Beware that this is different to the *expected* period", " that the block production apparatus provides. Your chosen consensus system will generally", " work with this to determine a sensible block time. e.g. For Aura, it will be double this", " period on default settings."}}, {Name: "DidUpdate", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "bool", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Did the timestamp get updated in this block?"}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set", Args: []FunctionArgumentMetadata{{Name: "now", Type: "Compact<T::Moment>"}}, Documentation: []Text{" Set the current time.", "", " This call should be invoked exactly once per block. It will panic at the finalization phase,", " if this call hasn't been invoked by that time.", "", " The timestamp should be greater than the previous one by the amount specified by `minimum_period`.", "", " The dispatch origin for this call must be `Inherent`."}}}, HasEvents: false, Events: []EventMetadataV4(nil)}, {Name: "consensus", Prefix: "Consensus", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "OriginalAuthorities", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<T::SessionKey>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text(nil)}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "report_misbehavior", Args: []FunctionArgumentMetadata{{Name: "_report", Type: "Vec<u8>"}}, Documentation: []Text{" Report some misbehavior."}}, {Name: "note_offline", Args: []FunctionArgumentMetadata{{Name: "offline", Type: "<T::InherentOfflineReport as InherentOfflineReport>::Inherent"}}, Documentation: []Text{" Note that the previous block's validator missed its opportunity to propose a block."}}, {Name: "remark", Args: []FunctionArgumentMetadata{{Name: "_remark", Type: "Vec<u8>"}}, Documentation: []Text{" Make some on-chain remark."}}, {Name: "set_heap_pages", Args: []FunctionArgumentMetadata{{Name: "pages", Type: "u64"}}, Documentation: []Text{" Set the number of pages in the WebAssembly environment's heap."}}, {Name: "set_code", Args: []FunctionArgumentMetadata{{Name: "new", Type: "Vec<u8>"}}, Documentation: []Text{" Set the new code."}}, {Name: "set_storage", Args: []FunctionArgumentMetadata{{Name: "items", Type: "Vec<KeyValue>"}}, Documentation: []Text{" Set some items of storage."}}, {Name: "kill_storage", Args: []FunctionArgumentMetadata{{Name: "keys", Type: "Vec<Key>"}}, Documentation: []Text{" Kill some items from storage."}}}, HasEvents: false, Events: []EventMetadataV4(nil)}, {Name: "indices", Prefix: "Indices", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "NextEnumSet", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::AccountIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The next free enumeration set."}}, {Name: "EnumSet", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountIndex", Value: "Vec<T::AccountId>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The enumeration sets."}}}, HasCalls: true, Calls: []FunctionMetadataV4(nil), HasEvents: true, Events: []EventMetadataV4{{Name: "NewAccountIndex", Args: []Type{"AccountId", "AccountIndex"}, Documentation: []Text{" A new account index was assigned.", "", " This event is not triggered when an existing index is reassigned", " to another `AccountId`."}}}}, {Name: "balances", Prefix: "Balances", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "TotalIssuance", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Balance", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The total units issued in the system."}}, {Name: "ExistentialDeposit", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Balance", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The minimum amount required to keep an account open."}}, {Name: "TransferFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Balance", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to make a transfer."}}, {Name: "CreationFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Balance", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to create an account."}}, {Name: "TransactionBaseFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Balance", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee to be paid for making a transaction; the base."}}, {Name: "TransactionByteFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Balance", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee to be paid for making a transaction; the per-byte portion."}}, {Name: "Vesting", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "VestingSchedule<T::Balance>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Information regarding the vesting of a given account."}}, {Name: "FreeBalance", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::Balance", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The 'free' balance of a given account.", "", " This is the only balance that matters in terms of most operations on tokens. It", " alone is used to determine the balance when in the contract execution environment. When this", " balance falls below the value of `ExistentialDeposit`, then the 'current account' is", " deleted: specifically `FreeBalance`. Further, the `OnFreeBalanceZero` callback", " is invoked, giving a chance to external modules to clean up data associated with", " the deleted account.", "", " `system::AccountNonce` is also deleted if `ReservedBalance` is also zero (it also gets", " collapsed to zero if it ever becomes less than `ExistentialDeposit`."}}, {Name: "ReservedBalance", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::Balance", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The amount of the balance of a given account that is externally reserved; this can still get", " slashed, but gets slashed last of all.", "", " This balance is a 'reserve' balance that other subsystems use in order to set aside tokens", " that are still 'owned' by the account holder, but which are suspendable.", "", " When this balance falls below the value of `ExistentialDeposit`, then this 'reserve account'", " is deleted: specifically, `ReservedBalance`.", "", " `system::AccountNonce` is also deleted if `FreeBalance` is also zero (it also gets", " collapsed to zero if it ever becomes less than `ExistentialDeposit`.)"}}, {Name: "Locks", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "Vec<BalanceLock<T::Balance, T::BlockNumber>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Any liquidity locks on some account balances."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "transfer", Args: []FunctionArgumentMetadata{{Name: "dest", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "value", Type: "Compact<T::Balance>"}}, Documentation: []Text{" Transfer some liquid free balance to another account.", "", " `transfer` will set the `FreeBalance` of the sender and receiver.", " It will decrease the total issuance of the system by the `TransferFee`.", " If the sender's account is below the existential deposit as a result", " of the transfer, the account will be reaped.", "", " The dispatch origin for this call must be `Signed` by the transactor."}}, {Name: "set_balance", Args: []FunctionArgumentMetadata{{Name: "who", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "free", Type: "Compact<T::Balance>"}, {Name: "reserved", Type: "Compact<T::Balance>"}}, Documentation: []Text{" Set the balances of a given account.", "", " This will alter `FreeBalance` and `ReservedBalance` in storage.", " If the new free or reserved balance is below the existential deposit,", " it will also decrease the total issuance of the system (`TotalIssuance`)", " and reset the account nonce (`system::AccountNonce`).", "", " The dispatch origin for this call is `root`."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "NewAccount", Args: []Type{"AccountId", "Balance"}, Documentation: []Text{" A new account was created."}}, {Name: "ReapedAccount", Args: []Type{"AccountId"}, Documentation: []Text{" An account was reaped."}}, {Name: "Transfer", Args: []Type{"AccountId", "AccountId", "Balance", "Balance"}, Documentation: []Text{" Transfer succeeded (from, to, value, fees)."}}}}, {Name: "session", Prefix: "Session", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "Validators", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The current set of validators."}}, {Name: "SessionLength", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current length of the session."}}, {Name: "CurrentIndex", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current index of the session."}}, {Name: "CurrentStart", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Moment", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Timestamp when current session started."}}, {Name: "ForcingNewSession", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "bool", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" New session is being forced if this entry exists; in which case, the boolean value is whether", " the new session should be considered a normal rotation (rewardable) or exceptional (slashable)."}}, {Name: "LastLengthChange", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Block at which the session length last changed."}}, {Name: "NextKeyFor", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::SessionKey", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The next key for a given validator."}}, {Name: "NextSessionLength", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The next session length."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set_key", Args: []FunctionArgumentMetadata{{Name: "key", Type: "T::SessionKey"}}, Documentation: []Text{" Sets the session key of `_validator` to `_key`. This doesn't take effect until the next", " session."}}, {Name: "set_length", Args: []FunctionArgumentMetadata{{Name: "new", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Set a new session length. Won't kick in until the next session change (at current length)."}}, {Name: "force_new_session", Args: []FunctionArgumentMetadata{{Name: "apply_rewards", Type: "bool"}}, Documentation: []Text{" Forces a new session."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "NewSession", Args: []Type{"BlockNumber"}, Documentation: []Text{" New session has happened. Note that the argument is the session index, not the block", " number as the type might suggest."}}}}, {Name: "staking", Prefix: "Staking", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "ValidatorCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The ideal number of staking participants."}}, {Name: "MinimumValidatorCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x4, 0x0, 0x0, 0x0}, Documentation: []Text{" Minimum number of staking participants before emergency conditions are imposed."}}, {Name: "SessionsPerEra", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The length of a staking era in sessions."}}, {Name: "SessionReward", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Perbill", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x3c, 0x0, 0x0, 0x0}, Documentation: []Text{" Maximum reward, per validator, that is provided per acceptable session."}}, {Name: "OfflineSlash", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Perbill", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x40, 0x42, 0xf, 0x0}, Documentation: []Text{" Slash, per validator that is taken for the first time they are found to be offline."}}, {Name: "OfflineSlashGrace", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of instances of offline reports before slashing begins for validators."}}, {Name: "BondingDuration", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The length of the bonding duration in blocks."}}, {Name: "Invulnerables", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Any validators that may never be slashed or forcibly kicked. It's a Vec since they're easy to initialize", " and the performance hit is minimal (we expect no more than four invulnerables) and restricted to testnets."}}, {Name: "Bonded", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::AccountId", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Map from all locked \"stash\" accounts to the controller account."}}, {Name: "Ledger", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "StakingLedger<T::AccountId, BalanceOf<T>, T::BlockNumber>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Map from all (unlocked) \"controller\" accounts to the info regarding the staking."}}, {Name: "Payee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "RewardDestination", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Where the reward payment should be made. Keyed by stash."}}, {Name: "Validators", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "ValidatorPrefs<BalanceOf<T>>", Linked: true}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xc, 0x0}, Documentation: []Text{" The map from (wannabe) validator stash key to the preferences of that validator."}}, {Name: "Nominators", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "Vec<T::AccountId>", Linked: true}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The map from nominator stash key to the set of stash keys of all validators to nominate."}}, {Name: "Stakers", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "Exposure<T::AccountId, BalanceOf<T>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0}, Documentation: []Text{" Nominators for a particular account that is in action right now. You can't iterate through validators here,", " but you can find them in the `sessions` module.", "", " This is keyed by the stash account."}}, {Name: "CurrentElected", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The currently elected validator set keyed by stash account ID."}}, {Name: "CurrentEra", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The current era index."}}, {Name: "CurrentSessionReward", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Maximum reward, per validator, that is provided per acceptable session."}}, {Name: "CurrentEraReward", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The accumulated reward for the current era. Reset to zero at the beginning of the era and", " increased for every successfully finished session."}}, {Name: "NextSessionsPerEra", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The next value of sessions per era."}}, {Name: "LastEraLengthChange", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The session index at which the era length last changed."}}, {Name: "SlotStake", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The amount of balance actively at stake for each validator slot, currently.", "", " This is used to derive rewards and punishments."}}, {Name: "SlashCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "u32", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The number of times a given validator has been reported offline. This gets decremented by one each era that passes."}}, {Name: "ForcingNewEra", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "()", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" We are forcing a new era."}}, {Name: "RecentlyOffline", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<(T::AccountId, T::BlockNumber, u32)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Most recent `RECENT_OFFLINE_COUNT` instances. (who it was, when it was reported, how many instances they were offline for)."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "bond", Args: []FunctionArgumentMetadata{{Name: "controller", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "value", Type: "Compact<BalanceOf<T>>"}, {Name: "payee", Type: "RewardDestination"}}, Documentation: []Text{" Take the origin account as a stash and lock up `value` of its balance. `controller` will be the", " account that controls it.", "", " The dispatch origin for this call must be _Signed_ by the stash account."}}, {Name: "bond_extra", Args: []FunctionArgumentMetadata{{Name: "max_additional", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Add some extra amount that have appeared in the stash `free_balance` into the balance up for", " staking.", "", " Use this if there are additional funds in your stash account that you wish to bond.", "", " The dispatch origin for this call must be _Signed_ by the stash, not the controller."}}, {Name: "unbond", Args: []FunctionArgumentMetadata{{Name: "value", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Schedule a portion of the stash to be unlocked ready for transfer out after the bond", " period ends. If this leaves an amount actively bonded less than", " T::Currency::existential_deposit(), then it is increased to the full amount.", "", " Once the unlock period is done, you can call `withdraw_unbonded` to actually move", " the funds out of management ready for transfer.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash.", "", " See also [`Call::withdraw_unbonded`]."}}, {Name: "withdraw_unbonded", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Remove any unlocked chunks from the `unlocking` queue from our management.", "", " This essentially frees up that balance to be used by the stash account to do", " whatever it wants.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash.", "", " See also [`Call::unbond`]."}}, {Name: "validate", Args: []FunctionArgumentMetadata{{Name: "prefs", Type: "ValidatorPrefs<BalanceOf<T>>"}}, Documentation: []Text{" Declare the desire to validate for the origin controller.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash."}}, {Name: "nominate", Args: []FunctionArgumentMetadata{{Name: "targets", Type: "Vec<<T::Lookup as StaticLookup>::Source>"}}, Documentation: []Text{" Declare the desire to nominate `targets` for the origin controller.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash."}}, {Name: "chill", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Declare no desire to either validate or nominate.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash."}}, {Name: "set_payee", Args: []FunctionArgumentMetadata{{Name: "payee", Type: "RewardDestination"}}, Documentation: []Text{" (Re-)set the payment target for a controller.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash."}}, {Name: "set_controller", Args: []FunctionArgumentMetadata{{Name: "controller", Type: "<T::Lookup as StaticLookup>::Source"}}, Documentation: []Text{" (Re-)set the payment target for a controller.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the stash, not the controller."}}, {Name: "set_sessions_per_era", Args: []FunctionArgumentMetadata{{Name: "new", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Set the number of sessions in an era."}}, {Name: "set_bonding_duration", Args: []FunctionArgumentMetadata{{Name: "new", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" The length of the bonding duration in eras."}}, {Name: "set_validator_count", Args: []FunctionArgumentMetadata{{Name: "new", Type: "Compact<u32>"}}, Documentation: []Text{" The ideal number of validators."}}, {Name: "force_new_era", Args: []FunctionArgumentMetadata{{Name: "apply_rewards", Type: "bool"}}, Documentation: []Text{" Force there to be a new era. This also forces a new session immediately after.", " `apply_rewards` should be true for validators to get the session reward."}}, {Name: "set_offline_slash_grace", Args: []FunctionArgumentMetadata{{Name: "new", Type: "Compact<u32>"}}, Documentation: []Text{" Set the offline slash grace period."}}, {Name: "set_invulnerables", Args: []FunctionArgumentMetadata{{Name: "validators", Type: "Vec<T::AccountId>"}}, Documentation: []Text{" Set the validators who cannot be slashed (if any)."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Reward", Args: []Type{"Balance"}, Documentation: []Text{" All validators have been rewarded by the given balance."}}, {Name: "OfflineWarning", Args: []Type{"AccountId", "u32"}, Documentation: []Text{" One validator (and their nominators) has been given a offline-warning (they're still", " within their grace). The accrued number of slashes is recorded, too."}}, {Name: "OfflineSlash", Args: []Type{"AccountId", "Balance"}, Documentation: []Text{" One validator (and their nominators) has been slashed by the given amount."}}}}, {Name: "democracy", Prefix: "Democracy", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "PublicPropCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "PropIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The number of (public) proposals that have been made so far."}}, {Name: "PublicProps", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<(PropIndex, T::Proposal, T::AccountId)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The public proposals. Unsorted. `T::AccountId` refers to the account that proposed."}}, {Name: "DepositOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "PropIndex", Value: "(BalanceOf<T>, Vec<T::AccountId>)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Those who have locked a deposit."}}, {Name: "LaunchPeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" How often (in blocks) new public referenda are launched."}}, {Name: "MinimumDeposit", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The minimum amount to be used as a deposit for a public referendum proposal."}}, {Name: "PublicDelay", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The delay before enactment for all public referenda."}}, {Name: "MaxLockPeriods", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "LockPeriods", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The maximum number of additional lock periods a voter may offer to strengthen their vote."}}, {Name: "VotingPeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" How often (in blocks) to check for new votes."}}, {Name: "ReferendumCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "ReferendumIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The next free referendum index, aka the number of referenda started so far."}}, {Name: "NextTally", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "ReferendumIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The next referendum index that should be tallied."}}, {Name: "ReferendumInfoOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "ReferendumIndex", Value: "(ReferendumInfo<T::BlockNumber, T::Proposal>)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Information concerning any given referendum."}}, {Name: "DispatchQueue", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::BlockNumber", Value: "Vec<Option<(T::Proposal, ReferendumIndex)>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Queue of successful referenda to be dispatched."}}, {Name: "VotersFor", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "ReferendumIndex", Value: "Vec<T::AccountId>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Get the voters for the current proposal."}}, {Name: "VoteOf", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "(ReferendumIndex, T::AccountId)", Value: "Vote", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Get the vote in a given referendum of a particular voter. The result is meaningful only if `voters_for` includes the", " voter when called with the referendum (you'll get the default `Vote` value otherwise). If you don't want to check", " `voters_for`, then you can also check for simple existence with `VoteOf::exists` first."}}, {Name: "Proxy", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::AccountId", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Who is able to vote for whom. Value is the fund-holding account, key is the vote-transaction-sending account."}}, {Name: "Delegations", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "(T::AccountId, LockPeriods)", Linked: true}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Get the account (and lock periods) to which another account is delegating vote."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "propose", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}, {Name: "value", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Propose a sensitive action to be taken."}}, {Name: "second", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Compact<PropIndex>"}}, Documentation: []Text{" Second (sponsor) a proposal."}}, {Name: "vote", Args: []FunctionArgumentMetadata{{Name: "ref_index", Type: "Compact<ReferendumIndex>"}, {Name: "vote", Type: "Vote"}}, Documentation: []Text{" Vote on a referendum. If `vote.is_aye`, the vote is to enact the proposal;", " otherwise it is a vote to keep the status quo."}}, {Name: "proxy_vote", Args: []FunctionArgumentMetadata{{Name: "ref_index", Type: "Compact<ReferendumIndex>"}, {Name: "vote", Type: "Vote"}}, Documentation: []Text{" Vote on a referendum using a proxy account on behalf of a stash account. If `vote.is_aye`, the vote is to enact the proposal;", " otherwise it is a vote to keep the status quo."}}, {Name: "start_referendum", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}, {Name: "threshold", Type: "VoteThreshold"}, {Name: "delay", Type: "T::BlockNumber"}}, Documentation: []Text{" Start a referendum."}}, {Name: "cancel_referendum", Args: []FunctionArgumentMetadata{{Name: "ref_index", Type: "Compact<ReferendumIndex>"}}, Documentation: []Text{" Remove a referendum."}}, {Name: "cancel_queued", Args: []FunctionArgumentMetadata{{Name: "when", Type: "Compact<T::BlockNumber>"}, {Name: "which", Type: "Compact<u32>"}}, Documentation: []Text{" Cancel a proposal queued for enactment."}}, {Name: "set_proxy", Args: []FunctionArgumentMetadata{{Name: "proxy", Type: "T::AccountId"}}, Documentation: []Text{" Specify a proxy. Called by the stash."}}, {Name: "resign_proxy", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Clear the proxy. Called by the proxy."}}, {Name: "remove_proxy", Args: []FunctionArgumentMetadata{{Name: "proxy", Type: "T::AccountId"}}, Documentation: []Text{" Clear the proxy. Called by the stash."}}, {Name: "delegate", Args: []FunctionArgumentMetadata{{Name: "to", Type: "T::AccountId"}, {Name: "lock_periods", Type: "LockPeriods"}}, Documentation: []Text{" Delegate vote."}}, {Name: "undelegate", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Undelegate vote."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Proposed", Args: []Type{"PropIndex", "Balance"}, Documentation: []Text(nil)}, {Name: "Tabled", Args: []Type{"PropIndex", "Balance", "Vec<AccountId>"}, Documentation: []Text(nil)}, {Name: "Started", Args: []Type{"ReferendumIndex", "VoteThreshold"}, Documentation: []Text(nil)}, {Name: "Passed", Args: []Type{"ReferendumIndex"}, Documentation: []Text(nil)}, {Name: "NotPassed", Args: []Type{"ReferendumIndex"}, Documentation: []Text(nil)}, {Name: "Cancelled", Args: []Type{"ReferendumIndex"}, Documentation: []Text(nil)}, {Name: "Executed", Args: []Type{"ReferendumIndex", "bool"}, Documentation: []Text(nil)}, {Name: "Delegated", Args: []Type{"AccountId", "AccountId"}, Documentation: []Text(nil)}, {Name: "Undelegated", Args: []Type{"AccountId"}, Documentation: []Text(nil)}}}, {Name: "council", Prefix: "Council", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "CandidacyBond", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Amount that must be locked up in order to submit one's candidacy."}}, {Name: "VotingBond", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Amount that must be locked up in order to be able to submit votes."}}, {Name: "PresentSlashPerVoter", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The punishment, per voter, if you provide an invalid presentation."}}, {Name: "CarryCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x2, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of runners-up who should have their approvals persist until the next vote."}}, {Name: "PresentationDuration", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of blocks to give each top candidate to present themselves after the vote ends."}}, {Name: "InactiveGracePeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "VoteIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x1, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of vote indices that need to go by after a target voter's last vote before they can", " be reaped if their approvals are moot."}}, {Name: "VotingPeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" How often (in blocks) to check for new votes."}}, {Name: "TermDuration", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" How long (in blocks) each position is active for."}}, {Name: "DesiredSeats", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of accounts that should be sitting on the council."}}, {Name: "ActiveCouncil", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<(T::AccountId, T::BlockNumber)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The current council. When there's a vote going on, this should still be used for executive", " matters. The block number is the block that the associated account ID's position is", " active until (calculated by the sum of the block number when the council member was", " elected and their term duration)."}}, {Name: "VoteCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "VoteIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The total number of votes that have happened or are in progress."}}, {Name: "ApprovalsOf", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "Vec<bool>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" A list of votes for each voter, respecting the last cleared vote index that this voter was", " last active at."}}, {Name: "RegisterInfoOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "(VoteIndex, u32)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The vote index and list slot in which the candidate account ID was registered or `None` if", " they are not currently registered."}}, {Name: "LastActiveOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "VoteIndex", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The last cleared vote index that this voter was last active at."}}, {Name: "Voters", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The present voter list."}}, {Name: "Candidates", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The present candidate list."}}, {Name: "CandidateCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of candidates."}}, {Name: "NextFinalize", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "(T::BlockNumber, u32, Vec<T::AccountId>)", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The accounts holding the seats that will become free on the next tally. Tuple of the block number", " at which the next tally will occur, the number of seats, and a list of the account IDs."}}, {Name: "SnapshotedStakes", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<BalanceOf<T>>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The stakes as they were at the point that the vote ended."}}, {Name: "Leaderboard", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<(BalanceOf<T>, T::AccountId)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Get the leaderboard if we're in the presentation phase."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set_approvals", Args: []FunctionArgumentMetadata{{Name: "votes", Type: "Vec<bool>"}, {Name: "index", Type: "Compact<VoteIndex>"}}, Documentation: []Text{" Set candidate approvals. Approval slots stay valid as long as candidates in those slots", " are registered."}}, {Name: "proxy_set_approvals", Args: []FunctionArgumentMetadata{{Name: "votes", Type: "Vec<bool>"}, {Name: "index", Type: "Compact<VoteIndex>"}}, Documentation: []Text{" Set candidate approvals from a proxy. Approval slots stay valid as long as candidates in those slots", " are registered."}}, {Name: "reap_inactive_voter", Args: []FunctionArgumentMetadata{{Name: "reporter_index", Type: "Compact<u32>"}, {Name: "who", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "who_index", Type: "Compact<u32>"}, {Name: "assumed_vote_index", Type: "Compact<VoteIndex>"}}, Documentation: []Text{" Remove a voter. For it not to be a bond-consuming no-op, all approved candidate indices", " must now be either unregistered or registered to a candidate that registered the slot after", " the voter gave their last approval set.", "", " May be called by anyone. Returns the voter deposit to `signed`."}}, {Name: "retract_voter", Args: []FunctionArgumentMetadata{{Name: "index", Type: "Compact<u32>"}}, Documentation: []Text{" Remove a voter. All votes are cancelled and the voter deposit is returned."}}, {Name: "submit_candidacy", Args: []FunctionArgumentMetadata{{Name: "slot", Type: "Compact<u32>"}}, Documentation: []Text{" Submit oneself for candidacy.", "", " Account must have enough transferrable funds in it to pay the bond."}}, {Name: "present_winner", Args: []FunctionArgumentMetadata{{Name: "candidate", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "total", Type: "Compact<BalanceOf<T>>"}, {Name: "index", Type: "Compact<VoteIndex>"}}, Documentation: []Text{" Present a candidate to be inserted into the leaderboard.", "", " The presenter (`origin`) must be slashable and will be slashed in the cases", " of an incorrect total or a duplicate presentation."}}, {Name: "set_desired_seats", Args: []FunctionArgumentMetadata{{Name: "count", Type: "Compact<u32>"}}, Documentation: []Text{" Set the desired member count; if less than or equal to the number of seats to be retained,", " then seats will not be up for election when they expire. If more, then a new vote will be", " started if one is not already in progress."}}, {Name: "remove_member", Args: []FunctionArgumentMetadata{{Name: "who", Type: "<T::Lookup as StaticLookup>::Source"}}, Documentation: []Text{" Remove a particular member. A tally will happen instantly (if not already in a presentation", " period) to fill the seat if removal means that the desired number of members is not met.", " This is effective immediately."}}, {Name: "set_presentation_duration", Args: []FunctionArgumentMetadata{{Name: "count", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Set the presentation duration (number of blocks)."}}, {Name: "set_term_duration", Args: []FunctionArgumentMetadata{{Name: "count", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Set the term duration (number of blocks)."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "VoterReaped", Args: []Type{"AccountId", "AccountId"}, Documentation: []Text{" A voter has been reaped. The tuple corresponds to the reaped voter and reaper, respectively."}}, {Name: "BadReaperSlashed", Args: []Type{"AccountId"}, Documentation: []Text{" A reaper has been slashed."}}, {Name: "TallyStarted", Args: []Type{"u32"}, Documentation: []Text{" A tally (for approval votes of council seat(s)) has started."}}, {Name: "TallyFinalized", Args: []Type{"Vec<AccountId>", "Vec<AccountId>"}, Documentation: []Text{" A tally (for approval votes of council seat(s)) has ended (with one or more new members)."}}}}, {Name: "council_voting", Prefix: "CouncilVoting", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "CooloffPeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Period (in blocks) that a veto is in effect."}}, {Name: "VotingPeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Period (in blocks) that a vote is open for."}}, {Name: "EnactDelayPeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of blocks by which to delay enactment of successful,", " non-unanimous, council-instigated referendum proposals."}}, {Name: "Proposals", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<(T::BlockNumber, T::Hash)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" A list of proposals by block number and proposal ID."}}, {Name: "ProposalOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "T::Proposal", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Map from proposal ID to the proposal."}}, {Name: "ProposalVoters", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "Vec<T::AccountId>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" List of voters that have voted on a proposal ID."}}, {Name: "CouncilVoteOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "(T::Hash, T::AccountId)", Value: "bool", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Map from a proposal ID and voter to the outcome of the vote. True indicates that it passed."}}, {Name: "VetoedProposal", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "(T::BlockNumber, Vec<T::AccountId>)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" A veto of a proposal. The veto has an expiry (block number) and a list of vetoers."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "propose", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}}, Documentation: []Text{" Make a proposal.", "", " A councillor vote of yay from `origin` is applied by default.", "", " The dispatch origin of this call must be signed by a _councillor_ by the time", " the proposal is subject to voting. See [`voting_period`](./voting/struct.VotingPeriod.html)."}}, {Name: "vote", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "T::Hash"}, {Name: "approve", Type: "bool"}}, Documentation: []Text{" Vote on a proposal.", "", " The dispatch origin of this call must be signed by a _councillor_."}}, {Name: "veto", Args: []FunctionArgumentMetadata{{Name: "proposal_hash", Type: "T::Hash"}}, Documentation: []Text{" Veto a proposal.", "", " A proposal cannot be vetoed while in the cooloff period.", " A proposal cannot be vetoed twice by the same account.", "", " The proposal information, including voters, is removed and only veto information is kept", " to indicate when the proposal can be re-proposed, and to make sure that no single councillor", " can veto it twice.", "", " The dispatch origin of this call must be signed by a _councillor_."}}, {Name: "set_cooloff_period", Args: []FunctionArgumentMetadata{{Name: "blocks", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Set the cooloff period."}}, {Name: "set_voting_period", Args: []FunctionArgumentMetadata{{Name: "blocks", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Set the voting period."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "TallyCancellation", Args: []Type{"Hash", "u32", "u32", "u32"}, Documentation: []Text{" A voting tally has happened for a referendum cancellation vote.", " Last three are yes, no, abstain counts."}}, {Name: "TallyReferendum", Args: []Type{"Hash", "u32", "u32", "u32"}, Documentation: []Text{" A voting tally has happened for a referendum vote.", " Last three are yes, no, abstain counts."}}}}, {Name: "council_motions", Prefix: "CouncilMotions", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "Proposals", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<T::Hash>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The (hashes of) the active proposals."}}, {Name: "ProposalOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "<T as Trait>::Proposal", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Actual proposal for a given hash, if it's current."}}, {Name: "Voting", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "(ProposalIndex, u32, Vec<T::AccountId>, Vec<T::AccountId>)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Votes for a given proposal: (Proposal index, required number of yes votes, yes voters, no voters)."}}, {Name: "ProposalCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Proposals so far."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "propose", Args: []FunctionArgumentMetadata{{Name: "threshold", Type: "Compact<u32>"}, {Name: "proposal", Type: "Box<<T as Trait>::Proposal>"}}, Documentation: []Text{" Make a proposal. `threshold` indicates the number of yes-votes needed for the proposal", " to execute.", "", " The proposal must be unique.", "", " The dispatch origin of this call must be signed by a _councillor_."}}, {Name: "vote", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "T::Hash"}, {Name: "index", Type: "Compact<ProposalIndex>"}, {Name: "approve", Type: "bool"}}, Documentation: []Text{" Vote on a proposal.", "", " The proposal hash and the index of the vote must be correctly provided.", " A voter can change their vote from yes to no, but duplicate votes will raise an error.", "", " Each submitted vote _may_ cause the proposal to be executed, if the required", " threshold is reached. Similarly, enough no-votes can cause the proposal to be", " removed from storage.", "", " The dispatch origin of this call must be signed by a _councillor_."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Proposed", Args: []Type{"AccountId", "ProposalIndex", "Hash", "u32"}, Documentation: []Text{" A motion (given hash) has been proposed (by given account) with a threshold (given `u32`)."}}, {Name: "Voted", Args: []Type{"AccountId", "Hash", "bool", "u32", "u32"}, Documentation: []Text{" A motion (given hash) has been voted on by given account, leaving", " a tally (yes votes and no votes given as `u32`s respectively)."}}, {Name: "Approved", Args: []Type{"Hash"}, Documentation: []Text{" A motion was approved by the required threshold."}}, {Name: "Disapproved", Args: []Type{"Hash"}, Documentation: []Text{" A motion was not approved by the required threshold."}}, {Name: "Executed", Args: []Type{"Hash", "bool"}, Documentation: []Text{" A motion was executed; `bool` is true if returned without error."}}}}, {Name: "finality_tracker", Prefix: "", HasStorage: false, Storage: []StorageFunctionMetadataV4(nil), HasCalls: true, Calls: []FunctionMetadataV4{{Name: "final_hint", Args: []FunctionArgumentMetadata{{Name: "hint", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Hint that the author of this block thinks the best finalized", " block is the given number."}}}, HasEvents: false, Events: []EventMetadataV4(nil)}, {Name: "grandpa", Prefix: "GrandpaFinality", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "PendingChange", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "StoredPendingChange<T::BlockNumber, T::SessionKey>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text(nil)}, {Name: "NextForced", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text(nil)}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "report_misbehavior", Args: []FunctionArgumentMetadata{{Name: "_report", Type: "Vec<u8>"}}, Documentation: []Text{" Report some misbehavior."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "NewAuthorities", Args: []Type{"Vec<(SessionKey, u64)>"}, Documentation: []Text{" New authority set has been applied."}}}}, {Name: "treasury", Prefix: "Treasury", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "ProposalBond", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Permill", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Proportion of funds that should be bonded in order to place a proposal. An accepted", " proposal gets these back. A rejected proposal doesn't."}}, {Name: "ProposalBondMinimum", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Minimum amount of funds that should be placed in a deposit for making a proposal."}}, {Name: "SpendPeriod", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Period between successive spends."}}, {Name: "Burn", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Permill", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Percentage of spare funds (if any) that are burnt per spend period."}}, {Name: "Pot", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Total funds available to this module for spending."}}, {Name: "ProposalCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "ProposalIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of proposals that have been made."}}, {Name: "Proposals", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "ProposalIndex", Value: "Proposal<T::AccountId, BalanceOf<T>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Proposals that have been made."}}, {Name: "Approvals", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Vec<ProposalIndex>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" Proposal indices that have been approved but not yet awarded."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "propose_spend", Args: []FunctionArgumentMetadata{{Name: "value", Type: "Compact<BalanceOf<T>>"}, {Name: "beneficiary", Type: "<T::Lookup as StaticLookup>::Source"}}, Documentation: []Text{" Put forward a suggestion for spending. A deposit proportional to the value", " is reserved and slashed if the proposal is rejected. It is returned once the", " proposal is awarded."}}, {Name: "set_pot", Args: []FunctionArgumentMetadata{{Name: "new_pot", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Set the balance of funds available to spend."}}, {Name: "configure", Args: []FunctionArgumentMetadata{{Name: "proposal_bond", Type: "Compact<Permill>"}, {Name: "proposal_bond_minimum", Type: "Compact<BalanceOf<T>>"}, {Name: "spend_period", Type: "Compact<T::BlockNumber>"}, {Name: "burn", Type: "Compact<Permill>"}}, Documentation: []Text{" (Re-)configure this module."}}, {Name: "reject_proposal", Args: []FunctionArgumentMetadata{{Name: "proposal_id", Type: "Compact<ProposalIndex>"}}, Documentation: []Text{" Reject a proposed spend. The original deposit will be slashed."}}, {Name: "approve_proposal", Args: []FunctionArgumentMetadata{{Name: "proposal_id", Type: "Compact<ProposalIndex>"}}, Documentation: []Text{" Approve a proposal. At a later time, the proposal will be allocated to the beneficiary", " and the original deposit will be returned."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Proposed", Args: []Type{"ProposalIndex"}, Documentation: []Text{" New proposal."}}, {Name: "Spending", Args: []Type{"Balance"}, Documentation: []Text{" We have ended a spend period and will now allocate funds."}}, {Name: "Awarded", Args: []Type{"ProposalIndex", "Balance", "AccountId"}, Documentation: []Text{" Some funds have been allocated."}}, {Name: "Burnt", Args: []Type{"Balance"}, Documentation: []Text{" Some of our funds have been burnt."}}, {Name: "Rollover", Args: []Type{"Balance"}, Documentation: []Text{" Spending has finished; this is the amount that rolls over until next spend."}}}}, {Name: "contract", Prefix: "Contract", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "TransferFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to make a transfer."}}, {Name: "CreationFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to create an account."}}, {Name: "TransactionBaseFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee to be paid for making a transaction; the base."}}, {Name: "TransactionByteFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee to be paid for making a transaction; the per-byte portion."}}, {Name: "ContractFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x15, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to create a contract instance."}}, {Name: "CallBaseFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Gas", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x87, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The base fee charged for calling into a contract."}}, {Name: "CreateBaseFee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Gas", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The base fee charged for creating a contract."}}, {Name: "GasPrice", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The price of one unit of gas."}}, {Name: "MaxDepth", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x64, 0x0, 0x0, 0x0}, Documentation: []Text{" The maximum nesting level of a call/create stack."}}, {Name: "BlockGasLimit", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Gas", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x80, 0x96, 0x98, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The maximum amount of gas that could be expended per block."}}, {Name: "GasSpent", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::Gas", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Gas spent so far in this block."}}, {Name: "CurrentSchedule", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "Schedule<T::Gas>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current cost schedule for contracts."}}, {Name: "CodeHashOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "CodeHash<T>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The code associated with a given account."}}, {Name: "PristineCode", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "CodeHash<T>", Value: "Vec<u8>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" A mapping from an original code hash to the original code, untouched by instrumentation."}}, {Name: "CodeStorage", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "CodeHash<T>", Value: "wasm::PrefabWasmModule", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" A mapping between an original code hash and instrumented wasm code, ready for the execution."}}, {Name: "AccountCounter", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "u64", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The subtrie counter"}}, {Name: "AccountInfoOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "AccountInfo", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0}, Documentation: []Text{" The code associated with a given account."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "update_schedule", Args: []FunctionArgumentMetadata{{Name: "schedule", Type: "Schedule<T::Gas>"}}, Documentation: []Text{" Updates the schedule for metering contracts.", "", " The schedule must have a greater version than the stored schedule."}}, {Name: "put_code", Args: []FunctionArgumentMetadata{{Name: "gas_limit", Type: "Compact<T::Gas>"}, {Name: "code", Type: "Vec<u8>"}}, Documentation: []Text{" Stores the given binary Wasm code into the chains storage and returns its `codehash`.", " You can instantiate contracts only with stored code."}}, {Name: "call", Args: []FunctionArgumentMetadata{{Name: "dest", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "value", Type: "Compact<BalanceOf<T>>"}, {Name: "gas_limit", Type: "Compact<T::Gas>"}, {Name: "data", Type: "Vec<u8>"}}, Documentation: []Text{" Makes a call to an account, optionally transferring some balance.", "", " * If the account is a smart-contract account, the associated code will be", " executed and any value will be transferred.", " * If the account is a regular account, any value will be transferred.", " * If no account exists and the call value is not less than `existential_deposit`,", " a regular account will be created and any value will be transferred."}}, {Name: "create", Args: []FunctionArgumentMetadata{{Name: "endowment", Type: "Compact<BalanceOf<T>>"}, {Name: "gas_limit", Type: "Compact<T::Gas>"}, {Name: "code_hash", Type: "CodeHash<T>"}, {Name: "data", Type: "Vec<u8>"}}, Documentation: []Text{" Creates a new contract from the `codehash` generated by `put_code`, optionally transferring some balance.", "", " Creation is executed as follows:", "", " - the destination address is computed based on the sender and hash of the code.", " - the smart-contract account is created at the computed address.", " - the `ctor_code` is executed in the context of the newly created account. Buffer returned", "   after the execution is saved as the `code` of the account. That code will be invoked", "   upon any call received by this account.", " - The contract is initialized."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Transfer", Args: []Type{"AccountId", "AccountId", "Balance"}, Documentation: []Text{" Transfer happened `from` to `to` with given `value` as part of a `call` or `create`."}}, {Name: "Instantiated", Args: []Type{"AccountId", "AccountId"}, Documentation: []Text{" Contract deployed by address at the specified address."}}, {Name: "CodeStored", Args: []Type{"Hash"}, Documentation: []Text{" Code with the specified hash has been stored."}}, {Name: "ScheduleUpdated", Args: []Type{"u32"}, Documentation: []Text{" Triggered when the current schedule is updated."}}, {Name: "Dispatched", Args: []Type{"AccountId", "bool"}, Documentation: []Text{" A call was dispatched from the given account. The bool signals whether it was", " successful execution or not."}}, {Name: "Contract", Args: []Type{"AccountId", "Vec<u8>"}, Documentation: []Text{" An event from contract of account."}}}}, {Name: "sudo", Prefix: "Sudo", HasStorage: true, Storage: []StorageFunctionMetadataV4{{Name: "Key", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV4{IsType: true, AsType: "T::AccountId", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: ""}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The `AccountId` of the sudo key."}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "sudo", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}}, Documentation: []Text{" Authenticates the sudo key and dispatches a function call with `Root` origin.", "", " The dispatch origin for this call must be _Signed_."}}, {Name: "set_key", Args: []FunctionArgumentMetadata{{Name: "new", Type: "<T::Lookup as StaticLookup>::Source"}}, Documentation: []Text{" Authenticates the current sudo key and sets the given AccountId (`new`) as the new sudo key.", "", " The dispatch origin for this call must be _Signed_."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Sudid", Args: []Type{"bool"}, Documentation: []Text{" A sudo just took place."}}, {Name: "KeyChanged", Args: []Type{"AccountId"}, Documentation: []Text{" The sudoer just switched identity; the old key is supplied."}}}}}}, IsMetadataV7: false, AsMetadataV7: MetadataV7{Modules: []ModuleMetadataV7(nil)}} //nolint:lll,dupl

var ExamplaryMetadataV4String = "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" //nolint:lll

var ExamplaryMetadataV8 = &Metadata{MagicNumber: 0x6174656d, Version: 0x8, IsMetadataV4: false, AsMetadataV4: MetadataV4{Modules: []ModuleMetadataV4(nil)}, IsMetadataV7: false, AsMetadataV7: MetadataV7{Modules: []ModuleMetadataV7(nil)}, IsMetadataV8: true, AsMetadataV8: MetadataV8{Modules: []ModuleMetadataV8{{Name: "System", HasStorage: true, Storage: StorageMetadata{Prefix: "System", Items: []StorageFunctionMetadataV5{{Name: "AccountNonce", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::Index", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Extrinsics nonce for accounts."}}, {Name: "ExtrinsicCount", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Total extrinsics count for the current block."}}, {Name: "AllExtrinsicsWeight", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Weight", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Total weight for all extrinsics put together, for the current block."}}, {Name: "AllExtrinsicsLen", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Total length (in bytes) for all extrinsics put together, for the current block."}}, {Name: "NextWeightMultiplier", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "WeightMultiplier", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The next weight multiplier. This should be updated at the end of each block based on the", " saturation level (weight)."}}, {Name: "BlockHash", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::BlockNumber", Value: "T::Hash", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Map of block numbers to block hashes."}}, {Name: "ExtrinsicData", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "u32", Value: "Vec<u8>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Extrinsics data for the current block (maps an extrinsic's index to its data)."}}, {Name: "Number", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The current block number being processed. Set by `execute_block`."}}, {Name: "ParentHash", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::Hash", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Hash of the previous block."}}, {Name: "ExtrinsicsRoot", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::Hash", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Extrinsics root of the current block, also part of the block header."}}, {Name: "Digest", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "DigestOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Digest of the current block, also part of the block header."}}, {Name: "Events", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<EventRecord<T::Event, T::Hash>>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Events deposited for the current block."}}, {Name: "EventCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "EventIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The number of events in the `Events<T>` list."}}, {Name: "EventTopics", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: true, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "()", Key2: "T::Hash", Value: "Vec<(T::BlockNumber, EventIndex)>", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Mapping between a topic (represented by T::Hash) and a vector of indexes", " of events in the `<Events<T>>` list.", "", " The first key serves no purpose. This field is declared as double_map just", " for convenience of using `remove_prefix`.", "", " All topic vectors have deterministic storage locations depending on the topic. This", " allows light-clients to leverage the changes trie storage tracking mechanism and", " in case of changes fetch the list of events of interest.", "", " The value has the type `(T::BlockNumber, EventIndex)` because if we used only just", " the `EventIndex` then in case if the topic has the same contents on the next block", " no notification will be triggered thus the event might be lost."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "fill_block", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" A big dispatch that will disallow any other transaction to be included."}}, {Name: "remark", Args: []FunctionArgumentMetadata{{Name: "_remark", Type: "Vec<u8>"}}, Documentation: []Text{" Make some on-chain remark."}}, {Name: "set_heap_pages", Args: []FunctionArgumentMetadata{{Name: "pages", Type: "u64"}}, Documentation: []Text{" Set the number of pages in the WebAssembly environment's heap."}}, {Name: "set_code", Args: []FunctionArgumentMetadata{{Name: "new", Type: "Vec<u8>"}}, Documentation: []Text{" Set the new code."}}, {Name: "set_storage", Args: []FunctionArgumentMetadata{{Name: "items", Type: "Vec<KeyValue>"}}, Documentation: []Text{" Set some items of storage."}}, {Name: "kill_storage", Args: []FunctionArgumentMetadata{{Name: "keys", Type: "Vec<Key>"}}, Documentation: []Text{" Kill some items from storage."}}, {Name: "kill_prefix", Args: []FunctionArgumentMetadata{{Name: "prefix", Type: "Key"}}, Documentation: []Text{" Kill all storage items with a key that starts with the given prefix."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "ExtrinsicSuccess", Args: []Type(nil), Documentation: []Text{" An extrinsic completed successfully."}}, {Name: "ExtrinsicFailed", Args: []Type{"DispatchError"}, Documentation: []Text{" An extrinsic failed."}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8{{Name: "BadSignature", Documentation: []Text(nil)}, {Name: "BlockFull", Documentation: []Text(nil)}, {Name: "RequireSignedOrigin", Documentation: []Text(nil)}, {Name: "RequireRootOrigin", Documentation: []Text(nil)}, {Name: "RequireNoOrigin", Documentation: []Text(nil)}}}, {Name: "Utility", HasStorage: false, Storage: StorageMetadata{Prefix: "", Items: []StorageFunctionMetadataV5(nil)}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "batch", Args: []FunctionArgumentMetadata{{Name: "calls", Type: "Vec<<T as Trait>::Call>"}}, Documentation: []Text{" Send a batch of dispatch calls (only root)."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "BatchExecuted", Args: []Type{"Vec<Result<(), DispatchError>>"}, Documentation: []Text(nil)}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "Babe", HasStorage: true, Storage: StorageMetadata{Prefix: "Babe", Items: []StorageFunctionMetadataV5{{Name: "EpochIndex", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u64", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current epoch index."}}, {Name: "Authorities", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<(AuthorityId, BabeAuthorityWeight)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Current epoch authorities."}}, {Name: "GenesisSlot", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u64", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The slot at which the first epoch actually started. This is 0", " until the first block of the chain."}}, {Name: "CurrentSlot", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u64", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current slot number."}}, {Name: "Randomness", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "[u8; 32]", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The epoch randomness for the *current* epoch.", "", " # Security", "", " This MUST NOT be used for gambling, as it can be influenced by a", " malicious validator in the short term. It MAY be used in many", " cryptographic protocols, however, so long as one remembers that this", " (like everything else on-chain) it is public. For example, it can be", " used where a number is needed that cannot have been chosen by an", " adversary, for purposes such as public-coin zero-knowledge proofs."}}, {Name: "NextRandomness", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "[u8; 32]", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Next epoch randomness."}}, {Name: "SegmentIndex", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Randomness under construction.", "", " We make a tradeoff between storage accesses and list length.", " We store the under-construction randomness in segments of up to", " `UNDER_CONSTRUCTION_SEGMENT_LENGTH`.", "", " Once a segment reaches this length, we begin the next one.", " We reset all segments and return to `0` at the beginning of every", " epoch."}}, {Name: "UnderConstruction", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "u32", Value: "Vec<[u8; 32]>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text(nil)}, {Name: "Initialized", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "MaybeVrf", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Temporary value (cleared at block finalization) which is `Some`", " if per-block initialization has already been called for current block."}}}}, HasCalls: true, Calls: []FunctionMetadataV4(nil), HasEvents: false, Events: []EventMetadataV4(nil), Constants: []ModuleConstantMetadataV6{{Name: "EpochDuration", Type: "u64", Value: Bytes{0xc8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The number of **slots** that an epoch takes. We couple sessions to", " epochs, i.e. we start a new session once the new epoch begins."}}, {Name: "ExpectedBlockTime", Type: "T::Moment", Value: Bytes{0xb8, 0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The expected average block time at which BABE should be creating", " blocks. Since BABE is probabilistic it is not trivial to figure out", " what the expected average block time should be based on the slot", " duration and the security parameter `c` (where `1 - c` represents", " the probability of a slot being empty)."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Timestamp", HasStorage: true, Storage: StorageMetadata{Prefix: "Timestamp", Items: []StorageFunctionMetadataV5{{Name: "Now", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::Moment", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current time for the current block."}}, {Name: "DidUpdate", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "bool", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Did the timestamp get updated in this block?"}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set", Args: []FunctionArgumentMetadata{{Name: "now", Type: "Compact<T::Moment>"}}, Documentation: []Text{" Set the current time.", "", " This call should be invoked exactly once per block. It will panic at the finalization", " phase, if this call hasn't been invoked by that time.", "", " The timestamp should be greater than the previous one by the amount specified by", " `MinimumPeriod`.", "", " The dispatch origin for this call must be `Inherent`."}}}, HasEvents: false, Events: []EventMetadataV4(nil), Constants: []ModuleConstantMetadataV6{{Name: "MinimumPeriod", Type: "T::Moment", Value: Bytes{0xdc, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The minimum period between blocks. Beware that this is different to the *expected* period", " that the block production apparatus provides. Your chosen consensus system will generally", " work with this to determine a sensible block time. e.g. For Aura, it will be double this", " period on default settings."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Authorship", HasStorage: true, Storage: StorageMetadata{Prefix: "Authorship", Items: []StorageFunctionMetadataV5{{Name: "Uncles", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<UncleEntryItem<T::BlockNumber, T::Hash, T::AccountId>>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Uncles"}}, {Name: "Author", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::AccountId", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Author of current block."}}, {Name: "DidSetUncles", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "bool", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Whether uncles were already set in this block."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set_uncles", Args: []FunctionArgumentMetadata{{Name: "new_uncles", Type: "Vec<T::Header>"}}, Documentation: []Text{" Provide a set of uncles."}}}, HasEvents: false, Events: []EventMetadataV4(nil), Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "Indices", HasStorage: true, Storage: StorageMetadata{Prefix: "Indices", Items: []StorageFunctionMetadataV5{{Name: "NextEnumSet", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::AccountIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The next free enumeration set."}}, {Name: "EnumSet", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountIndex", Value: "Vec<T::AccountId>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The enumeration sets."}}}}, HasCalls: true, Calls: []FunctionMetadataV4(nil), HasEvents: true, Events: []EventMetadataV4{{Name: "NewAccountIndex", Args: []Type{"AccountId", "AccountIndex"}, Documentation: []Text{" A new account index was assigned.", "", " This event is not triggered when an existing index is reassigned", " to another `AccountId`."}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "Balances", HasStorage: true, Storage: StorageMetadata{Prefix: "Balances", Items: []StorageFunctionMetadataV5{{Name: "TotalIssuance", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::Balance", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The total units issued in the system."}}, {Name: "Vesting", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "VestingSchedule<T::Balance, T::BlockNumber>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Information regarding the vesting of a given account."}}, {Name: "FreeBalance", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::Balance", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The 'free' balance of a given account.", "", " This is the only balance that matters in terms of most operations on tokens. It", " alone is used to determine the balance when in the contract execution environment. When this", " balance falls below the value of `ExistentialDeposit`, then the 'current account' is", " deleted: specifically `FreeBalance`. Further, the `OnFreeBalanceZero` callback", " is invoked, giving a chance to external modules to clean up data associated with", " the deleted account.", "", " `system::AccountNonce` is also deleted if `ReservedBalance` is also zero (it also gets", " collapsed to zero if it ever becomes less than `ExistentialDeposit`."}}, {Name: "ReservedBalance", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::Balance", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The amount of the balance of a given account that is externally reserved; this can still get", " slashed, but gets slashed last of all.", "", " This balance is a 'reserve' balance that other subsystems use in order to set aside tokens", " that are still 'owned' by the account holder, but which are suspendable.", "", " When this balance falls below the value of `ExistentialDeposit`, then this 'reserve account'", " is deleted: specifically, `ReservedBalance`.", "", " `system::AccountNonce` is also deleted if `FreeBalance` is also zero (it also gets", " collapsed to zero if it ever becomes less than `ExistentialDeposit`.)"}}, {Name: "Locks", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "Vec<BalanceLock<T::Balance, T::BlockNumber>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Any liquidity locks on some account balances."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "transfer", Args: []FunctionArgumentMetadata{{Name: "dest", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "value", Type: "Compact<T::Balance>"}}, Documentation: []Text{" Transfer some liquid free balance to another account.", "", " `transfer` will set the `FreeBalance` of the sender and receiver.", " It will decrease the total issuance of the system by the `TransferFee`.", " If the sender's account is below the existential deposit as a result", " of the transfer, the account will be reaped.", "", " The dispatch origin for this call must be `Signed` by the transactor.", "", " # <weight>", " - Dependent on arguments but not critical, given proper implementations for", "   input config  See related functions below.", " - It contains a limited number of reads and writes internally and no complex computation.", "", " Related functions:", "", "   - `ensure_can_withdraw` is always called internally but has a bounded complexity.", "   - Transferring balances to accounts that did not exist before will cause", "      `T::OnNewAccount::on_new_account` to be called.", "   - Removing enough funds from an account will trigger", "     `T::DustRemoval::on_unbalanced` and `T::OnFreeBalanceZero::on_free_balance_zero`.", "", " # </weight>"}}, {Name: "set_balance", Args: []FunctionArgumentMetadata{{Name: "who", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "new_free", Type: "Compact<T::Balance>"}, {Name: "new_reserved", Type: "Compact<T::Balance>"}}, Documentation: []Text{" Set the balances of a given account.", "", " This will alter `FreeBalance` and `ReservedBalance` in storage. it will", " also decrease the total issuance of the system (`TotalIssuance`).", " If the new free or reserved balance is below the existential deposit,", " it will reset the account nonce (`system::AccountNonce`).", "", " The dispatch origin for this call is `root`.", "", " # <weight>", " - Independent of the arguments.", " - Contains a limited number of reads and writes.", " # </weight>"}}, {Name: "force_transfer", Args: []FunctionArgumentMetadata{{Name: "source", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "dest", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "value", Type: "Compact<T::Balance>"}}, Documentation: []Text{" Exactly as `transfer`, except the origin must be root and the source account may be", " specified."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "NewAccount", Args: []Type{"AccountId", "Balance"}, Documentation: []Text{" A new account was created."}}, {Name: "ReapedAccount", Args: []Type{"AccountId"}, Documentation: []Text{" An account was reaped."}}, {Name: "Transfer", Args: []Type{"AccountId", "AccountId", "Balance", "Balance"}, Documentation: []Text{" Transfer succeeded (from, to, value, fees)."}}}, Constants: []ModuleConstantMetadataV6{{Name: "ExistentialDeposit", Type: "T::Balance", Value: Bytes{0x0, 0x40, 0x7a, 0x10, 0xf3, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The minimum amount required to keep an account open."}}, {Name: "TransferFee", Type: "T::Balance", Value: Bytes{0x0, 0x10, 0xa5, 0xd4, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to make a transfer."}}, {Name: "CreationFee", Type: "T::Balance", Value: Bytes{0x0, 0x10, 0xa5, 0xd4, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to create an account."}}, {Name: "TransactionBaseFee", Type: "T::Balance", Value: Bytes{0x0, 0x10, 0xa5, 0xd4, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee to be paid for making a transaction; the base."}}, {Name: "TransactionByteFee", Type: "T::Balance", Value: Bytes{0x0, 0xe4, 0xb, 0x54, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee to be paid for making a transaction; the per-byte portion."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Staking", HasStorage: true, Storage: StorageMetadata{Prefix: "Staking", Items: []StorageFunctionMetadataV5{{Name: "ValidatorCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The ideal number of staking participants."}}, {Name: "MinimumValidatorCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x4, 0x0, 0x0, 0x0}, Documentation: []Text{" Minimum number of staking participants before emergency conditions are imposed."}}, {Name: "Invulnerables", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Any validators that may never be slashed or forcibly kicked. It's a Vec since they're", " easy to initialize and the performance hit is minimal (we expect no more than four", " invulnerables) and restricted to testnets."}}, {Name: "Bonded", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::AccountId", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Map from all locked \"stash\" accounts to the controller account."}}, {Name: "Ledger", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "StakingLedger<T::AccountId, BalanceOf<T>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Map from all (unlocked) \"controller\" accounts to the info regarding the staking."}}, {Name: "Payee", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "RewardDestination", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Where the reward payment should be made. Keyed by stash."}}, {Name: "Validators", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "ValidatorPrefs<BalanceOf<T>>", Linked: true}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The map from (wannabe) validator stash key to the preferences of that validator."}}, {Name: "Nominators", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "Vec<T::AccountId>", Linked: true}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The map from nominator stash key to the set of stash keys of all validators to nominate."}}, {Name: "Stakers", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "Exposure<T::AccountId, BalanceOf<T>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0}, Documentation: []Text{" Nominators for a particular account that is in action right now. You can't iterate", " through validators here, but you can find them in the Session module.", "", " This is keyed by the stash account."}}, {Name: "CurrentElected", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The currently elected validator set keyed by stash account ID."}}, {Name: "CurrentEra", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "EraIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The current era index."}}, {Name: "CurrentEraStart", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "MomentOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The start of the current era."}}, {Name: "CurrentEraStartSessionIndex", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "SessionIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The session index at which the current era started."}}, {Name: "CurrentEraPointsEarned", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "EraPoints", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Rewards for the current era. Using indices of current elected set."}}, {Name: "SlotStake", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The amount of balance actively at stake for each validator slot, currently.", "", " This is used to derive rewards and punishments."}}, {Name: "ForceEra", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Forcing", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" True if the next session change will be a new era regardless of index."}}, {Name: "SlashRewardFraction", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Perbill", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The percentage of the slash that is distributed to reporters.", "", " The rest of the slashed value is handled by the `Slash`."}}, {Name: "BondedEras", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<(EraIndex, SessionIndex)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" A mapping from still-bonded eras to the first session index of that era."}}, {Name: "EraSlashJournal", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "EraIndex", Value: "Vec<SlashJournalEntry<T::AccountId, BalanceOf<T>>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" All slashes that have occurred in a given era."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "bond", Args: []FunctionArgumentMetadata{{Name: "controller", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "value", Type: "Compact<BalanceOf<T>>"}, {Name: "payee", Type: "RewardDestination"}}, Documentation: []Text{" Take the origin account as a stash and lock up `value` of its balance. `controller` will", " be the account that controls it.", "", " `value` must be more than the `minimum_balance` specified by `T::Currency`.", "", " The dispatch origin for this call must be _Signed_ by the stash account.", "", " # <weight>", " - Independent of the arguments. Moderate complexity.", " - O(1).", " - Three extra DB entries.", "", " NOTE: Two of the storage writes (`Self::bonded`, `Self::payee`) are _never_ cleaned unless", " the `origin` falls below _existential deposit_ and gets removed as dust.", " # </weight>"}}, {Name: "bond_extra", Args: []FunctionArgumentMetadata{{Name: "max_additional", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Add some extra amount that have appeared in the stash `free_balance` into the balance up", " for staking.", "", " Use this if there are additional funds in your stash account that you wish to bond.", " Unlike [`bond`] or [`unbond`] this function does not impose any limitation on the amount", " that can be added.", "", " The dispatch origin for this call must be _Signed_ by the stash, not the controller.", "", " # <weight>", " - Independent of the arguments. Insignificant complexity.", " - O(1).", " - One DB entry.", " # </weight>"}}, {Name: "unbond", Args: []FunctionArgumentMetadata{{Name: "value", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Schedule a portion of the stash to be unlocked ready for transfer out after the bond", " period ends. If this leaves an amount actively bonded less than", " T::Currency::minimum_balance(), then it is increased to the full amount.", "", " Once the unlock period is done, you can call `withdraw_unbonded` to actually move", " the funds out of management ready for transfer.", "", " No more than a limited number of unlocking chunks (see `MAX_UNLOCKING_CHUNKS`)", " can co-exists at the same time. In that case, [`Call::withdraw_unbonded`] need", " to be called first to remove some of the chunks (if possible).", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash.", "", " See also [`Call::withdraw_unbonded`].", "", " # <weight>", " - Independent of the arguments. Limited but potentially exploitable complexity.", " - Contains a limited number of reads.", " - Each call (requires the remainder of the bonded balance to be above `minimum_balance`)", "   will cause a new entry to be inserted into a vector (`Ledger.unlocking`) kept in storage.", "   The only way to clean the aforementioned storage item is also user-controlled via `withdraw_unbonded`.", " - One DB entry.", " </weight>"}}, {Name: "withdraw_unbonded", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Remove any unlocked chunks from the `unlocking` queue from our management.", "", " This essentially frees up that balance to be used by the stash account to do", " whatever it wants.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash.", "", " See also [`Call::unbond`].", "", " # <weight>", " - Could be dependent on the `origin` argument and how much `unlocking` chunks exist.", "  It implies `consolidate_unlocked` which loops over `Ledger.unlocking`, which is", "  indirectly user-controlled. See [`unbond`] for more detail.", " - Contains a limited number of reads, yet the size of which could be large based on `ledger`.", " - Writes are limited to the `origin` account key.", " # </weight>"}}, {Name: "validate", Args: []FunctionArgumentMetadata{{Name: "prefs", Type: "ValidatorPrefs<BalanceOf<T>>"}}, Documentation: []Text{" Declare the desire to validate for the origin controller.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash.", "", " # <weight>", " - Independent of the arguments. Insignificant complexity.", " - Contains a limited number of reads.", " - Writes are limited to the `origin` account key.", " # </weight>"}}, {Name: "nominate", Args: []FunctionArgumentMetadata{{Name: "targets", Type: "Vec<<T::Lookup as StaticLookup>::Source>"}}, Documentation: []Text{" Declare the desire to nominate `targets` for the origin controller.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash.", "", " # <weight>", " - The transaction's complexity is proportional to the size of `targets`,", " which is capped at `MAX_NOMINATIONS`.", " - Both the reads and writes follow a similar pattern.", " # </weight>"}}, {Name: "chill", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Declare no desire to either validate or nominate.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash.", "", " # <weight>", " - Independent of the arguments. Insignificant complexity.", " - Contains one read.", " - Writes are limited to the `origin` account key.", " # </weight>"}}, {Name: "set_payee", Args: []FunctionArgumentMetadata{{Name: "payee", Type: "RewardDestination"}}, Documentation: []Text{" (Re-)set the payment target for a controller.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the controller, not the stash.", "", " # <weight>", " - Independent of the arguments. Insignificant complexity.", " - Contains a limited number of reads.", " - Writes are limited to the `origin` account key.", " # </weight>"}}, {Name: "set_controller", Args: []FunctionArgumentMetadata{{Name: "controller", Type: "<T::Lookup as StaticLookup>::Source"}}, Documentation: []Text{" (Re-)set the controller of a stash.", "", " Effects will be felt at the beginning of the next era.", "", " The dispatch origin for this call must be _Signed_ by the stash, not the controller.", "", " # <weight>", " - Independent of the arguments. Insignificant complexity.", " - Contains a limited number of reads.", " - Writes are limited to the `origin` account key.", " # </weight>"}}, {Name: "set_validator_count", Args: []FunctionArgumentMetadata{{Name: "new", Type: "Compact<u32>"}}, Documentation: []Text{" The ideal number of validators."}}, {Name: "force_no_eras", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Force there to be no new eras indefinitely.", "", " # <weight>", " - No arguments.", " # </weight>"}}, {Name: "force_new_era", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Force there to be a new era at the end of the next session. After this, it will be", " reset to normal (non-forced) behaviour.", "", " # <weight>", " - No arguments.", " # </weight>"}}, {Name: "set_invulnerables", Args: []FunctionArgumentMetadata{{Name: "validators", Type: "Vec<T::AccountId>"}}, Documentation: []Text{" Set the validators who cannot be slashed (if any)."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Reward", Args: []Type{"Balance"}, Documentation: []Text{" All validators have been rewarded by the given balance."}}, {Name: "Slash", Args: []Type{"AccountId", "Balance"}, Documentation: []Text{" One validator (and its nominators) has been slashed by the given amount."}}, {Name: "OldSlashingReportDiscarded", Args: []Type{"SessionIndex"}, Documentation: []Text{" An old slashing report from a prior era was discarded because it could", " not be processed."}}}, Constants: []ModuleConstantMetadataV6{{Name: "SessionsPerEra", Type: "SessionIndex", Value: Bytes{0x6, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of sessions per era."}}, {Name: "BondingDuration", Type: "EraIndex", Value: Bytes{0xa0, 0x2, 0x0, 0x0}, Documentation: []Text{" Number of eras that staked funds must remain bonded for."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Session", HasStorage: true, Storage: StorageMetadata{Prefix: "Session", Items: []StorageFunctionMetadataV5{{Name: "Validators", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::ValidatorId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The current set of validators."}}, {Name: "CurrentIndex", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "SessionIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current index of the session."}}, {Name: "QueuedChanged", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "bool", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" True if the underlying economic identities or weighting behind the validators", " has changed in the queued validator set."}}, {Name: "QueuedKeys", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<(T::ValidatorId, T::Keys)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The queued keys for the next session. When the next session begins, these keys", " will be used to determine the validator's session keys."}}, {Name: "DisabledValidators", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<u32>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Indices of disabled validators.", "", " The set is cleared when `on_session_ending` returns a new set of identities."}}, {Name: "NextKeys", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: true, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: true}, Key1: "Vec<u8>", Key2: "T::ValidatorId", Value: "T::Keys", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The next session keys for a validator.", "", " The first key is always `DEDUP_KEY_PREFIX` to have all the data in the same branch of", " the trie. Having all data in the same branch should prevent slowing down other queries."}}, {Name: "KeyOwner", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: true, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: true}, Key1: "Vec<u8>", Key2: "(KeyTypeId, Vec<u8>)", Value: "T::ValidatorId", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The owner of a key. The second key is the `KeyTypeId` + the encoded key.", "", " The first key is always `DEDUP_KEY_PREFIX` to have all the data in the same branch of", " the trie. Having all data in the same branch should prevent slowing down other queries."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set_keys", Args: []FunctionArgumentMetadata{{Name: "keys", Type: "T::Keys"}, {Name: "proof", Type: "Vec<u8>"}}, Documentation: []Text{" Sets the session key(s) of the function caller to `key`.", " Allows an account to set its session key prior to becoming a validator.", " This doesn't take effect until the next session.", "", " The dispatch origin of this function must be signed.", "", " # <weight>", " - O(log n) in number of accounts.", " - One extra DB entry.", " # </weight>"}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "NewSession", Args: []Type{"SessionIndex"}, Documentation: []Text{" New session has happened. Note that the argument is the session index, not the block", " number as the type might suggest."}}}, Constants: []ModuleConstantMetadataV6{{Name: "DEDUP_KEY_PREFIX", Type: "&[u8]", Value: Bytes{0x34, 0x3a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x6b, 0x65, 0x79, 0x73}, Documentation: []Text{" Used as first key for `NextKeys` and `KeyOwner` to put all the data into the same branch", " of the trie."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Democracy", HasStorage: true, Storage: StorageMetadata{Prefix: "Democracy", Items: []StorageFunctionMetadataV5{{Name: "PublicPropCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "PropIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The number of (public) proposals that have been made so far."}}, {Name: "PublicProps", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<(PropIndex, T::Proposal, T::AccountId)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The public proposals. Unsorted."}}, {Name: "DepositOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "PropIndex", Value: "(BalanceOf<T>, Vec<T::AccountId>)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Those who have locked a deposit."}}, {Name: "ReferendumCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "ReferendumIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The next free referendum index, aka the number of referenda started so far."}}, {Name: "NextTally", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "ReferendumIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The next referendum index that should be tallied."}}, {Name: "ReferendumInfoOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "ReferendumIndex", Value: "(ReferendumInfo<T::BlockNumber, T::Proposal>)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Information concerning any given referendum."}}, {Name: "DispatchQueue", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::BlockNumber", Value: "Vec<Option<(T::Proposal, ReferendumIndex)>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Queue of successful referenda to be dispatched."}}, {Name: "VotersFor", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "ReferendumIndex", Value: "Vec<T::AccountId>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Get the voters for the current proposal."}}, {Name: "VoteOf", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "(ReferendumIndex, T::AccountId)", Value: "Vote", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Get the vote in a given referendum of a particular voter. The result is meaningful only", " if `voters_for` includes the voter when called with the referendum (you'll get the", " default `Vote` value otherwise). If you don't want to check `voters_for`, then you can", " also check for simple existence with `VoteOf::exists` first."}}, {Name: "Proxy", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::AccountId", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Who is able to vote for whom. Value is the fund-holding account, key is the", " vote-transaction-sending account."}}, {Name: "Delegations", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "(T::AccountId, Conviction)", Linked: true}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Get the account (and lock periods) to which another account is delegating vote."}}, {Name: "LastTabledWasExternal", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "bool", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" True if the last referendum tabled was submitted externally. False if it was a public", " proposal."}}, {Name: "NextExternal", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "(T::Proposal, VoteThreshold)", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The referendum to be tabled whenever it would be valid to table an external proposal.", " This happens when a referendum needs to be tabled and one of two conditions are met:", " - `LastTabledWasExternal` is `false`; or", " - `PublicProps` is empty."}}, {Name: "Blacklist", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "(T::BlockNumber, Vec<T::AccountId>)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" A record of who vetoed what. Maps proposal hash to a possible existent block number", " (until when it may not be resubmitted) and who vetoed it."}}, {Name: "Cancellations", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "bool", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Record of all proposals that have been subject to emergency cancellation."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "propose", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}, {Name: "value", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Propose a sensitive action to be taken.", "", " # <weight>", " - O(1).", " - Two DB changes, one DB entry.", " # </weight>"}}, {Name: "second", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Compact<PropIndex>"}}, Documentation: []Text{" Propose a sensitive action to be taken.", "", " # <weight>", " - O(1).", " - One DB entry.", " # </weight>"}}, {Name: "vote", Args: []FunctionArgumentMetadata{{Name: "ref_index", Type: "Compact<ReferendumIndex>"}, {Name: "vote", Type: "Vote"}}, Documentation: []Text{" Vote in a referendum. If `vote.is_aye()`, the vote is to enact the proposal;", " otherwise it is a vote to keep the status quo.", "", " # <weight>", " - O(1).", " - One DB change, one DB entry.", " # </weight>"}}, {Name: "proxy_vote", Args: []FunctionArgumentMetadata{{Name: "ref_index", Type: "Compact<ReferendumIndex>"}, {Name: "vote", Type: "Vote"}}, Documentation: []Text{" Vote in a referendum on behalf of a stash. If `vote.is_aye()`, the vote is to enact", " the proposal;  otherwise it is a vote to keep the status quo.", "", " # <weight>", " - O(1).", " - One DB change, one DB entry.", " # </weight>"}}, {Name: "emergency_cancel", Args: []FunctionArgumentMetadata{{Name: "ref_index", Type: "ReferendumIndex"}}, Documentation: []Text{" Schedule an emergency cancellation of a referendum. Cannot happen twice to the same", " referendum."}}, {Name: "external_propose", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}}, Documentation: []Text{" Schedule a referendum to be tabled once it is legal to schedule an external", " referendum."}}, {Name: "external_propose_majority", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}}, Documentation: []Text{" Schedule a majority-carries referendum to be tabled next once it is legal to schedule", " an external referendum.", "", " Unlike `external_propose`, blacklisting has no effect on this and it may replace a", " pre-scheduled `external_propose` call."}}, {Name: "external_propose_default", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}}, Documentation: []Text{" Schedule a negative-turnout-bias referendum to be tabled next once it is legal to", " schedule an external referendum.", "", " Unlike `external_propose`, blacklisting has no effect on this and it may replace a", " pre-scheduled `external_propose` call."}}, {Name: "fast_track", Args: []FunctionArgumentMetadata{{Name: "proposal_hash", Type: "T::Hash"}, {Name: "voting_period", Type: "T::BlockNumber"}, {Name: "delay", Type: "T::BlockNumber"}}, Documentation: []Text{" Schedule the currently externally-proposed majority-carries referendum to be tabled", " immediately. If there is no externally-proposed referendum currently, or if there is one", " but it is not a majority-carries referendum then it fails.", "", " - `proposal_hash`: The hash of the current external proposal.", " - `voting_period`: The period that is allowed for voting on this proposal.", " - `delay`: The number of block after voting has ended in approval and this should be", "   enacted. Increased to `EmergencyVotingPeriod` if too low."}}, {Name: "veto_external", Args: []FunctionArgumentMetadata{{Name: "proposal_hash", Type: "T::Hash"}}, Documentation: []Text{" Veto and blacklist the external proposal hash."}}, {Name: "cancel_referendum", Args: []FunctionArgumentMetadata{{Name: "ref_index", Type: "Compact<ReferendumIndex>"}}, Documentation: []Text{" Remove a referendum."}}, {Name: "cancel_queued", Args: []FunctionArgumentMetadata{{Name: "when", Type: "Compact<T::BlockNumber>"}, {Name: "which", Type: "Compact<u32>"}, {Name: "what", Type: "Compact<ReferendumIndex>"}}, Documentation: []Text{" Cancel a proposal queued for enactment."}}, {Name: "set_proxy", Args: []FunctionArgumentMetadata{{Name: "proxy", Type: "T::AccountId"}}, Documentation: []Text{" Specify a proxy. Called by the stash.", "", " # <weight>", " - One extra DB entry.", " # </weight>"}}, {Name: "resign_proxy", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Clear the proxy. Called by the proxy.", "", " # <weight>", " - One DB clear.", " # </weight>"}}, {Name: "remove_proxy", Args: []FunctionArgumentMetadata{{Name: "proxy", Type: "T::AccountId"}}, Documentation: []Text{" Clear the proxy. Called by the stash.", "", " # <weight>", " - One DB clear.", " # </weight>"}}, {Name: "delegate", Args: []FunctionArgumentMetadata{{Name: "to", Type: "T::AccountId"}, {Name: "conviction", Type: "Conviction"}}, Documentation: []Text{" Delegate vote.", "", " # <weight>", " - One extra DB entry.", " # </weight>"}}, {Name: "undelegate", Args: []FunctionArgumentMetadata(nil), Documentation: []Text{" Undelegate vote.", "", " # <weight>", " - O(1).", " # </weight>"}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Proposed", Args: []Type{"PropIndex", "Balance"}, Documentation: []Text(nil)}, {Name: "Tabled", Args: []Type{"PropIndex", "Balance", "Vec<AccountId>"}, Documentation: []Text(nil)}, {Name: "ExternalTabled", Args: []Type(nil), Documentation: []Text(nil)}, {Name: "Started", Args: []Type{"ReferendumIndex", "VoteThreshold"}, Documentation: []Text(nil)}, {Name: "Passed", Args: []Type{"ReferendumIndex"}, Documentation: []Text(nil)}, {Name: "NotPassed", Args: []Type{"ReferendumIndex"}, Documentation: []Text(nil)}, {Name: "Cancelled", Args: []Type{"ReferendumIndex"}, Documentation: []Text(nil)}, {Name: "Executed", Args: []Type{"ReferendumIndex", "bool"}, Documentation: []Text(nil)}, {Name: "Delegated", Args: []Type{"AccountId", "AccountId"}, Documentation: []Text(nil)}, {Name: "Undelegated", Args: []Type{"AccountId"}, Documentation: []Text(nil)}, {Name: "Vetoed", Args: []Type{"AccountId", "Hash", "BlockNumber"}, Documentation: []Text(nil)}}, Constants: []ModuleConstantMetadataV6{{Name: "EnactmentPeriod", Type: "T::BlockNumber", Value: Bytes{0x0, 0x2f, 0xd, 0x0}, Documentation: []Text{" The minimum period of locking and the period between a proposal being approved and enacted.", "", " It should generally be a little more than the unstake period to ensure that", " voting stakers have an opportunity to remove themselves from the system in the case where", " they are on the losing side of a vote."}}, {Name: "LaunchPeriod", Type: "T::BlockNumber", Value: Bytes{0x0, 0x4e, 0xc, 0x0}, Documentation: []Text{" How often (in blocks) new public referenda are launched."}}, {Name: "VotingPeriod", Type: "T::BlockNumber", Value: Bytes{0x0, 0x4e, 0xc, 0x0}, Documentation: []Text{" How often (in blocks) to check for new votes."}}, {Name: "MinimumDeposit", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x0, 0xc1, 0x6f, 0xf2, 0x86, 0x23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The minimum amount to be used as a deposit for a public referendum proposal."}}, {Name: "EmergencyVotingPeriod", Type: "T::BlockNumber", Value: Bytes{0x80, 0x51, 0x1, 0x0}, Documentation: []Text{" Minimum voting period allowed for an emergency referendum."}}, {Name: "CooloffPeriod", Type: "T::BlockNumber", Value: Bytes{0x0, 0x4e, 0xc, 0x0}, Documentation: []Text{" Period in blocks where an external proposal may not be re-submitted after being vetoed."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Council", HasStorage: true, Storage: StorageMetadata{Prefix: "Instance1Collective", Items: []StorageFunctionMetadataV5{{Name: "Proposals", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::Hash>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The hashes of the active proposals."}}, {Name: "ProposalOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "<T as Trait<I>>::Proposal", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Actual proposal for a given hash, if it's current."}}, {Name: "Voting", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "Votes<T::AccountId>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Votes on a given proposal, if it is ongoing."}}, {Name: "ProposalCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Proposals so far."}}, {Name: "Members", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The current members of the collective. This is stored sorted (just by value)."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set_members", Args: []FunctionArgumentMetadata{{Name: "new_members", Type: "Vec<T::AccountId>"}}, Documentation: []Text{" Set the collective's membership manually to `new_members`. Be nice to the chain and", " provide it pre-sorted.", "", " Requires root origin."}}, {Name: "execute", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<<T as Trait<I>>::Proposal>"}}, Documentation: []Text{" Dispatch a proposal from a member using the `Member` origin.", "", " Origin must be a member of the collective."}}, {Name: "propose", Args: []FunctionArgumentMetadata{{Name: "threshold", Type: "Compact<MemberCount>"}, {Name: "proposal", Type: "Box<<T as Trait<I>>::Proposal>"}}, Documentation: []Text{" # <weight>", " - Bounded storage reads and writes.", " - Argument `threshold` has bearing on weight.", " # </weight>"}}, {Name: "vote", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "T::Hash"}, {Name: "index", Type: "Compact<ProposalIndex>"}, {Name: "approve", Type: "bool"}}, Documentation: []Text{" # <weight>", " - Bounded storage read and writes.", " - Will be slightly heavier if the proposal is approved / disapproved after the vote.", " # </weight>"}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Proposed", Args: []Type{"AccountId", "ProposalIndex", "Hash", "MemberCount"}, Documentation: []Text{" A motion (given hash) has been proposed (by given account) with a threshold (given", " `MemberCount`)."}}, {Name: "Voted", Args: []Type{"AccountId", "Hash", "bool", "MemberCount", "MemberCount"}, Documentation: []Text{" A motion (given hash) has been voted on by given account, leaving", " a tally (yes votes and no votes given respectively as `MemberCount`)."}}, {Name: "Approved", Args: []Type{"Hash"}, Documentation: []Text{" A motion was approved by the required threshold."}}, {Name: "Disapproved", Args: []Type{"Hash"}, Documentation: []Text{" A motion was not approved by the required threshold."}}, {Name: "Executed", Args: []Type{"Hash", "bool"}, Documentation: []Text{" A motion was executed; `bool` is true if returned without error."}}, {Name: "MemberExecuted", Args: []Type{"Hash", "bool"}, Documentation: []Text{" A single member did some action; `bool` is true if returned without error."}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "TechnicalCommittee", HasStorage: true, Storage: StorageMetadata{Prefix: "Instance2Collective", Items: []StorageFunctionMetadataV5{{Name: "Proposals", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::Hash>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The hashes of the active proposals."}}, {Name: "ProposalOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "<T as Trait<I>>::Proposal", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Actual proposal for a given hash, if it's current."}}, {Name: "Voting", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::Hash", Value: "Votes<T::AccountId>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Votes on a given proposal, if it is ongoing."}}, {Name: "ProposalCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Proposals so far."}}, {Name: "Members", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The current members of the collective. This is stored sorted (just by value)."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set_members", Args: []FunctionArgumentMetadata{{Name: "new_members", Type: "Vec<T::AccountId>"}}, Documentation: []Text{" Set the collective's membership manually to `new_members`. Be nice to the chain and", " provide it pre-sorted.", "", " Requires root origin."}}, {Name: "execute", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<<T as Trait<I>>::Proposal>"}}, Documentation: []Text{" Dispatch a proposal from a member using the `Member` origin.", "", " Origin must be a member of the collective."}}, {Name: "propose", Args: []FunctionArgumentMetadata{{Name: "threshold", Type: "Compact<MemberCount>"}, {Name: "proposal", Type: "Box<<T as Trait<I>>::Proposal>"}}, Documentation: []Text{" # <weight>", " - Bounded storage reads and writes.", " - Argument `threshold` has bearing on weight.", " # </weight>"}}, {Name: "vote", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "T::Hash"}, {Name: "index", Type: "Compact<ProposalIndex>"}, {Name: "approve", Type: "bool"}}, Documentation: []Text{" # <weight>", " - Bounded storage read and writes.", " - Will be slightly heavier if the proposal is approved / disapproved after the vote.", " # </weight>"}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Proposed", Args: []Type{"AccountId", "ProposalIndex", "Hash", "MemberCount"}, Documentation: []Text{" A motion (given hash) has been proposed (by given account) with a threshold (given", " `MemberCount`)."}}, {Name: "Voted", Args: []Type{"AccountId", "Hash", "bool", "MemberCount", "MemberCount"}, Documentation: []Text{" A motion (given hash) has been voted on by given account, leaving", " a tally (yes votes and no votes given respectively as `MemberCount`)."}}, {Name: "Approved", Args: []Type{"Hash"}, Documentation: []Text{" A motion was approved by the required threshold."}}, {Name: "Disapproved", Args: []Type{"Hash"}, Documentation: []Text{" A motion was not approved by the required threshold."}}, {Name: "Executed", Args: []Type{"Hash", "bool"}, Documentation: []Text{" A motion was executed; `bool` is true if returned without error."}}, {Name: "MemberExecuted", Args: []Type{"Hash", "bool"}, Documentation: []Text{" A single member did some action; `bool` is true if returned without error."}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "Elections", HasStorage: true, Storage: StorageMetadata{Prefix: "Council", Items: []StorageFunctionMetadataV5{{Name: "PresentationDuration", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" How long to give each top candidate to present themselves after the vote ends."}}, {Name: "TermDuration", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" How long each position is active for."}}, {Name: "DesiredSeats", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of accounts that should constitute the collective."}}, {Name: "Members", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<(T::AccountId, T::BlockNumber)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{"  The current membership. When there's a vote going on, this should still be used for", "  executive matters. The block number (second element in the tuple) is the block that", "  their position is active until (calculated by the sum of the block number when the", "  member was elected and their term duration)."}}, {Name: "VoteCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "VoteIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The total number of vote rounds that have happened or are in progress."}}, {Name: "ApprovalsOf", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "(T::AccountId, SetIndex)", Value: "Vec<ApprovalFlag>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text(nil)}, {Name: "RegisterInfoOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "(VoteIndex, u32)", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The vote index and list slot that the candidate `who` was registered or `None` if they", " are not currently registered."}}, {Name: "VoterInfoOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "VoterInfo<BalanceOf<T>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Basic information about a voter."}}, {Name: "Voters", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "SetIndex", Value: "Vec<Option<T::AccountId>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The present voter list (chunked and capped at [`VOTER_SET_SIZE`])."}}, {Name: "NextVoterSet", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "SetIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" the next free set to store a voter in. This will keep growing."}}, {Name: "VoterCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "SetIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current number of Voters."}}, {Name: "Candidates", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The present candidate list."}}, {Name: "CandidateCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u32", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Current number of active candidates"}}, {Name: "NextFinalize", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "(T::BlockNumber, u32, Vec<T::AccountId>)", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The accounts holding the seats that will become free on the next tally."}}, {Name: "Leaderboard", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<(BalanceOf<T>, T::AccountId)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Get the leaderboard if we're in the presentation phase. The first element is the weight", " of each entry; It may be the direct summed approval stakes, or a weighted version of it.", " Sorted from low to high."}}, {Name: "Proxy", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "T::AccountId", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Who is able to vote for whom. Value is the fund-holding account, key is the", " vote-transaction-sending account."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "set_approvals", Args: []FunctionArgumentMetadata{{Name: "votes", Type: "Vec<bool>"}, {Name: "index", Type: "Compact<VoteIndex>"}, {Name: "hint", Type: "SetIndex"}, {Name: "value", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Set candidate approvals. Approval slots stay valid as long as candidates in those slots", " are registered.", "", " Locks `value` from the balance of `origin` indefinitely. Only [`retract_voter`] or", " [`reap_inactive_voter`] can unlock the balance.", "", " `hint` argument is interpreted differently based on:", " - if `origin` is setting approvals for the first time: The index will be checked for", "   being a valid _hole_ in the voter list.", "   - if the hint is correctly pointing to a hole, no fee is deducted from `origin`.", "   - Otherwise, the call will succeed but the index is ignored and simply a push to the", "     last chunk with free space happens. If the new push causes a new chunk to be", "     created, a fee indicated by [`VotingFee`] is deducted.", " - if `origin` is already a voter: the index __must__ be valid and point to the correct", "   position of the `origin` in the current voters list.", "", " Note that any trailing `false` votes in `votes` is ignored; In approval voting, not", " voting for a candidate and voting false, are equal.", "", " # <weight>", " - O(1).", " - Two extra DB entries, one DB change.", " - Argument `votes` is limited in length to number of candidates.", " # </weight>"}}, {Name: "proxy_set_approvals", Args: []FunctionArgumentMetadata{{Name: "votes", Type: "Vec<bool>"}, {Name: "index", Type: "Compact<VoteIndex>"}, {Name: "hint", Type: "SetIndex"}, {Name: "value", Type: "Compact<BalanceOf<T>>"}}, Documentation: []Text{" Set candidate approvals from a proxy. Approval slots stay valid as long as candidates in", " those slots are registered.", "", " # <weight>", " - Same as `set_approvals` with one additional storage read.", " # </weight>"}}, {Name: "reap_inactive_voter", Args: []FunctionArgumentMetadata{{Name: "reporter_index", Type: "Compact<u32>"}, {Name: "who", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "who_index", Type: "Compact<u32>"}, {Name: "assumed_vote_index", Type: "Compact<VoteIndex>"}}, Documentation: []Text{" Remove a voter. For it not to be a bond-consuming no-op, all approved candidate indices", " must now be either unregistered or registered to a candidate that registered the slot", " after the voter gave their last approval set.", "", " Both indices must be provided as explained in [`voter_at`] function.", "", " May be called by anyone. Returns the voter deposit to `signed`.", "", " # <weight>", " - O(1).", " - Two fewer DB entries, one DB change.", " # </weight>"}}, {Name: "retract_voter", Args: []FunctionArgumentMetadata{{Name: "index", Type: "Compact<u32>"}}, Documentation: []Text{" Remove a voter. All votes are cancelled and the voter deposit is returned.", "", " The index must be provided as explained in [`voter_at`] function.", "", " Also removes the lock on the balance of the voter. See [`do_set_approvals()`].", "", " # <weight>", " - O(1).", " - Two fewer DB entries, one DB change.", " # </weight>"}}, {Name: "submit_candidacy", Args: []FunctionArgumentMetadata{{Name: "slot", Type: "Compact<u32>"}}, Documentation: []Text{" Submit oneself for candidacy.", "", " Account must have enough transferrable funds in it to pay the bond.", "", " NOTE: if `origin` has already assigned approvals via [`set_approvals`],", " it will NOT have any usable funds to pass candidacy bond and must first retract.", " Note that setting approvals will lock the entire balance of the voter until", " retraction or being reported.", "", " # <weight>", " - Independent of input.", " - Three DB changes.", " # </weight>"}}, {Name: "present_winner", Args: []FunctionArgumentMetadata{{Name: "candidate", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "total", Type: "Compact<BalanceOf<T>>"}, {Name: "index", Type: "Compact<VoteIndex>"}}, Documentation: []Text{" Claim that `candidate` is one of the top `carry_count + desired_seats` candidates. Only", " works iff the presentation period is active. `candidate` should have at least collected", " some non-zero `total` votes and `origin` must have enough funds to pay for a potential", " slash.", "", " # <weight>", " - O(voters) compute.", " - One DB change.", " # </weight>"}}, {Name: "set_desired_seats", Args: []FunctionArgumentMetadata{{Name: "count", Type: "Compact<u32>"}}, Documentation: []Text{" Set the desired member count; if lower than the current count, then seats will not be up", " election when they expire. If more, then a new vote will be started if one is not", " already in progress."}}, {Name: "remove_member", Args: []FunctionArgumentMetadata{{Name: "who", Type: "<T::Lookup as StaticLookup>::Source"}}, Documentation: []Text{" Remove a particular member from the set. This is effective immediately.", "", " Note: A tally should happen instantly (if not already in a presentation", " period) to fill the seat if removal means that the desired members are not met."}}, {Name: "set_presentation_duration", Args: []FunctionArgumentMetadata{{Name: "count", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Set the presentation duration. If there is currently a vote being presented for, will", " invoke `finalize_vote`."}}, {Name: "set_term_duration", Args: []FunctionArgumentMetadata{{Name: "count", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Set the presentation duration. If there is current a vote being presented for, will", " invoke `finalize_vote`."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "VoterReaped", Args: []Type{"AccountId", "AccountId"}, Documentation: []Text{" reaped voter, reaper"}}, {Name: "BadReaperSlashed", Args: []Type{"AccountId"}, Documentation: []Text{" slashed reaper"}}, {Name: "TallyStarted", Args: []Type{"u32"}, Documentation: []Text{" A tally (for approval votes of seat(s)) has started."}}, {Name: "TallyFinalized", Args: []Type{"Vec<AccountId>", "Vec<AccountId>"}, Documentation: []Text{" A tally (for approval votes of seat(s)) has ended (with one or more new members)."}}}, Constants: []ModuleConstantMetadataV6{{Name: "CandidacyBond", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x80, 0xc6, 0xa4, 0x7e, 0x8d, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" How much should be locked up in order to submit one's candidacy. A reasonable", " default value is 9."}}, {Name: "VotingBond", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x40, 0x7a, 0x10, 0xf3, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" How much should be locked up in order to be able to submit votes."}}, {Name: "VotingFee", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x80, 0xf4, 0x20, 0xe6, 0xb5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The amount of fee paid upon each vote submission, unless if they submit a", " _hole_ index and replace it."}}, {Name: "PresentSlashPerVoter", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x10, 0xa5, 0xd4, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The punishment, per voter, if you provide an invalid presentation. A", " reasonable default value is 1."}}, {Name: "CarryCount", Type: "u32", Value: Bytes{0x6, 0x0, 0x0, 0x0}, Documentation: []Text{" How many runners-up should have their approvals persist until the next", " vote. A reasonable default value is 2."}}, {Name: "InactiveGracePeriod", Type: "VoteIndex", Value: Bytes{0x1, 0x0, 0x0, 0x0}, Documentation: []Text{" How many vote indices need to go by after a target voter's last vote before", " they can be reaped if their approvals are moot. A reasonable default value", " is 1."}}, {Name: "VotingPeriod", Type: "T::BlockNumber", Value: Bytes{0x0, 0xe1, 0x0, 0x0}, Documentation: []Text{" How often (in blocks) to check for new votes. A reasonable default value", " is 1000."}}, {Name: "MinimumVotingLock", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x40, 0x7a, 0x10, 0xf3, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Minimum about that can be used as the locked value for voting."}}, {Name: "DecayRatio", Type: "u32", Value: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Decay factor of weight when being accumulated. It should typically be set to", " __at least__ `membership_size -1` to keep the collective secure.", " When set to `N`, it indicates `(1/N)^t` of staked is decayed at weight", " increment step `t`. 0 will result in no weight being added at all (normal", " approval voting). A reasonable default value is 24."}}, {Name: "VOTER_SET_SIZE", Type: "u32", Value: Bytes{0x40, 0x0, 0x0, 0x0}, Documentation: []Text{" The chunk size of the voter vector."}}, {Name: "APPROVAL_SET_SIZE", Type: "u32", Value: Bytes{0x8, 0x0, 0x0, 0x0}, Documentation: []Text{" The chunk size of the approval vector."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "TechnicalMembership", HasStorage: true, Storage: StorageMetadata{Prefix: "Instance1Membership", Items: []StorageFunctionMetadataV5{{Name: "Members", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::AccountId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The current membership, stored as an ordered Vec."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "add_member", Args: []FunctionArgumentMetadata{{Name: "who", Type: "T::AccountId"}}, Documentation: []Text{" Add a member `who` to the set.", "", " May only be called from `AddOrigin` or root."}}, {Name: "remove_member", Args: []FunctionArgumentMetadata{{Name: "who", Type: "T::AccountId"}}, Documentation: []Text{" Remove a member `who` from the set.", "", " May only be called from `RemoveOrigin` or root."}}, {Name: "swap_member", Args: []FunctionArgumentMetadata{{Name: "remove", Type: "T::AccountId"}, {Name: "add", Type: "T::AccountId"}}, Documentation: []Text{" Swap out one member `remove` for another `add`.", "", " May only be called from `SwapOrigin` or root."}}, {Name: "reset_members", Args: []FunctionArgumentMetadata{{Name: "members", Type: "Vec<T::AccountId>"}}, Documentation: []Text{" Change the membership to a new set, disregarding the existing membership. Be nice and", " pass `members` pre-sorted.", "", " May only be called from `ResetOrigin` or root."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "MemberAdded", Args: []Type(nil), Documentation: []Text{" The given member was added; see the transaction for who."}}, {Name: "MemberRemoved", Args: []Type(nil), Documentation: []Text{" The given member was removed; see the transaction for who."}}, {Name: "MembersSwapped", Args: []Type(nil), Documentation: []Text{" Two members were swapped; see the transaction for who."}}, {Name: "MembersReset", Args: []Type(nil), Documentation: []Text{" The membership was reset; see the transaction for who the new set is."}}, {Name: "Dummy", Args: []Type{"rstd::marker::PhantomData<(AccountId, Event)>"}, Documentation: []Text{" Phantom member, never used."}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "FinalityTracker", HasStorage: false, Storage: StorageMetadata{Prefix: "", Items: []StorageFunctionMetadataV5(nil)}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "final_hint", Args: []FunctionArgumentMetadata{{Name: "hint", Type: "Compact<T::BlockNumber>"}}, Documentation: []Text{" Hint that the author of this block thinks the best finalized", " block is the given number."}}}, HasEvents: false, Events: []EventMetadataV4(nil), Constants: []ModuleConstantMetadataV6{{Name: "WindowSize", Type: "T::BlockNumber", Value: Bytes{0x65, 0x0, 0x0, 0x0}, Documentation: []Text{" The number of recent samples to keep from this chain. Default is 101."}}, {Name: "ReportLatency", Type: "T::BlockNumber", Value: Bytes{0xe8, 0x3, 0x0, 0x0}, Documentation: []Text{" The delay after which point things become suspicious. Default is 1000."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Grandpa", HasStorage: true, Storage: StorageMetadata{Prefix: "GrandpaFinality", Items: []StorageFunctionMetadataV5{{Name: "Authorities", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<(AuthorityId, AuthorityWeight)>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The current authority set."}}, {Name: "State", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "StoredState<T::BlockNumber>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" State of the current authority set."}}, {Name: "PendingChange", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "StoredPendingChange<T::BlockNumber>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Pending change: (signaled at, scheduled change)."}}, {Name: "NextForced", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" next block number where we can force a change."}}, {Name: "Stalled", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "(T::BlockNumber, T::BlockNumber)", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" `true` if we are currently stalled."}}, {Name: "CurrentSetId", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "SetId", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The number of changes (both in terms of keys and underlying economic responsibilities)", " in the \"set\" of Grandpa validators from genesis."}}, {Name: "SetIdSession", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "SetId", Value: "SessionIndex", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" A mapping from grandpa set ID to the index of the *most recent* session for which its members were responsible."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "report_misbehavior", Args: []FunctionArgumentMetadata{{Name: "_report", Type: "Vec<u8>"}}, Documentation: []Text{" Report some misbehavior."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "NewAuthorities", Args: []Type{"Vec<(AuthorityId, AuthorityWeight)>"}, Documentation: []Text{" New authority set has been applied."}}, {Name: "Paused", Args: []Type(nil), Documentation: []Text{" Current authority set has been paused."}}, {Name: "Resumed", Args: []Type(nil), Documentation: []Text{" Current authority set has been resumed."}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "Treasury", HasStorage: true, Storage: StorageMetadata{Prefix: "Treasury", Items: []StorageFunctionMetadataV5{{Name: "ProposalCount", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "ProposalIndex", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of proposals that have been made."}}, {Name: "Proposals", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "ProposalIndex", Value: "Proposal<T::AccountId, BalanceOf<T>>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Proposals that have been made."}}, {Name: "Approvals", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<ProposalIndex>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Proposal indices that have been approved but not yet awarded."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "propose_spend", Args: []FunctionArgumentMetadata{{Name: "value", Type: "Compact<BalanceOf<T>>"}, {Name: "beneficiary", Type: "<T::Lookup as StaticLookup>::Source"}}, Documentation: []Text{" Put forward a suggestion for spending. A deposit proportional to the value", " is reserved and slashed if the proposal is rejected. It is returned once the", " proposal is awarded.", "", " # <weight>", " - O(1).", " - Limited storage reads.", " - One DB change, one extra DB entry.", " # </weight>"}}, {Name: "reject_proposal", Args: []FunctionArgumentMetadata{{Name: "proposal_id", Type: "Compact<ProposalIndex>"}}, Documentation: []Text{" Reject a proposed spend. The original deposit will be slashed.", "", " # <weight>", " - O(1).", " - Limited storage reads.", " - One DB clear.", " # </weight>"}}, {Name: "approve_proposal", Args: []FunctionArgumentMetadata{{Name: "proposal_id", Type: "Compact<ProposalIndex>"}}, Documentation: []Text{" Approve a proposal. At a later time, the proposal will be allocated to the beneficiary", " and the original deposit will be returned.", "", " # <weight>", " - O(1).", " - Limited storage reads.", " - One DB change.", " # </weight>"}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Proposed", Args: []Type{"ProposalIndex"}, Documentation: []Text{" New proposal."}}, {Name: "Spending", Args: []Type{"Balance"}, Documentation: []Text{" We have ended a spend period and will now allocate funds."}}, {Name: "Awarded", Args: []Type{"ProposalIndex", "Balance", "AccountId"}, Documentation: []Text{" Some funds have been allocated."}}, {Name: "Burnt", Args: []Type{"Balance"}, Documentation: []Text{" Some of our funds have been burnt."}}, {Name: "Rollover", Args: []Type{"Balance"}, Documentation: []Text{" Spending has finished; this is the amount that rolls over until next spend."}}}, Constants: []ModuleConstantMetadataV6{{Name: "ProposalBond", Type: "Permill", Value: Bytes{0x50, 0xc3, 0x0, 0x0}, Documentation: []Text{" Fraction of a proposal's value that should be bonded in order to place the proposal.", " An accepted proposal gets these back. A rejected proposal does not."}}, {Name: "ProposalBondMinimum", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x40, 0x7a, 0x10, 0xf3, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Minimum amount of funds that should be placed in a deposit for making a proposal."}}, {Name: "SpendPeriod", Type: "T::BlockNumber", Value: Bytes{0x80, 0x70, 0x0, 0x0}, Documentation: []Text{" Period between successive spends."}}, {Name: "Burn", Type: "Permill", Value: Bytes{0x20, 0xa1, 0x7, 0x0}, Documentation: []Text{" Percentage of spare funds (if any) that are burnt per spend period."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Contracts", HasStorage: true, Storage: StorageMetadata{Prefix: "Contract", Items: []StorageFunctionMetadataV5{{Name: "GasSpent", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Gas", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Gas spent so far in this block."}}, {Name: "CurrentSchedule", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Schedule", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x87, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0}, Documentation: []Text{" Current cost schedule for contracts."}}, {Name: "PristineCode", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "CodeHash<T>", Value: "Vec<u8>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" A mapping from an original code hash to the original code, untouched by instrumentation."}}, {Name: "CodeStorage", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "CodeHash<T>", Value: "wasm::PrefabWasmModule", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" A mapping between an original code hash and instrumented wasm code, ready for execution."}}, {Name: "AccountCounter", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "u64", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The subtrie counter."}}, {Name: "ContractInfoOf", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "T::AccountId", Value: "ContractInfo<T>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The code associated with a given account."}}, {Name: "GasPrice", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "BalanceOf<T>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The price of one unit of gas."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "update_schedule", Args: []FunctionArgumentMetadata{{Name: "schedule", Type: "Schedule"}}, Documentation: []Text{" Updates the schedule for metering contracts.", "", " The schedule must have a greater version than the stored schedule."}}, {Name: "put_code", Args: []FunctionArgumentMetadata{{Name: "gas_limit", Type: "Compact<Gas>"}, {Name: "code", Type: "Vec<u8>"}}, Documentation: []Text{" Stores the given binary Wasm code into the chain's storage and returns its `codehash`.", " You can instantiate contracts only with stored code."}}, {Name: "call", Args: []FunctionArgumentMetadata{{Name: "dest", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "value", Type: "Compact<BalanceOf<T>>"}, {Name: "gas_limit", Type: "Compact<Gas>"}, {Name: "data", Type: "Vec<u8>"}}, Documentation: []Text{" Makes a call to an account, optionally transferring some balance.", "", " * If the account is a smart-contract account, the associated code will be", " executed and any value will be transferred.", " * If the account is a regular account, any value will be transferred.", " * If no account exists and the call value is not less than `existential_deposit`,", " a regular account will be created and any value will be transferred."}}, {Name: "instantiate", Args: []FunctionArgumentMetadata{{Name: "endowment", Type: "Compact<BalanceOf<T>>"}, {Name: "gas_limit", Type: "Compact<Gas>"}, {Name: "code_hash", Type: "CodeHash<T>"}, {Name: "data", Type: "Vec<u8>"}}, Documentation: []Text{" Instantiates a new contract from the `codehash` generated by `put_code`, optionally transferring some balance.", "", " Instantiation is executed as follows:", "", " - The destination address is computed based on the sender and hash of the code.", " - The smart-contract account is created at the computed address.", " - The `ctor_code` is executed in the context of the newly-created account. Buffer returned", "   after the execution is saved as the `code` of the account. That code will be invoked", "   upon any call received by this account.", " - The contract is initialized."}}, {Name: "claim_surcharge", Args: []FunctionArgumentMetadata{{Name: "dest", Type: "T::AccountId"}, {Name: "aux_sender", Type: "Option<T::AccountId>"}}, Documentation: []Text{" Allows block producers to claim a small reward for evicting a contract. If a block producer", " fails to do so, a regular users will be allowed to claim the reward.", "", " If contract is not evicted as a result of this call, no actions are taken and", " the sender is not eligible for the reward."}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Transfer", Args: []Type{"AccountId", "AccountId", "Balance"}, Documentation: []Text{" Transfer happened `from` to `to` with given `value` as part of a `call` or `instantiate`."}}, {Name: "Instantiated", Args: []Type{"AccountId", "AccountId"}, Documentation: []Text{" Contract deployed by address at the specified address."}}, {Name: "CodeStored", Args: []Type{"Hash"}, Documentation: []Text{" Code with the specified hash has been stored."}}, {Name: "ScheduleUpdated", Args: []Type{"u32"}, Documentation: []Text{" Triggered when the current schedule is updated."}}, {Name: "Dispatched", Args: []Type{"AccountId", "bool"}, Documentation: []Text{" A call was dispatched from the given account. The bool signals whether it was", " successful execution or not."}}, {Name: "Contract", Args: []Type{"AccountId", "Vec<u8>"}, Documentation: []Text{" An event from contract of account."}}}, Constants: []ModuleConstantMetadataV6{{Name: "SignedClaimHandicap", Type: "T::BlockNumber", Value: Bytes{0x2, 0x0, 0x0, 0x0}, Documentation: []Text{" Number of block delay an extrinsic claim surcharge has.", "", " When claim surcharge is called by an extrinsic the rent is checked", " for current_block - delay"}}, {Name: "TombstoneDeposit", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x40, 0x7a, 0x10, 0xf3, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The minimum amount required to generate a tombstone."}}, {Name: "StorageSizeOffset", Type: "u32", Value: Bytes{0x8, 0x0, 0x0, 0x0}, Documentation: []Text{" Size of a contract at the time of instantiaion. This is a simple way to ensure that", " empty contracts eventually gets deleted."}}, {Name: "RentByteFee", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x40, 0x7a, 0x10, 0xf3, 0x5a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Price of a byte of storage per one block interval. Should be greater than 0."}}, {Name: "RentDepositOffset", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x0, 0x8a, 0x5d, 0x78, 0x45, 0x63, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The amount of funds a contract should deposit in order to offset", " the cost of one byte.", "", " Let's suppose the deposit is 1,000 BU (balance units)/byte and the rent is 1 BU/byte/day,", " then a contract with 1,000,000 BU that uses 1,000 bytes of storage would pay no rent.", " But if the balance reduced to 500,000 BU and the storage stayed the same at 1,000,", " then it would pay 500 BU/day."}}, {Name: "SurchargeReward", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x80, 0xa1, 0xa7, 0x6b, 0x4a, 0x35, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" Reward that is received by the party whose touch has led", " to removal of a contract."}}, {Name: "TransferFee", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x10, 0xa5, 0xd4, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to make a transfer."}}, {Name: "CreationFee", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x10, 0xa5, 0xd4, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to create an account."}}, {Name: "TransactionBaseFee", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x10, 0xa5, 0xd4, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee to be paid for making a transaction; the base."}}, {Name: "TransactionByteFee", Type: "BalanceOf<T>", Value: Bytes{0x0, 0xe4, 0xb, 0x54, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee to be paid for making a transaction; the per-byte portion."}}, {Name: "ContractFee", Type: "BalanceOf<T>", Value: Bytes{0x0, 0x10, 0xa5, 0xd4, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The fee required to instantiate a contract instance. A reasonable default value", " is 21."}}, {Name: "CallBaseFee", Type: "Gas", Value: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The base fee charged for calling into a contract. A reasonable default", " value is 135."}}, {Name: "InstantiateBaseFee", Type: "Gas", Value: Bytes{0xe8, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The base fee charged for instantiating a contract. A reasonable default value", " is 175."}}, {Name: "MaxDepth", Type: "u32", Value: Bytes{0x0, 0x4, 0x0, 0x0}, Documentation: []Text{" The maximum nesting level of a call/instantiate stack. A reasonable default", " value is 100."}}, {Name: "MaxValueSize", Type: "u32", Value: Bytes{0x0, 0x40, 0x0, 0x0}, Documentation: []Text{" The maximum size of a storage value in bytes. A reasonable default is 16 KiB."}}, {Name: "BlockGasLimit", Type: "Gas", Value: Bytes{0x80, 0x96, 0x98, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The maximum amount of gas that could be expended per block. A reasonable", " default value is 10_000_000."}}}, Errors: []ErrorMetadataV8(nil)}, {Name: "Sudo", HasStorage: true, Storage: StorageMetadata{Prefix: "Sudo", Items: []StorageFunctionMetadataV5{{Name: "Key", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::AccountId", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The `AccountId` of the sudo key."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "sudo", Args: []FunctionArgumentMetadata{{Name: "proposal", Type: "Box<T::Proposal>"}}, Documentation: []Text{" Authenticates the sudo key and dispatches a function call with `Root` origin.", "", " The dispatch origin for this call must be _Signed_.", "", " # <weight>", " - O(1).", " - Limited storage reads.", " - One DB write (event).", " - Unknown weight of derivative `proposal` execution.", " # </weight>"}}, {Name: "set_key", Args: []FunctionArgumentMetadata{{Name: "new", Type: "<T::Lookup as StaticLookup>::Source"}}, Documentation: []Text{" Authenticates the current sudo key and sets the given AccountId (`new`) as the new sudo key.", "", " The dispatch origin for this call must be _Signed_.", "", " # <weight>", " - O(1).", " - Limited storage reads.", " - One DB change.", " # </weight>"}}, {Name: "sudo_as", Args: []FunctionArgumentMetadata{{Name: "who", Type: "<T::Lookup as StaticLookup>::Source"}, {Name: "proposal", Type: "Box<T::Proposal>"}}, Documentation: []Text{" Authenticates the sudo key and dispatches a function call with `Signed` origin from", " a given account.", "", " The dispatch origin for this call must be _Signed_.", "", " # <weight>", " - O(1).", " - Limited storage reads.", " - One DB write (event).", " - Unknown weight of derivative `proposal` execution.", " # </weight>"}}}, HasEvents: true, Events: []EventMetadataV4{{Name: "Sudid", Args: []Type{"bool"}, Documentation: []Text{" A sudo just took place."}}, {Name: "KeyChanged", Args: []Type{"AccountId"}, Documentation: []Text{" The sudoer just switched identity; the old key is supplied."}}, {Name: "SudoAsDone", Args: []Type{"bool"}, Documentation: []Text{" A sudo just took place."}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "ImOnline", HasStorage: true, Storage: StorageMetadata{Prefix: "ImOnline", Items: []StorageFunctionMetadataV5{{Name: "GossipAt", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "T::BlockNumber", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0, 0x0, 0x0, 0x0}, Documentation: []Text{" The block number when we should gossip."}}, {Name: "Keys", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::AuthorityId>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The current set of keys that may issue a heartbeat."}}, {Name: "ReceivedHeartbeats", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: true, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "SessionIndex", Key2: "AuthIndex", Value: "Vec<u8>", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" For each session index we keep a mapping of `AuthorityId`", " to `offchain::OpaqueNetworkState`."}}}}, HasCalls: true, Calls: []FunctionMetadataV4{{Name: "heartbeat", Args: []FunctionArgumentMetadata{{Name: "heartbeat", Type: "Heartbeat<T::BlockNumber>"}, {Name: "signature", Type: "<T::AuthorityId as RuntimeAppPublic>::Signature"}}, Documentation: []Text(nil)}}, HasEvents: true, Events: []EventMetadataV4{{Name: "HeartbeatReceived", Args: []Type{"AuthorityId"}, Documentation: []Text{" A new heartbeat was received from `AuthorityId`"}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "AuthorityDiscovery", HasStorage: false, Storage: StorageMetadata{Prefix: "", Items: []StorageFunctionMetadataV5(nil)}, HasCalls: true, Calls: []FunctionMetadataV4(nil), HasEvents: false, Events: []EventMetadataV4(nil), Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "Offences", HasStorage: true, Storage: StorageMetadata{Prefix: "Offences", Items: []StorageFunctionMetadataV5{{Name: "Reports", Modifier: StorageFunctionModifierV0{IsOptional: true, IsDefault: false, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "ReportIdOf<T>", Value: "OffenceDetails<T::AccountId, T::IdentificationTuple>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" The primary structure that holds all offence records keyed by report identifiers."}}, {Name: "ConcurrentReportsIndex", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: true, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "Kind", Key2: "OpaqueTimeSlot", Value: "Vec<ReportIdOf<T>>", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" A vector of reports of the same kind that happened at the same time slot."}}, {Name: "ReportsByKindIndex", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: false, AsType: "", IsMap: true, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: true, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "Kind", Value: "Vec<u8>", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Enumerates all reports of a kind along with the time they happened.", "", " All reports are sorted by the time of offence.", "", " Note that the actual type of this mapping is `Vec<u8>`, this is because values of", " different types are not supported at the moment so we are doing the manual serialization."}}}}, HasCalls: true, Calls: []FunctionMetadataV4(nil), HasEvents: true, Events: []EventMetadataV4{{Name: "Offence", Args: []Type{"Kind", "OpaqueTimeSlot"}, Documentation: []Text{" There is an offence reported of the given `kind` happened at the `session_index` and", " (kind-specific) time slot. This event is not deposited for duplicate slashes."}}}, Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}, {Name: "RandomnessCollectiveFlip", HasStorage: true, Storage: StorageMetadata{Prefix: "RandomnessCollectiveFlip", Items: []StorageFunctionMetadataV5{{Name: "RandomMaterial", Modifier: StorageFunctionModifierV0{IsOptional: false, IsDefault: true, IsRequired: false}, Type: StorageFunctionTypeV5{IsType: true, AsType: "Vec<T::Hash>", IsMap: false, AsMap: MapTypeV4{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key: "", Value: "", Linked: false}, IsDoubleMap: false, AsDoubleMap: DoubleMapTypeV5{Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}, Key1: "", Key2: "", Value: "", Key2Hasher: StorageHasher{IsBlake2_128: false, IsBlake2_256: false, IsTwox128: false, IsTwox256: false, IsTwox64Concat: false}}}, Fallback: Bytes{0x0}, Documentation: []Text{" Series of block headers from the last 81 blocks that acts as random seed material. This", " is arranged as a ring buffer with `block_number % 81` being the index into the `Vec` of", " the oldest hash."}}}}, HasCalls: true, Calls: []FunctionMetadataV4(nil), HasEvents: false, Events: []EventMetadataV4(nil), Constants: []ModuleConstantMetadataV6(nil), Errors: []ErrorMetadataV8(nil)}}}} //nolint:lll,dupl
