// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudhsm provides a client for Amazon CloudHSM.
package cloudhsm

import (
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/service"
)

const opCreateHAPG = "CreateHapg"

// CreateHAPGRequest generates a request for the CreateHAPG operation.
func (c *CloudHSM) CreateHAPGRequest(input *CreateHAPGInput) (req *service.Request, output *CreateHAPGOutput) {
	op := &service.Operation{
		Name:       opCreateHAPG,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHAPGInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHAPGOutput{}
	req.Data = output
	return
}

// Creates a high-availability partition group. A high-availability partition
// group is a group of partitions that spans multiple physical HSMs.
func (c *CloudHSM) CreateHAPG(input *CreateHAPGInput) (*CreateHAPGOutput, error) {
	req, out := c.CreateHAPGRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHSM = "CreateHsm"

// CreateHSMRequest generates a request for the CreateHSM operation.
func (c *CloudHSM) CreateHSMRequest(input *CreateHSMInput) (req *service.Request, output *CreateHSMOutput) {
	op := &service.Operation{
		Name:       opCreateHSM,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHSMInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHSMOutput{}
	req.Data = output
	return
}

// Creates an uninitialized HSM instance.
//
// There is an upfront fee charged for each HSM instance that you create with
// the CreateHsm operation. If you accidentally provision an HSM and want to
// request a refund, delete the instance using the DeleteHsm operation, go to
// the AWS Support Center (https://console.aws.amazon.com/support/home#/), create
// a new case, and select Account and Billing Support.
//
//   It can take up to 20 minutes to create and provision an HSM. You can monitor
// the status of the HSM with the DescribeHsm operation. The HSM is ready to
// be initialized when the status changes to RUNNING.
func (c *CloudHSM) CreateHSM(input *CreateHSMInput) (*CreateHSMOutput, error) {
	req, out := c.CreateHSMRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLunaClient = "CreateLunaClient"

// CreateLunaClientRequest generates a request for the CreateLunaClient operation.
func (c *CloudHSM) CreateLunaClientRequest(input *CreateLunaClientInput) (req *service.Request, output *CreateLunaClientOutput) {
	op := &service.Operation{
		Name:       opCreateLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLunaClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLunaClientOutput{}
	req.Data = output
	return
}

// Creates an HSM client.
func (c *CloudHSM) CreateLunaClient(input *CreateLunaClientInput) (*CreateLunaClientOutput, error) {
	req, out := c.CreateLunaClientRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHAPG = "DeleteHapg"

// DeleteHAPGRequest generates a request for the DeleteHAPG operation.
func (c *CloudHSM) DeleteHAPGRequest(input *DeleteHAPGInput) (req *service.Request, output *DeleteHAPGOutput) {
	op := &service.Operation{
		Name:       opDeleteHAPG,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHAPGInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHAPGOutput{}
	req.Data = output
	return
}

// Deletes a high-availability partition group.
func (c *CloudHSM) DeleteHAPG(input *DeleteHAPGInput) (*DeleteHAPGOutput, error) {
	req, out := c.DeleteHAPGRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHSM = "DeleteHsm"

// DeleteHSMRequest generates a request for the DeleteHSM operation.
func (c *CloudHSM) DeleteHSMRequest(input *DeleteHSMInput) (req *service.Request, output *DeleteHSMOutput) {
	op := &service.Operation{
		Name:       opDeleteHSM,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHSMInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHSMOutput{}
	req.Data = output
	return
}

// Deletes an HSM. After completion, this operation cannot be undone and your
// key material cannot be recovered.
func (c *CloudHSM) DeleteHSM(input *DeleteHSMInput) (*DeleteHSMOutput, error) {
	req, out := c.DeleteHSMRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLunaClient = "DeleteLunaClient"

// DeleteLunaClientRequest generates a request for the DeleteLunaClient operation.
func (c *CloudHSM) DeleteLunaClientRequest(input *DeleteLunaClientInput) (req *service.Request, output *DeleteLunaClientOutput) {
	op := &service.Operation{
		Name:       opDeleteLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLunaClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLunaClientOutput{}
	req.Data = output
	return
}

// Deletes a client.
func (c *CloudHSM) DeleteLunaClient(input *DeleteLunaClientInput) (*DeleteLunaClientOutput, error) {
	req, out := c.DeleteLunaClientRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeHAPG = "DescribeHapg"

// DescribeHAPGRequest generates a request for the DescribeHAPG operation.
func (c *CloudHSM) DescribeHAPGRequest(input *DescribeHAPGInput) (req *service.Request, output *DescribeHAPGOutput) {
	op := &service.Operation{
		Name:       opDescribeHAPG,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHAPGInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeHAPGOutput{}
	req.Data = output
	return
}

// Retrieves information about a high-availability partition group.
func (c *CloudHSM) DescribeHAPG(input *DescribeHAPGInput) (*DescribeHAPGOutput, error) {
	req, out := c.DescribeHAPGRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeHSM = "DescribeHsm"

// DescribeHSMRequest generates a request for the DescribeHSM operation.
func (c *CloudHSM) DescribeHSMRequest(input *DescribeHSMInput) (req *service.Request, output *DescribeHSMOutput) {
	op := &service.Operation{
		Name:       opDescribeHSM,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHSMInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeHSMOutput{}
	req.Data = output
	return
}

// Retrieves information about an HSM. You can identify the HSM by its ARN or
// its serial number.
func (c *CloudHSM) DescribeHSM(input *DescribeHSMInput) (*DescribeHSMOutput, error) {
	req, out := c.DescribeHSMRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLunaClient = "DescribeLunaClient"

// DescribeLunaClientRequest generates a request for the DescribeLunaClient operation.
func (c *CloudHSM) DescribeLunaClientRequest(input *DescribeLunaClientInput) (req *service.Request, output *DescribeLunaClientOutput) {
	op := &service.Operation{
		Name:       opDescribeLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLunaClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLunaClientOutput{}
	req.Data = output
	return
}

// Retrieves information about an HSM client.
func (c *CloudHSM) DescribeLunaClient(input *DescribeLunaClientInput) (*DescribeLunaClientOutput, error) {
	req, out := c.DescribeLunaClientRequest(input)
	err := req.Send()
	return out, err
}

const opGetConfig = "GetConfig"

// GetConfigRequest generates a request for the GetConfig operation.
func (c *CloudHSM) GetConfigRequest(input *GetConfigInput) (req *service.Request, output *GetConfigOutput) {
	op := &service.Operation{
		Name:       opGetConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetConfigOutput{}
	req.Data = output
	return
}

// Gets the configuration files necessary to connect to all high availability
// partition groups the client is associated with.
func (c *CloudHSM) GetConfig(input *GetConfigInput) (*GetConfigOutput, error) {
	req, out := c.GetConfigRequest(input)
	err := req.Send()
	return out, err
}

const opListAvailableZones = "ListAvailableZones"

// ListAvailableZonesRequest generates a request for the ListAvailableZones operation.
func (c *CloudHSM) ListAvailableZonesRequest(input *ListAvailableZonesInput) (req *service.Request, output *ListAvailableZonesOutput) {
	op := &service.Operation{
		Name:       opListAvailableZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableZonesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAvailableZonesOutput{}
	req.Data = output
	return
}

// Lists the Availability Zones that have available AWS CloudHSM capacity.
func (c *CloudHSM) ListAvailableZones(input *ListAvailableZonesInput) (*ListAvailableZonesOutput, error) {
	req, out := c.ListAvailableZonesRequest(input)
	err := req.Send()
	return out, err
}

const opListHSMs = "ListHsms"

// ListHSMsRequest generates a request for the ListHSMs operation.
func (c *CloudHSM) ListHSMsRequest(input *ListHSMsInput) (req *service.Request, output *ListHSMsOutput) {
	op := &service.Operation{
		Name:       opListHSMs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListHSMsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHSMsOutput{}
	req.Data = output
	return
}

// Retrieves the identifiers of all of the HSMs provisioned for the current
// customer.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListHsms to retrieve the next set
// of items.
func (c *CloudHSM) ListHSMs(input *ListHSMsInput) (*ListHSMsOutput, error) {
	req, out := c.ListHSMsRequest(input)
	err := req.Send()
	return out, err
}

const opListHapgs = "ListHapgs"

// ListHapgsRequest generates a request for the ListHapgs operation.
func (c *CloudHSM) ListHapgsRequest(input *ListHapgsInput) (req *service.Request, output *ListHapgsOutput) {
	op := &service.Operation{
		Name:       opListHapgs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListHapgsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHapgsOutput{}
	req.Data = output
	return
}

// Lists the high-availability partition groups for the account.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListHapgs to retrieve the next
// set of items.
func (c *CloudHSM) ListHapgs(input *ListHapgsInput) (*ListHapgsOutput, error) {
	req, out := c.ListHapgsRequest(input)
	err := req.Send()
	return out, err
}

const opListLunaClients = "ListLunaClients"

// ListLunaClientsRequest generates a request for the ListLunaClients operation.
func (c *CloudHSM) ListLunaClientsRequest(input *ListLunaClientsInput) (req *service.Request, output *ListLunaClientsOutput) {
	op := &service.Operation{
		Name:       opListLunaClients,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLunaClientsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListLunaClientsOutput{}
	req.Data = output
	return
}

// Lists all of the clients.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListLunaClients to retrieve the
// next set of items.
func (c *CloudHSM) ListLunaClients(input *ListLunaClientsInput) (*ListLunaClientsOutput, error) {
	req, out := c.ListLunaClientsRequest(input)
	err := req.Send()
	return out, err
}

const opModifyHAPG = "ModifyHapg"

// ModifyHAPGRequest generates a request for the ModifyHAPG operation.
func (c *CloudHSM) ModifyHAPGRequest(input *ModifyHAPGInput) (req *service.Request, output *ModifyHAPGOutput) {
	op := &service.Operation{
		Name:       opModifyHAPG,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHAPGInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyHAPGOutput{}
	req.Data = output
	return
}

// Modifies an existing high-availability partition group.
func (c *CloudHSM) ModifyHAPG(input *ModifyHAPGInput) (*ModifyHAPGOutput, error) {
	req, out := c.ModifyHAPGRequest(input)
	err := req.Send()
	return out, err
}

const opModifyHSM = "ModifyHsm"

// ModifyHSMRequest generates a request for the ModifyHSM operation.
func (c *CloudHSM) ModifyHSMRequest(input *ModifyHSMInput) (req *service.Request, output *ModifyHSMOutput) {
	op := &service.Operation{
		Name:       opModifyHSM,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHSMInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyHSMOutput{}
	req.Data = output
	return
}

// Modifies an HSM.
//
//   This operation can result in the HSM being offline for up to 15 minutes
// while the AWS CloudHSM service is reconfigured. If you are modifying a production
// HSM, you should ensure that your AWS CloudHSM service is configured for high
// availability, and consider executing this operation during a maintenance
// window.
func (c *CloudHSM) ModifyHSM(input *ModifyHSMInput) (*ModifyHSMOutput, error) {
	req, out := c.ModifyHSMRequest(input)
	err := req.Send()
	return out, err
}

const opModifyLunaClient = "ModifyLunaClient"

// ModifyLunaClientRequest generates a request for the ModifyLunaClient operation.
func (c *CloudHSM) ModifyLunaClientRequest(input *ModifyLunaClientInput) (req *service.Request, output *ModifyLunaClientOutput) {
	op := &service.Operation{
		Name:       opModifyLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyLunaClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyLunaClientOutput{}
	req.Data = output
	return
}

// Modifies the certificate used by the client.
//
// This action can potentially start a workflow to install the new certificate
// on the client's HSMs.
func (c *CloudHSM) ModifyLunaClient(input *ModifyLunaClientInput) (*ModifyLunaClientOutput, error) {
	req, out := c.ModifyLunaClientRequest(input)
	err := req.Send()
	return out, err
}

// Contains the inputs for the CreateHapgRequest action.
type CreateHAPGInput struct {
	// The label of the new high-availability partition group.
	Label *string `type:"string" required:"true"`

	metadataCreateHAPGInput `json:"-" xml:"-"`
}

type metadataCreateHAPGInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateHAPGInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHAPGInput) GoString() string {
	return s.String()
}

// Contains the output of the CreateHAPartitionGroup action.
type CreateHAPGOutput struct {
	// The ARN of the high-availability partition group.
	HAPGARN *string `locationName:"HapgArn" type:"string"`

	metadataCreateHAPGOutput `json:"-" xml:"-"`
}

type metadataCreateHAPGOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateHAPGOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHAPGOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateHsm operation.
type CreateHSMInput struct {
	// A user-defined token to ensure idempotence. Subsequent calls to this operation
	// with the same token will be ignored.
	ClientToken *string `locationName:"ClientToken" type:"string"`

	// The IP address to assign to the HSM's ENI.
	//
	// If an IP address is not specified, an IP address will be randomly chosen
	// from the CIDR range of the subnet.
	ENIIP *string `locationName:"EniIp" type:"string"`

	// The external ID from IamRoleArn, if present.
	ExternalID *string `locationName:"ExternalId" type:"string"`

	// The ARN of an IAM role to enable the AWS CloudHSM service to allocate an
	// ENI on your behalf.
	IAMRoleARN *string `locationName:"IamRoleArn" type:"string" required:"true"`

	// The SSH public key to install on the HSM.
	SSHKey *string `locationName:"SshKey" type:"string" required:"true"`

	// The identifier of the subnet in your VPC in which to place the HSM.
	SubnetID *string `locationName:"SubnetId" type:"string" required:"true"`

	// Specifies the type of subscription for the HSM.
	//
	//   PRODUCTION - The HSM is being used in a production environment.  TRIAL
	// - The HSM is being used in a product trial.
	SubscriptionType *string `locationName:"SubscriptionType" type:"string" required:"true" enum:"SubscriptionType"`

	// The IP address for the syslog monitoring server. The AWS CloudHSM service
	// only supports one syslog monitoring server.
	SyslogIP *string `locationName:"SyslogIp" type:"string"`

	metadataCreateHSMInput `json:"-" xml:"-"`
}

type metadataCreateHSMInput struct {
	SDKShapeTraits bool `locationName:"CreateHsmRequest" type:"structure"`
}

// String returns the string representation
func (s CreateHSMInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHSMInput) GoString() string {
	return s.String()
}

// Contains the output of the CreateHsm operation.
type CreateHSMOutput struct {
	// The ARN of the HSM.
	HSMARN *string `locationName:"HsmArn" type:"string"`

	metadataCreateHSMOutput `json:"-" xml:"-"`
}

type metadataCreateHSMOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateHSMOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHSMOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateLunaClient action.
type CreateLunaClientInput struct {
	// The contents of a Base64-Encoded X.509 v3 certificate to be installed on
	// the HSMs used by this client.
	Certificate *string `type:"string" required:"true"`

	// The label for the client.
	Label *string `type:"string"`

	metadataCreateLunaClientInput `json:"-" xml:"-"`
}

type metadataCreateLunaClientInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLunaClientInput) GoString() string {
	return s.String()
}

// Contains the output of the CreateLunaClient action.
type CreateLunaClientOutput struct {
	// The ARN of the client.
	ClientARN *string `locationName:"ClientArn" type:"string"`

	metadataCreateLunaClientOutput `json:"-" xml:"-"`
}

type metadataCreateLunaClientOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLunaClientOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteHapg action.
type DeleteHAPGInput struct {
	// The ARN of the high-availability partition group to delete.
	HAPGARN *string `locationName:"HapgArn" type:"string" required:"true"`

	metadataDeleteHAPGInput `json:"-" xml:"-"`
}

type metadataDeleteHAPGInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteHAPGInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHAPGInput) GoString() string {
	return s.String()
}

// Contains the output of the DeleteHapg action.
type DeleteHAPGOutput struct {
	// The status of the action.
	Status *string `type:"string" required:"true"`

	metadataDeleteHAPGOutput `json:"-" xml:"-"`
}

type metadataDeleteHAPGOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteHAPGOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHAPGOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteHsm operation.
type DeleteHSMInput struct {
	// The ARN of the HSM to delete.
	HSMARN *string `locationName:"HsmArn" type:"string" required:"true"`

	metadataDeleteHSMInput `json:"-" xml:"-"`
}

type metadataDeleteHSMInput struct {
	SDKShapeTraits bool `locationName:"DeleteHsmRequest" type:"structure"`
}

// String returns the string representation
func (s DeleteHSMInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHSMInput) GoString() string {
	return s.String()
}

// Contains the output of the DeleteHsm operation.
type DeleteHSMOutput struct {
	// The status of the operation.
	Status *string `type:"string" required:"true"`

	metadataDeleteHSMOutput `json:"-" xml:"-"`
}

type metadataDeleteHSMOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteHSMOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHSMOutput) GoString() string {
	return s.String()
}

type DeleteLunaClientInput struct {
	// The ARN of the client to delete.
	ClientARN *string `locationName:"ClientArn" type:"string" required:"true"`

	metadataDeleteLunaClientInput `json:"-" xml:"-"`
}

type metadataDeleteLunaClientInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLunaClientInput) GoString() string {
	return s.String()
}

type DeleteLunaClientOutput struct {
	// The status of the action.
	Status *string `type:"string" required:"true"`

	metadataDeleteLunaClientOutput `json:"-" xml:"-"`
}

type metadataDeleteLunaClientOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLunaClientOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DescribeHapg action.
type DescribeHAPGInput struct {
	// The ARN of the high-availability partition group to describe.
	HAPGARN *string `locationName:"HapgArn" type:"string" required:"true"`

	metadataDescribeHAPGInput `json:"-" xml:"-"`
}

type metadataDescribeHAPGInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeHAPGInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHAPGInput) GoString() string {
	return s.String()
}

// Contains the output of the DescribeHapg action.
type DescribeHAPGOutput struct {
	// The ARN of the high-availability partition group.
	HAPGARN *string `locationName:"HapgArn" type:"string"`

	// The serial number of the high-availability partition group.
	HAPGSerial *string `locationName:"HapgSerial" type:"string"`

	// Contains a list of ARNs that identify the HSMs.
	HSMsLastActionFailed []*string `locationName:"HsmsLastActionFailed" type:"list"`

	// Contains a list of ARNs that identify the HSMs.
	HSMsPendingDeletion []*string `locationName:"HsmsPendingDeletion" type:"list"`

	// Contains a list of ARNs that identify the HSMs.
	HSMsPendingRegistration []*string `locationName:"HsmsPendingRegistration" type:"list"`

	// The label for the high-availability partition group.
	Label *string `type:"string"`

	// The date and time the high-availability partition group was last modified.
	LastModifiedTimestamp *string `type:"string"`

	// The list of partition serial numbers that belong to the high-availability
	// partition group.
	PartitionSerialList []*string `type:"list"`

	// The state of the high-availability partition group.
	State *string `type:"string" enum:"CloudHsmObjectState"`

	metadataDescribeHAPGOutput `json:"-" xml:"-"`
}

type metadataDescribeHAPGOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeHAPGOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHAPGOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DescribeHsm operation.
type DescribeHSMInput struct {
	// The ARN of the HSM. Either the HsmArn or the SerialNumber parameter must
	// be specified.
	HSMARN *string `locationName:"HsmArn" type:"string"`

	// The serial number of the HSM. Either the HsmArn or the HsmSerialNumber parameter
	// must be specified.
	HSMSerialNumber *string `locationName:"HsmSerialNumber" type:"string"`

	metadataDescribeHSMInput `json:"-" xml:"-"`
}

type metadataDescribeHSMInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeHSMInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHSMInput) GoString() string {
	return s.String()
}

// Contains the output of the DescribeHsm operation.
type DescribeHSMOutput struct {
	// The Availability Zone that the HSM is in.
	AvailabilityZone *string `type:"string"`

	// The identifier of the elastic network interface (ENI) attached to the HSM.
	ENIID *string `locationName:"EniId" type:"string"`

	// The IP address assigned to the HSM's ENI.
	ENIIP *string `locationName:"EniIp" type:"string"`

	// The ARN of the HSM.
	HSMARN *string `locationName:"HsmArn" type:"string"`

	// The HSM model type.
	HSMType *string `locationName:"HsmType" type:"string"`

	// The ARN of the IAM role assigned to the HSM.
	IAMRoleARN *string `locationName:"IamRoleArn" type:"string"`

	// The list of partitions on the HSM.
	Partitions []*string `type:"list"`

	// The date and time that the SSH key was last updated.
	SSHKeyLastUpdated *string `locationName:"SshKeyLastUpdated" type:"string"`

	// The public SSH key.
	SSHPublicKey *string `locationName:"SshPublicKey" type:"string"`

	// The serial number of the HSM.
	SerialNumber *string `type:"string"`

	// The date and time that the server certificate was last updated.
	ServerCertLastUpdated *string `type:"string"`

	// The URI of the certificate server.
	ServerCertURI *string `locationName:"ServerCertUri" type:"string"`

	// The HSM software version.
	SoftwareVersion *string `type:"string"`

	// The status of the HSM.
	Status *string `type:"string" enum:"HsmStatus"`

	// Contains additional information about the status of the HSM.
	StatusDetails *string `type:"string"`

	// The identifier of the subnet that the HSM is in.
	SubnetID *string `locationName:"SubnetId" type:"string"`

	// The subscription end date.
	SubscriptionEndDate *string `type:"string"`

	// The subscription start date.
	SubscriptionStartDate *string `type:"string"`

	// Specifies the type of subscription for the HSM.
	//
	//   PRODUCTION - The HSM is being used in a production environment.  TRIAL
	// - The HSM is being used in a product trial.
	SubscriptionType *string `type:"string" enum:"SubscriptionType"`

	// The identifier of the VPC that the HSM is in.
	VPCID *string `locationName:"VpcId" type:"string"`

	// The name of the HSM vendor.
	VendorName *string `type:"string"`

	metadataDescribeHSMOutput `json:"-" xml:"-"`
}

type metadataDescribeHSMOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeHSMOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHSMOutput) GoString() string {
	return s.String()
}

type DescribeLunaClientInput struct {
	// The certificate fingerprint.
	CertificateFingerprint *string `type:"string"`

	// The ARN of the client.
	ClientARN *string `locationName:"ClientArn" type:"string"`

	metadataDescribeLunaClientInput `json:"-" xml:"-"`
}

type metadataDescribeLunaClientInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLunaClientInput) GoString() string {
	return s.String()
}

type DescribeLunaClientOutput struct {
	// The certificate installed on the HSMs used by this client.
	Certificate *string `type:"string"`

	// The certificate fingerprint.
	CertificateFingerprint *string `type:"string"`

	// The ARN of the client.
	ClientARN *string `locationName:"ClientArn" type:"string"`

	// The label of the client.
	Label *string `type:"string"`

	// The date and time the client was last modified.
	LastModifiedTimestamp *string `type:"string"`

	metadataDescribeLunaClientOutput `json:"-" xml:"-"`
}

type metadataDescribeLunaClientOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLunaClientOutput) GoString() string {
	return s.String()
}

type GetConfigInput struct {
	// The ARN of the client.
	ClientARN *string `locationName:"ClientArn" type:"string" required:"true"`

	// The client version.
	ClientVersion *string `type:"string" required:"true" enum:"ClientVersion"`

	// A list of ARNs that identify the high-availability partition groups that
	// are associated with the client.
	HAPGList []*string `locationName:"HapgList" type:"list" required:"true"`

	metadataGetConfigInput `json:"-" xml:"-"`
}

type metadataGetConfigInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigInput) GoString() string {
	return s.String()
}

type GetConfigOutput struct {
	// The certificate file containing the server.pem files of the HSMs.
	ConfigCred *string `type:"string"`

	// The chrystoki.conf configuration file.
	ConfigFile *string `type:"string"`

	// The type of credentials.
	ConfigType *string `type:"string"`

	metadataGetConfigOutput `json:"-" xml:"-"`
}

type metadataGetConfigOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the ListAvailableZones action.
type ListAvailableZonesInput struct {
	metadataListAvailableZonesInput `json:"-" xml:"-"`
}

type metadataListAvailableZonesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAvailableZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableZonesInput) GoString() string {
	return s.String()
}

type ListAvailableZonesOutput struct {
	// The list of Availability Zones that have available AWS CloudHSM capacity.
	AZList []*string `type:"list"`

	metadataListAvailableZonesOutput `json:"-" xml:"-"`
}

type metadataListAvailableZonesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAvailableZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableZonesOutput) GoString() string {
	return s.String()
}

type ListHSMsInput struct {
	// The NextToken value from a previous call to ListHsms. Pass null if this is
	// the first call.
	NextToken *string `type:"string"`

	metadataListHSMsInput `json:"-" xml:"-"`
}

type metadataListHSMsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHSMsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHSMsInput) GoString() string {
	return s.String()
}

// Contains the output of the ListHsms operation.
type ListHSMsOutput struct {
	// The list of ARNs that identify the HSMs.
	HSMList []*string `locationName:"HsmList" type:"list"`

	// If not null, more results are available. Pass this value to ListHsms to retrieve
	// the next set of items.
	NextToken *string `type:"string"`

	metadataListHSMsOutput `json:"-" xml:"-"`
}

type metadataListHSMsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHSMsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHSMsOutput) GoString() string {
	return s.String()
}

type ListHapgsInput struct {
	// The NextToken value from a previous call to ListHapgs. Pass null if this
	// is the first call.
	NextToken *string `type:"string"`

	metadataListHapgsInput `json:"-" xml:"-"`
}

type metadataListHapgsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHapgsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHapgsInput) GoString() string {
	return s.String()
}

type ListHapgsOutput struct {
	// The list of high-availability partition groups.
	HAPGList []*string `locationName:"HapgList" type:"list" required:"true"`

	// If not null, more results are available. Pass this value to ListHapgs to
	// retrieve the next set of items.
	NextToken *string `type:"string"`

	metadataListHapgsOutput `json:"-" xml:"-"`
}

type metadataListHapgsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHapgsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHapgsOutput) GoString() string {
	return s.String()
}

type ListLunaClientsInput struct {
	// The NextToken value from a previous call to ListLunaClients. Pass null if
	// this is the first call.
	NextToken *string `type:"string"`

	metadataListLunaClientsInput `json:"-" xml:"-"`
}

type metadataListLunaClientsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListLunaClientsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLunaClientsInput) GoString() string {
	return s.String()
}

type ListLunaClientsOutput struct {
	// The list of clients.
	ClientList []*string `type:"list" required:"true"`

	// If not null, more results are available. Pass this to ListLunaClients to
	// retrieve the next set of items.
	NextToken *string `type:"string"`

	metadataListLunaClientsOutput `json:"-" xml:"-"`
}

type metadataListLunaClientsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListLunaClientsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLunaClientsOutput) GoString() string {
	return s.String()
}

type ModifyHAPGInput struct {
	// The ARN of the high-availability partition group to modify.
	HAPGARN *string `locationName:"HapgArn" type:"string" required:"true"`

	// The new label for the high-availability partition group.
	Label *string `type:"string"`

	// The list of partition serial numbers to make members of the high-availability
	// partition group.
	PartitionSerialList []*string `type:"list"`

	metadataModifyHAPGInput `json:"-" xml:"-"`
}

type metadataModifyHAPGInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyHAPGInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHAPGInput) GoString() string {
	return s.String()
}

type ModifyHAPGOutput struct {
	// The ARN of the high-availability partition group.
	HAPGARN *string `locationName:"HapgArn" type:"string"`

	metadataModifyHAPGOutput `json:"-" xml:"-"`
}

type metadataModifyHAPGOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyHAPGOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHAPGOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the ModifyHsm operation.
type ModifyHSMInput struct {
	// The new IP address for the elastic network interface (ENI) attached to the
	// HSM.
	//
	// If the HSM is moved to a different subnet, and an IP address is not specified,
	// an IP address will be randomly chosen from the CIDR range of the new subnet.
	ENIIP *string `locationName:"EniIp" type:"string"`

	// The new external ID.
	ExternalID *string `locationName:"ExternalId" type:"string"`

	// The ARN of the HSM to modify.
	HSMARN *string `locationName:"HsmArn" type:"string" required:"true"`

	// The new IAM role ARN.
	IAMRoleARN *string `locationName:"IamRoleArn" type:"string"`

	// The new identifier of the subnet that the HSM is in. The new subnet must
	// be in the same Availability Zone as the current subnet.
	SubnetID *string `locationName:"SubnetId" type:"string"`

	// The new IP address for the syslog monitoring server. The AWS CloudHSM service
	// only supports one syslog monitoring server.
	SyslogIP *string `locationName:"SyslogIp" type:"string"`

	metadataModifyHSMInput `json:"-" xml:"-"`
}

type metadataModifyHSMInput struct {
	SDKShapeTraits bool `locationName:"ModifyHsmRequest" type:"structure"`
}

// String returns the string representation
func (s ModifyHSMInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHSMInput) GoString() string {
	return s.String()
}

// Contains the output of the ModifyHsm operation.
type ModifyHSMOutput struct {
	// The ARN of the HSM.
	HSMARN *string `locationName:"HsmArn" type:"string"`

	metadataModifyHSMOutput `json:"-" xml:"-"`
}

type metadataModifyHSMOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyHSMOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHSMOutput) GoString() string {
	return s.String()
}

type ModifyLunaClientInput struct {
	// The new certificate for the client.
	Certificate *string `type:"string" required:"true"`

	// The ARN of the client.
	ClientARN *string `locationName:"ClientArn" type:"string" required:"true"`

	metadataModifyLunaClientInput `json:"-" xml:"-"`
}

type metadataModifyLunaClientInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLunaClientInput) GoString() string {
	return s.String()
}

type ModifyLunaClientOutput struct {
	// The ARN of the client.
	ClientARN *string `locationName:"ClientArn" type:"string"`

	metadataModifyLunaClientOutput `json:"-" xml:"-"`
}

type metadataModifyLunaClientOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLunaClientOutput) GoString() string {
	return s.String()
}

const (
	// @enum ClientVersion
	ClientVersion51 = "5.1"
	// @enum ClientVersion
	ClientVersion53 = "5.3"
)

const (
	// @enum CloudHsmObjectState
	CloudHsmObjectStateReady = "READY"
	// @enum CloudHsmObjectState
	CloudHsmObjectStateUpdating = "UPDATING"
	// @enum CloudHsmObjectState
	CloudHsmObjectStateDegraded = "DEGRADED"
)

const (
	// @enum HsmStatus
	HsmStatusPending = "PENDING"
	// @enum HsmStatus
	HsmStatusRunning = "RUNNING"
	// @enum HsmStatus
	HsmStatusUpdating = "UPDATING"
	// @enum HsmStatus
	HsmStatusSuspended = "SUSPENDED"
	// @enum HsmStatus
	HsmStatusTerminating = "TERMINATING"
	// @enum HsmStatus
	HsmStatusTerminated = "TERMINATED"
	// @enum HsmStatus
	HsmStatusDegraded = "DEGRADED"
)

// Specifies the type of subscription for the HSM.
//
//   PRODUCTION - The HSM is being used in a production environment.  TRIAL
// - The HSM is being used in a product trial.
const (
	// @enum SubscriptionType
	SubscriptionTypeProduction = "PRODUCTION"
)
