// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudsearch provides a client for Amazon CloudSearch.
package cloudsearch

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/service"
)

const opBuildSuggesters = "BuildSuggesters"

// BuildSuggestersRequest generates a request for the BuildSuggesters operation.
func (c *CloudSearch) BuildSuggestersRequest(input *BuildSuggestersInput) (req *service.Request, output *BuildSuggestersOutput) {
	op := &service.Operation{
		Name:       opBuildSuggesters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BuildSuggestersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BuildSuggestersOutput{}
	req.Data = output
	return
}

// Indexes the search suggestions. For more information, see Configuring Suggesters
// (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters)
// in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) BuildSuggesters(input *BuildSuggestersInput) (*BuildSuggestersOutput, error) {
	req, out := c.BuildSuggestersRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a request for the CreateDomain operation.
func (c *CloudSearch) CreateDomainRequest(input *CreateDomainInput) (req *service.Request, output *CreateDomainOutput) {
	op := &service.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDomainOutput{}
	req.Data = output
	return
}

// Creates a new search domain. For more information, see Creating a Search
// Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDefineAnalysisScheme = "DefineAnalysisScheme"

// DefineAnalysisSchemeRequest generates a request for the DefineAnalysisScheme operation.
func (c *CloudSearch) DefineAnalysisSchemeRequest(input *DefineAnalysisSchemeInput) (req *service.Request, output *DefineAnalysisSchemeOutput) {
	op := &service.Operation{
		Name:       opDefineAnalysisScheme,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineAnalysisSchemeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DefineAnalysisSchemeOutput{}
	req.Data = output
	return
}

// Configures an analysis scheme that can be applied to a text or text-array
// field to define language-specific text processing options. For more information,
// see Configuring Analysis Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DefineAnalysisScheme(input *DefineAnalysisSchemeInput) (*DefineAnalysisSchemeOutput, error) {
	req, out := c.DefineAnalysisSchemeRequest(input)
	err := req.Send()
	return out, err
}

const opDefineExpression = "DefineExpression"

// DefineExpressionRequest generates a request for the DefineExpression operation.
func (c *CloudSearch) DefineExpressionRequest(input *DefineExpressionInput) (req *service.Request, output *DefineExpressionOutput) {
	op := &service.Operation{
		Name:       opDefineExpression,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineExpressionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DefineExpressionOutput{}
	req.Data = output
	return
}

// Configures an Expression for the search domain. Used to create new expressions
// and modify existing ones. If the expression exists, the new configuration
// replaces the old one. For more information, see Configuring Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DefineExpression(input *DefineExpressionInput) (*DefineExpressionOutput, error) {
	req, out := c.DefineExpressionRequest(input)
	err := req.Send()
	return out, err
}

const opDefineIndexField = "DefineIndexField"

// DefineIndexFieldRequest generates a request for the DefineIndexField operation.
func (c *CloudSearch) DefineIndexFieldRequest(input *DefineIndexFieldInput) (req *service.Request, output *DefineIndexFieldOutput) {
	op := &service.Operation{
		Name:       opDefineIndexField,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineIndexFieldInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DefineIndexFieldOutput{}
	req.Data = output
	return
}

// Configures an IndexField for the search domain. Used to create new fields
// and modify existing ones. You must specify the name of the domain you are
// configuring and an index field configuration. The index field configuration
// specifies a unique name, the index field type, and the options you want to
// configure for the field. The options you can specify depend on the IndexFieldType.
// If the field exists, the new configuration replaces the old one. For more
// information, see Configuring Index Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DefineIndexField(input *DefineIndexFieldInput) (*DefineIndexFieldOutput, error) {
	req, out := c.DefineIndexFieldRequest(input)
	err := req.Send()
	return out, err
}

const opDefineSuggester = "DefineSuggester"

// DefineSuggesterRequest generates a request for the DefineSuggester operation.
func (c *CloudSearch) DefineSuggesterRequest(input *DefineSuggesterInput) (req *service.Request, output *DefineSuggesterOutput) {
	op := &service.Operation{
		Name:       opDefineSuggester,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineSuggesterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DefineSuggesterOutput{}
	req.Data = output
	return
}

// Configures a suggester for a domain. A suggester enables you to display possible
// matches before users finish typing their queries. When you configure a suggester,
// you must specify the name of the text field you want to search for possible
// matches and a unique name for the suggester. For more information, see Getting
// Search Suggestions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DefineSuggester(input *DefineSuggesterInput) (*DefineSuggesterOutput, error) {
	req, out := c.DefineSuggesterRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAnalysisScheme = "DeleteAnalysisScheme"

// DeleteAnalysisSchemeRequest generates a request for the DeleteAnalysisScheme operation.
func (c *CloudSearch) DeleteAnalysisSchemeRequest(input *DeleteAnalysisSchemeInput) (req *service.Request, output *DeleteAnalysisSchemeOutput) {
	op := &service.Operation{
		Name:       opDeleteAnalysisScheme,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAnalysisSchemeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAnalysisSchemeOutput{}
	req.Data = output
	return
}

// Deletes an analysis scheme. For more information, see Configuring Analysis
// Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DeleteAnalysisScheme(input *DeleteAnalysisSchemeInput) (*DeleteAnalysisSchemeOutput, error) {
	req, out := c.DeleteAnalysisSchemeRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a request for the DeleteDomain operation.
func (c *CloudSearch) DeleteDomainRequest(input *DeleteDomainInput) (req *service.Request, output *DeleteDomainOutput) {
	op := &service.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDomainOutput{}
	req.Data = output
	return
}

// Permanently deletes a search domain and all of its data. Once a domain has
// been deleted, it cannot be recovered. For more information, see Deleting
// a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteExpression = "DeleteExpression"

// DeleteExpressionRequest generates a request for the DeleteExpression operation.
func (c *CloudSearch) DeleteExpressionRequest(input *DeleteExpressionInput) (req *service.Request, output *DeleteExpressionOutput) {
	op := &service.Operation{
		Name:       opDeleteExpression,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteExpressionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteExpressionOutput{}
	req.Data = output
	return
}

// Removes an Expression from the search domain. For more information, see Configuring
// Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DeleteExpression(input *DeleteExpressionInput) (*DeleteExpressionOutput, error) {
	req, out := c.DeleteExpressionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIndexField = "DeleteIndexField"

// DeleteIndexFieldRequest generates a request for the DeleteIndexField operation.
func (c *CloudSearch) DeleteIndexFieldRequest(input *DeleteIndexFieldInput) (req *service.Request, output *DeleteIndexFieldOutput) {
	op := &service.Operation{
		Name:       opDeleteIndexField,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIndexFieldInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIndexFieldOutput{}
	req.Data = output
	return
}

// Removes an IndexField from the search domain. For more information, see Configuring
// Index Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DeleteIndexField(input *DeleteIndexFieldInput) (*DeleteIndexFieldOutput, error) {
	req, out := c.DeleteIndexFieldRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSuggester = "DeleteSuggester"

// DeleteSuggesterRequest generates a request for the DeleteSuggester operation.
func (c *CloudSearch) DeleteSuggesterRequest(input *DeleteSuggesterInput) (req *service.Request, output *DeleteSuggesterOutput) {
	op := &service.Operation{
		Name:       opDeleteSuggester,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSuggesterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSuggesterOutput{}
	req.Data = output
	return
}

// Deletes a suggester. For more information, see Getting Search Suggestions
// (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DeleteSuggester(input *DeleteSuggesterInput) (*DeleteSuggesterOutput, error) {
	req, out := c.DeleteSuggesterRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAnalysisSchemes = "DescribeAnalysisSchemes"

// DescribeAnalysisSchemesRequest generates a request for the DescribeAnalysisSchemes operation.
func (c *CloudSearch) DescribeAnalysisSchemesRequest(input *DescribeAnalysisSchemesInput) (req *service.Request, output *DescribeAnalysisSchemesOutput) {
	op := &service.Operation{
		Name:       opDescribeAnalysisSchemes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAnalysisSchemesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAnalysisSchemesOutput{}
	req.Data = output
	return
}

// Gets the analysis schemes configured for a domain. An analysis scheme defines
// language-specific text processing options for a text field. Can be limited
// to specific analysis schemes by name. By default, shows all analysis schemes
// and includes any pending changes to the configuration. Set the Deployed option
// to true to show the active configuration and exclude pending changes. For
// more information, see Configuring Analysis Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DescribeAnalysisSchemes(input *DescribeAnalysisSchemesInput) (*DescribeAnalysisSchemesOutput, error) {
	req, out := c.DescribeAnalysisSchemesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAvailabilityOptions = "DescribeAvailabilityOptions"

// DescribeAvailabilityOptionsRequest generates a request for the DescribeAvailabilityOptions operation.
func (c *CloudSearch) DescribeAvailabilityOptionsRequest(input *DescribeAvailabilityOptionsInput) (req *service.Request, output *DescribeAvailabilityOptionsOutput) {
	op := &service.Operation{
		Name:       opDescribeAvailabilityOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAvailabilityOptionsOutput{}
	req.Data = output
	return
}

// Gets the availability options configured for a domain. By default, shows
// the configuration with any pending changes. Set the Deployed option to true
// to show the active configuration and exclude pending changes. For more information,
// see Configuring Availability Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DescribeAvailabilityOptions(input *DescribeAvailabilityOptionsInput) (*DescribeAvailabilityOptionsOutput, error) {
	req, out := c.DescribeAvailabilityOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDomains = "DescribeDomains"

// DescribeDomainsRequest generates a request for the DescribeDomains operation.
func (c *CloudSearch) DescribeDomainsRequest(input *DescribeDomainsInput) (req *service.Request, output *DescribeDomainsOutput) {
	op := &service.Operation{
		Name:       opDescribeDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDomainsOutput{}
	req.Data = output
	return
}

// Gets information about the search domains owned by this account. Can be limited
// to specific domains. Shows all domains by default. To get the number of searchable
// documents in a domain, use the console or submit a matchall request to your
// domain's search endpoint: q=matchall&amp;q.parser=structured&amp;size=0.
// For more information, see Getting Information about a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DescribeDomains(input *DescribeDomainsInput) (*DescribeDomainsOutput, error) {
	req, out := c.DescribeDomainsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeExpressions = "DescribeExpressions"

// DescribeExpressionsRequest generates a request for the DescribeExpressions operation.
func (c *CloudSearch) DescribeExpressionsRequest(input *DescribeExpressionsInput) (req *service.Request, output *DescribeExpressionsOutput) {
	op := &service.Operation{
		Name:       opDescribeExpressions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExpressionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeExpressionsOutput{}
	req.Data = output
	return
}

// Gets the expressions configured for the search domain. Can be limited to
// specific expressions by name. By default, shows all expressions and includes
// any pending changes to the configuration. Set the Deployed option to true
// to show the active configuration and exclude pending changes. For more information,
// see Configuring Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DescribeExpressions(input *DescribeExpressionsInput) (*DescribeExpressionsOutput, error) {
	req, out := c.DescribeExpressionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIndexFields = "DescribeIndexFields"

// DescribeIndexFieldsRequest generates a request for the DescribeIndexFields operation.
func (c *CloudSearch) DescribeIndexFieldsRequest(input *DescribeIndexFieldsInput) (req *service.Request, output *DescribeIndexFieldsOutput) {
	op := &service.Operation{
		Name:       opDescribeIndexFields,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIndexFieldsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeIndexFieldsOutput{}
	req.Data = output
	return
}

// Gets information about the index fields configured for the search domain.
// Can be limited to specific fields by name. By default, shows all fields and
// includes any pending changes to the configuration. Set the Deployed option
// to true to show the active configuration and exclude pending changes. For
// more information, see Getting Domain Information (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DescribeIndexFields(input *DescribeIndexFieldsInput) (*DescribeIndexFieldsOutput, error) {
	req, out := c.DescribeIndexFieldsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeScalingParameters = "DescribeScalingParameters"

// DescribeScalingParametersRequest generates a request for the DescribeScalingParameters operation.
func (c *CloudSearch) DescribeScalingParametersRequest(input *DescribeScalingParametersInput) (req *service.Request, output *DescribeScalingParametersOutput) {
	op := &service.Operation{
		Name:       opDescribeScalingParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingParametersOutput{}
	req.Data = output
	return
}

// Gets the scaling parameters configured for a domain. A domain's scaling parameters
// specify the desired search instance type and replication count. For more
// information, see Configuring Scaling Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DescribeScalingParameters(input *DescribeScalingParametersInput) (*DescribeScalingParametersOutput, error) {
	req, out := c.DescribeScalingParametersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeServiceAccessPolicies = "DescribeServiceAccessPolicies"

// DescribeServiceAccessPoliciesRequest generates a request for the DescribeServiceAccessPolicies operation.
func (c *CloudSearch) DescribeServiceAccessPoliciesRequest(input *DescribeServiceAccessPoliciesInput) (req *service.Request, output *DescribeServiceAccessPoliciesOutput) {
	op := &service.Operation{
		Name:       opDescribeServiceAccessPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServiceAccessPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeServiceAccessPoliciesOutput{}
	req.Data = output
	return
}

// Gets information about the access policies that control access to the domain's
// document and search endpoints. By default, shows the configuration with any
// pending changes. Set the Deployed option to true to show the active configuration
// and exclude pending changes. For more information, see Configuring Access
// for a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DescribeServiceAccessPolicies(input *DescribeServiceAccessPoliciesInput) (*DescribeServiceAccessPoliciesOutput, error) {
	req, out := c.DescribeServiceAccessPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSuggesters = "DescribeSuggesters"

// DescribeSuggestersRequest generates a request for the DescribeSuggesters operation.
func (c *CloudSearch) DescribeSuggestersRequest(input *DescribeSuggestersInput) (req *service.Request, output *DescribeSuggestersOutput) {
	op := &service.Operation{
		Name:       opDescribeSuggesters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSuggestersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSuggestersOutput{}
	req.Data = output
	return
}

// Gets the suggesters configured for a domain. A suggester enables you to display
// possible matches before users finish typing their queries. Can be limited
// to specific suggesters by name. By default, shows all suggesters and includes
// any pending changes to the configuration. Set the Deployed option to true
// to show the active configuration and exclude pending changes. For more information,
// see Getting Search Suggestions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) DescribeSuggesters(input *DescribeSuggestersInput) (*DescribeSuggestersOutput, error) {
	req, out := c.DescribeSuggestersRequest(input)
	err := req.Send()
	return out, err
}

const opIndexDocuments = "IndexDocuments"

// IndexDocumentsRequest generates a request for the IndexDocuments operation.
func (c *CloudSearch) IndexDocumentsRequest(input *IndexDocumentsInput) (req *service.Request, output *IndexDocumentsOutput) {
	op := &service.Operation{
		Name:       opIndexDocuments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IndexDocumentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &IndexDocumentsOutput{}
	req.Data = output
	return
}

// Tells the search domain to start indexing its documents using the latest
// indexing options. This operation must be invoked to activate options whose
// OptionStatus is RequiresIndexDocuments.
func (c *CloudSearch) IndexDocuments(input *IndexDocumentsInput) (*IndexDocumentsOutput, error) {
	req, out := c.IndexDocumentsRequest(input)
	err := req.Send()
	return out, err
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest generates a request for the ListDomainNames operation.
func (c *CloudSearch) ListDomainNamesRequest(input *ListDomainNamesInput) (req *service.Request, output *ListDomainNamesOutput) {
	op := &service.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDomainNamesOutput{}
	req.Data = output
	return
}

// Lists all search domains owned by an account.
func (c *CloudSearch) ListDomainNames(input *ListDomainNamesInput) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAvailabilityOptions = "UpdateAvailabilityOptions"

// UpdateAvailabilityOptionsRequest generates a request for the UpdateAvailabilityOptions operation.
func (c *CloudSearch) UpdateAvailabilityOptionsRequest(input *UpdateAvailabilityOptionsInput) (req *service.Request, output *UpdateAvailabilityOptionsOutput) {
	op := &service.Operation{
		Name:       opUpdateAvailabilityOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAvailabilityOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAvailabilityOptionsOutput{}
	req.Data = output
	return
}

// Configures the availability options for a domain. Enabling the Multi-AZ option
// expands an Amazon CloudSearch domain to an additional Availability Zone in
// the same Region to increase fault tolerance in the event of a service disruption.
// Changes to the Multi-AZ option can take about half an hour to become active.
// For more information, see Configuring Availability Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) UpdateAvailabilityOptions(input *UpdateAvailabilityOptionsInput) (*UpdateAvailabilityOptionsOutput, error) {
	req, out := c.UpdateAvailabilityOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateScalingParameters = "UpdateScalingParameters"

// UpdateScalingParametersRequest generates a request for the UpdateScalingParameters operation.
func (c *CloudSearch) UpdateScalingParametersRequest(input *UpdateScalingParametersInput) (req *service.Request, output *UpdateScalingParametersOutput) {
	op := &service.Operation{
		Name:       opUpdateScalingParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScalingParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateScalingParametersOutput{}
	req.Data = output
	return
}

// Configures scaling parameters for a domain. A domain's scaling parameters
// specify the desired search instance type and replication count. Amazon CloudSearch
// will still automatically scale your domain based on the volume of data and
// traffic, but not below the desired instance type and replication count. If
// the Multi-AZ option is enabled, these values control the resources used per
// Availability Zone. For more information, see Configuring Scaling Options
// (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
func (c *CloudSearch) UpdateScalingParameters(input *UpdateScalingParametersInput) (*UpdateScalingParametersOutput, error) {
	req, out := c.UpdateScalingParametersRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateServiceAccessPolicies = "UpdateServiceAccessPolicies"

// UpdateServiceAccessPoliciesRequest generates a request for the UpdateServiceAccessPolicies operation.
func (c *CloudSearch) UpdateServiceAccessPoliciesRequest(input *UpdateServiceAccessPoliciesInput) (req *service.Request, output *UpdateServiceAccessPoliciesOutput) {
	op := &service.Operation{
		Name:       opUpdateServiceAccessPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceAccessPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateServiceAccessPoliciesOutput{}
	req.Data = output
	return
}

// Configures the access rules that control access to the domain's document
// and search endpoints. For more information, see  Configuring Access for an
// Amazon CloudSearch Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
// target="_blank).
func (c *CloudSearch) UpdateServiceAccessPolicies(input *UpdateServiceAccessPoliciesInput) (*UpdateServiceAccessPoliciesOutput, error) {
	req, out := c.UpdateServiceAccessPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
type AccessPoliciesStatus struct {
	// Access rules for a domain's document or search service endpoints. For more
	// information, see Configuring Access for a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
	// target="_blank) in the Amazon CloudSearch Developer Guide. The maximum size
	// of a policy document is 100 KB.
	Options *string `type:"string" required:"true"`

	// The status of domain configuration option.
	Status *OptionStatus `type:"structure" required:"true"`

	metadataAccessPoliciesStatus `json:"-" xml:"-"`
}

type metadataAccessPoliciesStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPoliciesStatus) GoString() string {
	return s.String()
}

// Synonyms, stopwords, and stemming options for an analysis scheme. Includes
// tokenization dictionary for Japanese.
type AnalysisOptions struct {
	// The level of algorithmic stemming to perform: none, minimal, light, or full.
	// The available levels vary depending on the language. For more information,
	// see Language Specific Text Processing Settings (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
	// target="_blank) in the Amazon CloudSearch Developer Guide
	AlgorithmicStemming *string `type:"string" enum:"AlgorithmicStemming"`

	// A JSON array that contains a collection of terms, tokens, readings and part
	// of speech for Japanese Tokenizaiton. The Japanese tokenization dictionary
	// enables you to override the default tokenization for selected terms. This
	// is only valid for Japanese language fields.
	JapaneseTokenizationDictionary *string `type:"string"`

	// A JSON object that contains a collection of string:value pairs that each
	// map a term to its stem. For example, {"term1": "stem1", "term2": "stem2",
	// "term3": "stem3"}. The stemming dictionary is applied in addition to any
	// algorithmic stemming. This enables you to override the results of the algorithmic
	// stemming to correct specific cases of overstemming or understemming. The
	// maximum size of a stemming dictionary is 500 KB.
	StemmingDictionary *string `type:"string"`

	// A JSON array of terms to ignore during indexing and searching. For example,
	// ["a", "an", "the", "of"]. The stopwords dictionary must explicitly list each
	// word you want to ignore. Wildcards and regular expressions are not supported.
	Stopwords *string `type:"string"`

	// A JSON object that defines synonym groups and aliases. A synonym group is
	// an array of arrays, where each sub-array is a group of terms where each term
	// in the group is considered a synonym of every other term in the group. The
	// aliases value is an object that contains a collection of string:value pairs
	// where the string specifies a term and the array of values specifies each
	// of the aliases for that term. An alias is considered a synonym of the specified
	// term, but the term is not considered a synonym of the alias. For more information
	// about specifying synonyms, see Synonyms (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms)
	// in the Amazon CloudSearch Developer Guide.
	Synonyms *string `type:"string"`

	metadataAnalysisOptions `json:"-" xml:"-"`
}

type metadataAnalysisOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AnalysisOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalysisOptions) GoString() string {
	return s.String()
}

// Configuration information for an analysis scheme. Each analysis scheme has
// a unique name and specifies the language of the text to be processed. The
// following options can be configured for an analysis scheme: Synonyms, Stopwords,
// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
type AnalysisScheme struct {
	// Synonyms, stopwords, and stemming options for an analysis scheme. Includes
	// tokenization dictionary for Japanese.
	AnalysisOptions *AnalysisOptions `type:"structure"`

	// An IETF RFC 4646 (http://tools.ietf.org/html/rfc4646" target="_blank) language
	// code or mul for multiple languages.
	AnalysisSchemeLanguage *string `type:"string" required:"true" enum:"AnalysisSchemeLanguage"`

	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	AnalysisSchemeName *string `type:"string" required:"true"`

	metadataAnalysisScheme `json:"-" xml:"-"`
}

type metadataAnalysisScheme struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AnalysisScheme) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalysisScheme) GoString() string {
	return s.String()
}

// The status and configuration of an AnalysisScheme.
type AnalysisSchemeStatus struct {
	// Configuration information for an analysis scheme. Each analysis scheme has
	// a unique name and specifies the language of the text to be processed. The
	// following options can be configured for an analysis scheme: Synonyms, Stopwords,
	// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
	Options *AnalysisScheme `type:"structure" required:"true"`

	// The status of domain configuration option.
	Status *OptionStatus `type:"structure" required:"true"`

	metadataAnalysisSchemeStatus `json:"-" xml:"-"`
}

type metadataAnalysisSchemeStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AnalysisSchemeStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalysisSchemeStatus) GoString() string {
	return s.String()
}

// The status and configuration of the domain's availability options.
type AvailabilityOptionsStatus struct {
	// The availability options configured for the domain.
	Options *bool `type:"boolean" required:"true"`

	// The status of domain configuration option.
	Status *OptionStatus `type:"structure" required:"true"`

	metadataAvailabilityOptionsStatus `json:"-" xml:"-"`
}

type metadataAvailabilityOptionsStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AvailabilityOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityOptionsStatus) GoString() string {
	return s.String()
}

// Container for the parameters to the BuildSuggester operation. Specifies the
// name of the domain you want to update.
type BuildSuggestersInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	metadataBuildSuggestersInput `json:"-" xml:"-"`
}

type metadataBuildSuggestersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BuildSuggestersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildSuggestersInput) GoString() string {
	return s.String()
}

// The result of a BuildSuggester request. Contains a list of the fields used
// for suggestions.
type BuildSuggestersOutput struct {
	// A list of field names.
	FieldNames []*string `type:"list"`

	metadataBuildSuggestersOutput `json:"-" xml:"-"`
}

type metadataBuildSuggestersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BuildSuggestersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BuildSuggestersOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the CreateDomain operation. Specifies a name
// for the new search domain.
type CreateDomainInput struct {
	// A name for the domain you are creating. Allowed characters are a-z (lower-case
	// letters), 0-9, and hyphen (-). Domain names must start with a letter or number
	// and be at least 3 and no more than 28 characters long.
	DomainName *string `type:"string" required:"true"`

	metadataCreateDomainInput `json:"-" xml:"-"`
}

type metadataCreateDomainInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// The result of a CreateDomainRequest. Contains the status of a newly created
// domain.
type CreateDomainOutput struct {
	// The current status of the search domain.
	DomainStatus *DomainStatus `type:"structure"`

	metadataCreateDomainOutput `json:"-" xml:"-"`
}

type metadataCreateDomainOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// Options for a field that contains an array of dates. Present if IndexFieldType
// specifies the field is of type date-array. All options are enabled by default.
type DateArrayOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`

	metadataDateArrayOptions `json:"-" xml:"-"`
}

type metadataDateArrayOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DateArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateArrayOptions) GoString() string {
	return s.String()
}

// Options for a date field. Dates and times are specified in UTC (Coordinated
// Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z. Present
// if IndexFieldType specifies the field is of type date. All options are enabled
// by default.
type DateOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `type:"string"`

	metadataDateOptions `json:"-" xml:"-"`
}

type metadataDateOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DateOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DateOptions) GoString() string {
	return s.String()
}

// Container for the parameters to the DefineAnalysisScheme operation. Specifies
// the name of the domain you want to update and the analysis scheme configuration.
type DefineAnalysisSchemeInput struct {
	// Configuration information for an analysis scheme. Each analysis scheme has
	// a unique name and specifies the language of the text to be processed. The
	// following options can be configured for an analysis scheme: Synonyms, Stopwords,
	// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
	AnalysisScheme *AnalysisScheme `type:"structure" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	metadataDefineAnalysisSchemeInput `json:"-" xml:"-"`
}

type metadataDefineAnalysisSchemeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DefineAnalysisSchemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineAnalysisSchemeInput) GoString() string {
	return s.String()
}

// The result of a DefineAnalysisScheme request. Contains the status of the
// newly-configured analysis scheme.
type DefineAnalysisSchemeOutput struct {
	// The status and configuration of an AnalysisScheme.
	AnalysisScheme *AnalysisSchemeStatus `type:"structure" required:"true"`

	metadataDefineAnalysisSchemeOutput `json:"-" xml:"-"`
}

type metadataDefineAnalysisSchemeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DefineAnalysisSchemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineAnalysisSchemeOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DefineExpression operation. Specifies
// the name of the domain you want to update and the expression you want to
// configure.
type DefineExpressionInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	// A named expression that can be evaluated at search time. Can be used to sort
	// the search results, define other expressions, or return computed information
	// in the search results.
	Expression *Expression `type:"structure" required:"true"`

	metadataDefineExpressionInput `json:"-" xml:"-"`
}

type metadataDefineExpressionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DefineExpressionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineExpressionInput) GoString() string {
	return s.String()
}

// The result of a DefineExpression request. Contains the status of the newly-configured
// expression.
type DefineExpressionOutput struct {
	// The value of an Expression and its current status.
	Expression *ExpressionStatus `type:"structure" required:"true"`

	metadataDefineExpressionOutput `json:"-" xml:"-"`
}

type metadataDefineExpressionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DefineExpressionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineExpressionOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DefineIndexField operation. Specifies
// the name of the domain you want to update and the index field configuration.
type DefineIndexFieldInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	// The index field and field options you want to configure.
	IndexField *IndexField `type:"structure" required:"true"`

	metadataDefineIndexFieldInput `json:"-" xml:"-"`
}

type metadataDefineIndexFieldInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DefineIndexFieldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineIndexFieldInput) GoString() string {
	return s.String()
}

// The result of a DefineIndexField request. Contains the status of the newly-configured
// index field.
type DefineIndexFieldOutput struct {
	// The value of an IndexField and its current status.
	IndexField *IndexFieldStatus `type:"structure" required:"true"`

	metadataDefineIndexFieldOutput `json:"-" xml:"-"`
}

type metadataDefineIndexFieldOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DefineIndexFieldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineIndexFieldOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DefineSuggester operation. Specifies
// the name of the domain you want to update and the suggester configuration.
type DefineSuggesterInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	// Configuration information for a search suggester. Each suggester has a unique
	// name and specifies the text field you want to use for suggestions. The following
	// options can be configured for a suggester: FuzzyMatching, SortExpression.
	Suggester *Suggester `type:"structure" required:"true"`

	metadataDefineSuggesterInput `json:"-" xml:"-"`
}

type metadataDefineSuggesterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DefineSuggesterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineSuggesterInput) GoString() string {
	return s.String()
}

// The result of a DefineSuggester request. Contains the status of the newly-configured
// suggester.
type DefineSuggesterOutput struct {
	// The value of a Suggester and its current status.
	Suggester *SuggesterStatus `type:"structure" required:"true"`

	metadataDefineSuggesterOutput `json:"-" xml:"-"`
}

type metadataDefineSuggesterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DefineSuggesterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefineSuggesterOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteAnalysisScheme operation. Specifies
// the name of the domain you want to update and the analysis scheme you want
// to delete.
type DeleteAnalysisSchemeInput struct {
	// The name of the analysis scheme you want to delete.
	AnalysisSchemeName *string `type:"string" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	metadataDeleteAnalysisSchemeInput `json:"-" xml:"-"`
}

type metadataDeleteAnalysisSchemeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAnalysisSchemeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnalysisSchemeInput) GoString() string {
	return s.String()
}

// The result of a DeleteAnalysisScheme request. Contains the status of the
// deleted analysis scheme.
type DeleteAnalysisSchemeOutput struct {
	// The status of the analysis scheme being deleted.
	AnalysisScheme *AnalysisSchemeStatus `type:"structure" required:"true"`

	metadataDeleteAnalysisSchemeOutput `json:"-" xml:"-"`
}

type metadataDeleteAnalysisSchemeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAnalysisSchemeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAnalysisSchemeOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteDomain operation. Specifies the
// name of the domain you want to delete.
type DeleteDomainInput struct {
	// The name of the domain you want to permanently delete.
	DomainName *string `type:"string" required:"true"`

	metadataDeleteDomainInput `json:"-" xml:"-"`
}

type metadataDeleteDomainInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// The result of a DeleteDomain request. Contains the status of a newly deleted
// domain, or no status if the domain has already been completely deleted.
type DeleteDomainOutput struct {
	// The current status of the search domain.
	DomainStatus *DomainStatus `type:"structure"`

	metadataDeleteDomainOutput `json:"-" xml:"-"`
}

type metadataDeleteDomainOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteExpression operation. Specifies
// the name of the domain you want to update and the name of the expression
// you want to delete.
type DeleteExpressionInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	// The name of the Expression to delete.
	ExpressionName *string `type:"string" required:"true"`

	metadataDeleteExpressionInput `json:"-" xml:"-"`
}

type metadataDeleteExpressionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteExpressionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteExpressionInput) GoString() string {
	return s.String()
}

// The result of a DeleteExpression request. Specifies the expression being
// deleted.
type DeleteExpressionOutput struct {
	// The status of the expression being deleted.
	Expression *ExpressionStatus `type:"structure" required:"true"`

	metadataDeleteExpressionOutput `json:"-" xml:"-"`
}

type metadataDeleteExpressionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteExpressionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteExpressionOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteIndexField operation. Specifies
// the name of the domain you want to update and the name of the index field
// you want to delete.
type DeleteIndexFieldInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	// The name of the index field your want to remove from the domain's indexing
	// options.
	IndexFieldName *string `type:"string" required:"true"`

	metadataDeleteIndexFieldInput `json:"-" xml:"-"`
}

type metadataDeleteIndexFieldInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIndexFieldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIndexFieldInput) GoString() string {
	return s.String()
}

// The result of a DeleteIndexField request.
type DeleteIndexFieldOutput struct {
	// The status of the index field being deleted.
	IndexField *IndexFieldStatus `type:"structure" required:"true"`

	metadataDeleteIndexFieldOutput `json:"-" xml:"-"`
}

type metadataDeleteIndexFieldOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIndexFieldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIndexFieldOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteSuggester operation. Specifies
// the name of the domain you want to update and name of the suggester you want
// to delete.
type DeleteSuggesterInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	// Specifies the name of the suggester you want to delete.
	SuggesterName *string `type:"string" required:"true"`

	metadataDeleteSuggesterInput `json:"-" xml:"-"`
}

type metadataDeleteSuggesterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteSuggesterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSuggesterInput) GoString() string {
	return s.String()
}

// The result of a DeleteSuggester request. Contains the status of the deleted
// suggester.
type DeleteSuggesterOutput struct {
	// The status of the suggester being deleted.
	Suggester *SuggesterStatus `type:"structure" required:"true"`

	metadataDeleteSuggesterOutput `json:"-" xml:"-"`
}

type metadataDeleteSuggesterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteSuggesterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSuggesterOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeAnalysisSchemes operation. Specifies
// the name of the domain you want to describe. To limit the response to particular
// analysis schemes, specify the names of the analysis schemes you want to describe.
// To show the active configuration and exclude any pending changes, set the
// Deployed option to true.
type DescribeAnalysisSchemesInput struct {
	// The analysis schemes you want to describe.
	AnalysisSchemeNames []*string `type:"list"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	DomainName *string `type:"string" required:"true"`

	metadataDescribeAnalysisSchemesInput `json:"-" xml:"-"`
}

type metadataDescribeAnalysisSchemesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAnalysisSchemesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAnalysisSchemesInput) GoString() string {
	return s.String()
}

// The result of a DescribeAnalysisSchemes request. Contains the analysis schemes
// configured for the domain specified in the request.
type DescribeAnalysisSchemesOutput struct {
	// The analysis scheme descriptions.
	AnalysisSchemes []*AnalysisSchemeStatus `type:"list" required:"true"`

	metadataDescribeAnalysisSchemesOutput `json:"-" xml:"-"`
}

type metadataDescribeAnalysisSchemesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAnalysisSchemesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAnalysisSchemesOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeAvailabilityOptions operation.
// Specifies the name of the domain you want to describe. To show the active
// configuration and exclude any pending changes, set the Deployed option to
// true.
type DescribeAvailabilityOptionsInput struct {
	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	DomainName *string `type:"string" required:"true"`

	metadataDescribeAvailabilityOptionsInput `json:"-" xml:"-"`
}

type metadataDescribeAvailabilityOptionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAvailabilityOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityOptionsInput) GoString() string {
	return s.String()
}

// The result of a DescribeAvailabilityOptions request. Indicates whether or
// not the Multi-AZ option is enabled for the domain specified in the request.
type DescribeAvailabilityOptionsOutput struct {
	// The availability options configured for the domain. Indicates whether Multi-AZ
	// is enabled for the domain.
	AvailabilityOptions *AvailabilityOptionsStatus `type:"structure"`

	metadataDescribeAvailabilityOptionsOutput `json:"-" xml:"-"`
}

type metadataDescribeAvailabilityOptionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAvailabilityOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAvailabilityOptionsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeDomains operation. By default
// shows the status of all domains. To restrict the response to particular domains,
// specify the names of the domains you want to describe.
type DescribeDomainsInput struct {
	// The names of the domains you want to include in the response.
	DomainNames []*string `type:"list"`

	metadataDescribeDomainsInput `json:"-" xml:"-"`
}

type metadataDescribeDomainsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainsInput) GoString() string {
	return s.String()
}

// The result of a DescribeDomains request. Contains the status of the domains
// specified in the request or all domains owned by the account.
type DescribeDomainsOutput struct {
	// A list that contains the status of each requested domain.
	DomainStatusList []*DomainStatus `type:"list" required:"true"`

	metadataDescribeDomainsOutput `json:"-" xml:"-"`
}

type metadataDescribeDomainsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeDomains operation. Specifies
// the name of the domain you want to describe. To restrict the response to
// particular expressions, specify the names of the expressions you want to
// describe. To show the active configuration and exclude any pending changes,
// set the Deployed option to true.
type DescribeExpressionsInput struct {
	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	DomainName *string `type:"string" required:"true"`

	// Limits the DescribeExpressions response to the specified expressions. If
	// not specified, all expressions are shown.
	ExpressionNames []*string `type:"list"`

	metadataDescribeExpressionsInput `json:"-" xml:"-"`
}

type metadataDescribeExpressionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeExpressionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExpressionsInput) GoString() string {
	return s.String()
}

// The result of a DescribeExpressions request. Contains the expressions configured
// for the domain specified in the request.
type DescribeExpressionsOutput struct {
	// The expressions configured for the domain.
	Expressions []*ExpressionStatus `type:"list" required:"true"`

	metadataDescribeExpressionsOutput `json:"-" xml:"-"`
}

type metadataDescribeExpressionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeExpressionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeExpressionsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeIndexFields operation. Specifies
// the name of the domain you want to describe. To restrict the response to
// particular index fields, specify the names of the index fields you want to
// describe. To show the active configuration and exclude any pending changes,
// set the Deployed option to true.
type DescribeIndexFieldsInput struct {
	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	DomainName *string `type:"string" required:"true"`

	// A list of the index fields you want to describe. If not specified, information
	// is returned for all configured index fields.
	FieldNames []*string `type:"list"`

	metadataDescribeIndexFieldsInput `json:"-" xml:"-"`
}

type metadataDescribeIndexFieldsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeIndexFieldsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIndexFieldsInput) GoString() string {
	return s.String()
}

// The result of a DescribeIndexFields request. Contains the index fields configured
// for the domain specified in the request.
type DescribeIndexFieldsOutput struct {
	// The index fields configured for the domain.
	IndexFields []*IndexFieldStatus `type:"list" required:"true"`

	metadataDescribeIndexFieldsOutput `json:"-" xml:"-"`
}

type metadataDescribeIndexFieldsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeIndexFieldsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIndexFieldsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeScalingParameters operation.
// Specifies the name of the domain you want to describe.
type DescribeScalingParametersInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	metadataDescribeScalingParametersInput `json:"-" xml:"-"`
}

type metadataDescribeScalingParametersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeScalingParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingParametersInput) GoString() string {
	return s.String()
}

// The result of a DescribeScalingParameters request. Contains the scaling parameters
// configured for the domain specified in the request.
type DescribeScalingParametersOutput struct {
	// The status and configuration of a search domain's scaling parameters.
	ScalingParameters *ScalingParametersStatus `type:"structure" required:"true"`

	metadataDescribeScalingParametersOutput `json:"-" xml:"-"`
}

type metadataDescribeScalingParametersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeScalingParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingParametersOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeServiceAccessPolicies operation.
// Specifies the name of the domain you want to describe. To show the active
// configuration and exclude any pending changes, set the Deployed option to
// true.
type DescribeServiceAccessPoliciesInput struct {
	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	DomainName *string `type:"string" required:"true"`

	metadataDescribeServiceAccessPoliciesInput `json:"-" xml:"-"`
}

type metadataDescribeServiceAccessPoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceAccessPoliciesInput) GoString() string {
	return s.String()
}

// The result of a DescribeServiceAccessPolicies request.
type DescribeServiceAccessPoliciesOutput struct {
	// The access rules configured for the domain specified in the request.
	AccessPolicies *AccessPoliciesStatus `type:"structure" required:"true"`

	metadataDescribeServiceAccessPoliciesOutput `json:"-" xml:"-"`
}

type metadataDescribeServiceAccessPoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceAccessPoliciesOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeSuggester operation. Specifies
// the name of the domain you want to describe. To restrict the response to
// particular suggesters, specify the names of the suggesters you want to describe.
// To show the active configuration and exclude any pending changes, set the
// Deployed option to true.
type DescribeSuggestersInput struct {
	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	DomainName *string `type:"string" required:"true"`

	// The suggesters you want to describe.
	SuggesterNames []*string `type:"list"`

	metadataDescribeSuggestersInput `json:"-" xml:"-"`
}

type metadataDescribeSuggestersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSuggestersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSuggestersInput) GoString() string {
	return s.String()
}

// The result of a DescribeSuggesters request.
type DescribeSuggestersOutput struct {
	// The suggesters configured for the domain specified in the request.
	Suggesters []*SuggesterStatus `type:"list" required:"true"`

	metadataDescribeSuggestersOutput `json:"-" xml:"-"`
}

type metadataDescribeSuggestersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSuggestersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSuggestersOutput) GoString() string {
	return s.String()
}

// Options for a search suggester.
type DocumentSuggesterOptions struct {
	// The level of fuzziness allowed when suggesting matches for a string: none,
	// low, or high. With none, the specified string is treated as an exact prefix.
	// With low, suggestions must differ from the specified string by no more than
	// one character. With high, suggestions can differ by up to two characters.
	// The default is none.
	FuzzyMatching *string `type:"string" enum:"SuggesterFuzzyMatching"`

	// An expression that computes a score for each suggestion to control how they
	// are sorted. The scores are rounded to the nearest integer, with a floor of
	// 0 and a ceiling of 2^31-1. A document's relevance score is not computed for
	// suggestions, so sort expressions cannot reference the _score value. To sort
	// suggestions using a numeric field or existing expression, simply specify
	// the name of the field or expression. If no expression is configured for the
	// suggester, the suggestions are sorted with the closest matches listed first.
	SortExpression *string `type:"string"`

	// The name of the index field you want to use for suggestions.
	SourceField *string `type:"string" required:"true"`

	metadataDocumentSuggesterOptions `json:"-" xml:"-"`
}

type metadataDocumentSuggesterOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DocumentSuggesterOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentSuggesterOptions) GoString() string {
	return s.String()
}

// The current status of the search domain.
type DomainStatus struct {
	// The Amazon Resource Name (ARN) of the search domain. See Identifiers for
	// IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html"
	// target="_blank) in Using AWS Identity and Access Management for more information.
	ARN *string `type:"string"`

	// True if the search domain is created. It can take several minutes to initialize
	// a domain when CreateDomain is called. Newly created search domains are returned
	// from DescribeDomains with a false value for Created until domain creation
	// is complete.
	Created *bool `type:"boolean"`

	// True if the search domain has been deleted. The system must clean up resources
	// dedicated to the search domain when DeleteDomain is called. Newly deleted
	// search domains are returned from DescribeDomains with a true value for IsDeleted
	// for several minutes until resource cleanup is complete.
	Deleted *bool `type:"boolean"`

	// The service endpoint for updating documents in a search domain.
	DocService *ServiceEndpoint `type:"structure"`

	// An internally generated unique identifier for a domain.
	DomainID *string `locationName:"DomainId" type:"string" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	Limits *Limits `type:"structure"`

	// True if processing is being done to activate the current domain configuration.
	Processing *bool `type:"boolean"`

	// True if IndexDocuments needs to be called to activate the current domain
	// configuration.
	RequiresIndexDocuments *bool `type:"boolean" required:"true"`

	// The number of search instances that are available to process search requests.
	SearchInstanceCount *int64 `type:"integer"`

	// The instance type that is being used to process search requests.
	SearchInstanceType *string `type:"string"`

	// The number of partitions across which the search index is spread.
	SearchPartitionCount *int64 `type:"integer"`

	// The service endpoint for requesting search results from a search domain.
	SearchService *ServiceEndpoint `type:"structure"`

	metadataDomainStatus `json:"-" xml:"-"`
}

type metadataDomainStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DomainStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainStatus) GoString() string {
	return s.String()
}

// Options for a field that contains an array of double-precision 64-bit floating
// point values. Present if IndexFieldType specifies the field is of type double-array.
// All options are enabled by default.
type DoubleArrayOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *float64 `type:"double"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`

	metadataDoubleArrayOptions `json:"-" xml:"-"`
}

type metadataDoubleArrayOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DoubleArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DoubleArrayOptions) GoString() string {
	return s.String()
}

// Options for a double-precision 64-bit floating point field. Present if IndexFieldType
// specifies the field is of type double. All options are enabled by default.
type DoubleOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	// This can be important if you are using the field in an expression and that
	// field is not present in every document.
	DefaultValue *float64 `type:"double"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// The name of the source field to map to the field.
	SourceField *string `type:"string"`

	metadataDoubleOptions `json:"-" xml:"-"`
}

type metadataDoubleOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DoubleOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DoubleOptions) GoString() string {
	return s.String()
}

// A named expression that can be evaluated at search time. Can be used to sort
// the search results, define other expressions, or return computed information
// in the search results.
type Expression struct {
	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	ExpressionName *string `type:"string" required:"true"`

	// The expression to evaluate for sorting while processing a search request.
	// The Expression syntax is based on JavaScript expressions. For more information,
	// see Configuring Expressions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
	// target="_blank) in the Amazon CloudSearch Developer Guide.
	ExpressionValue *string `type:"string" required:"true"`

	metadataExpression `json:"-" xml:"-"`
}

type metadataExpression struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Expression) GoString() string {
	return s.String()
}

// The value of an Expression and its current status.
type ExpressionStatus struct {
	// The expression that is evaluated for sorting while processing a search request.
	Options *Expression `type:"structure" required:"true"`

	// The status of domain configuration option.
	Status *OptionStatus `type:"structure" required:"true"`

	metadataExpressionStatus `json:"-" xml:"-"`
}

type metadataExpressionStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ExpressionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpressionStatus) GoString() string {
	return s.String()
}

// Container for the parameters to the IndexDocuments operation. Specifies the
// name of the domain you want to re-index.
type IndexDocumentsInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	metadataIndexDocumentsInput `json:"-" xml:"-"`
}

type metadataIndexDocumentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IndexDocumentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocumentsInput) GoString() string {
	return s.String()
}

// The result of an IndexDocuments request. Contains the status of the indexing
// operation, including the fields being indexed.
type IndexDocumentsOutput struct {
	// The names of the fields that are currently being indexed.
	FieldNames []*string `type:"list"`

	metadataIndexDocumentsOutput `json:"-" xml:"-"`
}

type metadataIndexDocumentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IndexDocumentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocumentsOutput) GoString() string {
	return s.String()
}

// Configuration information for a field in the index, including its name, type,
// and options. The supported options depend on the IndexFieldType.
type IndexField struct {
	// Options for a field that contains an array of dates. Present if IndexFieldType
	// specifies the field is of type date-array. All options are enabled by default.
	DateArrayOptions *DateArrayOptions `type:"structure"`

	// Options for a date field. Dates and times are specified in UTC (Coordinated
	// Universal Time) according to IETF RFC3339: yyyy-mm-ddT00:00:00Z. Present
	// if IndexFieldType specifies the field is of type date. All options are enabled
	// by default.
	DateOptions *DateOptions `type:"structure"`

	// Options for a field that contains an array of double-precision 64-bit floating
	// point values. Present if IndexFieldType specifies the field is of type double-array.
	// All options are enabled by default.
	DoubleArrayOptions *DoubleArrayOptions `type:"structure"`

	// Options for a double-precision 64-bit floating point field. Present if IndexFieldType
	// specifies the field is of type double. All options are enabled by default.
	DoubleOptions *DoubleOptions `type:"structure"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	IndexFieldName *string `type:"string" required:"true"`

	// The type of field. The valid options for a field depend on the field type.
	// For more information about the supported field types, see Configuring Index
	// Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
	// target="_blank) in the Amazon CloudSearch Developer Guide.
	IndexFieldType *string `type:"string" required:"true" enum:"IndexFieldType"`

	// Options for a field that contains an array of 64-bit signed integers. Present
	// if IndexFieldType specifies the field is of type int-array. All options are
	// enabled by default.
	IntArrayOptions *IntArrayOptions `type:"structure"`

	// Options for a 64-bit signed integer field. Present if IndexFieldType specifies
	// the field is of type int. All options are enabled by default.
	IntOptions *IntOptions `type:"structure"`

	// Options for a latlon field. A latlon field contains a location stored as
	// a latitude and longitude value pair. Present if IndexFieldType specifies
	// the field is of type latlon. All options are enabled by default.
	LatLonOptions *LatLonOptions `type:"structure"`

	// Options for a field that contains an array of literal strings. Present if
	// IndexFieldType specifies the field is of type literal-array. All options
	// are enabled by default.
	LiteralArrayOptions *LiteralArrayOptions `type:"structure"`

	// Options for literal field. Present if IndexFieldType specifies the field
	// is of type literal. All options are enabled by default.
	LiteralOptions *LiteralOptions `type:"structure"`

	// Options for a field that contains an array of text strings. Present if IndexFieldType
	// specifies the field is of type text-array. A text-array field is always searchable.
	// All options are enabled by default.
	TextArrayOptions *TextArrayOptions `type:"structure"`

	// Options for text field. Present if IndexFieldType specifies the field is
	// of type text. A text field is always searchable. All options are enabled
	// by default.
	TextOptions *TextOptions `type:"structure"`

	metadataIndexField `json:"-" xml:"-"`
}

type metadataIndexField struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IndexField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexField) GoString() string {
	return s.String()
}

// The value of an IndexField and its current status.
type IndexFieldStatus struct {
	// Configuration information for a field in the index, including its name, type,
	// and options. The supported options depend on the IndexFieldType.
	Options *IndexField `type:"structure" required:"true"`

	// The status of domain configuration option.
	Status *OptionStatus `type:"structure" required:"true"`

	metadataIndexFieldStatus `json:"-" xml:"-"`
}

type metadataIndexFieldStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IndexFieldStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexFieldStatus) GoString() string {
	return s.String()
}

// Options for a field that contains an array of 64-bit signed integers. Present
// if IndexFieldType specifies the field is of type int-array. All options are
// enabled by default.
type IntArrayOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *int64 `type:"long"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`

	metadataIntArrayOptions `json:"-" xml:"-"`
}

type metadataIntArrayOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IntArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntArrayOptions) GoString() string {
	return s.String()
}

// Options for a 64-bit signed integer field. Present if IndexFieldType specifies
// the field is of type int. All options are enabled by default.
type IntOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	// This can be important if you are using the field in an expression and that
	// field is not present in every document.
	DefaultValue *int64 `type:"long"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// The name of the source field to map to the field.
	SourceField *string `type:"string"`

	metadataIntOptions `json:"-" xml:"-"`
}

type metadataIntOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IntOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IntOptions) GoString() string {
	return s.String()
}

// Options for a latlon field. A latlon field contains a location stored as
// a latitude and longitude value pair. Present if IndexFieldType specifies
// the field is of type latlon. All options are enabled by default.
type LatLonOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `type:"string"`

	metadataLatLonOptions `json:"-" xml:"-"`
}

type metadataLatLonOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LatLonOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LatLonOptions) GoString() string {
	return s.String()
}

type Limits struct {
	MaximumPartitionCount *int64 `type:"integer" required:"true"`

	MaximumReplicationCount *int64 `type:"integer" required:"true"`

	metadataLimits `json:"-" xml:"-"`
}

type metadataLimits struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Limits) GoString() string {
	return s.String()
}

type ListDomainNamesInput struct {
	metadataListDomainNamesInput `json:"-" xml:"-"`
}

type metadataListDomainNamesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesInput) GoString() string {
	return s.String()
}

// The result of a ListDomainNames request. Contains a list of the domains owned
// by an account.
type ListDomainNamesOutput struct {
	// The names of the search domains owned by an account.
	DomainNames map[string]*string `type:"map"`

	metadataListDomainNamesOutput `json:"-" xml:"-"`
}

type metadataListDomainNamesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesOutput) GoString() string {
	return s.String()
}

// Options for a field that contains an array of literal strings. Present if
// IndexFieldType specifies the field is of type literal-array. All options
// are enabled by default.
type LiteralArrayOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`

	metadataLiteralArrayOptions `json:"-" xml:"-"`
}

type metadataLiteralArrayOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LiteralArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LiteralArrayOptions) GoString() string {
	return s.String()
}

// Options for literal field. Present if IndexFieldType specifies the field
// is of type literal. All options are enabled by default.
type LiteralOptions struct {
	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether facet information can be returned for the field.
	FacetEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the contents of the field are searchable.
	SearchEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `type:"string"`

	metadataLiteralOptions `json:"-" xml:"-"`
}

type metadataLiteralOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LiteralOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LiteralOptions) GoString() string {
	return s.String()
}

// The status of domain configuration option.
type OptionStatus struct {
	// A timestamp for when this option was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Indicates that the option will be deleted once processing is complete.
	PendingDeletion *bool `type:"boolean"`

	// The state of processing a change to an option. Possible values:
	//
	//   RequiresIndexDocuments: the option's latest value will not be deployed
	// until IndexDocuments has been called and indexing is complete.  Processing:
	// the option's latest value is in the process of being activated.   Active:
	// the option's latest value is completely deployed.  FailedToValidate: the
	// option value is not compatible with the domain's data and cannot be used
	// to index the data. You must either modify the option value or update or remove
	// the incompatible documents.
	State *string `type:"string" required:"true" enum:"OptionState"`

	// A timestamp for when this option was last updated.
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A unique integer that indicates when this option was last updated.
	UpdateVersion *int64 `type:"integer"`

	metadataOptionStatus `json:"-" xml:"-"`
}

type metadataOptionStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionStatus) GoString() string {
	return s.String()
}

// The desired instance type and desired number of replicas of each index partition.
type ScalingParameters struct {
	// The instance type that you want to preconfigure for your domain. For example,
	// search.m1.small.
	DesiredInstanceType *string `type:"string" enum:"PartitionInstanceType"`

	// The number of partitions you want to preconfigure for your domain. Only valid
	// when you select m2.2xlarge as the desired instance type.
	DesiredPartitionCount *int64 `type:"integer"`

	// The number of replicas you want to preconfigure for each index partition.
	DesiredReplicationCount *int64 `type:"integer"`

	metadataScalingParameters `json:"-" xml:"-"`
}

type metadataScalingParameters struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ScalingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingParameters) GoString() string {
	return s.String()
}

// The status and configuration of a search domain's scaling parameters.
type ScalingParametersStatus struct {
	// The desired instance type and desired number of replicas of each index partition.
	Options *ScalingParameters `type:"structure" required:"true"`

	// The status of domain configuration option.
	Status *OptionStatus `type:"structure" required:"true"`

	metadataScalingParametersStatus `json:"-" xml:"-"`
}

type metadataScalingParametersStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ScalingParametersStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingParametersStatus) GoString() string {
	return s.String()
}

// The endpoint to which service requests can be submitted.
type ServiceEndpoint struct {
	// The endpoint to which service requests can be submitted. For example, search-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com
	// or doc-imdb-movies-oopcnjfn6ugofer3zx5iadxxca.eu-west-1.cloudsearch.amazonaws.com.
	Endpoint *string `type:"string"`

	metadataServiceEndpoint `json:"-" xml:"-"`
}

type metadataServiceEndpoint struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ServiceEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceEndpoint) GoString() string {
	return s.String()
}

// Configuration information for a search suggester. Each suggester has a unique
// name and specifies the text field you want to use for suggestions. The following
// options can be configured for a suggester: FuzzyMatching, SortExpression.
type Suggester struct {
	// Options for a search suggester.
	DocumentSuggesterOptions *DocumentSuggesterOptions `type:"structure" required:"true"`

	// Names must begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore).
	SuggesterName *string `type:"string" required:"true"`

	metadataSuggester `json:"-" xml:"-"`
}

type metadataSuggester struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Suggester) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Suggester) GoString() string {
	return s.String()
}

// The value of a Suggester and its current status.
type SuggesterStatus struct {
	// Configuration information for a search suggester. Each suggester has a unique
	// name and specifies the text field you want to use for suggestions. The following
	// options can be configured for a suggester: FuzzyMatching, SortExpression.
	Options *Suggester `type:"structure" required:"true"`

	// The status of domain configuration option.
	Status *OptionStatus `type:"structure" required:"true"`

	metadataSuggesterStatus `json:"-" xml:"-"`
}

type metadataSuggesterStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SuggesterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuggesterStatus) GoString() string {
	return s.String()
}

// Options for a field that contains an array of text strings. Present if IndexFieldType
// specifies the field is of type text-array. A text-array field is always searchable.
// All options are enabled by default.
type TextArrayOptions struct {
	// The name of an analysis scheme for a text-array field.
	AnalysisScheme *string `type:"string"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether highlights can be returned for the field.
	HighlightEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// A list of source fields to map to the field.
	SourceFields *string `type:"string"`

	metadataTextArrayOptions `json:"-" xml:"-"`
}

type metadataTextArrayOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TextArrayOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextArrayOptions) GoString() string {
	return s.String()
}

// Options for text field. Present if IndexFieldType specifies the field is
// of type text. A text field is always searchable. All options are enabled
// by default.
type TextOptions struct {
	// The name of an analysis scheme for a text field.
	AnalysisScheme *string `type:"string"`

	// A value to use for the field if the field isn't specified for a document.
	DefaultValue *string `type:"string"`

	// Whether highlights can be returned for the field.
	HighlightEnabled *bool `type:"boolean"`

	// Whether the contents of the field can be returned in the search results.
	ReturnEnabled *bool `type:"boolean"`

	// Whether the field can be used to sort the search results.
	SortEnabled *bool `type:"boolean"`

	// A string that represents the name of an index field. CloudSearch supports
	// regular index fields as well as dynamic fields. A dynamic field's name defines
	// a pattern that begins or ends with a wildcard. Any document fields that don't
	// map to a regular index field but do match a dynamic field's pattern are configured
	// with the dynamic field's indexing options.
	//
	// Regular field names begin with a letter and can contain the following characters:
	// a-z (lowercase), 0-9, and _ (underscore). Dynamic field names must begin
	// or end with a wildcard (*). The wildcard can also be the only character in
	// a dynamic field name. Multiple wildcards, and wildcards embedded within a
	// string are not supported.
	//
	// The name score is reserved and cannot be used as a field name. To reference
	// a document's ID, you can use the name _id.
	SourceField *string `type:"string"`

	metadataTextOptions `json:"-" xml:"-"`
}

type metadataTextOptions struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TextOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextOptions) GoString() string {
	return s.String()
}

// Container for the parameters to the UpdateAvailabilityOptions operation.
// Specifies the name of the domain you want to update and the Multi-AZ availability
// option.
type UpdateAvailabilityOptionsInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	// You expand an existing search domain to a second Availability Zone by setting
	// the Multi-AZ option to true. Similarly, you can turn off the Multi-AZ option
	// to downgrade the domain to a single Availability Zone by setting the Multi-AZ
	// option to false.
	MultiAZ *bool `type:"boolean" required:"true"`

	metadataUpdateAvailabilityOptionsInput `json:"-" xml:"-"`
}

type metadataUpdateAvailabilityOptionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAvailabilityOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAvailabilityOptionsInput) GoString() string {
	return s.String()
}

// The result of a UpdateAvailabilityOptions request. Contains the status of
// the domain's availability options.
type UpdateAvailabilityOptionsOutput struct {
	// The newly-configured availability options. Indicates whether Multi-AZ is
	// enabled for the domain.
	AvailabilityOptions *AvailabilityOptionsStatus `type:"structure"`

	metadataUpdateAvailabilityOptionsOutput `json:"-" xml:"-"`
}

type metadataUpdateAvailabilityOptionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAvailabilityOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAvailabilityOptionsOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the UpdateScalingParameters operation. Specifies
// the name of the domain you want to update and the scaling parameters you
// want to configure.
type UpdateScalingParametersInput struct {
	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	// The desired instance type and desired number of replicas of each index partition.
	ScalingParameters *ScalingParameters `type:"structure" required:"true"`

	metadataUpdateScalingParametersInput `json:"-" xml:"-"`
}

type metadataUpdateScalingParametersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateScalingParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateScalingParametersInput) GoString() string {
	return s.String()
}

// The result of a UpdateScalingParameters request. Contains the status of the
// newly-configured scaling parameters.
type UpdateScalingParametersOutput struct {
	// The status and configuration of a search domain's scaling parameters.
	ScalingParameters *ScalingParametersStatus `type:"structure" required:"true"`

	metadataUpdateScalingParametersOutput `json:"-" xml:"-"`
}

type metadataUpdateScalingParametersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateScalingParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateScalingParametersOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the UpdateServiceAccessPolicies operation.
// Specifies the name of the domain you want to update and the access rules
// you want to configure.
type UpdateServiceAccessPoliciesInput struct {
	// The access rules you want to configure. These rules replace any existing
	// rules.
	AccessPolicies *string `type:"string" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	DomainName *string `type:"string" required:"true"`

	metadataUpdateServiceAccessPoliciesInput `json:"-" xml:"-"`
}

type metadataUpdateServiceAccessPoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceAccessPoliciesInput) GoString() string {
	return s.String()
}

// The result of an UpdateServiceAccessPolicies request. Contains the new access
// policies.
type UpdateServiceAccessPoliciesOutput struct {
	// The access rules configured for the domain.
	AccessPolicies *AccessPoliciesStatus `type:"structure" required:"true"`

	metadataUpdateServiceAccessPoliciesOutput `json:"-" xml:"-"`
}

type metadataUpdateServiceAccessPoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceAccessPoliciesOutput) GoString() string {
	return s.String()
}

const (
	// @enum AlgorithmicStemming
	AlgorithmicStemmingNone = "none"
	// @enum AlgorithmicStemming
	AlgorithmicStemmingMinimal = "minimal"
	// @enum AlgorithmicStemming
	AlgorithmicStemmingLight = "light"
	// @enum AlgorithmicStemming
	AlgorithmicStemmingFull = "full"
)

// An IETF RFC 4646 (http://tools.ietf.org/html/rfc4646" target="_blank) language
// code or mul for multiple languages.
const (
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageAr = "ar"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageBg = "bg"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageCa = "ca"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageCs = "cs"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageDa = "da"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageDe = "de"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageEl = "el"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageEn = "en"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageEs = "es"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageEu = "eu"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageFa = "fa"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageFi = "fi"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageFr = "fr"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageGa = "ga"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageGl = "gl"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageHe = "he"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageHi = "hi"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageHu = "hu"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageHy = "hy"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageId = "id"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageIt = "it"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageJa = "ja"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageKo = "ko"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageLv = "lv"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageMul = "mul"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageNl = "nl"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageNo = "no"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguagePt = "pt"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageRo = "ro"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageRu = "ru"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageSv = "sv"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageTh = "th"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageTr = "tr"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageZhHans = "zh-Hans"
	// @enum AnalysisSchemeLanguage
	AnalysisSchemeLanguageZhHant = "zh-Hant"
)

// The type of field. The valid options for a field depend on the field type.
// For more information about the supported field types, see Configuring Index
// Fields (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
// target="_blank) in the Amazon CloudSearch Developer Guide.
const (
	// @enum IndexFieldType
	IndexFieldTypeInt = "int"
	// @enum IndexFieldType
	IndexFieldTypeDouble = "double"
	// @enum IndexFieldType
	IndexFieldTypeLiteral = "literal"
	// @enum IndexFieldType
	IndexFieldTypeText = "text"
	// @enum IndexFieldType
	IndexFieldTypeDate = "date"
	// @enum IndexFieldType
	IndexFieldTypeLatlon = "latlon"
	// @enum IndexFieldType
	IndexFieldTypeIntArray = "int-array"
	// @enum IndexFieldType
	IndexFieldTypeDoubleArray = "double-array"
	// @enum IndexFieldType
	IndexFieldTypeLiteralArray = "literal-array"
	// @enum IndexFieldType
	IndexFieldTypeTextArray = "text-array"
	// @enum IndexFieldType
	IndexFieldTypeDateArray = "date-array"
)

// The state of processing a change to an option. One of:
//
//  RequiresIndexDocuments: The option's latest value will not be deployed
// until IndexDocuments has been called and indexing is complete. Processing:
// The option's latest value is in the process of being activated. Active: The
// option's latest value is fully deployed.  FailedToValidate: The option value
// is not compatible with the domain's data and cannot be used to index the
// data. You must either modify the option value or update or remove the incompatible
// documents.
const (
	// @enum OptionState
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"
	// @enum OptionState
	OptionStateProcessing = "Processing"
	// @enum OptionState
	OptionStateActive = "Active"
	// @enum OptionState
	OptionStateFailedToValidate = "FailedToValidate"
)

// The instance type (such as search.m1.small) on which an index partition is
// hosted.
const (
	// @enum PartitionInstanceType
	PartitionInstanceTypeSearchM1Small = "search.m1.small"
	// @enum PartitionInstanceType
	PartitionInstanceTypeSearchM1Large = "search.m1.large"
	// @enum PartitionInstanceType
	PartitionInstanceTypeSearchM2Xlarge = "search.m2.xlarge"
	// @enum PartitionInstanceType
	PartitionInstanceTypeSearchM22xlarge = "search.m2.2xlarge"
	// @enum PartitionInstanceType
	PartitionInstanceTypeSearchM3Medium = "search.m3.medium"
	// @enum PartitionInstanceType
	PartitionInstanceTypeSearchM3Large = "search.m3.large"
	// @enum PartitionInstanceType
	PartitionInstanceTypeSearchM3Xlarge = "search.m3.xlarge"
	// @enum PartitionInstanceType
	PartitionInstanceTypeSearchM32xlarge = "search.m3.2xlarge"
)

const (
	// @enum SuggesterFuzzyMatching
	SuggesterFuzzyMatchingNone = "none"
	// @enum SuggesterFuzzyMatching
	SuggesterFuzzyMatchingLow = "low"
	// @enum SuggesterFuzzyMatching
	SuggesterFuzzyMatchingHigh = "high"
)
