// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package codepipeline_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/service/codepipeline"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleCodePipeline_AcknowledgeJob() {
	svc := codepipeline.New(nil)

	params := &codepipeline.AcknowledgeJobInput{
		JobID: aws.String("JobId"), // Required
		Nonce: aws.String("Nonce"), // Required
	}
	resp, err := svc.AcknowledgeJob(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_AcknowledgeThirdPartyJob() {
	svc := codepipeline.New(nil)

	params := &codepipeline.AcknowledgeThirdPartyJobInput{
		ClientToken: aws.String("ClientToken"),     // Required
		JobID:       aws.String("ThirdPartyJobId"), // Required
		Nonce:       aws.String("Nonce"),           // Required
	}
	resp, err := svc.AcknowledgeThirdPartyJob(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_CreateCustomActionType() {
	svc := codepipeline.New(nil)

	params := &codepipeline.CreateCustomActionTypeInput{
		Category: aws.String("ActionCategory"), // Required
		InputArtifactDetails: &codepipeline.ArtifactDetails{ // Required
			MaximumCount: aws.Int64(1), // Required
			MinimumCount: aws.Int64(1), // Required
		},
		OutputArtifactDetails: &codepipeline.ArtifactDetails{ // Required
			MaximumCount: aws.Int64(1), // Required
			MinimumCount: aws.Int64(1), // Required
		},
		Provider: aws.String("ActionProvider"), // Required
		Version:  aws.String("Version"),        // Required
		ConfigurationProperties: []*codepipeline.ActionConfigurationProperty{
			{ // Required
				Key:         aws.Bool(true),                       // Required
				Name:        aws.String("ActionConfigurationKey"), // Required
				Required:    aws.Bool(true),                       // Required
				Secret:      aws.Bool(true),                       // Required
				Description: aws.String("Description"),
				Queryable:   aws.Bool(true),
				Type:        aws.String("ActionConfigurationPropertyType"),
			},
			// More values...
		},
		Settings: &codepipeline.ActionTypeSettings{
			EntityURLTemplate:          aws.String("UrlTemplate"),
			ExecutionURLTemplate:       aws.String("UrlTemplate"),
			RevisionURLTemplate:        aws.String("UrlTemplate"),
			ThirdPartyConfigurationURL: aws.String("Url"),
		},
	}
	resp, err := svc.CreateCustomActionType(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_CreatePipeline() {
	svc := codepipeline.New(nil)

	params := &codepipeline.CreatePipelineInput{
		Pipeline: &codepipeline.PipelineDeclaration{ // Required
			ArtifactStore: &codepipeline.ArtifactStore{ // Required
				Location: aws.String("ArtifactStoreLocation"), // Required
				Type:     aws.String("ArtifactStoreType"),     // Required
			},
			Name:    aws.String("PipelineName"), // Required
			RoleARN: aws.String("RoleArn"),      // Required
			Stages: []*codepipeline.StageDeclaration{ // Required
				{ // Required
					Actions: []*codepipeline.ActionDeclaration{ // Required
						{ // Required
							ActionTypeID: &codepipeline.ActionTypeID{ // Required
								Category: aws.String("ActionCategory"), // Required
								Owner:    aws.String("ActionOwner"),    // Required
								Provider: aws.String("ActionProvider"), // Required
								Version:  aws.String("Version"),        // Required
							},
							Name: aws.String("ActionName"), // Required
							Configuration: map[string]*string{
								"Key": aws.String("ActionConfigurationValue"), // Required
								// More values...
							},
							InputArtifacts: []*codepipeline.InputArtifact{
								{ // Required
									Name: aws.String("ArtifactName"), // Required
								},
								// More values...
							},
							OutputArtifacts: []*codepipeline.OutputArtifact{
								{ // Required
									Name: aws.String("ArtifactName"), // Required
								},
								// More values...
							},
							RoleARN:  aws.String("RoleArn"),
							RunOrder: aws.Int64(1),
						},
						// More values...
					},
					Name: aws.String("StageName"), // Required
					Blockers: []*codepipeline.BlockerDeclaration{
						{ // Required
							Name: aws.String("BlockerName"), // Required
							Type: aws.String("BlockerType"), // Required
						},
						// More values...
					},
				},
				// More values...
			},
			Version: aws.Int64(1),
		},
	}
	resp, err := svc.CreatePipeline(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_DeleteCustomActionType() {
	svc := codepipeline.New(nil)

	params := &codepipeline.DeleteCustomActionTypeInput{
		Category: aws.String("ActionCategory"), // Required
		Provider: aws.String("ActionProvider"), // Required
		Version:  aws.String("Version"),        // Required
	}
	resp, err := svc.DeleteCustomActionType(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_DeletePipeline() {
	svc := codepipeline.New(nil)

	params := &codepipeline.DeletePipelineInput{
		Name: aws.String("PipelineName"), // Required
	}
	resp, err := svc.DeletePipeline(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_DisableStageTransition() {
	svc := codepipeline.New(nil)

	params := &codepipeline.DisableStageTransitionInput{
		PipelineName:   aws.String("PipelineName"),        // Required
		Reason:         aws.String("DisabledReason"),      // Required
		StageName:      aws.String("StageName"),           // Required
		TransitionType: aws.String("StageTransitionType"), // Required
	}
	resp, err := svc.DisableStageTransition(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_EnableStageTransition() {
	svc := codepipeline.New(nil)

	params := &codepipeline.EnableStageTransitionInput{
		PipelineName:   aws.String("PipelineName"),        // Required
		StageName:      aws.String("StageName"),           // Required
		TransitionType: aws.String("StageTransitionType"), // Required
	}
	resp, err := svc.EnableStageTransition(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_GetJobDetails() {
	svc := codepipeline.New(nil)

	params := &codepipeline.GetJobDetailsInput{
		JobID: aws.String("JobId"), // Required
	}
	resp, err := svc.GetJobDetails(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_GetPipeline() {
	svc := codepipeline.New(nil)

	params := &codepipeline.GetPipelineInput{
		Name:    aws.String("PipelineName"), // Required
		Version: aws.Int64(1),
	}
	resp, err := svc.GetPipeline(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_GetPipelineState() {
	svc := codepipeline.New(nil)

	params := &codepipeline.GetPipelineStateInput{
		Name: aws.String("PipelineName"), // Required
	}
	resp, err := svc.GetPipelineState(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_GetThirdPartyJobDetails() {
	svc := codepipeline.New(nil)

	params := &codepipeline.GetThirdPartyJobDetailsInput{
		ClientToken: aws.String("ClientToken"),     // Required
		JobID:       aws.String("ThirdPartyJobId"), // Required
	}
	resp, err := svc.GetThirdPartyJobDetails(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_ListActionTypes() {
	svc := codepipeline.New(nil)

	params := &codepipeline.ListActionTypesInput{
		ActionOwnerFilter: aws.String("ActionOwner"),
		NextToken:         aws.String("NextToken"),
	}
	resp, err := svc.ListActionTypes(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_ListPipelines() {
	svc := codepipeline.New(nil)

	params := &codepipeline.ListPipelinesInput{
		NextToken: aws.String("NextToken"),
	}
	resp, err := svc.ListPipelines(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_PollForJobs() {
	svc := codepipeline.New(nil)

	params := &codepipeline.PollForJobsInput{
		ActionTypeID: &codepipeline.ActionTypeID{ // Required
			Category: aws.String("ActionCategory"), // Required
			Owner:    aws.String("ActionOwner"),    // Required
			Provider: aws.String("ActionProvider"), // Required
			Version:  aws.String("Version"),        // Required
		},
		MaxBatchSize: aws.Int64(1),
		QueryParam: map[string]*string{
			"Key": aws.String("ActionConfigurationQueryableValue"), // Required
			// More values...
		},
	}
	resp, err := svc.PollForJobs(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_PollForThirdPartyJobs() {
	svc := codepipeline.New(nil)

	params := &codepipeline.PollForThirdPartyJobsInput{
		ActionTypeID: &codepipeline.ActionTypeID{ // Required
			Category: aws.String("ActionCategory"), // Required
			Owner:    aws.String("ActionOwner"),    // Required
			Provider: aws.String("ActionProvider"), // Required
			Version:  aws.String("Version"),        // Required
		},
		MaxBatchSize: aws.Int64(1),
	}
	resp, err := svc.PollForThirdPartyJobs(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_PutActionRevision() {
	svc := codepipeline.New(nil)

	params := &codepipeline.PutActionRevisionInput{
		ActionName: aws.String("ActionName"), // Required
		ActionRevision: &codepipeline.ActionRevision{ // Required
			Created:          aws.Time(time.Now()),     // Required
			RevisionID:       aws.String("RevisionId"), // Required
			RevisionChangeID: aws.String("RevisionChangeId"),
		},
		PipelineName: aws.String("PipelineName"), // Required
		StageName:    aws.String("StageName"),    // Required
	}
	resp, err := svc.PutActionRevision(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_PutJobFailureResult() {
	svc := codepipeline.New(nil)

	params := &codepipeline.PutJobFailureResultInput{
		FailureDetails: &codepipeline.FailureDetails{ // Required
			Type:                aws.String("FailureType"), // Required
			ExternalExecutionID: aws.String("ExecutionId"),
			Message:             aws.String("Message"),
		},
		JobID: aws.String("JobId"), // Required
	}
	resp, err := svc.PutJobFailureResult(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_PutJobSuccessResult() {
	svc := codepipeline.New(nil)

	params := &codepipeline.PutJobSuccessResultInput{
		JobID:             aws.String("JobId"), // Required
		ContinuationToken: aws.String("ContinuationToken"),
		CurrentRevision: &codepipeline.CurrentRevision{
			ChangeIdentifier: aws.String("RevisionChangeIdentifier"), // Required
			Revision:         aws.String("Revision"),                 // Required
		},
		ExecutionDetails: &codepipeline.ExecutionDetails{
			ExternalExecutionID: aws.String("ExecutionId"),
			PercentComplete:     aws.Int64(1),
			Summary:             aws.String("ExecutionSummary"),
		},
	}
	resp, err := svc.PutJobSuccessResult(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_PutThirdPartyJobFailureResult() {
	svc := codepipeline.New(nil)

	params := &codepipeline.PutThirdPartyJobFailureResultInput{
		ClientToken: aws.String("ClientToken"), // Required
		FailureDetails: &codepipeline.FailureDetails{ // Required
			Type:                aws.String("FailureType"), // Required
			ExternalExecutionID: aws.String("ExecutionId"),
			Message:             aws.String("Message"),
		},
		JobID: aws.String("ThirdPartyJobId"), // Required
	}
	resp, err := svc.PutThirdPartyJobFailureResult(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_PutThirdPartyJobSuccessResult() {
	svc := codepipeline.New(nil)

	params := &codepipeline.PutThirdPartyJobSuccessResultInput{
		ClientToken:       aws.String("ClientToken"),     // Required
		JobID:             aws.String("ThirdPartyJobId"), // Required
		ContinuationToken: aws.String("ContinuationToken"),
		CurrentRevision: &codepipeline.CurrentRevision{
			ChangeIdentifier: aws.String("RevisionChangeIdentifier"), // Required
			Revision:         aws.String("Revision"),                 // Required
		},
		ExecutionDetails: &codepipeline.ExecutionDetails{
			ExternalExecutionID: aws.String("ExecutionId"),
			PercentComplete:     aws.Int64(1),
			Summary:             aws.String("ExecutionSummary"),
		},
	}
	resp, err := svc.PutThirdPartyJobSuccessResult(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_StartPipelineExecution() {
	svc := codepipeline.New(nil)

	params := &codepipeline.StartPipelineExecutionInput{
		Name: aws.String("PipelineName"), // Required
	}
	resp, err := svc.StartPipelineExecution(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}

func ExampleCodePipeline_UpdatePipeline() {
	svc := codepipeline.New(nil)

	params := &codepipeline.UpdatePipelineInput{
		Pipeline: &codepipeline.PipelineDeclaration{ // Required
			ArtifactStore: &codepipeline.ArtifactStore{ // Required
				Location: aws.String("ArtifactStoreLocation"), // Required
				Type:     aws.String("ArtifactStoreType"),     // Required
			},
			Name:    aws.String("PipelineName"), // Required
			RoleARN: aws.String("RoleArn"),      // Required
			Stages: []*codepipeline.StageDeclaration{ // Required
				{ // Required
					Actions: []*codepipeline.ActionDeclaration{ // Required
						{ // Required
							ActionTypeID: &codepipeline.ActionTypeID{ // Required
								Category: aws.String("ActionCategory"), // Required
								Owner:    aws.String("ActionOwner"),    // Required
								Provider: aws.String("ActionProvider"), // Required
								Version:  aws.String("Version"),        // Required
							},
							Name: aws.String("ActionName"), // Required
							Configuration: map[string]*string{
								"Key": aws.String("ActionConfigurationValue"), // Required
								// More values...
							},
							InputArtifacts: []*codepipeline.InputArtifact{
								{ // Required
									Name: aws.String("ArtifactName"), // Required
								},
								// More values...
							},
							OutputArtifacts: []*codepipeline.OutputArtifact{
								{ // Required
									Name: aws.String("ArtifactName"), // Required
								},
								// More values...
							},
							RoleARN:  aws.String("RoleArn"),
							RunOrder: aws.Int64(1),
						},
						// More values...
					},
					Name: aws.String("StageName"), // Required
					Blockers: []*codepipeline.BlockerDeclaration{
						{ // Required
							Name: aws.String("BlockerName"), // Required
							Type: aws.String("BlockerType"), // Required
						},
						// More values...
					},
				},
				// More values...
			},
			Version: aws.Int64(1),
		},
	}
	resp, err := svc.UpdatePipeline(params)

	if err != nil {
		if awsErr, ok := err.(awserr.Error); ok {
			// Generic AWS error with Code, Message, and original error (if any)
			fmt.Println(awsErr.Code(), awsErr.Message(), awsErr.OrigErr())
			if reqErr, ok := err.(awserr.RequestFailure); ok {
				// A service error occurred
				fmt.Println(reqErr.Code(), reqErr.Message(), reqErr.StatusCode(), reqErr.RequestID())
			}
		} else {
			// This case should never be hit, the SDK should always return an
			// error which satisfies the awserr.Error interface.
			fmt.Println(err.Error())
		}
	}

	// Pretty-print the response data.
	fmt.Println(awsutil.Prettify(resp))
}
