// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package dynamodbstreams provides a client for Amazon DynamoDB Streams.
package dynamodbstreams

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

const opDescribeStream = "DescribeStream"

// DescribeStreamRequest generates a request for the DescribeStream operation.
func (c *DynamoDBStreams) DescribeStreamRequest(input *DescribeStreamInput) (req *service.Request, output *DescribeStreamOutput) {
	op := &service.Operation{
		Name:       opDescribeStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStreamInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStreamOutput{}
	req.Data = output
	return
}

// Returns information about a stream, including the current status of the stream,
// its Amazon Resource Name (ARN), the composition of its shards, and its corresponding
// DynamoDB table.
//
// You can call DescribeStream at a maximum rate of 10 times per second.
//
// Each shard in the stream has a SequenceNumberRange associated with it. If
// the SequenceNumberRange has a StartingSequenceNumber but no EndingSequenceNumber,
// then the shard is still open (able to receive more stream records). If both
// StartingSequenceNumber and EndingSequenceNumber are present, the that shared
// is closed and can no longer receive more data.
func (c *DynamoDBStreams) DescribeStream(input *DescribeStreamInput) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	err := req.Send()
	return out, err
}

const opGetRecords = "GetRecords"

// GetRecordsRequest generates a request for the GetRecords operation.
func (c *DynamoDBStreams) GetRecordsRequest(input *GetRecordsInput) (req *service.Request, output *GetRecordsOutput) {
	op := &service.Operation{
		Name:       opGetRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRecordsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRecordsOutput{}
	req.Data = output
	return
}

// Retrieves the stream records from a given shard.
//
// Specify a shard iterator using the ShardIterator parameter. The shard iterator
// specifies the position in the shard from which you want to start reading
// stream records sequentially. If there are no stream records available in
// the portion of the shard that the iterator points to, GetRecords returns
// an empty list. Note that it might take multiple calls to get to a portion
// of the shard that contains stream records.
//
// GetRecords can retrieve a maximum of 1 MB of data or 2000 stream records,
// whichever comes first.
func (c *DynamoDBStreams) GetRecords(input *GetRecordsInput) (*GetRecordsOutput, error) {
	req, out := c.GetRecordsRequest(input)
	err := req.Send()
	return out, err
}

const opGetShardIterator = "GetShardIterator"

// GetShardIteratorRequest generates a request for the GetShardIterator operation.
func (c *DynamoDBStreams) GetShardIteratorRequest(input *GetShardIteratorInput) (req *service.Request, output *GetShardIteratorOutput) {
	op := &service.Operation{
		Name:       opGetShardIterator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetShardIteratorInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetShardIteratorOutput{}
	req.Data = output
	return
}

// Returns a shard iterator. A shard iterator provides information about how
// to retrieve the stream records from within a shard. Use the shard iterator
// in a subsequent GetRecords request to read the stream records from the shard.
//
// A shard iterator expires 15 minutes after it is returned to the requester.
func (c *DynamoDBStreams) GetShardIterator(input *GetShardIteratorInput) (*GetShardIteratorOutput, error) {
	req, out := c.GetShardIteratorRequest(input)
	err := req.Send()
	return out, err
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a request for the ListStreams operation.
func (c *DynamoDBStreams) ListStreamsRequest(input *ListStreamsInput) (req *service.Request, output *ListStreamsOutput) {
	op := &service.Operation{
		Name:       opListStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListStreamsOutput{}
	req.Data = output
	return
}

// Returns an array of stream ARNs associated with the current account and endpoint.
// If the TableName parameter is present, then ListStreams will return only
// the streams ARNs for that table.
//
// You can call ListStreams at a maximum rate of 5 times per second.
func (c *DynamoDBStreams) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	err := req.Send()
	return out, err
}

// Represents the input of a DescribeStream operation.
type DescribeStreamInput struct {
	// The shard ID of the first item that this operation will evaluate. Use the
	// value that was returned for LastEvaluatedShardId in the previous operation.
	ExclusiveStartShardID *string `locationName:"ExclusiveStartShardId" type:"string"`

	// The maximum number of shard objects to return. The upper limit is 100.
	Limit *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for the stream.
	StreamARN *string `locationName:"StreamArn" type:"string" required:"true"`

	metadataDescribeStreamInput `json:"-" xml:"-"`
}

type metadataDescribeStreamInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStreamInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeStream operation.
type DescribeStreamOutput struct {
	// A complete description of the stream, including its creation date and time,
	// the DynamoDB table associated with the stream, the shard IDs within the stream,
	// and the beginning and ending sequence numbers of stream records within the
	// shards.
	StreamDescription *StreamDescription `type:"structure"`

	metadataDescribeStreamOutput `json:"-" xml:"-"`
}

type metadataDescribeStreamOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStreamOutput) GoString() string {
	return s.String()
}

// Represents the input of a GetRecords operation.
type GetRecordsInput struct {
	// The maximum number of records to return from the shard. The upper limit is
	// 1000.
	Limit *int64 `type:"integer"`

	// A shard iterator that was retrieved from a previous GetShardIterator operation.
	// This iterator can be used to access the stream records in this shard.
	ShardIterator *string `type:"string" required:"true"`

	metadataGetRecordsInput `json:"-" xml:"-"`
}

type metadataGetRecordsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecordsInput) GoString() string {
	return s.String()
}

// Represents the output of a GetRecords operation.
type GetRecordsOutput struct {
	// The next position in the shard from which to start sequentially reading stream
	// records. If set to null, the shard has been closed and the requested iterator
	// will not return any more data.
	NextShardIterator *string `type:"string"`

	// The stream records from the shard, which were retrieved using the shard iterator.
	Records []*Record `type:"list"`

	metadataGetRecordsOutput `json:"-" xml:"-"`
}

type metadataGetRecordsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecordsOutput) GoString() string {
	return s.String()
}

// Represents the input of a GetShardIterator operation.
type GetShardIteratorInput struct {
	// The sequence number of a stream record in the shard from which to start reading.
	SequenceNumber *string `type:"string"`

	// The identifier of the shard. The iterator will be returned for this shard
	// ID.
	ShardID *string `locationName:"ShardId" type:"string" required:"true"`

	// Determines how the shard iterator is used to start reading stream records
	// from the shard:
	//
	//   AT_SEQUENCE_NUMBER - Start reading exactly from the position denoted by
	// a specific sequence number.
	//
	//   AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted
	// by a specific sequence number.
	//
	//   TRIM_HORIZON - Start reading at the last (untrimmed) stream record, which
	// is the oldest record in the shard. In DynamoDB Streams, there is a 24 hour
	// limit on data retention. Stream records whose age exceeds this limit are
	// subject to removal (trimming) from the stream.
	//
	//   LATEST - Start reading just after the most recent stream record in the
	// shard, so that you always read the most recent data in the shard.
	ShardIteratorType *string `type:"string" required:"true" enum:"ShardIteratorType"`

	// The Amazon Resource Name (ARN) for the stream.
	StreamARN *string `locationName:"StreamArn" type:"string" required:"true"`

	metadataGetShardIteratorInput `json:"-" xml:"-"`
}

type metadataGetShardIteratorInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetShardIteratorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetShardIteratorInput) GoString() string {
	return s.String()
}

// Represents the output of a GetShardIterator operation.
type GetShardIteratorOutput struct {
	// The position in the shard from which to start reading stream records sequentially.
	// A shard iterator specifies this position using the sequence number of a stream
	// record in a shard.
	ShardIterator *string `type:"string"`

	metadataGetShardIteratorOutput `json:"-" xml:"-"`
}

type metadataGetShardIteratorOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetShardIteratorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetShardIteratorOutput) GoString() string {
	return s.String()
}

// Represents the input of a ListStreams operation.
type ListStreamsInput struct {
	// The ARN (Amazon Resource Name) of the first item that this operation will
	// evaluate. Use the value that was returned for LastEvaluatedStreamArn in the
	// previous operation.
	ExclusiveStartStreamARN *string `locationName:"ExclusiveStartStreamArn" type:"string"`

	// The maximum number of streams to return. The upper limit is 100.
	Limit *int64 `type:"integer"`

	// If this parameter is provided, then only the streams associated with this
	// table name are returned.
	TableName *string `type:"string"`

	metadataListStreamsInput `json:"-" xml:"-"`
}

type metadataListStreamsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsInput) GoString() string {
	return s.String()
}

// Represents the output of a ListStreams operation.
type ListStreamsOutput struct {
	// The stream ARN of the item where the operation stopped, inclusive of the
	// previous result set. Use this value to start a new operation, excluding this
	// value in the new request.
	//
	// If LastEvaluatedStreamArn is empty, then the "last page" of results has
	// been processed and there is no more data to be retrieved.
	//
	// If LastEvaluatedStreamArn is not empty, it does not necessarily mean that
	// there is more data in the result set. The only way to know when you have
	// reached the end of the result set is when LastEvaluatedStreamArn is empty.
	LastEvaluatedStreamARN *string `locationName:"LastEvaluatedStreamArn" type:"string"`

	// A list of stream descriptors associated with the current account and endpoint.
	Streams []*Stream `type:"list"`

	metadataListStreamsOutput `json:"-" xml:"-"`
}

type metadataListStreamsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsOutput) GoString() string {
	return s.String()
}

// A description of a unique event within a stream.
type Record struct {
	// The region in which the GetRecords request was received.
	AWSRegion *string `locationName:"awsRegion" type:"string"`

	// The main body of the stream record, containing all of the DynamoDB-specific
	// fields.
	DynamoDB *StreamRecord `locationName:"dynamodb" type:"structure"`

	// A globally unique identifier for the event that was recorded in this stream
	// record.
	EventID *string `locationName:"eventID" type:"string"`

	// The type of data modification that was performed on the DynamoDB table:
	//
	//  INSERT - a new item was added to the table.
	//
	// MODIFY - one or more of the item's attributes were updated.
	//
	// REMOVE - the item was deleted from the table
	EventName *string `locationName:"eventName" type:"string" enum:"OperationType"`

	// The AWS service from which the stream record originated. For DynamoDB Streams,
	// this is aws:dynamodb.
	EventSource *string `locationName:"eventSource" type:"string"`

	// The version number of the stream record format. Currently, this is 1.0.
	EventVersion *string `locationName:"eventVersion" type:"string"`

	metadataRecord `json:"-" xml:"-"`
}

type metadataRecord struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Record) GoString() string {
	return s.String()
}

// The beginning and ending sequence numbers for the stream records contained
// within a shard.
type SequenceNumberRange struct {
	// The last sequence number.
	EndingSequenceNumber *string `type:"string"`

	// The first sequence number.
	StartingSequenceNumber *string `type:"string"`

	metadataSequenceNumberRange `json:"-" xml:"-"`
}

type metadataSequenceNumberRange struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SequenceNumberRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SequenceNumberRange) GoString() string {
	return s.String()
}

// A uniquely identified group of stream records within a stream.
type Shard struct {
	// The shard ID of the current shard's parent.
	ParentShardID *string `locationName:"ParentShardId" type:"string"`

	// The range of possible sequence numbers for the shard.
	SequenceNumberRange *SequenceNumberRange `type:"structure"`

	// The system-generated identifier for this shard.
	ShardID *string `locationName:"ShardId" type:"string"`

	metadataShard `json:"-" xml:"-"`
}

type metadataShard struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Shard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Shard) GoString() string {
	return s.String()
}

// Represents all of the data describing a particular stream.
type Stream struct {
	// The Amazon Resource Name (ARN) for the stream.
	StreamARN *string `locationName:"StreamArn" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//  the AWS customer ID.
	//
	// the table name
	//
	// the StreamLabel
	StreamLabel *string `type:"string"`

	// The DynamoDB table with which the stream is associated.
	TableName *string `type:"string"`

	metadataStream `json:"-" xml:"-"`
}

type metadataStream struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Stream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stream) GoString() string {
	return s.String()
}

// Represents all of the data describing a particular stream.
type StreamDescription struct {
	// The date and time when the request to create this stream was issued.
	CreationRequestDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The key attribute(s) of the stream's DynamoDB table.
	KeySchema []*dynamodb.KeySchemaElement `type:"list"`

	// The shard ID of the item where the operation stopped, inclusive of the previous
	// result set. Use this value to start a new operation, excluding this value
	// in the new request.
	//
	// If LastEvaluatedShardId is empty, then the "last page" of results has been
	// processed and there is currently no more data to be retrieved.
	//
	// If LastEvaluatedShardId is not empty, it does not necessarily mean that
	// there is more data in the result set. The only way to know when you have
	// reached the end of the result set is when LastEvaluatedShardId is empty.
	LastEvaluatedShardID *string `locationName:"LastEvaluatedShardId" type:"string"`

	// The shards that comprise the stream.
	Shards []*Shard `type:"list"`

	// The Amazon Resource Name (ARN) for the stream.
	StreamARN *string `locationName:"StreamArn" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//  the AWS customer ID.
	//
	// the table name
	//
	// the StreamLabel
	StreamLabel *string `type:"string"`

	// Indicates the current status of the stream:
	//
	//  ENABLING - Streams is currently being enabled on the DynamoDB table.
	//
	// ENABLING - the stream is enabled.
	//
	// DISABLING - Streams is currently being disabled on the DynamoDB table.
	//
	// DISABLED - the stream is disabled.
	StreamStatus *string `type:"string" enum:"StreamStatus"`

	// Indicates the format of the records within this stream:
	//
	//  KEYS_ONLY - only the key attributes of items that were modified in the
	// DynamoDB table.
	//
	// NEW_IMAGE - entire item from the table, as it appeared after they were modified.
	//
	// OLD_IMAGE - entire item from the table, as it appeared before they were
	// modified.
	//
	// NEW_AND_OLD_IMAGES - both the new and the old images of the items from the
	// table.
	StreamViewType *string `type:"string" enum:"StreamViewType"`

	// The DynamoDB table with which the stream is associated.
	TableName *string `type:"string"`

	metadataStreamDescription `json:"-" xml:"-"`
}

type metadataStreamDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StreamDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamDescription) GoString() string {
	return s.String()
}

// A description of a single data modification that was performed on an item
// in a DynamoDB table.
type StreamRecord struct {
	// The primary key attribute(s) for the DynamoDB item that was modified.
	Keys map[string]*dynamodb.AttributeValue `type:"map"`

	// The item in the DynamoDB table as it appeared after it was modified.
	NewImage map[string]*dynamodb.AttributeValue `type:"map"`

	// The item in the DynamoDB table as it appeared before it was modified.
	OldImage map[string]*dynamodb.AttributeValue `type:"map"`

	// The sequence number of the stream record.
	SequenceNumber *string `type:"string"`

	// The size of the stream record, in bytes.
	SizeBytes *int64 `type:"long"`

	// The type of data from the modified DynamoDB item that was captured in this
	// stream record:
	//
	//  KEYS_ONLY - only the key attributes of the modified item.
	//
	// NEW_IMAGE - the entire item, as it appears after it was modified.
	//
	// OLD_IMAGE - the entire item, as it appeared before it was modified.
	//
	// NEW_AND_OLD_IMAGES — both the new and the old item images of the item.
	StreamViewType *string `type:"string" enum:"StreamViewType"`

	metadataStreamRecord `json:"-" xml:"-"`
}

type metadataStreamRecord struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StreamRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamRecord) GoString() string {
	return s.String()
}

const (
	// @enum KeyType
	KeyTypeHash = "HASH"
	// @enum KeyType
	KeyTypeRange = "RANGE"
)

const (
	// @enum OperationType
	OperationTypeInsert = "INSERT"
	// @enum OperationType
	OperationTypeModify = "MODIFY"
	// @enum OperationType
	OperationTypeRemove = "REMOVE"
)

const (
	// @enum ShardIteratorType
	ShardIteratorTypeTrimHorizon = "TRIM_HORIZON"
	// @enum ShardIteratorType
	ShardIteratorTypeLatest = "LATEST"
	// @enum ShardIteratorType
	ShardIteratorTypeAtSequenceNumber = "AT_SEQUENCE_NUMBER"
	// @enum ShardIteratorType
	ShardIteratorTypeAfterSequenceNumber = "AFTER_SEQUENCE_NUMBER"
)

const (
	// @enum StreamStatus
	StreamStatusEnabling = "ENABLING"
	// @enum StreamStatus
	StreamStatusEnabled = "ENABLED"
	// @enum StreamStatus
	StreamStatusDisabling = "DISABLING"
	// @enum StreamStatus
	StreamStatusDisabled = "DISABLED"
)

const (
	// @enum StreamViewType
	StreamViewTypeNewImage = "NEW_IMAGE"
	// @enum StreamViewType
	StreamViewTypeOldImage = "OLD_IMAGE"
	// @enum StreamViewType
	StreamViewTypeNewAndOldImages = "NEW_AND_OLD_IMAGES"
	// @enum StreamViewType
	StreamViewTypeKeysOnly = "KEYS_ONLY"
)
