// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elasticache provides a client for Amazon ElastiCache.
package elasticache

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/service"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a request for the AddTagsToResource operation.
func (c *ElastiCache) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *service.Request, output *TagListMessage) {
	op := &service.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TagListMessage{}
	req.Data = output
	return
}

// The AddTagsToResource action adds up to 10 cost allocation tags to the named
// resource. A cost allocation tag is a key-value pair where the key and value
// are case-sensitive. Cost allocation tags can be used to categorize and track
// your AWS costs.
//
//  When you apply tags to your ElastiCache resources, AWS generates a cost
// allocation report as a comma-separated value (CSV) file with your usage and
// costs aggregated by your tags. You can apply tags that represent business
// categories (such as cost centers, application names, or owners) to organize
// your costs across multiple services. For more information, see Using Cost
// Allocation Tags in Amazon ElastiCache (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/Tagging.html).
func (c *ElastiCache) AddTagsToResource(input *AddTagsToResourceInput) (*TagListMessage, error) {
	req, out := c.AddTagsToResourceRequest(input)
	err := req.Send()
	return out, err
}

const opAuthorizeCacheSecurityGroupIngress = "AuthorizeCacheSecurityGroupIngress"

// AuthorizeCacheSecurityGroupIngressRequest generates a request for the AuthorizeCacheSecurityGroupIngress operation.
func (c *ElastiCache) AuthorizeCacheSecurityGroupIngressRequest(input *AuthorizeCacheSecurityGroupIngressInput) (req *service.Request, output *AuthorizeCacheSecurityGroupIngressOutput) {
	op := &service.Operation{
		Name:       opAuthorizeCacheSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeCacheSecurityGroupIngressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AuthorizeCacheSecurityGroupIngressOutput{}
	req.Data = output
	return
}

// The AuthorizeCacheSecurityGroupIngress action allows network ingress to a
// cache security group. Applications using ElastiCache must be running on Amazon
// EC2, and Amazon EC2 security groups are used as the authorization mechanism.
//
// You cannot authorize ingress from an Amazon EC2 security group in one region
// to an ElastiCache cluster in another region.
func (c *ElastiCache) AuthorizeCacheSecurityGroupIngress(input *AuthorizeCacheSecurityGroupIngressInput) (*AuthorizeCacheSecurityGroupIngressOutput, error) {
	req, out := c.AuthorizeCacheSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest generates a request for the CopySnapshot operation.
func (c *ElastiCache) CopySnapshotRequest(input *CopySnapshotInput) (req *service.Request, output *CopySnapshotOutput) {
	op := &service.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopySnapshotOutput{}
	req.Data = output
	return
}

// The CopySnapshot action makes a copy of an existing snapshot.
func (c *ElastiCache) CopySnapshot(input *CopySnapshotInput) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCacheCluster = "CreateCacheCluster"

// CreateCacheClusterRequest generates a request for the CreateCacheCluster operation.
func (c *ElastiCache) CreateCacheClusterRequest(input *CreateCacheClusterInput) (req *service.Request, output *CreateCacheClusterOutput) {
	op := &service.Operation{
		Name:       opCreateCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCacheClusterOutput{}
	req.Data = output
	return
}

// The CreateCacheCluster action creates a cache cluster. All nodes in the cache
// cluster run the same protocol-compliant cache engine software, either Memcached
// or Redis.
func (c *ElastiCache) CreateCacheCluster(input *CreateCacheClusterInput) (*CreateCacheClusterOutput, error) {
	req, out := c.CreateCacheClusterRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCacheParameterGroup = "CreateCacheParameterGroup"

// CreateCacheParameterGroupRequest generates a request for the CreateCacheParameterGroup operation.
func (c *ElastiCache) CreateCacheParameterGroupRequest(input *CreateCacheParameterGroupInput) (req *service.Request, output *CreateCacheParameterGroupOutput) {
	op := &service.Operation{
		Name:       opCreateCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCacheParameterGroupOutput{}
	req.Data = output
	return
}

// The CreateCacheParameterGroup action creates a new cache parameter group.
// A cache parameter group is a collection of parameters that you apply to all
// of the nodes in a cache cluster.
func (c *ElastiCache) CreateCacheParameterGroup(input *CreateCacheParameterGroupInput) (*CreateCacheParameterGroupOutput, error) {
	req, out := c.CreateCacheParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCacheSecurityGroup = "CreateCacheSecurityGroup"

// CreateCacheSecurityGroupRequest generates a request for the CreateCacheSecurityGroup operation.
func (c *ElastiCache) CreateCacheSecurityGroupRequest(input *CreateCacheSecurityGroupInput) (req *service.Request, output *CreateCacheSecurityGroupOutput) {
	op := &service.Operation{
		Name:       opCreateCacheSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheSecurityGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCacheSecurityGroupOutput{}
	req.Data = output
	return
}

// The CreateCacheSecurityGroup action creates a new cache security group. Use
// a cache security group to control access to one or more cache clusters.
//
// Cache security groups are only used when you are creating a cache cluster
// outside of an Amazon Virtual Private Cloud (VPC). If you are creating a cache
// cluster inside of a VPC, use a cache subnet group instead. For more information,
// see CreateCacheSubnetGroup (http://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
func (c *ElastiCache) CreateCacheSecurityGroup(input *CreateCacheSecurityGroupInput) (*CreateCacheSecurityGroupOutput, error) {
	req, out := c.CreateCacheSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCacheSubnetGroup = "CreateCacheSubnetGroup"

// CreateCacheSubnetGroupRequest generates a request for the CreateCacheSubnetGroup operation.
func (c *ElastiCache) CreateCacheSubnetGroupRequest(input *CreateCacheSubnetGroupInput) (req *service.Request, output *CreateCacheSubnetGroupOutput) {
	op := &service.Operation{
		Name:       opCreateCacheSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCacheSubnetGroupOutput{}
	req.Data = output
	return
}

// The CreateCacheSubnetGroup action creates a new cache subnet group.
//
// Use this parameter only when you are creating a cluster in an Amazon Virtual
// Private Cloud (VPC).
func (c *ElastiCache) CreateCacheSubnetGroup(input *CreateCacheSubnetGroupInput) (*CreateCacheSubnetGroupOutput, error) {
	req, out := c.CreateCacheSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReplicationGroup = "CreateReplicationGroup"

// CreateReplicationGroupRequest generates a request for the CreateReplicationGroup operation.
func (c *ElastiCache) CreateReplicationGroupRequest(input *CreateReplicationGroupInput) (req *service.Request, output *CreateReplicationGroupOutput) {
	op := &service.Operation{
		Name:       opCreateReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReplicationGroupOutput{}
	req.Data = output
	return
}

// The CreateReplicationGroup action creates a replication group. A replication
// group is a collection of cache clusters, where one of the cache clusters
// is a read/write primary and the others are read-only replicas. Writes to
// the primary are automatically propagated to the replicas.
//
// When you create a replication group, you must specify an existing cache
// cluster that is in the primary role. When the replication group has been
// successfully created, you can add one or more read replica replicas to it,
// up to a total of five read replicas.
//
// Note: This action is valid only for Redis.
func (c *ElastiCache) CreateReplicationGroup(input *CreateReplicationGroupInput) (*CreateReplicationGroupOutput, error) {
	req, out := c.CreateReplicationGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a request for the CreateSnapshot operation.
func (c *ElastiCache) CreateSnapshotRequest(input *CreateSnapshotInput) (req *service.Request, output *CreateSnapshotOutput) {
	op := &service.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSnapshotOutput{}
	req.Data = output
	return
}

// The CreateSnapshot action creates a copy of an entire cache cluster at a
// specific moment in time.
func (c *ElastiCache) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCacheCluster = "DeleteCacheCluster"

// DeleteCacheClusterRequest generates a request for the DeleteCacheCluster operation.
func (c *ElastiCache) DeleteCacheClusterRequest(input *DeleteCacheClusterInput) (req *service.Request, output *DeleteCacheClusterOutput) {
	op := &service.Operation{
		Name:       opDeleteCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteCacheClusterOutput{}
	req.Data = output
	return
}

// The DeleteCacheCluster action deletes a previously provisioned cache cluster.
// DeleteCacheCluster deletes all associated cache nodes, node endpoints and
// the cache cluster itself. When you receive a successful response from this
// action, Amazon ElastiCache immediately begins deleting the cache cluster;
// you cannot cancel or revert this action.
//
// This API cannot be used to delete a cache cluster that is the last read
// replica of a replication group that has Multi-AZ mode enabled.
func (c *ElastiCache) DeleteCacheCluster(input *DeleteCacheClusterInput) (*DeleteCacheClusterOutput, error) {
	req, out := c.DeleteCacheClusterRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCacheParameterGroup = "DeleteCacheParameterGroup"

// DeleteCacheParameterGroupRequest generates a request for the DeleteCacheParameterGroup operation.
func (c *ElastiCache) DeleteCacheParameterGroupRequest(input *DeleteCacheParameterGroupInput) (req *service.Request, output *DeleteCacheParameterGroupOutput) {
	op := &service.Operation{
		Name:       opDeleteCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteCacheParameterGroupOutput{}
	req.Data = output
	return
}

// The DeleteCacheParameterGroup action deletes the specified cache parameter
// group. You cannot delete a cache parameter group if it is associated with
// any cache clusters.
func (c *ElastiCache) DeleteCacheParameterGroup(input *DeleteCacheParameterGroupInput) (*DeleteCacheParameterGroupOutput, error) {
	req, out := c.DeleteCacheParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCacheSecurityGroup = "DeleteCacheSecurityGroup"

// DeleteCacheSecurityGroupRequest generates a request for the DeleteCacheSecurityGroup operation.
func (c *ElastiCache) DeleteCacheSecurityGroupRequest(input *DeleteCacheSecurityGroupInput) (req *service.Request, output *DeleteCacheSecurityGroupOutput) {
	op := &service.Operation{
		Name:       opDeleteCacheSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheSecurityGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteCacheSecurityGroupOutput{}
	req.Data = output
	return
}

// The DeleteCacheSecurityGroup action deletes a cache security group.
//
// You cannot delete a cache security group if it is associated with any cache
// clusters.
func (c *ElastiCache) DeleteCacheSecurityGroup(input *DeleteCacheSecurityGroupInput) (*DeleteCacheSecurityGroupOutput, error) {
	req, out := c.DeleteCacheSecurityGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCacheSubnetGroup = "DeleteCacheSubnetGroup"

// DeleteCacheSubnetGroupRequest generates a request for the DeleteCacheSubnetGroup operation.
func (c *ElastiCache) DeleteCacheSubnetGroupRequest(input *DeleteCacheSubnetGroupInput) (req *service.Request, output *DeleteCacheSubnetGroupOutput) {
	op := &service.Operation{
		Name:       opDeleteCacheSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteCacheSubnetGroupOutput{}
	req.Data = output
	return
}

// The DeleteCacheSubnetGroup action deletes a cache subnet group.
//
// You cannot delete a cache subnet group if it is associated with any cache
// clusters.
func (c *ElastiCache) DeleteCacheSubnetGroup(input *DeleteCacheSubnetGroupInput) (*DeleteCacheSubnetGroupOutput, error) {
	req, out := c.DeleteCacheSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReplicationGroup = "DeleteReplicationGroup"

// DeleteReplicationGroupRequest generates a request for the DeleteReplicationGroup operation.
func (c *ElastiCache) DeleteReplicationGroupRequest(input *DeleteReplicationGroupInput) (req *service.Request, output *DeleteReplicationGroupOutput) {
	op := &service.Operation{
		Name:       opDeleteReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReplicationGroupOutput{}
	req.Data = output
	return
}

// The DeleteReplicationGroup action deletes an existing replication group.
// By default, this action deletes the entire replication group, including the
// primary cluster and all of the read replicas. You can optionally delete only
// the read replicas, while retaining the primary cluster.
//
// When you receive a successful response from this action, Amazon ElastiCache
// immediately begins deleting the selected resources; you cannot cancel or
// revert this action.
func (c *ElastiCache) DeleteReplicationGroup(input *DeleteReplicationGroupInput) (*DeleteReplicationGroupOutput, error) {
	req, out := c.DeleteReplicationGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a request for the DeleteSnapshot operation.
func (c *ElastiCache) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *service.Request, output *DeleteSnapshotOutput) {
	op := &service.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSnapshotOutput{}
	req.Data = output
	return
}

// The DeleteSnapshot action deletes an existing snapshot. When you receive
// a successful response from this action, ElastiCache immediately begins deleting
// the snapshot; you cannot cancel or revert this action.
func (c *ElastiCache) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCacheClusters = "DescribeCacheClusters"

// DescribeCacheClustersRequest generates a request for the DescribeCacheClusters operation.
func (c *ElastiCache) DescribeCacheClustersRequest(input *DescribeCacheClustersInput) (req *service.Request, output *DescribeCacheClustersOutput) {
	op := &service.Operation{
		Name:       opDescribeCacheClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheClustersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCacheClustersOutput{}
	req.Data = output
	return
}

// The DescribeCacheClusters action returns information about all provisioned
// cache clusters if no cache cluster identifier is specified, or about a specific
// cache cluster if a cache cluster identifier is supplied.
//
// By default, abbreviated information about the cache clusters(s) will be
// returned. You can use the optional ShowDetails flag to retrieve detailed
// information about the cache nodes associated with the cache clusters. These
// details include the DNS address and port for the cache node endpoint.
//
// If the cluster is in the CREATING state, only cluster level information
// will be displayed until all of the nodes are successfully provisioned.
//
// If the cluster is in the DELETING state, only cluster level information
// will be displayed.
//
// If cache nodes are currently being added to the cache cluster, node endpoint
// information and creation time for the additional nodes will not be displayed
// until they are completely provisioned. When the cache cluster state is available,
// the cluster is ready for use.
//
// If cache nodes are currently being removed from the cache cluster, no endpoint
// information for the removed nodes is displayed.
func (c *ElastiCache) DescribeCacheClusters(input *DescribeCacheClustersInput) (*DescribeCacheClustersOutput, error) {
	req, out := c.DescribeCacheClustersRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeCacheClustersPages(input *DescribeCacheClustersInput, fn func(p *DescribeCacheClustersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCacheClustersRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCacheClustersOutput), lastPage)
	})
}

const opDescribeCacheEngineVersions = "DescribeCacheEngineVersions"

// DescribeCacheEngineVersionsRequest generates a request for the DescribeCacheEngineVersions operation.
func (c *ElastiCache) DescribeCacheEngineVersionsRequest(input *DescribeCacheEngineVersionsInput) (req *service.Request, output *DescribeCacheEngineVersionsOutput) {
	op := &service.Operation{
		Name:       opDescribeCacheEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheEngineVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCacheEngineVersionsOutput{}
	req.Data = output
	return
}

// The DescribeCacheEngineVersions action returns a list of the available cache
// engines and their versions.
func (c *ElastiCache) DescribeCacheEngineVersions(input *DescribeCacheEngineVersionsInput) (*DescribeCacheEngineVersionsOutput, error) {
	req, out := c.DescribeCacheEngineVersionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeCacheEngineVersionsPages(input *DescribeCacheEngineVersionsInput, fn func(p *DescribeCacheEngineVersionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCacheEngineVersionsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCacheEngineVersionsOutput), lastPage)
	})
}

const opDescribeCacheParameterGroups = "DescribeCacheParameterGroups"

// DescribeCacheParameterGroupsRequest generates a request for the DescribeCacheParameterGroups operation.
func (c *ElastiCache) DescribeCacheParameterGroupsRequest(input *DescribeCacheParameterGroupsInput) (req *service.Request, output *DescribeCacheParameterGroupsOutput) {
	op := &service.Operation{
		Name:       opDescribeCacheParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheParameterGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCacheParameterGroupsOutput{}
	req.Data = output
	return
}

// The DescribeCacheParameterGroups action returns a list of cache parameter
// group descriptions. If a cache parameter group name is specified, the list
// will contain only the descriptions for that group.
func (c *ElastiCache) DescribeCacheParameterGroups(input *DescribeCacheParameterGroupsInput) (*DescribeCacheParameterGroupsOutput, error) {
	req, out := c.DescribeCacheParameterGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeCacheParameterGroupsPages(input *DescribeCacheParameterGroupsInput, fn func(p *DescribeCacheParameterGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCacheParameterGroupsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCacheParameterGroupsOutput), lastPage)
	})
}

const opDescribeCacheParameters = "DescribeCacheParameters"

// DescribeCacheParametersRequest generates a request for the DescribeCacheParameters operation.
func (c *ElastiCache) DescribeCacheParametersRequest(input *DescribeCacheParametersInput) (req *service.Request, output *DescribeCacheParametersOutput) {
	op := &service.Operation{
		Name:       opDescribeCacheParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCacheParametersOutput{}
	req.Data = output
	return
}

// The DescribeCacheParameters action returns the detailed parameter list for
// a particular cache parameter group.
func (c *ElastiCache) DescribeCacheParameters(input *DescribeCacheParametersInput) (*DescribeCacheParametersOutput, error) {
	req, out := c.DescribeCacheParametersRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeCacheParametersPages(input *DescribeCacheParametersInput, fn func(p *DescribeCacheParametersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCacheParametersRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCacheParametersOutput), lastPage)
	})
}

const opDescribeCacheSecurityGroups = "DescribeCacheSecurityGroups"

// DescribeCacheSecurityGroupsRequest generates a request for the DescribeCacheSecurityGroups operation.
func (c *ElastiCache) DescribeCacheSecurityGroupsRequest(input *DescribeCacheSecurityGroupsInput) (req *service.Request, output *DescribeCacheSecurityGroupsOutput) {
	op := &service.Operation{
		Name:       opDescribeCacheSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheSecurityGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCacheSecurityGroupsOutput{}
	req.Data = output
	return
}

// The DescribeCacheSecurityGroups action returns a list of cache security group
// descriptions. If a cache security group name is specified, the list will
// contain only the description of that group.
func (c *ElastiCache) DescribeCacheSecurityGroups(input *DescribeCacheSecurityGroupsInput) (*DescribeCacheSecurityGroupsOutput, error) {
	req, out := c.DescribeCacheSecurityGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeCacheSecurityGroupsPages(input *DescribeCacheSecurityGroupsInput, fn func(p *DescribeCacheSecurityGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCacheSecurityGroupsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCacheSecurityGroupsOutput), lastPage)
	})
}

const opDescribeCacheSubnetGroups = "DescribeCacheSubnetGroups"

// DescribeCacheSubnetGroupsRequest generates a request for the DescribeCacheSubnetGroups operation.
func (c *ElastiCache) DescribeCacheSubnetGroupsRequest(input *DescribeCacheSubnetGroupsInput) (req *service.Request, output *DescribeCacheSubnetGroupsOutput) {
	op := &service.Operation{
		Name:       opDescribeCacheSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCacheSubnetGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCacheSubnetGroupsOutput{}
	req.Data = output
	return
}

// The DescribeCacheSubnetGroups action returns a list of cache subnet group
// descriptions. If a subnet group name is specified, the list will contain
// only the description of that group.
func (c *ElastiCache) DescribeCacheSubnetGroups(input *DescribeCacheSubnetGroupsInput) (*DescribeCacheSubnetGroupsOutput, error) {
	req, out := c.DescribeCacheSubnetGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeCacheSubnetGroupsPages(input *DescribeCacheSubnetGroupsInput, fn func(p *DescribeCacheSubnetGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCacheSubnetGroupsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCacheSubnetGroupsOutput), lastPage)
	})
}

const opDescribeEngineDefaultParameters = "DescribeEngineDefaultParameters"

// DescribeEngineDefaultParametersRequest generates a request for the DescribeEngineDefaultParameters operation.
func (c *ElastiCache) DescribeEngineDefaultParametersRequest(input *DescribeEngineDefaultParametersInput) (req *service.Request, output *DescribeEngineDefaultParametersOutput) {
	op := &service.Operation{
		Name:       opDescribeEngineDefaultParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"EngineDefaults.Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEngineDefaultParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEngineDefaultParametersOutput{}
	req.Data = output
	return
}

// The DescribeEngineDefaultParameters action returns the default engine and
// system parameter information for the specified cache engine.
func (c *ElastiCache) DescribeEngineDefaultParameters(input *DescribeEngineDefaultParametersInput) (*DescribeEngineDefaultParametersOutput, error) {
	req, out := c.DescribeEngineDefaultParametersRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeEngineDefaultParametersPages(input *DescribeEngineDefaultParametersInput, fn func(p *DescribeEngineDefaultParametersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEngineDefaultParametersRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEngineDefaultParametersOutput), lastPage)
	})
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a request for the DescribeEvents operation.
func (c *ElastiCache) DescribeEventsRequest(input *DescribeEventsInput) (req *service.Request, output *DescribeEventsOutput) {
	op := &service.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventsOutput{}
	req.Data = output
	return
}

// The DescribeEvents action returns events related to cache clusters, cache
// security groups, and cache parameter groups. You can obtain events specific
// to a particular cache cluster, cache security group, or cache parameter group
// by providing the name as a parameter.
//
// By default, only the events occurring within the last hour are returned;
// however, you can retrieve up to 14 days' worth of events if necessary.
func (c *ElastiCache) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeEventsPages(input *DescribeEventsInput, fn func(p *DescribeEventsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEventsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEventsOutput), lastPage)
	})
}

const opDescribeReplicationGroups = "DescribeReplicationGroups"

// DescribeReplicationGroupsRequest generates a request for the DescribeReplicationGroups operation.
func (c *ElastiCache) DescribeReplicationGroupsRequest(input *DescribeReplicationGroupsInput) (req *service.Request, output *DescribeReplicationGroupsOutput) {
	op := &service.Operation{
		Name:       opDescribeReplicationGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReplicationGroupsOutput{}
	req.Data = output
	return
}

// The DescribeReplicationGroups action returns information about a particular
// replication group. If no identifier is specified, DescribeReplicationGroups
// returns information about all replication groups.
func (c *ElastiCache) DescribeReplicationGroups(input *DescribeReplicationGroupsInput) (*DescribeReplicationGroupsOutput, error) {
	req, out := c.DescribeReplicationGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeReplicationGroupsPages(input *DescribeReplicationGroupsInput, fn func(p *DescribeReplicationGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReplicationGroupsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReplicationGroupsOutput), lastPage)
	})
}

const opDescribeReservedCacheNodes = "DescribeReservedCacheNodes"

// DescribeReservedCacheNodesRequest generates a request for the DescribeReservedCacheNodes operation.
func (c *ElastiCache) DescribeReservedCacheNodesRequest(input *DescribeReservedCacheNodesInput) (req *service.Request, output *DescribeReservedCacheNodesOutput) {
	op := &service.Operation{
		Name:       opDescribeReservedCacheNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedCacheNodesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedCacheNodesOutput{}
	req.Data = output
	return
}

// The DescribeReservedCacheNodes action returns information about reserved
// cache nodes for this account, or about a specified reserved cache node.
func (c *ElastiCache) DescribeReservedCacheNodes(input *DescribeReservedCacheNodesInput) (*DescribeReservedCacheNodesOutput, error) {
	req, out := c.DescribeReservedCacheNodesRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeReservedCacheNodesPages(input *DescribeReservedCacheNodesInput, fn func(p *DescribeReservedCacheNodesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedCacheNodesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedCacheNodesOutput), lastPage)
	})
}

const opDescribeReservedCacheNodesOfferings = "DescribeReservedCacheNodesOfferings"

// DescribeReservedCacheNodesOfferingsRequest generates a request for the DescribeReservedCacheNodesOfferings operation.
func (c *ElastiCache) DescribeReservedCacheNodesOfferingsRequest(input *DescribeReservedCacheNodesOfferingsInput) (req *service.Request, output *DescribeReservedCacheNodesOfferingsOutput) {
	op := &service.Operation{
		Name:       opDescribeReservedCacheNodesOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedCacheNodesOfferingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReservedCacheNodesOfferingsOutput{}
	req.Data = output
	return
}

// The DescribeReservedCacheNodesOfferings action lists available reserved cache
// node offerings.
func (c *ElastiCache) DescribeReservedCacheNodesOfferings(input *DescribeReservedCacheNodesOfferingsInput) (*DescribeReservedCacheNodesOfferingsOutput, error) {
	req, out := c.DescribeReservedCacheNodesOfferingsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeReservedCacheNodesOfferingsPages(input *DescribeReservedCacheNodesOfferingsInput, fn func(p *DescribeReservedCacheNodesOfferingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeReservedCacheNodesOfferingsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeReservedCacheNodesOfferingsOutput), lastPage)
	})
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a request for the DescribeSnapshots operation.
func (c *ElastiCache) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *service.Request, output *DescribeSnapshotsOutput) {
	op := &service.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSnapshotsOutput{}
	req.Data = output
	return
}

// The DescribeSnapshots action returns information about cache cluster snapshots.
// By default, DescribeSnapshots lists all of your snapshots; it can optionally
// describe a single snapshot, or just the snapshots associated with a particular
// cache cluster.
func (c *ElastiCache) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElastiCache) DescribeSnapshotsPages(input *DescribeSnapshotsInput, fn func(p *DescribeSnapshotsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeSnapshotsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeSnapshotsOutput), lastPage)
	})
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a request for the ListTagsForResource operation.
func (c *ElastiCache) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *service.Request, output *TagListMessage) {
	op := &service.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TagListMessage{}
	req.Data = output
	return
}

// The ListTagsForResource action lists all cost allocation tags currently on
// the named resource. A cost allocation tag is a key-value pair where the key
// is case-sensitive and the value is optional. Cost allocation tags can be
// used to categorize and track your AWS costs.
//
// You can have a maximum of 10 cost allocation tags on an ElastiCache resource.
// For more information, see Using Cost Allocation Tags in Amazon ElastiCache
// (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/BestPractices.html).
func (c *ElastiCache) ListTagsForResource(input *ListTagsForResourceInput) (*TagListMessage, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opModifyCacheCluster = "ModifyCacheCluster"

// ModifyCacheClusterRequest generates a request for the ModifyCacheCluster operation.
func (c *ElastiCache) ModifyCacheClusterRequest(input *ModifyCacheClusterInput) (req *service.Request, output *ModifyCacheClusterOutput) {
	op := &service.Operation{
		Name:       opModifyCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCacheClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyCacheClusterOutput{}
	req.Data = output
	return
}

// The ModifyCacheCluster action modifies the settings for a cache cluster.
// You can use this action to change one or more cluster configuration parameters
// by specifying the parameters and the new values.
func (c *ElastiCache) ModifyCacheCluster(input *ModifyCacheClusterInput) (*ModifyCacheClusterOutput, error) {
	req, out := c.ModifyCacheClusterRequest(input)
	err := req.Send()
	return out, err
}

const opModifyCacheParameterGroup = "ModifyCacheParameterGroup"

// ModifyCacheParameterGroupRequest generates a request for the ModifyCacheParameterGroup operation.
func (c *ElastiCache) ModifyCacheParameterGroupRequest(input *ModifyCacheParameterGroupInput) (req *service.Request, output *CacheParameterGroupNameMessage) {
	op := &service.Operation{
		Name:       opModifyCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCacheParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CacheParameterGroupNameMessage{}
	req.Data = output
	return
}

// The ModifyCacheParameterGroup action modifies the parameters of a cache parameter
// group. You can modify up to 20 parameters in a single request by submitting
// a list parameter name and value pairs.
func (c *ElastiCache) ModifyCacheParameterGroup(input *ModifyCacheParameterGroupInput) (*CacheParameterGroupNameMessage, error) {
	req, out := c.ModifyCacheParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyCacheSubnetGroup = "ModifyCacheSubnetGroup"

// ModifyCacheSubnetGroupRequest generates a request for the ModifyCacheSubnetGroup operation.
func (c *ElastiCache) ModifyCacheSubnetGroupRequest(input *ModifyCacheSubnetGroupInput) (req *service.Request, output *ModifyCacheSubnetGroupOutput) {
	op := &service.Operation{
		Name:       opModifyCacheSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCacheSubnetGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyCacheSubnetGroupOutput{}
	req.Data = output
	return
}

// The ModifyCacheSubnetGroup action modifies an existing cache subnet group.
func (c *ElastiCache) ModifyCacheSubnetGroup(input *ModifyCacheSubnetGroupInput) (*ModifyCacheSubnetGroupOutput, error) {
	req, out := c.ModifyCacheSubnetGroupRequest(input)
	err := req.Send()
	return out, err
}

const opModifyReplicationGroup = "ModifyReplicationGroup"

// ModifyReplicationGroupRequest generates a request for the ModifyReplicationGroup operation.
func (c *ElastiCache) ModifyReplicationGroupRequest(input *ModifyReplicationGroupInput) (req *service.Request, output *ModifyReplicationGroupOutput) {
	op := &service.Operation{
		Name:       opModifyReplicationGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyReplicationGroupOutput{}
	req.Data = output
	return
}

// The ModifyReplicationGroup action modifies the settings for a replication
// group.
func (c *ElastiCache) ModifyReplicationGroup(input *ModifyReplicationGroupInput) (*ModifyReplicationGroupOutput, error) {
	req, out := c.ModifyReplicationGroupRequest(input)
	err := req.Send()
	return out, err
}

const opPurchaseReservedCacheNodesOffering = "PurchaseReservedCacheNodesOffering"

// PurchaseReservedCacheNodesOfferingRequest generates a request for the PurchaseReservedCacheNodesOffering operation.
func (c *ElastiCache) PurchaseReservedCacheNodesOfferingRequest(input *PurchaseReservedCacheNodesOfferingInput) (req *service.Request, output *PurchaseReservedCacheNodesOfferingOutput) {
	op := &service.Operation{
		Name:       opPurchaseReservedCacheNodesOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseReservedCacheNodesOfferingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PurchaseReservedCacheNodesOfferingOutput{}
	req.Data = output
	return
}

// The PurchaseReservedCacheNodesOffering action allows you to purchase a reserved
// cache node offering.
func (c *ElastiCache) PurchaseReservedCacheNodesOffering(input *PurchaseReservedCacheNodesOfferingInput) (*PurchaseReservedCacheNodesOfferingOutput, error) {
	req, out := c.PurchaseReservedCacheNodesOfferingRequest(input)
	err := req.Send()
	return out, err
}

const opRebootCacheCluster = "RebootCacheCluster"

// RebootCacheClusterRequest generates a request for the RebootCacheCluster operation.
func (c *ElastiCache) RebootCacheClusterRequest(input *RebootCacheClusterInput) (req *service.Request, output *RebootCacheClusterOutput) {
	op := &service.Operation{
		Name:       opRebootCacheCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootCacheClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RebootCacheClusterOutput{}
	req.Data = output
	return
}

// The RebootCacheCluster action reboots some, or all, of the cache nodes within
// a provisioned cache cluster. This API will apply any modified cache parameter
// groups to the cache cluster. The reboot action takes place as soon as possible,
// and results in a momentary outage to the cache cluster. During the reboot,
// the cache cluster status is set to REBOOTING.
//
// The reboot causes the contents of the cache (for each cache node being rebooted)
// to be lost.
//
// When the reboot is complete, a cache cluster event is created.
func (c *ElastiCache) RebootCacheCluster(input *RebootCacheClusterInput) (*RebootCacheClusterOutput, error) {
	req, out := c.RebootCacheClusterRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a request for the RemoveTagsFromResource operation.
func (c *ElastiCache) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *service.Request, output *TagListMessage) {
	op := &service.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TagListMessage{}
	req.Data = output
	return
}

// The RemoveTagsFromResource action removes the tags identified by the TagKeys
// list from the named resource.
func (c *ElastiCache) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*TagListMessage, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	err := req.Send()
	return out, err
}

const opResetCacheParameterGroup = "ResetCacheParameterGroup"

// ResetCacheParameterGroupRequest generates a request for the ResetCacheParameterGroup operation.
func (c *ElastiCache) ResetCacheParameterGroupRequest(input *ResetCacheParameterGroupInput) (req *service.Request, output *CacheParameterGroupNameMessage) {
	op := &service.Operation{
		Name:       opResetCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetCacheParameterGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CacheParameterGroupNameMessage{}
	req.Data = output
	return
}

// The ResetCacheParameterGroup action modifies the parameters of a cache parameter
// group to the engine or system default value. You can reset specific parameters
// by submitting a list of parameter names. To reset the entire cache parameter
// group, specify the ResetAllParameters and CacheParameterGroupName parameters.
func (c *ElastiCache) ResetCacheParameterGroup(input *ResetCacheParameterGroupInput) (*CacheParameterGroupNameMessage, error) {
	req, out := c.ResetCacheParameterGroupRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeCacheSecurityGroupIngress = "RevokeCacheSecurityGroupIngress"

// RevokeCacheSecurityGroupIngressRequest generates a request for the RevokeCacheSecurityGroupIngress operation.
func (c *ElastiCache) RevokeCacheSecurityGroupIngressRequest(input *RevokeCacheSecurityGroupIngressInput) (req *service.Request, output *RevokeCacheSecurityGroupIngressOutput) {
	op := &service.Operation{
		Name:       opRevokeCacheSecurityGroupIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeCacheSecurityGroupIngressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RevokeCacheSecurityGroupIngressOutput{}
	req.Data = output
	return
}

// The RevokeCacheSecurityGroupIngress action revokes ingress from a cache security
// group. Use this action to disallow access from an Amazon EC2 security group
// that had been previously authorized.
func (c *ElastiCache) RevokeCacheSecurityGroupIngress(input *RevokeCacheSecurityGroupIngressInput) (*RevokeCacheSecurityGroupIngressOutput, error) {
	req, out := c.RevokeCacheSecurityGroupIngressRequest(input)
	err := req.Send()
	return out, err
}

// Represents the input of an AddTagsToResource action.
type AddTagsToResourceInput struct {
	// The name of the resource to which the tags are to be added, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster.
	ResourceName *string `type:"string" required:"true"`

	// A list of cost allocation tags to be added to this resource. A tag is a key-value
	// pair. A tag key must be accompanied by a tag value.
	Tags []*Tag `locationNameList:"Tag" type:"list" required:"true"`

	metadataAddTagsToResourceInput `json:"-" xml:"-"`
}

type metadataAddTagsToResourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Represents the input of an AuthorizeCacheSecurityGroupIngress action.
type AuthorizeCacheSecurityGroupIngressInput struct {
	// The cache security group which will allow network ingress.
	CacheSecurityGroupName *string `type:"string" required:"true"`

	// The Amazon EC2 security group to be authorized for ingress to the cache security
	// group.
	EC2SecurityGroupName *string `type:"string" required:"true"`

	// The AWS account number of the Amazon EC2 security group owner. Note that
	// this is not the same thing as an AWS access key ID - you must provide a valid
	// AWS account number for this parameter.
	EC2SecurityGroupOwnerID *string `locationName:"EC2SecurityGroupOwnerId" type:"string" required:"true"`

	metadataAuthorizeCacheSecurityGroupIngressInput `json:"-" xml:"-"`
}

type metadataAuthorizeCacheSecurityGroupIngressInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AuthorizeCacheSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeCacheSecurityGroupIngressInput) GoString() string {
	return s.String()
}

type AuthorizeCacheSecurityGroupIngressOutput struct {
	// Represents the output of one of the following actions:
	//
	//   AuthorizeCacheSecurityGroupIngress   CreateCacheSecurityGroup   RevokeCacheSecurityGroupIngress
	CacheSecurityGroup *CacheSecurityGroup `type:"structure"`

	metadataAuthorizeCacheSecurityGroupIngressOutput `json:"-" xml:"-"`
}

type metadataAuthorizeCacheSecurityGroupIngressOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AuthorizeCacheSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeCacheSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// Describes an Availability Zone in which the cache cluster is launched.
type AvailabilityZone struct {
	// The name of the Availability Zone.
	Name *string `type:"string"`

	metadataAvailabilityZone `json:"-" xml:"-"`
}

type metadataAvailabilityZone struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// Contains all of the attributes of a specific cache cluster.
type CacheCluster struct {
	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The date and time when the cache cluster was created.
	CacheClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The user-supplied identifier of the cache cluster. This identifier is a unique
	// key that identifies a cache cluster.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string"`

	// The current state of this cache cluster, one of the following values: available,
	// creating, deleted, deleting, incompatible-network, modifying, rebooting cache
	// cluster nodes, restore-failed, or snapshotting.
	CacheClusterStatus *string `type:"string"`

	// The name of the compute and memory capacity node type for the cache cluster.
	//
	// Valid node types are as follows:
	//
	//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
	// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
	// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
	// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
	// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
	// cache.m2.4xlarge   Notes:
	//
	//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
	// Redis backup/restore is not supported for t2 instances. Redis Append-only
	// files (AOF) functionality is not supported for t1 or t2 instances.  For a
	// complete listing of cache node types and specifications, see Amazon ElastiCache
	// Product Features and Details (http://aws.amazon.com/elasticache/details)
	// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
	// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
	CacheNodeType *string `type:"string"`

	// A list of cache nodes that are members of the cache cluster.
	CacheNodes []*CacheNode `locationNameList:"CacheNode" type:"list"`

	// The status of the cache parameter group.
	CacheParameterGroup *CacheParameterGroupStatus `type:"structure"`

	// A list of cache security group elements, composed of name and status sub-elements.
	CacheSecurityGroups []*CacheSecurityGroupMembership `locationNameList:"CacheSecurityGroup" type:"list"`

	// The name of the cache subnet group associated with the cache cluster.
	CacheSubnetGroupName *string `type:"string"`

	// The URL of the web page where you can download the latest ElastiCache client
	// library.
	ClientDownloadLandingPage *string `type:"string"`

	// Represents the information required for client programs to connect to a cache
	// node.
	ConfigurationEndpoint *Endpoint `type:"structure"`

	// The name of the cache engine (memcached or redis) to be used for this cache
	// cluster.
	Engine *string `type:"string"`

	// The version of the cache engine version that is used in this cache cluster.
	EngineVersion *string `type:"string"`

	// Describes a notification topic and its status. Notification topics are used
	// for publishing ElastiCache events to subscribers using Amazon Simple Notification
	// Service (SNS).
	NotificationConfiguration *NotificationConfiguration `type:"structure"`

	// The number of cache nodes in the cache cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`

	// A group of settings that will be applied to the cache cluster in the future,
	// or that are currently being applied.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// The name of the Availability Zone in which the cache cluster is located or
	// "Multiple" if the cache nodes are located in different Availability Zones.
	PreferredAvailabilityZone *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cache cluster
	// is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	//  sun mon tue wed thu fri sat  Example: sun:05:00-sun:09:00
	PreferredMaintenanceWindow *string `type:"string"`

	// The replication group to which this cache cluster belongs. If this field
	// is empty, the cache cluster is not associated with any replication group.
	ReplicationGroupID *string `locationName:"ReplicationGroupId" type:"string"`

	// A list of VPC Security Groups associated with the cache cluster.
	SecurityGroups []*SecurityGroupMembership `type:"list"`

	// The number of days for which ElastiCache will retain automatic cache cluster
	// snapshots before deleting them. For example, if you set SnapshotRetentionLimit
	// to 5, then a snapshot that was taken today will be retained for 5 days before
	// being deleted.
	//
	// ImportantIf the value of SnapshotRetentionLimit is set to zero (0), backups
	// are turned off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache will begin taking
	// a daily snapshot of your cache cluster.
	//
	// Example: 05:00-09:00
	SnapshotWindow *string `type:"string"`

	metadataCacheCluster `json:"-" xml:"-"`
}

type metadataCacheCluster struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheCluster) GoString() string {
	return s.String()
}

// Provides all of the details about a particular cache engine version.
type CacheEngineVersion struct {
	// The description of the cache engine.
	CacheEngineDescription *string `type:"string"`

	// The description of the cache engine version.
	CacheEngineVersionDescription *string `type:"string"`

	// The name of the cache parameter group family associated with this cache engine.
	CacheParameterGroupFamily *string `type:"string"`

	// The name of the cache engine.
	Engine *string `type:"string"`

	// The version number of the cache engine.
	EngineVersion *string `type:"string"`

	metadataCacheEngineVersion `json:"-" xml:"-"`
}

type metadataCacheEngineVersion struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheEngineVersion) GoString() string {
	return s.String()
}

// Represents an individual cache node within a cache cluster. Each cache node
// runs its own instance of the cluster's protocol-compliant caching software
// - either Memcached or Redis.
//
// Valid node types are as follows:
//
//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
// cache.m2.4xlarge   Notes:
//
//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
// Redis backup/restore is not supported for t2 instances. Redis Append-only
// files (AOF) functionality is not supported for t1 or t2 instances.  For a
// complete listing of cache node types and specifications, see Amazon ElastiCache
// Product Features and Details (http://aws.amazon.com/elasticache/details)
// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
type CacheNode struct {
	// The date and time when the cache node was created.
	CacheNodeCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The cache node identifier. A node ID is a numeric identifier (0001, 0002,
	// etc.). The combination of cluster ID and node ID uniquely identifies every
	// cache node used in a customer's AWS account.
	CacheNodeID *string `locationName:"CacheNodeId" type:"string"`

	// The current state of this cache node.
	CacheNodeStatus *string `type:"string"`

	// The Availability Zone where this node was created and now resides.
	CustomerAvailabilityZone *string `type:"string"`

	// The hostname for connecting to this cache node.
	Endpoint *Endpoint `type:"structure"`

	// The status of the parameter group applied to this cache node.
	ParameterGroupStatus *string `type:"string"`

	// The ID of the primary node to which this read replica node is synchronized.
	// If this field is empty, then this node is not associated with a primary cache
	// cluster.
	SourceCacheNodeID *string `locationName:"SourceCacheNodeId" type:"string"`

	metadataCacheNode `json:"-" xml:"-"`
}

type metadataCacheNode struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheNode) GoString() string {
	return s.String()
}

// A parameter that has a different value for each cache node type it is applied
// to. For example, in a Redis cache cluster, a cache.m1.large cache node type
// would have a larger maxmemory value than a cache.m1.small type.
type CacheNodeTypeSpecificParameter struct {
	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// A list of cache node types and their corresponding values for this parameter.
	CacheNodeTypeSpecificValues []*CacheNodeTypeSpecificValue `locationNameList:"CacheNodeTypeSpecificValue" type:"list"`

	// The valid data type for the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest cache engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The source of the parameter value.
	Source *string `type:"string"`

	metadataCacheNodeTypeSpecificParameter `json:"-" xml:"-"`
}

type metadataCacheNodeTypeSpecificParameter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheNodeTypeSpecificParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheNodeTypeSpecificParameter) GoString() string {
	return s.String()
}

// A value that applies only to a certain cache node type.
type CacheNodeTypeSpecificValue struct {
	// The cache node type for which this value applies.
	CacheNodeType *string `type:"string"`

	// The value for the cache node type.
	Value *string `type:"string"`

	metadataCacheNodeTypeSpecificValue `json:"-" xml:"-"`
}

type metadataCacheNodeTypeSpecificValue struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheNodeTypeSpecificValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheNodeTypeSpecificValue) GoString() string {
	return s.String()
}

// Represents the output of a CreateCacheParameterGroup action.
type CacheParameterGroup struct {
	// The name of the cache parameter group family that this cache parameter group
	// is compatible with.
	CacheParameterGroupFamily *string `type:"string"`

	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`

	// The description for this cache parameter group.
	Description *string `type:"string"`

	metadataCacheParameterGroup `json:"-" xml:"-"`
}

type metadataCacheParameterGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheParameterGroup) GoString() string {
	return s.String()
}

// Represents the output of one of the following actions:
//
//   ModifyCacheParameterGroup   ResetCacheParameterGroup
type CacheParameterGroupNameMessage struct {
	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`

	metadataCacheParameterGroupNameMessage `json:"-" xml:"-"`
}

type metadataCacheParameterGroupNameMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheParameterGroupNameMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheParameterGroupNameMessage) GoString() string {
	return s.String()
}

// The status of the cache parameter group.
type CacheParameterGroupStatus struct {
	// A list of the cache node IDs which need to be rebooted for parameter changes
	// to be applied. A node ID is a numeric identifier (0001, 0002, etc.).
	CacheNodeIDsToReboot []*string `locationName:"CacheNodeIdsToReboot" locationNameList:"CacheNodeId" type:"list"`

	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`

	metadataCacheParameterGroupStatus `json:"-" xml:"-"`
}

type metadataCacheParameterGroupStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheParameterGroupStatus) GoString() string {
	return s.String()
}

// Represents the output of one of the following actions:
//
//   AuthorizeCacheSecurityGroupIngress   CreateCacheSecurityGroup   RevokeCacheSecurityGroupIngress
type CacheSecurityGroup struct {
	// The name of the cache security group.
	CacheSecurityGroupName *string `type:"string"`

	// The description of the cache security group.
	Description *string `type:"string"`

	// A list of Amazon EC2 security groups that are associated with this cache
	// security group.
	EC2SecurityGroups []*EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// The AWS account ID of the cache security group owner.
	OwnerID *string `locationName:"OwnerId" type:"string"`

	metadataCacheSecurityGroup `json:"-" xml:"-"`
}

type metadataCacheSecurityGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheSecurityGroup) GoString() string {
	return s.String()
}

// Represents a cache cluster's status within a particular cache security group.
type CacheSecurityGroupMembership struct {
	// The name of the cache security group.
	CacheSecurityGroupName *string `type:"string"`

	// The membership status in the cache security group. The status changes when
	// a cache security group is modified, or when the cache security groups assigned
	// to a cache cluster are modified.
	Status *string `type:"string"`

	metadataCacheSecurityGroupMembership `json:"-" xml:"-"`
}

type metadataCacheSecurityGroupMembership struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheSecurityGroupMembership) GoString() string {
	return s.String()
}

// Represents the output of one of the following actions:
//
//   CreateCacheSubnetGroup   ModifyCacheSubnetGroup
type CacheSubnetGroup struct {
	// The description of the cache subnet group.
	CacheSubnetGroupDescription *string `type:"string"`

	// The name of the cache subnet group.
	CacheSubnetGroupName *string `type:"string"`

	// A list of subnets associated with the cache subnet group.
	Subnets []*Subnet `locationNameList:"Subnet" type:"list"`

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet
	// group.
	VPCID *string `locationName:"VpcId" type:"string"`

	metadataCacheSubnetGroup `json:"-" xml:"-"`
}

type metadataCacheSubnetGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CacheSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheSubnetGroup) GoString() string {
	return s.String()
}

// Represents the input of a CopySnapshotMessage action.
type CopySnapshotInput struct {
	// The name of an existing snapshot from which to copy.
	SourceSnapshotName *string `type:"string" required:"true"`

	// A name for the copied snapshot.
	TargetSnapshotName *string `type:"string" required:"true"`

	metadataCopySnapshotInput `json:"-" xml:"-"`
}

type metadataCopySnapshotInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CopySnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotInput) GoString() string {
	return s.String()
}

type CopySnapshotOutput struct {
	// Represents a copy of an entire cache cluster as of the time when the snapshot
	// was taken.
	Snapshot *Snapshot `type:"structure"`

	metadataCopySnapshotOutput `json:"-" xml:"-"`
}

type metadataCopySnapshotOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CopySnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopySnapshotOutput) GoString() string {
	return s.String()
}

// Represents the input of a CreateCacheCluster action.
type CreateCacheClusterInput struct {
	// Specifies whether the nodes in this Memcached node group are created in a
	// single Availability Zone or created across multiple Availability Zones in
	// the cluster's region.
	//
	// This parameter is only supported for Memcached cache clusters.
	//
	// If the AZMode and PreferredAvailabilityZones are not specified, ElastiCache
	// assumes single-az mode.
	AZMode *string `type:"string" enum:"AZMode"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The node group identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//  A name must contain from 1 to 20 alphanumeric characters or hyphens. The
	// first character must be a letter. A name cannot end with a hyphen or contain
	// two consecutive hyphens.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string" required:"true"`

	// The compute and memory capacity of the nodes in the node group.
	//
	// Valid node types are as follows:
	//
	//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
	// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
	// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
	// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
	// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
	// cache.m2.4xlarge   Notes:
	//
	//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
	// Redis backup/restore is not supported for t2 instances. Redis Append-only
	// files (AOF) functionality is not supported for t1 or t2 instances.  For a
	// complete listing of cache node types and specifications, see Amazon ElastiCache
	// Product Features and Details (http://aws.amazon.com/elasticache/details)
	// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
	// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
	CacheNodeType *string `type:"string"`

	// The name of the parameter group to associate with this cache cluster. If
	// this argument is omitted, the default parameter group for the specified engine
	// is used.
	CacheParameterGroupName *string `type:"string"`

	// A list of security group names to associate with this cache cluster.
	//
	// Use this parameter only when you are creating a cache cluster outside of
	// an Amazon Virtual Private Cloud (VPC).
	CacheSecurityGroupNames []*string `locationNameList:"CacheSecurityGroupName" type:"list"`

	// The name of the subnet group to be used for the cache cluster.
	//
	// Use this parameter only when you are creating a cache cluster in an Amazon
	// Virtual Private Cloud (VPC).
	CacheSubnetGroupName *string `type:"string"`

	// The name of the cache engine to be used for this cache cluster.
	//
	// Valid values for this parameter are:
	//
	// memcached | redis
	Engine *string `type:"string"`

	// The version number of the cache engine to be used for this cache cluster.
	// To view the supported cache engine versions, use the DescribeCacheEngineVersions
	// action.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic to which notifications will be sent.
	//
	// The Amazon SNS topic owner must be the same as the cache cluster owner.
	NotificationTopicARN *string `locationName:"NotificationTopicArn" type:"string"`

	// The initial number of cache nodes that the cache cluster will have.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	//
	// If you need more than 20 nodes for your Memcached cluster, please fill out
	// the ElastiCache Limit Increase Request form at http://aws.amazon.com/contact-us/elasticache-node-limit-request/
	// (http://aws.amazon.com/contact-us/elasticache-node-limit-request/).
	NumCacheNodes *int64 `type:"integer"`

	// The port number on which each of the cache nodes will accept connections.
	Port *int64 `type:"integer"`

	// The EC2 Availability Zone in which the cache cluster will be created.
	//
	// All nodes belonging to this Memcached cache cluster are placed in the preferred
	// Availability Zone. If you want to create your nodes across multiple Availability
	// Zones, use PreferredAvailabilityZones.
	//
	// Default: System chosen Availability Zone.
	PreferredAvailabilityZone *string `type:"string"`

	// A list of the Availability Zones in which cache nodes will be created. The
	// order of the zones in the list is not important.
	//
	// This option is only supported on Memcached.
	//
	//  If you are creating your cache cluster in an Amazon VPC (recommended) you
	// can only locate nodes in Availability Zones that are associated with the
	// subnets in the selected subnet group.
	//
	// The number of Availability Zones listed must equal the value of NumCacheNodes.
	//
	//  If you want all the nodes in the same Availability Zone, use PreferredAvailabilityZone
	// instead, or repeat the Availability Zone multiple times in the list.
	//
	// Default: System chosen Availability Zones.
	//
	// Example: One Memcached node in each of three different Availability Zones:
	// PreferredAvailabilityZones.member.1=us-west-2a&PreferredAvailabilityZones.member.2=us-west-2b&PreferredAvailabilityZones.member.3=us-west-2c
	//
	// Example: All three Memcached nodes in one Availability Zone: PreferredAvailabilityZones.member.1=us-west-2a&PreferredAvailabilityZones.member.2=us-west-2a&PreferredAvailabilityZones.member.3=us-west-2a
	PreferredAvailabilityZones []*string `locationNameList:"PreferredAvailabilityZone" type:"list"`

	// Specifies the weekly time range during which maintenance on the cache cluster
	// is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	//  sun mon tue wed thu fri sat  Example: sun:05:00-sun:09:00
	PreferredMaintenanceWindow *string `type:"string"`

	// The ID of the replication group to which this cache cluster should belong.
	// If this parameter is specified, the cache cluster will be added to the specified
	// replication group as a read replica; otherwise, the cache cluster will be
	// a standalone primary that is not part of any replication group.
	//
	// If the specified replication group is Multi-AZ enabled and the availability
	// zone is not specified, the cache cluster will be created in availability
	// zones that provide the best spread of read replicas across availability zones.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	ReplicationGroupID *string `locationName:"ReplicationGroupId" type:"string"`

	// One or more VPC security groups associated with the cache cluster.
	//
	// Use this parameter only when you are creating a cache cluster in an Amazon
	// Virtual Private Cloud (VPC).
	SecurityGroupIDs []*string `locationName:"SecurityGroupIds" locationNameList:"SecurityGroupId" type:"list"`

	// A single-element string list containing an Amazon Resource Name (ARN) that
	// uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot
	// file will be used to populate the node group. The Amazon S3 object name in
	// the ARN cannot contain any commas.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	//
	// Example of an Amazon S3 ARN: arn:aws:s3:::my_bucket/snapshot1.rdb
	SnapshotARNs []*string `locationName:"SnapshotArns" locationNameList:"SnapshotArn" type:"list"`

	// The name of a snapshot from which to restore data into the new node group.
	// The snapshot status changes to restoring while the new node group is being
	// created.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	SnapshotName *string `type:"string"`

	// The number of days for which ElastiCache will retain automatic snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5,
	// then a snapshot that was taken today will be retained for 5 days before being
	// deleted.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	//
	// Default: 0 (i.e., automatic backups are disabled for this cache cluster).
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache will begin taking
	// a daily snapshot of your node group.
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, then ElastiCache will automatically
	// choose an appropriate time range.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	SnapshotWindow *string `type:"string"`

	// A list of cost allocation tags to be added to this resource. A tag is a key-value
	// pair. A tag key must be accompanied by a tag value.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	metadataCreateCacheClusterInput `json:"-" xml:"-"`
}

type metadataCreateCacheClusterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheClusterInput) GoString() string {
	return s.String()
}

type CreateCacheClusterOutput struct {
	// Contains all of the attributes of a specific cache cluster.
	CacheCluster *CacheCluster `type:"structure"`

	metadataCreateCacheClusterOutput `json:"-" xml:"-"`
}

type metadataCreateCacheClusterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheClusterOutput) GoString() string {
	return s.String()
}

// Represents the input of a CreateCacheParameterGroup action.
type CreateCacheParameterGroupInput struct {
	// The name of the cache parameter group family the cache parameter group can
	// be used with.
	//
	// Valid values are: memcached1.4 | redis2.6 | redis2.8
	CacheParameterGroupFamily *string `type:"string" required:"true"`

	// A user-specified name for the cache parameter group.
	CacheParameterGroupName *string `type:"string" required:"true"`

	// A user-specified description for the cache parameter group.
	Description *string `type:"string" required:"true"`

	metadataCreateCacheParameterGroupInput `json:"-" xml:"-"`
}

type metadataCreateCacheParameterGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheParameterGroupInput) GoString() string {
	return s.String()
}

type CreateCacheParameterGroupOutput struct {
	// Represents the output of a CreateCacheParameterGroup action.
	CacheParameterGroup *CacheParameterGroup `type:"structure"`

	metadataCreateCacheParameterGroupOutput `json:"-" xml:"-"`
}

type metadataCreateCacheParameterGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCacheParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheParameterGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a CreateCacheSecurityGroup action.
type CreateCacheSecurityGroupInput struct {
	// A name for the cache security group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters. Cannot
	// be the word "Default".
	//
	// Example: mysecuritygroup
	CacheSecurityGroupName *string `type:"string" required:"true"`

	// A description for the cache security group.
	Description *string `type:"string" required:"true"`

	metadataCreateCacheSecurityGroupInput `json:"-" xml:"-"`
}

type metadataCreateCacheSecurityGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCacheSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheSecurityGroupInput) GoString() string {
	return s.String()
}

type CreateCacheSecurityGroupOutput struct {
	// Represents the output of one of the following actions:
	//
	//   AuthorizeCacheSecurityGroupIngress   CreateCacheSecurityGroup   RevokeCacheSecurityGroupIngress
	CacheSecurityGroup *CacheSecurityGroup `type:"structure"`

	metadataCreateCacheSecurityGroupOutput `json:"-" xml:"-"`
}

type metadataCreateCacheSecurityGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCacheSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheSecurityGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a CreateCacheSubnetGroup action.
type CreateCacheSubnetGroupInput struct {
	// A description for the cache subnet group.
	CacheSubnetGroupDescription *string `type:"string" required:"true"`

	// A name for the cache subnet group. This value is stored as a lowercase string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
	//
	// Example: mysubnetgroup
	CacheSubnetGroupName *string `type:"string" required:"true"`

	// A list of VPC subnet IDs for the cache subnet group.
	SubnetIDs []*string `locationName:"SubnetIds" locationNameList:"SubnetIdentifier" type:"list" required:"true"`

	metadataCreateCacheSubnetGroupInput `json:"-" xml:"-"`
}

type metadataCreateCacheSubnetGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCacheSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheSubnetGroupInput) GoString() string {
	return s.String()
}

type CreateCacheSubnetGroupOutput struct {
	// Represents the output of one of the following actions:
	//
	//   CreateCacheSubnetGroup   ModifyCacheSubnetGroup
	CacheSubnetGroup *CacheSubnetGroup `type:"structure"`

	metadataCreateCacheSubnetGroupOutput `json:"-" xml:"-"`
}

type metadataCreateCacheSubnetGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCacheSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCacheSubnetGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a CreateReplicationGroup action.
type CreateReplicationGroupInput struct {
	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies whether a read-only replica will be automatically promoted to read/write
	// primary if the existing primary fails.
	//
	// If true, Multi-AZ is enabled for this replication group. If false, Multi-AZ
	// is disabled for this replication group.
	//
	// Default: false
	//
	// ElastiCache Multi-AZ replication groups is not supported on:
	//
	//  Redis versions earlier than 2.8.6. T1 and T2 cache node types.
	AutomaticFailoverEnabled *bool `type:"boolean"`

	// The compute and memory capacity of the nodes in the node group.
	//
	// Valid node types are as follows:
	//
	//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
	// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
	// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
	// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
	// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
	// cache.m2.4xlarge   Notes:
	//
	//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
	// Redis backup/restore is not supported for t2 instances. Redis Append-only
	// files (AOF) functionality is not supported for t1 or t2 instances.  For a
	// complete listing of cache node types and specifications, see Amazon ElastiCache
	// Product Features and Details (http://aws.amazon.com/elasticache/details)
	// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
	// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
	CacheNodeType *string `type:"string"`

	// The name of the parameter group to associate with this replication group.
	// If this argument is omitted, the default cache parameter group for the specified
	// engine is used.
	CacheParameterGroupName *string `type:"string"`

	// A list of cache security group names to associate with this replication group.
	CacheSecurityGroupNames []*string `locationNameList:"CacheSecurityGroupName" type:"list"`

	// The name of the cache subnet group to be used for the replication group.
	CacheSubnetGroupName *string `type:"string"`

	// The name of the cache engine to be used for the cache clusters in this replication
	// group.
	//
	// Default: redis
	Engine *string `type:"string"`

	// The version number of the cache engine to be used for the cache clusters
	// in this replication group. To view the supported cache engine versions, use
	// the DescribeCacheEngineVersions action.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic to which notifications will be sent.
	//
	// The Amazon SNS topic owner must be the same as the cache cluster owner.
	NotificationTopicARN *string `locationName:"NotificationTopicArn" type:"string"`

	// The number of cache clusters this replication group will initially have.
	//
	// If Multi-AZ is enabled, the value of this parameter must be at least 2.
	//
	// The maximum permitted value for NumCacheClusters is 6 (primary plus 5 replicas).
	// If you need to exceed this limit, please fill out the ElastiCache Limit Increase
	// Request form at http://aws.amazon.com/contact-us/elasticache-node-limit-request
	// (http://aws.amazon.com/contact-us/elasticache-node-limit-request).
	NumCacheClusters *int64 `type:"integer"`

	// The port number on which each member of the replication group will accept
	// connections.
	Port *int64 `type:"integer"`

	// A list of EC2 availability zones in which the replication group's cache clusters
	// will be created. The order of the availability zones in the list is not important.
	//
	// If you are creating your replication group in an Amazon VPC (recommended),
	// you can only locate cache clusters in availability zones associated with
	// the subnets in the selected subnet group. The number of availability zones
	// listed must equal the value of NumCacheClusters.
	//
	// Default: system chosen availability zones.
	//
	// Example: One Redis cache cluster in each of three availability zones. PreferredAvailabilityZones.member.1=us-west-2a
	// PreferredAvailabilityZones.member.2=us-west-2c PreferredAvailabilityZones.member.3=us-west-2c
	PreferredCacheClusterAZs []*string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the weekly time range during which maintenance on the cache cluster
	// is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	//  sun mon tue wed thu fri sat  Example: sun:05:00-sun:09:00
	PreferredMaintenanceWindow *string `type:"string"`

	// The identifier of the cache cluster that will serve as the primary for this
	// replication group. This cache cluster must already exist and have a status
	// of available.
	//
	// This parameter is not required if NumCacheClusters is specified.
	PrimaryClusterID *string `locationName:"PrimaryClusterId" type:"string"`

	// A user-created description for the replication group.
	ReplicationGroupDescription *string `type:"string" required:"true"`

	// The replication group identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//  A name must contain from 1 to 20 alphanumeric characters or hyphens. The
	// first character must be a letter. A name cannot end with a hyphen or contain
	// two consecutive hyphens.
	ReplicationGroupID *string `locationName:"ReplicationGroupId" type:"string" required:"true"`

	// One or more Amazon VPC security groups associated with this replication group.
	//
	// Use this parameter only when you are creating a replication group in an
	// Amazon Virtual Private Cloud (VPC).
	SecurityGroupIDs []*string `locationName:"SecurityGroupIds" locationNameList:"SecurityGroupId" type:"list"`

	// A single-element string list containing an Amazon Resource Name (ARN) that
	// uniquely identifies a Redis RDB snapshot file stored in Amazon S3. The snapshot
	// file will be used to populate the node group. The Amazon S3 object name in
	// the ARN cannot contain any commas.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	//
	// Example of an Amazon S3 ARN: arn:aws:s3:::my_bucket/snapshot1.rdb
	SnapshotARNs []*string `locationName:"SnapshotArns" locationNameList:"SnapshotArn" type:"list"`

	// The name of a snapshot from which to restore data into the new node group.
	// The snapshot status changes to restoring while the new node group is being
	// created.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	SnapshotName *string `type:"string"`

	// The number of days for which ElastiCache will retain automatic snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5,
	// then a snapshot that was taken today will be retained for 5 days before being
	// deleted.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	//
	// Default: 0 (i.e., automatic backups are disabled for this cache cluster).
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache will begin taking
	// a daily snapshot of your node group.
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, then ElastiCache will automatically
	// choose an appropriate time range.
	//
	// Note: This parameter is only valid if the Engine parameter is redis.
	SnapshotWindow *string `type:"string"`

	// A list of cost allocation tags to be added to this resource. A tag is a key-value
	// pair. A tag key must be accompanied by a tag value.
	Tags []*Tag `locationNameList:"Tag" type:"list"`

	metadataCreateReplicationGroupInput `json:"-" xml:"-"`
}

type metadataCreateReplicationGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationGroupInput) GoString() string {
	return s.String()
}

type CreateReplicationGroupOutput struct {
	// Contains all of the attributes of a specific replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`

	metadataCreateReplicationGroupOutput `json:"-" xml:"-"`
}

type metadataCreateReplicationGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a CreateSnapshot action.
type CreateSnapshotInput struct {
	// The identifier of an existing cache cluster. The snapshot will be created
	// from this cache cluster.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string" required:"true"`

	// A name for the snapshot being created.
	SnapshotName *string `type:"string" required:"true"`

	metadataCreateSnapshotInput `json:"-" xml:"-"`
}

type metadataCreateSnapshotInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

type CreateSnapshotOutput struct {
	// Represents a copy of an entire cache cluster as of the time when the snapshot
	// was taken.
	Snapshot *Snapshot `type:"structure"`

	metadataCreateSnapshotOutput `json:"-" xml:"-"`
}

type metadataCreateSnapshotOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteCacheCluster action.
type DeleteCacheClusterInput struct {
	// The cache cluster identifier for the cluster to be deleted. This parameter
	// is not case sensitive.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string" required:"true"`

	// The user-supplied name of a final cache cluster snapshot. This is the unique
	// name that identifies the snapshot. ElastiCache creates the snapshot, and
	// then deletes the cache cluster immediately afterward.
	FinalSnapshotIdentifier *string `type:"string"`

	metadataDeleteCacheClusterInput `json:"-" xml:"-"`
}

type metadataDeleteCacheClusterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheClusterInput) GoString() string {
	return s.String()
}

type DeleteCacheClusterOutput struct {
	// Contains all of the attributes of a specific cache cluster.
	CacheCluster *CacheCluster `type:"structure"`

	metadataDeleteCacheClusterOutput `json:"-" xml:"-"`
}

type metadataDeleteCacheClusterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheClusterOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteCacheParameterGroup action.
type DeleteCacheParameterGroupInput struct {
	// The name of the cache parameter group to delete.
	//
	// The specified cache security group must not be associated with any cache
	// clusters.
	CacheParameterGroupName *string `type:"string" required:"true"`

	metadataDeleteCacheParameterGroupInput `json:"-" xml:"-"`
}

type metadataDeleteCacheParameterGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheParameterGroupInput) GoString() string {
	return s.String()
}

type DeleteCacheParameterGroupOutput struct {
	metadataDeleteCacheParameterGroupOutput `json:"-" xml:"-"`
}

type metadataDeleteCacheParameterGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheParameterGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteCacheSecurityGroup action.
type DeleteCacheSecurityGroupInput struct {
	// The name of the cache security group to delete.
	//
	// You cannot delete the default security group.
	CacheSecurityGroupName *string `type:"string" required:"true"`

	metadataDeleteCacheSecurityGroupInput `json:"-" xml:"-"`
}

type metadataDeleteCacheSecurityGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheSecurityGroupInput) GoString() string {
	return s.String()
}

type DeleteCacheSecurityGroupOutput struct {
	metadataDeleteCacheSecurityGroupOutput `json:"-" xml:"-"`
}

type metadataDeleteCacheSecurityGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheSecurityGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteCacheSubnetGroup action.
type DeleteCacheSubnetGroupInput struct {
	// The name of the cache subnet group to delete.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
	CacheSubnetGroupName *string `type:"string" required:"true"`

	metadataDeleteCacheSubnetGroupInput `json:"-" xml:"-"`
}

type metadataDeleteCacheSubnetGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheSubnetGroupInput) GoString() string {
	return s.String()
}

type DeleteCacheSubnetGroupOutput struct {
	metadataDeleteCacheSubnetGroupOutput `json:"-" xml:"-"`
}

type metadataDeleteCacheSubnetGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCacheSubnetGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteReplicationGroup action.
type DeleteReplicationGroupInput struct {
	// The name of a final node group snapshot. ElastiCache creates the snapshot
	// from the primary node in the cluster, rather than one of the replicas; this
	// is to ensure that it captures the freshest data. After the final snapshot
	// is taken, the cluster is immediately deleted.
	FinalSnapshotIdentifier *string `type:"string"`

	// The identifier for the cluster to be deleted. This parameter is not case
	// sensitive.
	ReplicationGroupID *string `locationName:"ReplicationGroupId" type:"string" required:"true"`

	// If set to true, all of the read replicas will be deleted, but the primary
	// node will be retained.
	RetainPrimaryCluster *bool `type:"boolean"`

	metadataDeleteReplicationGroupInput `json:"-" xml:"-"`
}

type metadataDeleteReplicationGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationGroupInput) GoString() string {
	return s.String()
}

type DeleteReplicationGroupOutput struct {
	// Contains all of the attributes of a specific replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`

	metadataDeleteReplicationGroupOutput `json:"-" xml:"-"`
}

type metadataDeleteReplicationGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteSnapshot action.
type DeleteSnapshotInput struct {
	// The name of the snapshot to be deleted.
	SnapshotName *string `type:"string" required:"true"`

	metadataDeleteSnapshotInput `json:"-" xml:"-"`
}

type metadataDeleteSnapshotInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

type DeleteSnapshotOutput struct {
	// Represents a copy of an entire cache cluster as of the time when the snapshot
	// was taken.
	Snapshot *Snapshot `type:"structure"`

	metadataDeleteSnapshotOutput `json:"-" xml:"-"`
}

type metadataDeleteSnapshotOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeCacheClusters action.
type DescribeCacheClustersInput struct {
	// The user-supplied cluster identifier. If this parameter is specified, only
	// information about that specific cache cluster is returned. This parameter
	// isn't case sensitive.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// An optional flag that can be included in the DescribeCacheCluster request
	// to retrieve information about the individual cache nodes.
	ShowCacheNodeInfo *bool `type:"boolean"`

	metadataDescribeCacheClustersInput `json:"-" xml:"-"`
}

type metadataDescribeCacheClustersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheClustersInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeCacheClusters action.
type DescribeCacheClustersOutput struct {
	// A list of cache clusters. Each item in the list contains detailed information
	// about one cache cluster.
	CacheClusters []*CacheCluster `locationNameList:"CacheCluster" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	metadataDescribeCacheClustersOutput `json:"-" xml:"-"`
}

type metadataDescribeCacheClustersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheClustersOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeCacheEngineVersions action.
type DescribeCacheEngineVersionsInput struct {
	// The name of a specific cache parameter group family to return details for.
	//
	// Constraints:
	//
	//  Must be 1 to 255 alphanumeric characters First character must be a letter
	// Cannot end with a hyphen or contain two consecutive hyphens
	CacheParameterGroupFamily *string `type:"string"`

	// If true, specifies that only the default version of the specified engine
	// or engine and major version combination is to be returned.
	DefaultOnly *bool `type:"boolean"`

	// The cache engine to return. Valid values: memcached | redis
	Engine *string `type:"string"`

	// The cache engine version to return.
	//
	// Example: 1.4.14
	EngineVersion *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	metadataDescribeCacheEngineVersionsInput `json:"-" xml:"-"`
}

type metadataDescribeCacheEngineVersionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheEngineVersionsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeCacheEngineVersions action.
type DescribeCacheEngineVersionsOutput struct {
	// A list of cache engine version details. Each element in the list contains
	// detailed information about one cache engine version.
	CacheEngineVersions []*CacheEngineVersion `locationNameList:"CacheEngineVersion" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	metadataDescribeCacheEngineVersionsOutput `json:"-" xml:"-"`
}

type metadataDescribeCacheEngineVersionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheEngineVersionsOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeCacheParameterGroups action.
type DescribeCacheParameterGroupsInput struct {
	// The name of a specific cache parameter group to return details for.
	CacheParameterGroupName *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	metadataDescribeCacheParameterGroupsInput `json:"-" xml:"-"`
}

type metadataDescribeCacheParameterGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheParameterGroupsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeCacheParameterGroups action.
type DescribeCacheParameterGroupsOutput struct {
	// A list of cache parameter groups. Each element in the list contains detailed
	// information about one cache parameter group.
	CacheParameterGroups []*CacheParameterGroup `locationNameList:"CacheParameterGroup" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	metadataDescribeCacheParameterGroupsOutput `json:"-" xml:"-"`
}

type metadataDescribeCacheParameterGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheParameterGroupsOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeCacheParameters action.
type DescribeCacheParametersInput struct {
	// The name of a specific cache parameter group to return details for.
	CacheParameterGroupName *string `type:"string" required:"true"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The parameter types to return.
	//
	// Valid values: user | system | engine-default
	Source *string `type:"string"`

	metadataDescribeCacheParametersInput `json:"-" xml:"-"`
}

type metadataDescribeCacheParametersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheParametersInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeCacheParameters action.
type DescribeCacheParametersOutput struct {
	// A list of parameters specific to a particular cache node type. Each element
	// in the list contains detailed information about one parameter.
	CacheNodeTypeSpecificParameters []*CacheNodeTypeSpecificParameter `locationNameList:"CacheNodeTypeSpecificParameter" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of Parameter instances.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	metadataDescribeCacheParametersOutput `json:"-" xml:"-"`
}

type metadataDescribeCacheParametersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheParametersOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeCacheSecurityGroups action.
type DescribeCacheSecurityGroupsInput struct {
	// The name of the cache security group to return details for.
	CacheSecurityGroupName *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	metadataDescribeCacheSecurityGroupsInput `json:"-" xml:"-"`
}

type metadataDescribeCacheSecurityGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheSecurityGroupsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeCacheSecurityGroups action.
type DescribeCacheSecurityGroupsOutput struct {
	// A list of cache security groups. Each element in the list contains detailed
	// information about one group.
	CacheSecurityGroups []*CacheSecurityGroup `locationNameList:"CacheSecurityGroup" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	metadataDescribeCacheSecurityGroupsOutput `json:"-" xml:"-"`
}

type metadataDescribeCacheSecurityGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheSecurityGroupsOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeCacheSubnetGroups action.
type DescribeCacheSubnetGroupsInput struct {
	// The name of the cache subnet group to return details for.
	CacheSubnetGroupName *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	metadataDescribeCacheSubnetGroupsInput `json:"-" xml:"-"`
}

type metadataDescribeCacheSubnetGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheSubnetGroupsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeCacheSubnetGroups action.
type DescribeCacheSubnetGroupsOutput struct {
	// A list of cache subnet groups. Each element in the list contains detailed
	// information about one group.
	CacheSubnetGroups []*CacheSubnetGroup `locationNameList:"CacheSubnetGroup" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	metadataDescribeCacheSubnetGroupsOutput `json:"-" xml:"-"`
}

type metadataDescribeCacheSubnetGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheSubnetGroupsOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeEngineDefaultParameters action.
type DescribeEngineDefaultParametersInput struct {
	// The name of the cache parameter group family. Valid values are: memcached1.4
	// | redis2.6 | redis2.8
	CacheParameterGroupFamily *string `type:"string" required:"true"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	metadataDescribeEngineDefaultParametersInput `json:"-" xml:"-"`
}

type metadataDescribeEngineDefaultParametersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersInput) GoString() string {
	return s.String()
}

type DescribeEngineDefaultParametersOutput struct {
	// Represents the output of a DescribeEngineDefaultParameters action.
	EngineDefaults *EngineDefaults `type:"structure"`

	metadataDescribeEngineDefaultParametersOutput `json:"-" xml:"-"`
}

type metadataDescribeEngineDefaultParametersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEngineDefaultParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEngineDefaultParametersOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeEvents action.
type DescribeEventsInput struct {
	// The number of minutes' worth of events to retrieve.
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of the event source for which events will be returned. If
	// not specified, then all sources are included in the response.
	SourceIdentifier *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	//
	// Valid values are: cache-cluster | cache-parameter-group | cache-security-group
	// | cache-subnet-group
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataDescribeEventsInput `json:"-" xml:"-"`
}

type metadataDescribeEventsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeEvents action.
type DescribeEventsOutput struct {
	// A list of events. Each element in the list contains detailed information
	// about one event.
	Events []*Event `locationNameList:"Event" type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	metadataDescribeEventsOutput `json:"-" xml:"-"`
}

type metadataDescribeEventsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeReplicationGroups action.
type DescribeReplicationGroupsInput struct {
	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier for the replication group to be described. This parameter
	// is not case sensitive.
	//
	// If you do not specify this parameter, information about all replication
	// groups is returned.
	ReplicationGroupID *string `locationName:"ReplicationGroupId" type:"string"`

	metadataDescribeReplicationGroupsInput `json:"-" xml:"-"`
}

type metadataDescribeReplicationGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReplicationGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationGroupsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeReplicationGroups action.
type DescribeReplicationGroupsOutput struct {
	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of replication groups. Each item in the list contains detailed information
	// about one replication group.
	ReplicationGroups []*ReplicationGroup `locationNameList:"ReplicationGroup" type:"list"`

	metadataDescribeReplicationGroupsOutput `json:"-" xml:"-"`
}

type metadataDescribeReplicationGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReplicationGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationGroupsOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeReservedCacheNodes action.
type DescribeReservedCacheNodesInput struct {
	// The cache node type filter value. Use this parameter to show only those reservations
	// matching the specified cache node type.
	//
	// Valid node types are as follows:
	//
	//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
	// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
	// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
	// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
	// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
	// cache.m2.4xlarge   Notes:
	//
	//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
	// Redis backup/restore is not supported for t2 instances. Redis Append-only
	// files (AOF) functionality is not supported for t1 or t2 instances.  For a
	// complete listing of cache node types and specifications, see Amazon ElastiCache
	// Product Features and Details (http://aws.amazon.com/elasticache/details)
	// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
	// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
	CacheNodeType *string `type:"string"`

	// The duration filter value, specified in years or seconds. Use this parameter
	// to show only reservations for this duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The offering type filter value. Use this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid values: "Light Utilization"|"Medium Utilization"|"Heavy Utilization"
	OfferingType *string `type:"string"`

	// The product description filter value. Use this parameter to show only those
	// reservations matching the specified product description.
	ProductDescription *string `type:"string"`

	// The reserved cache node identifier filter value. Use this parameter to show
	// only the reservation that matches the specified reservation ID.
	ReservedCacheNodeID *string `locationName:"ReservedCacheNodeId" type:"string"`

	// The offering identifier filter value. Use this parameter to show only purchased
	// reservations matching the specified offering identifier.
	ReservedCacheNodesOfferingID *string `locationName:"ReservedCacheNodesOfferingId" type:"string"`

	metadataDescribeReservedCacheNodesInput `json:"-" xml:"-"`
}

type metadataDescribeReservedCacheNodesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedCacheNodesInput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeReservedCacheNodesOfferings action.
type DescribeReservedCacheNodesOfferingsInput struct {
	// The cache node type filter value. Use this parameter to show only the available
	// offerings matching the specified cache node type.
	//
	// Valid node types are as follows:
	//
	//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
	// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
	// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
	// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
	// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
	// cache.m2.4xlarge   Notes:
	//
	//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
	// Redis backup/restore is not supported for t2 instances. Redis Append-only
	// files (AOF) functionality is not supported for t1 or t2 instances.  For a
	// complete listing of cache node types and specifications, see Amazon ElastiCache
	// Product Features and Details (http://aws.amazon.com/elasticache/details)
	// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
	// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
	CacheNodeType *string `type:"string"`

	// Duration filter value, specified in years or seconds. Use this parameter
	// to show only reservations for a given duration.
	//
	// Valid Values: 1 | 3 | 31536000 | 94608000
	Duration *string `type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: minimum 20; maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The offering type filter value. Use this parameter to show only the available
	// offerings matching the specified offering type.
	//
	// Valid Values: "Light Utilization"|"Medium Utilization"|"Heavy Utilization"
	OfferingType *string `type:"string"`

	// The product description filter value. Use this parameter to show only the
	// available offerings matching the specified product description.
	ProductDescription *string `type:"string"`

	// The offering identifier filter value. Use this parameter to show only the
	// available offering that matches the specified reservation identifier.
	//
	// Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
	ReservedCacheNodesOfferingID *string `locationName:"ReservedCacheNodesOfferingId" type:"string"`

	metadataDescribeReservedCacheNodesOfferingsInput `json:"-" xml:"-"`
}

type metadataDescribeReservedCacheNodesOfferingsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedCacheNodesOfferingsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeReservedCacheNodesOfferings action.
type DescribeReservedCacheNodesOfferingsOutput struct {
	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of reserved cache node offerings. Each element in the list contains
	// detailed information about one offering.
	ReservedCacheNodesOfferings []*ReservedCacheNodesOffering `locationNameList:"ReservedCacheNodesOffering" type:"list"`

	metadataDescribeReservedCacheNodesOfferingsOutput `json:"-" xml:"-"`
}

type metadataDescribeReservedCacheNodesOfferingsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedCacheNodesOfferingsOutput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeReservedCacheNodes action.
type DescribeReservedCacheNodesOutput struct {
	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// A list of reserved cache nodes. Each element in the list contains detailed
	// information about one node.
	ReservedCacheNodes []*ReservedCacheNode `locationNameList:"ReservedCacheNode" type:"list"`

	metadataDescribeReservedCacheNodesOutput `json:"-" xml:"-"`
}

type metadataDescribeReservedCacheNodesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReservedCacheNodesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReservedCacheNodesOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeSnapshotsMessage action.
type DescribeSnapshotsInput struct {
	// A user-supplied cluster identifier. If this parameter is specified, only
	// snapshots associated with that specific cache cluster will be described.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string"`

	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a marker is included in the response
	// so that the remaining results can be retrieved.
	//
	// Default: 50
	//
	// Constraints: minimum 20; maximum 50.
	MaxRecords *int64 `type:"integer"`

	// A user-supplied name of the snapshot. If this parameter is specified, only
	// this snapshot will be described.
	SnapshotName *string `type:"string"`

	// If set to system, the output shows snapshots that were automatically created
	// by ElastiCache. If set to user the output shows snapshots that were manually
	// created. If omitted, the output shows both automatically and manually created
	// snapshots.
	SnapshotSource *string `type:"string"`

	metadataDescribeSnapshotsInput `json:"-" xml:"-"`
}

type metadataDescribeSnapshotsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeSnapshots action.
type DescribeSnapshotsOutput struct {
	// An optional marker returned from a prior request. Use this marker for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only records beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A list of snapshots. Each item in the list contains detailed information
	// about one snapshot.
	Snapshots []*Snapshot `locationNameList:"Snapshot" type:"list"`

	metadataDescribeSnapshotsOutput `json:"-" xml:"-"`
}

type metadataDescribeSnapshotsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsOutput) GoString() string {
	return s.String()
}

// Provides ownership and status information for an Amazon EC2 security group.
type EC2SecurityGroup struct {
	// The name of the Amazon EC2 security group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account ID of the Amazon EC2 security group owner.
	EC2SecurityGroupOwnerID *string `locationName:"EC2SecurityGroupOwnerId" type:"string"`

	// The status of the Amazon EC2 security group.
	Status *string `type:"string"`

	metadataEC2SecurityGroup `json:"-" xml:"-"`
}

type metadataEC2SecurityGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2SecurityGroup) GoString() string {
	return s.String()
}

// Represents the information required for client programs to connect to a cache
// node.
type Endpoint struct {
	// The DNS hostname of the cache node.
	Address *string `type:"string"`

	// The port number that the cache engine is listening on.
	Port *int64 `type:"integer"`

	metadataEndpoint `json:"-" xml:"-"`
}

type metadataEndpoint struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// Represents the output of a DescribeEngineDefaultParameters action.
type EngineDefaults struct {
	// A list of parameters specific to a particular cache node type. Each element
	// in the list contains detailed information about one parameter.
	CacheNodeTypeSpecificParameters []*CacheNodeTypeSpecificParameter `locationNameList:"CacheNodeTypeSpecificParameter" type:"list"`

	// Specifies the name of the cache parameter group family to which the engine
	// default parameters apply.
	CacheParameterGroupFamily *string `type:"string"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// Contains a list of engine default parameters.
	Parameters []*Parameter `locationNameList:"Parameter" type:"list"`

	metadataEngineDefaults `json:"-" xml:"-"`
}

type metadataEngineDefaults struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineDefaults) GoString() string {
	return s.String()
}

// Represents a single occurrence of something interesting within the system.
// Some examples of events are creating a cache cluster, adding or removing
// a cache node, or rebooting a node.
type Event struct {
	// The date and time when the event occurred.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The text of the event.
	Message *string `type:"string"`

	// The identifier for the source of the event. For example, if the event occurred
	// at the cache cluster level, the identifier would be the name of the cache
	// cluster.
	SourceIdentifier *string `type:"string"`

	// Specifies the origin of this event - a cache cluster, a parameter group,
	// a security group, etc.
	SourceType *string `type:"string" enum:"SourceType"`

	metadataEvent `json:"-" xml:"-"`
}

type metadataEvent struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// The input parameters for the ListTagsForResource action.
type ListTagsForResourceInput struct {
	// The name of the resource for which you want the list of tags, for example
	// arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster.
	ResourceName *string `type:"string" required:"true"`

	metadataListTagsForResourceInput `json:"-" xml:"-"`
}

type metadataListTagsForResourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Represents the input of a ModifyCacheCluster action.
type ModifyCacheClusterInput struct {
	// Specifies whether the new nodes in this Memcached cache cluster are all created
	// in a single Availability Zone or created across multiple Availability Zones.
	//
	// Valid values: single-az | cross-az.
	//
	// This option is only supported for Memcached cache clusters.
	//
	// You cannot specify single-az if the Memcached cache cluster already has
	// cache nodes in different Availability Zones. If cross-az is specified, existing
	// Memcached nodes remain in their current Availability Zone.
	//
	// Only newly created nodes will be located in different Availability Zones.
	// For instructions on how to move existing Memcached nodes to different Availability
	// Zones, see the Availability Zone Considerations section of Cache Node Considerations
	// for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheNode.Memcached.html).
	AZMode *string `type:"string" enum:"AZMode"`

	// If true, this parameter causes the modifications in this request and any
	// pending modifications to be applied, asynchronously and as soon as possible,
	// regardless of the PreferredMaintenanceWindow setting for the cache cluster.
	//
	// If false, then changes to the cache cluster are applied on the next maintenance
	// reboot, or the next failure reboot, whichever occurs first.
	//
	// If you perform a ModifyCacheCluster before a pending modification is applied,
	// the pending modification is replaced by the newer modification. Valid values:
	// true | false
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The cache cluster identifier. This value is stored as a lowercase string.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string" required:"true"`

	// A list of cache node IDs to be removed. A node ID is a numeric identifier
	// (0001, 0002, etc.). This parameter is only valid when NumCacheNodes is less
	// than the existing number of cache nodes. The number of cache node IDs supplied
	// in this parameter must match the difference between the existing number of
	// cache nodes in the cluster or pending cache nodes, whichever is greater,
	// and the value of NumCacheNodes in the request.
	//
	// For example: If you have 3 active cache nodes, 7 pending cache nodes, and
	// the number of cache nodes in this ModifyCacheCluser call is 5, you must list
	// 2 (7 - 5) cache node IDs to remove.
	CacheNodeIDsToRemove []*string `locationName:"CacheNodeIdsToRemove" locationNameList:"CacheNodeId" type:"list"`

	// The name of the cache parameter group to apply to this cache cluster. This
	// change is asynchronously applied as soon as possible for parameters when
	// the ApplyImmediately parameter is specified as true for this request.
	CacheParameterGroupName *string `type:"string"`

	// A list of cache security group names to authorize on this cache cluster.
	// This change is asynchronously applied as soon as possible.
	//
	// This parameter can be used only with clusters that are created outside of
	// an Amazon Virtual Private Cloud (VPC).
	//
	// Constraints: Must contain no more than 255 alphanumeric characters. Must
	// not be "Default".
	CacheSecurityGroupNames []*string `locationNameList:"CacheSecurityGroupName" type:"list"`

	// The upgraded version of the cache engine to be run on the cache nodes.
	EngineVersion *string `type:"string"`

	// The list of Availability Zones where the new Memcached cache nodes will be
	// created.
	//
	// This parameter is only valid when NumCacheNodes in the request is greater
	// than the sum of the number of active cache nodes and the number of cache
	// nodes pending creation (which may be zero). The number of Availability Zones
	// supplied in this list must match the cache nodes being added in this request.
	//
	// This option is only supported on Memcached clusters.
	//
	// Scenarios:   Scenario 1: You have 3 active nodes and wish to add 2 nodes.
	// Specify NumCacheNodes=5 (3 + 2) and optionally specify two Availability Zones
	// for the two new nodes.  Scenario 2: You have 3 active nodes and 2 nodes pending
	// creation (from the scenario 1 call) and want to add 1 more node. Specify
	// NumCacheNodes=6 ((3 + 2) + 1) and optionally specify an Availability Zone
	// for the new node.  Scenario 3: You want to cancel all pending actions. Specify
	// NumCacheNodes=3 to cancel all pending actions.
	//
	// The Availability Zone placement of nodes pending creation cannot be modified.
	// If you wish to cancel any nodes pending creation, add 0 nodes by setting
	// NumCacheNodes to the number of current nodes.
	//
	// If cross-az is specified, existing Memcached nodes remain in their current
	// Availability Zone. Only newly created nodes can be located in different Availability
	// Zones. For guidance on how to move existing Memcached nodes to different
	// Availability Zones, see the Availability Zone Considerations section of Cache
	// Node Considerations for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheNode.Memcached.html).
	//
	// Impact of new add/remove requests upon pending requests
	//
	//   Scenarios Pending action New Request Results   Scenario-1 Delete Delete
	// The new delete, pending or immediate, replaces the pending delete.   Scenario-2
	// Delete Create The new create, pending or immediate, replaces the pending
	// delete.   Scenario-3 Create Delete The new delete, pending or immediate,
	// replaces the pending create.   Scenario-4 Create Create The new create is
	// added to the pending create. Important:If the new create request is Apply
	// Immediately - Yes, all creates are performed immediately. If the new create
	// request is Apply Immediately - No, all creates are pending.   Example: NewAvailabilityZones.member.1=us-west-2a&NewAvailabilityZones.member.2=us-west-2b&NewAvailabilityZones.member.3=us-west-2c
	NewAvailabilityZones []*string `locationNameList:"PreferredAvailabilityZone" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications
	// will be sent.
	//
	// The Amazon SNS topic owner must be same as the cache cluster owner.
	NotificationTopicARN *string `locationName:"NotificationTopicArn" type:"string"`

	// The status of the Amazon SNS notification topic. Notifications are sent only
	// if the status is active.
	//
	// Valid values: active | inactive
	NotificationTopicStatus *string `type:"string"`

	// The number of cache nodes that the cache cluster should have. If the value
	// for NumCacheNodes is greater than the sum of the number of current cache
	// nodes and the number of cache nodes pending creation (which may be zero),
	// then more nodes will be added. If the value is less than the number of existing
	// cache nodes, then nodes will be removed. If the value is equal to the number
	// of current cache nodes, then any pending add or remove requests are canceled.
	//
	// If you are removing cache nodes, you must use the CacheNodeIdsToRemove parameter
	// to provide the IDs of the specific cache nodes to remove.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	//
	// Note:Adding or removing Memcached cache nodes can be applied immediately
	// or as a pending action. See ApplyImmediately. A pending action to modify
	// the number of cache nodes in a cluster during its maintenance window, whether
	// by adding or removing nodes in accordance with the scale out architecture,
	// is not queued. The customer's latest request to add or remove nodes to the
	// cluster overrides any previous pending actions to modify the number of cache
	// nodes in the cluster. For example, a request to remove 2 nodes would override
	// a previous pending action to remove 3 nodes. Similarly, a request to add
	// 2 nodes would override a previous pending action to remove 3 nodes and vice
	// versa. As Memcached cache nodes may now be provisioned in different Availability
	// Zones with flexible cache node placement, a request to add nodes does not
	// automatically override a previous pending action to add nodes. The customer
	// can modify the previous pending action to add more nodes or explicitly cancel
	// the pending request and retry the new request. To cancel pending actions
	// to modify the number of cache nodes in a cluster, use the ModifyCacheCluster
	// request and set NumCacheNodes equal to the number of cache nodes currently
	// in the cache cluster.
	NumCacheNodes *int64 `type:"integer"`

	// Specifies the weekly time range during which maintenance on the cache cluster
	// is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	//  sun mon tue wed thu fri sat  Example: sun:05:00-sun:09:00
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the VPC Security Groups associated with the cache cluster.
	//
	// This parameter can be used only with clusters that are created in an Amazon
	// Virtual Private Cloud (VPC).
	SecurityGroupIDs []*string `locationName:"SecurityGroupIds" locationNameList:"SecurityGroupId" type:"list"`

	// The number of days for which ElastiCache will retain automatic cache cluster
	// snapshots before deleting them. For example, if you set SnapshotRetentionLimit
	// to 5, then a snapshot that was taken today will be retained for 5 days before
	// being deleted.
	//
	// ImportantIf the value of SnapshotRetentionLimit is set to zero (0), backups
	// are turned off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache will begin taking
	// a daily snapshot of your cache cluster.
	SnapshotWindow *string `type:"string"`

	metadataModifyCacheClusterInput `json:"-" xml:"-"`
}

type metadataModifyCacheClusterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheClusterInput) GoString() string {
	return s.String()
}

type ModifyCacheClusterOutput struct {
	// Contains all of the attributes of a specific cache cluster.
	CacheCluster *CacheCluster `type:"structure"`

	metadataModifyCacheClusterOutput `json:"-" xml:"-"`
}

type metadataModifyCacheClusterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheClusterOutput) GoString() string {
	return s.String()
}

// Represents the input of a ModifyCacheParameterGroup action.
type ModifyCacheParameterGroupInput struct {
	// The name of the cache parameter group to modify.
	CacheParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names and values for the parameter update. You must
	// supply at least one parameter name and value; subsequent arguments are optional.
	// A maximum of 20 parameters may be modified per request.
	ParameterNameValues []*ParameterNameValue `locationNameList:"ParameterNameValue" type:"list" required:"true"`

	metadataModifyCacheParameterGroupInput `json:"-" xml:"-"`
}

type metadataModifyCacheParameterGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheParameterGroupInput) GoString() string {
	return s.String()
}

// Represents the input of a ModifyCacheSubnetGroup action.
type ModifyCacheSubnetGroupInput struct {
	// A description for the cache subnet group.
	CacheSubnetGroupDescription *string `type:"string"`

	// The name for the cache subnet group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters or hyphens.
	//
	// Example: mysubnetgroup
	CacheSubnetGroupName *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the cache subnet group.
	SubnetIDs []*string `locationName:"SubnetIds" locationNameList:"SubnetIdentifier" type:"list"`

	metadataModifyCacheSubnetGroupInput `json:"-" xml:"-"`
}

type metadataModifyCacheSubnetGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyCacheSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheSubnetGroupInput) GoString() string {
	return s.String()
}

type ModifyCacheSubnetGroupOutput struct {
	// Represents the output of one of the following actions:
	//
	//   CreateCacheSubnetGroup   ModifyCacheSubnetGroup
	CacheSubnetGroup *CacheSubnetGroup `type:"structure"`

	metadataModifyCacheSubnetGroupOutput `json:"-" xml:"-"`
}

type metadataModifyCacheSubnetGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyCacheSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCacheSubnetGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a ModifyReplicationGroups action.
type ModifyReplicationGroupInput struct {
	// If true, this parameter causes the modifications in this request and any
	// pending modifications to be applied, asynchronously and as soon as possible,
	// regardless of the PreferredMaintenanceWindow setting for the replication
	// group.
	//
	// If false, then changes to the nodes in the replication group are applied
	// on the next maintenance reboot, or the next failure reboot, whichever occurs
	// first.
	//
	// Valid values: true | false
	//
	// Default: false
	ApplyImmediately *bool `type:"boolean"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Whether a read replica will be automatically promoted to read/write primary
	// if the existing primary encounters a failure.
	//
	// Valid values: true | false
	//
	// ElastiCache Multi-AZ replication groups are not supported on:
	//
	//  Redis versions earlier than 2.8.6. T1 and T2 cache node types.
	AutomaticFailoverEnabled *bool `type:"boolean"`

	// The name of the cache parameter group to apply to all of the clusters in
	// this replication group. This change is asynchronously applied as soon as
	// possible for parameters when the ApplyImmediately parameter is specified
	// as true for this request.
	CacheParameterGroupName *string `type:"string"`

	// A list of cache security group names to authorize for the clusters in this
	// replication group. This change is asynchronously applied as soon as possible.
	//
	// This parameter can be used only with replication group containing cache
	// clusters running outside of an Amazon Virtual Private Cloud (VPC).
	//
	// Constraints: Must contain no more than 255 alphanumeric characters. Must
	// not be "Default".
	CacheSecurityGroupNames []*string `locationNameList:"CacheSecurityGroupName" type:"list"`

	// The upgraded version of the cache engine to be run on the cache clusters
	// in the replication group.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications
	// will be sent.
	//
	// The Amazon SNS topic owner must be same as the replication group owner.
	NotificationTopicARN *string `locationName:"NotificationTopicArn" type:"string"`

	// The status of the Amazon SNS notification topic for the replication group.
	// Notifications are sent only if the status is active.
	//
	// Valid values: active | inactive
	NotificationTopicStatus *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cache cluster
	// is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	//  sun mon tue wed thu fri sat  Example: sun:05:00-sun:09:00
	PreferredMaintenanceWindow *string `type:"string"`

	// If this parameter is specified, ElastiCache will promote each of the cache
	// clusters in the specified replication group to the primary role. The nodes
	// of all other cache clusters in the replication group will be read replicas.
	PrimaryClusterID *string `locationName:"PrimaryClusterId" type:"string"`

	// A description for the replication group. Maximum length is 255 characters.
	ReplicationGroupDescription *string `type:"string"`

	// The identifier of the replication group to modify.
	ReplicationGroupID *string `locationName:"ReplicationGroupId" type:"string" required:"true"`

	// Specifies the VPC Security Groups associated with the cache clusters in the
	// replication group.
	//
	// This parameter can be used only with replication group containing cache
	// clusters running in an Amazon Virtual Private Cloud (VPC).
	SecurityGroupIDs []*string `locationName:"SecurityGroupIds" locationNameList:"SecurityGroupId" type:"list"`

	// The number of days for which ElastiCache will retain automatic node group
	// snapshots before deleting them. For example, if you set SnapshotRetentionLimit
	// to 5, then a snapshot that was taken today will be retained for 5 days before
	// being deleted.
	//
	// ImportantIf the value of SnapshotRetentionLimit is set to zero (0), backups
	// are turned off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache will begin taking
	// a daily snapshot of the node group specified by SnapshottingClusterId.
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, then ElastiCache will automatically
	// choose an appropriate time range.
	SnapshotWindow *string `type:"string"`

	// The cache cluster ID that will be used as the daily snapshot source for the
	// replication group.
	SnapshottingClusterID *string `locationName:"SnapshottingClusterId" type:"string"`

	metadataModifyReplicationGroupInput `json:"-" xml:"-"`
}

type metadataModifyReplicationGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationGroupInput) GoString() string {
	return s.String()
}

type ModifyReplicationGroupOutput struct {
	// Contains all of the attributes of a specific replication group.
	ReplicationGroup *ReplicationGroup `type:"structure"`

	metadataModifyReplicationGroupOutput `json:"-" xml:"-"`
}

type metadataModifyReplicationGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationGroupOutput) GoString() string {
	return s.String()
}

// Represents a collection of cache nodes in a replication group.
type NodeGroup struct {
	// The identifier for the node group. A replication group contains only one
	// node group; therefore, the node group ID is 0001.
	NodeGroupID *string `locationName:"NodeGroupId" type:"string"`

	// A list containing information about individual nodes within the node group.
	NodeGroupMembers []*NodeGroupMember `locationNameList:"NodeGroupMember" type:"list"`

	// Represents the information required for client programs to connect to a cache
	// node.
	PrimaryEndpoint *Endpoint `type:"structure"`

	// The current state of this replication group - creating, available, etc.
	Status *string `type:"string"`

	metadataNodeGroup `json:"-" xml:"-"`
}

type metadataNodeGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NodeGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeGroup) GoString() string {
	return s.String()
}

// Represents a single node within a node group.
type NodeGroupMember struct {
	// The ID of the cache cluster to which the node belongs.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string"`

	// The ID of the node within its cache cluster. A node ID is a numeric identifier
	// (0001, 0002, etc.).
	CacheNodeID *string `locationName:"CacheNodeId" type:"string"`

	// The role that is currently assigned to the node - primary or replica.
	CurrentRole *string `type:"string"`

	// The name of the Availability Zone in which the node is located.
	PreferredAvailabilityZone *string `type:"string"`

	// Represents the information required for client programs to connect to a cache
	// node.
	ReadEndpoint *Endpoint `type:"structure"`

	metadataNodeGroupMember `json:"-" xml:"-"`
}

type metadataNodeGroupMember struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NodeGroupMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeGroupMember) GoString() string {
	return s.String()
}

// Represents an individual cache node in a snapshot of a cache cluster.
type NodeSnapshot struct {
	// The date and time when the cache node was created in the source cache cluster.
	CacheNodeCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The cache node identifier for the node in the source cache cluster.
	CacheNodeID *string `locationName:"CacheNodeId" type:"string"`

	// The size of the cache on the source cache node.
	CacheSize *string `type:"string"`

	// The date and time when the source node's metadata and cache data set was
	// obtained for the snapshot.
	SnapshotCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataNodeSnapshot `json:"-" xml:"-"`
}

type metadataNodeSnapshot struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NodeSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeSnapshot) GoString() string {
	return s.String()
}

// Describes a notification topic and its status. Notification topics are used
// for publishing ElastiCache events to subscribers using Amazon Simple Notification
// Service (SNS).
type NotificationConfiguration struct {
	// The Amazon Resource Name (ARN) that identifies the topic.
	TopicARN *string `locationName:"TopicArn" type:"string"`

	// The current state of the topic.
	TopicStatus *string `type:"string"`

	metadataNotificationConfiguration `json:"-" xml:"-"`
}

type metadataNotificationConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// Describes an individual setting that controls some aspect of ElastiCache
// behavior.
type Parameter struct {
	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// The valid data type for the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest cache engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`

	// The source of the parameter.
	Source *string `type:"string"`

	metadataParameter `json:"-" xml:"-"`
}

type metadataParameter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// Describes a name-value pair that is used to update the value of a parameter.
type ParameterNameValue struct {
	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`

	metadataParameterNameValue `json:"-" xml:"-"`
}

type metadataParameterNameValue struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ParameterNameValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterNameValue) GoString() string {
	return s.String()
}

// A group of settings that will be applied to the cache cluster in the future,
// or that are currently being applied.
type PendingModifiedValues struct {
	// A list of cache node IDs that are being removed (or will be removed) from
	// the cache cluster. A node ID is a numeric identifier (0001, 0002, etc.).
	CacheNodeIDsToRemove []*string `locationName:"CacheNodeIdsToRemove" locationNameList:"CacheNodeId" type:"list"`

	// The new cache engine version that the cache cluster will run.
	EngineVersion *string `type:"string"`

	// The new number of cache nodes for the cache cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`

	metadataPendingModifiedValues `json:"-" xml:"-"`
}

type metadataPendingModifiedValues struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedValues) GoString() string {
	return s.String()
}

// Represents the input of a PurchaseReservedCacheNodesOffering action.
type PurchaseReservedCacheNodesOfferingInput struct {
	// The number of cache node instances to reserve.
	//
	// Default: 1
	CacheNodeCount *int64 `type:"integer"`

	// A customer-specified identifier to track this reservation.
	//
	// Example: myreservationID
	ReservedCacheNodeID *string `locationName:"ReservedCacheNodeId" type:"string"`

	// The ID of the reserved cache node offering to purchase.
	//
	// Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
	ReservedCacheNodesOfferingID *string `locationName:"ReservedCacheNodesOfferingId" type:"string" required:"true"`

	metadataPurchaseReservedCacheNodesOfferingInput `json:"-" xml:"-"`
}

type metadataPurchaseReservedCacheNodesOfferingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PurchaseReservedCacheNodesOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedCacheNodesOfferingInput) GoString() string {
	return s.String()
}

type PurchaseReservedCacheNodesOfferingOutput struct {
	// Represents the output of a PurchaseReservedCacheNodesOffering action.
	ReservedCacheNode *ReservedCacheNode `type:"structure"`

	metadataPurchaseReservedCacheNodesOfferingOutput `json:"-" xml:"-"`
}

type metadataPurchaseReservedCacheNodesOfferingOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PurchaseReservedCacheNodesOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseReservedCacheNodesOfferingOutput) GoString() string {
	return s.String()
}

// Represents the input of a RebootCacheCluster action.
type RebootCacheClusterInput struct {
	// The cache cluster identifier. This parameter is stored as a lowercase string.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string" required:"true"`

	// A list of cache node IDs to reboot. A node ID is a numeric identifier (0001,
	// 0002, etc.). To reboot an entire cache cluster, specify all of the cache
	// node IDs.
	CacheNodeIDsToReboot []*string `locationName:"CacheNodeIdsToReboot" locationNameList:"CacheNodeId" type:"list" required:"true"`

	metadataRebootCacheClusterInput `json:"-" xml:"-"`
}

type metadataRebootCacheClusterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RebootCacheClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootCacheClusterInput) GoString() string {
	return s.String()
}

type RebootCacheClusterOutput struct {
	// Contains all of the attributes of a specific cache cluster.
	CacheCluster *CacheCluster `type:"structure"`

	metadataRebootCacheClusterOutput `json:"-" xml:"-"`
}

type metadataRebootCacheClusterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RebootCacheClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootCacheClusterOutput) GoString() string {
	return s.String()
}

// Contains the specific price and frequency of a recurring charges for a reserved
// cache node, or for a reserved cache node offering.
type RecurringCharge struct {
	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`

	metadataRecurringCharge `json:"-" xml:"-"`
}

type metadataRecurringCharge struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// Represents the input of a RemoveTagsFromResource action.
type RemoveTagsFromResourceInput struct {
	// The name of the ElastiCache resource from which you want the listed tags
	// removed, for example arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster.
	ResourceName *string `type:"string" required:"true"`

	// A list of TagKeys identifying the tags you want removed from the named resource.
	// For example, TagKeys.member.1=Region removes the cost allocation tag with
	// the key name Region from the resource named by the ResourceName parameter.
	TagKeys []*string `type:"list" required:"true"`

	metadataRemoveTagsFromResourceInput `json:"-" xml:"-"`
}

type metadataRemoveTagsFromResourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Contains all of the attributes of a specific replication group.
type ReplicationGroup struct {
	// Indicates the status of Multi-AZ for this replication group.
	//
	// ElastiCache Multi-AZ replication groups are not supported on:
	//
	//  Redis versions earlier than 2.8.6. T1 and T2 cache node types.
	AutomaticFailover *string `type:"string" enum:"AutomaticFailoverStatus"`

	// The description of the replication group.
	Description *string `type:"string"`

	// The names of all the cache clusters that are part of this replication group.
	MemberClusters []*string `locationNameList:"ClusterId" type:"list"`

	// A single element list with information about the nodes in the replication
	// group.
	NodeGroups []*NodeGroup `locationNameList:"NodeGroup" type:"list"`

	// A group of settings to be applied to the replication group, either immediately
	// or during the next maintenance window.
	PendingModifiedValues *ReplicationGroupPendingModifiedValues `type:"structure"`

	// The identifier for the replication group.
	ReplicationGroupID *string `locationName:"ReplicationGroupId" type:"string"`

	// The cache cluster ID that is used as the daily snapshot source for the replication
	// group.
	SnapshottingClusterID *string `locationName:"SnapshottingClusterId" type:"string"`

	// The current state of this replication group - creating, available, etc.
	Status *string `type:"string"`

	metadataReplicationGroup `json:"-" xml:"-"`
}

type metadataReplicationGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReplicationGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationGroup) GoString() string {
	return s.String()
}

// The settings to be applied to the replication group, either immediately or
// during the next maintenance window.
type ReplicationGroupPendingModifiedValues struct {
	// Indicates the status of Multi-AZ for this replication group.
	//
	// ElastiCache Multi-AZ replication groups are not supported on:
	//
	//  Redis versions earlier than 2.8.6. T1 and T2 cache node types.
	AutomaticFailoverStatus *string `type:"string" enum:"PendingAutomaticFailoverStatus"`

	// The primary cluster ID which will be applied immediately (if --apply-immediately
	// was specified), or during the next maintenance window.
	PrimaryClusterID *string `locationName:"PrimaryClusterId" type:"string"`

	metadataReplicationGroupPendingModifiedValues `json:"-" xml:"-"`
}

type metadataReplicationGroupPendingModifiedValues struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReplicationGroupPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationGroupPendingModifiedValues) GoString() string {
	return s.String()
}

// Represents the output of a PurchaseReservedCacheNodesOffering action.
type ReservedCacheNode struct {
	// The number of cache nodes that have been reserved.
	CacheNodeCount *int64 `type:"integer"`

	// The cache node type for the reserved cache nodes.
	//
	// Valid node types are as follows:
	//
	//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
	// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
	// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
	// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
	// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
	// cache.m2.4xlarge   Notes:
	//
	//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
	// Redis backup/restore is not supported for t2 instances. Redis Append-only
	// files (AOF) functionality is not supported for t1 or t2 instances.  For a
	// complete listing of cache node types and specifications, see Amazon ElastiCache
	// Product Features and Details (http://aws.amazon.com/elasticache/details)
	// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
	// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
	CacheNodeType *string `type:"string"`

	// The duration of the reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this reserved cache node.
	FixedPrice *float64 `type:"double"`

	// The offering type of this reserved cache node.
	OfferingType *string `type:"string"`

	// The description of the reserved cache node.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved cache node.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The unique identifier for the reservation.
	ReservedCacheNodeID *string `locationName:"ReservedCacheNodeId" type:"string"`

	// The offering identifier.
	ReservedCacheNodesOfferingID *string `locationName:"ReservedCacheNodesOfferingId" type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the reserved cache node.
	State *string `type:"string"`

	// The hourly price charged for this reserved cache node.
	UsagePrice *float64 `type:"double"`

	metadataReservedCacheNode `json:"-" xml:"-"`
}

type metadataReservedCacheNode struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReservedCacheNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedCacheNode) GoString() string {
	return s.String()
}

// Describes all of the attributes of a reserved cache node offering.
type ReservedCacheNodesOffering struct {
	// The cache node type for the reserved cache node.
	//
	// Valid node types are as follows:
	//
	//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
	// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
	// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
	// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
	// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
	// cache.m2.4xlarge   Notes:
	//
	//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
	// Redis backup/restore is not supported for t2 instances. Redis Append-only
	// files (AOF) functionality is not supported for t1 or t2 instances.  For a
	// complete listing of cache node types and specifications, see Amazon ElastiCache
	// Product Features and Details (http://aws.amazon.com/elasticache/details)
	// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
	// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
	CacheNodeType *string `type:"string"`

	// The duration of the offering. in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this offering.
	FixedPrice *float64 `type:"double"`

	// The offering type.
	OfferingType *string `type:"string"`

	// The cache engine used by the offering.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved cache node.
	RecurringCharges []*RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// A unique identifier for the reserved cache node offering.
	ReservedCacheNodesOfferingID *string `locationName:"ReservedCacheNodesOfferingId" type:"string"`

	// The hourly price charged for this offering.
	UsagePrice *float64 `type:"double"`

	metadataReservedCacheNodesOffering `json:"-" xml:"-"`
}

type metadataReservedCacheNodesOffering struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReservedCacheNodesOffering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservedCacheNodesOffering) GoString() string {
	return s.String()
}

// Represents the input of a ResetCacheParameterGroup action.
type ResetCacheParameterGroupInput struct {
	// The name of the cache parameter group to reset.
	CacheParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names to be reset. If you are not resetting the entire
	// cache parameter group, you must specify at least one parameter name.
	ParameterNameValues []*ParameterNameValue `locationNameList:"ParameterNameValue" type:"list" required:"true"`

	// If true, all parameters in the cache parameter group will be reset to default
	// values. If false, no such action occurs.
	//
	// Valid values: true | false
	ResetAllParameters *bool `type:"boolean"`

	metadataResetCacheParameterGroupInput `json:"-" xml:"-"`
}

type metadataResetCacheParameterGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResetCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheParameterGroupInput) GoString() string {
	return s.String()
}

// Represents the input of a RevokeCacheSecurityGroupIngress action.
type RevokeCacheSecurityGroupIngressInput struct {
	// The name of the cache security group to revoke ingress from.
	CacheSecurityGroupName *string `type:"string" required:"true"`

	// The name of the Amazon EC2 security group to revoke access from.
	EC2SecurityGroupName *string `type:"string" required:"true"`

	// The AWS account number of the Amazon EC2 security group owner. Note that
	// this is not the same thing as an AWS access key ID - you must provide a valid
	// AWS account number for this parameter.
	EC2SecurityGroupOwnerID *string `locationName:"EC2SecurityGroupOwnerId" type:"string" required:"true"`

	metadataRevokeCacheSecurityGroupIngressInput `json:"-" xml:"-"`
}

type metadataRevokeCacheSecurityGroupIngressInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RevokeCacheSecurityGroupIngressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeCacheSecurityGroupIngressInput) GoString() string {
	return s.String()
}

type RevokeCacheSecurityGroupIngressOutput struct {
	// Represents the output of one of the following actions:
	//
	//   AuthorizeCacheSecurityGroupIngress   CreateCacheSecurityGroup   RevokeCacheSecurityGroupIngress
	CacheSecurityGroup *CacheSecurityGroup `type:"structure"`

	metadataRevokeCacheSecurityGroupIngressOutput `json:"-" xml:"-"`
}

type metadataRevokeCacheSecurityGroupIngressOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RevokeCacheSecurityGroupIngressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeCacheSecurityGroupIngressOutput) GoString() string {
	return s.String()
}

// Represents a single cache security group and its status.
type SecurityGroupMembership struct {
	// The identifier of the cache security group.
	SecurityGroupID *string `locationName:"SecurityGroupId" type:"string"`

	// The status of the cache security group membership. The status changes whenever
	// a cache security group is modified, or when the cache security groups assigned
	// to a cache cluster are modified.
	Status *string `type:"string"`

	metadataSecurityGroupMembership `json:"-" xml:"-"`
}

type metadataSecurityGroupMembership struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityGroupMembership) GoString() string {
	return s.String()
}

// Represents a copy of an entire cache cluster as of the time when the snapshot
// was taken.
type Snapshot struct {
	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The date and time when the source cache cluster was created.
	CacheClusterCreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The user-supplied identifier of the source cache cluster.
	CacheClusterID *string `locationName:"CacheClusterId" type:"string"`

	// The name of the compute and memory capacity node type for the source cache
	// cluster.
	//
	// Valid node types are as follows:
	//
	//  General purpose:  Current generation: cache.t2.micro, cache.t2.small, cache.t2.medium,
	// cache.m3.medium, cache.m3.large, cache.m3.xlarge, cache.m3.2xlarge Previous
	// generation: cache.t1.micro, cache.m1.small, cache.m1.medium, cache.m1.large,
	// cache.m1.xlarge  Compute optimized: cache.c1.xlarge Memory optimized  Current
	// generation: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	// cache.r3.8xlarge Previous generation: cache.m2.xlarge, cache.m2.2xlarge,
	// cache.m2.4xlarge   Notes:
	//
	//  All t2 instances are created in an Amazon Virtual Private Cloud (VPC).
	// Redis backup/restore is not supported for t2 instances. Redis Append-only
	// files (AOF) functionality is not supported for t1 or t2 instances.  For a
	// complete listing of cache node types and specifications, see Amazon ElastiCache
	// Product Features and Details (http://aws.amazon.com/elasticache/details)
	// and Cache Node Type-Specific Parameters for Memcached (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Memcached.html#CacheParameterGroups.Memcached.NodeSpecific)
	// or Cache Node Type-Specific Parameters for Redis (http://docs.aws.amazon.com/AmazonElastiCache/latest/UserGuide/CacheParameterGroups.Redis.html#CacheParameterGroups.Redis.NodeSpecific).
	CacheNodeType *string `type:"string"`

	// The cache parameter group that is associated with the source cache cluster.
	CacheParameterGroupName *string `type:"string"`

	// The name of the cache subnet group associated with the source cache cluster.
	CacheSubnetGroupName *string `type:"string"`

	// The name of the cache engine (memcached or redis) used by the source cache
	// cluster.
	Engine *string `type:"string"`

	// The version of the cache engine version that is used by the source cache
	// cluster.
	EngineVersion *string `type:"string"`

	// A list of the cache nodes in the source cache cluster.
	NodeSnapshots []*NodeSnapshot `locationNameList:"NodeSnapshot" type:"list"`

	// The number of cache nodes in the source cache cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`

	// The port number used by each cache nodes in the source cache cluster.
	Port *int64 `type:"integer"`

	// The name of the Availability Zone in which the source cache cluster is located.
	PreferredAvailabilityZone *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cache cluster
	// is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	//  sun mon tue wed thu fri sat  Example: sun:05:00-sun:09:00
	PreferredMaintenanceWindow *string `type:"string"`

	// The name of a snapshot. For an automatic snapshot, the name is system-generated;
	// for a manual snapshot, this is the user-provided name.
	SnapshotName *string `type:"string"`

	// For an automatic snapshot, the number of days for which ElastiCache will
	// retain the snapshot before deleting it.
	//
	// For manual snapshots, this field reflects the SnapshotRetentionLimit for
	// the source cache cluster when the snapshot was created. This field is otherwise
	// ignored: Manual snapshots do not expire, and can only be deleted using the
	// DeleteSnapshot action.
	//
	// ImportantIf the value of SnapshotRetentionLimit is set to zero (0), backups
	// are turned off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// Indicates whether the snapshot is from an automatic backup (automated) or
	// was created manually (manual).
	SnapshotSource *string `type:"string"`

	// The status of the snapshot. Valid values: creating | available | restoring
	// | copying | deleting.
	SnapshotStatus *string `type:"string"`

	// The daily time range during which ElastiCache takes daily snapshots of the
	// source cache cluster.
	SnapshotWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) for the topic used by the source cache cluster
	// for publishing notifications.
	TopicARN *string `locationName:"TopicArn" type:"string"`

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet
	// group for the source cache cluster.
	VPCID *string `locationName:"VpcId" type:"string"`

	metadataSnapshot `json:"-" xml:"-"`
}

type metadataSnapshot struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// Represents the subnet associated with a cache cluster. This parameter refers
// to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used
// with ElastiCache.
type Subnet struct {
	// The Availability Zone associated with the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The unique identifier for the subnet.
	SubnetIdentifier *string `type:"string"`

	metadataSubnet `json:"-" xml:"-"`
}

type metadataSubnet struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// A cost allocation Tag that can be added to an ElastiCache cluster or replication
// group. Tags are composed of a Key/Value pair. A tag with a null Value is
// permitted.
type Tag struct {
	// The key for the tag.
	Key *string `type:"string"`

	// The tag's value. May not be null.
	Value *string `type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Represents the output from the AddTagsToResource, ListTagsOnResource, and
// RemoveTagsFromResource actions.
type TagListMessage struct {
	// A list of cost allocation tags as key-value pairs.
	TagList []*Tag `locationNameList:"Tag" type:"list"`

	metadataTagListMessage `json:"-" xml:"-"`
}

type metadataTagListMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TagListMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagListMessage) GoString() string {
	return s.String()
}

const (
	// @enum AZMode
	AZModeSingleAz = "single-az"
	// @enum AZMode
	AZModeCrossAz = "cross-az"
)

const (
	// @enum AutomaticFailoverStatus
	AutomaticFailoverStatusEnabled = "enabled"
	// @enum AutomaticFailoverStatus
	AutomaticFailoverStatusDisabled = "disabled"
	// @enum AutomaticFailoverStatus
	AutomaticFailoverStatusEnabling = "enabling"
	// @enum AutomaticFailoverStatus
	AutomaticFailoverStatusDisabling = "disabling"
)

const (
	// @enum PendingAutomaticFailoverStatus
	PendingAutomaticFailoverStatusEnabled = "enabled"
	// @enum PendingAutomaticFailoverStatus
	PendingAutomaticFailoverStatusDisabled = "disabled"
)

const (
	// @enum SourceType
	SourceTypeCacheCluster = "cache-cluster"
	// @enum SourceType
	SourceTypeCacheParameterGroup = "cache-parameter-group"
	// @enum SourceType
	SourceTypeCacheSecurityGroup = "cache-security-group"
	// @enum SourceType
	SourceTypeCacheSubnetGroup = "cache-subnet-group"
)
